unit VFRead;
{$I option.pas}
interface
uses Dos, VFDcl, VFString;

var FlagProcessFile : boolean;

Function  FindFileLoc(ss : string; sExtDef : ExtStr) : string;
Procedure LogReadState;

Procedure StartRead(ss : string);
Procedure CloseRead;
Function  EndOfRead : boolean;
Function  ReturnRead (var IDent : string;
                      var NBuf : integer;
                      var Buf : BufRecord) : ReadState;
Procedure SkipOp(var RState : ReadState;
                 var Buf    : BufRecord);

Function  PackBuf(var NBuf : integer; var Buf : BufRecord) : string;
function  ConvFromByte(var sp : string; flempty : boolean) : byte;
function  ConvFromLongInt(var sp : string; flempty : boolean) : longint;
function  ConvFromReal(var sp : string; flempty : boolean) : float;
function  ConvFromString(var sp : string; flempty : boolean) : string;

function GetFullString(var NBuf : integer;
                    var Buf : BufRecord;
                    RS : ReadState) : string;
Function  NoCommRead (var IDent : string;
                      var NBuf : integer;
                      var Buf : BufRecord) : ReadState;

Procedure FileFix11  (ss : string);
Procedure FixBrace   (ss : string);
Procedure FixVarName (var ss : string);


implementation

{$I convfrom.pas}

const MaxFile = MaxLoadStruct;
type  RecordFile = record
                   fn : text;
                   inum : byte;
                   dummy : byte;
                   sbuf : string;
                   snam : string;
                   icount : longint;
                   end;

type  PFileType = array [1..MaxFile] of RecordFile;
const PFile     : ^ PFileType = nil;
const NFile : integer = 0;
const ExtFile : ExtStr = '';

type IfCaseType = (ifcasefalse, ifcasetrue,
                   ifcaseint0, ifcasestr0,
                   ifcaseint, ifcasestr);
     IfCaseRecord = record
                    ifvalue : IfCaseType;
                    dummy : byte;
                    case IfCaseType of
                    ifcasefalse,
                    ifcasetrue : ();
                    ifcaseint0,
                    ifcaseint  : (ifint : longint);
                    ifcasestr0,
                    ifcasestr  : (ifstr : svaltype);
                    end;
     IfStateRecord = record
                     iftrue : boolean;
                     ifelse : boolean;
                     end;

var IFCase   : array [1..MaxCaseStruct] of IfCaseRecord;
    IFState  : array [1..MaxCaseStruct] of IfStateRecord;
const NCase  : integer = 0;
      NCount : integer = 0;

function FindFileLoc(ss : string; sExtDef : ExtStr) : string;
var fn   : text;
    sh   : string;
    sres : string;
    sDir : DirStr;
    sNam : NameStr;
    sExt : ExtStr;
    i    : integer;
    fl   : boolean;
begin

    ExtFile:=sExtDef;

    FileSplit(ss,sDir,sNam,sExt);
    if sExt = '' then sExt:=sExtDef;
    sh:=sNam+sExt;

    {---- Where to find file -----}
    sres:=PathConcat(sDir,sh);
    assign(fn,sres);
    {$I-} reset(fn); {$I+}
    if IOResult = 0 then
    begin
         close(fn);
         sh:=sres;
    end
    else begin
         fl:=true;
         if sDir = '' then
         begin
              i:=1;
              while (fl) and (i <= NDirectory) do
              begin
                   sres:=PathConcat(DefDirectory[i],sh);
                   assign(fn,sres);
                   {$I-} reset(fn); {$I+}
                   if IOResult = 0 then
                   begin
                        close(fn);
                        sh:=sres;
                        fl:=false;
                   end
                   else i:=i+1;
              end;
         end;
         if fl then
         begin
              sh:='';
         end;
    end;

    FindFileLoc:=sh;

end; {FindFileLoc}


Function  PackBuf(var NBuf : integer; var Buf : BufRecord) : string;
var s : string;
    i, ind : integer;
begin

    ind:=NBuf;
    if ind > 255 then ind:=155;

    for i:=1 to ind do s[i]:=Buf[i];
    s[0]:=char(ind);

    PackBuf:=DelSpaces(s);

end; {PackBuf}


Procedure StartRead(ss : string);
var sh : string;
    i  : integer;
begin

     if (PFile = nil) then new(PFile);

     if NFile >= MaxFile then
     begin
          ErrorLog('*** Error: "LOAD '+ss+'" is nested too deep');
          exit;
     end;

     if NFile <= 0 then
     begin
          NCase:=0; NCount:=0;
          ErrorLog('<read file '+ss+'>');
     end
     else begin
          sh:='';
          for i:=1 to NFile-1 do sh:=sh+'*';
          ErrorLog('<'+sh+'include file '+ss+'>');
     end;

     NFile:=NFile+1;
     with PFile^[NFile] do
     begin
          assign(fn,ss);
          {$I-} reset(fn); {$I+}
          if IOResult <> 0 then
          begin
                ErrorLog('*** Error: File is not found ('+ss+')');
                NFile:=NFile-1;
          end
          else begin
               inum:=0; dummy:=0;
               sbuf:=''; snam:=ss;
               icount:=0;
          end;
     end;

end; {StartRead}


Procedure CloseRead;
var i : integer;
begin
     for i:=NFile downto 1 do
         close(PFile^[i].fn);
     NFile:=0;
end; {CloseRead}


Function  EndOfRead : boolean;
begin
     EndOfRead:=(NFile <= 0);
end; {EndOfRead}


Procedure LogReadState;
var fl : boolean;
begin
     if NFile <= 0 then exit;
     fl:=FlagLogScr; FlagLogScr:=false;
     with PFile^[NFile] do
     begin
          ErrorLog('    Error/Warning/Message before or in the record : ');
          ErrorLog('    File : '+snam+'  Line : '+ConvInt(icount));
          ErrorLog('    "'+sbuf+'"');
     end;
     FlagLogScr:=fl;
end; {LogReadState}


function GetChar(var ch : char) : boolean;
var sh : string;
    i  : integer;
begin
     while true do
     begin
          if NFile <= 0 then
          begin
             ch:=' '; GetChar:=false;
             exit;
          end;
          with PFile^[NFile] do
          begin
              if (inum < 1) or (inum > ord(sbuf[0])) then
              begin
                   if eof(fn) then
                   begin
                       close(fn); NFile:=NFile-1;
                       if NFile > 0 then
                       begin
                           sh:='';
                           for i:=1 to NFile-1 do sh:=sh+'*';
                           ErrorLog('<'+sh+'file '+PFile^[NFile].snam+'>');
                       end
                       else ErrorLog('<endfile '+PFile^[NFile+1].snam+'>');
                   end
                   else begin
                       if (inum < 1) then
                       begin
                          readln(fn,sbuf); inum:=1;
                          icount:=icount+1;
                       end
                       else begin
                          inum:=0; ch:=' ';
                          GetChar:=true; exit;
                       end;
                   end;
              end
              else begin
                   ch:=sbuf[inum]; inum:=inum+1;
                   if ch in [#0..#31,#127,#255] then ch:=' ';
                   GetChar:=true; exit;
              end;
          end; {with}
     end; {while}
end; {GetChar}


Function  ReturnRead (var IDent : string;
                      var NBuf : integer;
                      var Buf : BufRecord) : ReadState;
var ch : char;
    ind : byte;
    flover : boolean;
begin

      {------ Discard leading blanks ------}
      ch:=' ';
      while ch = ' ' do
      begin
           if not GetChar(ch) then
           begin
                IDent:=''; NBuf:=0; ReturnRead:=EndFile;
                exit;
           end;
      end; {while}

      if ch = ')' then
      begin
           IDent:=''; NBuf:=0;
           ReturnRead:=CloseLex;
           exit;
      end;

      if ch <> '(' then
      begin
           ErrorLog('*** Error: Operator is started not from "("');
           ErrorLog('           Symbol "(" is inserted before "'+ch+'" [pos='
                                    +ConvByte(PFile^[NFile].inum-1)+'] : ');
           ErrorLog('           '+PFile^[NFile].sbuf);
           if FlagProcessFile then LogReadState;
      end
      else begin
           {---- Discard up to next non-blank---}
           ch:=' ';
           while ch = ' ' do
           begin
              if not GetChar(ch) then
              begin
                   IDent:=''; NBuf:=0; ReturnRead:=EndFile;
                   ErrorLog('*** Error: Unexpected end-of-file ('
                                   +PFile^[NFile].snam+')');
                   exit;
              end;
           end;
      end;

      {--- Copy identifier ---}
      ind:=0;
      while not (ch in [' ','(',')']) do
      begin
           if ind < 255 then
           begin
                ind:=ind+1; IDent[ind]:=UpCase(ch);
           end;
           if not GetChar(ch) then
           begin
                IDent[0]:=char(ind); NBuf:=0; ReturnRead:=EndFile;
                ErrorLog('*** Error: Unexpected end-of-file ('
                                   +PFile^[NFile].snam+')');
                exit;
           end;
      end;

      IDent[0]:=char(ind);
      NBuf:=0; flover:=false;

      {---- Read up to ')' or '(' ---}
      while ch = ' ' do
      begin
           if not GetChar(ch) then
           begin
                ReturnRead:=EndFile;
                ErrorLog('*** Error: Unexpected end-of-file ('
                                   +PFile^[NFile].snam+')');
                exit;
           end;
      end;

      while not (ch in ['(',')']) do
      begin
           if NBuf < MaxBufSize then
           begin
                NBuf:=NBuf+1;
                Buf[NBuf]:=ch;
           end
           else begin
                if not flover then
                begin
                    ErrorLog('*** Error: BufSize is too small ['
                                     +ConvByte(PFile^[NFile].inum-1)+'] : ');
                    ErrorLog('           '+PFile^[NFile].sbuf);
                    if FlagProcessFile then LogReadState;
                end;
                flover:=true;
           end;

           if not GetChar(ch) then
           begin
                IDent[0]:=char(ind); NBuf:=0; ReturnRead:=EndFile;
                ErrorLog('*** Error: Unexpected end-of-file ('
                                   +PFile^[NFile].snam+')');
                exit;
           end;

      end; {while ch <> () }

      if ch = '(' then
      begin
           ReturnRead:=OpenBrace;
           PFile^[NFile].inum:=PFile^[NFile].inum-1;
      end
      else ReturnRead:=CloseBrace;

end; {ReturnRead}


procedure SkipOp(var RState : ReadState;
                 var Buf    : BufRecord);
var icn : integer;
    IDent : string;
    NBuf : integer;
begin
     if RState = OpenBrace then icn:=1
                           else icn:=0;
     while (icn > 0) do
     begin
          RState:=ReturnRead(IDent,NBuf,Buf);
          case RState of
          OpenBrace  : icn:=icn+1;
          CloseBrace : ;
          CloseLex   : icn:=icn-1;
          EndFile    : begin
                         ErrorLog('*** Error : Unfinished operator (end-of-file)');
                         icn:=0; FlagError:=true;
          end;
          end; {case}
    end; {while}
end; {SkipOp}

const MaxIFStr  = 9;
const MaxIFName = 28;
type IFNameStr  = string[MaxIFStr];
const IFType : array [1..MaxIFName] of byte =
( 0,   0,  0,  1,  1,  1,
  2,   3,  4,  5,  6,  7,
  8,   9, 10, 11, 12, 13,
  14,
  15, 16, 17, 18, 19, 20,
  21,
  22, 23);
const IFName : array [1..MaxIFName] of IFNameStr =
( 'IF',     'IF-ONE',  'IF-TRUE', 'IF-NOT', 'IF-ZERO', 'IF-FALSE',
  'IF-EQ',  'IF-NE',   'IF-GT',   'IF-GE',  'IF-LE',   'IF-LT',
  'IFR-EQ', 'IFR-NE',  'IFR-GT',  'IFR-GE', 'IFR-LE',  'IFR-LT',
  'IF-CASE',
  'IFS-EQ', 'IFS-NE',  'IFS-GT',  'IFS-GE', 'IFS-LE',  'IFS-LT',
  'IFS-CASE',
  'IF-DEF', 'IF-NDEF');

function FindIFType(s : string) : byte;
var i : integer;
begin
    for i:=0 to MaxIFName do
    begin
         if s = IFName[i] then
         begin
              FindIFType:=IFType[i];
              exit;
         end;
    end;
    FindIFType:=255;
end; {FinfIFType}

procedure FileFix11(ss : string);
begin
    ErrorLog('*** Error : '''+ss+''' cannot include sub-operators');
    ErrorLog('            Missing ")" is inserted');
    if FlagProcessFile then LogReadState;
    FlagError:=true;
end; {FileFix1}

procedure FixBrace(ss : string);
begin
    ErrorLog('*** Error : '''+ss+''' contains no open brace');
    ErrorLog('            Missing "(" is inserted');
    if FlagProcessFile then LogReadState;
    FlagError:=true;
end; {FixBrace}

procedure FixVarName(var ss : string);
begin
     {---
     ss:=UpCaseString(ss);
     ---}
     if ord(ss[0]) > 16 then
     begin
         ErrorLog('*** Warning : Name '+ss+' is too long.');
         ss[0]:=char(16);
         ErrorLog('              It is transformed to '+ss);
         if FlagProcessFile then LogReadState;
     end;
     if (ss = '') or (ss = ' ') then
     begin
         ErrorLog('*** Warning : Empty variable name.');
         ss:='NoName';
         ErrorLog('              It is transformed to '+ss);
         if FlagProcessFile then LogReadState;
     end;
end; {FixVarName}


procedure FixIFF(RState : ReadState;
                var IDent : string;
                NBuf : integer;
                var Buf : BufRecord;
                ic : byte);
var ii, jj : longint;
    pp, qq : float;
    sa, sb : svaltype;
    ss : string;
    ptrV   : ptrVarRecord;
    sbuf   : string;
    k      : integer;
    fl, flerr : boolean;
begin

    if RState <> CloseBrace then FileFix11(IDent);
    if NCase >= MaxCaseStruct then
    begin
         ErrorLog('*** Error : Too much IF statements');
         if FlagProcessFile then LogReadState;
         FlagError:=true;
    end
    else begin

         if NBuf <= 0 then
         begin
             ErrorLog('*** Error : '+IDent+' has no parameters');
             if FlagProcessFile then LogReadState;
             FlagError:=true;
         end;

         sbuf:=PackBuf(NBuf,Buf);
         if ic > 23 then
         begin
              ErrorLog('*** Internal Error : Unknown IF-??? state : '
                     +ConvInt(ic));
              if FlagProcessFile then LogReadState;
              FlagError:=true;
         end
         else if (ic > 20) then
         begin {if-def, if-ndef, ifs-case}
               sa:='';
               sb:=ConvFromString(sbuf,true);
               if ic = 21 then sb:=UpCaseString(sb);
               ii:=0; jj:=0;
               pp:=0.0; qq:=0.0;
         end
         else if (ic > 14) then
         begin {ifs-???}
               sa:=ConvFromString(sbuf,false);
               sa:=UpCaseString(sa);
               sb:=ConvFromString(sbuf,true);
               sb:=UpCaseString(sb);
               ii:=0; jj:=0;
               pp:=0.0; qq:=0.0;
         end
         else if (ic = 14) then
         begin {if-case}
               pp:=0.0; qq:=0.0;
               sa:=''; sb:='';
               ii:=0; jj:=ConvFromLongInt(sbuf,true);
         end
         else if ic > 7 then
         begin {ifr-???}
              ii:=0; jj:=0;
              pp:=ConvFromReal(sbuf,false);
              qq:=ConvFromReal(sbuf,true);
              sa:=''; sb:='';
         end
         else begin {if-???}
              pp:=0.0; qq:=0.0;
              if ic > 1 then ii:=ConvFromLongInt(sbuf,false)
                        else ii:=0;
              jj:=ConvFromLongInt(sbuf,true);
              sa:=''; sb:='';
         end;

         NCount:=0;
         NCase:=NCase+1;
         flerr:=false;

         case ic of
         0 : {if, if-one, if-true}
             if jj <> 0 then IFCase[NCase].ifvalue:=ifcasetrue
                        else IFCase[NCase].ifvalue:=ifcasefalse;
         1 : {if-not, if-zero, if-false}
             if jj = 0 then IFCase[NCase].ifvalue:=ifcasetrue
                       else IFCase[NCase].ifvalue:=ifcasefalse;
         2 : {if-eq}
             if ii = jj then IFCase[NCase].ifvalue:=ifcasetrue
                        else IFCase[NCase].ifvalue:=ifcasefalse;
         3 : {if-ne}
             if ii <> jj then IFCase[NCase].ifvalue:=ifcasetrue
                         else IFCase[NCase].ifvalue:=ifcasefalse;
         4 : {if-gt}
             if ii > jj then IFCase[NCase].ifvalue:=ifcasetrue
                        else IFCase[NCase].ifvalue:=ifcasefalse;
         5 : {if-ge}
             if ii >= jj then IFCase[NCase].ifvalue:=ifcasetrue
                         else IFCase[NCase].ifvalue:=ifcasefalse;
         6 : {if-le}
             if ii <= jj then IFCase[NCase].ifvalue:=ifcasetrue
                         else IFCase[NCase].ifvalue:=ifcasefalse;
         7 : {if-lt}
             if ii < jj then IFCase[NCase].ifvalue:=ifcasetrue
                        else IFCase[NCase].ifvalue:=ifcasefalse;
         8 : {ifr-eq}
             if pp = qq then IFCase[NCase].ifvalue:=ifcasetrue
                        else IFCase[NCase].ifvalue:=ifcasefalse;
         9 : {ifr-ne}
             if pp <> qq then IFCase[NCase].ifvalue:=ifcasetrue
                         else IFCase[NCase].ifvalue:=ifcasefalse;
        10 : {ifr-gt}
             if pp > qq then IFCase[NCase].ifvalue:=ifcasetrue
                        else IFCase[NCase].ifvalue:=ifcasefalse;
        11 : {ifr-ge}
             if pp >= qq then IFCase[NCase].ifvalue:=ifcasetrue
                         else IFCase[NCase].ifvalue:=ifcasefalse;
        12 : {ifr-le}
             if pp <= qq then IFCase[NCase].ifvalue:=ifcasetrue
                         else IFCase[NCase].ifvalue:=ifcasefalse;
        13 : {ifr-lt}
             if pp < qq then IFCase[NCase].ifvalue:=ifcasetrue
                        else IFCase[NCase].ifvalue:=ifcasefalse;
        14 : {if-case}
             begin
                  IFCase[NCase].ifvalue:=ifcaseint0;
                  IFCase[NCase].ifint:=jj;
             end;
        15 : {ifs-eq}
             if sa = sb then IFCase[NCase].ifvalue:=ifcasetrue
                        else IFCase[NCase].ifvalue:=ifcasefalse;
        16 : {ifs-ne}
             if sa <> sb then IFCase[NCase].ifvalue:=ifcasetrue
                         else IFCase[NCase].ifvalue:=ifcasefalse;
        17 : {ifs-gt}
             if sa > sb then IFCase[NCase].ifvalue:=ifcasetrue
                        else IFCase[NCase].ifvalue:=ifcasefalse;
        18 : {ifs-ge}
             if sa >= sb then IFCase[NCase].ifvalue:=ifcasetrue
                         else IFCase[NCase].ifvalue:=ifcasefalse;
        19 : {ifs-le}
             if sa <= sb then IFCase[NCase].ifvalue:=ifcasetrue
                         else IFCase[NCase].ifvalue:=ifcasefalse;
        20 : {ifs-lt}
             if sa < sb then IFCase[NCase].ifvalue:=ifcasetrue
                        else IFCase[NCase].ifvalue:=ifcasefalse;
        21 : {ifs-case}
             begin
                  IFCase[NCase].ifvalue:=ifcasestr0;
                  IFCase[NCase].ifstr:=sb;
             end;
        22, 23 : {if-def, if-ndef}
             begin
                  ptrV:=ptrVariableGlb; fl:=true;
                  ss:=sb; FixVarName(ss);
                  while (ptrV <> nil) and fl do
                  begin
                      if ptrV^.VName = ss then fl:=false
                                          else ptrV:=ptrV^.ptrNext;
                  end; {while}

                  if ic = 22 then fl:=not fl;
                  if fl then IFCase[NCase].ifvalue:=ifcasetrue
                        else IFCase[NCase].ifvalue:=ifcasefalse;
             end;
        else begin
              flerr:=true;
              NCase:=NCase-1;
              { --- already fixed ---
              ErrorLog('*** Internal Error : Unknown IF-??? state : '
                     +ConvInt(ic));
              if FlagProcessFile then LogReadState;
              FlagError:=true;
              }
         end;
         end; {case}

         if not flerr then
         begin
              if IFCase[NCase].ifvalue = ifcasetrue
                 then IFState[NCase].iftrue:=true
                 else IFState[NCase].iftrue:=false;
              IFState[NCase].ifelse:=false;
         end;

    end;
end; {FixIFF}

{-------------------------------------------------}
{                                                 }
{   This procedure processes operator VARIABLE    }
{                                                 }
{-------------------------------------------------}
procedure LVariables(var NBuf : integer; var Buf : BufRecord;
                RS : ReadState);
var RState : ReadState;
    icn    : integer;
    IDent,
    sbuf   : string;
var ptrV   : ptrVarRecord;
    s      : string;
    fl     : boolean;
    ic     : byte;
begin
     RState:=RS;
     {--------- VARIABLE --------------------}
     if (NBuf > 0) then
     begin
          ErrorLog('*** Warning : VARIABLES with the string parameter.');
          ErrorLog('              Parameter is ignored.');
          LogReadState;
     end;

     if RState = OpenBrace then icn:=1
                           else icn:=0;
     while (icn > 0) do
     begin
           RState:=NoCommRead(IDent,NBuf,Buf);
           case RState of
           OpenBrace : begin
                icn:=icn+1;
                ErrorLog('*** Error : VARIABLES cannot have sub-lists.');
                ErrorLog('            Parameter '+IDent+' is ignored.');
                LogReadState; FlagError:=true;
           end;
           CloseLex   : begin
               icn:=icn-1;
           end;
           EndFile    : begin
               ErrorLog('*** Error : Unfinished operator (end-of-file)');
               icn:=0; FlagError:=true;
           end;
           CloseBrace : if icn = 1 then
           begin
                if (NBuf <= 0) then
                begin
                    ErrorLog('*** Warning : VARIABLE/'+IDent+' is without name/value');
                    LogReadState;
                end
                else begin
                     sbuf:=PackBuf(NBuf,Buf);
                     s:=GetFragmString(sbuf);
                     FixVarName(s);

                     if (sbuf = '') or (sbuf = ' ') then
                     begin
                         ErrorLog('*** Warning : VARIABLE '+IDent+'/'+s+' is without value');
                         LogReadState;
                     end;

                     ptrV:=ptrVariableGlb; fl:=true;
                     while (ptrV <> nil) and fl do
                     begin
                         if ptrV^.VName = s then fl:=false
                                            else ptrV:=ptrV^.ptrNext;
                     end; {while}

                     if fl then
                     begin
                          new(ptrV); ptrV^.psval:=nil;
                          ptrV^.ptrNext:=ptrVariableGlb;
                          ptrVariableGlb:=ptrV;
                     end
                     else begin
                          ErrorLog('*** Warning : VARIABLE '+IDent+'/'+s+' is redefined');
                          if ptrV^.VType = VarStr then dispose(ptrV^.psval);
                          ptrV^.psval:=nil;
                          LogReadState;
                     end;

                     if (IDent = 'REAL')
                          then ic:=ord(VarReal)
                     else if (IDent = 'INTEGER')
                          then ic:=ord(VarInt)
                     else if (IDent = 'CHAR')
                              or (IDent = 'CHARACTER')
                              or (IDent = 'BYTE')
                          then ic:=ord(VarChar)
                     else if (IDent = 'STRING')
                          then ic:=ord(VarStr)
                     else begin
                          ErrorLog('*** Warning : VARIABLE '+IDent+'/'+s+' : illegal type');
                          LogReadState;
                          ic:=ord(VarNone);
                     end;

                     with ptrV^ do
                     begin
                          VName:=s;
                          VType:=VarNone;
                          case VarType(ic) of
                          VarChar : cval:=ConvFromByte(sbuf,true);
                          VarInt  : jval:=ConvFromLongInt(sbuf,true);
                          VarReal : rval:=ConvFromReal(sbuf,true);
                          VarStr  : begin
                                    if psval = nil then new(psval);
                                    psval^:=ConvFromString(sbuf,true);
                                    end;
                          else ic:=ord(VarNone);
                          end; {case}
                          VType:=VarType(ic);
                     end;

                end;
           end;
           end; {case}
     end; {while}
     {--------- end VARIABLE --------------------}
end; {LVariable}

function GetElementString(var NBuf : integer;
                          var Buf : BufRecord) : string;
var sbuf, sh : string;
begin
    if NBuf <= 0 then sbuf:=''
                 else sbuf:=PackBuf(NBuf,Buf);
    sh:='';
    while (sbuf <> '') and (sbuf <> ' ') do
    begin
         sh:=sh+ConvFromString(sbuf,false)+' ';
    end; {while}
    GetElementString:=sh;
end; {GetElementString}


function GetFullString(var NBuf : integer;
                    var Buf : BufRecord;
                    RS : ReadState) : string;
var IDent, sh : string;
    icn : integer;
    RState : ReadState;
begin
    sh:=GetElementString(NBuf, Buf);

    RState:=RS;
    if RState = OpenBrace then icn:=1
                          else icn:=0;

    while (icn > 0) do
    begin
         RState:=ReturnRead(IDent,NBuf,Buf);
         case RState of
         OpenBrace : begin
                     icn:=icn+1; sh:=sh+' ('+IDent;
                     sh:=sh+' '+GetElementString(NBuf,Buf);
         end;
         CloseBrace : begin
                      sh:=sh+' ('+IDent+' '
                            +GetElementString(NBuf,Buf)+')';
         end;
         CloseLex   : begin
                      sh:=sh+') ';
                      icn:=icn-1;
         end;
         EndFile    : begin
                      ErrorLog('*** Error : Unfinished operator (end-of-file)');
                      icn:=0; FlagError:=true;
         end;
         end; {case}
    end; {while icn > 0}
    GetFullString:=DelSpaces(sh);
end; {GetFullString}


Function  NoCommRead (var IDent : string;
                      var NBuf : integer;
                      var Buf : BufRecord) : ReadState;
var ptrV   : ptrVarRecord;
var jj     : longint;
    sb     : svaltype;
    ss, sh, sbuf : string;
    k, icn : integer;
var RState : ReadState;
    icss   : integer;
    fl, flag : boolean;
    ic     : byte;
begin

      repeat
      begin

            RState:=ReturnRead(IDent,NBuf,Buf);
            flag:=(RState=EndFile);

            {---- IF-THEN-ELSE structures ---}
            if IDent = 'CASE' then
            begin
               if (NCount > 0) then
               else if (NCase <= 0)
                    or (not (IfCase[NCase].ifvalue in [ifcaseint0, ifcaseint,
                                                       ifcasestr0, ifcasestr]))
                    or IfState[NCase].ifelse
               then begin
                   ErrorLog('*** Error : CASE outside IF-CASE structure is ignored');
                   if FlagProcessFile then LogReadState;
                   FlagError:=true;
               end
               else if not IFState[NCase].iftrue then
               begin
                    sbuf:=PackBuf(NBuf,Buf);
                    case IfCase[NCase].ifvalue of
                    ifcaseint0,
                    ifcaseint : begin
                          jj:=ConvFromLongInt(sbuf,true);
                          if (jj = IFCase[NCase].ifint) then
                          begin
                               IFState[NCase].iftrue:=true;
                               IfCase[NCase].ifvalue:=ifcaseint;
                          end;
                    end;
                    ifcasestr0,
                    ifcasestr : begin
                          sb:=ConvFromString(sbuf,true);
                          sb:=UpCaseString(sb);
                          if (sb = IFCase[NCase].ifstr) then
                          begin
                               IFState[NCase].iftrue:=true;
                               IfCase[NCase].ifvalue:=ifcasestr;
                          end;
                    end;
                    else begin
                         ErrorLog('*** Internal Error : Unknown IF-??? state (2) ');
                         if FlagProcessFile then LogReadState;
                         FlagError:=true;
                    end;
                    end; {case}
               end;
            end
            else if IDent = 'ELSE' then
            begin
               if RState <> CloseBrace then FileFix11(IDent);
               if (NCount > 0) then
               else if NCase <= 0 then
               begin
                   ErrorLog('*** Error : ELSE outside IF-THEN structure is ignored');
                   if FlagProcessFile then LogReadState;
                   FlagError:=true;
               end
               else if IFState[NCase].ifelse then
               begin
                   ErrorLog('*** Error : ELSE is specified already (ignored)');
                   if FlagProcessFile then LogReadState;
                   FlagError:=true;
               end
               else begin
                    IFState[NCase].ifelse:=true;
                    if IfCase[NCase].ifvalue in [ifcasefalse, ifcasetrue]
                    then begin
                         IFState[NCase].iftrue:=not IFState[NCase].iftrue;
                    end
                    else if IfCase[NCase].ifvalue in [ifcaseint0, ifcasestr0]
                    then begin
                         IFState[NCase].iftrue:=true;
                    end;
               end;
            end
            else if IDent = 'ENDIF' then
            begin
               if RState <> CloseBrace then FileFix11(IDent);
               if (NCount > 0) then NCount:=NCount-1
               else begin
                  if NCase <= 0 then
                  begin
                      ErrorLog('*** Error : ENDIF outside IF-THEN structure is ignored');
                      if FlagProcessFile then LogReadState;
                      FlagError:=true;
                  end
                  else NCase:=NCase-1;
               end;
            end
            {---- IF-operators ---}
            else begin
                 ic:=FindIFType(IDent);
                 if ic <> 255 then
                 begin
                     if (NCase > 0) and not IFState[NCase].iftrue
                        then NCount:=NCount+1
                        else FixIFF(RState,IDent,NBuf,Buf,ic);
                 end
                 else if (NCase > 0) and
                    (not IFState[NCase].iftrue)
                 then begin
                      SkipOp(RState,Buf);
                 end
                 {---- other than IF-THEN-ELSE operators ---}
                 else if IDent = 'BREAK' then
                 begin
                      if RState <> CloseBrace then FileFix11(IDent);
                      if (NCount > 0) then
                      else if (NCase <= 0)
                           or (not (IfCase[NCase].ifvalue in [ifcaseint0,
                                                              ifcaseint,
                                                              ifcasestr0,
                                                              ifcasestr]))
                           or IfState[NCase].ifelse
                      then begin
                           ErrorLog('*** Error : BREAK outside IF-CASE structure is ignored');
                           if FlagProcessFile then LogReadState;
                           FlagError:=true;
                      end
                      else if IFState[NCase].iftrue then
                      begin
                           IFState[NCase].iftrue:=false;
                      end;
                 end
                 else if (IDent = 'VAR') or (IDent = 'VARIABLE') then
                 begin
                      LVariables(NBuf, Buf, RState);
                 end
                 else if (IDent = 'ASSIGN') then
                 begin
                      if RState <> CloseBrace then FileFix11(IDent);
                      if (NBuf <= 0) then
                      begin
                          ErrorLog('*** Warning : ASSIGN is without name/value');
                          LogReadState;
                      end
                      else begin
                          sbuf:=PackBuf(NBuf,Buf);
                          ss:=GetFragmString(sbuf);
                          FixVarName(ss);
                          if (sbuf = '') or (sbuf = ' ') then
                          begin
                              ErrorLog('*** Warning : VARIABLE '+ss+' is without value');
                              LogReadState;
                          end;

                          ptrV:=ptrVariableGlb; fl:=true;
                          while (ptrV <> nil) and fl do
                          begin
                              if ptrV^.VName = ss
                                 then fl:=false
                                 else ptrV:=ptrV^.ptrNext;
                          end; {while}

                          if fl then
                          begin
                              ErrorLog('*** Error : VARIABLE '+ss+' is not defined');
                              LogReadState; FlagError:=true;
                          end
                          else with ptrV^ do
                          begin
                               case VType of
                               VarNone : ;
                               VarChar : cval:=ConvFromByte(sbuf,true);
                               VarInt  : jval:=ConvFromLongInt(sbuf,true);
                               VarReal : rval:=ConvFromReal(sbuf,true);
                               VarStr  : begin
                                         if psval = nil then new(psval);
                                         psval^:=ConvFromString(sbuf,true);
                                         end;
                               end; {case}
                          end;
                      end;
                 end
                 else if IDent = 'ENDLOAD' then
                 begin
                       close(PFile^[NFile].fn); NFile:=NFile-1;
                       if NFile > 1 then
                          ErrorLog('*Include File  '+PFile^[NFile].snam)
                       else if NFile > 0 then
                          ErrorLog('*File  '+PFile^[NFile].snam);
                 end
                 else if IDent = 'ENDINPUT'  then
                 begin
                      if RState <> CloseBrace then FileFix11(IDent);
                      CloseRead;
                 end
                 else if IDent = 'HALTPGM'  then
                 begin
                      if RState <> CloseBrace then FileFix11(IDent);
                      ErrorLog('Program is terminated by User');
                      CloseRead;
                      CloseLogFile;
                      halt;
                 end
                 else if (IDent = 'LOADFILE') or (IDent = 'LOAD') then
                 begin
                      if RState <> CloseBrace then FileFix11(IDent);
                      sbuf:=PackBuf(NBuf,Buf);
                      ss:=ConvFromString(sbuf,true);
                      sh:=FindFileLoc(ss,ExtFile);
                      if sh = '' then
                      begin
                           ErrorLog('*** Unable to open LOAD file : '+ss);
                           if FlagProcessFile then LogReadState;
                           FlagError:=true; FlagSevere:=true;
                      end
                      else begin
                           {
                           ErrorLog('Include File : '+sh);
                           }
                           StartRead(sh);
                      end;
                 end
                 else if IDent = 'COMMENT' then
                 begin
                      SkipOp(RState,Buf);
                 end
                 else if (IDent = 'MESSAGE') or (IDent = 'TYPEOUT') then
                 begin
                      sh:=GetFullString(NBuf,Buf,RState);
                      ErrorLog('*** Message : '+sh);
                      if FlagProcessFile then LogReadState;
                 end
                 else flag:=true;
            end;
      end
      until flag;

      NoCommRead:=RState;

end; {NoCommRead}


end.