#include <fcntl.h>
#include <sys/doscalls.h>
#include "djio.h"

int _fmode_bin = O_BINARY;
int _nfiles = 40;
long _files[40];
int _lookahead[40];

void djio_init(void)
{
    int i, j;

    for (i = 0; i < _nfiles; ++i) {
	_files[i] = 0;
	_lookahead[i] = -1;
	if ((j = dos_ioctl_getattr(i)) != -1) {
	    _files[i] |= O_NOT_CLOSE;
	    if (j & 128)
		_files[i] |= F_DEV;
	    if (i <= 2)
		_files[i] |= O_TEXT;
	    else
		_files[i] |= O_BINARY;
	    if (i == 0)
		_files[0] |= O_RDONLY;
	    else if (i == 1)
		_files[1] |= O_WRONLY;
	    else if (i == 2)
		_files[2] |= O_WRONLY;
	    else
		_files[i] |= O_RDWR;
	}
    }
}
