/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.IconsDatabase;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.panels.NextMediaFileFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class NextMediaDialog
extends JDialog
implements ActionListener {
    private static final String NEXTMEDIA_MSG_ID = "nextmedia.msg";
    private static final String NEXTMEDIA_TITLE_ID = "nextmedia.title";
    private static final String BROWSEBTN_ID = "nextmedia.browsebtn";
    private static final String OKBTN_ID = "nextmedia.okbtn";
    private static final String CANCELBTN_ID = "nextmedia.cancelbtn";
    private static final long serialVersionUID = -2551719029962051020L;
    protected JLabel msg;
    protected JTextField path;
    protected JButton browsebtn;
    protected JButton okbtn;
    protected JButton cancelbtn;
    protected String nextmedianame;
    protected String nextmediapath;
    protected String nextmediainput;
    protected LocaleDatabase langpack;
    protected IconsDatabase icons;
    protected Frame owner;

    public NextMediaDialog(InstallerFrame main, String nextmedia) throws HeadlessException {
        this(null, main, nextmedia);
    }

    public NextMediaDialog(Frame owner, InstallerFrame main, String nextmedia) throws HeadlessException {
        this(owner, main.langpack, main.icons, nextmedia);
    }

    public NextMediaDialog(Frame owner, LocaleDatabase languagepack, IconsDatabase icons, String nextmedia) throws HeadlessException {
        super(owner, languagepack.getString(NEXTMEDIA_TITLE_ID), true);
        this.owner = owner;
        this.langpack = languagepack;
        this.icons = icons;
        this.nextmediapath = nextmedia;
        File nextmediafile = new File(this.nextmediapath);
        this.nextmedianame = nextmediafile.getName();
        this.initUI();
    }

    public NextMediaDialog(Frame owner, AutomatedInstallData idata, String nextmedia) throws HeadlessException {
        this(owner, idata.langpack, null, nextmedia);
    }

    protected void initUI() {
        if (this.icons != null) {
            this.msg = LabelFactory.create(this.langpack.getString(NEXTMEDIA_MSG_ID), this.icons.getImageIcon("warning"), 2);
            this.browsebtn = ButtonFactory.createButton(this.langpack.getString(BROWSEBTN_ID), this.icons.getImageIcon("open"), new Color(230, 230, 230));
            this.okbtn = ButtonFactory.createButton(this.langpack.getString(OKBTN_ID), this.icons.getImageIcon("ok"), new Color(230, 230, 230));
            this.cancelbtn = ButtonFactory.createButton(this.langpack.getString(CANCELBTN_ID), this.icons.getImageIcon("cancel"), new Color(230, 230, 230));
        } else {
            this.msg = new JLabel(this.langpack.getString(NEXTMEDIA_MSG_ID), 2);
            this.browsebtn = new JButton(this.langpack.getString(BROWSEBTN_ID));
            this.okbtn = new JButton(this.langpack.getString(OKBTN_ID));
            this.cancelbtn = new JButton(this.langpack.getString(CANCELBTN_ID));
        }
        this.path = new JTextField(this.nextmediapath);
        this.path.setColumns(40);
        this.browsebtn.addActionListener(this);
        this.okbtn.addActionListener(this);
        this.cancelbtn.addActionListener(this);
        JPanel mainpanel = new JPanel();
        mainpanel.setLayout(new BoxLayout(mainpanel, 3));
        mainpanel.add(this.msg);
        JPanel pathpanel = new JPanel();
        pathpanel.setLayout(new BoxLayout(pathpanel, 2));
        pathpanel.add(this.path);
        pathpanel.add(this.browsebtn);
        pathpanel.add(Box.createHorizontalGlue());
        mainpanel.add(pathpanel);
        JPanel okpanel = new JPanel();
        okpanel.setLayout(new BoxLayout(okpanel, 2));
        okpanel.add(Box.createHorizontalGlue());
        okpanel.add(this.okbtn);
        okpanel.add(this.cancelbtn);
        okpanel.add(Box.createHorizontalGlue());
        mainpanel.add(okpanel);
        mainpanel.add(Box.createVerticalGlue());
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)mainpanel, "Center");
        this.pack();
        if (this.owner != null) {
            Dimension mysize = this.getSize();
            Dimension ownersize = this.owner.getSize();
            Point position = this.owner.getLocationOnScreen();
            Point centerposition = new Point();
            centerposition.setLocation(position.getX() + 0.5 * ownersize.getWidth(), position.getY() + 0.5 * ownersize.getHeight());
            Point myposition = new Point();
            myposition.setLocation(centerposition.getX() - 0.5 * mysize.getWidth(), centerposition.getY() - 0.5 * mysize.getHeight());
            this.setLocation(myposition);
        }
    }

    public String getNextMedia() {
        return this.nextmediainput;
    }

    public void actionPerformed(ActionEvent e) {
        int option;
        if (e.getSource() == this.browsebtn) {
            JFileChooser jfc = this.path.getText() != null ? new JFileChooser(this.path.getText()) : new JFileChooser();
            jfc.setFileFilter(new NextMediaFileFilter(this.nextmedianame, this.langpack));
            jfc.setDialogTitle(this.langpack.getString("nextmedia.choosertitle"));
            jfc.setDialogType(0);
            jfc.setFileSelectionMode(0);
            if (jfc.showOpenDialog(this) == 0) {
                this.nextmediainput = jfc.getSelectedFile().getAbsolutePath();
                this.path.setText(this.nextmediainput);
            }
        } else if (e.getSource() == this.okbtn) {
            this.nextmediainput = this.path.getText();
            this.setVisible(false);
        } else if (e.getSource() == this.cancelbtn && (option = JOptionPane.showConfirmDialog(this, this.langpack.getString("installer.quit.message"), this.langpack.getString("installer.quit.title"), 0)) == 0) {
            System.exit(-1);
        }
    }
}

