# coding: utf-8
# Name:        main.py
# Author:      Mancuniancol
# Created on:  28.12.2016
# Licence:     GPL v.3: http://www.gnu.org/copyleft/gpl.html
"""
Main Menu Magnetic Subscription manager
"""

import sys
import xbmcaddon
import xbmcgui
import xbmcplugin
from shutil import rmtree
from urlparse import parse_qsl

from resources.lib.storage import *

base_url = sys.argv[0]
addon_handle = int(sys.argv[1])
args = dict(parse_qsl(sys.argv[2][1:]))

listing = []
tv_shows = Storage.open('subscriptions', ttl=None)
information = Storage.open('library', ttl=None)

mode = args.get('mode', None)
imdb_id = args.get('imdb_id', None)
title = args.get('title', None)

if mode == 'remove':
    if xbmcgui.Dialog().yesno('Magnetizer', 'Are you sure to remove %s from subscription?' % title):
        del tv_shows[imdb_id]
        tv_shows.sync()
        # erasing files
        if xbmcgui.Dialog().yesno('Magnetizer', 'Do you want to erase the files of %s?' % title):
            folder = xbmc.translatePath(xbmcaddon.Addon('script.module.magnetic').getSetting('shows_folder'))
            folder = os.path.join(folder, title)
            logger.log.info(folder)
            rmtree(folder)
            xbmc.executebuiltin('XBMC.CleanLibrary(video)')  # update the library with the new information

if not mode:
    # creation menu
    for imdb_id in tv_shows:
        video = information.get(imdb_id, {imdb_id: None})
        if video[imdb_id]:
            title = video[imdb_id]['title']
            list_item = xbmcgui.ListItem(label=title)
            # icon = provider["thumbnail"]
            # fanart = provider["fanart"]
            # list_item.setArt({'thumb': icon,
            #                   'icon': icon,
            #                   'fanart': fanart})
            is_folder = False
            url = base_url + '?mode=remove&imdb_id=%s&title=%s' % (imdb_id, title)
            listing.append((url, list_item, is_folder))

    xbmcplugin.addDirectoryItems(addon_handle, listing, len(listing))
    xbmcplugin.addSortMethod(addon_handle, xbmcplugin.SORT_METHOD_LABEL_IGNORE_THE)
    xbmcplugin.endOfDirectory(addon_handle, updateListing=True)

# destroying storage objects
tv_shows.close()
information.close()
del tv_shows
del information
