from entertainment.plugnplay.interfaces import MovieSource
from entertainment.plugnplay.interfaces import TVShowSource
from entertainment.plugnplay import Plugin


class putlockerac(MovieSource,TVShowSource):
    implements = [MovieSource,TVShowSource]
    
    name = "putlocker.ac"
    display_name = "Putlocker.ac"
    source_enabled_by_default = 'true'
    
    def GetFileHosts(self, url, list, lock, message_queue,season,episode,type):
        import re,json
        from entertainment import requests




        POSTURL='https://putlockers.ca/wp-admin/admin-ajax.php'


        headers={'Accept':'text/html, application/xhtml+xml, */*',
                'Referer':'https://putlockers.ca/',
                'Accept-Language':'en-GB',
                'User-Agent':'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko',
                'Accept-Encoding':'gzip, deflate',
                'Host':'putlockers.ca',
                'DNT':'1'}

        
        content= requests.get(url,headers=headers,verify=False).content



        headers={'Accept':'application/json, text/javascript, */*; q=0.01',
                'Content-Type':'application/x-www-form-urlencoded; charset=UTF-8',
                'X-Requested-With':'XMLHttpRequest',
                'Referer':url,
                'Accept-Language':'en-GB',
                'Accept-Encoding':'gzip, deflate',
                'User-Agent':'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko',
                'Host':'putlockers.ca',
                'DNT':'1',
                'Connection':'Keep-Alive',
                'Cache-Control':'no-cache'}

        match=re.compile("<a href='(.+?)' class='(.+?)' data-id='(.+?)' data-post-id='(.+?)'>").findall(content)  

        for datahref , dataclass , dataid ,datapostid in match:

            if "' data-id-last='" in datapostid:
                DATA={'action':'get_src',
                      'data[class]':dataclass,
                      'data[href]':datahref,
                      'data[data-post-id]':datapostid.split("'")[0],
                      'data[data-id]':dataid,
                      'data[data-id-last]':datapostid.split("='")[1]}

            else:    
                DATA={'action':'get_src',
                      'data[class]':dataclass,
                      'data[href]':datahref,
                      'data[data-post-id]':datapostid,
                      'data[data-id]':dataid}

            movielink = requests.post(POSTURL,DATA,headers=headers,verify=False).content
         
            link=json.loads(movielink)
            data=link['sources']
            for field in data:
                FINAL_URL=field['file']
                res=field['label'].upper()

                if res=='360P':
                    res='SD'
                if res=='480P':
                    res='HD'
                    
                self.AddFileHost(list, res, FINAL_URL)



    def GetFileHostsForContent(self, title, name, year, season, episode, type, list, lock, message_queue):                 
        import re
        from entertainment import requests
       
        name = self.CleanTextForSearch(name)
        helper ='%s (%s)' %(name, year)

        
        search_url = 'https://putlockers.ca/?s=' + name.replace(' ','+').lower()

        headers={'Accept':'text/html, application/xhtml+xml, */*',
                'Referer':'https://putlockers.ca/',
                'Accept-Language':'en-GB',
                'User-Agent':'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko',
                'Accept-Encoding':'gzip, deflate',
                'Host':'putlockers.ca',
                'DNT':'1'}

        if type=='tv_episodes':
            url='https://putlockers.ca/tv-series/%s/season-%s/episode-%s' % (name.replace(' ','-').lower(),season,episode)
            self.GetFileHosts(url, list, lock, message_queue,season,episode,type)
        else:    
            content = requests.get(search_url,headers=headers,verify=False).content
            
            match = re.compile('title="(.+?)">.+?<a href="(.+?)"').findall(content)
            for title, url in match:
                if name.lower() in title.lower():
                    if year in title:
                        self.GetFileHosts(url, list, lock, message_queue,season,episode,type)

                

    def Resolve(self, url):                 

            
        if 'google' in url or 'blogspot' in url:
            if 'googleusercontent.com' in url or 'redirector' in url:
                import urllib
                page = urllib.urlopen(url)
                resolved=page.geturl()
                if 'requiressl=yes' in resolved:
                    resolved=resolved.replace('http://','https://')
                
            else:
                 if 'requiressl=yes' in url:
                     url=url.replace('http://','https://')
                 resolved=url
            

        else:
        
            from entertainment import istream
            resolved =istream.ResolveUrl(url)
        return resolved  


