# Polish (pl) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                            | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | ------------------------------------------ | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987                                       | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5                                          | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987                                       | 1986-12-29T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 4                                          | 0003-12-29T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 1                                          | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                          | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | I kw.                                      | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | II kw.                                     | 2019-04-01T00:00:00.000Z |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | I kwartał                                  | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | II kwartał                                 | 2019-04-01T00:00:00.000Z |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | 1                                          | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                          | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 1                                          | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                          | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | I kw.                                      | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | II kw.                                     | 2019-04-01T00:00:00.000Z |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | I kwartał                                  | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | II kwartał                                 | 2019-04-01T00:00:00.000Z |
| Month (formatting)              | Mo           | 2019-02-11T12:13:14.015Z | 2                                          | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7                                          | 2019-07-01T00:00:00.000Z |
|                                 | MMM          | 2019-02-11T12:13:14.015Z | lut                                        | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | lip                                        | 2019-07-01T00:00:00.000Z |
|                                 | MMMM         | 2019-02-11T12:13:14.015Z | lutego                                     | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | lipca                                      | 2019-07-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-02-11T12:13:14.015Z | l                                          | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | l                                          | 2019-02-01T00:00:00.000Z |
| Month (stand-alone)             | Lo           | 2019-02-11T12:13:14.015Z | 2                                          | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7                                          | 2019-07-01T00:00:00.000Z |
|                                 | LLL          | 2019-02-11T12:13:14.015Z | lut                                        | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | lip                                        | 2019-07-01T00:00:00.000Z |
|                                 | LLLL         | 2019-02-11T12:13:14.015Z | luty                                       | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | lipiec                                     | 2019-07-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-02-11T12:13:14.015Z | L                                          | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | L                                          | 2019-02-01T00:00:00.000Z |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 1                                          | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48                                         | 2019-11-25T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 1                                          | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48                                         | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-11T12:13:14.015Z | 11                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28                                         | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365                                        | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | pon.                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | pt.                                        | 2019-02-15T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | pon.                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | pt.                                        | 2019-02-15T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | pon.                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | pt.                                        | 2019-02-15T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | poniedziałek                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | piątek                                     | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | p                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | p                                          | 2019-02-11T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | pon                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | pią                                        | 2019-02-15T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5                                          | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | pon.                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | pt.                                        | 2019-02-15T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | poniedziałek                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | piątek                                     | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | p                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | p                                          | 2019-02-11T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | pon                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | pią                                        | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 1                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5                                          | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | pon.                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | pt.                                        | 2019-02-15T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | poniedziałek                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | piątek                                     | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | p                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | p                                          | 2019-02-11T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | pon                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | pią                                        | 2019-02-15T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 1                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5                                          | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | pon.                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | pt.                                        | 2019-02-15T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | poniedziałek                               | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | piątek                                     | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | P                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | P                                          | 2019-02-11T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | pon                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | pią                                        | 2019-02-15T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | AM                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                         | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                         | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                         | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | AM                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                         | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                         | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                         | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | am                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | pm                                         | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | pm                                         | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | am                                         | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | AM                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                         | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                         | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                         | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | a                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a                                          | 2019-02-11T00:00:00.000Z |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | AM                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                         | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                         | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                         | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | AM                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                         | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                         | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                         | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | am                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | pm                                         | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | pm                                         | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | am                                         | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | AM                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                         | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                         | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                         | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | a                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p                                          | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a                                          | 2019-02-11T00:00:00.000Z |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | rano                                       | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | po południu                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | wieczorem                                  | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | w nocy                                     | 2019-02-11T00:00:00.000Z |
|                                 | BB           | 2019-02-11T11:13:14.015Z | rano                                       | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | po południu                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | wieczorem                                  | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | w nocy                                     | 2019-02-11T00:00:00.000Z |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | rano                                       | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | po południu                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | wieczorem                                  | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | w nocy                                     | 2019-02-11T00:00:00.000Z |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | rano                                       | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | po południu                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | wieczorem                                  | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | w nocy                                     | 2019-02-11T00:00:00.000Z |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | rano                                       | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | po poł.                                    | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | wiecz.                                     | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | w nocy                                     | 2019-02-11T00:00:00.000Z |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11                                         | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11                                         | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11                                         | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23                                         | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11                                         | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11                                         | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11                                         | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23                                         | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1                                          | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55                                         | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1                                          | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55                                         | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-02-11T12:13:14.015Z | 11.02.1987                                 | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29.05.1453                                 | 1453-05-29T00:00:00.000Z |
|                                 | PP           | 1987-02-11T12:13:14.015Z | 11 lut 1987                                | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 maj 1453                                | 1453-05-29T00:00:00.000Z |
|                                 | PPP          | 1987-02-11T12:13:14.015Z | 11 lutego 1987                             | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 maja 1453                               | 1453-05-29T00:00:00.000Z |
|                                 | PPPP         | 1987-02-11T12:13:14.015Z | środa, 11 lutego 1987                      | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | niedziela, 29 maja 1453                    | 1453-05-29T00:00:00.000Z |
| Long localized time             | p            | 1987-02-11T12:13:14.015Z | 12:13                                      | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59                                      | 1453-05-29T23:59:00.000Z |
|                                 | pp           | 1987-02-11T12:13:14.015Z | 12:13:14                                   | 1987-02-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59                                   | 1453-05-29T23:59:59.000Z |
|                                 | ppp          | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+0                             | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+0                             | Errored                  |
|                                 | pppp         | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+00:00                         | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+00:00                         | Errored                  |
| Combination of date and time    | Pp           | 1987-02-11T12:13:14.015Z | 11.02.1987, 12:13                          | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29.05.1453, 23:59                          | 1453-05-29T23:59:00.000Z |
|                                 | PPpp         | 1987-02-11T12:13:14.015Z | 11 lut 1987, 12:13:14                      | 1987-02-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 maj 1453, 23:59:59                      | 1453-05-29T23:59:59.000Z |
|                                 | PPPppp       | 1987-02-11T12:13:14.015Z | 11 lutego 1987 12:13:14 GMT+0              | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 maja 1453 23:59:59 GMT+0                | Errored                  |
|                                 | PPPPpppp     | 1987-02-11T12:13:14.015Z | środa, 11 lutego 1987 12:13:14 GMT+00:00   | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | niedziela, 29 maja 1453 23:59:59 GMT+00:00 | Errored                  |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result           | `includeSeconds: true` | `addSuffix: true`     |
| ------------------------ | ---------------- | ---------------------- | --------------------- |
| 2006-01-01T00:00:00.000Z | około 6 lat      | około 6 lat            | za około 6 lat        |
| 2005-01-01T00:00:00.000Z | około 5 lat      | około 5 lat            | za około 5 lat        |
| 2004-01-01T00:00:00.000Z | około 4 lata     | około 4 lata           | za około 4 lata       |
| 2003-01-01T00:00:00.000Z | około 3 lata     | około 3 lata           | za około 3 lata       |
| 2002-01-01T00:00:00.000Z | około 2 lata     | około 2 lata           | za około 2 lata       |
| 2001-06-01T00:00:00.000Z | ponad rok        | ponad rok              | za ponad rok          |
| 2001-02-01T00:00:00.000Z | około rok        | około rok              | za około rok          |
| 2001-01-01T00:00:00.000Z | około rok        | około rok              | za około rok          |
| 2000-06-01T00:00:00.000Z | 5 miesięcy       | 5 miesięcy             | za 5 miesięcy         |
| 2000-03-01T00:00:00.000Z | 2 miesiące       | 2 miesiące             | za 2 miesiące         |
| 2000-02-01T00:00:00.000Z | około miesiąc    | około miesiąc          | za około miesiąc      |
| 2000-01-15T00:00:00.000Z | 14 dni           | 14 dni                 | za 14 dni             |
| 2000-01-02T00:00:00.000Z | dzień            | dzień                  | za 1 dzień            |
| 2000-01-01T06:00:00.000Z | około 6 godzin   | około 6 godzin         | za około 6 godzin     |
| 2000-01-01T01:00:00.000Z | około godziny    | około godziny          | za około godzinę      |
| 2000-01-01T00:45:00.000Z | około godziny    | około godziny          | za około godzinę      |
| 2000-01-01T00:30:00.000Z | 30 minut         | 30 minut               | za 30 minut           |
| 2000-01-01T00:15:00.000Z | 15 minut         | 15 minut               | za 15 minut           |
| 2000-01-01T00:01:00.000Z | minuta           | minuta                 | za minutę             |
| 2000-01-01T00:00:25.000Z | mniej niż minuta | pół minuty             | za mniej niż minutę   |
| 2000-01-01T00:00:15.000Z | mniej niż minuta | mniej niż 20 sekund    | za mniej niż minutę   |
| 2000-01-01T00:00:05.000Z | mniej niż minuta | mniej niż 10 sekund    | za mniej niż minutę   |
| 2000-01-01T00:00:00.000Z | mniej niż minuta | mniej niż 5 sekund     | mniej niż minutę temu |
| 1999-12-31T23:59:55.000Z | mniej niż minuta | mniej niż 10 sekund    | mniej niż minutę temu |
| 1999-12-31T23:59:45.000Z | mniej niż minuta | mniej niż 20 sekund    | mniej niż minutę temu |
| 1999-12-31T23:59:35.000Z | mniej niż minuta | pół minuty             | mniej niż minutę temu |
| 1999-12-31T23:59:00.000Z | minuta           | minuta                 | minutę temu           |
| 1999-12-31T23:45:00.000Z | 15 minut         | 15 minut               | 15 minut temu         |
| 1999-12-31T23:30:00.000Z | 30 minut         | 30 minut               | 30 minut temu         |
| 1999-12-31T23:15:00.000Z | około godziny    | około godziny          | około godziny temu    |
| 1999-12-31T23:00:00.000Z | około godziny    | około godziny          | około godziny temu    |
| 1999-12-31T18:00:00.000Z | około 6 godzin   | około 6 godzin         | około 6 godzin temu   |
| 1999-12-30T00:00:00.000Z | 2 dni            | 2 dni                  | 2 dni temu            |
| 1999-12-15T00:00:00.000Z | 17 dni           | 17 dni                 | 17 dni temu           |
| 1999-12-01T00:00:00.000Z | około miesiąc    | około miesiąc          | około miesiąc temu    |
| 1999-11-01T00:00:00.000Z | 2 miesiące       | 2 miesiące             | 2 miesiące temu       |
| 1999-06-01T00:00:00.000Z | 7 miesięcy       | 7 miesięcy             | 7 miesięcy temu       |
| 1999-01-01T00:00:00.000Z | około rok        | około rok              | około rok temu        |
| 1998-12-01T00:00:00.000Z | około rok        | około rok              | około rok temu        |
| 1998-06-01T00:00:00.000Z | ponad rok        | ponad rok              | ponad rok temu        |
| 1998-01-01T00:00:00.000Z | około 2 lata     | około 2 lata           | około 2 lata temu     |
| 1997-01-01T00:00:00.000Z | około 3 lata     | około 3 lata           | około 3 lata temu     |
| 1996-01-01T00:00:00.000Z | około 4 lata     | około 4 lata           | około 4 lata temu     |
| 1995-01-01T00:00:00.000Z | około 5 lat      | około 5 lat            | około 5 lat temu      |
| 1994-01-01T00:00:00.000Z | około 6 lat      | około 6 lat            | około 6 lat temu      |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result     | `addSuffix: true` | With forced unit (i.e. `hour`) |
| ------------------------ | ---------- | ----------------- | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6 lat      | za 6 lat          | 52608 godzin                   |
| 2005-01-01T00:00:00.000Z | 5 lat      | za 5 lat          | 43848 godzin                   |
| 2004-01-01T00:00:00.000Z | 4 lata     | za 4 lata         | 35064 godziny                  |
| 2003-01-01T00:00:00.000Z | 3 lata     | za 3 lata         | 26304 godziny                  |
| 2002-01-01T00:00:00.000Z | 2 lata     | za 2 lata         | 17544 godziny                  |
| 2001-06-01T00:00:00.000Z | rok        | za rok            | 12408 godzin                   |
| 2001-02-01T00:00:00.000Z | rok        | za rok            | 9528 godzin                    |
| 2001-01-01T00:00:00.000Z | rok        | za rok            | 8784 godziny                   |
| 2000-06-01T00:00:00.000Z | 5 miesięcy | za 5 miesięcy     | 3648 godzin                    |
| 2000-03-01T00:00:00.000Z | 2 miesiące | za 2 miesiące     | 1440 godzin                    |
| 2000-02-01T00:00:00.000Z | miesiąc    | za miesiąc        | 744 godziny                    |
| 2000-01-15T00:00:00.000Z | 14 dni     | za 14 dni         | 336 godzin                     |
| 2000-01-02T00:00:00.000Z | dzień      | za 1 dzień        | 24 godziny                     |
| 2000-01-01T06:00:00.000Z | 6 godzin   | za 6 godzin       | 6 godzin                       |
| 2000-01-01T01:00:00.000Z | godzina    | za godzinę        | godzina                        |
| 2000-01-01T00:45:00.000Z | 45 minut   | za 45 minut       | godzina                        |
| 2000-01-01T00:30:00.000Z | 30 minut   | za 30 minut       | godzina                        |
| 2000-01-01T00:15:00.000Z | 15 minut   | za 15 minut       | 0 godzin                       |
| 2000-01-01T00:01:00.000Z | minuta     | za minutę         | 0 godzin                       |
| 2000-01-01T00:00:25.000Z | 25 sekund  | za 25 sekund      | 0 godzin                       |
| 2000-01-01T00:00:15.000Z | 15 sekund  | za 15 sekund      | 0 godzin                       |
| 2000-01-01T00:00:05.000Z | 5 sekund   | za 5 sekund       | 0 godzin                       |
| 2000-01-01T00:00:00.000Z | 0 sekund   | 0 sekund temu     | 0 godzin                       |
| 1999-12-31T23:59:55.000Z | 5 sekund   | 5 sekund temu     | 0 godzin                       |
| 1999-12-31T23:59:45.000Z | 15 sekund  | 15 sekund temu    | 0 godzin                       |
| 1999-12-31T23:59:35.000Z | 25 sekund  | 25 sekund temu    | 0 godzin                       |
| 1999-12-31T23:59:00.000Z | minuta     | minutę temu       | 0 godzin                       |
| 1999-12-31T23:45:00.000Z | 15 minut   | 15 minut temu     | 0 godzin                       |
| 1999-12-31T23:30:00.000Z | 30 minut   | 30 minut temu     | godzina                        |
| 1999-12-31T23:15:00.000Z | 45 minut   | 45 minut temu     | godzina                        |
| 1999-12-31T23:00:00.000Z | godzina    | godzinę temu      | godzina                        |
| 1999-12-31T18:00:00.000Z | 6 godzin   | 6 godzin temu     | 6 godzin                       |
| 1999-12-30T00:00:00.000Z | 2 dni      | 2 dni temu        | 48 godzin                      |
| 1999-12-15T00:00:00.000Z | 17 dni     | 17 dni temu       | 408 godzin                     |
| 1999-12-01T00:00:00.000Z | miesiąc    | miesiąc temu      | 744 godziny                    |
| 1999-11-01T00:00:00.000Z | 2 miesiące | 2 miesiące temu   | 1464 godziny                   |
| 1999-06-01T00:00:00.000Z | 7 miesięcy | 7 miesięcy temu   | 5136 godzin                    |
| 1999-01-01T00:00:00.000Z | rok        | rok temu          | 8760 godzin                    |
| 1998-12-01T00:00:00.000Z | rok        | rok temu          | 9504 godziny                   |
| 1998-06-01T00:00:00.000Z | 2 lata     | 2 lata temu       | 13896 godzin                   |
| 1998-01-01T00:00:00.000Z | 2 lata     | 2 lata temu       | 17520 godzin                   |
| 1997-01-01T00:00:00.000Z | 3 lata     | 3 lata temu       | 26280 godzin                   |
| 1996-01-01T00:00:00.000Z | 4 lata     | 4 lata temu       | 35064 godziny                  |
| 1995-01-01T00:00:00.000Z | 5 lat      | 5 lat temu        | 43824 godziny                  |
| 1994-01-01T00:00:00.000Z | 6 lat      | 6 lat temu        | 52584 godziny                  |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                   |
| ------------------------ | ------------------------ |
| 2000-01-10T00:00:00.000Z | 10.01.2000               |
| 2000-01-05T00:00:00.000Z | następna środa o 00:00   |
| 2000-01-02T00:00:00.000Z | jutro o 00:00            |
| 2000-01-01T00:00:00.000Z | dzisiaj o 00:00          |
| 1999-12-31T00:00:00.000Z | wczoraj o 00:00          |
| 1999-12-27T00:00:00.000Z | ten poniedziałek o 00:00 |
| 1999-12-21T00:00:00.000Z | 21.12.1999               |
