#!/bin/sh

APP=
FILE=
NAME=$0
GERD_EXTRA_ARGS=
if [ "$1" = "--help" -o "$1" = "-h" ] ; then
	NAME=gerd-play
	APP=gerd-gtkdummy
	GERD_EXTRA_ARGS=--gerd-help
elif [ "$1" = "--version" -o "$1" = "-v" ] ; then
	FILE=
	NAME=gerd-play
	APP=gerd-gtkdummy
	GERD_EXTRA_ARGS=--gerd-version
elif [ -z "$1" -o -z "$2" ] ; then
	echo "usage: gerd-play <event-file> <application>"
	exit 1
else
	FILE="$1"
	shift
	APP="$1"
	shift
fi


case "$NAME" in
*-play)		GERD_PLAY="$FILE"
		;;
*-record)	GERD_RECORD="$FILE"
		;;
*)	echo "$NAME: call gerd-play or gerd-record"
	exit 1
	;;
esac

GTK_MODULES=$GTK_MODULES:gerd

export GERD_PLAY GERD_RECORD GTK_MODULES GERD_EXTRA_ARGS

LD_PRELOAD=/usr/local/lib/libgerd-xwrapper.so $APP $GERD_EXTRA_ARGS $@
