# Bombardier QSeries Common Electrical System Functions
# Bea Wolf (D-ECHO) 2019-2021

#based on turboprop engine electrical system by Syd Adams

# Helper function
var check_or_create = func ( prop, value, type ) {
	var obj = props.globals.getNode(prop, 1);
	if( obj.getValue() == nil ){
		return props.globals.initNode(prop, value, type);
	} else {
		return obj;
	}
}

var delta_sec = props.globals.getNode("sim/time/delta-sec");

var strobeLight = aircraft.light.new("/sim/model/lights/strobe", [0.08, 2.5]);
var beaconLight = aircraft.light.new("/sim/model/lights/beacon", [0.08, 0.08, 0.08, 2.5]);

strobeLight.switch( 1 );
beaconLight.switch( 1 );

#var battery = Battery.new(name, switch-prop,volts,amps,amp_hours,charge_percent,charge_amps);
Battery = {
	new : func(name, swtch,vlt,amp,hr,chp,cha){
		m = { parents : [Battery] };
		m.switch = props.globals.getNode(swtch,1);
		m.switch.setBoolValue(1);
		m.volt_prop = check_or_create("/systems/electrical/battery/"~ name ~ "-volts", 0.0, "DOUBLE");
		m.ideal_volts = vlt;
		m.ideal_amps = amp;
		m.amp_hours = hr;
		m.charge_percent = chp; 
		m.charge_amps = cha;
		return m;
	},
	apply_load : func(load,dt) {
		if(me.switch.getValue()){
			var amphrs_used = load * dt / 3600.0;
			var percent_used = amphrs_used / me.amp_hours;
			me.charge_percent -= percent_used;
			if ( me.charge_percent < 0.0 ) {
				me.charge_percent = 0.0;
			} elsif ( me.charge_percent > 1.0 ) {
				me.charge_percent = 1.0;
			}
			var output =me.amp_hours * me.charge_percent;
			return output;
		}else return 0;
	},
	
	get_output_volts : func {
		if(me.switch.getValue()){
			var x = 1.0 - me.charge_percent;
			var tmp = -(3.0 * x - 1.0);
			var factor = (tmp*tmp*tmp*tmp*tmp + 32) / 32;
			var output = me.ideal_volts * factor;
			me.volt_prop.setDoubleValue( output );
			return output;
		} else {
			me.volt_prop.setDoubleValue( 0.0 );
			return 0;
		}
	},
	
	get_output_amps : func {
		if(me.switch.getValue()){
			var x = 1.0 - me.charge_percent;
			var tmp = -(3.0 * x - 1.0);
			var factor = (tmp*tmp*tmp*tmp*tmp + 32) / 32;
			var output =me.ideal_amps * factor;
			return output;
		}else return 0;
	}
};

# var alternator = Alternator.new(num,switch,rpm_source,rpm_threshold,volts,amps);
Alternator = {
	new : func (num,switch,src,thr,vlt,amp){
		m = { parents : [Alternator] };
		m.switch =  props.globals.getNode(switch,1);
		m.switch.setBoolValue(0);
		m.meter =  props.globals.getNode("systems/electrical/gen-load["~num~"]",1);
		m.meter.setDoubleValue(0);
		m.gen_output =  props.globals.getNode("engines/engine["~num~"]/amp-v",1);
		m.gen_output.setDoubleValue(0);
		m.meter.setDoubleValue(0);
		m.rpm_source =  props.globals.getNode(src,1);
		m.rpm_threshold = thr;
		m.ideal_volts = vlt;
		m.ideal_amps = amp;
		return m;
	},
	
	apply_load : func( load ) {
		var cur_volt=me.gen_output.getValue();
		var cur_amp=me.meter.getValue();
		if(cur_volt >1){
			var factor=1/cur_volt;
			gout = (load * factor);
			if(gout>1)gout=1;
		}else{
			gout=0;
		}
		if(cur_amp > gout)me.meter.setValue(cur_amp - 0.01);
		if(cur_amp < gout)me.meter.setValue(cur_amp + 0.01);
	},
	
	get_output_volts : func {
		var out = 0;
		if(me.switch.getBoolValue()){
			var factor = me.rpm_source.getValue() / me.rpm_threshold;
			if ( factor > 1.0 )factor = 1.0;
			var out = (me.ideal_volts * factor);
		}
		me.gen_output.setValue(out);
		if (out > 1) return out;
		return 0;
	},
	
	get_output_amps : func {
		var ampout =0;
		if(me.switch.getBoolValue()){
			var factor = me.rpm_source.getValue() / me.rpm_threshold;
			if ( factor > 1.0 ) {
				factor = 1.0;
			}
			ampout = me.ideal_amps * factor;
		}
		return ampout;
	}
};


var consumer = {
	new: func( name, switch, load ){
		m = { parents : [consumer] };
		m.cb = breakers.initNode(name, 1, "BOOL");
		m.switch_type = "none";
		if( switch != nil ){
			m.switch = switch;
			if ( switch.getType() == "DOUBLE" ) {
				m.switch_type = "double";
			} else if ( switch.getType() == "BOOL" ) {
				m.switch_type = "bool";
			} else {
				die("Consumer (non-int) switch of unsupported type: "~ switch.getType() ~ "!");
			}
		} else {
			m.switch = nil;
		}
		m.output = output.initNode(name, 0.0, "DOUBLE");
		m.load = load;
		return m;
	},
	power: func( bus_volts ){
		if( me.cb.getBoolValue() and bus_volts != 0.0 ){
			if ( me.switch_type == "none" or ( me.switch_type == "bool" and me.switch.getBoolValue() ) ) {
				me.output.setDoubleValue( bus_volts );
				return me.load;
			} else if ( me.switch_type == "double" ) {
				me.output.setDoubleValue( bus_volts * me.switch.getDoubleValue() );
				return me.load * me.switch.getDoubleValue();
			} else {
				me.output.setDoubleValue( 0.0 );
				return 0.0;
			}
		} else {
			me.output.setDoubleValue( 0.0 );
			return 0.0;
		}
	},
};
# Consumer with support for integer switches
var consumer_int = {
	new: func( name, switch, load, int, mode ){
		m = { parents : [consumer_int] };
		m.cb = breakers.initNode(name, 1, "BOOL");
		if ( switch.getType() == "INT" ) {
			m.switch = switch;
			m.int = int;
			# Mode: 0 means "=="; 1 means "!="
			if( mode != nil ){
				m.mode = mode;
			} else {
				m.mode = 0;
			}
		} else {
			die("Consumer (int) switch of unsupported type: "~ switch.getType() ~ "!");
		}
		m.output = output.initNode(name, 0.0, "DOUBLE");
		m.load = load;
		return m;
	},
	power: func( bus_volts ){
		if( me.cb.getBoolValue() and bus_volts != 0.0 ){
			if ( ( ( me.mode == 0 and me.switch.getIntValue() == me.int ) or ( me.mode == 1 and me.switch.getIntValue() != me.int ) ) ) {
				me.output.setDoubleValue( bus_volts );
				return me.load;
			} else {
				me.output.setDoubleValue( 0.0 );
				return 0.0;
			}
		} else {
			me.output.setDoubleValue( 0.0 );
			return 0.0;
		}
	},
};


var bus = {
	new: func( name, type, on_update, consumers ) {
		m = { parents : [bus] };
		if( type != "AC" and type != "DC" ){ die("Electrical Bus with incorrect type: "~ type ) }
		m.bus_root = props.globals.initNode("/systems/electrical/" ~ type ~ "/" ~ name ~ "-bus" );
		m.name = name;
		m.volts = m.bus_root.initNode("volts", 0.0, "DOUBLE");
		m.amps = m.bus_root.initNode("amps", 0.0, "DOUBLE");
		m.serviceable = m.bus_root.initNode("serviceable", 1, "BOOL");
		m.on_update = on_update;
		m.bus_volts = 0.0;
		m.consumers = consumers;
		m.ammeter_ave = 0.0;
		return m;
	},
	update_consumers: func () {
		#print("Update consumers of bus "~ me.name);
		load = 0.0;
		foreach( var c; me.consumers ) {
			load += c.power( me.bus_volts );
		}
		return load;
	},
};

