
<div align="center">
    <img style="display: block; border-radius: 9999px;" src="https://github.com/user-attachments/assets/e8fb14f5-ec8e-440e-a2ac-8065322b0e28">
    <h1>Paperize</h1>
  <p align="center"></p>
    <p>Paperize is a dynamic wallpaper changer application designed to keep your device's aesthetic fresh and exciting</p>
</div>


## Features
- **Dynamic Wallpaper Changer**: Set your wallpaper to change at specific time intervals
- **Supports Various Image Types**: Paperize can handle a wide range of image types
  - Including: JPEG, PNG, AVIF, WEBP
- **Folder Support**: Organize your wallpapers into folders for auto-updating
- **Home and Lock Screen Wallpaper**: Choose the same or separate albums for your home screen and lock screen
- **Wallpaper effects**: Change the brightness and the blur of your wallpaper
- **On-Device Storage**: All your wallpapers and settings are stored on your device

 
<div align="center">
    <br/>
      <img src="https://github.com/Anthonyy232/Paperize/assets/60626873/57122f72-78f8-45ed-a9ac-de943061d6a2" width="30%" alt="onboarding" />
      <img src="https://github.com/user-attachments/assets/f054e7f1-d67f-4500-a547-64bccd986bbd" width="30%" alt="wallpaper" />
      <img src="https://github.com/user-attachments/assets/cdf0d989-ae11-44ba-b33c-4aeec6b6116e" width="30%" alt="interval" />
      <img src="https://github.com/Anthonyy232/Paperize/assets/60626873/4ce1b28d-f4b2-4048-a261-203156222263" width="30%" alt="album" />
      <img src="https://github.com/user-attachments/assets/d23f290d-bb2c-4b89-9321-b426e45864f9" width="30%" alt="settings" />
    <br/>
    <video controls src="https://github.com/user-attachments/assets/ce7f5c7c-66a7-45fc-bb28-a53d8d9cf733" muted="true"></video>
</div>


## Download
[<img src="https://github.com/Anthonyy232/Paperize/assets/60626873/1c034414-21cd-4a0a-838d-89fe7bd56910" alt="Download app from GitHub" height="80">](https://github.com/Anthonyy232/Paperize/releases)
[<img src="https://fdroid.gitlab.io/artwork/badge/get-it-on.png" alt="Download app from F-Droid" height="80">](https://f-droid.org/en/packages/com.anthonyla.paperize/)
[<img src="https://gitlab.com/IzzyOnDroid/repo/-/raw/master/assets/IzzyOnDroid.png" alt="Download app from IzzyOnDroid" height="80">](https://apt.izzysoft.de/fdroid/index/apk/com.anthonyla.paperize)

## Localization
I want to allow more people to use the app. Currently, most of the translations are provided using machine translation and AI -- which is not optimal.

I would love some help translating the app! Help me out with that [here](https://crowdin.com/project/paperize/invite?h=d8d7a7513d2beb0c96ba9b2a5f85473e2084922)!

[![Crowdin](https://badges.crowdin.net/paperize/localized.svg)](https://crowdin.com/project/paperize)

## Technologies

- [Kotlin](https://kotlinlang.org/) - A programming language that is used for Android app development
- [Jetpack Compose](https://developer.android.com/develop/ui/compose) - A declarative UI toolkit for building native Android UI
- [Material 3](https://m3.material.io/) - A UI design system git for modern UI guidelines
- [Dagger Hilt](https://dagger.dev/hilt/) - A dependency injection library
- [Room](https://developer.android.com/training/data-storage/room) - A persistence library that provides an abstraction layer over SQLite interfacing with Kotlin
- [AboutLibraries](https://github.com/mikepenz/AboutLibraries) - A library to offer some information of libraries
- [Lottie Compose](https://github.com/airbnb/lottie) - A library that provides Lottie animation support for Jetpack Compose
- [Landscapist](https://github.com/skydoves/landscapist) - A Compose and KPP image loading library that streamlines Glide, Coil, and Fresco
- [Zoomable](https://github.com/usuiat/Zoomable) - A library that provides a zoomable and pannable view, which can be used with any view you want
- [AnimatedFABMenu](https://github.com/rajaumair7890/AnimatedFABMenu) - A animated floating action button with Material 3 design
- [DocumentFileCompat](https://github.com/ItzNotABug/DocumentFileCompat) - A DocumentFile wrapper that caches the result to improve efficiency
- [LazyColumnScrollbar](https://github.com/nanihadesuka/LazyColumnScrollbar) - A Jetpack Compose scrollbar library

Thanks to the creators and maintainers of the open-source libraries used in this project.

## Build

This project is built using Kotlin, Java, and Gradle. Here are the steps to build the project:

### Prerequisites
- Java 8 (1.8)
- Android Studio Jellyfish | 2024.1.1 or later
- Android Gradle Plugin 8.5.1 or later
- Gradle 8.9
- Minimum SDK 26

### Steps
- Open a terminal and run the following git command:  <pre>git clone https://github.com/Anthonyy232/Paperize.git </pre>
- Launch Android Studio and choose Open an existing Android Studio project. Navigate to the cloned repository and select the root folder of the project.
- In Android Studio, click on Build -> Generate Signed Bundle / APK and follow the instructions to generate an APK
- Alternatively, click `▶ Run` and build the app and run it immediately


## Contributions

All contributions to the app is welcome. Feel free to report any issues and create pull requests for any issues or pull requests.

Inspiration from j4velin for their wallpaper changer app

## Donations

If you want to donate, you can do so using GitHub sponsorship (one-time or monthly). I appreciate the thought, thanks!


## License
Contact on my GitHub profile

[Anthony La](https://github.com/Anthonyy232) © GNU GPL v3.0
