/*
 * Copyright (C) 2023 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.google.android.accessibility.braille.brailledisplay.platform.connect.device;

/** Connectable device. */
public abstract class ConnectableDevice {
  private boolean useHid = false;

  /** The name of the connectable device. */
  public abstract String name();

  /** The address of the connectable device. */
  public abstract String address();

  /** Sets use HID protocol or not. */
  public void setUseHid(boolean useHid) {
    this.useHid = useHid;
  }

  /** Returns to use HID protocol or not. */
  public boolean useHid() {
    return useHid;
  }

  /** Returns a string including both the name and address. */
  @Override
  public String toString() {
    return name() + "(" + address() + ")";
  }
}
