/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.android.robotium.solo;

import android.app.Activity;
import android.app.Instrumentation;
import android.view.View;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CheckedTextView;
import android.widget.CompoundButton;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.GridView;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.RadioButton;
import android.widget.ScrollView;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.TimePicker;
import android.widget.ToggleButton;
import com.jayway.android.robotium.solo.ActivityUtils;
import com.jayway.android.robotium.solo.Asserter;
import com.jayway.android.robotium.solo.Checker;
import com.jayway.android.robotium.solo.Clicker;
import com.jayway.android.robotium.solo.DialogUtils;
import com.jayway.android.robotium.solo.Presser;
import com.jayway.android.robotium.solo.RobotiumUtils;
import com.jayway.android.robotium.solo.Scroller;
import com.jayway.android.robotium.solo.Searcher;
import com.jayway.android.robotium.solo.Setter;
import com.jayway.android.robotium.solo.Sleeper;
import com.jayway.android.robotium.solo.TextEnterer;
import com.jayway.android.robotium.solo.ViewFetcher;
import com.jayway.android.robotium.solo.Waiter;
import java.util.ArrayList;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Solo {
    private final Asserter asserter;
    private final ViewFetcher viewFetcher;
    private final Checker checker;
    private final Clicker clicker;
    private final Presser presser;
    private final Searcher searcher;
    private final ActivityUtils activitiyUtils;
    private final DialogUtils dialogUtils;
    private final TextEnterer textEnterer;
    private final Scroller scroller;
    private final RobotiumUtils robotiumUtils;
    private final Sleeper sleeper;
    private final Waiter waiter;
    private final Setter setter;
    private final Instrumentation inst;
    public static final int LANDSCAPE = 0;
    public static final int PORTRAIT = 1;
    public static final int RIGHT = 22;
    public static final int LEFT = 21;
    public static final int UP = 19;
    public static final int DOWN = 20;
    public static final int ENTER = 66;
    public static final int MENU = 82;
    public static final int DELETE = 67;

    public Solo(Instrumentation inst, Activity activity) {
        this.inst = inst;
        this.sleeper = new Sleeper();
        this.activitiyUtils = new ActivityUtils(inst, activity, this.sleeper);
        this.setter = new Setter(this.activitiyUtils);
        this.viewFetcher = new ViewFetcher(inst, this.activitiyUtils, this.sleeper);
        this.asserter = new Asserter(this.activitiyUtils, this.sleeper);
        this.dialogUtils = new DialogUtils(this.viewFetcher, this.sleeper);
        this.scroller = new Scroller(inst, this.activitiyUtils, this.viewFetcher, this.sleeper);
        this.searcher = new Searcher(this.viewFetcher, this.scroller, inst, this.sleeper);
        this.waiter = new Waiter(this.viewFetcher, this.searcher, this.scroller, this.sleeper);
        this.checker = new Checker(this.viewFetcher, this.waiter);
        this.robotiumUtils = new RobotiumUtils(inst, this.sleeper);
        this.clicker = new Clicker(this.viewFetcher, this.scroller, this.robotiumUtils, inst, this.sleeper, this.waiter);
        this.presser = new Presser(this.viewFetcher, this.clicker, inst, this.sleeper);
        this.textEnterer = new TextEnterer(this.activitiyUtils, this.waiter);
    }

    public ArrayList<View> getViews() {
        try {
            return this.viewFetcher.getViews(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ArrayList<View> getViews(View parent) {
        try {
            return this.viewFetcher.getViews(parent);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public View getTopParent(View view) {
        View topParent = this.viewFetcher.getTopParent(view);
        return topParent;
    }

    public void clearEditText(int index) {
        this.waiter.waitForView(EditText.class, index);
        ArrayList<EditText> visibleEditTexts = RobotiumUtils.removeInvisibleViews(this.getCurrentEditTexts());
        if (index > visibleEditTexts.size() - 1) {
            Assert.assertTrue((String)("EditText with index " + index + " is not available!"), (boolean)false);
        }
        this.textEnterer.setEditText(visibleEditTexts.get(index), "");
    }

    public void clearEditText(EditText editText) {
        this.waiter.waitForView(EditText.class, 0);
        this.textEnterer.setEditText(editText, "");
    }

    public boolean waitForText(String text) {
        return this.waiter.waitForText(text);
    }

    public boolean waitForText(String text, int minimumNumberOfMatches, long timeout) {
        return this.waiter.waitForText(text, minimumNumberOfMatches, timeout);
    }

    public boolean waitForText(String text, int minimumNumberOfMatches, long timeout, boolean scroll) {
        return this.waiter.waitForText(text, minimumNumberOfMatches, timeout, scroll);
    }

    public <T extends View> boolean waitForView(Class<T> viewClass, int minimumNumberOfMatches, int timeout) {
        int index = minimumNumberOfMatches - 1;
        if (index < 1) {
            index = 0;
        }
        return this.waiter.waitForView(viewClass, index, timeout, true);
    }

    public <T extends View> boolean waitForView(Class<T> viewClass, int minimumNumberOfMatches, int timeout, boolean scroll) {
        int index = minimumNumberOfMatches - 1;
        if (index < 1) {
            index = 0;
        }
        return this.waiter.waitForView(viewClass, index, timeout, scroll);
    }

    public boolean searchEditText(String text) {
        boolean found = this.searcher.searchWithTimeoutFor(EditText.class, text, 1, true, false);
        return found;
    }

    public boolean searchButton(String text) {
        boolean found = this.searcher.searchWithTimeoutFor(Button.class, text, 0, true, false);
        return found;
    }

    public boolean searchButton(String text, boolean onlyVisible) {
        boolean found = this.searcher.searchWithTimeoutFor(Button.class, text, 0, true, onlyVisible);
        return found;
    }

    public boolean searchToggleButton(String text) {
        boolean found = this.searcher.searchWithTimeoutFor(ToggleButton.class, text, 0, true, false);
        return found;
    }

    public boolean searchButton(String text, int minimumNumberOfMatches) {
        boolean found = this.searcher.searchWithTimeoutFor(Button.class, text, minimumNumberOfMatches, true, false);
        return found;
    }

    public boolean searchButton(String text, int minimumNumberOfMatches, boolean onlyVisible) {
        boolean found = this.searcher.searchWithTimeoutFor(Button.class, text, minimumNumberOfMatches, true, onlyVisible);
        return found;
    }

    public boolean searchToggleButton(String text, int minimumNumberOfMatches) {
        boolean found = this.searcher.searchWithTimeoutFor(ToggleButton.class, text, minimumNumberOfMatches, true, false);
        return found;
    }

    public boolean searchText(String text) {
        boolean found = this.searcher.searchWithTimeoutFor(TextView.class, text, 0, true, false);
        return found;
    }

    public boolean searchText(String text, boolean onlyVisible) {
        boolean found = this.searcher.searchWithTimeoutFor(TextView.class, text, 0, true, onlyVisible);
        return found;
    }

    public boolean searchText(String text, int minimumNumberOfMatches) {
        boolean found = this.searcher.searchWithTimeoutFor(TextView.class, text, minimumNumberOfMatches, true, false);
        return found;
    }

    public boolean searchText(String text, int minimumNumberOfMatches, boolean scroll) {
        return this.searcher.searchWithTimeoutFor(TextView.class, text, minimumNumberOfMatches, scroll, false);
    }

    public boolean searchText(String text, int minimumNumberOfMatches, boolean scroll, boolean onlyVisible) {
        return this.searcher.searchWithTimeoutFor(TextView.class, text, minimumNumberOfMatches, scroll, onlyVisible);
    }

    public void setActivityOrientation(int orientation) {
        this.activitiyUtils.setActivityOrientation(orientation);
    }

    public ArrayList<Activity> getAllOpenedActivities() {
        return this.activitiyUtils.getAllOpenedActivities();
    }

    public Activity getCurrentActivity() {
        Activity activity = this.activitiyUtils.getCurrentActivity();
        return activity;
    }

    public void assertCurrentActivity(String message, String name) {
        this.asserter.assertCurrentActivity(message, name);
    }

    public void assertCurrentActivity(String message, Class expectedClass) {
        this.asserter.assertCurrentActivity(message, expectedClass);
    }

    public void assertCurrentActivity(String message, String name, boolean isNewInstance) {
        this.asserter.assertCurrentActivity(message, name, isNewInstance);
    }

    public void assertCurrentActivity(String message, Class expectedClass, boolean isNewInstance) {
        this.asserter.assertCurrentActivity(message, expectedClass, isNewInstance);
    }

    public void assertMemoryNotLow() {
        this.asserter.assertMemoryNotLow();
    }

    public boolean waitForDialogToClose(long timeout) {
        return this.dialogUtils.waitForDialogToClose(timeout);
    }

    public void goBack() {
        this.robotiumUtils.goBack();
    }

    public void clickOnScreen(float x, float y) {
        this.sleeper.sleep();
        this.inst.waitForIdleSync();
        this.clicker.clickOnScreen(x, y);
    }

    public void clickLongOnScreen(float x, float y) {
        this.clicker.clickLongOnScreen(x, y, 0);
    }

    public void clickLongOnScreen(float x, float y, int time) {
        this.clicker.clickLongOnScreen(x, y, time);
    }

    public void clickOnButton(String name) {
        this.clicker.clickOn(Button.class, name);
    }

    public void clickOnImageButton(int index) {
        this.clicker.clickOn(ImageButton.class, index);
    }

    public void clickOnToggleButton(String name) {
        this.clicker.clickOn(ToggleButton.class, name);
    }

    public void clickOnMenuItem(String text) {
        this.clicker.clickOnMenuItem(text);
    }

    public void clickOnMenuItem(String text, boolean subMenu) {
        this.clicker.clickOnMenuItem(text, subMenu);
    }

    public void pressMenuItem(int index) {
        this.presser.pressMenuItem(index);
    }

    public void pressSpinnerItem(int spinnerIndex, int itemIndex) {
        this.presser.pressSpinnerItem(spinnerIndex, itemIndex);
    }

    public void clickOnView(View view) {
        this.waiter.waitForClickableItems();
        this.clicker.clickOnScreen(view);
    }

    public void clickLongOnView(View view) {
        this.waiter.waitForClickableItems();
        this.clicker.clickOnScreen(view, true, 0);
    }

    public void clickLongOnView(View view, int time) {
        this.waiter.waitForClickableItems();
        this.clicker.clickOnScreen(view, true, time);
    }

    public void clickOnText(String text) {
        this.clicker.clickOnText(text, false, 1, true, 0);
    }

    public void clickOnText(String text, int match) {
        this.clicker.clickOnText(text, false, match, true, 0);
    }

    public void clickOnText(String text, int match, boolean scroll) {
        this.clicker.clickOnText(text, false, match, scroll, 0);
    }

    public void clickLongOnText(String text) {
        this.clicker.clickOnText(text, true, 1, true, 0);
    }

    public void clickLongOnText(String text, int match) {
        this.clicker.clickOnText(text, true, match, true, 0);
    }

    public void clickLongOnText(String text, int match, boolean scroll) {
        this.clicker.clickOnText(text, true, match, scroll, 0);
    }

    public void clickLongOnText(String text, int match, int time) {
        this.clicker.clickOnText(text, true, match, true, time);
    }

    public void clickLongOnTextAndPress(String text, int index) {
        this.clicker.clickLongOnTextAndPress(text, index);
    }

    public void clickOnButton(int index) {
        this.clicker.clickOn(Button.class, index);
    }

    public void clickOnRadioButton(int index) {
        this.clicker.clickOn(RadioButton.class, index);
    }

    public void clickOnCheckBox(int index) {
        this.clicker.clickOn(CheckBox.class, index);
    }

    public void clickOnEditText(int index) {
        this.clicker.clickOn(EditText.class, index);
    }

    public ArrayList<TextView> clickInList(int line) {
        return this.clicker.clickInList(line);
    }

    public ArrayList<TextView> clickInList(int line, int listIndex) {
        return this.clicker.clickInList(line, listIndex);
    }

    public void drag(float fromX, float toX, float fromY, float toY, int stepCount) {
        this.scroller.drag(fromX, toX, fromY, toY, stepCount);
    }

    public boolean scrollDown() {
        this.waiter.waitForViews(ListView.class, ScrollView.class);
        return this.scroller.scroll(Scroller.Direction.DOWN);
    }

    public boolean scrollUp() {
        this.waiter.waitForViews(ListView.class, ScrollView.class);
        return this.scroller.scroll(Scroller.Direction.UP);
    }

    public boolean scrollDownList(int listIndex) {
        return this.scroller.scrollList(listIndex, Scroller.Direction.DOWN, null);
    }

    public boolean scrollUpList(int listIndex) {
        return this.scroller.scrollList(listIndex, Scroller.Direction.UP, null);
    }

    public void scrollToSide(int side) {
        switch (side) {
            case 22: {
                this.scroller.scrollToSide(Scroller.Side.RIGHT);
                break;
            }
            case 21: {
                this.scroller.scrollToSide(Scroller.Side.LEFT);
            }
        }
    }

    public void setDatePicker(int index, int year, int monthOfYear, int dayOfMonth) {
        this.waiter.waitForView(DatePicker.class, index);
        ArrayList<DatePicker> visibleDatePickers = RobotiumUtils.removeInvisibleViews(this.getCurrentDatePickers());
        if (index > visibleDatePickers.size() - 1) {
            Assert.assertTrue((String)("DatePicker with index " + index + " is not available!"), (boolean)false);
        }
        this.setter.setDatePicker(visibleDatePickers.get(index), year, monthOfYear, dayOfMonth);
    }

    public void setDatePicker(DatePicker datePicker, int year, int monthOfYear, int dayOfMonth) {
        this.waiter.waitForView(DatePicker.class, 0);
        this.setter.setDatePicker(datePicker, year, monthOfYear, dayOfMonth);
    }

    public void setTimePicker(int index, int hour, int minute) {
        this.waiter.waitForView(TimePicker.class, index);
        ArrayList<TimePicker> visibleTimePickers = RobotiumUtils.removeInvisibleViews(this.getCurrentTimePickers());
        if (index > visibleTimePickers.size() - 1) {
            Assert.assertTrue((String)("TimePicker with index " + index + " is not available!"), (boolean)false);
        }
        this.setter.setTimePicker(visibleTimePickers.get(index), hour, minute);
    }

    public void setTimePicker(TimePicker timePicker, int hour, int minute) {
        this.waiter.waitForView(TimePicker.class, 0);
        this.setter.setTimePicker(timePicker, hour, minute);
    }

    public void setProgressBar(int index, int progress) {
        this.waiter.waitForView(ProgressBar.class, index);
        ArrayList<ProgressBar> visibleProgressBars = RobotiumUtils.removeInvisibleViews(this.getCurrentProgressBars());
        if (index > visibleProgressBars.size() - 1) {
            Assert.assertTrue((String)("ProgressBar with index " + index + " is not available!"), (boolean)false);
        }
        this.setter.setProgressBar(visibleProgressBars.get(index), progress);
    }

    public void setProgressBar(ProgressBar progressBar, int progress) {
        this.waiter.waitForView(ProgressBar.class, 0);
        this.setter.setProgressBar(progressBar, progress);
    }

    public void enterText(int index, String text) {
        this.waiter.waitForView(EditText.class, index);
        ArrayList<EditText> visibleEditTexts = RobotiumUtils.removeInvisibleViews(this.getCurrentEditTexts());
        if (index > visibleEditTexts.size() - 1) {
            Assert.assertTrue((String)("EditText with index " + index + " is not available!"), (boolean)false);
        }
        this.textEnterer.setEditText(visibleEditTexts.get(index), text);
    }

    public void enterText(EditText editText, String text) {
        this.waiter.waitForView(EditText.class, 0);
        this.textEnterer.setEditText(editText, text);
    }

    public void clickOnImage(int index) {
        this.clicker.clickOn(ImageView.class, index);
    }

    public ArrayList<ImageView> getCurrentImageViews() {
        return this.viewFetcher.getCurrentViews(ImageView.class);
    }

    public EditText getEditText(int index) {
        EditText editText = this.viewFetcher.getView(EditText.class, index);
        return editText;
    }

    public Button getButton(int index) {
        Button button = this.viewFetcher.getView(Button.class, index);
        return button;
    }

    public TextView getText(int index) {
        return this.viewFetcher.getView(TextView.class, index);
    }

    public ImageView getImage(int index) {
        return this.viewFetcher.getView(ImageView.class, index);
    }

    public ImageButton getImageButton(int index) {
        return this.viewFetcher.getView(ImageButton.class, index);
    }

    public TextView getText(String text) {
        return this.viewFetcher.getView(TextView.class, text);
    }

    public Button getButton(String text) {
        return this.viewFetcher.getView(Button.class, text);
    }

    public EditText getEditText(String text) {
        return this.viewFetcher.getView(EditText.class, text);
    }

    public View getView(int id) {
        return this.viewFetcher.getView(id);
    }

    public ArrayList<EditText> getCurrentEditTexts() {
        return this.viewFetcher.getCurrentViews(EditText.class);
    }

    public ArrayList<ListView> getCurrentListViews() {
        return this.viewFetcher.getCurrentViews(ListView.class);
    }

    public ArrayList<ScrollView> getCurrentScrollViews() {
        return this.viewFetcher.getCurrentViews(ScrollView.class);
    }

    public ArrayList<Spinner> getCurrentSpinners() {
        return this.viewFetcher.getCurrentViews(Spinner.class);
    }

    public ArrayList<TextView> getCurrentTextViews(View parent) {
        return this.viewFetcher.getCurrentViews(TextView.class, parent);
    }

    public ArrayList<GridView> getCurrentGridViews() {
        return this.viewFetcher.getCurrentViews(GridView.class);
    }

    public ArrayList<Button> getCurrentButtons() {
        return this.viewFetcher.getCurrentViews(Button.class);
    }

    public ArrayList<ToggleButton> getCurrentToggleButtons() {
        return this.viewFetcher.getCurrentViews(ToggleButton.class);
    }

    public ArrayList<RadioButton> getCurrentRadioButtons() {
        return this.viewFetcher.getCurrentViews(RadioButton.class);
    }

    public ArrayList<CheckBox> getCurrentCheckBoxes() {
        return this.viewFetcher.getCurrentViews(CheckBox.class);
    }

    public ArrayList<ImageButton> getCurrentImageButtons() {
        return this.viewFetcher.getCurrentViews(ImageButton.class);
    }

    public ArrayList<DatePicker> getCurrentDatePickers() {
        return this.viewFetcher.getCurrentViews(DatePicker.class);
    }

    public ArrayList<TimePicker> getCurrentTimePickers() {
        return this.viewFetcher.getCurrentViews(TimePicker.class);
    }

    public ArrayList<ProgressBar> getCurrentProgressBars() {
        return this.viewFetcher.getCurrentViews(ProgressBar.class);
    }

    public boolean isRadioButtonChecked(int index) {
        return this.checker.isButtonChecked(RadioButton.class, index);
    }

    public boolean isRadioButtonChecked(String text) {
        return this.checker.isButtonChecked(RadioButton.class, text);
    }

    public boolean isCheckBoxChecked(int index) {
        return this.checker.isButtonChecked(CheckBox.class, index);
    }

    public boolean isToggleButtonChecked(String text) {
        return this.checker.isButtonChecked(ToggleButton.class, text);
    }

    public boolean isToggleButtonChecked(int index) {
        return this.checker.isButtonChecked(ToggleButton.class, index);
    }

    public boolean isCheckBoxChecked(String text) {
        return this.checker.isButtonChecked(CheckBox.class, text);
    }

    public boolean isTextChecked(String text) {
        this.waiter.waitForViews(CheckedTextView.class, CompoundButton.class);
        if (this.viewFetcher.getCurrentViews(CheckedTextView.class).size() > 0 && this.checker.isCheckedTextChecked(text)) {
            return true;
        }
        return this.viewFetcher.getCurrentViews(CompoundButton.class).size() > 0 && this.checker.isButtonChecked(CompoundButton.class, text);
    }

    public boolean isSpinnerTextSelected(String text) {
        return this.checker.isSpinnerTextSelected(text);
    }

    public boolean isSpinnerTextSelected(int index, String text) {
        return this.checker.isSpinnerTextSelected(index, text);
    }

    public void sendKey(int key) {
        switch (key) {
            case 22: {
                this.robotiumUtils.sendKeyCode(22);
                break;
            }
            case 21: {
                this.robotiumUtils.sendKeyCode(21);
                break;
            }
            case 19: {
                this.robotiumUtils.sendKeyCode(19);
                break;
            }
            case 20: {
                this.robotiumUtils.sendKeyCode(20);
                break;
            }
            case 66: {
                this.robotiumUtils.sendKeyCode(66);
                break;
            }
            case 82: {
                this.robotiumUtils.sendKeyCode(82);
                break;
            }
            case 67: {
                this.robotiumUtils.sendKeyCode(67);
                break;
            }
        }
    }

    public void goBackToActivity(String name) {
        this.activitiyUtils.goBackToActivity(name);
    }

    public boolean waitForActivity(String name, int timeout) {
        return this.activitiyUtils.waitForActivity(name, timeout);
    }

    public String getString(int resId) {
        return this.activitiyUtils.getString(resId);
    }

    public void sleep(int time) {
        this.sleeper.sleep(time);
    }

    public void finalize() throws Throwable {
        this.activitiyUtils.finalize();
    }
}

