/*
 This file is part of AdGuard Content Blocker (https://github.com/AdguardTeam/ContentBlocker).
 Copyright © 2018 AdGuard Content Blocker. All rights reserved.

 AdGuard Content Blocker is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by the
 Free Software Foundation, either version 3 of the License, or (at your option)
 any later version.

 AdGuard Content Blocker is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 AdGuard Content Blocker.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.adguard.android.contentblocker.ui;

import android.os.Bundle;

import androidx.appcompat.app.AppCompatActivity;

import com.adguard.android.contentblocker.R;
import com.adguard.android.contentblocker.ui.utils.ActivityUtils;

public class NoBrowsersFoundActivity extends AppCompatActivity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_no_browsers_found);

        findViewById(R.id.install_samsung_browser).setOnClickListener(v -> {
            ActivityUtils.startMarket(NoBrowsersFoundActivity.this, "com.sec.android.app.sbrowser", null);
            finish();
        });

        findViewById(R.id.install_yandex_browser).setOnClickListener(v -> {
            ActivityUtils.startMarket(NoBrowsersFoundActivity.this, "com.yandex.browser", "adguard1");
            finish();
        });
    }
}
