/*
 This file is part of AdGuard Content Blocker (https://github.com/AdguardTeam/ContentBlocker).
 Copyright © 2018 AdGuard Content Blocker. All rights reserved.

 AdGuard Content Blocker is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by the
 Free Software Foundation, either version 3 of the License, or (at your option)
 any later version.

 AdGuard Content Blocker is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 AdGuard Content Blocker.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.adguard.android.contentblocker.service;

import java.util.Date;
import java.util.Set;

/**
 * Service that stores application preferences
 */
public interface PreferencesService {

    String KEY_AUTOUPDATE_FILTERS = "auto_update_filters";
    String KEY_UPDATE_OVER_WIFI = "update_over_wifi";
    String KEY_LAST_UPDATE_CHECK_DATE = "last_update_check_date";
    String KEY_LAST_IMPORT_URL = "key_last_import_rule";
    String KEY_FILTER_RULE_COUNT = "key_filter_rule_count";
    String KEY_ONBOARDING_SHOWN = "key_onboarding_shown";
    String KEY_USER_RULES_STRING = "key_user_rules_string";
    String KEY_DISABLED_USER_RULES = "key_disabled_user_rules";
    String KEY_WHITELIST_STRING = "key_whitelist_string";
    String KEY_DISABLED_WHITELIST = "key_disabled_whitelist";
    String KEY_INSTALLATION_TIME = "key_installation_time";
    String KEY_APP_RATED = "key_app_rated";
    String KEY_RATE_APP_DIALOG_COUNT = "key_rate_app_dialog_count";

    /**
     * @return true if filters autoupdate is enabled
     */
    boolean isAutoUpdateFilters();

    /**
     * @param value true if filters autoupdate is enabled
     */
    void setAutoUpdateFilters(boolean value);

    /**
     * @return true if update over wifi only is enabled
     */
    boolean isUpdateOverWifiOnly();

    /**
     * @param value true if update over wifi only is enabled
     */
    void setUpdateOverWifiOnly(boolean value);

    /**
     * @return True if we have shown the onboarding screen
     */
    boolean isOnboardingShown();

    /**
     * Save the flag determining that we have shown onboarding screen
     *
     * @param value True if shown
     */
    void setOnboardingShown(boolean value);

    /**
     * @return Whitelisted domains
     */
    String getWhitelist();

    /**
     * @param whitelist Whitelist contents
     */
    void setWhitelist(String whitelist);

    /**
     * @return Set with disabled whitelist rules
     */
    Set<String> getDisabledWhitelistRules();

    /**
     * @param disabledWhitelistRules Set with disabled whitelist rules
     */
    void setDisabledWhitelistRules(Set<String> disabledWhitelistRules);

    /**
     * @return User filter rules
     */
    String getUserRules();

    /**
     * Set user filter text
     *
     * @param userRules user rules
     */
    void setUserRuleItems(String userRules);

    /**
     * @return Set with disabled user rules
     */
    Set<String> getDisabledUserRules();

    /**
     * @param disabledUserRules Set with disabled user rules
     */
    void setDisabledUserRules(Set<String> disabledUserRules);

    /**
     * @param time Last time updates where checked
     */
    void setLastUpdateCheck(long time);

    /**
     * @return Last time updates where checked
     */
    Date getLastUpdateCheck();

    /**
     * Gets url from which user imported his rules
     *
     * @return last imported url
     */
    String getLastImportUrl();

    /**
     * Saves url from which user imported his rules
     *
     * @param url last url from which user has imported some rules
     */
    void setLastImportUrl(String url);

    /**
     * Sets filter rules count
     *
     * @param ruleCount Filter rules count
     */
    void setFilterRuleCount(int ruleCount);

    /**
     * @return Filter rules count
     */
    int getFilterRuleCount();

    /**
     * @return Installation time
     */
    Long getInstallationTime();

    /**
     * @param installationTime Installation time in millis
     */
    void setInstallationTime(Long installationTime);

    /**
     * @return {@code True} if user already rate app
     */
    boolean isAppRated();

    /**
     * @param appRated {@code True} if user already rate app
     */
    void setAppRated(boolean appRated);

    /**
     * @return Count of 'Rate app' dialog shows
     */
    int getRateAppDialogCount();

    /**
     * Increases count of 'Rate app' dialog shows
     */
    void increaseRateAppDialogCount();
}
