/*
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 */

import 'package:clima/l10n/app_localizations.dart';
import 'package:clima/ui/pages/settings_page.dart';
import 'package:clima/ui/widgets/dialogs/help_and_feedback_dialog.dart';
import 'package:flutter/material.dart';

class OverflowMenuButton extends StatelessWidget {
  const OverflowMenuButton({super.key});

  @override
  Widget build(BuildContext context) {
    final appLocalizations = AppLocalizations.of(context);

    return PopupMenuButton<void>(
      shape: RoundedRectangleBorder(
        borderRadius: BorderRadius.circular(5.0),
      ),
      icon: Icon(
        Icons.more_vert,
        color: Theme.of(context).appBarTheme.iconTheme!.color,
      ),
      tooltip: appLocalizations.moreOptionsButtonTooltip,
      itemBuilder: (context) => [
        PopupMenuItem(
          child: Text(appLocalizations.settings),
          onTap: () {
            Navigator.push(
              context,
              MaterialPageRoute<void>(
                builder: (context) => const SettingsPage(),
              ),
            );
          },
        ),
        PopupMenuItem(
          child: Text(appLocalizations.helpAndFeedback),
          onTap: () {
            showDialog<void>(
              context: context,
              builder: (context) => const HelpAndFeedbackDialog(),
            );
          },
        ),
      ],
    );
  }
}
