/*
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 */

import 'package:clima/core/failure.dart';
import 'package:clima/l10n/app_localizations.dart';
import 'package:clima/ui/utilities/constants.dart';
import 'package:flutter/material.dart';
import 'package:flutter_hooks/flutter_hooks.dart';
import 'package:sizer/sizer.dart';

class FailureBanner extends HookWidget {
  const FailureBanner({
    required this.onRetry,
    required this.failure,
    super.key,
  });

  final void Function() onRetry;

  final Failure failure;

  @override
  Widget build(BuildContext context) {
    final appLocalizations = AppLocalizations.of(context);

    return MaterialBanner(
      forceActionsBelow: true,
      content: Text(
        switch (failure) {
          NoConnection _ => appLocalizations.weather_failureBanner_noConnection,
          FailedToParseResponse _ =>
            appLocalizations.weather_failureBanner_failedToParseResponse,
          ServerDown _ => appLocalizations.weather_failureBanner_serverDown,
          InvalidCityName _ =>
            appLocalizations.weather_failureBanner_invalidCityName,
          ServerError(:final reason?) =>
            appLocalizations.weather_failureBanner_serverError(reason),
          ServerError _ =>
            appLocalizations.weather_failureBanner_serverErrorUnspecified,
        },
        style: TextStyle(
          fontSize: MediaQuery.of(context).size.shortestSide < kTabletBreakpoint
              ? 13.sp
              : 7.sp,
        ),
      ),
      actions: [
        TextButton(
          onPressed: onRetry,
          child: Text(
            appLocalizations.retryButtonLabel,
            style: TextStyle(
              color: Theme.of(context).colorScheme.secondary,
            ),
          ),
        ),
      ],
    );
  }
}
