/*
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 */

import 'package:clima/data/models/theme_model.dart';
import 'package:clima/l10n/app_localizations.dart';
import 'package:clima/ui/state_notifiers/theme_state_notifier.dart';
import 'package:clima/ui/utilities/radio_dialog.dart';
import 'package:flutter/material.dart';
import 'package:flutter_riverpod/flutter_riverpod.dart';

class ThemeDialog extends ConsumerWidget {
  const ThemeDialog({super.key});

  @override
  Widget build(BuildContext context, WidgetRef ref) {
    final appLocalizations = AppLocalizations.of(context);

    final themeStateNotifier = ref.watch(themeStateNotifierProvider.notifier);
    final theme = ref.watch(
      themeStateNotifierProvider.select((state) => state.theme),
    );

    return RadioDialog<ThemeModel>(
      title: appLocalizations.settings_theme,
      options: {
        ThemeModel.systemDefault: appLocalizations.settings_theme_systemDefault,
        ThemeModel.light: appLocalizations.settings_theme_light,
        ThemeModel.dark: appLocalizations.settings_theme_dark,
      },
      currentValue: theme,
      onChanged: themeStateNotifier.setTheme,
    );
  }
}
