/*
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 */

import 'package:clima/data/models/dark_theme_model.dart';
import 'package:clima/l10n/app_localizations.dart';
import 'package:clima/ui/state_notifiers/theme_state_notifier.dart';
import 'package:clima/ui/utilities/radio_dialog.dart';
import 'package:flutter/material.dart';
import 'package:flutter_riverpod/flutter_riverpod.dart';

class DarkThemeDialog extends ConsumerWidget {
  const DarkThemeDialog({super.key});

  @override
  Widget build(BuildContext context, WidgetRef ref) {
    final appLocalizations = AppLocalizations.of(context);
    final themeStateNotifier = ref.watch(themeStateNotifierProvider.notifier);
    final darkTheme = ref.watch(
      themeStateNotifierProvider.select((state) => state.darkTheme),
    );

    return RadioDialog<DarkThemeModel>(
      title: appLocalizations.settings_darkTheme,
      options: {
        DarkThemeModel.darkGrey: appLocalizations.settings_darkTheme_default,
        DarkThemeModel.black: appLocalizations.settings_darkTheme_black,
      },
      currentValue: darkTheme,
      onChanged: themeStateNotifier.setDarkTheme,
    );
  }
}
