/*
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 */

import 'package:clima/ui/themes/clima_theme.dart';
import 'package:flutter/material.dart';
import 'package:sizer/sizer.dart';

import 'constants.dart';

Future<void> showGeneralSheet(
  BuildContext context, {
  required Widget child,
  required String title,
}) =>
    showModalBottomSheet(
      backgroundColor: Theme.of(context).dialogBackgroundColor,
      useRootNavigator: true,
      isScrollControlled: true,
      shape: const RoundedRectangleBorder(
        borderRadius: BorderRadius.only(
          topLeft: Radius.circular(8.0),
          topRight: Radius.circular(8.0),
        ),
      ),
      elevation: 2,
      context: context,
      builder: (context) => Column(
        mainAxisSize: MainAxisSize.min,
        children: [
          Container(
            height: 0.5.h,
            width: MediaQuery.of(context).size.shortestSide < kTabletBreakpoint
                ? 8.w
                : 4.h,
            margin: EdgeInsetsDirectional.only(top: 2.h),
            decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(2.0),
              color: ClimaTheme.of(context).sheetPillColor,
            ),
          ),
          Padding(
            padding: EdgeInsetsDirectional.symmetric(
              vertical: 2.h,
              horizontal: 12.w,
            ),
            child: Text(
              title,
              style: kSubtitle1TextStyle(context),
              textAlign: TextAlign.center,
            ),
          ),
          Divider(
            color:
                Theme.of(context).textTheme.titleMedium!.color!.withAlpha(65),
          ),
          Flexible(
            child: SingleChildScrollView(child: child),
          ),
        ],
      ),
    );
