/*
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 */

import 'package:clima/domain/entities/unit_system.dart';
import 'package:equatable/equatable.dart';

class UnitSystemModel extends Equatable {
  const UnitSystemModel(this.unitSystem);

  factory UnitSystemModel.parse(String string) => UnitSystemModel(
        switch (string) {
          'metric' => UnitSystem.metric,
          'imperial' => UnitSystem.imperial,
          _ => throw ArgumentError(),
        },
      );

  final UnitSystem unitSystem;

  @override
  String toString() => switch (unitSystem) {
        UnitSystem.metric => 'metric',
        UnitSystem.imperial => 'imperial',
      };

  @override
  List<Object?> get props => [unitSystem];
}
