/*
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 */

import 'package:clima/domain/entities/city.dart';
import 'package:equatable/equatable.dart';

class CityModel extends Equatable {
  const CityModel(this.city);

  factory CityModel.fromJson(
    Map<String, dynamic> result, {
    required String language,
  }) =>
      CityModel(
        City(
          name: result['name'] as String,
          id: result['id'] as int,
          language: language,
          long: (result['longitude'] as num).toDouble(),
          lat: (result['latitude'] as num).toDouble(),
        ),
      );

  final City city;

  @override
  List<Object?> get props => [city];
}
