extension Let<X> on X {
  /// Call `f` on this object. The main purpose is to make handling `null`s
  /// easier.
  ///
  /// Example:
  /// ```dart
  /// number?.toDouble()?.let((n) => n / 20)
  /// ```
  T2 let<T2>(T2 Function(X) f) => f(this);
}
