/*
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 */

import 'package:equatable/equatable.dart';

sealed class Failure extends Equatable {
  const Failure();
}

class NoConnection extends Failure {
  const NoConnection();

  @override
  List<Object?> get props => const [];
}

class ServerError extends Failure {
  const ServerError({required this.reason});

  final String? reason;

  @override
  List<Object?> get props => [reason];
}

class ServerDown extends Failure {
  const ServerDown();

  @override
  List<Object?> get props => const [];
}

class FailedToParseResponse extends Failure {
  const FailedToParseResponse();

  @override
  List<Object?> get props => const [];
}

class InvalidCityName extends Failure {
  const InvalidCityName(this.cityName);

  final String cityName;

  @override
  List<Object?> get props => [cityName];
}
