/*
 * Copyright (c) 2017 Carmen Alvarez
 *
 * This file is part of Poet Assistant.
 *
 * Poet Assistant is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Poet Assistant is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Poet Assistant.  If not, see <http://www.gnu.org/licenses/>.
 */

package ca.rmen.android.poetassistant

/**
 * Run background and foreground tasks directly in the same thread, blocking.
 */
class JunitThreading : Threading {
    override fun executeForeground(delayMs: Long, body: () -> Unit) : Threading.Cancelable {
        body.invoke()
        return NoOpCancelable()
    }

    override fun <T> execute(backgroundTask: () -> T, foregroundTask: ((T) -> Unit)?, errorTask: ((Throwable) -> Unit)?) {
        try {
            val result = backgroundTask.invoke()
            foregroundTask?.invoke(result)
        } catch (t: Throwable) {
            errorTask?.invoke(t)
        }
    }

    private class NoOpCancelable : Threading.Cancelable {
        override fun cancel() {
        }
    }
}