// Copyright 2020 Kenton Hamaluik
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

import 'package:bloc/bloc.dart';
import 'package:equatable/equatable.dart';
import 'package:flutter/widgets.dart';
import 'package:timecop/data_providers/settings/settings_provider.dart';

part 'locale_event.dart';
part 'locale_state.dart';

class LocaleBloc extends Bloc<LocaleEvent, LocaleState> {
  final SettingsProvider settings;
  LocaleBloc(this.settings) : super(const LocaleState(null)) {
    on<LoadLocaleEvent>((event, emit) {
      emit(LocaleState(settings.getLocale()));
    });
    on<ChangeLocaleEvent>((event, emit) {
      settings.setLocale(event.locale);
      emit(LocaleState(event.locale));
    });
  }
}
