package ca.chancehorizon.paseo

import android.app.PendingIntent
import android.appwidget.AppWidgetManager
import android.appwidget.AppWidgetProvider
import android.content.ComponentName
import android.content.Context
import android.content.Intent
import android.os.Build
import android.widget.RemoteViews

import java.text.NumberFormat
import java.text.SimpleDateFormat
import java.util.*


/**
 * Implementation of App Widget functionality.
 */
class PaseoStepsWidget : AppWidgetProvider() {

    override fun onUpdate(context: Context, appWidgetManager: AppWidgetManager, appWidgetIds: IntArray) {
        // There may be multiple widgets active, so update all of them
        for (appWidgetId in appWidgetIds) {
            updateAppWidget(context, appWidgetManager, appWidgetId)
        }
    }

    override fun onReceive(context: Context?, intent: Intent?) {
        super.onReceive(context, intent)
    }


    override fun onEnabled(context: Context) {
        // Enter relevant functionality for when the first widget is created
    }

    override fun onDisabled(context: Context) {
        // Enter relevant functionality for when the last widget is disabled
    }

    companion object {

        lateinit var paseoDBHelper : PaseoDBHelper



        internal fun updateAppWidget(context: Context, appWidgetManager: AppWidgetManager,
                                     appWidgetId: Int) {

            // Create an Intent to launch MainActivity
            val intent = Intent(context, MainActivity::class.java)

            val pendingIntent =
                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.S) {
                        PendingIntent.getBroadcast(context, 0, intent, PendingIntent.FLAG_UPDATE_CURRENT or PendingIntent.FLAG_MUTABLE)
                    }
                    else
                    {
                        PendingIntent.getBroadcast(context, 0, intent, PendingIntent.FLAG_UPDATE_CURRENT)
                    }

            // retrieve today's step total to show in the widget
            val dateFormat = SimpleDateFormat("yyyyMMdd", Locale.getDefault()) // looks like "19891225"
            val today = dateFormat.format(Date()).toInt()

            var theSteps = 0
            if (::paseoDBHelper.isInitialized) {
                theSteps = paseoDBHelper.getDaysSteps(today)
            }

            // Construct the RemoteViews object
            val views = RemoteViews(context.packageName, R.layout.paseo_steps_widget)
            views.setTextViewText(R.id.stepwidget_text, "" + NumberFormat.getIntegerInstance().format(theSteps))
            views.setOnClickPendingIntent(R.id.stepwidget_text, pendingIntent)

            // Instruct the widget manager to update the widget
            appWidgetManager.updateAppWidget(appWidgetId, views)
        }
    }
}

