# Mindful Attention Awareness Scale (MAAS)
_Find out how mindful you are on a scale of 1 to 6._

## Screenshots

<p float="center">
  <img src="https://github.com/vbresan/MindfulAttentionAwarenessScale/blob/master/metadata/en-US/images/phoneScreenshots/1.png" width="20%" alt="Screenshot about the scale" title="Screenshot about the scale" />
  <img src="https://github.com/vbresan/MindfulAttentionAwarenessScale/blob/master/metadata/en-US/images/phoneScreenshots/2.png" width="20%" alt="Screenshot pre-test" title="Screenshot pre-test" />
  <img src="https://github.com/vbresan/MindfulAttentionAwarenessScale/blob/master/metadata/en-US/images/phoneScreenshots/4.png" width="20%" alt="Screenshot test results" title="Screenshot test results" />
  <img src="https://github.com/vbresan/MindfulAttentionAwarenessScale/blob/master/metadata/en-US/images/phoneScreenshots/3.png" width="60%" alt="Screenshot question sample" title="Screenshot question sample" />
</p>

## About

The MAAS is a 15-item scale designed to assess a core characteristic of dispositional mindfulness, namely, open or receptive awareness of and attention to what is taking place in the present.

The scale shows strong psychometric properties and has been validated with college, community, and cancer patient samples.

Correlational, quasi-experimental, and laboratory studies have shown that the MAAS taps a unique quality of consciousness that is related to, and predictive of, a variety of self-regulation and well-being constructs.

The measure takes 10 minutes or less to complete.

Reference:
Brown, K.W. & Ryan, R.M. (2003). The benefits of being present: Mindfulness and its role in psychological well-being. Journal of Personality and Social Psychology, 84, 822-848.

## Get it on ...

[<img src="https://fdroid.gitlab.io/artwork/badge/get-it-on.png" alt="Get it on F-Droid" height="80">](https://f-droid.org/packages/biz.binarysolutions.mindfulscale/)
[<img src="https://gitlab.com/IzzyOnDroid/repo/-/raw/master/assets/IzzyOnDroid.png" alt="Get it on IzzyOnDroid" height="80">](https://apt.izzysoft.de/fdroid/index/apk/biz.binarysolutions.mindfulscale)
[<img src="https://raw.githubusercontent.com/andOTP/andOTP/master/assets/badges/get-it-on-github.png" alt="Get it on GitHub" height="80">](https://github.com/vbresan/MindfulAttentionAwarenessScale/releases/latest)
[<img src="https://play.google.com/intl/en_us/badges/images/generic/en-play-badge.png" alt="Get it on Google Play" height="80">](https://play.google.com/store/apps/details?id=biz.binarysolutions.mindfulscale)

## Support and contributions

Open-source projects often struggle to be financially sustainable. You are more than welcome to sponsor the project by donating via [Ko-fi](https://ko-fi.com/vbresan) or [Liberapay](https://liberapay.com/vbresan). Such support can help ensure the continued development of this app.

If you like the app, you can show your support by starring the repository and joining the [stargazers](https://github.com/vbresan/MindfulAttentionAwarenessScale/stargazers)!

If you would like to get directly involved in the project, you can contribute by providing a translation.

### Translations

Translations are managed through [Weblate](https://weblate.org). App string resources are available in [app-main](https://hosted.weblate.org/projects/mindful-attention-awareness-scale/app-main/) and [app-withoutads](https://hosted.weblate.org/projects/mindful-attention-awareness-scale/app-withoutads/) components, while [metadata](https://hosted.weblate.org/projects/mindful-attention-awareness-scale/metadata/) component contains the app description and other details. You can log in to Weblate with your GitHub account. *(When your Weblate and GitHub accounts are connected, and your contributions are merged into the main branch, you will be shown in the GitHub [Contributors](https://github.com/vbresan/MindfulAttentionAwarenessScale/graphs/contributors) sidebar.)*

Your contributions are greatly appreciated.

#### Current translation status

![Bar chart with current translation status](https://camo.githubusercontent.com/66b5dca96350ef5b2a85fa802d2b9a3b0fa8ce1a75e95bfe73495eea3f8fcd56/68747470733a2f2f686f737465642e7765626c6174652e6f72672f7769646765742f6d696e6466756c2d617474656e74696f6e2d61776172656e6573732d7363616c652f6170702d6d61696e2f686f72697a6f6e74616c2d6175746f2e737667 "Current translation status")

#### Notes to translators

When translating app string resources:
* For context, please refer to the provided screenshots.

When translating metadata:
* It's not necessary to translate changelogs related to app releases made before your language was added.

#### Translators

Big thanks to:
* French - **[Ponj](https://github.com/p6nj)**
* Spanish - **[Kamborio](https://github.com/Kamborio)**, gallegonovato
* Tamil - **[தமிழ் நேரம்](https://github.com/TamilNeram)**
