/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import net.fortuna.ical4j.model.CalendarDateFormatFactory;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.Time;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.util.CompatibilityHints;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class DateTime
extends Date {
    private static final long serialVersionUID = -6407231357919440387L;
    private static final String DEFAULT_PATTERN = "yyyyMMdd'T'HHmmss";
    private static final String UTC_PATTERN = "yyyyMMdd'T'HHmmss'Z'";
    private static final String RELAXED_PATTERN = "yyyyMMdd";
    private static final ThreadLocal UTC_FORMAT = new ThreadLocal(){

        protected Object initialValue() {
            SimpleDateFormat format = new SimpleDateFormat(DateTime.UTC_PATTERN);
            format.setTimeZone(TimeZone.getTimeZone("Etc/UTC"));
            format.setLenient(false);
            return format;
        }
    };
    private static final ThreadLocal DEFAULT_FORMAT = new ThreadLocal(){

        protected Object initialValue() {
            SimpleDateFormat format = new SimpleDateFormat(DateTime.DEFAULT_PATTERN);
            format.setLenient(false);
            return format;
        }
    };
    private static final ThreadLocal LENIENT_DEFAULT_FORMAT = new ThreadLocal(){

        protected Object initialValue() {
            return new SimpleDateFormat(DateTime.DEFAULT_PATTERN);
        }
    };
    private static final ThreadLocal RELAXED_FORMAT = new ThreadLocal(){

        protected Object initialValue() {
            return new SimpleDateFormat(DateTime.RELAXED_PATTERN);
        }
    };
    private Time time;
    private TimeZone timezone;

    public DateTime() {
        super(0, java.util.TimeZone.getDefault());
        this.time = new Time(System.currentTimeMillis(), this.getFormat().getTimeZone());
    }

    public DateTime(boolean utc) {
        this();
        this.setUtc(utc);
    }

    public DateTime(long time) {
        super(time, 0, java.util.TimeZone.getDefault());
        this.time = new Time(time, this.getFormat().getTimeZone());
    }

    public DateTime(java.util.Date date) {
        super(date.getTime(), 0, java.util.TimeZone.getDefault());
        this.time = new Time(date.getTime(), this.getFormat().getTimeZone());
        if (date instanceof DateTime) {
            DateTime dateTime = (DateTime)date;
            if (dateTime.isUtc()) {
                this.setUtc(true);
            } else {
                this.setTimeZone(dateTime.getTimeZone());
            }
        }
    }

    public DateTime(String value) throws ParseException {
        this(value, (TimeZone)null);
    }

    public DateTime(String value, TimeZone timezone) throws ParseException {
        super(0, timezone != null ? timezone : java.util.TimeZone.getDefault());
        this.time = new Time(System.currentTimeMillis(), this.getFormat().getTimeZone());
        try {
            this.setTime(value, (DateFormat)UTC_FORMAT.get(), null);
            this.setUtc(true);
        }
        catch (ParseException pe) {
            block7: {
                try {
                    if (timezone != null) {
                        this.setTime(value, (DateFormat)DEFAULT_FORMAT.get(), timezone);
                    } else {
                        this.setTime(value, (DateFormat)LENIENT_DEFAULT_FORMAT.get(), this.getFormat().getTimeZone());
                    }
                }
                catch (ParseException pe2) {
                    if (CompatibilityHints.isHintEnabled("ical4j.parsing.relaxed")) {
                        this.setTime(value, (DateFormat)RELAXED_FORMAT.get(), timezone);
                        break block7;
                    }
                    throw pe2;
                }
            }
            this.setTimeZone(timezone);
        }
    }

    public DateTime(String value, String pattern, TimeZone timezone) throws ParseException {
        super(0, timezone != null ? timezone : java.util.TimeZone.getDefault());
        this.time = new Time(System.currentTimeMillis(), this.getFormat().getTimeZone());
        DateFormat format = CalendarDateFormatFactory.getInstance(pattern);
        this.setTime(value, format, timezone);
    }

    public DateTime(String value, String pattern, boolean utc) throws ParseException {
        this();
        DateFormat format = CalendarDateFormatFactory.getInstance(pattern);
        if (utc) {
            this.setTime(value, format, ((DateFormat)UTC_FORMAT.get()).getTimeZone());
        } else {
            this.setTime(value, format, null);
        }
        this.setUtc(utc);
    }

    private void setTime(String value, DateFormat format, java.util.TimeZone tz) throws ParseException {
        if (tz != null) {
            format.setTimeZone(tz);
        }
        this.setTime(format.parse(value).getTime());
    }

    public final void setTime(long time) {
        super.setTime(time);
        if (this.time != null) {
            this.time.setTime(time);
        }
    }

    public final boolean isUtc() {
        return this.time.isUtc();
    }

    public final void setUtc(boolean utc) {
        this.timezone = null;
        if (utc) {
            this.getFormat().setTimeZone(TimeZone.getTimeZone("Etc/UTC"));
        } else {
            this.resetTimeZone();
        }
        this.time = new Time(this.time, this.getFormat().getTimeZone(), utc);
    }

    public final void setTimeZone(TimeZone timezone) {
        this.timezone = timezone;
        if (timezone != null) {
            this.getFormat().setTimeZone(timezone);
        } else {
            this.resetTimeZone();
        }
        this.time = new Time(this.time, this.getFormat().getTimeZone(), false);
    }

    private void resetTimeZone() {
        this.getFormat().setTimeZone(TimeZone.getDefault());
    }

    public final TimeZone getTimeZone() {
        return this.timezone;
    }

    public final String toString() {
        StringBuffer b = new StringBuffer(super.toString());
        b.append('T');
        b.append(this.time.toString());
        return b.toString();
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof DateTime) {
            return new EqualsBuilder().append((Object)this.time, (Object)((DateTime)arg0).time).isEquals();
        }
        return super.equals(arg0);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.time).append((Object)this.timezone).toHashCode();
    }
}

