(function(){"use strict";try{if(typeof document!="undefined"){var e=document.createElement("style");e.appendChild(document.createTextNode('.vue3-marquee{display:flex!important;position:relative}.vue3-marquee.horizontal{overflow-x:hidden!important;flex-direction:row!important;width:100%;height:max-content}.vue3-marquee.vertical{overflow-y:hidden!important;flex-direction:column!important;height:100%;width:max-content}.vue3-marquee:hover>.marquee{animation-play-state:var(--pauseOnHover)}.vue3-marquee:active>.marquee{animation-play-state:var(--pauseOnClick)}.vue3-marquee>.marquee{flex:0 0 auto;min-width:var(--min-width);min-height:var(--min-height);z-index:1;animation:var(--orientation) var(--duration) linear var(--delay) var(--loops);animation-play-state:var(--pauseAnimation);animation-direction:var(--direction)}.vue3-marquee.horizontal>.marquee{display:flex;flex-direction:row;align-items:center}.vue3-marquee.vertical>.marquee{display:flex;flex-direction:column;align-items:center}@keyframes scrollX{0%{transform:translate(0)}to{transform:translate(-100%)}}@keyframes scrollY{0%{transform:translateY(0)}to{transform:translateY(-100%)}}.vue3-marquee>.overlay{position:absolute;width:100%;height:100%}.vue3-marquee>.transparent-overlay{position:absolute;width:100%;height:100%}.vue3-marquee>.overlay:before,.vue3-marquee>.overlay:after{content:"";position:absolute;z-index:2}.vue3-marquee.horizontal>.overlay:before,.vue3-marquee.horizontal>.overlay:after{background:linear-gradient(to right,var(--gradient-color));height:100%;width:var(--gradient-length)}.vue3-marquee.vertical>.overlay:before,.vue3-marquee.vertical>.overlay:after{background:linear-gradient(to bottom,var(--gradient-color));height:var(--gradient-length);width:100%}.vue3-marquee.horizontal>.overlay:after{transform:rotate(180deg)}.vue3-marquee.vertical>.overlay:after{transform:rotate(-180deg)}.vue3-marquee>.overlay:before{left:0;top:0}.vue3-marquee.horizontal>.overlay:after{right:0;top:0}.vue3-marquee.vertical>.overlay:after{left:0;bottom:0}')),document.head.appendChild(e)}}catch(a){console.error("vite-plugin-css-injected-by-js",a)}})();
var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
import { defineComponent, ref, watch, computed, onMounted, onBeforeUnmount, openBlock, createElementBlock, normalizeClass, normalizeStyle, createElementVNode, createCommentVNode, renderSlot, Fragment, renderList } from "vue";
var vue3Marquee_vue_vue_type_style_index_0_lang = "";
var _export_sfc = (sfc, props) => {
  const target = sfc.__vccOpts || sfc;
  for (const [key, val] of props) {
    target[key] = val;
  }
  return target;
};
const _sfc_main = defineComponent({
  props: {
    vertical: {
      type: Boolean,
      default: false
    },
    direction: {
      type: String,
      default: "normal"
    },
    duration: {
      type: Number,
      default: 20
    },
    delay: {
      type: Number,
      default: 0
    },
    loop: {
      type: Number,
      default: 0
    },
    clone: {
      type: Boolean,
      default: false
    },
    gradient: {
      type: Boolean,
      default: false
    },
    gradientColor: {
      type: Array,
      default: [255, 255, 255]
    },
    gradientWidth: {
      type: String
    },
    gradientLength: {
      type: String
    },
    pauseOnHover: {
      type: Boolean,
      default: false
    },
    pauseOnClick: {
      type: Boolean,
      default: false
    },
    pause: {
      type: Boolean,
      default: false
    },
    animateOnOverflowOnly: {
      type: Boolean,
      default: false
    }
  },
  emits: [
    "onComplete",
    "onLoopComplete",
    "onPause",
    "onResume",
    "onOverflowDetected",
    "onOverflowCleared"
  ],
  setup(props, { emit }) {
    const cloneAmount = ref(0);
    const minWidth = ref("100%");
    const minHeight = ref("100%");
    const componentKey = ref(0);
    const verticalAnimationPause = ref(false);
    const animateOnOverflowPause = ref(false);
    const containerWidth = ref(0);
    const contentWidth = ref(0);
    const containerHeight = ref(0);
    const contentHeight = ref(0);
    const mouseOverMarquee = ref(false);
    const mouseDownMarquee = ref(false);
    const loopCounter = ref(0);
    const loopInterval = ref(null);
    const gradientLength = ref("200px");
    const ready = ref(false);
    const marqueeContent = ref(null);
    const marqueeOverlayContainer = ref(null);
    const ForcesUpdate = async () => {
      await checkForClone();
      componentKey.value++;
    };
    const checkForClone = async () => {
      if (props.vertical) {
        verticalAnimationPause.value = true;
      }
      setInterval(() => {
        minWidth.value = "0%";
        minHeight.value = "0%";
        if (marqueeContent.value !== null && marqueeOverlayContainer.value !== null && marqueeContent.value && marqueeOverlayContainer.value) {
          if (props.vertical && "clientHeight" in marqueeContent.value && "clientHeight" in marqueeOverlayContainer.value) {
            contentHeight.value = marqueeContent.value.clientHeight;
            containerHeight.value = marqueeOverlayContainer.value.clientHeight;
            const localCloneAmount = Math.ceil(containerHeight.value / contentHeight.value);
            cloneAmount.value = isFinite(localCloneAmount) ? localCloneAmount : 0;
            verticalAnimationPause.value = false;
            return cloneAmount.value;
          } else if (!props.vertical && "clientWidth" in marqueeContent.value && "clientWidth" in marqueeOverlayContainer.value) {
            contentWidth.value = marqueeContent.value.clientWidth;
            containerWidth.value = marqueeOverlayContainer.value.clientWidth;
            if (props.animateOnOverflowOnly) {
              if (contentWidth.value < containerWidth.value) {
                animateOnOverflowPause.value = true;
                emit("onOverflowDetected");
              } else {
                animateOnOverflowPause.value = false;
                emit("onOverflowCleared");
              }
              return 0;
            }
            const localCloneAmount = Math.ceil(containerWidth.value / contentWidth.value);
            cloneAmount.value = isFinite(localCloneAmount) ? localCloneAmount : 0;
            return cloneAmount.value;
          } else {
            minWidth.value = "100%";
            minHeight.value = "100%";
            return 0;
          }
        } else {
          minWidth.value = "100%";
          minHeight.value = "100%";
          return 0;
        }
      }, 100);
    };
    watch(contentWidth, async () => {
      if (props.clone) {
        ForcesUpdate();
      }
    });
    watch(containerWidth, async () => {
      if (props.clone || props.animateOnOverflowOnly) {
        ForcesUpdate();
      }
    });
    watch(() => props.pause, (newVal, oldVal) => {
      if (newVal !== oldVal) {
        if (newVal) {
          emit("onResume");
        } else {
          emit("onPause");
        }
      }
    });
    const hoverStarted = () => {
      if (props.pauseOnHover) {
        emit("onPause");
        mouseOverMarquee.value = true;
      }
    };
    const hoverEnded = () => {
      if (props.pauseOnHover) {
        emit("onResume");
        mouseOverMarquee.value = false;
      }
    };
    const mouseDown = () => {
      if (props.pauseOnClick) {
        emit("onPause");
        mouseDownMarquee.value = true;
      }
    };
    const mouseUp = () => {
      if (props.pauseOnClick) {
        emit("onResume");
        mouseDownMarquee.value = false;
      }
    };
    const animationState = computed(() => {
      if (props.pause) {
        return "paused";
      }
      if (props.vertical && verticalAnimationPause.value) {
        return "paused";
      }
      if (props.animateOnOverflowOnly && animateOnOverflowPause.value) {
        return "paused";
      }
      return "running";
    });
    const hoverAnimationState = computed(() => {
      if (props.pauseOnHover && (mouseOverMarquee.value || mouseDownMarquee.value)) {
        return "paused";
      }
      if (!props.pauseOnHover && animationState.value === "paused") {
        return "paused";
      }
      return "running";
    });
    const clickAnimationState = computed(() => {
      if (props.pauseOnHover && mouseOverMarquee.value) {
        return "paused";
      }
      if (props.pauseOnClick && mouseDownMarquee.value) {
        return "paused";
      }
      if (!props.pauseOnHover && animationState.value === "paused") {
        return "paused";
      }
      return "running";
    });
    const getCurrentStyle = computed(() => {
      const cssVariables = {
        "--duration": `${props.duration}s`,
        "--delay": `${props.delay}s`,
        "--direction": `${props.direction}`,
        "--pauseOnHover": `${hoverAnimationState.value}`,
        "--pauseOnClick": `${clickAnimationState.value}`,
        "--pauseAnimation": `${animationState.value}`,
        "--loops": `${props.loop === 0 ? "infinite" : props.loop}`,
        "--gradient-color": `rgba(${props.gradientColor[0]}, ${props.gradientColor[1]}, ${props.gradientColor[2]}, 1), rgba(${props.gradientColor[0]}, ${props.gradientColor[1]}, ${props.gradientColor[2]}, 0)`,
        "--gradient-length": `${gradientLength.value}`,
        "--min-width": `${minWidth.value}`,
        "--min-height": `${minHeight.value}`
      };
      const animationStyles = {
        "--orientation": "scrollX",
        orientation: "horizontal"
      };
      if (props.vertical) {
        animationStyles["--orientation"] = "scrollY";
      }
      const styles = __spreadValues(__spreadValues({}, cssVariables), animationStyles);
      return styles;
    });
    const showGradient = computed(() => {
      if (props.gradient) {
        return true;
      }
      return false;
    });
    const setupMarquee = async () => {
      if (props.vertical) {
        minHeight.value = "100%";
        minWidth.value = "auto";
        if (props.animateOnOverflowOnly) {
          console.warn("The `animateOnOverflowOnly` prop is not supported for vertical marquees.");
        }
      } else {
        minHeight.value = "auto";
        if (props.animateOnOverflowOnly) {
          minWidth.value = "auto";
        } else {
          minWidth.value = "100%";
        }
      }
      if (props.gradient) {
        if (props.gradientWidth) {
          console.warn("The `gradientWidth` prop has been deprecated and will be removed in a future release. Please use `gradientLength` instead.");
          gradientLength.value = props.gradientWidth;
        } else if (props.gradientLength) {
          gradientLength.value = props.gradientLength;
        }
      }
      if (props.clone || props.animateOnOverflowOnly) {
        await checkForClone();
        ForcesUpdate();
        ready.value = true;
      } else {
        ready.value = true;
      }
    };
    onMounted(async () => {
      setupMarquee();
      loopInterval.value = setInterval(() => {
        loopCounter.value++;
        if (props.loop !== 0 && loopCounter.value === props.loop) {
          emit("onComplete");
          clearInterval(loopInterval.value);
        }
        emit("onLoopComplete");
      }, props.duration * 1e3);
    });
    onBeforeUnmount(() => {
      clearInterval(loopInterval.value);
    });
    return {
      ready,
      contentWidth,
      containerWidth,
      contentHeight,
      containerHeight,
      loopCounter,
      loopInterval,
      mouseOverMarquee,
      mouseDownMarquee,
      minWidth,
      minHeight,
      animateOnOverflowPause,
      marqueeContent,
      marqueeOverlayContainer,
      componentKey,
      showGradient,
      cloneAmount,
      ForcesUpdate,
      checkForClone,
      setupMarquee,
      getCurrentStyle,
      hoverStarted,
      hoverEnded,
      mouseDown,
      mouseUp
    };
  }
});
const _hoisted_1 = {
  class: "transparent-overlay",
  ref: "marqueeOverlayContainer",
  "aria-hidden": true
};
const _hoisted_2 = {
  class: "marquee",
  ref: "marqueeContent"
};
const _hoisted_3 = {
  key: 1,
  "aria-hidden": true,
  class: "marquee"
};
function _sfc_render(_ctx, _cache, $props, $setup, $data, $options) {
  return _ctx.ready ? (openBlock(), createElementBlock("div", {
    class: normalizeClass(["vue3-marquee", { vertical: _ctx.vertical, horizontal: !_ctx.vertical }]),
    style: normalizeStyle(_ctx.getCurrentStyle),
    key: _ctx.componentKey,
    onMouseenter: _cache[0] || (_cache[0] = (...args) => _ctx.hoverStarted && _ctx.hoverStarted(...args)),
    onMouseleave: _cache[1] || (_cache[1] = (...args) => _ctx.hoverEnded && _ctx.hoverEnded(...args)),
    onMousedown: _cache[2] || (_cache[2] = (...args) => _ctx.mouseDown && _ctx.mouseDown(...args)),
    onMouseup: _cache[3] || (_cache[3] = (...args) => _ctx.mouseUp && _ctx.mouseUp(...args))
  }, [
    createElementVNode("div", _hoisted_1, null, 512),
    _ctx.showGradient ? (openBlock(), createElementBlock("div", {
      key: 0,
      "aria-hidden": true,
      class: normalizeClass(["overlay", { vertical: _ctx.vertical, horizontal: !_ctx.vertical }])
    }, null, 2)) : createCommentVNode("", true),
    createElementVNode("div", _hoisted_2, [
      renderSlot(_ctx.$slots, "default")
    ], 512),
    !_ctx.animateOnOverflowOnly || _ctx.animateOnOverflowOnly && !_ctx.animateOnOverflowPause ? (openBlock(), createElementBlock("div", _hoisted_3, [
      renderSlot(_ctx.$slots, "default")
    ])) : createCommentVNode("", true),
    (openBlock(true), createElementBlock(Fragment, null, renderList(_ctx.cloneAmount, (num) => {
      return openBlock(), createElementBlock("div", {
        "aria-hidden": true,
        class: "marquee cloned",
        key: num
      }, [
        renderSlot(_ctx.$slots, "default")
      ]);
    }), 128))
  ], 38)) : createCommentVNode("", true);
}
var Vue3Marquee = /* @__PURE__ */ _export_sfc(_sfc_main, [["render", _sfc_render]]);
var index = {
  install(app, options) {
    var _a;
    const name = (_a = options == null ? void 0 : options.name) != null ? _a : "Vue3Marquee";
    app.component(name, Vue3Marquee);
  }
};
export { Vue3Marquee, index as default };
