/*!
 Stencil Compiler v4.19.2 | MIT Licensed | https://stenciljs.com
 */
"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __typeError = (msg) => {
  throw TypeError(msg);
};
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __esm = (fn, res) => function __init() {
  return fn && (res = (0, fn[__getOwnPropNames(fn)[0]])(fn = 0)), res;
};
var __commonJS = (cb, mod) => function __require() {
  return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key !== "symbol" ? key + "" : key, value);
var __accessCheck = (obj, member2, msg) => member2.has(obj) || __typeError("Cannot " + msg);
var __privateGet = (obj, member2, getter) => (__accessCheck(obj, member2, "read from private field"), getter ? getter.call(obj) : member2.get(obj));
var __privateAdd = (obj, member2, value) => member2.has(obj) ? __typeError("Cannot add the same private member more than once") : member2 instanceof WeakSet ? member2.add(obj) : member2.set(obj, value);
var __privateSet = (obj, member2, value, setter) => (__accessCheck(obj, member2, "write to private field"), setter ? setter.call(obj, value) : member2.set(obj, value), value);
var __privateMethod = (obj, member2, method) => (__accessCheck(obj, member2, "access private method"), method);

// node_modules/source-map/lib/base64.js
var require_base64 = __commonJS({
  "node_modules/source-map/lib/base64.js"(exports2) {
    var intToCharMap = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".split("");
    exports2.encode = function(number) {
      if (0 <= number && number < intToCharMap.length) {
        return intToCharMap[number];
      }
      throw new TypeError("Must be between 0 and 63: " + number);
    };
    exports2.decode = function(charCode) {
      var bigA = 65;
      var bigZ = 90;
      var littleA = 97;
      var littleZ = 122;
      var zero = 48;
      var nine = 57;
      var plus = 43;
      var slash = 47;
      var littleOffset = 26;
      var numberOffset = 52;
      if (bigA <= charCode && charCode <= bigZ) {
        return charCode - bigA;
      }
      if (littleA <= charCode && charCode <= littleZ) {
        return charCode - littleA + littleOffset;
      }
      if (zero <= charCode && charCode <= nine) {
        return charCode - zero + numberOffset;
      }
      if (charCode == plus) {
        return 62;
      }
      if (charCode == slash) {
        return 63;
      }
      return -1;
    };
  }
});

// node_modules/source-map/lib/base64-vlq.js
var require_base64_vlq = __commonJS({
  "node_modules/source-map/lib/base64-vlq.js"(exports2) {
    var base64 = require_base64();
    var VLQ_BASE_SHIFT = 5;
    var VLQ_BASE = 1 << VLQ_BASE_SHIFT;
    var VLQ_BASE_MASK = VLQ_BASE - 1;
    var VLQ_CONTINUATION_BIT = VLQ_BASE;
    function toVLQSigned(aValue) {
      return aValue < 0 ? (-aValue << 1) + 1 : (aValue << 1) + 0;
    }
    function fromVLQSigned(aValue) {
      var isNegative = (aValue & 1) === 1;
      var shifted = aValue >> 1;
      return isNegative ? -shifted : shifted;
    }
    exports2.encode = function base64VLQ_encode(aValue) {
      var encoded = "";
      var digit;
      var vlq = toVLQSigned(aValue);
      do {
        digit = vlq & VLQ_BASE_MASK;
        vlq >>>= VLQ_BASE_SHIFT;
        if (vlq > 0) {
          digit |= VLQ_CONTINUATION_BIT;
        }
        encoded += base64.encode(digit);
      } while (vlq > 0);
      return encoded;
    };
    exports2.decode = function base64VLQ_decode(aStr, aIndex, aOutParam) {
      var strLen = aStr.length;
      var result2 = 0;
      var shift = 0;
      var continuation, digit;
      do {
        if (aIndex >= strLen) {
          throw new Error("Expected more digits in base 64 VLQ value.");
        }
        digit = base64.decode(aStr.charCodeAt(aIndex++));
        if (digit === -1) {
          throw new Error("Invalid base64 digit: " + aStr.charAt(aIndex - 1));
        }
        continuation = !!(digit & VLQ_CONTINUATION_BIT);
        digit &= VLQ_BASE_MASK;
        result2 = result2 + (digit << shift);
        shift += VLQ_BASE_SHIFT;
      } while (continuation);
      aOutParam.value = fromVLQSigned(result2);
      aOutParam.rest = aIndex;
    };
  }
});

// node_modules/source-map/lib/util.js
var require_util = __commonJS({
  "node_modules/source-map/lib/util.js"(exports2) {
    function getArg(aArgs, aName, aDefaultValue) {
      if (aName in aArgs) {
        return aArgs[aName];
      } else if (arguments.length === 3) {
        return aDefaultValue;
      } else {
        throw new Error('"' + aName + '" is a required argument.');
      }
    }
    exports2.getArg = getArg;
    var urlRegexp = /^(?:([\w+\-.]+):)?\/\/(?:(\w+:\w+)@)?([\w.-]*)(?::(\d+))?(.*)$/;
    var dataUrlRegexp = /^data:.+\,.+$/;
    function urlParse(aUrl) {
      var match2 = aUrl.match(urlRegexp);
      if (!match2) {
        return null;
      }
      return {
        scheme: match2[1],
        auth: match2[2],
        host: match2[3],
        port: match2[4],
        path: match2[5]
      };
    }
    exports2.urlParse = urlParse;
    function urlGenerate(aParsedUrl) {
      var url = "";
      if (aParsedUrl.scheme) {
        url += aParsedUrl.scheme + ":";
      }
      url += "//";
      if (aParsedUrl.auth) {
        url += aParsedUrl.auth + "@";
      }
      if (aParsedUrl.host) {
        url += aParsedUrl.host;
      }
      if (aParsedUrl.port) {
        url += ":" + aParsedUrl.port;
      }
      if (aParsedUrl.path) {
        url += aParsedUrl.path;
      }
      return url;
    }
    exports2.urlGenerate = urlGenerate;
    function normalize3(aPath) {
      var path6 = aPath;
      var url = urlParse(aPath);
      if (url) {
        if (!url.path) {
          return aPath;
        }
        path6 = url.path;
      }
      var isAbsolute25 = exports2.isAbsolute(path6);
      var parts = path6.split(/\/+/);
      for (var part, up = 0, i = parts.length - 1; i >= 0; i--) {
        part = parts[i];
        if (part === ".") {
          parts.splice(i, 1);
        } else if (part === "..") {
          up++;
        } else if (up > 0) {
          if (part === "") {
            parts.splice(i + 1, up);
            up = 0;
          } else {
            parts.splice(i, 2);
            up--;
          }
        }
      }
      path6 = parts.join("/");
      if (path6 === "") {
        path6 = isAbsolute25 ? "/" : ".";
      }
      if (url) {
        url.path = path6;
        return urlGenerate(url);
      }
      return path6;
    }
    exports2.normalize = normalize3;
    function join2(aRoot, aPath) {
      if (aRoot === "") {
        aRoot = ".";
      }
      if (aPath === "") {
        aPath = ".";
      }
      var aPathUrl = urlParse(aPath);
      var aRootUrl = urlParse(aRoot);
      if (aRootUrl) {
        aRoot = aRootUrl.path || "/";
      }
      if (aPathUrl && !aPathUrl.scheme) {
        if (aRootUrl) {
          aPathUrl.scheme = aRootUrl.scheme;
        }
        return urlGenerate(aPathUrl);
      }
      if (aPathUrl || aPath.match(dataUrlRegexp)) {
        return aPath;
      }
      if (aRootUrl && !aRootUrl.host && !aRootUrl.path) {
        aRootUrl.host = aPath;
        return urlGenerate(aRootUrl);
      }
      var joined = aPath.charAt(0) === "/" ? aPath : normalize3(aRoot.replace(/\/+$/, "") + "/" + aPath);
      if (aRootUrl) {
        aRootUrl.path = joined;
        return urlGenerate(aRootUrl);
      }
      return joined;
    }
    exports2.join = join2;
    exports2.isAbsolute = function(aPath) {
      return aPath.charAt(0) === "/" || urlRegexp.test(aPath);
    };
    function relative4(aRoot, aPath) {
      if (aRoot === "") {
        aRoot = ".";
      }
      aRoot = aRoot.replace(/\/$/, "");
      var level = 0;
      while (aPath.indexOf(aRoot + "/") !== 0) {
        var index2 = aRoot.lastIndexOf("/");
        if (index2 < 0) {
          return aPath;
        }
        aRoot = aRoot.slice(0, index2);
        if (aRoot.match(/^([^\/]+:\/)?\/*$/)) {
          return aPath;
        }
        ++level;
      }
      return Array(level + 1).join("../") + aPath.substr(aRoot.length + 1);
    }
    exports2.relative = relative4;
    var supportsNullProto = function() {
      var obj = /* @__PURE__ */ Object.create(null);
      return !("__proto__" in obj);
    }();
    function identity(s) {
      return s;
    }
    function toSetString(aStr) {
      if (isProtoString(aStr)) {
        return "$" + aStr;
      }
      return aStr;
    }
    exports2.toSetString = supportsNullProto ? identity : toSetString;
    function fromSetString(aStr) {
      if (isProtoString(aStr)) {
        return aStr.slice(1);
      }
      return aStr;
    }
    exports2.fromSetString = supportsNullProto ? identity : fromSetString;
    function isProtoString(s) {
      if (!s) {
        return false;
      }
      var length3 = s.length;
      if (length3 < 9) {
        return false;
      }
      if (s.charCodeAt(length3 - 1) !== 95 || s.charCodeAt(length3 - 2) !== 95 || s.charCodeAt(length3 - 3) !== 111 || s.charCodeAt(length3 - 4) !== 116 || s.charCodeAt(length3 - 5) !== 111 || s.charCodeAt(length3 - 6) !== 114 || s.charCodeAt(length3 - 7) !== 112 || s.charCodeAt(length3 - 8) !== 95 || s.charCodeAt(length3 - 9) !== 95) {
        return false;
      }
      for (var i = length3 - 10; i >= 0; i--) {
        if (s.charCodeAt(i) !== 36) {
          return false;
        }
      }
      return true;
    }
    function compareByOriginalPositions(mappingA, mappingB, onlyCompareOriginal) {
      var cmp = strcmp(mappingA.source, mappingB.source);
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.originalLine - mappingB.originalLine;
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.originalColumn - mappingB.originalColumn;
      if (cmp !== 0 || onlyCompareOriginal) {
        return cmp;
      }
      cmp = mappingA.generatedColumn - mappingB.generatedColumn;
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.generatedLine - mappingB.generatedLine;
      if (cmp !== 0) {
        return cmp;
      }
      return strcmp(mappingA.name, mappingB.name);
    }
    exports2.compareByOriginalPositions = compareByOriginalPositions;
    function compareByGeneratedPositionsDeflated(mappingA, mappingB, onlyCompareGenerated) {
      var cmp = mappingA.generatedLine - mappingB.generatedLine;
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.generatedColumn - mappingB.generatedColumn;
      if (cmp !== 0 || onlyCompareGenerated) {
        return cmp;
      }
      cmp = strcmp(mappingA.source, mappingB.source);
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.originalLine - mappingB.originalLine;
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.originalColumn - mappingB.originalColumn;
      if (cmp !== 0) {
        return cmp;
      }
      return strcmp(mappingA.name, mappingB.name);
    }
    exports2.compareByGeneratedPositionsDeflated = compareByGeneratedPositionsDeflated;
    function strcmp(aStr1, aStr2) {
      if (aStr1 === aStr2) {
        return 0;
      }
      if (aStr1 === null) {
        return 1;
      }
      if (aStr2 === null) {
        return -1;
      }
      if (aStr1 > aStr2) {
        return 1;
      }
      return -1;
    }
    function compareByGeneratedPositionsInflated(mappingA, mappingB) {
      var cmp = mappingA.generatedLine - mappingB.generatedLine;
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.generatedColumn - mappingB.generatedColumn;
      if (cmp !== 0) {
        return cmp;
      }
      cmp = strcmp(mappingA.source, mappingB.source);
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.originalLine - mappingB.originalLine;
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.originalColumn - mappingB.originalColumn;
      if (cmp !== 0) {
        return cmp;
      }
      return strcmp(mappingA.name, mappingB.name);
    }
    exports2.compareByGeneratedPositionsInflated = compareByGeneratedPositionsInflated;
    function parseSourceMapInput(str) {
      return JSON.parse(str.replace(/^\)]}'[^\n]*\n/, ""));
    }
    exports2.parseSourceMapInput = parseSourceMapInput;
    function computeSourceURL(sourceRoot, sourceURL, sourceMapURL) {
      sourceURL = sourceURL || "";
      if (sourceRoot) {
        if (sourceRoot[sourceRoot.length - 1] !== "/" && sourceURL[0] !== "/") {
          sourceRoot += "/";
        }
        sourceURL = sourceRoot + sourceURL;
      }
      if (sourceMapURL) {
        var parsed = urlParse(sourceMapURL);
        if (!parsed) {
          throw new Error("sourceMapURL could not be parsed");
        }
        if (parsed.path) {
          var index2 = parsed.path.lastIndexOf("/");
          if (index2 >= 0) {
            parsed.path = parsed.path.substring(0, index2 + 1);
          }
        }
        sourceURL = join2(urlGenerate(parsed), sourceURL);
      }
      return normalize3(sourceURL);
    }
    exports2.computeSourceURL = computeSourceURL;
  }
});

// node_modules/source-map/lib/array-set.js
var require_array_set = __commonJS({
  "node_modules/source-map/lib/array-set.js"(exports2) {
    var util = require_util();
    var has3 = Object.prototype.hasOwnProperty;
    var hasNativeMap = typeof Map !== "undefined";
    function ArraySet() {
      this._array = [];
      this._set = hasNativeMap ? /* @__PURE__ */ new Map() : /* @__PURE__ */ Object.create(null);
    }
    ArraySet.fromArray = function ArraySet_fromArray(aArray, aAllowDuplicates) {
      var set = new ArraySet();
      for (var i = 0, len = aArray.length; i < len; i++) {
        set.add(aArray[i], aAllowDuplicates);
      }
      return set;
    };
    ArraySet.prototype.size = function ArraySet_size() {
      return hasNativeMap ? this._set.size : Object.getOwnPropertyNames(this._set).length;
    };
    ArraySet.prototype.add = function ArraySet_add(aStr, aAllowDuplicates) {
      var sStr = hasNativeMap ? aStr : util.toSetString(aStr);
      var isDuplicate = hasNativeMap ? this.has(aStr) : has3.call(this._set, sStr);
      var idx = this._array.length;
      if (!isDuplicate || aAllowDuplicates) {
        this._array.push(aStr);
      }
      if (!isDuplicate) {
        if (hasNativeMap) {
          this._set.set(aStr, idx);
        } else {
          this._set[sStr] = idx;
        }
      }
    };
    ArraySet.prototype.has = function ArraySet_has(aStr) {
      if (hasNativeMap) {
        return this._set.has(aStr);
      } else {
        var sStr = util.toSetString(aStr);
        return has3.call(this._set, sStr);
      }
    };
    ArraySet.prototype.indexOf = function ArraySet_indexOf(aStr) {
      if (hasNativeMap) {
        var idx = this._set.get(aStr);
        if (idx >= 0) {
          return idx;
        }
      } else {
        var sStr = util.toSetString(aStr);
        if (has3.call(this._set, sStr)) {
          return this._set[sStr];
        }
      }
      throw new Error('"' + aStr + '" is not in the set.');
    };
    ArraySet.prototype.at = function ArraySet_at(aIdx) {
      if (aIdx >= 0 && aIdx < this._array.length) {
        return this._array[aIdx];
      }
      throw new Error("No element indexed by " + aIdx);
    };
    ArraySet.prototype.toArray = function ArraySet_toArray() {
      return this._array.slice();
    };
    exports2.ArraySet = ArraySet;
  }
});

// node_modules/source-map/lib/mapping-list.js
var require_mapping_list = __commonJS({
  "node_modules/source-map/lib/mapping-list.js"(exports2) {
    var util = require_util();
    function generatedPositionAfter(mappingA, mappingB) {
      var lineA = mappingA.generatedLine;
      var lineB = mappingB.generatedLine;
      var columnA = mappingA.generatedColumn;
      var columnB = mappingB.generatedColumn;
      return lineB > lineA || lineB == lineA && columnB >= columnA || util.compareByGeneratedPositionsInflated(mappingA, mappingB) <= 0;
    }
    function MappingList() {
      this._array = [];
      this._sorted = true;
      this._last = { generatedLine: -1, generatedColumn: 0 };
    }
    MappingList.prototype.unsortedForEach = function MappingList_forEach(aCallback, aThisArg) {
      this._array.forEach(aCallback, aThisArg);
    };
    MappingList.prototype.add = function MappingList_add(aMapping) {
      if (generatedPositionAfter(this._last, aMapping)) {
        this._last = aMapping;
        this._array.push(aMapping);
      } else {
        this._sorted = false;
        this._array.push(aMapping);
      }
    };
    MappingList.prototype.toArray = function MappingList_toArray() {
      if (!this._sorted) {
        this._array.sort(util.compareByGeneratedPositionsInflated);
        this._sorted = true;
      }
      return this._array;
    };
    exports2.MappingList = MappingList;
  }
});

// node_modules/source-map/lib/source-map-generator.js
var require_source_map_generator = __commonJS({
  "node_modules/source-map/lib/source-map-generator.js"(exports2) {
    var base64VLQ = require_base64_vlq();
    var util = require_util();
    var ArraySet = require_array_set().ArraySet;
    var MappingList = require_mapping_list().MappingList;
    function SourceMapGenerator2(aArgs) {
      if (!aArgs) {
        aArgs = {};
      }
      this._file = util.getArg(aArgs, "file", null);
      this._sourceRoot = util.getArg(aArgs, "sourceRoot", null);
      this._skipValidation = util.getArg(aArgs, "skipValidation", false);
      this._sources = new ArraySet();
      this._names = new ArraySet();
      this._mappings = new MappingList();
      this._sourcesContents = null;
    }
    SourceMapGenerator2.prototype._version = 3;
    SourceMapGenerator2.fromSourceMap = function SourceMapGenerator_fromSourceMap(aSourceMapConsumer) {
      var sourceRoot = aSourceMapConsumer.sourceRoot;
      var generator = new SourceMapGenerator2({
        file: aSourceMapConsumer.file,
        sourceRoot
      });
      aSourceMapConsumer.eachMapping(function(mapping) {
        var newMapping = {
          generated: {
            line: mapping.generatedLine,
            column: mapping.generatedColumn
          }
        };
        if (mapping.source != null) {
          newMapping.source = mapping.source;
          if (sourceRoot != null) {
            newMapping.source = util.relative(sourceRoot, newMapping.source);
          }
          newMapping.original = {
            line: mapping.originalLine,
            column: mapping.originalColumn
          };
          if (mapping.name != null) {
            newMapping.name = mapping.name;
          }
        }
        generator.addMapping(newMapping);
      });
      aSourceMapConsumer.sources.forEach(function(sourceFile) {
        var sourceRelative = sourceFile;
        if (sourceRoot !== null) {
          sourceRelative = util.relative(sourceRoot, sourceFile);
        }
        if (!generator._sources.has(sourceRelative)) {
          generator._sources.add(sourceRelative);
        }
        var content = aSourceMapConsumer.sourceContentFor(sourceFile);
        if (content != null) {
          generator.setSourceContent(sourceFile, content);
        }
      });
      return generator;
    };
    SourceMapGenerator2.prototype.addMapping = function SourceMapGenerator_addMapping(aArgs) {
      var generated = util.getArg(aArgs, "generated");
      var original = util.getArg(aArgs, "original", null);
      var source = util.getArg(aArgs, "source", null);
      var name = util.getArg(aArgs, "name", null);
      if (!this._skipValidation) {
        this._validateMapping(generated, original, source, name);
      }
      if (source != null) {
        source = String(source);
        if (!this._sources.has(source)) {
          this._sources.add(source);
        }
      }
      if (name != null) {
        name = String(name);
        if (!this._names.has(name)) {
          this._names.add(name);
        }
      }
      this._mappings.add({
        generatedLine: generated.line,
        generatedColumn: generated.column,
        originalLine: original != null && original.line,
        originalColumn: original != null && original.column,
        source,
        name
      });
    };
    SourceMapGenerator2.prototype.setSourceContent = function SourceMapGenerator_setSourceContent(aSourceFile, aSourceContent) {
      var source = aSourceFile;
      if (this._sourceRoot != null) {
        source = util.relative(this._sourceRoot, source);
      }
      if (aSourceContent != null) {
        if (!this._sourcesContents) {
          this._sourcesContents = /* @__PURE__ */ Object.create(null);
        }
        this._sourcesContents[util.toSetString(source)] = aSourceContent;
      } else if (this._sourcesContents) {
        delete this._sourcesContents[util.toSetString(source)];
        if (Object.keys(this._sourcesContents).length === 0) {
          this._sourcesContents = null;
        }
      }
    };
    SourceMapGenerator2.prototype.applySourceMap = function SourceMapGenerator_applySourceMap(aSourceMapConsumer, aSourceFile, aSourceMapPath) {
      var sourceFile = aSourceFile;
      if (aSourceFile == null) {
        if (aSourceMapConsumer.file == null) {
          throw new Error(
            `SourceMapGenerator.prototype.applySourceMap requires either an explicit source file, or the source map's "file" property. Both were omitted.`
          );
        }
        sourceFile = aSourceMapConsumer.file;
      }
      var sourceRoot = this._sourceRoot;
      if (sourceRoot != null) {
        sourceFile = util.relative(sourceRoot, sourceFile);
      }
      var newSources = new ArraySet();
      var newNames = new ArraySet();
      this._mappings.unsortedForEach(function(mapping) {
        if (mapping.source === sourceFile && mapping.originalLine != null) {
          var original = aSourceMapConsumer.originalPositionFor({
            line: mapping.originalLine,
            column: mapping.originalColumn
          });
          if (original.source != null) {
            mapping.source = original.source;
            if (aSourceMapPath != null) {
              mapping.source = util.join(aSourceMapPath, mapping.source);
            }
            if (sourceRoot != null) {
              mapping.source = util.relative(sourceRoot, mapping.source);
            }
            mapping.originalLine = original.line;
            mapping.originalColumn = original.column;
            if (original.name != null) {
              mapping.name = original.name;
            }
          }
        }
        var source = mapping.source;
        if (source != null && !newSources.has(source)) {
          newSources.add(source);
        }
        var name = mapping.name;
        if (name != null && !newNames.has(name)) {
          newNames.add(name);
        }
      }, this);
      this._sources = newSources;
      this._names = newNames;
      aSourceMapConsumer.sources.forEach(function(sourceFile2) {
        var content = aSourceMapConsumer.sourceContentFor(sourceFile2);
        if (content != null) {
          if (aSourceMapPath != null) {
            sourceFile2 = util.join(aSourceMapPath, sourceFile2);
          }
          if (sourceRoot != null) {
            sourceFile2 = util.relative(sourceRoot, sourceFile2);
          }
          this.setSourceContent(sourceFile2, content);
        }
      }, this);
    };
    SourceMapGenerator2.prototype._validateMapping = function SourceMapGenerator_validateMapping(aGenerated, aOriginal, aSource, aName) {
      if (aOriginal && typeof aOriginal.line !== "number" && typeof aOriginal.column !== "number") {
        throw new Error(
          "original.line and original.column are not numbers -- you probably meant to omit the original mapping entirely and only map the generated position. If so, pass null for the original mapping instead of an object with empty or null values."
        );
      }
      if (aGenerated && "line" in aGenerated && "column" in aGenerated && aGenerated.line > 0 && aGenerated.column >= 0 && !aOriginal && !aSource && !aName) {
        return;
      } else if (aGenerated && "line" in aGenerated && "column" in aGenerated && aOriginal && "line" in aOriginal && "column" in aOriginal && aGenerated.line > 0 && aGenerated.column >= 0 && aOriginal.line > 0 && aOriginal.column >= 0 && aSource) {
        return;
      } else {
        throw new Error("Invalid mapping: " + JSON.stringify({
          generated: aGenerated,
          source: aSource,
          original: aOriginal,
          name: aName
        }));
      }
    };
    SourceMapGenerator2.prototype._serializeMappings = function SourceMapGenerator_serializeMappings() {
      var previousGeneratedColumn = 0;
      var previousGeneratedLine = 1;
      var previousOriginalColumn = 0;
      var previousOriginalLine = 0;
      var previousName = 0;
      var previousSource = 0;
      var result2 = "";
      var next;
      var mapping;
      var nameIdx;
      var sourceIdx;
      var mappings = this._mappings.toArray();
      for (var i = 0, len = mappings.length; i < len; i++) {
        mapping = mappings[i];
        next = "";
        if (mapping.generatedLine !== previousGeneratedLine) {
          previousGeneratedColumn = 0;
          while (mapping.generatedLine !== previousGeneratedLine) {
            next += ";";
            previousGeneratedLine++;
          }
        } else {
          if (i > 0) {
            if (!util.compareByGeneratedPositionsInflated(mapping, mappings[i - 1])) {
              continue;
            }
            next += ",";
          }
        }
        next += base64VLQ.encode(mapping.generatedColumn - previousGeneratedColumn);
        previousGeneratedColumn = mapping.generatedColumn;
        if (mapping.source != null) {
          sourceIdx = this._sources.indexOf(mapping.source);
          next += base64VLQ.encode(sourceIdx - previousSource);
          previousSource = sourceIdx;
          next += base64VLQ.encode(mapping.originalLine - 1 - previousOriginalLine);
          previousOriginalLine = mapping.originalLine - 1;
          next += base64VLQ.encode(mapping.originalColumn - previousOriginalColumn);
          previousOriginalColumn = mapping.originalColumn;
          if (mapping.name != null) {
            nameIdx = this._names.indexOf(mapping.name);
            next += base64VLQ.encode(nameIdx - previousName);
            previousName = nameIdx;
          }
        }
        result2 += next;
      }
      return result2;
    };
    SourceMapGenerator2.prototype._generateSourcesContent = function SourceMapGenerator_generateSourcesContent(aSources, aSourceRoot) {
      return aSources.map(function(source) {
        if (!this._sourcesContents) {
          return null;
        }
        if (aSourceRoot != null) {
          source = util.relative(aSourceRoot, source);
        }
        var key = util.toSetString(source);
        return Object.prototype.hasOwnProperty.call(this._sourcesContents, key) ? this._sourcesContents[key] : null;
      }, this);
    };
    SourceMapGenerator2.prototype.toJSON = function SourceMapGenerator_toJSON() {
      var map2 = {
        version: this._version,
        sources: this._sources.toArray(),
        names: this._names.toArray(),
        mappings: this._serializeMappings()
      };
      if (this._file != null) {
        map2.file = this._file;
      }
      if (this._sourceRoot != null) {
        map2.sourceRoot = this._sourceRoot;
      }
      if (this._sourcesContents) {
        map2.sourcesContent = this._generateSourcesContent(map2.sources, map2.sourceRoot);
      }
      return map2;
    };
    SourceMapGenerator2.prototype.toString = function SourceMapGenerator_toString() {
      return JSON.stringify(this.toJSON());
    };
    exports2.SourceMapGenerator = SourceMapGenerator2;
  }
});

// node_modules/source-map/lib/binary-search.js
var require_binary_search = __commonJS({
  "node_modules/source-map/lib/binary-search.js"(exports2) {
    exports2.GREATEST_LOWER_BOUND = 1;
    exports2.LEAST_UPPER_BOUND = 2;
    function recursiveSearch(aLow, aHigh, aNeedle, aHaystack, aCompare, aBias) {
      var mid = Math.floor((aHigh - aLow) / 2) + aLow;
      var cmp = aCompare(aNeedle, aHaystack[mid], true);
      if (cmp === 0) {
        return mid;
      } else if (cmp > 0) {
        if (aHigh - mid > 1) {
          return recursiveSearch(mid, aHigh, aNeedle, aHaystack, aCompare, aBias);
        }
        if (aBias == exports2.LEAST_UPPER_BOUND) {
          return aHigh < aHaystack.length ? aHigh : -1;
        } else {
          return mid;
        }
      } else {
        if (mid - aLow > 1) {
          return recursiveSearch(aLow, mid, aNeedle, aHaystack, aCompare, aBias);
        }
        if (aBias == exports2.LEAST_UPPER_BOUND) {
          return mid;
        } else {
          return aLow < 0 ? -1 : aLow;
        }
      }
    }
    exports2.search = function search(aNeedle, aHaystack, aCompare, aBias) {
      if (aHaystack.length === 0) {
        return -1;
      }
      var index2 = recursiveSearch(
        -1,
        aHaystack.length,
        aNeedle,
        aHaystack,
        aCompare,
        aBias || exports2.GREATEST_LOWER_BOUND
      );
      if (index2 < 0) {
        return -1;
      }
      while (index2 - 1 >= 0) {
        if (aCompare(aHaystack[index2], aHaystack[index2 - 1], true) !== 0) {
          break;
        }
        --index2;
      }
      return index2;
    };
  }
});

// node_modules/source-map/lib/quick-sort.js
var require_quick_sort = __commonJS({
  "node_modules/source-map/lib/quick-sort.js"(exports2) {
    function swap(ary, x, y) {
      var temp = ary[x];
      ary[x] = ary[y];
      ary[y] = temp;
    }
    function randomIntInRange(low, high) {
      return Math.round(low + Math.random() * (high - low));
    }
    function doQuickSort(ary, comparator, p, r) {
      if (p < r) {
        var pivotIndex = randomIntInRange(p, r);
        var i = p - 1;
        swap(ary, pivotIndex, r);
        var pivot = ary[r];
        for (var j = p; j < r; j++) {
          if (comparator(ary[j], pivot) <= 0) {
            i += 1;
            swap(ary, i, j);
          }
        }
        swap(ary, i + 1, j);
        var q = i + 1;
        doQuickSort(ary, comparator, p, q - 1);
        doQuickSort(ary, comparator, q + 1, r);
      }
    }
    exports2.quickSort = function(ary, comparator) {
      doQuickSort(ary, comparator, 0, ary.length - 1);
    };
  }
});

// node_modules/source-map/lib/source-map-consumer.js
var require_source_map_consumer = __commonJS({
  "node_modules/source-map/lib/source-map-consumer.js"(exports2) {
    var util = require_util();
    var binarySearch2 = require_binary_search();
    var ArraySet = require_array_set().ArraySet;
    var base64VLQ = require_base64_vlq();
    var quickSort = require_quick_sort().quickSort;
    function SourceMapConsumer2(aSourceMap, aSourceMapURL) {
      var sourceMap = aSourceMap;
      if (typeof aSourceMap === "string") {
        sourceMap = util.parseSourceMapInput(aSourceMap);
      }
      return sourceMap.sections != null ? new IndexedSourceMapConsumer(sourceMap, aSourceMapURL) : new BasicSourceMapConsumer(sourceMap, aSourceMapURL);
    }
    SourceMapConsumer2.fromSourceMap = function(aSourceMap, aSourceMapURL) {
      return BasicSourceMapConsumer.fromSourceMap(aSourceMap, aSourceMapURL);
    };
    SourceMapConsumer2.prototype._version = 3;
    SourceMapConsumer2.prototype.__generatedMappings = null;
    Object.defineProperty(SourceMapConsumer2.prototype, "_generatedMappings", {
      configurable: true,
      enumerable: true,
      get: function() {
        if (!this.__generatedMappings) {
          this._parseMappings(this._mappings, this.sourceRoot);
        }
        return this.__generatedMappings;
      }
    });
    SourceMapConsumer2.prototype.__originalMappings = null;
    Object.defineProperty(SourceMapConsumer2.prototype, "_originalMappings", {
      configurable: true,
      enumerable: true,
      get: function() {
        if (!this.__originalMappings) {
          this._parseMappings(this._mappings, this.sourceRoot);
        }
        return this.__originalMappings;
      }
    });
    SourceMapConsumer2.prototype._charIsMappingSeparator = function SourceMapConsumer_charIsMappingSeparator(aStr, index2) {
      var c = aStr.charAt(index2);
      return c === ";" || c === ",";
    };
    SourceMapConsumer2.prototype._parseMappings = function SourceMapConsumer_parseMappings(aStr, aSourceRoot) {
      throw new Error("Subclasses must implement _parseMappings");
    };
    SourceMapConsumer2.GENERATED_ORDER = 1;
    SourceMapConsumer2.ORIGINAL_ORDER = 2;
    SourceMapConsumer2.GREATEST_LOWER_BOUND = 1;
    SourceMapConsumer2.LEAST_UPPER_BOUND = 2;
    SourceMapConsumer2.prototype.eachMapping = function SourceMapConsumer_eachMapping(aCallback, aContext, aOrder) {
      var context = aContext || null;
      var order = aOrder || SourceMapConsumer2.GENERATED_ORDER;
      var mappings;
      switch (order) {
        case SourceMapConsumer2.GENERATED_ORDER:
          mappings = this._generatedMappings;
          break;
        case SourceMapConsumer2.ORIGINAL_ORDER:
          mappings = this._originalMappings;
          break;
        default:
          throw new Error("Unknown order of iteration.");
      }
      var sourceRoot = this.sourceRoot;
      mappings.map(function(mapping) {
        var source = mapping.source === null ? null : this._sources.at(mapping.source);
        source = util.computeSourceURL(sourceRoot, source, this._sourceMapURL);
        return {
          source,
          generatedLine: mapping.generatedLine,
          generatedColumn: mapping.generatedColumn,
          originalLine: mapping.originalLine,
          originalColumn: mapping.originalColumn,
          name: mapping.name === null ? null : this._names.at(mapping.name)
        };
      }, this).forEach(aCallback, context);
    };
    SourceMapConsumer2.prototype.allGeneratedPositionsFor = function SourceMapConsumer_allGeneratedPositionsFor(aArgs) {
      var line = util.getArg(aArgs, "line");
      var needle = {
        source: util.getArg(aArgs, "source"),
        originalLine: line,
        originalColumn: util.getArg(aArgs, "column", 0)
      };
      needle.source = this._findSourceIndex(needle.source);
      if (needle.source < 0) {
        return [];
      }
      var mappings = [];
      var index2 = this._findMapping(
        needle,
        this._originalMappings,
        "originalLine",
        "originalColumn",
        util.compareByOriginalPositions,
        binarySearch2.LEAST_UPPER_BOUND
      );
      if (index2 >= 0) {
        var mapping = this._originalMappings[index2];
        if (aArgs.column === void 0) {
          var originalLine = mapping.originalLine;
          while (mapping && mapping.originalLine === originalLine) {
            mappings.push({
              line: util.getArg(mapping, "generatedLine", null),
              column: util.getArg(mapping, "generatedColumn", null),
              lastColumn: util.getArg(mapping, "lastGeneratedColumn", null)
            });
            mapping = this._originalMappings[++index2];
          }
        } else {
          var originalColumn = mapping.originalColumn;
          while (mapping && mapping.originalLine === line && mapping.originalColumn == originalColumn) {
            mappings.push({
              line: util.getArg(mapping, "generatedLine", null),
              column: util.getArg(mapping, "generatedColumn", null),
              lastColumn: util.getArg(mapping, "lastGeneratedColumn", null)
            });
            mapping = this._originalMappings[++index2];
          }
        }
      }
      return mappings;
    };
    exports2.SourceMapConsumer = SourceMapConsumer2;
    function BasicSourceMapConsumer(aSourceMap, aSourceMapURL) {
      var sourceMap = aSourceMap;
      if (typeof aSourceMap === "string") {
        sourceMap = util.parseSourceMapInput(aSourceMap);
      }
      var version3 = util.getArg(sourceMap, "version");
      var sources = util.getArg(sourceMap, "sources");
      var names = util.getArg(sourceMap, "names", []);
      var sourceRoot = util.getArg(sourceMap, "sourceRoot", null);
      var sourcesContent = util.getArg(sourceMap, "sourcesContent", null);
      var mappings = util.getArg(sourceMap, "mappings");
      var file = util.getArg(sourceMap, "file", null);
      if (version3 != this._version) {
        throw new Error("Unsupported version: " + version3);
      }
      if (sourceRoot) {
        sourceRoot = util.normalize(sourceRoot);
      }
      sources = sources.map(String).map(util.normalize).map(function(source) {
        return sourceRoot && util.isAbsolute(sourceRoot) && util.isAbsolute(source) ? util.relative(sourceRoot, source) : source;
      });
      this._names = ArraySet.fromArray(names.map(String), true);
      this._sources = ArraySet.fromArray(sources, true);
      this._absoluteSources = this._sources.toArray().map(function(s) {
        return util.computeSourceURL(sourceRoot, s, aSourceMapURL);
      });
      this.sourceRoot = sourceRoot;
      this.sourcesContent = sourcesContent;
      this._mappings = mappings;
      this._sourceMapURL = aSourceMapURL;
      this.file = file;
    }
    BasicSourceMapConsumer.prototype = Object.create(SourceMapConsumer2.prototype);
    BasicSourceMapConsumer.prototype.consumer = SourceMapConsumer2;
    BasicSourceMapConsumer.prototype._findSourceIndex = function(aSource) {
      var relativeSource = aSource;
      if (this.sourceRoot != null) {
        relativeSource = util.relative(this.sourceRoot, relativeSource);
      }
      if (this._sources.has(relativeSource)) {
        return this._sources.indexOf(relativeSource);
      }
      var i;
      for (i = 0; i < this._absoluteSources.length; ++i) {
        if (this._absoluteSources[i] == aSource) {
          return i;
        }
      }
      return -1;
    };
    BasicSourceMapConsumer.fromSourceMap = function SourceMapConsumer_fromSourceMap(aSourceMap, aSourceMapURL) {
      var smc = Object.create(BasicSourceMapConsumer.prototype);
      var names = smc._names = ArraySet.fromArray(aSourceMap._names.toArray(), true);
      var sources = smc._sources = ArraySet.fromArray(aSourceMap._sources.toArray(), true);
      smc.sourceRoot = aSourceMap._sourceRoot;
      smc.sourcesContent = aSourceMap._generateSourcesContent(
        smc._sources.toArray(),
        smc.sourceRoot
      );
      smc.file = aSourceMap._file;
      smc._sourceMapURL = aSourceMapURL;
      smc._absoluteSources = smc._sources.toArray().map(function(s) {
        return util.computeSourceURL(smc.sourceRoot, s, aSourceMapURL);
      });
      var generatedMappings = aSourceMap._mappings.toArray().slice();
      var destGeneratedMappings = smc.__generatedMappings = [];
      var destOriginalMappings = smc.__originalMappings = [];
      for (var i = 0, length3 = generatedMappings.length; i < length3; i++) {
        var srcMapping = generatedMappings[i];
        var destMapping = new Mapping();
        destMapping.generatedLine = srcMapping.generatedLine;
        destMapping.generatedColumn = srcMapping.generatedColumn;
        if (srcMapping.source) {
          destMapping.source = sources.indexOf(srcMapping.source);
          destMapping.originalLine = srcMapping.originalLine;
          destMapping.originalColumn = srcMapping.originalColumn;
          if (srcMapping.name) {
            destMapping.name = names.indexOf(srcMapping.name);
          }
          destOriginalMappings.push(destMapping);
        }
        destGeneratedMappings.push(destMapping);
      }
      quickSort(smc.__originalMappings, util.compareByOriginalPositions);
      return smc;
    };
    BasicSourceMapConsumer.prototype._version = 3;
    Object.defineProperty(BasicSourceMapConsumer.prototype, "sources", {
      get: function() {
        return this._absoluteSources.slice();
      }
    });
    function Mapping() {
      this.generatedLine = 0;
      this.generatedColumn = 0;
      this.source = null;
      this.originalLine = null;
      this.originalColumn = null;
      this.name = null;
    }
    BasicSourceMapConsumer.prototype._parseMappings = function SourceMapConsumer_parseMappings(aStr, aSourceRoot) {
      var generatedLine = 1;
      var previousGeneratedColumn = 0;
      var previousOriginalLine = 0;
      var previousOriginalColumn = 0;
      var previousSource = 0;
      var previousName = 0;
      var length3 = aStr.length;
      var index2 = 0;
      var cachedSegments = {};
      var temp = {};
      var originalMappings = [];
      var generatedMappings = [];
      var mapping, str, segment, end, value;
      while (index2 < length3) {
        if (aStr.charAt(index2) === ";") {
          generatedLine++;
          index2++;
          previousGeneratedColumn = 0;
        } else if (aStr.charAt(index2) === ",") {
          index2++;
        } else {
          mapping = new Mapping();
          mapping.generatedLine = generatedLine;
          for (end = index2; end < length3; end++) {
            if (this._charIsMappingSeparator(aStr, end)) {
              break;
            }
          }
          str = aStr.slice(index2, end);
          segment = cachedSegments[str];
          if (segment) {
            index2 += str.length;
          } else {
            segment = [];
            while (index2 < end) {
              base64VLQ.decode(aStr, index2, temp);
              value = temp.value;
              index2 = temp.rest;
              segment.push(value);
            }
            if (segment.length === 2) {
              throw new Error("Found a source, but no line and column");
            }
            if (segment.length === 3) {
              throw new Error("Found a source and line, but no column");
            }
            cachedSegments[str] = segment;
          }
          mapping.generatedColumn = previousGeneratedColumn + segment[0];
          previousGeneratedColumn = mapping.generatedColumn;
          if (segment.length > 1) {
            mapping.source = previousSource + segment[1];
            previousSource += segment[1];
            mapping.originalLine = previousOriginalLine + segment[2];
            previousOriginalLine = mapping.originalLine;
            mapping.originalLine += 1;
            mapping.originalColumn = previousOriginalColumn + segment[3];
            previousOriginalColumn = mapping.originalColumn;
            if (segment.length > 4) {
              mapping.name = previousName + segment[4];
              previousName += segment[4];
            }
          }
          generatedMappings.push(mapping);
          if (typeof mapping.originalLine === "number") {
            originalMappings.push(mapping);
          }
        }
      }
      quickSort(generatedMappings, util.compareByGeneratedPositionsDeflated);
      this.__generatedMappings = generatedMappings;
      quickSort(originalMappings, util.compareByOriginalPositions);
      this.__originalMappings = originalMappings;
    };
    BasicSourceMapConsumer.prototype._findMapping = function SourceMapConsumer_findMapping(aNeedle, aMappings, aLineName, aColumnName, aComparator, aBias) {
      if (aNeedle[aLineName] <= 0) {
        throw new TypeError("Line must be greater than or equal to 1, got " + aNeedle[aLineName]);
      }
      if (aNeedle[aColumnName] < 0) {
        throw new TypeError("Column must be greater than or equal to 0, got " + aNeedle[aColumnName]);
      }
      return binarySearch2.search(aNeedle, aMappings, aComparator, aBias);
    };
    BasicSourceMapConsumer.prototype.computeColumnSpans = function SourceMapConsumer_computeColumnSpans() {
      for (var index2 = 0; index2 < this._generatedMappings.length; ++index2) {
        var mapping = this._generatedMappings[index2];
        if (index2 + 1 < this._generatedMappings.length) {
          var nextMapping = this._generatedMappings[index2 + 1];
          if (mapping.generatedLine === nextMapping.generatedLine) {
            mapping.lastGeneratedColumn = nextMapping.generatedColumn - 1;
            continue;
          }
        }
        mapping.lastGeneratedColumn = Infinity;
      }
    };
    BasicSourceMapConsumer.prototype.originalPositionFor = function SourceMapConsumer_originalPositionFor(aArgs) {
      var needle = {
        generatedLine: util.getArg(aArgs, "line"),
        generatedColumn: util.getArg(aArgs, "column")
      };
      var index2 = this._findMapping(
        needle,
        this._generatedMappings,
        "generatedLine",
        "generatedColumn",
        util.compareByGeneratedPositionsDeflated,
        util.getArg(aArgs, "bias", SourceMapConsumer2.GREATEST_LOWER_BOUND)
      );
      if (index2 >= 0) {
        var mapping = this._generatedMappings[index2];
        if (mapping.generatedLine === needle.generatedLine) {
          var source = util.getArg(mapping, "source", null);
          if (source !== null) {
            source = this._sources.at(source);
            source = util.computeSourceURL(this.sourceRoot, source, this._sourceMapURL);
          }
          var name = util.getArg(mapping, "name", null);
          if (name !== null) {
            name = this._names.at(name);
          }
          return {
            source,
            line: util.getArg(mapping, "originalLine", null),
            column: util.getArg(mapping, "originalColumn", null),
            name
          };
        }
      }
      return {
        source: null,
        line: null,
        column: null,
        name: null
      };
    };
    BasicSourceMapConsumer.prototype.hasContentsOfAllSources = function BasicSourceMapConsumer_hasContentsOfAllSources() {
      if (!this.sourcesContent) {
        return false;
      }
      return this.sourcesContent.length >= this._sources.size() && !this.sourcesContent.some(function(sc) {
        return sc == null;
      });
    };
    BasicSourceMapConsumer.prototype.sourceContentFor = function SourceMapConsumer_sourceContentFor(aSource, nullOnMissing) {
      if (!this.sourcesContent) {
        return null;
      }
      var index2 = this._findSourceIndex(aSource);
      if (index2 >= 0) {
        return this.sourcesContent[index2];
      }
      var relativeSource = aSource;
      if (this.sourceRoot != null) {
        relativeSource = util.relative(this.sourceRoot, relativeSource);
      }
      var url;
      if (this.sourceRoot != null && (url = util.urlParse(this.sourceRoot))) {
        var fileUriAbsPath = relativeSource.replace(/^file:\/\//, "");
        if (url.scheme == "file" && this._sources.has(fileUriAbsPath)) {
          return this.sourcesContent[this._sources.indexOf(fileUriAbsPath)];
        }
        if ((!url.path || url.path == "/") && this._sources.has("/" + relativeSource)) {
          return this.sourcesContent[this._sources.indexOf("/" + relativeSource)];
        }
      }
      if (nullOnMissing) {
        return null;
      } else {
        throw new Error('"' + relativeSource + '" is not in the SourceMap.');
      }
    };
    BasicSourceMapConsumer.prototype.generatedPositionFor = function SourceMapConsumer_generatedPositionFor(aArgs) {
      var source = util.getArg(aArgs, "source");
      source = this._findSourceIndex(source);
      if (source < 0) {
        return {
          line: null,
          column: null,
          lastColumn: null
        };
      }
      var needle = {
        source,
        originalLine: util.getArg(aArgs, "line"),
        originalColumn: util.getArg(aArgs, "column")
      };
      var index2 = this._findMapping(
        needle,
        this._originalMappings,
        "originalLine",
        "originalColumn",
        util.compareByOriginalPositions,
        util.getArg(aArgs, "bias", SourceMapConsumer2.GREATEST_LOWER_BOUND)
      );
      if (index2 >= 0) {
        var mapping = this._originalMappings[index2];
        if (mapping.source === needle.source) {
          return {
            line: util.getArg(mapping, "generatedLine", null),
            column: util.getArg(mapping, "generatedColumn", null),
            lastColumn: util.getArg(mapping, "lastGeneratedColumn", null)
          };
        }
      }
      return {
        line: null,
        column: null,
        lastColumn: null
      };
    };
    exports2.BasicSourceMapConsumer = BasicSourceMapConsumer;
    function IndexedSourceMapConsumer(aSourceMap, aSourceMapURL) {
      var sourceMap = aSourceMap;
      if (typeof aSourceMap === "string") {
        sourceMap = util.parseSourceMapInput(aSourceMap);
      }
      var version3 = util.getArg(sourceMap, "version");
      var sections = util.getArg(sourceMap, "sections");
      if (version3 != this._version) {
        throw new Error("Unsupported version: " + version3);
      }
      this._sources = new ArraySet();
      this._names = new ArraySet();
      var lastOffset = {
        line: -1,
        column: 0
      };
      this._sections = sections.map(function(s) {
        if (s.url) {
          throw new Error("Support for url field in sections not implemented.");
        }
        var offset2 = util.getArg(s, "offset");
        var offsetLine = util.getArg(offset2, "line");
        var offsetColumn = util.getArg(offset2, "column");
        if (offsetLine < lastOffset.line || offsetLine === lastOffset.line && offsetColumn < lastOffset.column) {
          throw new Error("Section offsets must be ordered and non-overlapping.");
        }
        lastOffset = offset2;
        return {
          generatedOffset: {
            // The offset fields are 0-based, but we use 1-based indices when
            // encoding/decoding from VLQ.
            generatedLine: offsetLine + 1,
            generatedColumn: offsetColumn + 1
          },
          consumer: new SourceMapConsumer2(util.getArg(s, "map"), aSourceMapURL)
        };
      });
    }
    IndexedSourceMapConsumer.prototype = Object.create(SourceMapConsumer2.prototype);
    IndexedSourceMapConsumer.prototype.constructor = SourceMapConsumer2;
    IndexedSourceMapConsumer.prototype._version = 3;
    Object.defineProperty(IndexedSourceMapConsumer.prototype, "sources", {
      get: function() {
        var sources = [];
        for (var i = 0; i < this._sections.length; i++) {
          for (var j = 0; j < this._sections[i].consumer.sources.length; j++) {
            sources.push(this._sections[i].consumer.sources[j]);
          }
        }
        return sources;
      }
    });
    IndexedSourceMapConsumer.prototype.originalPositionFor = function IndexedSourceMapConsumer_originalPositionFor(aArgs) {
      var needle = {
        generatedLine: util.getArg(aArgs, "line"),
        generatedColumn: util.getArg(aArgs, "column")
      };
      var sectionIndex = binarySearch2.search(
        needle,
        this._sections,
        function(needle2, section2) {
          var cmp = needle2.generatedLine - section2.generatedOffset.generatedLine;
          if (cmp) {
            return cmp;
          }
          return needle2.generatedColumn - section2.generatedOffset.generatedColumn;
        }
      );
      var section = this._sections[sectionIndex];
      if (!section) {
        return {
          source: null,
          line: null,
          column: null,
          name: null
        };
      }
      return section.consumer.originalPositionFor({
        line: needle.generatedLine - (section.generatedOffset.generatedLine - 1),
        column: needle.generatedColumn - (section.generatedOffset.generatedLine === needle.generatedLine ? section.generatedOffset.generatedColumn - 1 : 0),
        bias: aArgs.bias
      });
    };
    IndexedSourceMapConsumer.prototype.hasContentsOfAllSources = function IndexedSourceMapConsumer_hasContentsOfAllSources() {
      return this._sections.every(function(s) {
        return s.consumer.hasContentsOfAllSources();
      });
    };
    IndexedSourceMapConsumer.prototype.sourceContentFor = function IndexedSourceMapConsumer_sourceContentFor(aSource, nullOnMissing) {
      for (var i = 0; i < this._sections.length; i++) {
        var section = this._sections[i];
        var content = section.consumer.sourceContentFor(aSource, true);
        if (content) {
          return content;
        }
      }
      if (nullOnMissing) {
        return null;
      } else {
        throw new Error('"' + aSource + '" is not in the SourceMap.');
      }
    };
    IndexedSourceMapConsumer.prototype.generatedPositionFor = function IndexedSourceMapConsumer_generatedPositionFor(aArgs) {
      for (var i = 0; i < this._sections.length; i++) {
        var section = this._sections[i];
        if (section.consumer._findSourceIndex(util.getArg(aArgs, "source")) === -1) {
          continue;
        }
        var generatedPosition2 = section.consumer.generatedPositionFor(aArgs);
        if (generatedPosition2) {
          var ret = {
            line: generatedPosition2.line + (section.generatedOffset.generatedLine - 1),
            column: generatedPosition2.column + (section.generatedOffset.generatedLine === generatedPosition2.line ? section.generatedOffset.generatedColumn - 1 : 0)
          };
          return ret;
        }
      }
      return {
        line: null,
        column: null
      };
    };
    IndexedSourceMapConsumer.prototype._parseMappings = function IndexedSourceMapConsumer_parseMappings(aStr, aSourceRoot) {
      this.__generatedMappings = [];
      this.__originalMappings = [];
      for (var i = 0; i < this._sections.length; i++) {
        var section = this._sections[i];
        var sectionMappings = section.consumer._generatedMappings;
        for (var j = 0; j < sectionMappings.length; j++) {
          var mapping = sectionMappings[j];
          var source = section.consumer._sources.at(mapping.source);
          source = util.computeSourceURL(section.consumer.sourceRoot, source, this._sourceMapURL);
          this._sources.add(source);
          source = this._sources.indexOf(source);
          var name = null;
          if (mapping.name) {
            name = section.consumer._names.at(mapping.name);
            this._names.add(name);
            name = this._names.indexOf(name);
          }
          var adjustedMapping = {
            source,
            generatedLine: mapping.generatedLine + (section.generatedOffset.generatedLine - 1),
            generatedColumn: mapping.generatedColumn + (section.generatedOffset.generatedLine === mapping.generatedLine ? section.generatedOffset.generatedColumn - 1 : 0),
            originalLine: mapping.originalLine,
            originalColumn: mapping.originalColumn,
            name
          };
          this.__generatedMappings.push(adjustedMapping);
          if (typeof adjustedMapping.originalLine === "number") {
            this.__originalMappings.push(adjustedMapping);
          }
        }
      }
      quickSort(this.__generatedMappings, util.compareByGeneratedPositionsDeflated);
      quickSort(this.__originalMappings, util.compareByOriginalPositions);
    };
    exports2.IndexedSourceMapConsumer = IndexedSourceMapConsumer;
  }
});

// node_modules/source-map/lib/source-node.js
var require_source_node = __commonJS({
  "node_modules/source-map/lib/source-node.js"(exports2) {
    var SourceMapGenerator2 = require_source_map_generator().SourceMapGenerator;
    var util = require_util();
    var REGEX_NEWLINE = /(\r?\n)/;
    var NEWLINE_CODE = 10;
    var isSourceNode = "$$$isSourceNode$$$";
    function SourceNode(aLine, aColumn, aSource, aChunks, aName) {
      this.children = [];
      this.sourceContents = {};
      this.line = aLine == null ? null : aLine;
      this.column = aColumn == null ? null : aColumn;
      this.source = aSource == null ? null : aSource;
      this.name = aName == null ? null : aName;
      this[isSourceNode] = true;
      if (aChunks != null) this.add(aChunks);
    }
    SourceNode.fromStringWithSourceMap = function SourceNode_fromStringWithSourceMap(aGeneratedCode, aSourceMapConsumer, aRelativePath) {
      var node = new SourceNode();
      var remainingLines = aGeneratedCode.split(REGEX_NEWLINE);
      var remainingLinesIndex = 0;
      var shiftNextLine = function() {
        var lineContents = getNextLine();
        var newLine = getNextLine() || "";
        return lineContents + newLine;
        function getNextLine() {
          return remainingLinesIndex < remainingLines.length ? remainingLines[remainingLinesIndex++] : void 0;
        }
      };
      var lastGeneratedLine = 1, lastGeneratedColumn = 0;
      var lastMapping = null;
      aSourceMapConsumer.eachMapping(function(mapping) {
        if (lastMapping !== null) {
          if (lastGeneratedLine < mapping.generatedLine) {
            addMappingWithCode(lastMapping, shiftNextLine());
            lastGeneratedLine++;
            lastGeneratedColumn = 0;
          } else {
            var nextLine = remainingLines[remainingLinesIndex] || "";
            var code = nextLine.substr(0, mapping.generatedColumn - lastGeneratedColumn);
            remainingLines[remainingLinesIndex] = nextLine.substr(mapping.generatedColumn - lastGeneratedColumn);
            lastGeneratedColumn = mapping.generatedColumn;
            addMappingWithCode(lastMapping, code);
            lastMapping = mapping;
            return;
          }
        }
        while (lastGeneratedLine < mapping.generatedLine) {
          node.add(shiftNextLine());
          lastGeneratedLine++;
        }
        if (lastGeneratedColumn < mapping.generatedColumn) {
          var nextLine = remainingLines[remainingLinesIndex] || "";
          node.add(nextLine.substr(0, mapping.generatedColumn));
          remainingLines[remainingLinesIndex] = nextLine.substr(mapping.generatedColumn);
          lastGeneratedColumn = mapping.generatedColumn;
        }
        lastMapping = mapping;
      }, this);
      if (remainingLinesIndex < remainingLines.length) {
        if (lastMapping) {
          addMappingWithCode(lastMapping, shiftNextLine());
        }
        node.add(remainingLines.splice(remainingLinesIndex).join(""));
      }
      aSourceMapConsumer.sources.forEach(function(sourceFile) {
        var content = aSourceMapConsumer.sourceContentFor(sourceFile);
        if (content != null) {
          if (aRelativePath != null) {
            sourceFile = util.join(aRelativePath, sourceFile);
          }
          node.setSourceContent(sourceFile, content);
        }
      });
      return node;
      function addMappingWithCode(mapping, code) {
        if (mapping === null || mapping.source === void 0) {
          node.add(code);
        } else {
          var source = aRelativePath ? util.join(aRelativePath, mapping.source) : mapping.source;
          node.add(new SourceNode(
            mapping.originalLine,
            mapping.originalColumn,
            source,
            code,
            mapping.name
          ));
        }
      }
    };
    SourceNode.prototype.add = function SourceNode_add(aChunk) {
      if (Array.isArray(aChunk)) {
        aChunk.forEach(function(chunk) {
          this.add(chunk);
        }, this);
      } else if (aChunk[isSourceNode] || typeof aChunk === "string") {
        if (aChunk) {
          this.children.push(aChunk);
        }
      } else {
        throw new TypeError(
          "Expected a SourceNode, string, or an array of SourceNodes and strings. Got " + aChunk
        );
      }
      return this;
    };
    SourceNode.prototype.prepend = function SourceNode_prepend(aChunk) {
      if (Array.isArray(aChunk)) {
        for (var i = aChunk.length - 1; i >= 0; i--) {
          this.prepend(aChunk[i]);
        }
      } else if (aChunk[isSourceNode] || typeof aChunk === "string") {
        this.children.unshift(aChunk);
      } else {
        throw new TypeError(
          "Expected a SourceNode, string, or an array of SourceNodes and strings. Got " + aChunk
        );
      }
      return this;
    };
    SourceNode.prototype.walk = function SourceNode_walk(aFn) {
      var chunk;
      for (var i = 0, len = this.children.length; i < len; i++) {
        chunk = this.children[i];
        if (chunk[isSourceNode]) {
          chunk.walk(aFn);
        } else {
          if (chunk !== "") {
            aFn(chunk, {
              source: this.source,
              line: this.line,
              column: this.column,
              name: this.name
            });
          }
        }
      }
    };
    SourceNode.prototype.join = function SourceNode_join(aSep) {
      var newChildren;
      var i;
      var len = this.children.length;
      if (len > 0) {
        newChildren = [];
        for (i = 0; i < len - 1; i++) {
          newChildren.push(this.children[i]);
          newChildren.push(aSep);
        }
        newChildren.push(this.children[i]);
        this.children = newChildren;
      }
      return this;
    };
    SourceNode.prototype.replaceRight = function SourceNode_replaceRight(aPattern, aReplacement) {
      var lastChild = this.children[this.children.length - 1];
      if (lastChild[isSourceNode]) {
        lastChild.replaceRight(aPattern, aReplacement);
      } else if (typeof lastChild === "string") {
        this.children[this.children.length - 1] = lastChild.replace(aPattern, aReplacement);
      } else {
        this.children.push("".replace(aPattern, aReplacement));
      }
      return this;
    };
    SourceNode.prototype.setSourceContent = function SourceNode_setSourceContent(aSourceFile, aSourceContent) {
      this.sourceContents[util.toSetString(aSourceFile)] = aSourceContent;
    };
    SourceNode.prototype.walkSourceContents = function SourceNode_walkSourceContents(aFn) {
      for (var i = 0, len = this.children.length; i < len; i++) {
        if (this.children[i][isSourceNode]) {
          this.children[i].walkSourceContents(aFn);
        }
      }
      var sources = Object.keys(this.sourceContents);
      for (var i = 0, len = sources.length; i < len; i++) {
        aFn(util.fromSetString(sources[i]), this.sourceContents[sources[i]]);
      }
    };
    SourceNode.prototype.toString = function SourceNode_toString() {
      var str = "";
      this.walk(function(chunk) {
        str += chunk;
      });
      return str;
    };
    SourceNode.prototype.toStringWithSourceMap = function SourceNode_toStringWithSourceMap(aArgs) {
      var generated = {
        code: "",
        line: 1,
        column: 0
      };
      var map2 = new SourceMapGenerator2(aArgs);
      var sourceMappingActive = false;
      var lastOriginalSource = null;
      var lastOriginalLine = null;
      var lastOriginalColumn = null;
      var lastOriginalName = null;
      this.walk(function(chunk, original) {
        generated.code += chunk;
        if (original.source !== null && original.line !== null && original.column !== null) {
          if (lastOriginalSource !== original.source || lastOriginalLine !== original.line || lastOriginalColumn !== original.column || lastOriginalName !== original.name) {
            map2.addMapping({
              source: original.source,
              original: {
                line: original.line,
                column: original.column
              },
              generated: {
                line: generated.line,
                column: generated.column
              },
              name: original.name
            });
          }
          lastOriginalSource = original.source;
          lastOriginalLine = original.line;
          lastOriginalColumn = original.column;
          lastOriginalName = original.name;
          sourceMappingActive = true;
        } else if (sourceMappingActive) {
          map2.addMapping({
            generated: {
              line: generated.line,
              column: generated.column
            }
          });
          lastOriginalSource = null;
          sourceMappingActive = false;
        }
        for (var idx = 0, length3 = chunk.length; idx < length3; idx++) {
          if (chunk.charCodeAt(idx) === NEWLINE_CODE) {
            generated.line++;
            generated.column = 0;
            if (idx + 1 === length3) {
              lastOriginalSource = null;
              sourceMappingActive = false;
            } else if (sourceMappingActive) {
              map2.addMapping({
                source: original.source,
                original: {
                  line: original.line,
                  column: original.column
                },
                generated: {
                  line: generated.line,
                  column: generated.column
                },
                name: original.name
              });
            }
          } else {
            generated.column++;
          }
        }
      });
      this.walkSourceContents(function(sourceFile, sourceContent) {
        map2.setSourceContent(sourceFile, sourceContent);
      });
      return { code: generated.code, map: map2 };
    };
    exports2.SourceNode = SourceNode;
  }
});

// node_modules/source-map/source-map.js
var require_source_map = __commonJS({
  "node_modules/source-map/source-map.js"(exports2) {
    exports2.SourceMapGenerator = require_source_map_generator().SourceMapGenerator;
    exports2.SourceMapConsumer = require_source_map_consumer().SourceMapConsumer;
    exports2.SourceNode = require_source_node().SourceNode;
  }
});

// node_modules/buffer-from/index.js
var require_buffer_from = __commonJS({
  "node_modules/buffer-from/index.js"(exports2, module2) {
    var toString7 = Object.prototype.toString;
    var isModern = typeof Buffer !== "undefined" && typeof Buffer.alloc === "function" && typeof Buffer.allocUnsafe === "function" && typeof Buffer.from === "function";
    function isArrayBuffer(input) {
      return toString7.call(input).slice(8, -1) === "ArrayBuffer";
    }
    function fromArrayBuffer(obj, byteOffset, length3) {
      byteOffset >>>= 0;
      var maxLength = obj.byteLength - byteOffset;
      if (maxLength < 0) {
        throw new RangeError("'offset' is out of bounds");
      }
      if (length3 === void 0) {
        length3 = maxLength;
      } else {
        length3 >>>= 0;
        if (length3 > maxLength) {
          throw new RangeError("'length' is out of bounds");
        }
      }
      return isModern ? Buffer.from(obj.slice(byteOffset, byteOffset + length3)) : new Buffer(new Uint8Array(obj.slice(byteOffset, byteOffset + length3)));
    }
    function fromString(string, encoding) {
      if (typeof encoding !== "string" || encoding === "") {
        encoding = "utf8";
      }
      if (!Buffer.isEncoding(encoding)) {
        throw new TypeError('"encoding" must be a valid string encoding');
      }
      return isModern ? Buffer.from(string, encoding) : new Buffer(string, encoding);
    }
    function bufferFrom(value, encodingOrOffset, length3) {
      if (typeof value === "number") {
        throw new TypeError('"value" argument must not be a number');
      }
      if (isArrayBuffer(value)) {
        return fromArrayBuffer(value, encodingOrOffset, length3);
      }
      if (typeof value === "string") {
        return fromString(value, encodingOrOffset);
      }
      return isModern ? Buffer.from(value) : new Buffer(value);
    }
    module2.exports = bufferFrom;
  }
});

// node_modules/source-map-support/source-map-support.js
var require_source_map_support = __commonJS({
  "node_modules/source-map-support/source-map-support.js"(exports2, module2) {
    var SourceMapConsumer2 = require_source_map().SourceMapConsumer;
    var path6 = require("path");
    var fs3;
    try {
      fs3 = require("fs");
      if (!fs3.existsSync || !fs3.readFileSync) {
        fs3 = null;
      }
    } catch (err2) {
    }
    var bufferFrom = require_buffer_from();
    function dynamicRequire(mod, request) {
      return mod.require(request);
    }
    var errorFormatterInstalled = false;
    var uncaughtShimInstalled = false;
    var emptyCacheBetweenOperations = false;
    var environment = "auto";
    var fileContentsCache = {};
    var sourceMapCache = {};
    var reSourceMap = /^data:application\/json[^,]+base64,/;
    var retrieveFileHandlers = [];
    var retrieveMapHandlers = [];
    function isInBrowser() {
      if (environment === "browser")
        return true;
      if (environment === "node")
        return false;
      return typeof window !== "undefined" && typeof XMLHttpRequest === "function" && !(window.require && window.module && window.process && window.process.type === "renderer");
    }
    function hasGlobalProcessEventEmitter() {
      return typeof process === "object" && process !== null && typeof process.on === "function";
    }
    function globalProcessVersion() {
      if (typeof process === "object" && process !== null) {
        return process.version;
      } else {
        return "";
      }
    }
    function globalProcessStderr() {
      if (typeof process === "object" && process !== null) {
        return process.stderr;
      }
    }
    function globalProcessExit(code) {
      if (typeof process === "object" && process !== null && typeof process.exit === "function") {
        return process.exit(code);
      }
    }
    function handlerExec(list) {
      return function(arg) {
        for (var i = 0; i < list.length; i++) {
          var ret = list[i](arg);
          if (ret) {
            return ret;
          }
        }
        return null;
      };
    }
    var retrieveFile = handlerExec(retrieveFileHandlers);
    retrieveFileHandlers.push(function(path7) {
      path7 = path7.trim();
      if (/^file:/.test(path7)) {
        path7 = path7.replace(/file:\/\/\/(\w:)?/, function(protocol, drive) {
          return drive ? "" : (
            // file:///C:/dir/file -> C:/dir/file
            "/"
          );
        });
      }
      if (path7 in fileContentsCache) {
        return fileContentsCache[path7];
      }
      var contents = "";
      try {
        if (!fs3) {
          var xhr = new XMLHttpRequest();
          xhr.open(
            "GET",
            path7,
            /** async */
            false
          );
          xhr.send(null);
          if (xhr.readyState === 4 && xhr.status === 200) {
            contents = xhr.responseText;
          }
        } else if (fs3.existsSync(path7)) {
          contents = fs3.readFileSync(path7, "utf8");
        }
      } catch (er) {
      }
      return fileContentsCache[path7] = contents;
    });
    function supportRelativeURL(file, url) {
      if (!file) return url;
      var dir = path6.dirname(file);
      var match2 = /^\w+:\/\/[^\/]*/.exec(dir);
      var protocol = match2 ? match2[0] : "";
      var startPath = dir.slice(protocol.length);
      if (protocol && /^\/\w\:/.test(startPath)) {
        protocol += "/";
        return protocol + path6.resolve(dir.slice(protocol.length), url).replace(/\\/g, "/");
      }
      return protocol + path6.resolve(dir.slice(protocol.length), url);
    }
    function retrieveSourceMapURL(source) {
      var fileData;
      if (isInBrowser()) {
        try {
          var xhr = new XMLHttpRequest();
          xhr.open("GET", source, false);
          xhr.send(null);
          fileData = xhr.readyState === 4 ? xhr.responseText : null;
          var sourceMapHeader = xhr.getResponseHeader("SourceMap") || xhr.getResponseHeader("X-SourceMap");
          if (sourceMapHeader) {
            return sourceMapHeader;
          }
        } catch (e) {
        }
      }
      fileData = retrieveFile(source);
      var re = /(?:\/\/[@#][\s]*sourceMappingURL=([^\s'"]+)[\s]*$)|(?:\/\*[@#][\s]*sourceMappingURL=([^\s*'"]+)[\s]*(?:\*\/)[\s]*$)/mg;
      var lastMatch, match2;
      while (match2 = re.exec(fileData)) lastMatch = match2;
      if (!lastMatch) return null;
      return lastMatch[1];
    }
    var retrieveSourceMap = handlerExec(retrieveMapHandlers);
    retrieveMapHandlers.push(function(source) {
      var sourceMappingURL = retrieveSourceMapURL(source);
      if (!sourceMappingURL) return null;
      var sourceMapData;
      if (reSourceMap.test(sourceMappingURL)) {
        var rawData = sourceMappingURL.slice(sourceMappingURL.indexOf(",") + 1);
        sourceMapData = bufferFrom(rawData, "base64").toString();
        sourceMappingURL = source;
      } else {
        sourceMappingURL = supportRelativeURL(source, sourceMappingURL);
        sourceMapData = retrieveFile(sourceMappingURL);
      }
      if (!sourceMapData) {
        return null;
      }
      return {
        url: sourceMappingURL,
        map: sourceMapData
      };
    });
    function mapSourcePosition(position) {
      var sourceMap = sourceMapCache[position.source];
      if (!sourceMap) {
        var urlAndMap = retrieveSourceMap(position.source);
        if (urlAndMap) {
          sourceMap = sourceMapCache[position.source] = {
            url: urlAndMap.url,
            map: new SourceMapConsumer2(urlAndMap.map)
          };
          if (sourceMap.map.sourcesContent) {
            sourceMap.map.sources.forEach(function(source, i) {
              var contents = sourceMap.map.sourcesContent[i];
              if (contents) {
                var url = supportRelativeURL(sourceMap.url, source);
                fileContentsCache[url] = contents;
              }
            });
          }
        } else {
          sourceMap = sourceMapCache[position.source] = {
            url: null,
            map: null
          };
        }
      }
      if (sourceMap && sourceMap.map && typeof sourceMap.map.originalPositionFor === "function") {
        var originalPosition = sourceMap.map.originalPositionFor(position);
        if (originalPosition.source !== null) {
          originalPosition.source = supportRelativeURL(
            sourceMap.url,
            originalPosition.source
          );
          return originalPosition;
        }
      }
      return position;
    }
    function mapEvalOrigin(origin) {
      var match2 = /^eval at ([^(]+) \((.+):(\d+):(\d+)\)$/.exec(origin);
      if (match2) {
        var position = mapSourcePosition({
          source: match2[2],
          line: +match2[3],
          column: match2[4] - 1
        });
        return "eval at " + match2[1] + " (" + position.source + ":" + position.line + ":" + (position.column + 1) + ")";
      }
      match2 = /^eval at ([^(]+) \((.+)\)$/.exec(origin);
      if (match2) {
        return "eval at " + match2[1] + " (" + mapEvalOrigin(match2[2]) + ")";
      }
      return origin;
    }
    function CallSiteToString() {
      var fileName;
      var fileLocation = "";
      if (this.isNative()) {
        fileLocation = "native";
      } else {
        fileName = this.getScriptNameOrSourceURL();
        if (!fileName && this.isEval()) {
          fileLocation = this.getEvalOrigin();
          fileLocation += ", ";
        }
        if (fileName) {
          fileLocation += fileName;
        } else {
          fileLocation += "<anonymous>";
        }
        var lineNumber = this.getLineNumber();
        if (lineNumber != null) {
          fileLocation += ":" + lineNumber;
          var columnNumber = this.getColumnNumber();
          if (columnNumber) {
            fileLocation += ":" + columnNumber;
          }
        }
      }
      var line = "";
      var functionName = this.getFunctionName();
      var addSuffix = true;
      var isConstructor = this.isConstructor();
      var isMethodCall = !(this.isToplevel() || isConstructor);
      if (isMethodCall) {
        var typeName = this.getTypeName();
        if (typeName === "[object Object]") {
          typeName = "null";
        }
        var methodName = this.getMethodName();
        if (functionName) {
          if (typeName && functionName.indexOf(typeName) != 0) {
            line += typeName + ".";
          }
          line += functionName;
          if (methodName && functionName.indexOf("." + methodName) != functionName.length - methodName.length - 1) {
            line += " [as " + methodName + "]";
          }
        } else {
          line += typeName + "." + (methodName || "<anonymous>");
        }
      } else if (isConstructor) {
        line += "new " + (functionName || "<anonymous>");
      } else if (functionName) {
        line += functionName;
      } else {
        line += fileLocation;
        addSuffix = false;
      }
      if (addSuffix) {
        line += " (" + fileLocation + ")";
      }
      return line;
    }
    function cloneCallSite(frame) {
      var object = {};
      Object.getOwnPropertyNames(Object.getPrototypeOf(frame)).forEach(function(name) {
        object[name] = /^(?:is|get)/.test(name) ? function() {
          return frame[name].call(frame);
        } : frame[name];
      });
      object.toString = CallSiteToString;
      return object;
    }
    function wrapCallSite(frame, state) {
      if (state === void 0) {
        state = { nextPosition: null, curPosition: null };
      }
      if (frame.isNative()) {
        state.curPosition = null;
        return frame;
      }
      var source = frame.getFileName() || frame.getScriptNameOrSourceURL();
      if (source) {
        var line = frame.getLineNumber();
        var column = frame.getColumnNumber() - 1;
        var noHeader = /^v(10\.1[6-9]|10\.[2-9][0-9]|10\.[0-9]{3,}|1[2-9]\d*|[2-9]\d|\d{3,}|11\.11)/;
        var headerLength = noHeader.test(globalProcessVersion()) ? 0 : 62;
        if (line === 1 && column > headerLength && !isInBrowser() && !frame.isEval()) {
          column -= headerLength;
        }
        var position = mapSourcePosition({
          source,
          line,
          column
        });
        state.curPosition = position;
        frame = cloneCallSite(frame);
        var originalFunctionName = frame.getFunctionName;
        frame.getFunctionName = function() {
          if (state.nextPosition == null) {
            return originalFunctionName();
          }
          return state.nextPosition.name || originalFunctionName();
        };
        frame.getFileName = function() {
          return position.source;
        };
        frame.getLineNumber = function() {
          return position.line;
        };
        frame.getColumnNumber = function() {
          return position.column + 1;
        };
        frame.getScriptNameOrSourceURL = function() {
          return position.source;
        };
        return frame;
      }
      var origin = frame.isEval() && frame.getEvalOrigin();
      if (origin) {
        origin = mapEvalOrigin(origin);
        frame = cloneCallSite(frame);
        frame.getEvalOrigin = function() {
          return origin;
        };
        return frame;
      }
      return frame;
    }
    function prepareStackTrace(error2, stack) {
      if (emptyCacheBetweenOperations) {
        fileContentsCache = {};
        sourceMapCache = {};
      }
      var name = error2.name || "Error";
      var message = error2.message || "";
      var errorString = name + ": " + message;
      var state = { nextPosition: null, curPosition: null };
      var processedStack = [];
      for (var i = stack.length - 1; i >= 0; i--) {
        processedStack.push("\n    at " + wrapCallSite(stack[i], state));
        state.nextPosition = state.curPosition;
      }
      state.curPosition = state.nextPosition = null;
      return errorString + processedStack.reverse().join("");
    }
    function getErrorSource(error2) {
      var match2 = /\n    at [^(]+ \((.*):(\d+):(\d+)\)/.exec(error2.stack);
      if (match2) {
        var source = match2[1];
        var line = +match2[2];
        var column = +match2[3];
        var contents = fileContentsCache[source];
        if (!contents && fs3 && fs3.existsSync(source)) {
          try {
            contents = fs3.readFileSync(source, "utf8");
          } catch (er) {
            contents = "";
          }
        }
        if (contents) {
          var code = contents.split(/(?:\r\n|\r|\n)/)[line - 1];
          if (code) {
            return source + ":" + line + "\n" + code + "\n" + new Array(column).join(" ") + "^";
          }
        }
      }
      return null;
    }
    function printErrorAndExit(error2) {
      var source = getErrorSource(error2);
      var stderr = globalProcessStderr();
      if (stderr && stderr._handle && stderr._handle.setBlocking) {
        stderr._handle.setBlocking(true);
      }
      if (source) {
        console.error();
        console.error(source);
      }
      console.error(error2.stack);
      globalProcessExit(1);
    }
    function shimEmitUncaughtException() {
      var origEmit = process.emit;
      process.emit = function(type) {
        if (type === "uncaughtException") {
          var hasStack = arguments[1] && arguments[1].stack;
          var hasListeners = this.listeners(type).length > 0;
          if (hasStack && !hasListeners) {
            return printErrorAndExit(arguments[1]);
          }
        }
        return origEmit.apply(this, arguments);
      };
    }
    var originalRetrieveFileHandlers = retrieveFileHandlers.slice(0);
    var originalRetrieveMapHandlers = retrieveMapHandlers.slice(0);
    exports2.wrapCallSite = wrapCallSite;
    exports2.getErrorSource = getErrorSource;
    exports2.mapSourcePosition = mapSourcePosition;
    exports2.retrieveSourceMap = retrieveSourceMap;
    exports2.install = function(options) {
      options = options || {};
      if (options.environment) {
        environment = options.environment;
        if (["node", "browser", "auto"].indexOf(environment) === -1) {
          throw new Error("environment " + environment + " was unknown. Available options are {auto, browser, node}");
        }
      }
      if (options.retrieveFile) {
        if (options.overrideRetrieveFile) {
          retrieveFileHandlers.length = 0;
        }
        retrieveFileHandlers.unshift(options.retrieveFile);
      }
      if (options.retrieveSourceMap) {
        if (options.overrideRetrieveSourceMap) {
          retrieveMapHandlers.length = 0;
        }
        retrieveMapHandlers.unshift(options.retrieveSourceMap);
      }
      if (options.hookRequire && !isInBrowser()) {
        var Module2 = dynamicRequire(module2, "module");
        var $compile = Module2.prototype._compile;
        if (!$compile.__sourceMapSupport) {
          Module2.prototype._compile = function(content, filename) {
            fileContentsCache[filename] = content;
            sourceMapCache[filename] = void 0;
            return $compile.call(this, content, filename);
          };
          Module2.prototype._compile.__sourceMapSupport = true;
        }
      }
      if (!emptyCacheBetweenOperations) {
        emptyCacheBetweenOperations = "emptyCacheBetweenOperations" in options ? options.emptyCacheBetweenOperations : false;
      }
      if (!errorFormatterInstalled) {
        errorFormatterInstalled = true;
        Error.prepareStackTrace = prepareStackTrace;
      }
      if (!uncaughtShimInstalled) {
        var installHandler = "handleUncaughtExceptions" in options ? options.handleUncaughtExceptions : true;
        try {
          var worker_threads = dynamicRequire(module2, "worker_threads");
          if (worker_threads.isMainThread === false) {
            installHandler = false;
          }
        } catch (e) {
        }
        if (installHandler && hasGlobalProcessEventEmitter()) {
          uncaughtShimInstalled = true;
          shimEmitUncaughtException();
        }
      }
    };
    exports2.resetRetrieveHandlers = function() {
      retrieveFileHandlers.length = 0;
      retrieveMapHandlers.length = 0;
      retrieveFileHandlers = originalRetrieveFileHandlers.slice(0);
      retrieveMapHandlers = originalRetrieveMapHandlers.slice(0);
      retrieveSourceMap = handlerExec(retrieveMapHandlers);
      retrieveFile = handlerExec(retrieveFileHandlers);
    };
  }
});

// node_modules/balanced-match/index.js
var require_balanced_match = __commonJS({
  "node_modules/balanced-match/index.js"(exports2, module2) {
    "use strict";
    module2.exports = balanced;
    function balanced(a, b, str) {
      if (a instanceof RegExp) a = maybeMatch(a, str);
      if (b instanceof RegExp) b = maybeMatch(b, str);
      var r = range(a, b, str);
      return r && {
        start: r[0],
        end: r[1],
        pre: str.slice(0, r[0]),
        body: str.slice(r[0] + a.length, r[1]),
        post: str.slice(r[1] + b.length)
      };
    }
    function maybeMatch(reg, str) {
      var m = str.match(reg);
      return m ? m[0] : null;
    }
    balanced.range = range;
    function range(a, b, str) {
      var begs, beg, left, right, result2;
      var ai = str.indexOf(a);
      var bi = str.indexOf(b, ai + 1);
      var i = ai;
      if (ai >= 0 && bi > 0) {
        if (a === b) {
          return [ai, bi];
        }
        begs = [];
        left = str.length;
        while (i >= 0 && !result2) {
          if (i == ai) {
            begs.push(i);
            ai = str.indexOf(a, i + 1);
          } else if (begs.length == 1) {
            result2 = [begs.pop(), bi];
          } else {
            beg = begs.pop();
            if (beg < left) {
              left = beg;
              right = bi;
            }
            bi = str.indexOf(b, i + 1);
          }
          i = ai < bi && ai >= 0 ? ai : bi;
        }
        if (begs.length) {
          result2 = [left, right];
        }
      }
      return result2;
    }
  }
});

// node_modules/brace-expansion/index.js
var require_brace_expansion = __commonJS({
  "node_modules/brace-expansion/index.js"(exports2, module2) {
    var balanced = require_balanced_match();
    module2.exports = expandTop;
    var escSlash = "\0SLASH" + Math.random() + "\0";
    var escOpen = "\0OPEN" + Math.random() + "\0";
    var escClose = "\0CLOSE" + Math.random() + "\0";
    var escComma = "\0COMMA" + Math.random() + "\0";
    var escPeriod = "\0PERIOD" + Math.random() + "\0";
    function numeric(str) {
      return parseInt(str, 10) == str ? parseInt(str, 10) : str.charCodeAt(0);
    }
    function escapeBraces(str) {
      return str.split("\\\\").join(escSlash).split("\\{").join(escOpen).split("\\}").join(escClose).split("\\,").join(escComma).split("\\.").join(escPeriod);
    }
    function unescapeBraces(str) {
      return str.split(escSlash).join("\\").split(escOpen).join("{").split(escClose).join("}").split(escComma).join(",").split(escPeriod).join(".");
    }
    function parseCommaParts(str) {
      if (!str)
        return [""];
      var parts = [];
      var m = balanced("{", "}", str);
      if (!m)
        return str.split(",");
      var pre = m.pre;
      var body = m.body;
      var post = m.post;
      var p = pre.split(",");
      p[p.length - 1] += "{" + body + "}";
      var postParts = parseCommaParts(post);
      if (post.length) {
        p[p.length - 1] += postParts.shift();
        p.push.apply(p, postParts);
      }
      parts.push.apply(parts, p);
      return parts;
    }
    function expandTop(str) {
      if (!str)
        return [];
      if (str.substr(0, 2) === "{}") {
        str = "\\{\\}" + str.substr(2);
      }
      return expand2(escapeBraces(str), true).map(unescapeBraces);
    }
    function embrace(str) {
      return "{" + str + "}";
    }
    function isPadded(el) {
      return /^-?0\d/.test(el);
    }
    function lte(i, y) {
      return i <= y;
    }
    function gte(i, y) {
      return i >= y;
    }
    function expand2(str, isTop) {
      var expansions = [];
      var m = balanced("{", "}", str);
      if (!m) return [str];
      var pre = m.pre;
      var post = m.post.length ? expand2(m.post, false) : [""];
      if (/\$$/.test(m.pre)) {
        for (var k = 0; k < post.length; k++) {
          var expansion = pre + "{" + m.body + "}" + post[k];
          expansions.push(expansion);
        }
      } else {
        var isNumericSequence = /^-?\d+\.\.-?\d+(?:\.\.-?\d+)?$/.test(m.body);
        var isAlphaSequence = /^[a-zA-Z]\.\.[a-zA-Z](?:\.\.-?\d+)?$/.test(m.body);
        var isSequence = isNumericSequence || isAlphaSequence;
        var isOptions = m.body.indexOf(",") >= 0;
        if (!isSequence && !isOptions) {
          if (m.post.match(/,.*\}/)) {
            str = m.pre + "{" + m.body + escClose + m.post;
            return expand2(str);
          }
          return [str];
        }
        var n3;
        if (isSequence) {
          n3 = m.body.split(/\.\./);
        } else {
          n3 = parseCommaParts(m.body);
          if (n3.length === 1) {
            n3 = expand2(n3[0], false).map(embrace);
            if (n3.length === 1) {
              return post.map(function(p) {
                return m.pre + n3[0] + p;
              });
            }
          }
        }
        var N;
        if (isSequence) {
          var x = numeric(n3[0]);
          var y = numeric(n3[1]);
          var width = Math.max(n3[0].length, n3[1].length);
          var incr = n3.length == 3 ? Math.abs(numeric(n3[2])) : 1;
          var test = lte;
          var reverse = y < x;
          if (reverse) {
            incr *= -1;
            test = gte;
          }
          var pad = n3.some(isPadded);
          N = [];
          for (var i = x; test(i, y); i += incr) {
            var c;
            if (isAlphaSequence) {
              c = String.fromCharCode(i);
              if (c === "\\")
                c = "";
            } else {
              c = String(i);
              if (pad) {
                var need = width - c.length;
                if (need > 0) {
                  var z = new Array(need + 1).join("0");
                  if (i < 0)
                    c = "-" + z + c.slice(1);
                  else
                    c = z + c;
                }
              }
            }
            N.push(c);
          }
        } else {
          N = [];
          for (var j = 0; j < n3.length; j++) {
            N.push.apply(N, expand2(n3[j], false));
          }
        }
        for (var j = 0; j < N.length; j++) {
          for (var k = 0; k < post.length; k++) {
            var expansion = pre + N[j] + post[k];
            if (!isTop || isSequence || expansion)
              expansions.push(expansion);
          }
        }
      }
      return expansions;
    }
  }
});

// node_modules/picomatch/lib/constants.js
var require_constants = __commonJS({
  "node_modules/picomatch/lib/constants.js"(exports2, module2) {
    "use strict";
    var path6 = require("path");
    var WIN_SLASH = "\\\\/";
    var WIN_NO_SLASH = `[^${WIN_SLASH}]`;
    var DOT_LITERAL = "\\.";
    var PLUS_LITERAL = "\\+";
    var QMARK_LITERAL = "\\?";
    var SLASH_LITERAL = "\\/";
    var ONE_CHAR = "(?=.)";
    var QMARK = "[^/]";
    var END_ANCHOR = `(?:${SLASH_LITERAL}|$)`;
    var START_ANCHOR = `(?:^|${SLASH_LITERAL})`;
    var DOTS_SLASH = `${DOT_LITERAL}{1,2}${END_ANCHOR}`;
    var NO_DOT = `(?!${DOT_LITERAL})`;
    var NO_DOTS = `(?!${START_ANCHOR}${DOTS_SLASH})`;
    var NO_DOT_SLASH = `(?!${DOT_LITERAL}{0,1}${END_ANCHOR})`;
    var NO_DOTS_SLASH = `(?!${DOTS_SLASH})`;
    var QMARK_NO_DOT = `[^.${SLASH_LITERAL}]`;
    var STAR = `${QMARK}*?`;
    var POSIX_CHARS = {
      DOT_LITERAL,
      PLUS_LITERAL,
      QMARK_LITERAL,
      SLASH_LITERAL,
      ONE_CHAR,
      QMARK,
      END_ANCHOR,
      DOTS_SLASH,
      NO_DOT,
      NO_DOTS,
      NO_DOT_SLASH,
      NO_DOTS_SLASH,
      QMARK_NO_DOT,
      STAR,
      START_ANCHOR
    };
    var WINDOWS_CHARS = {
      ...POSIX_CHARS,
      SLASH_LITERAL: `[${WIN_SLASH}]`,
      QMARK: WIN_NO_SLASH,
      STAR: `${WIN_NO_SLASH}*?`,
      DOTS_SLASH: `${DOT_LITERAL}{1,2}(?:[${WIN_SLASH}]|$)`,
      NO_DOT: `(?!${DOT_LITERAL})`,
      NO_DOTS: `(?!(?:^|[${WIN_SLASH}])${DOT_LITERAL}{1,2}(?:[${WIN_SLASH}]|$))`,
      NO_DOT_SLASH: `(?!${DOT_LITERAL}{0,1}(?:[${WIN_SLASH}]|$))`,
      NO_DOTS_SLASH: `(?!${DOT_LITERAL}{1,2}(?:[${WIN_SLASH}]|$))`,
      QMARK_NO_DOT: `[^.${WIN_SLASH}]`,
      START_ANCHOR: `(?:^|[${WIN_SLASH}])`,
      END_ANCHOR: `(?:[${WIN_SLASH}]|$)`
    };
    var POSIX_REGEX_SOURCE = {
      alnum: "a-zA-Z0-9",
      alpha: "a-zA-Z",
      ascii: "\\x00-\\x7F",
      blank: " \\t",
      cntrl: "\\x00-\\x1F\\x7F",
      digit: "0-9",
      graph: "\\x21-\\x7E",
      lower: "a-z",
      print: "\\x20-\\x7E ",
      punct: "\\-!\"#$%&'()\\*+,./:;<=>?@[\\]^_`{|}~",
      space: " \\t\\r\\n\\v\\f",
      upper: "A-Z",
      word: "A-Za-z0-9_",
      xdigit: "A-Fa-f0-9"
    };
    module2.exports = {
      MAX_LENGTH: 1024 * 64,
      POSIX_REGEX_SOURCE,
      // regular expressions
      REGEX_BACKSLASH: /\\(?![*+?^${}(|)[\]])/g,
      REGEX_NON_SPECIAL_CHARS: /^[^@![\].,$*+?^{}()|\\/]+/,
      REGEX_SPECIAL_CHARS: /[-*+?.^${}(|)[\]]/,
      REGEX_SPECIAL_CHARS_BACKREF: /(\\?)((\W)(\3*))/g,
      REGEX_SPECIAL_CHARS_GLOBAL: /([-*+?.^${}(|)[\]])/g,
      REGEX_REMOVE_BACKSLASH: /(?:\[.*?[^\\]\]|\\(?=.))/g,
      // Replace globs with equivalent patterns to reduce parsing time.
      REPLACEMENTS: {
        "***": "*",
        "**/**": "**",
        "**/**/**": "**"
      },
      // Digits
      CHAR_0: 48,
      /* 0 */
      CHAR_9: 57,
      /* 9 */
      // Alphabet chars.
      CHAR_UPPERCASE_A: 65,
      /* A */
      CHAR_LOWERCASE_A: 97,
      /* a */
      CHAR_UPPERCASE_Z: 90,
      /* Z */
      CHAR_LOWERCASE_Z: 122,
      /* z */
      CHAR_LEFT_PARENTHESES: 40,
      /* ( */
      CHAR_RIGHT_PARENTHESES: 41,
      /* ) */
      CHAR_ASTERISK: 42,
      /* * */
      // Non-alphabetic chars.
      CHAR_AMPERSAND: 38,
      /* & */
      CHAR_AT: 64,
      /* @ */
      CHAR_BACKWARD_SLASH: 92,
      /* \ */
      CHAR_CARRIAGE_RETURN: 13,
      /* \r */
      CHAR_CIRCUMFLEX_ACCENT: 94,
      /* ^ */
      CHAR_COLON: 58,
      /* : */
      CHAR_COMMA: 44,
      /* , */
      CHAR_DOT: 46,
      /* . */
      CHAR_DOUBLE_QUOTE: 34,
      /* " */
      CHAR_EQUAL: 61,
      /* = */
      CHAR_EXCLAMATION_MARK: 33,
      /* ! */
      CHAR_FORM_FEED: 12,
      /* \f */
      CHAR_FORWARD_SLASH: 47,
      /* / */
      CHAR_GRAVE_ACCENT: 96,
      /* ` */
      CHAR_HASH: 35,
      /* # */
      CHAR_HYPHEN_MINUS: 45,
      /* - */
      CHAR_LEFT_ANGLE_BRACKET: 60,
      /* < */
      CHAR_LEFT_CURLY_BRACE: 123,
      /* { */
      CHAR_LEFT_SQUARE_BRACKET: 91,
      /* [ */
      CHAR_LINE_FEED: 10,
      /* \n */
      CHAR_NO_BREAK_SPACE: 160,
      /* \u00A0 */
      CHAR_PERCENT: 37,
      /* % */
      CHAR_PLUS: 43,
      /* + */
      CHAR_QUESTION_MARK: 63,
      /* ? */
      CHAR_RIGHT_ANGLE_BRACKET: 62,
      /* > */
      CHAR_RIGHT_CURLY_BRACE: 125,
      /* } */
      CHAR_RIGHT_SQUARE_BRACKET: 93,
      /* ] */
      CHAR_SEMICOLON: 59,
      /* ; */
      CHAR_SINGLE_QUOTE: 39,
      /* ' */
      CHAR_SPACE: 32,
      /*   */
      CHAR_TAB: 9,
      /* \t */
      CHAR_UNDERSCORE: 95,
      /* _ */
      CHAR_VERTICAL_LINE: 124,
      /* | */
      CHAR_ZERO_WIDTH_NOBREAK_SPACE: 65279,
      /* \uFEFF */
      SEP: path6.sep,
      /**
       * Create EXTGLOB_CHARS
       */
      extglobChars(chars3) {
        return {
          "!": { type: "negate", open: "(?:(?!(?:", close: `))${chars3.STAR})` },
          "?": { type: "qmark", open: "(?:", close: ")?" },
          "+": { type: "plus", open: "(?:", close: ")+" },
          "*": { type: "star", open: "(?:", close: ")*" },
          "@": { type: "at", open: "(?:", close: ")" }
        };
      },
      /**
       * Create GLOB_CHARS
       */
      globChars(win322) {
        return win322 === true ? WINDOWS_CHARS : POSIX_CHARS;
      }
    };
  }
});

// node_modules/picomatch/lib/utils.js
var require_utils = __commonJS({
  "node_modules/picomatch/lib/utils.js"(exports2) {
    "use strict";
    var path6 = require("path");
    var win322 = process.platform === "win32";
    var {
      REGEX_BACKSLASH,
      REGEX_REMOVE_BACKSLASH,
      REGEX_SPECIAL_CHARS,
      REGEX_SPECIAL_CHARS_GLOBAL
    } = require_constants();
    exports2.isObject = (val) => val !== null && typeof val === "object" && !Array.isArray(val);
    exports2.hasRegexChars = (str) => REGEX_SPECIAL_CHARS.test(str);
    exports2.isRegexChar = (str) => str.length === 1 && exports2.hasRegexChars(str);
    exports2.escapeRegex = (str) => str.replace(REGEX_SPECIAL_CHARS_GLOBAL, "\\$1");
    exports2.toPosixSlashes = (str) => str.replace(REGEX_BACKSLASH, "/");
    exports2.removeBackslashes = (str) => {
      return str.replace(REGEX_REMOVE_BACKSLASH, (match2) => {
        return match2 === "\\" ? "" : match2;
      });
    };
    exports2.supportsLookbehinds = () => {
      const segs = process.version.slice(1).split(".").map(Number);
      if (segs.length === 3 && segs[0] >= 9 || segs[0] === 8 && segs[1] >= 10) {
        return true;
      }
      return false;
    };
    exports2.isWindows = (options) => {
      if (options && typeof options.windows === "boolean") {
        return options.windows;
      }
      return win322 === true || path6.sep === "\\";
    };
    exports2.escapeLast = (input, char, lastIdx) => {
      const idx = input.lastIndexOf(char, lastIdx);
      if (idx === -1) return input;
      if (input[idx - 1] === "\\") return exports2.escapeLast(input, char, idx - 1);
      return `${input.slice(0, idx)}\\${input.slice(idx)}`;
    };
    exports2.removePrefix = (input, state = {}) => {
      let output = input;
      if (output.startsWith("./")) {
        output = output.slice(2);
        state.prefix = "./";
      }
      return output;
    };
    exports2.wrapOutput = (input, state = {}, options = {}) => {
      const prepend3 = options.contains ? "" : "^";
      const append4 = options.contains ? "" : "$";
      let output = `${prepend3}(?:${input})${append4}`;
      if (state.negated === true) {
        output = `(?:^(?!${output}).*$)`;
      }
      return output;
    };
  }
});

// node_modules/picomatch/lib/scan.js
var require_scan = __commonJS({
  "node_modules/picomatch/lib/scan.js"(exports2, module2) {
    "use strict";
    var utils = require_utils();
    var {
      CHAR_ASTERISK,
      /* * */
      CHAR_AT,
      /* @ */
      CHAR_BACKWARD_SLASH,
      /* \ */
      CHAR_COMMA,
      /* , */
      CHAR_DOT,
      /* . */
      CHAR_EXCLAMATION_MARK,
      /* ! */
      CHAR_FORWARD_SLASH,
      /* / */
      CHAR_LEFT_CURLY_BRACE,
      /* { */
      CHAR_LEFT_PARENTHESES,
      /* ( */
      CHAR_LEFT_SQUARE_BRACKET,
      /* [ */
      CHAR_PLUS,
      /* + */
      CHAR_QUESTION_MARK,
      /* ? */
      CHAR_RIGHT_CURLY_BRACE,
      /* } */
      CHAR_RIGHT_PARENTHESES,
      /* ) */
      CHAR_RIGHT_SQUARE_BRACKET
      /* ] */
    } = require_constants();
    var isPathSeparator = (code) => {
      return code === CHAR_FORWARD_SLASH || code === CHAR_BACKWARD_SLASH;
    };
    var depth = (token) => {
      if (token.isPrefix !== true) {
        token.depth = token.isGlobstar ? Infinity : 1;
      }
    };
    var scan = (input, options) => {
      const opts = options || {};
      const length3 = input.length - 1;
      const scanToEnd = opts.parts === true || opts.scanToEnd === true;
      const slashes = [];
      const tokens = [];
      const parts = [];
      let str = input;
      let index2 = -1;
      let start = 0;
      let lastIndex = 0;
      let isBrace = false;
      let isBracket = false;
      let isGlob2 = false;
      let isExtglob = false;
      let isGlobstar = false;
      let braceEscaped = false;
      let backslashes = false;
      let negated = false;
      let negatedExtglob = false;
      let finished = false;
      let braces = 0;
      let prev;
      let code;
      let token = { value: "", depth: 0, isGlob: false };
      const eos = () => index2 >= length3;
      const peek = () => str.charCodeAt(index2 + 1);
      const advance3 = () => {
        prev = code;
        return str.charCodeAt(++index2);
      };
      while (index2 < length3) {
        code = advance3();
        let next;
        if (code === CHAR_BACKWARD_SLASH) {
          backslashes = token.backslashes = true;
          code = advance3();
          if (code === CHAR_LEFT_CURLY_BRACE) {
            braceEscaped = true;
          }
          continue;
        }
        if (braceEscaped === true || code === CHAR_LEFT_CURLY_BRACE) {
          braces++;
          while (eos() !== true && (code = advance3())) {
            if (code === CHAR_BACKWARD_SLASH) {
              backslashes = token.backslashes = true;
              advance3();
              continue;
            }
            if (code === CHAR_LEFT_CURLY_BRACE) {
              braces++;
              continue;
            }
            if (braceEscaped !== true && code === CHAR_DOT && (code = advance3()) === CHAR_DOT) {
              isBrace = token.isBrace = true;
              isGlob2 = token.isGlob = true;
              finished = true;
              if (scanToEnd === true) {
                continue;
              }
              break;
            }
            if (braceEscaped !== true && code === CHAR_COMMA) {
              isBrace = token.isBrace = true;
              isGlob2 = token.isGlob = true;
              finished = true;
              if (scanToEnd === true) {
                continue;
              }
              break;
            }
            if (code === CHAR_RIGHT_CURLY_BRACE) {
              braces--;
              if (braces === 0) {
                braceEscaped = false;
                isBrace = token.isBrace = true;
                finished = true;
                break;
              }
            }
          }
          if (scanToEnd === true) {
            continue;
          }
          break;
        }
        if (code === CHAR_FORWARD_SLASH) {
          slashes.push(index2);
          tokens.push(token);
          token = { value: "", depth: 0, isGlob: false };
          if (finished === true) continue;
          if (prev === CHAR_DOT && index2 === start + 1) {
            start += 2;
            continue;
          }
          lastIndex = index2 + 1;
          continue;
        }
        if (opts.noext !== true) {
          const isExtglobChar = code === CHAR_PLUS || code === CHAR_AT || code === CHAR_ASTERISK || code === CHAR_QUESTION_MARK || code === CHAR_EXCLAMATION_MARK;
          if (isExtglobChar === true && peek() === CHAR_LEFT_PARENTHESES) {
            isGlob2 = token.isGlob = true;
            isExtglob = token.isExtglob = true;
            finished = true;
            if (code === CHAR_EXCLAMATION_MARK && index2 === start) {
              negatedExtglob = true;
            }
            if (scanToEnd === true) {
              while (eos() !== true && (code = advance3())) {
                if (code === CHAR_BACKWARD_SLASH) {
                  backslashes = token.backslashes = true;
                  code = advance3();
                  continue;
                }
                if (code === CHAR_RIGHT_PARENTHESES) {
                  isGlob2 = token.isGlob = true;
                  finished = true;
                  break;
                }
              }
              continue;
            }
            break;
          }
        }
        if (code === CHAR_ASTERISK) {
          if (prev === CHAR_ASTERISK) isGlobstar = token.isGlobstar = true;
          isGlob2 = token.isGlob = true;
          finished = true;
          if (scanToEnd === true) {
            continue;
          }
          break;
        }
        if (code === CHAR_QUESTION_MARK) {
          isGlob2 = token.isGlob = true;
          finished = true;
          if (scanToEnd === true) {
            continue;
          }
          break;
        }
        if (code === CHAR_LEFT_SQUARE_BRACKET) {
          while (eos() !== true && (next = advance3())) {
            if (next === CHAR_BACKWARD_SLASH) {
              backslashes = token.backslashes = true;
              advance3();
              continue;
            }
            if (next === CHAR_RIGHT_SQUARE_BRACKET) {
              isBracket = token.isBracket = true;
              isGlob2 = token.isGlob = true;
              finished = true;
              break;
            }
          }
          if (scanToEnd === true) {
            continue;
          }
          break;
        }
        if (opts.nonegate !== true && code === CHAR_EXCLAMATION_MARK && index2 === start) {
          negated = token.negated = true;
          start++;
          continue;
        }
        if (opts.noparen !== true && code === CHAR_LEFT_PARENTHESES) {
          isGlob2 = token.isGlob = true;
          if (scanToEnd === true) {
            while (eos() !== true && (code = advance3())) {
              if (code === CHAR_LEFT_PARENTHESES) {
                backslashes = token.backslashes = true;
                code = advance3();
                continue;
              }
              if (code === CHAR_RIGHT_PARENTHESES) {
                finished = true;
                break;
              }
            }
            continue;
          }
          break;
        }
        if (isGlob2 === true) {
          finished = true;
          if (scanToEnd === true) {
            continue;
          }
          break;
        }
      }
      if (opts.noext === true) {
        isExtglob = false;
        isGlob2 = false;
      }
      let base2 = str;
      let prefix = "";
      let glob = "";
      if (start > 0) {
        prefix = str.slice(0, start);
        str = str.slice(start);
        lastIndex -= start;
      }
      if (base2 && isGlob2 === true && lastIndex > 0) {
        base2 = str.slice(0, lastIndex);
        glob = str.slice(lastIndex);
      } else if (isGlob2 === true) {
        base2 = "";
        glob = str;
      } else {
        base2 = str;
      }
      if (base2 && base2 !== "" && base2 !== "/" && base2 !== str) {
        if (isPathSeparator(base2.charCodeAt(base2.length - 1))) {
          base2 = base2.slice(0, -1);
        }
      }
      if (opts.unescape === true) {
        if (glob) glob = utils.removeBackslashes(glob);
        if (base2 && backslashes === true) {
          base2 = utils.removeBackslashes(base2);
        }
      }
      const state = {
        prefix,
        input,
        start,
        base: base2,
        glob,
        isBrace,
        isBracket,
        isGlob: isGlob2,
        isExtglob,
        isGlobstar,
        negated,
        negatedExtglob
      };
      if (opts.tokens === true) {
        state.maxDepth = 0;
        if (!isPathSeparator(code)) {
          tokens.push(token);
        }
        state.tokens = tokens;
      }
      if (opts.parts === true || opts.tokens === true) {
        let prevIndex;
        for (let idx = 0; idx < slashes.length; idx++) {
          const n3 = prevIndex ? prevIndex + 1 : start;
          const i = slashes[idx];
          const value = input.slice(n3, i);
          if (opts.tokens) {
            if (idx === 0 && start !== 0) {
              tokens[idx].isPrefix = true;
              tokens[idx].value = prefix;
            } else {
              tokens[idx].value = value;
            }
            depth(tokens[idx]);
            state.maxDepth += tokens[idx].depth;
          }
          if (idx !== 0 || value !== "") {
            parts.push(value);
          }
          prevIndex = i;
        }
        if (prevIndex && prevIndex + 1 < input.length) {
          const value = input.slice(prevIndex + 1);
          parts.push(value);
          if (opts.tokens) {
            tokens[tokens.length - 1].value = value;
            depth(tokens[tokens.length - 1]);
            state.maxDepth += tokens[tokens.length - 1].depth;
          }
        }
        state.slashes = slashes;
        state.parts = parts;
      }
      return state;
    };
    module2.exports = scan;
  }
});

// node_modules/picomatch/lib/parse.js
var require_parse = __commonJS({
  "node_modules/picomatch/lib/parse.js"(exports2, module2) {
    "use strict";
    var constants = require_constants();
    var utils = require_utils();
    var {
      MAX_LENGTH,
      POSIX_REGEX_SOURCE,
      REGEX_NON_SPECIAL_CHARS,
      REGEX_SPECIAL_CHARS_BACKREF,
      REPLACEMENTS
    } = constants;
    var expandRange = (args, options) => {
      if (typeof options.expandRange === "function") {
        return options.expandRange(...args, options);
      }
      args.sort();
      const value = `[${args.join("-")}]`;
      try {
        new RegExp(value);
      } catch (ex) {
        return args.map((v) => utils.escapeRegex(v)).join("..");
      }
      return value;
    };
    var syntaxError = (type, char) => {
      return `Missing ${type}: "${char}" - use "\\\\${char}" to match literal characters`;
    };
    var parse5 = (input, options) => {
      if (typeof input !== "string") {
        throw new TypeError("Expected a string");
      }
      input = REPLACEMENTS[input] || input;
      const opts = { ...options };
      const max = typeof opts.maxLength === "number" ? Math.min(MAX_LENGTH, opts.maxLength) : MAX_LENGTH;
      let len = input.length;
      if (len > max) {
        throw new SyntaxError(`Input length: ${len}, exceeds maximum allowed length: ${max}`);
      }
      const bos = { type: "bos", value: "", output: opts.prepend || "" };
      const tokens = [bos];
      const capture = opts.capture ? "" : "?:";
      const win322 = utils.isWindows(options);
      const PLATFORM_CHARS = constants.globChars(win322);
      const EXTGLOB_CHARS = constants.extglobChars(PLATFORM_CHARS);
      const {
        DOT_LITERAL,
        PLUS_LITERAL,
        SLASH_LITERAL,
        ONE_CHAR,
        DOTS_SLASH,
        NO_DOT,
        NO_DOT_SLASH,
        NO_DOTS_SLASH,
        QMARK,
        QMARK_NO_DOT,
        STAR,
        START_ANCHOR
      } = PLATFORM_CHARS;
      const globstar = (opts2) => {
        return `(${capture}(?:(?!${START_ANCHOR}${opts2.dot ? DOTS_SLASH : DOT_LITERAL}).)*?)`;
      };
      const nodot = opts.dot ? "" : NO_DOT;
      const qmarkNoDot = opts.dot ? QMARK : QMARK_NO_DOT;
      let star3 = opts.bash === true ? globstar(opts) : STAR;
      if (opts.capture) {
        star3 = `(${star3})`;
      }
      if (typeof opts.noext === "boolean") {
        opts.noextglob = opts.noext;
      }
      const state = {
        input,
        index: -1,
        start: 0,
        dot: opts.dot === true,
        consumed: "",
        output: "",
        prefix: "",
        backtrack: false,
        negated: false,
        brackets: 0,
        braces: 0,
        parens: 0,
        quotes: 0,
        globstar: false,
        tokens
      };
      input = utils.removePrefix(input, state);
      len = input.length;
      const extglobs = [];
      const braces = [];
      const stack = [];
      let prev = bos;
      let value;
      const eos = () => state.index === len - 1;
      const peek = state.peek = (n3 = 1) => input[state.index + n3];
      const advance3 = state.advance = () => input[++state.index] || "";
      const remaining = () => input.slice(state.index + 1);
      const consume = (value2 = "", num = 0) => {
        state.consumed += value2;
        state.index += num;
      };
      const append4 = (token) => {
        state.output += token.output != null ? token.output : token.value;
        consume(token.value);
      };
      const negate = () => {
        let count = 1;
        while (peek() === "!" && (peek(2) !== "(" || peek(3) === "?")) {
          advance3();
          state.start++;
          count++;
        }
        if (count % 2 === 0) {
          return false;
        }
        state.negated = true;
        state.start++;
        return true;
      };
      const increment = (type) => {
        state[type]++;
        stack.push(type);
      };
      const decrement = (type) => {
        state[type]--;
        stack.pop();
      };
      const push2 = (tok) => {
        if (prev.type === "globstar") {
          const isBrace = state.braces > 0 && (tok.type === "comma" || tok.type === "brace");
          const isExtglob = tok.extglob === true || extglobs.length && (tok.type === "pipe" || tok.type === "paren");
          if (tok.type !== "slash" && tok.type !== "paren" && !isBrace && !isExtglob) {
            state.output = state.output.slice(0, -prev.output.length);
            prev.type = "star";
            prev.value = "*";
            prev.output = star3;
            state.output += prev.output;
          }
        }
        if (extglobs.length && tok.type !== "paren") {
          extglobs[extglobs.length - 1].inner += tok.value;
        }
        if (tok.value || tok.output) append4(tok);
        if (prev && prev.type === "text" && tok.type === "text") {
          prev.value += tok.value;
          prev.output = (prev.output || "") + tok.value;
          return;
        }
        tok.prev = prev;
        tokens.push(tok);
        prev = tok;
      };
      const extglobOpen = (type, value2) => {
        const token = { ...EXTGLOB_CHARS[value2], conditions: 1, inner: "" };
        token.prev = prev;
        token.parens = state.parens;
        token.output = state.output;
        const output = (opts.capture ? "(" : "") + token.open;
        increment("parens");
        push2({ type, value: value2, output: state.output ? "" : ONE_CHAR });
        push2({ type: "paren", extglob: true, value: advance3(), output });
        extglobs.push(token);
      };
      const extglobClose = (token) => {
        let output = token.close + (opts.capture ? ")" : "");
        let rest;
        if (token.type === "negate") {
          let extglobStar = star3;
          if (token.inner && token.inner.length > 1 && token.inner.includes("/")) {
            extglobStar = globstar(opts);
          }
          if (extglobStar !== star3 || eos() || /^\)+$/.test(remaining())) {
            output = token.close = `)$))${extglobStar}`;
          }
          if (token.inner.includes("*") && (rest = remaining()) && /^\.[^\\/.]+$/.test(rest)) {
            const expression = parse5(rest, { ...options, fastpaths: false }).output;
            output = token.close = `)${expression})${extglobStar})`;
          }
          if (token.prev.type === "bos") {
            state.negatedExtglob = true;
          }
        }
        push2({ type: "paren", extglob: true, value, output });
        decrement("parens");
      };
      if (opts.fastpaths !== false && !/(^[*!]|[/()[\]{}"])/.test(input)) {
        let backslashes = false;
        let output = input.replace(REGEX_SPECIAL_CHARS_BACKREF, (m, esc, chars3, first, rest, index2) => {
          if (first === "\\") {
            backslashes = true;
            return m;
          }
          if (first === "?") {
            if (esc) {
              return esc + first + (rest ? QMARK.repeat(rest.length) : "");
            }
            if (index2 === 0) {
              return qmarkNoDot + (rest ? QMARK.repeat(rest.length) : "");
            }
            return QMARK.repeat(chars3.length);
          }
          if (first === ".") {
            return DOT_LITERAL.repeat(chars3.length);
          }
          if (first === "*") {
            if (esc) {
              return esc + first + (rest ? star3 : "");
            }
            return star3;
          }
          return esc ? m : `\\${m}`;
        });
        if (backslashes === true) {
          if (opts.unescape === true) {
            output = output.replace(/\\/g, "");
          } else {
            output = output.replace(/\\+/g, (m) => {
              return m.length % 2 === 0 ? "\\\\" : m ? "\\" : "";
            });
          }
        }
        if (output === input && opts.contains === true) {
          state.output = input;
          return state;
        }
        state.output = utils.wrapOutput(output, state, options);
        return state;
      }
      while (!eos()) {
        value = advance3();
        if (value === "\0") {
          continue;
        }
        if (value === "\\") {
          const next = peek();
          if (next === "/" && opts.bash !== true) {
            continue;
          }
          if (next === "." || next === ";") {
            continue;
          }
          if (!next) {
            value += "\\";
            push2({ type: "text", value });
            continue;
          }
          const match2 = /^\\+/.exec(remaining());
          let slashes = 0;
          if (match2 && match2[0].length > 2) {
            slashes = match2[0].length;
            state.index += slashes;
            if (slashes % 2 !== 0) {
              value += "\\";
            }
          }
          if (opts.unescape === true) {
            value = advance3();
          } else {
            value += advance3();
          }
          if (state.brackets === 0) {
            push2({ type: "text", value });
            continue;
          }
        }
        if (state.brackets > 0 && (value !== "]" || prev.value === "[" || prev.value === "[^")) {
          if (opts.posix !== false && value === ":") {
            const inner = prev.value.slice(1);
            if (inner.includes("[")) {
              prev.posix = true;
              if (inner.includes(":")) {
                const idx = prev.value.lastIndexOf("[");
                const pre = prev.value.slice(0, idx);
                const rest2 = prev.value.slice(idx + 2);
                const posix3 = POSIX_REGEX_SOURCE[rest2];
                if (posix3) {
                  prev.value = pre + posix3;
                  state.backtrack = true;
                  advance3();
                  if (!bos.output && tokens.indexOf(prev) === 1) {
                    bos.output = ONE_CHAR;
                  }
                  continue;
                }
              }
            }
          }
          if (value === "[" && peek() !== ":" || value === "-" && peek() === "]") {
            value = `\\${value}`;
          }
          if (value === "]" && (prev.value === "[" || prev.value === "[^")) {
            value = `\\${value}`;
          }
          if (opts.posix === true && value === "!" && prev.value === "[") {
            value = "^";
          }
          prev.value += value;
          append4({ value });
          continue;
        }
        if (state.quotes === 1 && value !== '"') {
          value = utils.escapeRegex(value);
          prev.value += value;
          append4({ value });
          continue;
        }
        if (value === '"') {
          state.quotes = state.quotes === 1 ? 0 : 1;
          if (opts.keepQuotes === true) {
            push2({ type: "text", value });
          }
          continue;
        }
        if (value === "(") {
          increment("parens");
          push2({ type: "paren", value });
          continue;
        }
        if (value === ")") {
          if (state.parens === 0 && opts.strictBrackets === true) {
            throw new SyntaxError(syntaxError("opening", "("));
          }
          const extglob = extglobs[extglobs.length - 1];
          if (extglob && state.parens === extglob.parens + 1) {
            extglobClose(extglobs.pop());
            continue;
          }
          push2({ type: "paren", value, output: state.parens ? ")" : "\\)" });
          decrement("parens");
          continue;
        }
        if (value === "[") {
          if (opts.nobracket === true || !remaining().includes("]")) {
            if (opts.nobracket !== true && opts.strictBrackets === true) {
              throw new SyntaxError(syntaxError("closing", "]"));
            }
            value = `\\${value}`;
          } else {
            increment("brackets");
          }
          push2({ type: "bracket", value });
          continue;
        }
        if (value === "]") {
          if (opts.nobracket === true || prev && prev.type === "bracket" && prev.value.length === 1) {
            push2({ type: "text", value, output: `\\${value}` });
            continue;
          }
          if (state.brackets === 0) {
            if (opts.strictBrackets === true) {
              throw new SyntaxError(syntaxError("opening", "["));
            }
            push2({ type: "text", value, output: `\\${value}` });
            continue;
          }
          decrement("brackets");
          const prevValue = prev.value.slice(1);
          if (prev.posix !== true && prevValue[0] === "^" && !prevValue.includes("/")) {
            value = `/${value}`;
          }
          prev.value += value;
          append4({ value });
          if (opts.literalBrackets === false || utils.hasRegexChars(prevValue)) {
            continue;
          }
          const escaped = utils.escapeRegex(prev.value);
          state.output = state.output.slice(0, -prev.value.length);
          if (opts.literalBrackets === true) {
            state.output += escaped;
            prev.value = escaped;
            continue;
          }
          prev.value = `(${capture}${escaped}|${prev.value})`;
          state.output += prev.value;
          continue;
        }
        if (value === "{" && opts.nobrace !== true) {
          increment("braces");
          const open = {
            type: "brace",
            value,
            output: "(",
            outputIndex: state.output.length,
            tokensIndex: state.tokens.length
          };
          braces.push(open);
          push2(open);
          continue;
        }
        if (value === "}") {
          const brace = braces[braces.length - 1];
          if (opts.nobrace === true || !brace) {
            push2({ type: "text", value, output: value });
            continue;
          }
          let output = ")";
          if (brace.dots === true) {
            const arr = tokens.slice();
            const range = [];
            for (let i = arr.length - 1; i >= 0; i--) {
              tokens.pop();
              if (arr[i].type === "brace") {
                break;
              }
              if (arr[i].type !== "dots") {
                range.unshift(arr[i].value);
              }
            }
            output = expandRange(range, opts);
            state.backtrack = true;
          }
          if (brace.comma !== true && brace.dots !== true) {
            const out = state.output.slice(0, brace.outputIndex);
            const toks = state.tokens.slice(brace.tokensIndex);
            brace.value = brace.output = "\\{";
            value = output = "\\}";
            state.output = out;
            for (const t of toks) {
              state.output += t.output || t.value;
            }
          }
          push2({ type: "brace", value, output });
          decrement("braces");
          braces.pop();
          continue;
        }
        if (value === "|") {
          if (extglobs.length > 0) {
            extglobs[extglobs.length - 1].conditions++;
          }
          push2({ type: "text", value });
          continue;
        }
        if (value === ",") {
          let output = value;
          const brace = braces[braces.length - 1];
          if (brace && stack[stack.length - 1] === "braces") {
            brace.comma = true;
            output = "|";
          }
          push2({ type: "comma", value, output });
          continue;
        }
        if (value === "/") {
          if (prev.type === "dot" && state.index === state.start + 1) {
            state.start = state.index + 1;
            state.consumed = "";
            state.output = "";
            tokens.pop();
            prev = bos;
            continue;
          }
          push2({ type: "slash", value, output: SLASH_LITERAL });
          continue;
        }
        if (value === ".") {
          if (state.braces > 0 && prev.type === "dot") {
            if (prev.value === ".") prev.output = DOT_LITERAL;
            const brace = braces[braces.length - 1];
            prev.type = "dots";
            prev.output += value;
            prev.value += value;
            brace.dots = true;
            continue;
          }
          if (state.braces + state.parens === 0 && prev.type !== "bos" && prev.type !== "slash") {
            push2({ type: "text", value, output: DOT_LITERAL });
            continue;
          }
          push2({ type: "dot", value, output: DOT_LITERAL });
          continue;
        }
        if (value === "?") {
          const isGroup = prev && prev.value === "(";
          if (!isGroup && opts.noextglob !== true && peek() === "(" && peek(2) !== "?") {
            extglobOpen("qmark", value);
            continue;
          }
          if (prev && prev.type === "paren") {
            const next = peek();
            let output = value;
            if (next === "<" && !utils.supportsLookbehinds()) {
              throw new Error("Node.js v10 or higher is required for regex lookbehinds");
            }
            if (prev.value === "(" && !/[!=<:]/.test(next) || next === "<" && !/<([!=]|\w+>)/.test(remaining())) {
              output = `\\${value}`;
            }
            push2({ type: "text", value, output });
            continue;
          }
          if (opts.dot !== true && (prev.type === "slash" || prev.type === "bos")) {
            push2({ type: "qmark", value, output: QMARK_NO_DOT });
            continue;
          }
          push2({ type: "qmark", value, output: QMARK });
          continue;
        }
        if (value === "!") {
          if (opts.noextglob !== true && peek() === "(") {
            if (peek(2) !== "?" || !/[!=<:]/.test(peek(3))) {
              extglobOpen("negate", value);
              continue;
            }
          }
          if (opts.nonegate !== true && state.index === 0) {
            negate();
            continue;
          }
        }
        if (value === "+") {
          if (opts.noextglob !== true && peek() === "(" && peek(2) !== "?") {
            extglobOpen("plus", value);
            continue;
          }
          if (prev && prev.value === "(" || opts.regex === false) {
            push2({ type: "plus", value, output: PLUS_LITERAL });
            continue;
          }
          if (prev && (prev.type === "bracket" || prev.type === "paren" || prev.type === "brace") || state.parens > 0) {
            push2({ type: "plus", value });
            continue;
          }
          push2({ type: "plus", value: PLUS_LITERAL });
          continue;
        }
        if (value === "@") {
          if (opts.noextglob !== true && peek() === "(" && peek(2) !== "?") {
            push2({ type: "at", extglob: true, value, output: "" });
            continue;
          }
          push2({ type: "text", value });
          continue;
        }
        if (value !== "*") {
          if (value === "$" || value === "^") {
            value = `\\${value}`;
          }
          const match2 = REGEX_NON_SPECIAL_CHARS.exec(remaining());
          if (match2) {
            value += match2[0];
            state.index += match2[0].length;
          }
          push2({ type: "text", value });
          continue;
        }
        if (prev && (prev.type === "globstar" || prev.star === true)) {
          prev.type = "star";
          prev.star = true;
          prev.value += value;
          prev.output = star3;
          state.backtrack = true;
          state.globstar = true;
          consume(value);
          continue;
        }
        let rest = remaining();
        if (opts.noextglob !== true && /^\([^?]/.test(rest)) {
          extglobOpen("star", value);
          continue;
        }
        if (prev.type === "star") {
          if (opts.noglobstar === true) {
            consume(value);
            continue;
          }
          const prior = prev.prev;
          const before = prior.prev;
          const isStart = prior.type === "slash" || prior.type === "bos";
          const afterStar = before && (before.type === "star" || before.type === "globstar");
          if (opts.bash === true && (!isStart || rest[0] && rest[0] !== "/")) {
            push2({ type: "star", value, output: "" });
            continue;
          }
          const isBrace = state.braces > 0 && (prior.type === "comma" || prior.type === "brace");
          const isExtglob = extglobs.length && (prior.type === "pipe" || prior.type === "paren");
          if (!isStart && prior.type !== "paren" && !isBrace && !isExtglob) {
            push2({ type: "star", value, output: "" });
            continue;
          }
          while (rest.slice(0, 3) === "/**") {
            const after = input[state.index + 4];
            if (after && after !== "/") {
              break;
            }
            rest = rest.slice(3);
            consume("/**", 3);
          }
          if (prior.type === "bos" && eos()) {
            prev.type = "globstar";
            prev.value += value;
            prev.output = globstar(opts);
            state.output = prev.output;
            state.globstar = true;
            consume(value);
            continue;
          }
          if (prior.type === "slash" && prior.prev.type !== "bos" && !afterStar && eos()) {
            state.output = state.output.slice(0, -(prior.output + prev.output).length);
            prior.output = `(?:${prior.output}`;
            prev.type = "globstar";
            prev.output = globstar(opts) + (opts.strictSlashes ? ")" : "|$)");
            prev.value += value;
            state.globstar = true;
            state.output += prior.output + prev.output;
            consume(value);
            continue;
          }
          if (prior.type === "slash" && prior.prev.type !== "bos" && rest[0] === "/") {
            const end = rest[1] !== void 0 ? "|$" : "";
            state.output = state.output.slice(0, -(prior.output + prev.output).length);
            prior.output = `(?:${prior.output}`;
            prev.type = "globstar";
            prev.output = `${globstar(opts)}${SLASH_LITERAL}|${SLASH_LITERAL}${end})`;
            prev.value += value;
            state.output += prior.output + prev.output;
            state.globstar = true;
            consume(value + advance3());
            push2({ type: "slash", value: "/", output: "" });
            continue;
          }
          if (prior.type === "bos" && rest[0] === "/") {
            prev.type = "globstar";
            prev.value += value;
            prev.output = `(?:^|${SLASH_LITERAL}|${globstar(opts)}${SLASH_LITERAL})`;
            state.output = prev.output;
            state.globstar = true;
            consume(value + advance3());
            push2({ type: "slash", value: "/", output: "" });
            continue;
          }
          state.output = state.output.slice(0, -prev.output.length);
          prev.type = "globstar";
          prev.output = globstar(opts);
          prev.value += value;
          state.output += prev.output;
          state.globstar = true;
          consume(value);
          continue;
        }
        const token = { type: "star", value, output: star3 };
        if (opts.bash === true) {
          token.output = ".*?";
          if (prev.type === "bos" || prev.type === "slash") {
            token.output = nodot + token.output;
          }
          push2(token);
          continue;
        }
        if (prev && (prev.type === "bracket" || prev.type === "paren") && opts.regex === true) {
          token.output = value;
          push2(token);
          continue;
        }
        if (state.index === state.start || prev.type === "slash" || prev.type === "dot") {
          if (prev.type === "dot") {
            state.output += NO_DOT_SLASH;
            prev.output += NO_DOT_SLASH;
          } else if (opts.dot === true) {
            state.output += NO_DOTS_SLASH;
            prev.output += NO_DOTS_SLASH;
          } else {
            state.output += nodot;
            prev.output += nodot;
          }
          if (peek() !== "*") {
            state.output += ONE_CHAR;
            prev.output += ONE_CHAR;
          }
        }
        push2(token);
      }
      while (state.brackets > 0) {
        if (opts.strictBrackets === true) throw new SyntaxError(syntaxError("closing", "]"));
        state.output = utils.escapeLast(state.output, "[");
        decrement("brackets");
      }
      while (state.parens > 0) {
        if (opts.strictBrackets === true) throw new SyntaxError(syntaxError("closing", ")"));
        state.output = utils.escapeLast(state.output, "(");
        decrement("parens");
      }
      while (state.braces > 0) {
        if (opts.strictBrackets === true) throw new SyntaxError(syntaxError("closing", "}"));
        state.output = utils.escapeLast(state.output, "{");
        decrement("braces");
      }
      if (opts.strictSlashes !== true && (prev.type === "star" || prev.type === "bracket")) {
        push2({ type: "maybe_slash", value: "", output: `${SLASH_LITERAL}?` });
      }
      if (state.backtrack === true) {
        state.output = "";
        for (const token of state.tokens) {
          state.output += token.output != null ? token.output : token.value;
          if (token.suffix) {
            state.output += token.suffix;
          }
        }
      }
      return state;
    };
    parse5.fastpaths = (input, options) => {
      const opts = { ...options };
      const max = typeof opts.maxLength === "number" ? Math.min(MAX_LENGTH, opts.maxLength) : MAX_LENGTH;
      const len = input.length;
      if (len > max) {
        throw new SyntaxError(`Input length: ${len}, exceeds maximum allowed length: ${max}`);
      }
      input = REPLACEMENTS[input] || input;
      const win322 = utils.isWindows(options);
      const {
        DOT_LITERAL,
        SLASH_LITERAL,
        ONE_CHAR,
        DOTS_SLASH,
        NO_DOT,
        NO_DOTS,
        NO_DOTS_SLASH,
        STAR,
        START_ANCHOR
      } = constants.globChars(win322);
      const nodot = opts.dot ? NO_DOTS : NO_DOT;
      const slashDot = opts.dot ? NO_DOTS_SLASH : NO_DOT;
      const capture = opts.capture ? "" : "?:";
      const state = { negated: false, prefix: "" };
      let star3 = opts.bash === true ? ".*?" : STAR;
      if (opts.capture) {
        star3 = `(${star3})`;
      }
      const globstar = (opts2) => {
        if (opts2.noglobstar === true) return star3;
        return `(${capture}(?:(?!${START_ANCHOR}${opts2.dot ? DOTS_SLASH : DOT_LITERAL}).)*?)`;
      };
      const create = (str) => {
        switch (str) {
          case "*":
            return `${nodot}${ONE_CHAR}${star3}`;
          case ".*":
            return `${DOT_LITERAL}${ONE_CHAR}${star3}`;
          case "*.*":
            return `${nodot}${star3}${DOT_LITERAL}${ONE_CHAR}${star3}`;
          case "*/*":
            return `${nodot}${star3}${SLASH_LITERAL}${ONE_CHAR}${slashDot}${star3}`;
          case "**":
            return nodot + globstar(opts);
          case "**/*":
            return `(?:${nodot}${globstar(opts)}${SLASH_LITERAL})?${slashDot}${ONE_CHAR}${star3}`;
          case "**/*.*":
            return `(?:${nodot}${globstar(opts)}${SLASH_LITERAL})?${slashDot}${star3}${DOT_LITERAL}${ONE_CHAR}${star3}`;
          case "**/.*":
            return `(?:${nodot}${globstar(opts)}${SLASH_LITERAL})?${DOT_LITERAL}${ONE_CHAR}${star3}`;
          default: {
            const match2 = /^(.*?)\.(\w+)$/.exec(str);
            if (!match2) return;
            const source2 = create(match2[1]);
            if (!source2) return;
            return source2 + DOT_LITERAL + match2[2];
          }
        }
      };
      const output = utils.removePrefix(input, state);
      let source = create(output);
      if (source && opts.strictSlashes !== true) {
        source += `${SLASH_LITERAL}?`;
      }
      return source;
    };
    module2.exports = parse5;
  }
});

// node_modules/picomatch/lib/picomatch.js
var require_picomatch = __commonJS({
  "node_modules/picomatch/lib/picomatch.js"(exports2, module2) {
    "use strict";
    var path6 = require("path");
    var scan = require_scan();
    var parse5 = require_parse();
    var utils = require_utils();
    var constants = require_constants();
    var isObject4 = (val) => val && typeof val === "object" && !Array.isArray(val);
    var picomatch = (glob, options, returnState = false) => {
      if (Array.isArray(glob)) {
        const fns = glob.map((input) => picomatch(input, options, returnState));
        const arrayMatcher = (str) => {
          for (const isMatch of fns) {
            const state2 = isMatch(str);
            if (state2) return state2;
          }
          return false;
        };
        return arrayMatcher;
      }
      const isState = isObject4(glob) && glob.tokens && glob.input;
      if (glob === "" || typeof glob !== "string" && !isState) {
        throw new TypeError("Expected pattern to be a non-empty string");
      }
      const opts = options || {};
      const posix3 = utils.isWindows(options);
      const regex = isState ? picomatch.compileRe(glob, options) : picomatch.makeRe(glob, options, false, true);
      const state = regex.state;
      delete regex.state;
      let isIgnored = () => false;
      if (opts.ignore) {
        const ignoreOpts = { ...options, ignore: null, onMatch: null, onResult: null };
        isIgnored = picomatch(opts.ignore, ignoreOpts, returnState);
      }
      const matcher = (input, returnObject = false) => {
        const { isMatch, match: match2, output } = picomatch.test(input, regex, options, { glob, posix: posix3 });
        const result2 = { glob, state, regex, posix: posix3, input, output, match: match2, isMatch };
        if (typeof opts.onResult === "function") {
          opts.onResult(result2);
        }
        if (isMatch === false) {
          result2.isMatch = false;
          return returnObject ? result2 : false;
        }
        if (isIgnored(input)) {
          if (typeof opts.onIgnore === "function") {
            opts.onIgnore(result2);
          }
          result2.isMatch = false;
          return returnObject ? result2 : false;
        }
        if (typeof opts.onMatch === "function") {
          opts.onMatch(result2);
        }
        return returnObject ? result2 : true;
      };
      if (returnState) {
        matcher.state = state;
      }
      return matcher;
    };
    picomatch.test = (input, regex, options, { glob, posix: posix3 } = {}) => {
      if (typeof input !== "string") {
        throw new TypeError("Expected input to be a string");
      }
      if (input === "") {
        return { isMatch: false, output: "" };
      }
      const opts = options || {};
      const format = opts.format || (posix3 ? utils.toPosixSlashes : null);
      let match2 = input === glob;
      let output = match2 && format ? format(input) : input;
      if (match2 === false) {
        output = format ? format(input) : input;
        match2 = output === glob;
      }
      if (match2 === false || opts.capture === true) {
        if (opts.matchBase === true || opts.basename === true) {
          match2 = picomatch.matchBase(input, regex, options, posix3);
        } else {
          match2 = regex.exec(output);
        }
      }
      return { isMatch: Boolean(match2), match: match2, output };
    };
    picomatch.matchBase = (input, glob, options, posix3 = utils.isWindows(options)) => {
      const regex = glob instanceof RegExp ? glob : picomatch.makeRe(glob, options);
      return regex.test(path6.basename(input));
    };
    picomatch.isMatch = (str, patterns, options) => picomatch(patterns, options)(str);
    picomatch.parse = (pattern, options) => {
      if (Array.isArray(pattern)) return pattern.map((p) => picomatch.parse(p, options));
      return parse5(pattern, { ...options, fastpaths: false });
    };
    picomatch.scan = (input, options) => scan(input, options);
    picomatch.compileRe = (state, options, returnOutput = false, returnState = false) => {
      if (returnOutput === true) {
        return state.output;
      }
      const opts = options || {};
      const prepend3 = opts.contains ? "" : "^";
      const append4 = opts.contains ? "" : "$";
      let source = `${prepend3}(?:${state.output})${append4}`;
      if (state && state.negated === true) {
        source = `^(?!${source}).*$`;
      }
      const regex = picomatch.toRegex(source, options);
      if (returnState === true) {
        regex.state = state;
      }
      return regex;
    };
    picomatch.makeRe = (input, options = {}, returnOutput = false, returnState = false) => {
      if (!input || typeof input !== "string") {
        throw new TypeError("Expected a non-empty string");
      }
      let parsed = { negated: false, fastpaths: true };
      if (options.fastpaths !== false && (input[0] === "." || input[0] === "*")) {
        parsed.output = parse5.fastpaths(input, options);
      }
      if (!parsed.output) {
        parsed = parse5(input, options);
      }
      return picomatch.compileRe(parsed, options, returnOutput, returnState);
    };
    picomatch.toRegex = (source, options) => {
      try {
        const opts = options || {};
        return new RegExp(source, opts.flags || (opts.nocase ? "i" : ""));
      } catch (err2) {
        if (options && options.debug === true) throw err2;
        return /$^/;
      }
    };
    picomatch.constants = constants;
    module2.exports = picomatch;
  }
});

// node_modules/picomatch/index.js
var require_picomatch2 = __commonJS({
  "node_modules/picomatch/index.js"(exports2, module2) {
    "use strict";
    module2.exports = require_picomatch();
  }
});

// node_modules/@rollup/plugin-commonjs/node_modules/@rollup/pluginutils/dist/cjs/index.js
var require_cjs = __commonJS({
  "node_modules/@rollup/plugin-commonjs/node_modules/@rollup/pluginutils/dist/cjs/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    function _interopDefault(ex) {
      return ex && typeof ex === "object" && "default" in ex ? ex["default"] : ex;
    }
    var path6 = require("path");
    var pm3 = _interopDefault(require_picomatch2());
    var addExtension3 = function addExtension4(filename, ext2 = ".js") {
      let result2 = `${filename}`;
      if (!path6.extname(filename))
        result2 += ext2;
      return result2;
    };
    function walk3(ast, { enter, leave }) {
      return visit2(ast, null, enter, leave);
    }
    var should_skip = false;
    var should_remove = false;
    var replacement = null;
    var context = {
      skip: () => should_skip = true,
      remove: () => should_remove = true,
      replace: (node) => replacement = node
    };
    function replace2(parent, prop, index3, node) {
      if (parent) {
        if (index3 !== null) {
          parent[prop][index3] = node;
        } else {
          parent[prop] = node;
        }
      }
    }
    function remove4(parent, prop, index3) {
      if (parent) {
        if (index3 !== null) {
          parent[prop].splice(index3, 1);
        } else {
          delete parent[prop];
        }
      }
    }
    function visit2(node, parent, enter, leave, prop, index3) {
      if (node) {
        if (enter) {
          const _should_skip = should_skip;
          const _should_remove = should_remove;
          const _replacement = replacement;
          should_skip = false;
          should_remove = false;
          replacement = null;
          enter.call(context, node, parent, prop, index3);
          if (replacement) {
            node = replacement;
            replace2(parent, prop, index3, node);
          }
          if (should_remove) {
            remove4(parent, prop, index3);
          }
          const skipped = should_skip;
          const removed = should_remove;
          should_skip = _should_skip;
          should_remove = _should_remove;
          replacement = _replacement;
          if (skipped) return node;
          if (removed) return null;
        }
        for (const key in node) {
          const value = node[key];
          if (typeof value !== "object") {
            continue;
          } else if (Array.isArray(value)) {
            for (let j = 0, k = 0; j < value.length; j += 1, k += 1) {
              if (value[j] !== null && typeof value[j].type === "string") {
                if (!visit2(value[j], node, enter, leave, key, k)) {
                  j--;
                }
              }
            }
          } else if (value !== null && typeof value.type === "string") {
            visit2(value, node, enter, leave, key, null);
          }
        }
        if (leave) {
          const _replacement = replacement;
          const _should_remove = should_remove;
          replacement = null;
          should_remove = false;
          leave.call(context, node, parent, prop, index3);
          if (replacement) {
            node = replacement;
            replace2(parent, prop, index3, node);
          }
          if (should_remove) {
            remove4(parent, prop, index3);
          }
          const removed = should_remove;
          replacement = _replacement;
          should_remove = _should_remove;
          if (removed) return null;
        }
      }
      return node;
    }
    var extractors3 = {
      ArrayPattern(names, param) {
        for (const element of param.elements) {
          if (element)
            extractors3[element.type](names, element);
        }
      },
      AssignmentPattern(names, param) {
        extractors3[param.left.type](names, param.left);
      },
      Identifier(names, param) {
        names.push(param.name);
      },
      MemberExpression() {
      },
      ObjectPattern(names, param) {
        for (const prop of param.properties) {
          if (prop.type === "RestElement") {
            extractors3.RestElement(names, prop);
          } else {
            extractors3[prop.value.type](names, prop.value);
          }
        }
      },
      RestElement(names, param) {
        extractors3[param.argument.type](names, param.argument);
      }
    };
    var extractAssignedNames5 = function extractAssignedNames6(param) {
      const names = [];
      extractors3[param.type](names, param);
      return names;
    };
    var blockDeclarations2 = {
      const: true,
      let: true
    };
    var Scope4 = class {
      constructor(options = {}) {
        this.parent = options.parent;
        this.isBlockScope = !!options.block;
        this.declarations = /* @__PURE__ */ Object.create(null);
        if (options.params) {
          options.params.forEach((param) => {
            extractAssignedNames5(param).forEach((name) => {
              this.declarations[name] = true;
            });
          });
        }
      }
      addDeclaration(node, isBlockDeclaration, isVar) {
        if (!isBlockDeclaration && this.isBlockScope) {
          this.parent.addDeclaration(node, isBlockDeclaration, isVar);
        } else if (node.id) {
          extractAssignedNames5(node.id).forEach((name) => {
            this.declarations[name] = true;
          });
        }
      }
      contains(name) {
        return this.declarations[name] || (this.parent ? this.parent.contains(name) : false);
      }
    };
    var attachScopes3 = function attachScopes4(ast, propertyName = "scope") {
      let scope = new Scope4();
      walk3(ast, {
        enter(n3, parent) {
          const node = n3;
          if (/(Function|Class)Declaration/.test(node.type)) {
            scope.addDeclaration(node, false, false);
          }
          if (node.type === "VariableDeclaration") {
            const { kind } = node;
            const isBlockDeclaration = blockDeclarations2[kind];
            const parentType = parent ? parent.type : "";
            if (!(isBlockDeclaration && /ForOfStatement/.test(parentType))) {
              node.declarations.forEach((declaration) => {
                scope.addDeclaration(declaration, isBlockDeclaration, true);
              });
            }
          }
          let newScope;
          if (/Function/.test(node.type)) {
            const func = node;
            newScope = new Scope4({
              parent: scope,
              block: false,
              params: func.params
            });
            if (func.type === "FunctionExpression" && func.id) {
              newScope.addDeclaration(func, false, false);
            }
          }
          if (node.type === "BlockStatement" && !/Function/.test(parent.type)) {
            newScope = new Scope4({
              parent: scope,
              block: true
            });
          }
          if (node.type === "CatchClause") {
            newScope = new Scope4({
              parent: scope,
              params: node.param ? [node.param] : [],
              block: true
            });
          }
          if (newScope) {
            Object.defineProperty(node, propertyName, {
              value: newScope,
              configurable: true
            });
            scope = newScope;
          }
        },
        leave(n3) {
          const node = n3;
          if (node[propertyName])
            scope = scope.parent;
        }
      });
      return scope;
    };
    function isArray4(arg) {
      return Array.isArray(arg);
    }
    function ensureArray4(thing) {
      if (isArray4(thing))
        return thing;
      if (thing == null)
        return [];
      return [thing];
    }
    function getMatcherString3(id, resolutionBase) {
      if (resolutionBase === false) {
        return id;
      }
      const basePath = path6.resolve(resolutionBase || "").split(path6.sep).join("/").replace(/[-^$*+?.()|[\]{}]/g, "\\$&");
      return path6.posix.join(basePath, id);
    }
    var createFilter5 = function createFilter6(include, exclude, options) {
      const resolutionBase = options && options.resolve;
      const getMatcher = (id) => id instanceof RegExp ? id : {
        test: (what) => {
          const pattern = getMatcherString3(id, resolutionBase);
          const fn = pm3(pattern, { dot: true });
          const result2 = fn(what);
          return result2;
        }
      };
      const includeMatchers = ensureArray4(include).map(getMatcher);
      const excludeMatchers = ensureArray4(exclude).map(getMatcher);
      return function result2(id) {
        if (typeof id !== "string")
          return false;
        if (/\0/.test(id))
          return false;
        const pathId = id.split(path6.sep).join("/");
        for (let i = 0; i < excludeMatchers.length; ++i) {
          const matcher = excludeMatchers[i];
          if (matcher.test(pathId))
            return false;
        }
        for (let i = 0; i < includeMatchers.length; ++i) {
          const matcher = includeMatchers[i];
          if (matcher.test(pathId))
            return true;
        }
        return !includeMatchers.length;
      };
    };
    var reservedWords4 = "break case class catch const continue debugger default delete do else export extends finally for function if import in instanceof let new return super switch this throw try typeof var void while with yield enum await implements package protected static interface private public";
    var builtins5 = "arguments Infinity NaN undefined null true false eval uneval isFinite isNaN parseFloat parseInt decodeURI decodeURIComponent encodeURI encodeURIComponent escape unescape Object Function Boolean Symbol Error EvalError InternalError RangeError ReferenceError SyntaxError TypeError URIError Number Math Date String RegExp Array Int8Array Uint8Array Uint8ClampedArray Int16Array Uint16Array Int32Array Uint32Array Float32Array Float64Array Map Set WeakMap WeakSet SIMD ArrayBuffer DataView JSON Promise Generator GeneratorFunction Reflect Proxy Intl";
    var forbiddenIdentifiers3 = new Set(`${reservedWords4} ${builtins5}`.split(" "));
    forbiddenIdentifiers3.add("");
    var makeLegalIdentifier3 = function makeLegalIdentifier4(str) {
      let identifier = str.replace(/-(\w)/g, (_, letter) => letter.toUpperCase()).replace(/[^$_a-zA-Z0-9]/g, "_");
      if (/\d/.test(identifier[0]) || forbiddenIdentifiers3.has(identifier)) {
        identifier = `_${identifier}`;
      }
      return identifier || "_";
    };
    function stringify2(obj) {
      return (JSON.stringify(obj) || "undefined").replace(/[\u2028\u2029]/g, (char) => `\\u${`000${char.charCodeAt(0).toString(16)}`.slice(-4)}`);
    }
    function serializeArray2(arr, indent3, baseIndent) {
      let output = "[";
      const separator = indent3 ? `
${baseIndent}${indent3}` : "";
      for (let i = 0; i < arr.length; i++) {
        const key = arr[i];
        output += `${i > 0 ? "," : ""}${separator}${serialize2(key, indent3, baseIndent + indent3)}`;
      }
      return `${output}${indent3 ? `
${baseIndent}` : ""}]`;
    }
    function serializeObject2(obj, indent3, baseIndent) {
      let output = "{";
      const separator = indent3 ? `
${baseIndent}${indent3}` : "";
      const entries = Object.entries(obj);
      for (let i = 0; i < entries.length; i++) {
        const [key, value] = entries[i];
        const stringKey = makeLegalIdentifier3(key) === key ? key : stringify2(key);
        output += `${i > 0 ? "," : ""}${separator}${stringKey}:${indent3 ? " " : ""}${serialize2(value, indent3, baseIndent + indent3)}`;
      }
      return `${output}${indent3 ? `
${baseIndent}` : ""}}`;
    }
    function serialize2(obj, indent3, baseIndent) {
      if (obj === Infinity)
        return "Infinity";
      if (obj === -Infinity)
        return "-Infinity";
      if (obj === 0 && 1 / obj === -Infinity)
        return "-0";
      if (obj instanceof Date)
        return `new Date(${obj.getTime()})`;
      if (obj instanceof RegExp)
        return obj.toString();
      if (obj !== obj)
        return "NaN";
      if (Array.isArray(obj))
        return serializeArray2(obj, indent3, baseIndent);
      if (obj === null)
        return "null";
      if (typeof obj === "object")
        return serializeObject2(obj, indent3, baseIndent);
      return stringify2(obj);
    }
    var dataToEsm3 = function dataToEsm4(data2, options = {}) {
      const t = options.compact ? "" : "indent" in options ? options.indent : "	";
      const _ = options.compact ? "" : " ";
      const n3 = options.compact ? "" : "\n";
      const declarationType = options.preferConst ? "const" : "var";
      if (options.namedExports === false || typeof data2 !== "object" || Array.isArray(data2) || data2 instanceof Date || data2 instanceof RegExp || data2 === null) {
        const code = serialize2(data2, options.compact ? null : t, "");
        const magic = _ || (/^[{[\-\/]/.test(code) ? "" : " ");
        return `export default${magic}${code};`;
      }
      let namedExportCode = "";
      const defaultExportRows = [];
      for (const [key, value] of Object.entries(data2)) {
        if (key === makeLegalIdentifier3(key)) {
          if (options.objectShorthand)
            defaultExportRows.push(key);
          else
            defaultExportRows.push(`${key}:${_}${key}`);
          namedExportCode += `export ${declarationType} ${key}${_}=${_}${serialize2(value, options.compact ? null : t, "")};${n3}`;
        } else {
          defaultExportRows.push(`${stringify2(key)}:${_}${serialize2(value, options.compact ? null : t, "")}`);
        }
      }
      return `${namedExportCode}export default${_}{${n3}${t}${defaultExportRows.join(`,${n3}${t}`)}${n3}};${n3}`;
    };
    var index2 = {
      addExtension: addExtension3,
      attachScopes: attachScopes3,
      createFilter: createFilter5,
      dataToEsm: dataToEsm3,
      extractAssignedNames: extractAssignedNames5,
      makeLegalIdentifier: makeLegalIdentifier3
    };
    exports2.addExtension = addExtension3;
    exports2.attachScopes = attachScopes3;
    exports2.createFilter = createFilter5;
    exports2.dataToEsm = dataToEsm3;
    exports2.default = index2;
    exports2.extractAssignedNames = extractAssignedNames5;
    exports2.makeLegalIdentifier = makeLegalIdentifier3;
  }
});

// node_modules/commondir/index.js
var require_commondir = __commonJS({
  "node_modules/commondir/index.js"(exports2, module2) {
    var path6 = require("path");
    module2.exports = function(basedir, relfiles) {
      if (relfiles) {
        var files = relfiles.map(function(r) {
          return path6.resolve(basedir, r);
        });
      } else {
        var files = basedir;
      }
      var res = files.slice(1).reduce(function(ps, file) {
        if (!file.match(/^([A-Za-z]:)?\/|\\/)) {
          throw new Error("relative path without a basedir");
        }
        var xs = file.split(/\/+|\\+/);
        for (var i = 0; ps[i] === xs[i] && i < Math.min(ps.length, xs.length); i++) ;
        return ps.slice(0, i);
      }, files[0].split(/\/+|\\+/));
      return res.length > 1 ? res.join("/") : "/";
    };
  }
});

// node_modules/estree-walker/dist/umd/estree-walker.js
var require_estree_walker = __commonJS({
  "node_modules/estree-walker/dist/umd/estree-walker.js"(exports2, module2) {
    (function(global2, factory) {
      typeof exports2 === "object" && typeof module2 !== "undefined" ? factory(exports2) : typeof define === "function" && define.amd ? define(["exports"], factory) : (global2 = global2 || self, factory(global2.estreeWalker = {}));
    })(exports2, function(exports3) {
      "use strict";
      class WalkerBase2 {
        constructor() {
          this.should_skip = false;
          this.should_remove = false;
          this.replacement = null;
          this.context = {
            skip: () => this.should_skip = true,
            remove: () => this.should_remove = true,
            replace: (node) => this.replacement = node
          };
        }
        /**
         *
         * @param {any} parent
         * @param {string} prop
         * @param {number} index
         * @param {BaseNode} node
         */
        replace(parent, prop, index2, node) {
          if (parent) {
            if (index2 !== null) {
              parent[prop][index2] = node;
            } else {
              parent[prop] = node;
            }
          }
        }
        /**
         *
         * @param {any} parent
         * @param {string} prop
         * @param {number} index
         */
        remove(parent, prop, index2) {
          if (parent) {
            if (index2 !== null) {
              parent[prop].splice(index2, 1);
            } else {
              delete parent[prop];
            }
          }
        }
      }
      class SyncWalker2 extends WalkerBase2 {
        /**
         *
         * @param {SyncHandler} enter
         * @param {SyncHandler} leave
         */
        constructor(enter, leave) {
          super();
          this.enter = enter;
          this.leave = leave;
        }
        /**
         *
         * @param {BaseNode} node
         * @param {BaseNode} parent
         * @param {string} [prop]
         * @param {number} [index]
         * @returns {BaseNode}
         */
        visit(node, parent, prop, index2) {
          if (node) {
            if (this.enter) {
              const _should_skip = this.should_skip;
              const _should_remove = this.should_remove;
              const _replacement = this.replacement;
              this.should_skip = false;
              this.should_remove = false;
              this.replacement = null;
              this.enter.call(this.context, node, parent, prop, index2);
              if (this.replacement) {
                node = this.replacement;
                this.replace(parent, prop, index2, node);
              }
              if (this.should_remove) {
                this.remove(parent, prop, index2);
              }
              const skipped = this.should_skip;
              const removed = this.should_remove;
              this.should_skip = _should_skip;
              this.should_remove = _should_remove;
              this.replacement = _replacement;
              if (skipped) return node;
              if (removed) return null;
            }
            for (const key in node) {
              const value = node[key];
              if (typeof value !== "object") {
                continue;
              } else if (Array.isArray(value)) {
                for (let i = 0; i < value.length; i += 1) {
                  if (value[i] !== null && typeof value[i].type === "string") {
                    if (!this.visit(value[i], node, key, i)) {
                      i--;
                    }
                  }
                }
              } else if (value !== null && typeof value.type === "string") {
                this.visit(value, node, key, null);
              }
            }
            if (this.leave) {
              const _replacement = this.replacement;
              const _should_remove = this.should_remove;
              this.replacement = null;
              this.should_remove = false;
              this.leave.call(this.context, node, parent, prop, index2);
              if (this.replacement) {
                node = this.replacement;
                this.replace(parent, prop, index2, node);
              }
              if (this.should_remove) {
                this.remove(parent, prop, index2);
              }
              const removed = this.should_remove;
              this.replacement = _replacement;
              this.should_remove = _should_remove;
              if (removed) return null;
            }
          }
          return node;
        }
      }
      class AsyncWalker extends WalkerBase2 {
        /**
         *
         * @param {AsyncHandler} enter
         * @param {AsyncHandler} leave
         */
        constructor(enter, leave) {
          super();
          this.enter = enter;
          this.leave = leave;
        }
        /**
         *
         * @param {BaseNode} node
         * @param {BaseNode} parent
         * @param {string} [prop]
         * @param {number} [index]
         * @returns {Promise<BaseNode>}
         */
        async visit(node, parent, prop, index2) {
          if (node) {
            if (this.enter) {
              const _should_skip = this.should_skip;
              const _should_remove = this.should_remove;
              const _replacement = this.replacement;
              this.should_skip = false;
              this.should_remove = false;
              this.replacement = null;
              await this.enter.call(this.context, node, parent, prop, index2);
              if (this.replacement) {
                node = this.replacement;
                this.replace(parent, prop, index2, node);
              }
              if (this.should_remove) {
                this.remove(parent, prop, index2);
              }
              const skipped = this.should_skip;
              const removed = this.should_remove;
              this.should_skip = _should_skip;
              this.should_remove = _should_remove;
              this.replacement = _replacement;
              if (skipped) return node;
              if (removed) return null;
            }
            for (const key in node) {
              const value = node[key];
              if (typeof value !== "object") {
                continue;
              } else if (Array.isArray(value)) {
                for (let i = 0; i < value.length; i += 1) {
                  if (value[i] !== null && typeof value[i].type === "string") {
                    if (!await this.visit(value[i], node, key, i)) {
                      i--;
                    }
                  }
                }
              } else if (value !== null && typeof value.type === "string") {
                await this.visit(value, node, key, null);
              }
            }
            if (this.leave) {
              const _replacement = this.replacement;
              const _should_remove = this.should_remove;
              this.replacement = null;
              this.should_remove = false;
              await this.leave.call(this.context, node, parent, prop, index2);
              if (this.replacement) {
                node = this.replacement;
                this.replace(parent, prop, index2, node);
              }
              if (this.should_remove) {
                this.remove(parent, prop, index2);
              }
              const removed = this.should_remove;
              this.replacement = _replacement;
              this.should_remove = _should_remove;
              if (removed) return null;
            }
          }
          return node;
        }
      }
      function walk3(ast, { enter, leave }) {
        const instance = new SyncWalker2(enter, leave);
        return instance.visit(ast, null);
      }
      async function asyncWalk(ast, { enter, leave }) {
        const instance = new AsyncWalker(enter, leave);
        return await instance.visit(ast, null);
      }
      exports3.asyncWalk = asyncWalk;
      exports3.walk = walk3;
      Object.defineProperty(exports3, "__esModule", { value: true });
    });
  }
});

// node_modules/sourcemap-codec/dist/sourcemap-codec.umd.js
var require_sourcemap_codec_umd = __commonJS({
  "node_modules/sourcemap-codec/dist/sourcemap-codec.umd.js"(exports2, module2) {
    (function(global2, factory) {
      typeof exports2 === "object" && typeof module2 !== "undefined" ? factory(exports2) : typeof define === "function" && define.amd ? define(["exports"], factory) : (global2 = global2 || self, factory(global2.sourcemapCodec = {}));
    })(exports2, function(exports3) {
      "use strict";
      var charToInteger2 = {};
      var chars3 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
      for (var i = 0; i < chars3.length; i++) {
        charToInteger2[chars3.charCodeAt(i)] = i;
      }
      function decode3(mappings) {
        var decoded = [];
        var line = [];
        var segment = [
          0,
          0,
          0,
          0,
          0
        ];
        var j = 0;
        for (var i2 = 0, shift = 0, value = 0; i2 < mappings.length; i2++) {
          var c = mappings.charCodeAt(i2);
          if (c === 44) {
            segmentify2(line, segment, j);
            j = 0;
          } else if (c === 59) {
            segmentify2(line, segment, j);
            j = 0;
            decoded.push(line);
            line = [];
            segment[0] = 0;
          } else {
            var integer = charToInteger2[c];
            if (integer === void 0) {
              throw new Error("Invalid character (" + String.fromCharCode(c) + ")");
            }
            var hasContinuationBit = integer & 32;
            integer &= 31;
            value += integer << shift;
            if (hasContinuationBit) {
              shift += 5;
            } else {
              var shouldNegate = value & 1;
              value >>>= 1;
              if (shouldNegate) {
                value = value === 0 ? -2147483648 : -value;
              }
              segment[j] += value;
              j++;
              value = shift = 0;
            }
          }
        }
        segmentify2(line, segment, j);
        decoded.push(line);
        return decoded;
      }
      function segmentify2(line, segment, j) {
        if (j === 4)
          line.push([segment[0], segment[1], segment[2], segment[3]]);
        else if (j === 5)
          line.push([segment[0], segment[1], segment[2], segment[3], segment[4]]);
        else if (j === 1)
          line.push([segment[0]]);
      }
      function encode3(decoded) {
        var sourceFileIndex = 0;
        var sourceCodeLine = 0;
        var sourceCodeColumn = 0;
        var nameIndex = 0;
        var mappings = "";
        for (var i2 = 0; i2 < decoded.length; i2++) {
          var line = decoded[i2];
          if (i2 > 0)
            mappings += ";";
          if (line.length === 0)
            continue;
          var generatedCodeColumn = 0;
          var lineMappings = [];
          for (var _i = 0, line_1 = line; _i < line_1.length; _i++) {
            var segment = line_1[_i];
            var segmentMappings = encodeInteger3(segment[0] - generatedCodeColumn);
            generatedCodeColumn = segment[0];
            if (segment.length > 1) {
              segmentMappings += encodeInteger3(segment[1] - sourceFileIndex) + encodeInteger3(segment[2] - sourceCodeLine) + encodeInteger3(segment[3] - sourceCodeColumn);
              sourceFileIndex = segment[1];
              sourceCodeLine = segment[2];
              sourceCodeColumn = segment[3];
            }
            if (segment.length === 5) {
              segmentMappings += encodeInteger3(segment[4] - nameIndex);
              nameIndex = segment[4];
            }
            lineMappings.push(segmentMappings);
          }
          mappings += lineMappings.join(",");
        }
        return mappings;
      }
      function encodeInteger3(num) {
        var result2 = "";
        num = num < 0 ? -num << 1 | 1 : num << 1;
        do {
          var clamped = num & 31;
          num >>>= 5;
          if (num > 0) {
            clamped |= 32;
          }
          result2 += chars3[clamped];
        } while (num > 0);
        return result2;
      }
      exports3.decode = decode3;
      exports3.encode = encode3;
      Object.defineProperty(exports3, "__esModule", { value: true });
    });
  }
});

// node_modules/@rollup/plugin-commonjs/node_modules/magic-string/dist/magic-string.cjs.js
var require_magic_string_cjs = __commonJS({
  "node_modules/@rollup/plugin-commonjs/node_modules/magic-string/dist/magic-string.cjs.js"(exports2, module2) {
    "use strict";
    var sourcemapCodec = require_sourcemap_codec_umd();
    var BitSet4 = function BitSet5(arg) {
      this.bits = arg instanceof BitSet5 ? arg.bits.slice() : [];
    };
    BitSet4.prototype.add = function add2(n4) {
      this.bits[n4 >> 5] |= 1 << (n4 & 31);
    };
    BitSet4.prototype.has = function has3(n4) {
      return !!(this.bits[n4 >> 5] & 1 << (n4 & 31));
    };
    var Chunk4 = function Chunk5(start, end, content) {
      this.start = start;
      this.end = end;
      this.original = content;
      this.intro = "";
      this.outro = "";
      this.content = content;
      this.storeName = false;
      this.edited = false;
      Object.defineProperties(this, {
        previous: { writable: true, value: null },
        next: { writable: true, value: null }
      });
    };
    Chunk4.prototype.appendLeft = function appendLeft3(content) {
      this.outro += content;
    };
    Chunk4.prototype.appendRight = function appendRight3(content) {
      this.intro = this.intro + content;
    };
    Chunk4.prototype.clone = function clone5() {
      var chunk = new Chunk4(this.start, this.end, this.original);
      chunk.intro = this.intro;
      chunk.outro = this.outro;
      chunk.content = this.content;
      chunk.storeName = this.storeName;
      chunk.edited = this.edited;
      return chunk;
    };
    Chunk4.prototype.contains = function contains2(index2) {
      return this.start < index2 && index2 < this.end;
    };
    Chunk4.prototype.eachNext = function eachNext2(fn) {
      var chunk = this;
      while (chunk) {
        fn(chunk);
        chunk = chunk.next;
      }
    };
    Chunk4.prototype.eachPrevious = function eachPrevious2(fn) {
      var chunk = this;
      while (chunk) {
        fn(chunk);
        chunk = chunk.previous;
      }
    };
    Chunk4.prototype.edit = function edit2(content, storeName, contentOnly) {
      this.content = content;
      if (!contentOnly) {
        this.intro = "";
        this.outro = "";
      }
      this.storeName = storeName;
      this.edited = true;
      return this;
    };
    Chunk4.prototype.prependLeft = function prependLeft3(content) {
      this.outro = content + this.outro;
    };
    Chunk4.prototype.prependRight = function prependRight3(content) {
      this.intro = content + this.intro;
    };
    Chunk4.prototype.split = function split2(index2) {
      var sliceIndex = index2 - this.start;
      var originalBefore = this.original.slice(0, sliceIndex);
      var originalAfter = this.original.slice(sliceIndex);
      this.original = originalBefore;
      var newChunk = new Chunk4(index2, this.end, originalAfter);
      newChunk.outro = this.outro;
      this.outro = "";
      this.end = index2;
      if (this.edited) {
        newChunk.edit("", false);
        this.content = "";
      } else {
        this.content = originalBefore;
      }
      newChunk.next = this.next;
      if (newChunk.next) {
        newChunk.next.previous = newChunk;
      }
      newChunk.previous = this;
      this.next = newChunk;
      return newChunk;
    };
    Chunk4.prototype.toString = function toString8() {
      return this.intro + this.content + this.outro;
    };
    Chunk4.prototype.trimEnd = function trimEnd4(rx) {
      this.outro = this.outro.replace(rx, "");
      if (this.outro.length) {
        return true;
      }
      var trimmed = this.content.replace(rx, "");
      if (trimmed.length) {
        if (trimmed !== this.content) {
          this.split(this.start + trimmed.length).edit("", void 0, true);
        }
        return true;
      } else {
        this.edit("", void 0, true);
        this.intro = this.intro.replace(rx, "");
        if (this.intro.length) {
          return true;
        }
      }
    };
    Chunk4.prototype.trimStart = function trimStart4(rx) {
      this.intro = this.intro.replace(rx, "");
      if (this.intro.length) {
        return true;
      }
      var trimmed = this.content.replace(rx, "");
      if (trimmed.length) {
        if (trimmed !== this.content) {
          this.split(this.end - trimmed.length);
          this.edit("", void 0, true);
        }
        return true;
      } else {
        this.edit("", void 0, true);
        this.outro = this.outro.replace(rx, "");
        if (this.outro.length) {
          return true;
        }
      }
    };
    var btoa4 = function() {
      throw new Error("Unsupported environment: `window.btoa` or `Buffer` should be supported.");
    };
    if (typeof window !== "undefined" && typeof window.btoa === "function") {
      btoa4 = function(str) {
        return window.btoa(unescape(encodeURIComponent(str)));
      };
    } else if (typeof Buffer === "function") {
      btoa4 = function(str) {
        return Buffer.from(str, "utf-8").toString("base64");
      };
    }
    var SourceMap5 = function SourceMap6(properties) {
      this.version = 3;
      this.file = properties.file;
      this.sources = properties.sources;
      this.sourcesContent = properties.sourcesContent;
      this.names = properties.names;
      this.mappings = sourcemapCodec.encode(properties.mappings);
    };
    SourceMap5.prototype.toString = function toString8() {
      return JSON.stringify(this);
    };
    SourceMap5.prototype.toUrl = function toUrl2() {
      return "data:application/json;charset=utf-8;base64," + btoa4(this.toString());
    };
    function guessIndent3(code) {
      var lines = code.split("\n");
      var tabbed = lines.filter(function(line) {
        return /^\t+/.test(line);
      });
      var spaced = lines.filter(function(line) {
        return /^ {2,}/.test(line);
      });
      if (tabbed.length === 0 && spaced.length === 0) {
        return null;
      }
      if (tabbed.length >= spaced.length) {
        return "	";
      }
      var min = spaced.reduce(function(previous, current2) {
        var numSpaces = /^ +/.exec(current2)[0].length;
        return Math.min(numSpaces, previous);
      }, Infinity);
      return new Array(min + 1).join(" ");
    }
    function getRelativePath3(from, to) {
      var fromParts = from.split(/[/\\]/);
      var toParts = to.split(/[/\\]/);
      fromParts.pop();
      while (fromParts[0] === toParts[0]) {
        fromParts.shift();
        toParts.shift();
      }
      if (fromParts.length) {
        var i = fromParts.length;
        while (i--) {
          fromParts[i] = "..";
        }
      }
      return fromParts.concat(toParts).join("/");
    }
    var toString7 = Object.prototype.toString;
    function isObject4(thing) {
      return toString7.call(thing) === "[object Object]";
    }
    function getLocator3(source) {
      var originalLines = source.split("\n");
      var lineOffsets = [];
      for (var i = 0, pos = 0; i < originalLines.length; i++) {
        lineOffsets.push(pos);
        pos += originalLines[i].length + 1;
      }
      return function locate2(index2) {
        var i2 = 0;
        var j = lineOffsets.length;
        while (i2 < j) {
          var m = i2 + j >> 1;
          if (index2 < lineOffsets[m]) {
            j = m;
          } else {
            i2 = m + 1;
          }
        }
        var line = i2 - 1;
        var column = index2 - lineOffsets[line];
        return { line, column };
      };
    }
    var Mappings4 = function Mappings5(hires) {
      this.hires = hires;
      this.generatedCodeLine = 0;
      this.generatedCodeColumn = 0;
      this.raw = [];
      this.rawSegments = this.raw[this.generatedCodeLine] = [];
      this.pending = null;
    };
    Mappings4.prototype.addEdit = function addEdit2(sourceIndex2, content, loc, nameIndex) {
      if (content.length) {
        var segment = [this.generatedCodeColumn, sourceIndex2, loc.line, loc.column];
        if (nameIndex >= 0) {
          segment.push(nameIndex);
        }
        this.rawSegments.push(segment);
      } else if (this.pending) {
        this.rawSegments.push(this.pending);
      }
      this.advance(content);
      this.pending = null;
    };
    Mappings4.prototype.addUneditedChunk = function addUneditedChunk2(sourceIndex2, chunk, original, loc, sourcemapLocations) {
      var originalCharIndex = chunk.start;
      var first = true;
      while (originalCharIndex < chunk.end) {
        if (this.hires || first || sourcemapLocations.has(originalCharIndex)) {
          this.rawSegments.push([this.generatedCodeColumn, sourceIndex2, loc.line, loc.column]);
        }
        if (original[originalCharIndex] === "\n") {
          loc.line += 1;
          loc.column = 0;
          this.generatedCodeLine += 1;
          this.raw[this.generatedCodeLine] = this.rawSegments = [];
          this.generatedCodeColumn = 0;
          first = true;
        } else {
          loc.column += 1;
          this.generatedCodeColumn += 1;
          first = false;
        }
        originalCharIndex += 1;
      }
      this.pending = null;
    };
    Mappings4.prototype.advance = function advance3(str) {
      if (!str) {
        return;
      }
      var lines = str.split("\n");
      if (lines.length > 1) {
        for (var i = 0; i < lines.length - 1; i++) {
          this.generatedCodeLine++;
          this.raw[this.generatedCodeLine] = this.rawSegments = [];
        }
        this.generatedCodeColumn = 0;
      }
      this.generatedCodeColumn += lines[lines.length - 1].length;
    };
    var n3 = "\n";
    var warned3 = {
      insertLeft: false,
      insertRight: false,
      storeName: false
    };
    var MagicString4 = function MagicString5(string, options) {
      if (options === void 0) options = {};
      var chunk = new Chunk4(0, string.length, string);
      Object.defineProperties(this, {
        original: { writable: true, value: string },
        outro: { writable: true, value: "" },
        intro: { writable: true, value: "" },
        firstChunk: { writable: true, value: chunk },
        lastChunk: { writable: true, value: chunk },
        lastSearchedChunk: { writable: true, value: chunk },
        byStart: { writable: true, value: {} },
        byEnd: { writable: true, value: {} },
        filename: { writable: true, value: options.filename },
        indentExclusionRanges: { writable: true, value: options.indentExclusionRanges },
        sourcemapLocations: { writable: true, value: new BitSet4() },
        storedNames: { writable: true, value: {} },
        indentStr: { writable: true, value: guessIndent3(string) }
      });
      this.byStart[0] = chunk;
      this.byEnd[string.length] = chunk;
    };
    MagicString4.prototype.addSourcemapLocation = function addSourcemapLocation2(char) {
      this.sourcemapLocations.add(char);
    };
    MagicString4.prototype.append = function append4(content) {
      if (typeof content !== "string") {
        throw new TypeError("outro content must be a string");
      }
      this.outro += content;
      return this;
    };
    MagicString4.prototype.appendLeft = function appendLeft3(index2, content) {
      if (typeof content !== "string") {
        throw new TypeError("inserted content must be a string");
      }
      this._split(index2);
      var chunk = this.byEnd[index2];
      if (chunk) {
        chunk.appendLeft(content);
      } else {
        this.intro += content;
      }
      return this;
    };
    MagicString4.prototype.appendRight = function appendRight3(index2, content) {
      if (typeof content !== "string") {
        throw new TypeError("inserted content must be a string");
      }
      this._split(index2);
      var chunk = this.byStart[index2];
      if (chunk) {
        chunk.appendRight(content);
      } else {
        this.outro += content;
      }
      return this;
    };
    MagicString4.prototype.clone = function clone5() {
      var cloned = new MagicString4(this.original, { filename: this.filename });
      var originalChunk = this.firstChunk;
      var clonedChunk = cloned.firstChunk = cloned.lastSearchedChunk = originalChunk.clone();
      while (originalChunk) {
        cloned.byStart[clonedChunk.start] = clonedChunk;
        cloned.byEnd[clonedChunk.end] = clonedChunk;
        var nextOriginalChunk = originalChunk.next;
        var nextClonedChunk = nextOriginalChunk && nextOriginalChunk.clone();
        if (nextClonedChunk) {
          clonedChunk.next = nextClonedChunk;
          nextClonedChunk.previous = clonedChunk;
          clonedChunk = nextClonedChunk;
        }
        originalChunk = nextOriginalChunk;
      }
      cloned.lastChunk = clonedChunk;
      if (this.indentExclusionRanges) {
        cloned.indentExclusionRanges = this.indentExclusionRanges.slice();
      }
      cloned.sourcemapLocations = new BitSet4(this.sourcemapLocations);
      cloned.intro = this.intro;
      cloned.outro = this.outro;
      return cloned;
    };
    MagicString4.prototype.generateDecodedMap = function generateDecodedMap3(options) {
      var this$1$1 = this;
      options = options || {};
      var sourceIndex2 = 0;
      var names = Object.keys(this.storedNames);
      var mappings = new Mappings4(options.hires);
      var locate2 = getLocator3(this.original);
      if (this.intro) {
        mappings.advance(this.intro);
      }
      this.firstChunk.eachNext(function(chunk) {
        var loc = locate2(chunk.start);
        if (chunk.intro.length) {
          mappings.advance(chunk.intro);
        }
        if (chunk.edited) {
          mappings.addEdit(
            sourceIndex2,
            chunk.content,
            loc,
            chunk.storeName ? names.indexOf(chunk.original) : -1
          );
        } else {
          mappings.addUneditedChunk(sourceIndex2, chunk, this$1$1.original, loc, this$1$1.sourcemapLocations);
        }
        if (chunk.outro.length) {
          mappings.advance(chunk.outro);
        }
      });
      return {
        file: options.file ? options.file.split(/[/\\]/).pop() : null,
        sources: [options.source ? getRelativePath3(options.file || "", options.source) : null],
        sourcesContent: options.includeContent ? [this.original] : [null],
        names,
        mappings: mappings.raw
      };
    };
    MagicString4.prototype.generateMap = function generateMap3(options) {
      return new SourceMap5(this.generateDecodedMap(options));
    };
    MagicString4.prototype.getIndentString = function getIndentString4() {
      return this.indentStr === null ? "	" : this.indentStr;
    };
    MagicString4.prototype.indent = function indent3(indentStr, options) {
      var pattern = /^[^\r\n]/gm;
      if (isObject4(indentStr)) {
        options = indentStr;
        indentStr = void 0;
      }
      indentStr = indentStr !== void 0 ? indentStr : this.indentStr || "	";
      if (indentStr === "") {
        return this;
      }
      options = options || {};
      var isExcluded = {};
      if (options.exclude) {
        var exclusions = typeof options.exclude[0] === "number" ? [options.exclude] : options.exclude;
        exclusions.forEach(function(exclusion) {
          for (var i = exclusion[0]; i < exclusion[1]; i += 1) {
            isExcluded[i] = true;
          }
        });
      }
      var shouldIndentNextCharacter = options.indentStart !== false;
      var replacer = function(match2) {
        if (shouldIndentNextCharacter) {
          return "" + indentStr + match2;
        }
        shouldIndentNextCharacter = true;
        return match2;
      };
      this.intro = this.intro.replace(pattern, replacer);
      var charIndex = 0;
      var chunk = this.firstChunk;
      while (chunk) {
        var end = chunk.end;
        if (chunk.edited) {
          if (!isExcluded[charIndex]) {
            chunk.content = chunk.content.replace(pattern, replacer);
            if (chunk.content.length) {
              shouldIndentNextCharacter = chunk.content[chunk.content.length - 1] === "\n";
            }
          }
        } else {
          charIndex = chunk.start;
          while (charIndex < end) {
            if (!isExcluded[charIndex]) {
              var char = this.original[charIndex];
              if (char === "\n") {
                shouldIndentNextCharacter = true;
              } else if (char !== "\r" && shouldIndentNextCharacter) {
                shouldIndentNextCharacter = false;
                if (charIndex === chunk.start) {
                  chunk.prependRight(indentStr);
                } else {
                  this._splitChunk(chunk, charIndex);
                  chunk = chunk.next;
                  chunk.prependRight(indentStr);
                }
              }
            }
            charIndex += 1;
          }
        }
        charIndex = chunk.end;
        chunk = chunk.next;
      }
      this.outro = this.outro.replace(pattern, replacer);
      return this;
    };
    MagicString4.prototype.insert = function insert4() {
      throw new Error(
        "magicString.insert(...) is deprecated. Use prependRight(...) or appendLeft(...)"
      );
    };
    MagicString4.prototype.insertLeft = function insertLeft2(index2, content) {
      if (!warned3.insertLeft) {
        console.warn(
          "magicString.insertLeft(...) is deprecated. Use magicString.appendLeft(...) instead"
        );
        warned3.insertLeft = true;
      }
      return this.appendLeft(index2, content);
    };
    MagicString4.prototype.insertRight = function insertRight2(index2, content) {
      if (!warned3.insertRight) {
        console.warn(
          "magicString.insertRight(...) is deprecated. Use magicString.prependRight(...) instead"
        );
        warned3.insertRight = true;
      }
      return this.prependRight(index2, content);
    };
    MagicString4.prototype.move = function move2(start, end, index2) {
      if (index2 >= start && index2 <= end) {
        throw new Error("Cannot move a selection inside itself");
      }
      this._split(start);
      this._split(end);
      this._split(index2);
      var first = this.byStart[start];
      var last = this.byEnd[end];
      var oldLeft = first.previous;
      var oldRight = last.next;
      var newRight = this.byStart[index2];
      if (!newRight && last === this.lastChunk) {
        return this;
      }
      var newLeft = newRight ? newRight.previous : this.lastChunk;
      if (oldLeft) {
        oldLeft.next = oldRight;
      }
      if (oldRight) {
        oldRight.previous = oldLeft;
      }
      if (newLeft) {
        newLeft.next = first;
      }
      if (newRight) {
        newRight.previous = last;
      }
      if (!first.previous) {
        this.firstChunk = last.next;
      }
      if (!last.next) {
        this.lastChunk = first.previous;
        this.lastChunk.next = null;
      }
      first.previous = newLeft;
      last.next = newRight || null;
      if (!newLeft) {
        this.firstChunk = first;
      }
      if (!newRight) {
        this.lastChunk = last;
      }
      return this;
    };
    MagicString4.prototype.overwrite = function overwrite2(start, end, content, options) {
      if (typeof content !== "string") {
        throw new TypeError("replacement content must be a string");
      }
      while (start < 0) {
        start += this.original.length;
      }
      while (end < 0) {
        end += this.original.length;
      }
      if (end > this.original.length) {
        throw new Error("end is out of bounds");
      }
      if (start === end) {
        throw new Error(
          "Cannot overwrite a zero-length range \u2013 use appendLeft or prependRight instead"
        );
      }
      this._split(start);
      this._split(end);
      if (options === true) {
        if (!warned3.storeName) {
          console.warn(
            "The final argument to magicString.overwrite(...) should be an options object. See https://github.com/rich-harris/magic-string"
          );
          warned3.storeName = true;
        }
        options = { storeName: true };
      }
      var storeName = options !== void 0 ? options.storeName : false;
      var contentOnly = options !== void 0 ? options.contentOnly : false;
      if (storeName) {
        var original = this.original.slice(start, end);
        Object.defineProperty(this.storedNames, original, { writable: true, value: true, enumerable: true });
      }
      var first = this.byStart[start];
      var last = this.byEnd[end];
      if (first) {
        var chunk = first;
        while (chunk !== last) {
          if (chunk.next !== this.byStart[chunk.end]) {
            throw new Error("Cannot overwrite across a split point");
          }
          chunk = chunk.next;
          chunk.edit("", false);
        }
        first.edit(content, storeName, contentOnly);
      } else {
        var newChunk = new Chunk4(start, end, "").edit(content, storeName);
        last.next = newChunk;
        newChunk.previous = last;
      }
      return this;
    };
    MagicString4.prototype.prepend = function prepend3(content) {
      if (typeof content !== "string") {
        throw new TypeError("outro content must be a string");
      }
      this.intro = content + this.intro;
      return this;
    };
    MagicString4.prototype.prependLeft = function prependLeft3(index2, content) {
      if (typeof content !== "string") {
        throw new TypeError("inserted content must be a string");
      }
      this._split(index2);
      var chunk = this.byEnd[index2];
      if (chunk) {
        chunk.prependLeft(content);
      } else {
        this.intro = content + this.intro;
      }
      return this;
    };
    MagicString4.prototype.prependRight = function prependRight3(index2, content) {
      if (typeof content !== "string") {
        throw new TypeError("inserted content must be a string");
      }
      this._split(index2);
      var chunk = this.byStart[index2];
      if (chunk) {
        chunk.prependRight(content);
      } else {
        this.outro = content + this.outro;
      }
      return this;
    };
    MagicString4.prototype.remove = function remove4(start, end) {
      while (start < 0) {
        start += this.original.length;
      }
      while (end < 0) {
        end += this.original.length;
      }
      if (start === end) {
        return this;
      }
      if (start < 0 || end > this.original.length) {
        throw new Error("Character is out of bounds");
      }
      if (start > end) {
        throw new Error("end must be greater than start");
      }
      this._split(start);
      this._split(end);
      var chunk = this.byStart[start];
      while (chunk) {
        chunk.intro = "";
        chunk.outro = "";
        chunk.edit("");
        chunk = end > chunk.end ? this.byStart[chunk.end] : null;
      }
      return this;
    };
    MagicString4.prototype.lastChar = function lastChar2() {
      if (this.outro.length) {
        return this.outro[this.outro.length - 1];
      }
      var chunk = this.lastChunk;
      do {
        if (chunk.outro.length) {
          return chunk.outro[chunk.outro.length - 1];
        }
        if (chunk.content.length) {
          return chunk.content[chunk.content.length - 1];
        }
        if (chunk.intro.length) {
          return chunk.intro[chunk.intro.length - 1];
        }
      } while (chunk = chunk.previous);
      if (this.intro.length) {
        return this.intro[this.intro.length - 1];
      }
      return "";
    };
    MagicString4.prototype.lastLine = function lastLine2() {
      var lineIndex = this.outro.lastIndexOf(n3);
      if (lineIndex !== -1) {
        return this.outro.substr(lineIndex + 1);
      }
      var lineStr = this.outro;
      var chunk = this.lastChunk;
      do {
        if (chunk.outro.length > 0) {
          lineIndex = chunk.outro.lastIndexOf(n3);
          if (lineIndex !== -1) {
            return chunk.outro.substr(lineIndex + 1) + lineStr;
          }
          lineStr = chunk.outro + lineStr;
        }
        if (chunk.content.length > 0) {
          lineIndex = chunk.content.lastIndexOf(n3);
          if (lineIndex !== -1) {
            return chunk.content.substr(lineIndex + 1) + lineStr;
          }
          lineStr = chunk.content + lineStr;
        }
        if (chunk.intro.length > 0) {
          lineIndex = chunk.intro.lastIndexOf(n3);
          if (lineIndex !== -1) {
            return chunk.intro.substr(lineIndex + 1) + lineStr;
          }
          lineStr = chunk.intro + lineStr;
        }
      } while (chunk = chunk.previous);
      lineIndex = this.intro.lastIndexOf(n3);
      if (lineIndex !== -1) {
        return this.intro.substr(lineIndex + 1) + lineStr;
      }
      return this.intro + lineStr;
    };
    MagicString4.prototype.slice = function slice2(start, end) {
      if (start === void 0) start = 0;
      if (end === void 0) end = this.original.length;
      while (start < 0) {
        start += this.original.length;
      }
      while (end < 0) {
        end += this.original.length;
      }
      var result2 = "";
      var chunk = this.firstChunk;
      while (chunk && (chunk.start > start || chunk.end <= start)) {
        if (chunk.start < end && chunk.end >= end) {
          return result2;
        }
        chunk = chunk.next;
      }
      if (chunk && chunk.edited && chunk.start !== start) {
        throw new Error("Cannot use replaced character " + start + " as slice start anchor.");
      }
      var startChunk = chunk;
      while (chunk) {
        if (chunk.intro && (startChunk !== chunk || chunk.start === start)) {
          result2 += chunk.intro;
        }
        var containsEnd = chunk.start < end && chunk.end >= end;
        if (containsEnd && chunk.edited && chunk.end !== end) {
          throw new Error("Cannot use replaced character " + end + " as slice end anchor.");
        }
        var sliceStart = startChunk === chunk ? start - chunk.start : 0;
        var sliceEnd = containsEnd ? chunk.content.length + end - chunk.end : chunk.content.length;
        result2 += chunk.content.slice(sliceStart, sliceEnd);
        if (chunk.outro && (!containsEnd || chunk.end === end)) {
          result2 += chunk.outro;
        }
        if (containsEnd) {
          break;
        }
        chunk = chunk.next;
      }
      return result2;
    };
    MagicString4.prototype.snip = function snip2(start, end) {
      var clone5 = this.clone();
      clone5.remove(0, start);
      clone5.remove(end, clone5.original.length);
      return clone5;
    };
    MagicString4.prototype._split = function _split2(index2) {
      if (this.byStart[index2] || this.byEnd[index2]) {
        return;
      }
      var chunk = this.lastSearchedChunk;
      var searchForward = index2 > chunk.end;
      while (chunk) {
        if (chunk.contains(index2)) {
          return this._splitChunk(chunk, index2);
        }
        chunk = searchForward ? this.byStart[chunk.end] : this.byEnd[chunk.start];
      }
    };
    MagicString4.prototype._splitChunk = function _splitChunk2(chunk, index2) {
      if (chunk.edited && chunk.content.length) {
        var loc = getLocator3(this.original)(index2);
        throw new Error(
          "Cannot split a chunk that has already been edited (" + loc.line + ":" + loc.column + ' \u2013 "' + chunk.original + '")'
        );
      }
      var newChunk = chunk.split(index2);
      this.byEnd[index2] = chunk;
      this.byStart[index2] = newChunk;
      this.byEnd[newChunk.end] = newChunk;
      if (chunk === this.lastChunk) {
        this.lastChunk = newChunk;
      }
      this.lastSearchedChunk = chunk;
      return true;
    };
    MagicString4.prototype.toString = function toString8() {
      var str = this.intro;
      var chunk = this.firstChunk;
      while (chunk) {
        str += chunk.toString();
        chunk = chunk.next;
      }
      return str + this.outro;
    };
    MagicString4.prototype.isEmpty = function isEmpty3() {
      var chunk = this.firstChunk;
      do {
        if (chunk.intro.length && chunk.intro.trim() || chunk.content.length && chunk.content.trim() || chunk.outro.length && chunk.outro.trim()) {
          return false;
        }
      } while (chunk = chunk.next);
      return true;
    };
    MagicString4.prototype.length = function length3() {
      var chunk = this.firstChunk;
      var length4 = 0;
      do {
        length4 += chunk.intro.length + chunk.content.length + chunk.outro.length;
      } while (chunk = chunk.next);
      return length4;
    };
    MagicString4.prototype.trimLines = function trimLines3() {
      return this.trim("[\\r\\n]");
    };
    MagicString4.prototype.trim = function trim5(charType) {
      return this.trimStart(charType).trimEnd(charType);
    };
    MagicString4.prototype.trimEndAborted = function trimEndAborted2(charType) {
      var rx = new RegExp((charType || "\\s") + "+$");
      this.outro = this.outro.replace(rx, "");
      if (this.outro.length) {
        return true;
      }
      var chunk = this.lastChunk;
      do {
        var end = chunk.end;
        var aborted = chunk.trimEnd(rx);
        if (chunk.end !== end) {
          if (this.lastChunk === chunk) {
            this.lastChunk = chunk.next;
          }
          this.byEnd[chunk.end] = chunk;
          this.byStart[chunk.next.start] = chunk.next;
          this.byEnd[chunk.next.end] = chunk.next;
        }
        if (aborted) {
          return true;
        }
        chunk = chunk.previous;
      } while (chunk);
      return false;
    };
    MagicString4.prototype.trimEnd = function trimEnd4(charType) {
      this.trimEndAborted(charType);
      return this;
    };
    MagicString4.prototype.trimStartAborted = function trimStartAborted2(charType) {
      var rx = new RegExp("^" + (charType || "\\s") + "+");
      this.intro = this.intro.replace(rx, "");
      if (this.intro.length) {
        return true;
      }
      var chunk = this.firstChunk;
      do {
        var end = chunk.end;
        var aborted = chunk.trimStart(rx);
        if (chunk.end !== end) {
          if (chunk === this.lastChunk) {
            this.lastChunk = chunk.next;
          }
          this.byEnd[chunk.end] = chunk;
          this.byStart[chunk.next.start] = chunk.next;
          this.byEnd[chunk.next.end] = chunk.next;
        }
        if (aborted) {
          return true;
        }
        chunk = chunk.next;
      } while (chunk);
      return false;
    };
    MagicString4.prototype.trimStart = function trimStart4(charType) {
      this.trimStartAborted(charType);
      return this;
    };
    var hasOwnProp2 = Object.prototype.hasOwnProperty;
    var Bundle3 = function Bundle4(options) {
      if (options === void 0) options = {};
      this.intro = options.intro || "";
      this.separator = options.separator !== void 0 ? options.separator : "\n";
      this.sources = [];
      this.uniqueSources = [];
      this.uniqueSourceIndexByFilename = {};
    };
    Bundle3.prototype.addSource = function addSource2(source) {
      if (source instanceof MagicString4) {
        return this.addSource({
          content: source,
          filename: source.filename,
          separator: this.separator
        });
      }
      if (!isObject4(source) || !source.content) {
        throw new Error(
          "bundle.addSource() takes an object with a `content` property, which should be an instance of MagicString, and an optional `filename`"
        );
      }
      ["filename", "indentExclusionRanges", "separator"].forEach(function(option) {
        if (!hasOwnProp2.call(source, option)) {
          source[option] = source.content[option];
        }
      });
      if (source.separator === void 0) {
        source.separator = this.separator;
      }
      if (source.filename) {
        if (!hasOwnProp2.call(this.uniqueSourceIndexByFilename, source.filename)) {
          this.uniqueSourceIndexByFilename[source.filename] = this.uniqueSources.length;
          this.uniqueSources.push({ filename: source.filename, content: source.content.original });
        } else {
          var uniqueSource = this.uniqueSources[this.uniqueSourceIndexByFilename[source.filename]];
          if (source.content.original !== uniqueSource.content) {
            throw new Error("Illegal source: same filename (" + source.filename + "), different contents");
          }
        }
      }
      this.sources.push(source);
      return this;
    };
    Bundle3.prototype.append = function append4(str, options) {
      this.addSource({
        content: new MagicString4(str),
        separator: options && options.separator || ""
      });
      return this;
    };
    Bundle3.prototype.clone = function clone5() {
      var bundle = new Bundle3({
        intro: this.intro,
        separator: this.separator
      });
      this.sources.forEach(function(source) {
        bundle.addSource({
          filename: source.filename,
          content: source.content.clone(),
          separator: source.separator
        });
      });
      return bundle;
    };
    Bundle3.prototype.generateDecodedMap = function generateDecodedMap3(options) {
      var this$1$1 = this;
      if (options === void 0) options = {};
      var names = [];
      this.sources.forEach(function(source) {
        Object.keys(source.content.storedNames).forEach(function(name) {
          if (!~names.indexOf(name)) {
            names.push(name);
          }
        });
      });
      var mappings = new Mappings4(options.hires);
      if (this.intro) {
        mappings.advance(this.intro);
      }
      this.sources.forEach(function(source, i) {
        if (i > 0) {
          mappings.advance(this$1$1.separator);
        }
        var sourceIndex2 = source.filename ? this$1$1.uniqueSourceIndexByFilename[source.filename] : -1;
        var magicString = source.content;
        var locate2 = getLocator3(magicString.original);
        if (magicString.intro) {
          mappings.advance(magicString.intro);
        }
        magicString.firstChunk.eachNext(function(chunk) {
          var loc = locate2(chunk.start);
          if (chunk.intro.length) {
            mappings.advance(chunk.intro);
          }
          if (source.filename) {
            if (chunk.edited) {
              mappings.addEdit(
                sourceIndex2,
                chunk.content,
                loc,
                chunk.storeName ? names.indexOf(chunk.original) : -1
              );
            } else {
              mappings.addUneditedChunk(
                sourceIndex2,
                chunk,
                magicString.original,
                loc,
                magicString.sourcemapLocations
              );
            }
          } else {
            mappings.advance(chunk.content);
          }
          if (chunk.outro.length) {
            mappings.advance(chunk.outro);
          }
        });
        if (magicString.outro) {
          mappings.advance(magicString.outro);
        }
      });
      return {
        file: options.file ? options.file.split(/[/\\]/).pop() : null,
        sources: this.uniqueSources.map(function(source) {
          return options.file ? getRelativePath3(options.file, source.filename) : source.filename;
        }),
        sourcesContent: this.uniqueSources.map(function(source) {
          return options.includeContent ? source.content : null;
        }),
        names,
        mappings: mappings.raw
      };
    };
    Bundle3.prototype.generateMap = function generateMap3(options) {
      return new SourceMap5(this.generateDecodedMap(options));
    };
    Bundle3.prototype.getIndentString = function getIndentString4() {
      var indentStringCounts = {};
      this.sources.forEach(function(source) {
        var indentStr = source.content.indentStr;
        if (indentStr === null) {
          return;
        }
        if (!indentStringCounts[indentStr]) {
          indentStringCounts[indentStr] = 0;
        }
        indentStringCounts[indentStr] += 1;
      });
      return Object.keys(indentStringCounts).sort(function(a, b) {
        return indentStringCounts[a] - indentStringCounts[b];
      })[0] || "	";
    };
    Bundle3.prototype.indent = function indent3(indentStr) {
      var this$1$1 = this;
      if (!arguments.length) {
        indentStr = this.getIndentString();
      }
      if (indentStr === "") {
        return this;
      }
      var trailingNewline = !this.intro || this.intro.slice(-1) === "\n";
      this.sources.forEach(function(source, i) {
        var separator = source.separator !== void 0 ? source.separator : this$1$1.separator;
        var indentStart = trailingNewline || i > 0 && /\r?\n$/.test(separator);
        source.content.indent(indentStr, {
          exclude: source.indentExclusionRanges,
          indentStart
          //: trailingNewline || /\r?\n$/.test( separator )  //true///\r?\n/.test( separator )
        });
        trailingNewline = source.content.lastChar() === "\n";
      });
      if (this.intro) {
        this.intro = indentStr + this.intro.replace(/^[^\n]/gm, function(match2, index2) {
          return index2 > 0 ? indentStr + match2 : match2;
        });
      }
      return this;
    };
    Bundle3.prototype.prepend = function prepend3(str) {
      this.intro = str + this.intro;
      return this;
    };
    Bundle3.prototype.toString = function toString8() {
      var this$1$1 = this;
      var body = this.sources.map(function(source, i) {
        var separator = source.separator !== void 0 ? source.separator : this$1$1.separator;
        var str = (i > 0 ? separator : "") + source.content.toString();
        return str;
      }).join("");
      return this.intro + body;
    };
    Bundle3.prototype.isEmpty = function isEmpty3() {
      if (this.intro.length && this.intro.trim()) {
        return false;
      }
      if (this.sources.some(function(source) {
        return !source.content.isEmpty();
      })) {
        return false;
      }
      return true;
    };
    Bundle3.prototype.length = function length3() {
      return this.sources.reduce(
        function(length4, source) {
          return length4 + source.content.length();
        },
        this.intro.length
      );
    };
    Bundle3.prototype.trimLines = function trimLines3() {
      return this.trim("[\\r\\n]");
    };
    Bundle3.prototype.trim = function trim5(charType) {
      return this.trimStart(charType).trimEnd(charType);
    };
    Bundle3.prototype.trimStart = function trimStart4(charType) {
      var rx = new RegExp("^" + (charType || "\\s") + "+");
      this.intro = this.intro.replace(rx, "");
      if (!this.intro) {
        var source;
        var i = 0;
        do {
          source = this.sources[i++];
          if (!source) {
            break;
          }
        } while (!source.content.trimStartAborted(charType));
      }
      return this;
    };
    Bundle3.prototype.trimEnd = function trimEnd4(charType) {
      var rx = new RegExp((charType || "\\s") + "+$");
      var source;
      var i = this.sources.length - 1;
      do {
        source = this.sources[i--];
        if (!source) {
          this.intro = this.intro.replace(rx, "");
          break;
        }
      } while (!source.content.trimEndAborted(charType));
      return this;
    };
    MagicString4.Bundle = Bundle3;
    MagicString4.SourceMap = SourceMap5;
    MagicString4.default = MagicString4;
    module2.exports = MagicString4;
  }
});

// node_modules/is-reference/dist/is-reference.js
var require_is_reference = __commonJS({
  "node_modules/is-reference/dist/is-reference.js"(exports2, module2) {
    (function(global2, factory) {
      typeof exports2 === "object" && typeof module2 !== "undefined" ? module2.exports = factory() : typeof define === "function" && define.amd ? define(factory) : (global2 = global2 || self, global2.isReference = factory());
    })(exports2, function() {
      "use strict";
      function isReference(node, parent) {
        if (node.type === "MemberExpression") {
          return !node.computed && isReference(node.object, node);
        }
        if (node.type === "Identifier") {
          if (!parent)
            return true;
          switch (parent.type) {
            case "MemberExpression":
              return parent.computed || node === parent.object;
            case "MethodDefinition":
              return parent.computed;
            case "FieldDefinition":
              return parent.computed || node === parent.value;
            case "Property":
              return parent.computed || node === parent.value;
            case "ExportSpecifier":
            case "ImportSpecifier":
              return node === parent.local;
            case "LabeledStatement":
            case "BreakStatement":
            case "ContinueStatement":
              return false;
            default:
              return true;
          }
        }
        return false;
      }
      return isReference;
    });
  }
});

// node_modules/resolve/lib/homedir.js
var require_homedir = __commonJS({
  "node_modules/resolve/lib/homedir.js"(exports2, module2) {
    "use strict";
    var os2 = require("os");
    module2.exports = os2.homedir || function homedir2() {
      var home = process.env.HOME;
      var user = process.env.LOGNAME || process.env.USER || process.env.LNAME || process.env.USERNAME;
      if (process.platform === "win32") {
        return process.env.USERPROFILE || process.env.HOMEDRIVE + process.env.HOMEPATH || home || null;
      }
      if (process.platform === "darwin") {
        return home || (user ? "/Users/" + user : null);
      }
      if (process.platform === "linux") {
        return home || (process.getuid() === 0 ? "/root" : user ? "/home/" + user : null);
      }
      return home || null;
    };
  }
});

// node_modules/resolve/lib/caller.js
var require_caller = __commonJS({
  "node_modules/resolve/lib/caller.js"(exports2, module2) {
    module2.exports = function() {
      var origPrepareStackTrace = Error.prepareStackTrace;
      Error.prepareStackTrace = function(_, stack2) {
        return stack2;
      };
      var stack = new Error().stack;
      Error.prepareStackTrace = origPrepareStackTrace;
      return stack[2].getFileName();
    };
  }
});

// node_modules/path-parse/index.js
var require_path_parse = __commonJS({
  "node_modules/path-parse/index.js"(exports2, module2) {
    "use strict";
    var isWindows = process.platform === "win32";
    var splitWindowsRe = /^(((?:[a-zA-Z]:|[\\\/]{2}[^\\\/]+[\\\/]+[^\\\/]+)?[\\\/]?)(?:[^\\\/]*[\\\/])*)((\.{1,2}|[^\\\/]+?|)(\.[^.\/\\]*|))[\\\/]*$/;
    var win322 = {};
    function win32SplitPath(filename) {
      return splitWindowsRe.exec(filename).slice(1);
    }
    win322.parse = function(pathString) {
      if (typeof pathString !== "string") {
        throw new TypeError(
          "Parameter 'pathString' must be a string, not " + typeof pathString
        );
      }
      var allParts = win32SplitPath(pathString);
      if (!allParts || allParts.length !== 5) {
        throw new TypeError("Invalid path '" + pathString + "'");
      }
      return {
        root: allParts[1],
        dir: allParts[0] === allParts[1] ? allParts[0] : allParts[0].slice(0, -1),
        base: allParts[2],
        ext: allParts[4],
        name: allParts[3]
      };
    };
    var splitPathRe = /^((\/?)(?:[^\/]*\/)*)((\.{1,2}|[^\/]+?|)(\.[^.\/]*|))[\/]*$/;
    var posix3 = {};
    function posixSplitPath(filename) {
      return splitPathRe.exec(filename).slice(1);
    }
    posix3.parse = function(pathString) {
      if (typeof pathString !== "string") {
        throw new TypeError(
          "Parameter 'pathString' must be a string, not " + typeof pathString
        );
      }
      var allParts = posixSplitPath(pathString);
      if (!allParts || allParts.length !== 5) {
        throw new TypeError("Invalid path '" + pathString + "'");
      }
      return {
        root: allParts[1],
        dir: allParts[0].slice(0, -1),
        base: allParts[2],
        ext: allParts[4],
        name: allParts[3]
      };
    };
    if (isWindows)
      module2.exports = win322.parse;
    else
      module2.exports = posix3.parse;
    module2.exports.posix = posix3.parse;
    module2.exports.win32 = win322.parse;
  }
});

// node_modules/resolve/lib/node-modules-paths.js
var require_node_modules_paths = __commonJS({
  "node_modules/resolve/lib/node-modules-paths.js"(exports2, module2) {
    var path6 = require("path");
    var parse5 = path6.parse || require_path_parse();
    var getNodeModulesDirs = function getNodeModulesDirs2(absoluteStart, modules) {
      var prefix = "/";
      if (/^([A-Za-z]:)/.test(absoluteStart)) {
        prefix = "";
      } else if (/^\\\\/.test(absoluteStart)) {
        prefix = "\\\\";
      }
      var paths = [absoluteStart];
      var parsed = parse5(absoluteStart);
      while (parsed.dir !== paths[paths.length - 1]) {
        paths.push(parsed.dir);
        parsed = parse5(parsed.dir);
      }
      return paths.reduce(function(dirs, aPath) {
        return dirs.concat(modules.map(function(moduleDir) {
          return path6.resolve(prefix, aPath, moduleDir);
        }));
      }, []);
    };
    module2.exports = function nodeModulesPaths(start, opts, request) {
      var modules = opts && opts.moduleDirectory ? [].concat(opts.moduleDirectory) : ["node_modules"];
      if (opts && typeof opts.paths === "function") {
        return opts.paths(
          request,
          start,
          function() {
            return getNodeModulesDirs(start, modules);
          },
          opts
        );
      }
      var dirs = getNodeModulesDirs(start, modules);
      return opts && opts.paths ? dirs.concat(opts.paths) : dirs;
    };
  }
});

// node_modules/resolve/lib/normalize-options.js
var require_normalize_options = __commonJS({
  "node_modules/resolve/lib/normalize-options.js"(exports2, module2) {
    module2.exports = function(x, opts) {
      return opts || {};
    };
  }
});

// node_modules/function-bind/implementation.js
var require_implementation = __commonJS({
  "node_modules/function-bind/implementation.js"(exports2, module2) {
    "use strict";
    var ERROR_MESSAGE = "Function.prototype.bind called on incompatible ";
    var toStr = Object.prototype.toString;
    var max = Math.max;
    var funcType = "[object Function]";
    var concatty = function concatty2(a, b) {
      var arr = [];
      for (var i = 0; i < a.length; i += 1) {
        arr[i] = a[i];
      }
      for (var j = 0; j < b.length; j += 1) {
        arr[j + a.length] = b[j];
      }
      return arr;
    };
    var slicy = function slicy2(arrLike, offset2) {
      var arr = [];
      for (var i = offset2 || 0, j = 0; i < arrLike.length; i += 1, j += 1) {
        arr[j] = arrLike[i];
      }
      return arr;
    };
    var joiny = function(arr, joiner) {
      var str = "";
      for (var i = 0; i < arr.length; i += 1) {
        str += arr[i];
        if (i + 1 < arr.length) {
          str += joiner;
        }
      }
      return str;
    };
    module2.exports = function bind(that) {
      var target = this;
      if (typeof target !== "function" || toStr.apply(target) !== funcType) {
        throw new TypeError(ERROR_MESSAGE + target);
      }
      var args = slicy(arguments, 1);
      var bound;
      var binder = function() {
        if (this instanceof bound) {
          var result2 = target.apply(
            this,
            concatty(args, arguments)
          );
          if (Object(result2) === result2) {
            return result2;
          }
          return this;
        }
        return target.apply(
          that,
          concatty(args, arguments)
        );
      };
      var boundLength = max(0, target.length - args.length);
      var boundArgs = [];
      for (var i = 0; i < boundLength; i++) {
        boundArgs[i] = "$" + i;
      }
      bound = Function("binder", "return function (" + joiny(boundArgs, ",") + "){ return binder.apply(this,arguments); }")(binder);
      if (target.prototype) {
        var Empty = function Empty2() {
        };
        Empty.prototype = target.prototype;
        bound.prototype = new Empty();
        Empty.prototype = null;
      }
      return bound;
    };
  }
});

// node_modules/function-bind/index.js
var require_function_bind = __commonJS({
  "node_modules/function-bind/index.js"(exports2, module2) {
    "use strict";
    var implementation = require_implementation();
    module2.exports = Function.prototype.bind || implementation;
  }
});

// node_modules/hasown/index.js
var require_hasown = __commonJS({
  "node_modules/hasown/index.js"(exports2, module2) {
    "use strict";
    var call = Function.prototype.call;
    var $hasOwn = Object.prototype.hasOwnProperty;
    var bind = require_function_bind();
    module2.exports = bind.call(call, $hasOwn);
  }
});

// node_modules/is-core-module/core.json
var require_core = __commonJS({
  "node_modules/is-core-module/core.json"(exports2, module2) {
    module2.exports = {
      assert: true,
      "node:assert": [">= 14.18 && < 15", ">= 16"],
      "assert/strict": ">= 15",
      "node:assert/strict": ">= 16",
      async_hooks: ">= 8",
      "node:async_hooks": [">= 14.18 && < 15", ">= 16"],
      buffer_ieee754: ">= 0.5 && < 0.9.7",
      buffer: true,
      "node:buffer": [">= 14.18 && < 15", ">= 16"],
      child_process: true,
      "node:child_process": [">= 14.18 && < 15", ">= 16"],
      cluster: ">= 0.5",
      "node:cluster": [">= 14.18 && < 15", ">= 16"],
      console: true,
      "node:console": [">= 14.18 && < 15", ">= 16"],
      constants: true,
      "node:constants": [">= 14.18 && < 15", ">= 16"],
      crypto: true,
      "node:crypto": [">= 14.18 && < 15", ">= 16"],
      _debug_agent: ">= 1 && < 8",
      _debugger: "< 8",
      dgram: true,
      "node:dgram": [">= 14.18 && < 15", ">= 16"],
      diagnostics_channel: [">= 14.17 && < 15", ">= 15.1"],
      "node:diagnostics_channel": [">= 14.18 && < 15", ">= 16"],
      dns: true,
      "node:dns": [">= 14.18 && < 15", ">= 16"],
      "dns/promises": ">= 15",
      "node:dns/promises": ">= 16",
      domain: ">= 0.7.12",
      "node:domain": [">= 14.18 && < 15", ">= 16"],
      events: true,
      "node:events": [">= 14.18 && < 15", ">= 16"],
      freelist: "< 6",
      fs: true,
      "node:fs": [">= 14.18 && < 15", ">= 16"],
      "fs/promises": [">= 10 && < 10.1", ">= 14"],
      "node:fs/promises": [">= 14.18 && < 15", ">= 16"],
      _http_agent: ">= 0.11.1",
      "node:_http_agent": [">= 14.18 && < 15", ">= 16"],
      _http_client: ">= 0.11.1",
      "node:_http_client": [">= 14.18 && < 15", ">= 16"],
      _http_common: ">= 0.11.1",
      "node:_http_common": [">= 14.18 && < 15", ">= 16"],
      _http_incoming: ">= 0.11.1",
      "node:_http_incoming": [">= 14.18 && < 15", ">= 16"],
      _http_outgoing: ">= 0.11.1",
      "node:_http_outgoing": [">= 14.18 && < 15", ">= 16"],
      _http_server: ">= 0.11.1",
      "node:_http_server": [">= 14.18 && < 15", ">= 16"],
      http: true,
      "node:http": [">= 14.18 && < 15", ">= 16"],
      http2: ">= 8.8",
      "node:http2": [">= 14.18 && < 15", ">= 16"],
      https: true,
      "node:https": [">= 14.18 && < 15", ">= 16"],
      inspector: ">= 8",
      "node:inspector": [">= 14.18 && < 15", ">= 16"],
      "inspector/promises": [">= 19"],
      "node:inspector/promises": [">= 19"],
      _linklist: "< 8",
      module: true,
      "node:module": [">= 14.18 && < 15", ">= 16"],
      net: true,
      "node:net": [">= 14.18 && < 15", ">= 16"],
      "node-inspect/lib/_inspect": ">= 7.6 && < 12",
      "node-inspect/lib/internal/inspect_client": ">= 7.6 && < 12",
      "node-inspect/lib/internal/inspect_repl": ">= 7.6 && < 12",
      os: true,
      "node:os": [">= 14.18 && < 15", ">= 16"],
      path: true,
      "node:path": [">= 14.18 && < 15", ">= 16"],
      "path/posix": ">= 15.3",
      "node:path/posix": ">= 16",
      "path/win32": ">= 15.3",
      "node:path/win32": ">= 16",
      perf_hooks: ">= 8.5",
      "node:perf_hooks": [">= 14.18 && < 15", ">= 16"],
      process: ">= 1",
      "node:process": [">= 14.18 && < 15", ">= 16"],
      punycode: ">= 0.5",
      "node:punycode": [">= 14.18 && < 15", ">= 16"],
      querystring: true,
      "node:querystring": [">= 14.18 && < 15", ">= 16"],
      readline: true,
      "node:readline": [">= 14.18 && < 15", ">= 16"],
      "readline/promises": ">= 17",
      "node:readline/promises": ">= 17",
      repl: true,
      "node:repl": [">= 14.18 && < 15", ">= 16"],
      smalloc: ">= 0.11.5 && < 3",
      _stream_duplex: ">= 0.9.4",
      "node:_stream_duplex": [">= 14.18 && < 15", ">= 16"],
      _stream_transform: ">= 0.9.4",
      "node:_stream_transform": [">= 14.18 && < 15", ">= 16"],
      _stream_wrap: ">= 1.4.1",
      "node:_stream_wrap": [">= 14.18 && < 15", ">= 16"],
      _stream_passthrough: ">= 0.9.4",
      "node:_stream_passthrough": [">= 14.18 && < 15", ">= 16"],
      _stream_readable: ">= 0.9.4",
      "node:_stream_readable": [">= 14.18 && < 15", ">= 16"],
      _stream_writable: ">= 0.9.4",
      "node:_stream_writable": [">= 14.18 && < 15", ">= 16"],
      stream: true,
      "node:stream": [">= 14.18 && < 15", ">= 16"],
      "stream/consumers": ">= 16.7",
      "node:stream/consumers": ">= 16.7",
      "stream/promises": ">= 15",
      "node:stream/promises": ">= 16",
      "stream/web": ">= 16.5",
      "node:stream/web": ">= 16.5",
      string_decoder: true,
      "node:string_decoder": [">= 14.18 && < 15", ">= 16"],
      sys: [">= 0.4 && < 0.7", ">= 0.8"],
      "node:sys": [">= 14.18 && < 15", ">= 16"],
      "test/reporters": ">= 19.9 && < 20.2",
      "node:test/reporters": [">= 18.17 && < 19", ">= 19.9", ">= 20"],
      "node:test": [">= 16.17 && < 17", ">= 18"],
      timers: true,
      "node:timers": [">= 14.18 && < 15", ">= 16"],
      "timers/promises": ">= 15",
      "node:timers/promises": ">= 16",
      _tls_common: ">= 0.11.13",
      "node:_tls_common": [">= 14.18 && < 15", ">= 16"],
      _tls_legacy: ">= 0.11.3 && < 10",
      _tls_wrap: ">= 0.11.3",
      "node:_tls_wrap": [">= 14.18 && < 15", ">= 16"],
      tls: true,
      "node:tls": [">= 14.18 && < 15", ">= 16"],
      trace_events: ">= 10",
      "node:trace_events": [">= 14.18 && < 15", ">= 16"],
      tty: true,
      "node:tty": [">= 14.18 && < 15", ">= 16"],
      url: true,
      "node:url": [">= 14.18 && < 15", ">= 16"],
      util: true,
      "node:util": [">= 14.18 && < 15", ">= 16"],
      "util/types": ">= 15.3",
      "node:util/types": ">= 16",
      "v8/tools/arguments": ">= 10 && < 12",
      "v8/tools/codemap": [">= 4.4 && < 5", ">= 5.2 && < 12"],
      "v8/tools/consarray": [">= 4.4 && < 5", ">= 5.2 && < 12"],
      "v8/tools/csvparser": [">= 4.4 && < 5", ">= 5.2 && < 12"],
      "v8/tools/logreader": [">= 4.4 && < 5", ">= 5.2 && < 12"],
      "v8/tools/profile_view": [">= 4.4 && < 5", ">= 5.2 && < 12"],
      "v8/tools/splaytree": [">= 4.4 && < 5", ">= 5.2 && < 12"],
      v8: ">= 1",
      "node:v8": [">= 14.18 && < 15", ">= 16"],
      vm: true,
      "node:vm": [">= 14.18 && < 15", ">= 16"],
      wasi: [">= 13.4 && < 13.5", ">= 18.17 && < 19", ">= 20"],
      "node:wasi": [">= 18.17 && < 19", ">= 20"],
      worker_threads: ">= 11.7",
      "node:worker_threads": [">= 14.18 && < 15", ">= 16"],
      zlib: ">= 0.5",
      "node:zlib": [">= 14.18 && < 15", ">= 16"]
    };
  }
});

// node_modules/is-core-module/index.js
var require_is_core_module = __commonJS({
  "node_modules/is-core-module/index.js"(exports2, module2) {
    "use strict";
    var hasOwn = require_hasown();
    function specifierIncluded(current2, specifier) {
      var nodeParts = current2.split(".");
      var parts = specifier.split(" ");
      var op = parts.length > 1 ? parts[0] : "=";
      var versionParts = (parts.length > 1 ? parts[1] : parts[0]).split(".");
      for (var i = 0; i < 3; ++i) {
        var cur = parseInt(nodeParts[i] || 0, 10);
        var ver = parseInt(versionParts[i] || 0, 10);
        if (cur === ver) {
          continue;
        }
        if (op === "<") {
          return cur < ver;
        }
        if (op === ">=") {
          return cur >= ver;
        }
        return false;
      }
      return op === ">=";
    }
    function matchesRange(current2, range) {
      var specifiers = range.split(/ ?&& ?/);
      if (specifiers.length === 0) {
        return false;
      }
      for (var i = 0; i < specifiers.length; ++i) {
        if (!specifierIncluded(current2, specifiers[i])) {
          return false;
        }
      }
      return true;
    }
    function versionIncluded(nodeVersion, specifierValue) {
      if (typeof specifierValue === "boolean") {
        return specifierValue;
      }
      var current2 = typeof nodeVersion === "undefined" ? process.versions && process.versions.node : nodeVersion;
      if (typeof current2 !== "string") {
        throw new TypeError(typeof nodeVersion === "undefined" ? "Unable to determine current node version" : "If provided, a valid node version is required");
      }
      if (specifierValue && typeof specifierValue === "object") {
        for (var i = 0; i < specifierValue.length; ++i) {
          if (matchesRange(current2, specifierValue[i])) {
            return true;
          }
        }
        return false;
      }
      return matchesRange(current2, specifierValue);
    }
    var data2 = require_core();
    module2.exports = function isCore(x, nodeVersion) {
      return hasOwn(data2, x) && versionIncluded(nodeVersion, data2[x]);
    };
  }
});

// node_modules/resolve/lib/async.js
var require_async = __commonJS({
  "node_modules/resolve/lib/async.js"(exports2, module2) {
    var fs3 = require("fs");
    var getHomedir = require_homedir();
    var path6 = require("path");
    var caller = require_caller();
    var nodeModulesPaths = require_node_modules_paths();
    var normalizeOptions = require_normalize_options();
    var isCore = require_is_core_module();
    var realpathFS = process.platform !== "win32" && fs3.realpath && typeof fs3.realpath.native === "function" ? fs3.realpath.native : fs3.realpath;
    var homedir2 = getHomedir();
    var defaultPaths = function() {
      return [
        path6.join(homedir2, ".node_modules"),
        path6.join(homedir2, ".node_libraries")
      ];
    };
    var defaultIsFile = function isFile(file, cb) {
      fs3.stat(file, function(err2, stat2) {
        if (!err2) {
          return cb(null, stat2.isFile() || stat2.isFIFO());
        }
        if (err2.code === "ENOENT" || err2.code === "ENOTDIR") return cb(null, false);
        return cb(err2);
      });
    };
    var defaultIsDir = function isDirectory(dir, cb) {
      fs3.stat(dir, function(err2, stat2) {
        if (!err2) {
          return cb(null, stat2.isDirectory());
        }
        if (err2.code === "ENOENT" || err2.code === "ENOTDIR") return cb(null, false);
        return cb(err2);
      });
    };
    var defaultRealpath = function realpath2(x, cb) {
      realpathFS(x, function(realpathErr, realPath) {
        if (realpathErr && realpathErr.code !== "ENOENT") cb(realpathErr);
        else cb(null, realpathErr ? x : realPath);
      });
    };
    var maybeRealpath = function maybeRealpath2(realpath2, x, opts, cb) {
      if (opts && opts.preserveSymlinks === false) {
        realpath2(x, cb);
      } else {
        cb(null, x);
      }
    };
    var defaultReadPackage = function defaultReadPackage2(readFile3, pkgfile, cb) {
      readFile3(pkgfile, function(readFileErr, body) {
        if (readFileErr) cb(readFileErr);
        else {
          try {
            var pkg = JSON.parse(body);
            cb(null, pkg);
          } catch (jsonErr) {
            cb(null);
          }
        }
      });
    };
    var getPackageCandidates = function getPackageCandidates2(x, start, opts) {
      var dirs = nodeModulesPaths(start, opts, x);
      for (var i = 0; i < dirs.length; i++) {
        dirs[i] = path6.join(dirs[i], x);
      }
      return dirs;
    };
    module2.exports = function resolve9(x, options, callback) {
      var cb = callback;
      var opts = options;
      if (typeof options === "function") {
        cb = opts;
        opts = {};
      }
      if (typeof x !== "string") {
        var err2 = new TypeError("Path must be a string.");
        return process.nextTick(function() {
          cb(err2);
        });
      }
      opts = normalizeOptions(x, opts);
      var isFile = opts.isFile || defaultIsFile;
      var isDirectory = opts.isDirectory || defaultIsDir;
      var readFile3 = opts.readFile || fs3.readFile;
      var realpath2 = opts.realpath || defaultRealpath;
      var readPackage = opts.readPackage || defaultReadPackage;
      if (opts.readFile && opts.readPackage) {
        var conflictErr = new TypeError("`readFile` and `readPackage` are mutually exclusive.");
        return process.nextTick(function() {
          cb(conflictErr);
        });
      }
      var packageIterator = opts.packageIterator;
      var extensions = opts.extensions || [".js"];
      var includeCoreModules = opts.includeCoreModules !== false;
      var basedir = opts.basedir || path6.dirname(caller());
      var parent = opts.filename || basedir;
      opts.paths = opts.paths || defaultPaths();
      var absoluteStart = path6.resolve(basedir);
      maybeRealpath(
        realpath2,
        absoluteStart,
        opts,
        function(err3, realStart) {
          if (err3) cb(err3);
          else init(realStart);
        }
      );
      var res;
      function init(basedir2) {
        if (/^(?:\.\.?(?:\/|$)|\/|([A-Za-z]:)?[/\\])/.test(x)) {
          res = path6.resolve(basedir2, x);
          if (x === "." || x === ".." || x.slice(-1) === "/") res += "/";
          if (/\/$/.test(x) && res === basedir2) {
            loadAsDirectory(res, opts.package, onfile);
          } else loadAsFile(res, opts.package, onfile);
        } else if (includeCoreModules && isCore(x)) {
          return cb(null, x);
        } else loadNodeModules(x, basedir2, function(err3, n3, pkg) {
          if (err3) cb(err3);
          else if (n3) {
            return maybeRealpath(realpath2, n3, opts, function(err4, realN) {
              if (err4) {
                cb(err4);
              } else {
                cb(null, realN, pkg);
              }
            });
          } else {
            var moduleError = new Error("Cannot find module '" + x + "' from '" + parent + "'");
            moduleError.code = "MODULE_NOT_FOUND";
            cb(moduleError);
          }
        });
      }
      function onfile(err3, m, pkg) {
        if (err3) cb(err3);
        else if (m) cb(null, m, pkg);
        else loadAsDirectory(res, function(err4, d, pkg2) {
          if (err4) cb(err4);
          else if (d) {
            maybeRealpath(realpath2, d, opts, function(err5, realD) {
              if (err5) {
                cb(err5);
              } else {
                cb(null, realD, pkg2);
              }
            });
          } else {
            var moduleError = new Error("Cannot find module '" + x + "' from '" + parent + "'");
            moduleError.code = "MODULE_NOT_FOUND";
            cb(moduleError);
          }
        });
      }
      function loadAsFile(x2, thePackage, callback2) {
        var loadAsFilePackage = thePackage;
        var cb2 = callback2;
        if (typeof loadAsFilePackage === "function") {
          cb2 = loadAsFilePackage;
          loadAsFilePackage = void 0;
        }
        var exts = [""].concat(extensions);
        load(exts, x2, loadAsFilePackage);
        function load(exts2, x3, loadPackage) {
          if (exts2.length === 0) return cb2(null, void 0, loadPackage);
          var file = x3 + exts2[0];
          var pkg = loadPackage;
          if (pkg) onpkg(null, pkg);
          else loadpkg(path6.dirname(file), onpkg);
          function onpkg(err3, pkg_, dir) {
            pkg = pkg_;
            if (err3) return cb2(err3);
            if (dir && pkg && opts.pathFilter) {
              var rfile = path6.relative(dir, file);
              var rel = rfile.slice(0, rfile.length - exts2[0].length);
              var r = opts.pathFilter(pkg, x3, rel);
              if (r) return load(
                [""].concat(extensions.slice()),
                path6.resolve(dir, r),
                pkg
              );
            }
            isFile(file, onex);
          }
          function onex(err3, ex) {
            if (err3) return cb2(err3);
            if (ex) return cb2(null, file, pkg);
            load(exts2.slice(1), x3, pkg);
          }
        }
      }
      function loadpkg(dir, cb2) {
        if (dir === "" || dir === "/") return cb2(null);
        if (process.platform === "win32" && /^\w:[/\\]*$/.test(dir)) {
          return cb2(null);
        }
        if (/[/\\]node_modules[/\\]*$/.test(dir)) return cb2(null);
        maybeRealpath(realpath2, dir, opts, function(unwrapErr2, pkgdir) {
          if (unwrapErr2) return loadpkg(path6.dirname(dir), cb2);
          var pkgfile = path6.join(pkgdir, "package.json");
          isFile(pkgfile, function(err3, ex) {
            if (!ex) return loadpkg(path6.dirname(dir), cb2);
            readPackage(readFile3, pkgfile, function(err4, pkgParam) {
              if (err4) cb2(err4);
              var pkg = pkgParam;
              if (pkg && opts.packageFilter) {
                pkg = opts.packageFilter(pkg, pkgfile);
              }
              cb2(null, pkg, dir);
            });
          });
        });
      }
      function loadAsDirectory(x2, loadAsDirectoryPackage, callback2) {
        var cb2 = callback2;
        var fpkg = loadAsDirectoryPackage;
        if (typeof fpkg === "function") {
          cb2 = fpkg;
          fpkg = opts.package;
        }
        maybeRealpath(realpath2, x2, opts, function(unwrapErr2, pkgdir) {
          if (unwrapErr2) return cb2(unwrapErr2);
          var pkgfile = path6.join(pkgdir, "package.json");
          isFile(pkgfile, function(err3, ex) {
            if (err3) return cb2(err3);
            if (!ex) return loadAsFile(path6.join(x2, "index"), fpkg, cb2);
            readPackage(readFile3, pkgfile, function(err4, pkgParam) {
              if (err4) return cb2(err4);
              var pkg = pkgParam;
              if (pkg && opts.packageFilter) {
                pkg = opts.packageFilter(pkg, pkgfile);
              }
              if (pkg && pkg.main) {
                if (typeof pkg.main !== "string") {
                  var mainError = new TypeError("package \u201C" + pkg.name + "\u201D `main` must be a string");
                  mainError.code = "INVALID_PACKAGE_MAIN";
                  return cb2(mainError);
                }
                if (pkg.main === "." || pkg.main === "./") {
                  pkg.main = "index";
                }
                loadAsFile(path6.resolve(x2, pkg.main), pkg, function(err5, m, pkg2) {
                  if (err5) return cb2(err5);
                  if (m) return cb2(null, m, pkg2);
                  if (!pkg2) return loadAsFile(path6.join(x2, "index"), pkg2, cb2);
                  var dir = path6.resolve(x2, pkg2.main);
                  loadAsDirectory(dir, pkg2, function(err6, n3, pkg3) {
                    if (err6) return cb2(err6);
                    if (n3) return cb2(null, n3, pkg3);
                    loadAsFile(path6.join(x2, "index"), pkg3, cb2);
                  });
                });
                return;
              }
              loadAsFile(path6.join(x2, "/index"), pkg, cb2);
            });
          });
        });
      }
      function processDirs(cb2, dirs) {
        if (dirs.length === 0) return cb2(null, void 0);
        var dir = dirs[0];
        isDirectory(path6.dirname(dir), isdir);
        function isdir(err3, isdir2) {
          if (err3) return cb2(err3);
          if (!isdir2) return processDirs(cb2, dirs.slice(1));
          loadAsFile(dir, opts.package, onfile2);
        }
        function onfile2(err3, m, pkg) {
          if (err3) return cb2(err3);
          if (m) return cb2(null, m, pkg);
          loadAsDirectory(dir, opts.package, ondir);
        }
        function ondir(err3, n3, pkg) {
          if (err3) return cb2(err3);
          if (n3) return cb2(null, n3, pkg);
          processDirs(cb2, dirs.slice(1));
        }
      }
      function loadNodeModules(x2, start, cb2) {
        var thunk = function() {
          return getPackageCandidates(x2, start, opts);
        };
        processDirs(
          cb2,
          packageIterator ? packageIterator(x2, start, thunk, opts) : thunk()
        );
      }
    };
  }
});

// node_modules/resolve/lib/core.json
var require_core2 = __commonJS({
  "node_modules/resolve/lib/core.json"(exports2, module2) {
    module2.exports = {
      assert: true,
      "node:assert": [">= 14.18 && < 15", ">= 16"],
      "assert/strict": ">= 15",
      "node:assert/strict": ">= 16",
      async_hooks: ">= 8",
      "node:async_hooks": [">= 14.18 && < 15", ">= 16"],
      buffer_ieee754: ">= 0.5 && < 0.9.7",
      buffer: true,
      "node:buffer": [">= 14.18 && < 15", ">= 16"],
      child_process: true,
      "node:child_process": [">= 14.18 && < 15", ">= 16"],
      cluster: ">= 0.5",
      "node:cluster": [">= 14.18 && < 15", ">= 16"],
      console: true,
      "node:console": [">= 14.18 && < 15", ">= 16"],
      constants: true,
      "node:constants": [">= 14.18 && < 15", ">= 16"],
      crypto: true,
      "node:crypto": [">= 14.18 && < 15", ">= 16"],
      _debug_agent: ">= 1 && < 8",
      _debugger: "< 8",
      dgram: true,
      "node:dgram": [">= 14.18 && < 15", ">= 16"],
      diagnostics_channel: [">= 14.17 && < 15", ">= 15.1"],
      "node:diagnostics_channel": [">= 14.18 && < 15", ">= 16"],
      dns: true,
      "node:dns": [">= 14.18 && < 15", ">= 16"],
      "dns/promises": ">= 15",
      "node:dns/promises": ">= 16",
      domain: ">= 0.7.12",
      "node:domain": [">= 14.18 && < 15", ">= 16"],
      events: true,
      "node:events": [">= 14.18 && < 15", ">= 16"],
      freelist: "< 6",
      fs: true,
      "node:fs": [">= 14.18 && < 15", ">= 16"],
      "fs/promises": [">= 10 && < 10.1", ">= 14"],
      "node:fs/promises": [">= 14.18 && < 15", ">= 16"],
      _http_agent: ">= 0.11.1",
      "node:_http_agent": [">= 14.18 && < 15", ">= 16"],
      _http_client: ">= 0.11.1",
      "node:_http_client": [">= 14.18 && < 15", ">= 16"],
      _http_common: ">= 0.11.1",
      "node:_http_common": [">= 14.18 && < 15", ">= 16"],
      _http_incoming: ">= 0.11.1",
      "node:_http_incoming": [">= 14.18 && < 15", ">= 16"],
      _http_outgoing: ">= 0.11.1",
      "node:_http_outgoing": [">= 14.18 && < 15", ">= 16"],
      _http_server: ">= 0.11.1",
      "node:_http_server": [">= 14.18 && < 15", ">= 16"],
      http: true,
      "node:http": [">= 14.18 && < 15", ">= 16"],
      http2: ">= 8.8",
      "node:http2": [">= 14.18 && < 15", ">= 16"],
      https: true,
      "node:https": [">= 14.18 && < 15", ">= 16"],
      inspector: ">= 8",
      "node:inspector": [">= 14.18 && < 15", ">= 16"],
      "inspector/promises": [">= 19"],
      "node:inspector/promises": [">= 19"],
      _linklist: "< 8",
      module: true,
      "node:module": [">= 14.18 && < 15", ">= 16"],
      net: true,
      "node:net": [">= 14.18 && < 15", ">= 16"],
      "node-inspect/lib/_inspect": ">= 7.6 && < 12",
      "node-inspect/lib/internal/inspect_client": ">= 7.6 && < 12",
      "node-inspect/lib/internal/inspect_repl": ">= 7.6 && < 12",
      os: true,
      "node:os": [">= 14.18 && < 15", ">= 16"],
      path: true,
      "node:path": [">= 14.18 && < 15", ">= 16"],
      "path/posix": ">= 15.3",
      "node:path/posix": ">= 16",
      "path/win32": ">= 15.3",
      "node:path/win32": ">= 16",
      perf_hooks: ">= 8.5",
      "node:perf_hooks": [">= 14.18 && < 15", ">= 16"],
      process: ">= 1",
      "node:process": [">= 14.18 && < 15", ">= 16"],
      punycode: ">= 0.5",
      "node:punycode": [">= 14.18 && < 15", ">= 16"],
      querystring: true,
      "node:querystring": [">= 14.18 && < 15", ">= 16"],
      readline: true,
      "node:readline": [">= 14.18 && < 15", ">= 16"],
      "readline/promises": ">= 17",
      "node:readline/promises": ">= 17",
      repl: true,
      "node:repl": [">= 14.18 && < 15", ">= 16"],
      smalloc: ">= 0.11.5 && < 3",
      _stream_duplex: ">= 0.9.4",
      "node:_stream_duplex": [">= 14.18 && < 15", ">= 16"],
      _stream_transform: ">= 0.9.4",
      "node:_stream_transform": [">= 14.18 && < 15", ">= 16"],
      _stream_wrap: ">= 1.4.1",
      "node:_stream_wrap": [">= 14.18 && < 15", ">= 16"],
      _stream_passthrough: ">= 0.9.4",
      "node:_stream_passthrough": [">= 14.18 && < 15", ">= 16"],
      _stream_readable: ">= 0.9.4",
      "node:_stream_readable": [">= 14.18 && < 15", ">= 16"],
      _stream_writable: ">= 0.9.4",
      "node:_stream_writable": [">= 14.18 && < 15", ">= 16"],
      stream: true,
      "node:stream": [">= 14.18 && < 15", ">= 16"],
      "stream/consumers": ">= 16.7",
      "node:stream/consumers": ">= 16.7",
      "stream/promises": ">= 15",
      "node:stream/promises": ">= 16",
      "stream/web": ">= 16.5",
      "node:stream/web": ">= 16.5",
      string_decoder: true,
      "node:string_decoder": [">= 14.18 && < 15", ">= 16"],
      sys: [">= 0.4 && < 0.7", ">= 0.8"],
      "node:sys": [">= 14.18 && < 15", ">= 16"],
      "test/reporters": ">= 19.9 && < 20.2",
      "node:test/reporters": [">= 18.17 && < 19", ">= 19.9", ">= 20"],
      "node:test": [">= 16.17 && < 17", ">= 18"],
      timers: true,
      "node:timers": [">= 14.18 && < 15", ">= 16"],
      "timers/promises": ">= 15",
      "node:timers/promises": ">= 16",
      _tls_common: ">= 0.11.13",
      "node:_tls_common": [">= 14.18 && < 15", ">= 16"],
      _tls_legacy: ">= 0.11.3 && < 10",
      _tls_wrap: ">= 0.11.3",
      "node:_tls_wrap": [">= 14.18 && < 15", ">= 16"],
      tls: true,
      "node:tls": [">= 14.18 && < 15", ">= 16"],
      trace_events: ">= 10",
      "node:trace_events": [">= 14.18 && < 15", ">= 16"],
      tty: true,
      "node:tty": [">= 14.18 && < 15", ">= 16"],
      url: true,
      "node:url": [">= 14.18 && < 15", ">= 16"],
      util: true,
      "node:util": [">= 14.18 && < 15", ">= 16"],
      "util/types": ">= 15.3",
      "node:util/types": ">= 16",
      "v8/tools/arguments": ">= 10 && < 12",
      "v8/tools/codemap": [">= 4.4 && < 5", ">= 5.2 && < 12"],
      "v8/tools/consarray": [">= 4.4 && < 5", ">= 5.2 && < 12"],
      "v8/tools/csvparser": [">= 4.4 && < 5", ">= 5.2 && < 12"],
      "v8/tools/logreader": [">= 4.4 && < 5", ">= 5.2 && < 12"],
      "v8/tools/profile_view": [">= 4.4 && < 5", ">= 5.2 && < 12"],
      "v8/tools/splaytree": [">= 4.4 && < 5", ">= 5.2 && < 12"],
      v8: ">= 1",
      "node:v8": [">= 14.18 && < 15", ">= 16"],
      vm: true,
      "node:vm": [">= 14.18 && < 15", ">= 16"],
      wasi: [">= 13.4 && < 13.5", ">= 18.17 && < 19", ">= 20"],
      "node:wasi": [">= 18.17 && < 19", ">= 20"],
      worker_threads: ">= 11.7",
      "node:worker_threads": [">= 14.18 && < 15", ">= 16"],
      zlib: ">= 0.5",
      "node:zlib": [">= 14.18 && < 15", ">= 16"]
    };
  }
});

// node_modules/resolve/lib/core.js
var require_core3 = __commonJS({
  "node_modules/resolve/lib/core.js"(exports2, module2) {
    "use strict";
    var isCoreModule = require_is_core_module();
    var data2 = require_core2();
    var core = {};
    for (mod in data2) {
      if (Object.prototype.hasOwnProperty.call(data2, mod)) {
        core[mod] = isCoreModule(mod);
      }
    }
    var mod;
    module2.exports = core;
  }
});

// node_modules/resolve/lib/is-core.js
var require_is_core = __commonJS({
  "node_modules/resolve/lib/is-core.js"(exports2, module2) {
    var isCoreModule = require_is_core_module();
    module2.exports = function isCore(x) {
      return isCoreModule(x);
    };
  }
});

// node_modules/resolve/lib/sync.js
var require_sync = __commonJS({
  "node_modules/resolve/lib/sync.js"(exports2, module2) {
    var isCore = require_is_core_module();
    var fs3 = require("fs");
    var path6 = require("path");
    var getHomedir = require_homedir();
    var caller = require_caller();
    var nodeModulesPaths = require_node_modules_paths();
    var normalizeOptions = require_normalize_options();
    var realpathFS = process.platform !== "win32" && fs3.realpathSync && typeof fs3.realpathSync.native === "function" ? fs3.realpathSync.native : fs3.realpathSync;
    var homedir2 = getHomedir();
    var defaultPaths = function() {
      return [
        path6.join(homedir2, ".node_modules"),
        path6.join(homedir2, ".node_libraries")
      ];
    };
    var defaultIsFile = function isFile(file) {
      try {
        var stat2 = fs3.statSync(file, { throwIfNoEntry: false });
      } catch (e) {
        if (e && (e.code === "ENOENT" || e.code === "ENOTDIR")) return false;
        throw e;
      }
      return !!stat2 && (stat2.isFile() || stat2.isFIFO());
    };
    var defaultIsDir = function isDirectory(dir) {
      try {
        var stat2 = fs3.statSync(dir, { throwIfNoEntry: false });
      } catch (e) {
        if (e && (e.code === "ENOENT" || e.code === "ENOTDIR")) return false;
        throw e;
      }
      return !!stat2 && stat2.isDirectory();
    };
    var defaultRealpathSync = function realpathSync3(x) {
      try {
        return realpathFS(x);
      } catch (realpathErr) {
        if (realpathErr.code !== "ENOENT") {
          throw realpathErr;
        }
      }
      return x;
    };
    var maybeRealpathSync = function maybeRealpathSync2(realpathSync3, x, opts) {
      if (opts && opts.preserveSymlinks === false) {
        return realpathSync3(x);
      }
      return x;
    };
    var defaultReadPackageSync = function defaultReadPackageSync2(readFileSync, pkgfile) {
      var body = readFileSync(pkgfile);
      try {
        var pkg = JSON.parse(body);
        return pkg;
      } catch (jsonErr) {
      }
    };
    var getPackageCandidates = function getPackageCandidates2(x, start, opts) {
      var dirs = nodeModulesPaths(start, opts, x);
      for (var i = 0; i < dirs.length; i++) {
        dirs[i] = path6.join(dirs[i], x);
      }
      return dirs;
    };
    module2.exports = function resolveSync(x, options) {
      if (typeof x !== "string") {
        throw new TypeError("Path must be a string.");
      }
      var opts = normalizeOptions(x, options);
      var isFile = opts.isFile || defaultIsFile;
      var readFileSync = opts.readFileSync || fs3.readFileSync;
      var isDirectory = opts.isDirectory || defaultIsDir;
      var realpathSync3 = opts.realpathSync || defaultRealpathSync;
      var readPackageSync = opts.readPackageSync || defaultReadPackageSync;
      if (opts.readFileSync && opts.readPackageSync) {
        throw new TypeError("`readFileSync` and `readPackageSync` are mutually exclusive.");
      }
      var packageIterator = opts.packageIterator;
      var extensions = opts.extensions || [".js"];
      var includeCoreModules = opts.includeCoreModules !== false;
      var basedir = opts.basedir || path6.dirname(caller());
      var parent = opts.filename || basedir;
      opts.paths = opts.paths || defaultPaths();
      var absoluteStart = maybeRealpathSync(realpathSync3, path6.resolve(basedir), opts);
      if (/^(?:\.\.?(?:\/|$)|\/|([A-Za-z]:)?[/\\])/.test(x)) {
        var res = path6.resolve(absoluteStart, x);
        if (x === "." || x === ".." || x.slice(-1) === "/") res += "/";
        var m = loadAsFileSync(res) || loadAsDirectorySync(res);
        if (m) return maybeRealpathSync(realpathSync3, m, opts);
      } else if (includeCoreModules && isCore(x)) {
        return x;
      } else {
        var n3 = loadNodeModulesSync(x, absoluteStart);
        if (n3) return maybeRealpathSync(realpathSync3, n3, opts);
      }
      var err2 = new Error("Cannot find module '" + x + "' from '" + parent + "'");
      err2.code = "MODULE_NOT_FOUND";
      throw err2;
      function loadAsFileSync(x2) {
        var pkg = loadpkg(path6.dirname(x2));
        if (pkg && pkg.dir && pkg.pkg && opts.pathFilter) {
          var rfile = path6.relative(pkg.dir, x2);
          var r = opts.pathFilter(pkg.pkg, x2, rfile);
          if (r) {
            x2 = path6.resolve(pkg.dir, r);
          }
        }
        if (isFile(x2)) {
          return x2;
        }
        for (var i = 0; i < extensions.length; i++) {
          var file = x2 + extensions[i];
          if (isFile(file)) {
            return file;
          }
        }
      }
      function loadpkg(dir) {
        if (dir === "" || dir === "/") return;
        if (process.platform === "win32" && /^\w:[/\\]*$/.test(dir)) {
          return;
        }
        if (/[/\\]node_modules[/\\]*$/.test(dir)) return;
        var pkgfile = path6.join(maybeRealpathSync(realpathSync3, dir, opts), "package.json");
        if (!isFile(pkgfile)) {
          return loadpkg(path6.dirname(dir));
        }
        var pkg = readPackageSync(readFileSync, pkgfile);
        if (pkg && opts.packageFilter) {
          pkg = opts.packageFilter(
            pkg,
            /*pkgfile,*/
            dir
          );
        }
        return { pkg, dir };
      }
      function loadAsDirectorySync(x2) {
        var pkgfile = path6.join(maybeRealpathSync(realpathSync3, x2, opts), "/package.json");
        if (isFile(pkgfile)) {
          try {
            var pkg = readPackageSync(readFileSync, pkgfile);
          } catch (e) {
          }
          if (pkg && opts.packageFilter) {
            pkg = opts.packageFilter(
              pkg,
              /*pkgfile,*/
              x2
            );
          }
          if (pkg && pkg.main) {
            if (typeof pkg.main !== "string") {
              var mainError = new TypeError("package \u201C" + pkg.name + "\u201D `main` must be a string");
              mainError.code = "INVALID_PACKAGE_MAIN";
              throw mainError;
            }
            if (pkg.main === "." || pkg.main === "./") {
              pkg.main = "index";
            }
            try {
              var m2 = loadAsFileSync(path6.resolve(x2, pkg.main));
              if (m2) return m2;
              var n4 = loadAsDirectorySync(path6.resolve(x2, pkg.main));
              if (n4) return n4;
            } catch (e) {
            }
          }
        }
        return loadAsFileSync(path6.join(x2, "/index"));
      }
      function loadNodeModulesSync(x2, start) {
        var thunk = function() {
          return getPackageCandidates(x2, start, opts);
        };
        var dirs = packageIterator ? packageIterator(x2, start, thunk, opts) : thunk();
        for (var i = 0; i < dirs.length; i++) {
          var dir = dirs[i];
          if (isDirectory(path6.dirname(dir))) {
            var m2 = loadAsFileSync(dir);
            if (m2) return m2;
            var n4 = loadAsDirectorySync(dir);
            if (n4) return n4;
          }
        }
      }
    };
  }
});

// node_modules/resolve/index.js
var require_resolve = __commonJS({
  "node_modules/resolve/index.js"(exports2, module2) {
    var async = require_async();
    async.core = require_core3();
    async.isCore = require_is_core();
    async.sync = require_sync();
    module2.exports = async;
  }
});

// node_modules/@rollup/plugin-commonjs/dist/index.js
var require_dist = __commonJS({
  "node_modules/@rollup/plugin-commonjs/dist/index.js"(exports2, module2) {
    "use strict";
    var path6 = require("path");
    var pluginutils = require_cjs();
    var getCommonDir = require_commondir();
    var fs3 = require("fs");
    var glob = require("../sys/node/glob.js");
    var estreeWalker = require_estree_walker();
    var MagicString4 = require_magic_string_cjs();
    var isReference = require_is_reference();
    var resolve9 = require_resolve();
    function _interopDefaultLegacy(e) {
      return e && typeof e === "object" && "default" in e ? e : { "default": e };
    }
    var getCommonDir__default = /* @__PURE__ */ _interopDefaultLegacy(getCommonDir);
    var glob__default = /* @__PURE__ */ _interopDefaultLegacy(glob);
    var MagicString__default = /* @__PURE__ */ _interopDefaultLegacy(MagicString4);
    var isReference__default = /* @__PURE__ */ _interopDefaultLegacy(isReference);
    var peerDependencies = {
      rollup: "^2.38.3"
    };
    function tryParse(parse5, code, id) {
      try {
        return parse5(code, { allowReturnOutsideFunction: true });
      } catch (err2) {
        err2.message += ` in ${id}`;
        throw err2;
      }
    }
    var firstpassGlobal = /\b(?:require|module|exports|global)\b/;
    var firstpassNoGlobal = /\b(?:require|module|exports)\b/;
    function hasCjsKeywords(code, ignoreGlobal) {
      const firstpass = ignoreGlobal ? firstpassNoGlobal : firstpassGlobal;
      return firstpass.test(code);
    }
    function analyzeTopLevelStatements(parse5, code, id) {
      const ast = tryParse(parse5, code, id);
      let isEsModule = false;
      let hasDefaultExport = false;
      let hasNamedExports = false;
      for (const node of ast.body) {
        switch (node.type) {
          case "ExportDefaultDeclaration":
            isEsModule = true;
            hasDefaultExport = true;
            break;
          case "ExportNamedDeclaration":
            isEsModule = true;
            if (node.declaration) {
              hasNamedExports = true;
            } else {
              for (const specifier of node.specifiers) {
                if (specifier.exported.name === "default") {
                  hasDefaultExport = true;
                } else {
                  hasNamedExports = true;
                }
              }
            }
            break;
          case "ExportAllDeclaration":
            isEsModule = true;
            if (node.exported && node.exported.name === "default") {
              hasDefaultExport = true;
            } else {
              hasNamedExports = true;
            }
            break;
          case "ImportDeclaration":
            isEsModule = true;
            break;
        }
      }
      return { isEsModule, hasDefaultExport, hasNamedExports, ast };
    }
    var isWrappedId = (id, suffix) => id.endsWith(suffix);
    var wrapId = (id, suffix) => `\0${id}${suffix}`;
    var unwrapId = (wrappedId, suffix) => wrappedId.slice(1, -suffix.length);
    var PROXY_SUFFIX = "?commonjs-proxy";
    var REQUIRE_SUFFIX = "?commonjs-require";
    var EXTERNAL_SUFFIX = "?commonjs-external";
    var EXPORTS_SUFFIX = "?commonjs-exports";
    var MODULE_SUFFIX = "?commonjs-module";
    var DYNAMIC_REGISTER_SUFFIX = "?commonjs-dynamic-register";
    var DYNAMIC_JSON_PREFIX = "\0commonjs-dynamic-json:";
    var DYNAMIC_PACKAGES_ID = "\0commonjs-dynamic-packages";
    var HELPERS_ID = "\0commonjsHelpers.js";
    var HELPERS = `
export var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

export function getDefaultExportFromCjs (x) {
	return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
}

export function getDefaultExportFromNamespaceIfPresent (n) {
	return n && Object.prototype.hasOwnProperty.call(n, 'default') ? n['default'] : n;
}

export function getDefaultExportFromNamespaceIfNotNamed (n) {
	return n && Object.prototype.hasOwnProperty.call(n, 'default') && Object.keys(n).length === 1 ? n['default'] : n;
}

export function getAugmentedNamespace(n) {
	if (n.__esModule) return n;
	var a = Object.defineProperty({}, '__esModule', {value: true});
	Object.keys(n).forEach(function (k) {
		var d = Object.getOwnPropertyDescriptor(n, k);
		Object.defineProperty(a, k, d.get ? d : {
			enumerable: true,
			get: function () {
				return n[k];
			}
		});
	});
	return a;
}
`;
    var FAILED_REQUIRE_ERROR = `throw new Error('Could not dynamically require "' + path + '". Please configure the dynamicRequireTargets or/and ignoreDynamicRequires option of @rollup/plugin-commonjs appropriately for this require call to work.');`;
    var HELPER_NON_DYNAMIC = `
export function commonjsRequire (path) {
	${FAILED_REQUIRE_ERROR}
}
`;
    var getDynamicHelpers = (ignoreDynamicRequires) => `
export function createModule(modulePath) {
	return {
		path: modulePath,
		exports: {},
		require: function (path, base) {
			return commonjsRequire(path, base == null ? modulePath : base);
		}
	};
}

export function commonjsRegister (path, loader) {
	DYNAMIC_REQUIRE_LOADERS[path] = loader;
}

export function commonjsRegisterOrShort (path, to) {
	var resolvedPath = commonjsResolveImpl(path, null, true);
	if (resolvedPath !== null && DYNAMIC_REQUIRE_CACHE[resolvedPath]) {
	  DYNAMIC_REQUIRE_CACHE[path] = DYNAMIC_REQUIRE_CACHE[resolvedPath];
	} else {
	  DYNAMIC_REQUIRE_SHORTS[path] = to;
	}
}

var DYNAMIC_REQUIRE_LOADERS = Object.create(null);
var DYNAMIC_REQUIRE_CACHE = Object.create(null);
var DYNAMIC_REQUIRE_SHORTS = Object.create(null);
var DEFAULT_PARENT_MODULE = {
	id: '<' + 'rollup>', exports: {}, parent: undefined, filename: null, loaded: false, children: [], paths: []
};
var CHECKED_EXTENSIONS = ['', '.js', '.json'];

function normalize (path) {
	path = path.replace(/\\\\/g, '/');
	var parts = path.split('/');
	var slashed = parts[0] === '';
	for (var i = 1; i < parts.length; i++) {
		if (parts[i] === '.' || parts[i] === '') {
			parts.splice(i--, 1);
		}
	}
	for (var i = 1; i < parts.length; i++) {
		if (parts[i] !== '..') continue;
		if (i > 0 && parts[i - 1] !== '..' && parts[i - 1] !== '.') {
			parts.splice(--i, 2);
			i--;
		}
	}
	path = parts.join('/');
	if (slashed && path[0] !== '/')
	  path = '/' + path;
	else if (path.length === 0)
	  path = '.';
	return path;
}

function join () {
	if (arguments.length === 0)
	  return '.';
	var joined;
	for (var i = 0; i < arguments.length; ++i) {
	  var arg = arguments[i];
	  if (arg.length > 0) {
		if (joined === undefined)
		  joined = arg;
		else
		  joined += '/' + arg;
	  }
	}
	if (joined === undefined)
	  return '.';

	return joined;
}

function isPossibleNodeModulesPath (modulePath) {
	var c0 = modulePath[0];
	if (c0 === '/' || c0 === '\\\\') return false;
	var c1 = modulePath[1], c2 = modulePath[2];
	if ((c0 === '.' && (!c1 || c1 === '/' || c1 === '\\\\')) ||
		(c0 === '.' && c1 === '.' && (!c2 || c2 === '/' || c2 === '\\\\'))) return false;
	if (c1 === ':' && (c2 === '/' || c2 === '\\\\'))
		return false;
	return true;
}

function dirname (path) {
  if (path.length === 0)
    return '.';

  var i = path.length - 1;
  while (i > 0) {
    var c = path.charCodeAt(i);
    if ((c === 47 || c === 92) && i !== path.length - 1)
      break;
    i--;
  }

  if (i > 0)
    return path.substr(0, i);

  if (path.chartCodeAt(0) === 47 || path.chartCodeAt(0) === 92)
    return path.charAt(0);

  return '.';
}

export function commonjsResolveImpl (path, originalModuleDir, testCache) {
	var shouldTryNodeModules = isPossibleNodeModulesPath(path);
	path = normalize(path);
	var relPath;
	if (path[0] === '/') {
		originalModuleDir = '/';
	}
	while (true) {
		if (!shouldTryNodeModules) {
			relPath = originalModuleDir ? normalize(originalModuleDir + '/' + path) : path;
		} else if (originalModuleDir) {
			relPath = normalize(originalModuleDir + '/node_modules/' + path);
		} else {
			relPath = normalize(join('node_modules', path));
		}

		if (relPath.endsWith('/..')) {
			break; // Travelled too far up, avoid infinite loop
		}

		for (var extensionIndex = 0; extensionIndex < CHECKED_EXTENSIONS.length; extensionIndex++) {
			var resolvedPath = relPath + CHECKED_EXTENSIONS[extensionIndex];
			if (DYNAMIC_REQUIRE_CACHE[resolvedPath]) {
				return resolvedPath;
			}
			if (DYNAMIC_REQUIRE_SHORTS[resolvedPath]) {
			  return resolvedPath;
			}
			if (DYNAMIC_REQUIRE_LOADERS[resolvedPath]) {
				return resolvedPath;
			}
		}
		if (!shouldTryNodeModules) break;
		var nextDir = normalize(originalModuleDir + '/..');
		if (nextDir === originalModuleDir) break;
		originalModuleDir = nextDir;
	}
	return null;
}

export function commonjsResolve (path, originalModuleDir) {
	var resolvedPath = commonjsResolveImpl(path, originalModuleDir);
	if (resolvedPath !== null) {
		return resolvedPath;
	}
	return require.resolve(path);
}

export function commonjsRequire (path, originalModuleDir) {
	var resolvedPath = commonjsResolveImpl(path, originalModuleDir, true);
	if (resolvedPath !== null) {
    var cachedModule = DYNAMIC_REQUIRE_CACHE[resolvedPath];
    if (cachedModule) return cachedModule.exports;
    var shortTo = DYNAMIC_REQUIRE_SHORTS[resolvedPath];
    if (shortTo) {
      cachedModule = DYNAMIC_REQUIRE_CACHE[shortTo];
      if (cachedModule)
        return cachedModule.exports;
      resolvedPath = commonjsResolveImpl(shortTo, null, true);
    }
    var loader = DYNAMIC_REQUIRE_LOADERS[resolvedPath];
    if (loader) {
      DYNAMIC_REQUIRE_CACHE[resolvedPath] = cachedModule = {
        id: resolvedPath,
        filename: resolvedPath,
        path: dirname(resolvedPath),
        exports: {},
        parent: DEFAULT_PARENT_MODULE,
        loaded: false,
        children: [],
        paths: [],
        require: function (path, base) {
          return commonjsRequire(path, (base === undefined || base === null) ? cachedModule.path : base);
        }
      };
      try {
        loader.call(commonjsGlobal, cachedModule, cachedModule.exports);
      } catch (error) {
        delete DYNAMIC_REQUIRE_CACHE[resolvedPath];
        throw error;
      }
      cachedModule.loaded = true;
      return cachedModule.exports;
    };
	}
	${ignoreDynamicRequires ? "return require(path);" : FAILED_REQUIRE_ERROR}
}

commonjsRequire.cache = DYNAMIC_REQUIRE_CACHE;
commonjsRequire.resolve = commonjsResolve;
`;
    function getHelpersModule(isDynamicRequireModulesEnabled, ignoreDynamicRequires) {
      return `${HELPERS}${isDynamicRequireModulesEnabled ? getDynamicHelpers(ignoreDynamicRequires) : HELPER_NON_DYNAMIC}`;
    }
    function deconflict(scopes, globals, identifier) {
      let i = 1;
      let deconflicted = pluginutils.makeLegalIdentifier(identifier);
      const hasConflicts = () => scopes.some((scope) => scope.contains(deconflicted)) || globals.has(deconflicted);
      while (hasConflicts()) {
        deconflicted = pluginutils.makeLegalIdentifier(`${identifier}_${i}`);
        i += 1;
      }
      for (const scope of scopes) {
        scope.declarations[deconflicted] = true;
      }
      return deconflicted;
    }
    function getName(id) {
      const name = pluginutils.makeLegalIdentifier(path6.basename(id, path6.extname(id)));
      if (name !== "index") {
        return name;
      }
      return pluginutils.makeLegalIdentifier(path6.basename(path6.dirname(id)));
    }
    function normalizePathSlashes(path7) {
      return path7.replace(/\\/g, "/");
    }
    var VIRTUAL_PATH_BASE = "/$$rollup_base$$";
    var getVirtualPathForDynamicRequirePath = (path7, commonDir) => {
      const normalizedPath = normalizePathSlashes(path7);
      return normalizedPath.startsWith(commonDir) ? VIRTUAL_PATH_BASE + normalizedPath.slice(commonDir.length) : normalizedPath;
    };
    function getPackageEntryPoint(dirPath) {
      let entryPoint = "index.js";
      try {
        if (fs3.existsSync(path6.join(dirPath, "package.json"))) {
          entryPoint = JSON.parse(fs3.readFileSync(path6.join(dirPath, "package.json"), { encoding: "utf8" })).main || entryPoint;
        }
      } catch (ignored) {
      }
      return entryPoint;
    }
    function getDynamicPackagesModule(dynamicRequireModuleDirPaths, commonDir) {
      let code = `const commonjsRegisterOrShort = require('${HELPERS_ID}?commonjsRegisterOrShort');`;
      for (const dir of dynamicRequireModuleDirPaths) {
        const entryPoint = getPackageEntryPoint(dir);
        code += `
commonjsRegisterOrShort(${JSON.stringify(
          getVirtualPathForDynamicRequirePath(dir, commonDir)
        )}, ${JSON.stringify(getVirtualPathForDynamicRequirePath(path6.join(dir, entryPoint), commonDir))});`;
      }
      return code;
    }
    function getDynamicPackagesEntryIntro(dynamicRequireModuleDirPaths, dynamicRequireModuleSet) {
      let dynamicImports = Array.from(
        dynamicRequireModuleSet,
        (dynamicId) => `require(${JSON.stringify(wrapId(dynamicId, DYNAMIC_REGISTER_SUFFIX))});`
      ).join("\n");
      if (dynamicRequireModuleDirPaths.length) {
        dynamicImports += `require(${JSON.stringify(
          wrapId(DYNAMIC_PACKAGES_ID, DYNAMIC_REGISTER_SUFFIX)
        )});`;
      }
      return dynamicImports;
    }
    function isDynamicModuleImport(id, dynamicRequireModuleSet) {
      const normalizedPath = normalizePathSlashes(id);
      return dynamicRequireModuleSet.has(normalizedPath) && !normalizedPath.endsWith(".json");
    }
    function isDirectory(path7) {
      try {
        if (fs3.statSync(path7).isDirectory()) return true;
      } catch (ignored) {
      }
      return false;
    }
    function getDynamicRequirePaths(patterns) {
      const dynamicRequireModuleSet = /* @__PURE__ */ new Set();
      for (const pattern of !patterns || Array.isArray(patterns) ? patterns || [] : [patterns]) {
        const isNegated = pattern.startsWith("!");
        const modifySet = Set.prototype[isNegated ? "delete" : "add"].bind(dynamicRequireModuleSet);
        for (const path$1 of glob__default["default"].sync(isNegated ? pattern.substr(1) : pattern)) {
          modifySet(normalizePathSlashes(path6.resolve(path$1)));
          if (isDirectory(path$1)) {
            modifySet(normalizePathSlashes(path6.resolve(path6.join(path$1, getPackageEntryPoint(path$1)))));
          }
        }
      }
      const dynamicRequireModuleDirPaths = Array.from(dynamicRequireModuleSet.values()).filter(
        (path7) => isDirectory(path7)
      );
      return { dynamicRequireModuleSet, dynamicRequireModuleDirPaths };
    }
    function getCommonJSMetaPromise(commonJSMetaPromises, id) {
      let commonJSMetaPromise = commonJSMetaPromises.get(id);
      if (commonJSMetaPromise) return commonJSMetaPromise.promise;
      const promise = new Promise((resolve10) => {
        commonJSMetaPromise = {
          resolve: resolve10,
          promise: null
        };
        commonJSMetaPromises.set(id, commonJSMetaPromise);
      });
      commonJSMetaPromise.promise = promise;
      return promise;
    }
    function setCommonJSMetaPromise(commonJSMetaPromises, id, commonjsMeta) {
      const commonJSMetaPromise = commonJSMetaPromises.get(id);
      if (commonJSMetaPromise) {
        if (commonJSMetaPromise.resolve) {
          commonJSMetaPromise.resolve(commonjsMeta);
          commonJSMetaPromise.resolve = null;
        }
      } else {
        commonJSMetaPromises.set(id, { promise: Promise.resolve(commonjsMeta), resolve: null });
      }
    }
    function getSpecificHelperProxy(id) {
      return `export {${id.split("?")[1]} as default} from "${HELPERS_ID}";`;
    }
    function getUnknownRequireProxy(id, requireReturnsDefault) {
      if (requireReturnsDefault === true || id.endsWith(".json")) {
        return `export {default} from ${JSON.stringify(id)};`;
      }
      const name = getName(id);
      const exported = requireReturnsDefault === "auto" ? `import {getDefaultExportFromNamespaceIfNotNamed} from "${HELPERS_ID}"; export default /*@__PURE__*/getDefaultExportFromNamespaceIfNotNamed(${name});` : requireReturnsDefault === "preferred" ? `import {getDefaultExportFromNamespaceIfPresent} from "${HELPERS_ID}"; export default /*@__PURE__*/getDefaultExportFromNamespaceIfPresent(${name});` : !requireReturnsDefault ? `import {getAugmentedNamespace} from "${HELPERS_ID}"; export default /*@__PURE__*/getAugmentedNamespace(${name});` : `export default ${name};`;
      return `import * as ${name} from ${JSON.stringify(id)}; ${exported}`;
    }
    function getDynamicJsonProxy(id, commonDir) {
      const normalizedPath = normalizePathSlashes(id.slice(DYNAMIC_JSON_PREFIX.length));
      return `const commonjsRegister = require('${HELPERS_ID}?commonjsRegister');
commonjsRegister(${JSON.stringify(
        getVirtualPathForDynamicRequirePath(normalizedPath, commonDir)
      )}, function (module, exports) {
  module.exports = require(${JSON.stringify(normalizedPath)});
});`;
    }
    function getDynamicRequireProxy(normalizedPath, commonDir) {
      return `const commonjsRegister = require('${HELPERS_ID}?commonjsRegister');
commonjsRegister(${JSON.stringify(
        getVirtualPathForDynamicRequirePath(normalizedPath, commonDir)
      )}, function (module, exports) {
  ${fs3.readFileSync(normalizedPath, { encoding: "utf8" })}
});`;
    }
    async function getStaticRequireProxy(id, requireReturnsDefault, esModulesWithDefaultExport, esModulesWithNamedExports, commonJsMetaPromises) {
      const name = getName(id);
      const commonjsMeta = await getCommonJSMetaPromise(commonJsMetaPromises, id);
      if (commonjsMeta && commonjsMeta.isCommonJS) {
        return `export { __moduleExports as default } from ${JSON.stringify(id)};`;
      } else if (commonjsMeta === null) {
        return getUnknownRequireProxy(id, requireReturnsDefault);
      } else if (!requireReturnsDefault) {
        return `import { getAugmentedNamespace } from "${HELPERS_ID}"; import * as ${name} from ${JSON.stringify(
          id
        )}; export default /*@__PURE__*/getAugmentedNamespace(${name});`;
      } else if (requireReturnsDefault !== true && (requireReturnsDefault === "namespace" || !esModulesWithDefaultExport.has(id) || requireReturnsDefault === "auto" && esModulesWithNamedExports.has(id))) {
        return `import * as ${name} from ${JSON.stringify(id)}; export default ${name};`;
      }
      return `export { default } from ${JSON.stringify(id)};`;
    }
    function getCandidatesForExtension(resolved, extension) {
      return [resolved + extension, `${resolved}${path6.sep}index${extension}`];
    }
    function getCandidates(resolved, extensions) {
      return extensions.reduce(
        (paths, extension) => paths.concat(getCandidatesForExtension(resolved, extension)),
        [resolved]
      );
    }
    function getResolveId(extensions) {
      function resolveExtensions(importee, importer) {
        if (importee[0] !== "." || !importer) return void 0;
        const resolved = path6.resolve(path6.dirname(importer), importee);
        const candidates = getCandidates(resolved, extensions);
        for (let i = 0; i < candidates.length; i += 1) {
          try {
            const stats = fs3.statSync(candidates[i]);
            if (stats.isFile()) return { id: candidates[i] };
          } catch (err2) {
          }
        }
        return void 0;
      }
      return function resolveId3(importee, rawImporter, resolveOptions) {
        if (isWrappedId(importee, MODULE_SUFFIX) || isWrappedId(importee, EXPORTS_SUFFIX)) {
          return importee;
        }
        const importer = rawImporter && isWrappedId(rawImporter, DYNAMIC_REGISTER_SUFFIX) ? unwrapId(rawImporter, DYNAMIC_REGISTER_SUFFIX) : rawImporter;
        if (importer && isWrappedId(importer, PROXY_SUFFIX)) {
          return importee;
        }
        const isProxyModule = isWrappedId(importee, PROXY_SUFFIX);
        const isRequiredModule = isWrappedId(importee, REQUIRE_SUFFIX);
        let isModuleRegistration = false;
        if (isProxyModule) {
          importee = unwrapId(importee, PROXY_SUFFIX);
        } else if (isRequiredModule) {
          importee = unwrapId(importee, REQUIRE_SUFFIX);
          isModuleRegistration = isWrappedId(importee, DYNAMIC_REGISTER_SUFFIX);
          if (isModuleRegistration) {
            importee = unwrapId(importee, DYNAMIC_REGISTER_SUFFIX);
          }
        }
        if (importee.startsWith(HELPERS_ID) || importee === DYNAMIC_PACKAGES_ID || importee.startsWith(DYNAMIC_JSON_PREFIX)) {
          return importee;
        }
        if (importee.startsWith("\0")) {
          return null;
        }
        return this.resolve(
          importee,
          importer,
          Object.assign({}, resolveOptions, {
            skipSelf: true,
            custom: Object.assign({}, resolveOptions.custom, {
              "node-resolve": { isRequire: isProxyModule || isRequiredModule }
            })
          })
        ).then((resolved) => {
          if (!resolved) {
            resolved = resolveExtensions(importee, importer);
          }
          if (resolved && isProxyModule) {
            resolved.id = wrapId(resolved.id, resolved.external ? EXTERNAL_SUFFIX : PROXY_SUFFIX);
            resolved.external = false;
          } else if (resolved && isModuleRegistration) {
            resolved.id = wrapId(resolved.id, DYNAMIC_REGISTER_SUFFIX);
          } else if (!resolved && (isProxyModule || isRequiredModule)) {
            return { id: wrapId(importee, EXTERNAL_SUFFIX), external: false };
          }
          return resolved;
        });
      };
    }
    function validateRollupVersion(rollupVersion2, peerDependencyVersion) {
      const [major, minor] = rollupVersion2.split(".").map(Number);
      const versionRegexp = /\^(\d+\.\d+)\.\d+/g;
      let minMajor = Infinity;
      let minMinor = Infinity;
      let foundVersion;
      while (foundVersion = versionRegexp.exec(peerDependencyVersion)) {
        const [foundMajor, foundMinor] = foundVersion[1].split(".").map(Number);
        if (foundMajor < minMajor) {
          minMajor = foundMajor;
          minMinor = foundMinor;
        }
      }
      if (major < minMajor || major === minMajor && minor < minMinor) {
        throw new Error(
          `Insufficient Rollup version: "@rollup/plugin-commonjs" requires at least rollup@${minMajor}.${minMinor} but found rollup@${rollupVersion2}.`
        );
      }
    }
    var operators = {
      "==": (x) => equals(x.left, x.right, false),
      "!=": (x) => not(operators["=="](x)),
      "===": (x) => equals(x.left, x.right, true),
      "!==": (x) => not(operators["==="](x)),
      "!": (x) => isFalsy(x.argument),
      "&&": (x) => isTruthy(x.left) && isTruthy(x.right),
      "||": (x) => isTruthy(x.left) || isTruthy(x.right)
    };
    function not(value) {
      return value === null ? value : !value;
    }
    function equals(a, b, strict) {
      if (a.type !== b.type) return null;
      if (a.type === "Literal") return strict ? a.value === b.value : a.value == b.value;
      return null;
    }
    function isTruthy(node) {
      if (!node) return false;
      if (node.type === "Literal") return !!node.value;
      if (node.type === "ParenthesizedExpression") return isTruthy(node.expression);
      if (node.operator in operators) return operators[node.operator](node);
      return null;
    }
    function isFalsy(node) {
      return not(isTruthy(node));
    }
    function getKeypath(node) {
      const parts = [];
      while (node.type === "MemberExpression") {
        if (node.computed) return null;
        parts.unshift(node.property.name);
        node = node.object;
      }
      if (node.type !== "Identifier") return null;
      const { name } = node;
      parts.unshift(name);
      return { name, keypath: parts.join(".") };
    }
    var KEY_COMPILED_ESM = "__esModule";
    function isDefineCompiledEsm(node) {
      const definedProperty = getDefinePropertyCallName(node, "exports") || getDefinePropertyCallName(node, "module.exports");
      if (definedProperty && definedProperty.key === KEY_COMPILED_ESM) {
        return isTruthy(definedProperty.value);
      }
      return false;
    }
    function getDefinePropertyCallName(node, targetName) {
      const {
        callee: { object, property: property2 }
      } = node;
      if (!object || object.type !== "Identifier" || object.name !== "Object") return;
      if (!property2 || property2.type !== "Identifier" || property2.name !== "defineProperty") return;
      if (node.arguments.length !== 3) return;
      const targetNames = targetName.split(".");
      const [target, key, value] = node.arguments;
      if (targetNames.length === 1) {
        if (target.type !== "Identifier" || target.name !== targetNames[0]) {
          return;
        }
      }
      if (targetNames.length === 2) {
        if (target.type !== "MemberExpression" || target.object.name !== targetNames[0] || target.property.name !== targetNames[1]) {
          return;
        }
      }
      if (value.type !== "ObjectExpression" || !value.properties) return;
      const valueProperty = value.properties.find((p) => p.key && p.key.name === "value");
      if (!valueProperty || !valueProperty.value) return;
      return { key: key.value, value: valueProperty.value };
    }
    function isShorthandProperty(parent) {
      return parent && parent.type === "Property" && parent.shorthand;
    }
    function hasDefineEsmProperty(node) {
      return node.properties.some((property2) => {
        if (property2.type === "Property" && property2.key.type === "Identifier" && property2.key.name === "__esModule" && isTruthy(property2.value)) {
          return true;
        }
        return false;
      });
    }
    function wrapCode(magicString, uses, moduleName, exportsName) {
      const args = [];
      const passedArgs = [];
      if (uses.module) {
        args.push("module");
        passedArgs.push(moduleName);
      }
      if (uses.exports) {
        args.push("exports");
        passedArgs.push(exportsName);
      }
      magicString.trim().prepend(`(function (${args.join(", ")}) {
`).append(`
}(${passedArgs.join(", ")}));`);
    }
    function rewriteExportsAndGetExportsBlock(magicString, moduleName, exportsName, wrapped, moduleExportsAssignments, firstTopLevelModuleExportsAssignment, exportsAssignmentsByName, topLevelAssignments, defineCompiledEsmExpressions, deconflictedExportNames, code, HELPERS_NAME, exportMode, detectWrappedDefault, defaultIsModuleExports) {
      const exports3 = [];
      const exportDeclarations = [];
      if (exportMode === "replace") {
        getExportsForReplacedModuleExports(
          magicString,
          exports3,
          exportDeclarations,
          moduleExportsAssignments,
          firstTopLevelModuleExportsAssignment,
          exportsName
        );
      } else {
        exports3.push(`${exportsName} as __moduleExports`);
        if (wrapped) {
          getExportsWhenWrapping(
            exportDeclarations,
            exportsName,
            detectWrappedDefault,
            HELPERS_NAME,
            defaultIsModuleExports
          );
        } else {
          getExports2(
            magicString,
            exports3,
            exportDeclarations,
            moduleExportsAssignments,
            exportsAssignmentsByName,
            deconflictedExportNames,
            topLevelAssignments,
            moduleName,
            exportsName,
            defineCompiledEsmExpressions,
            HELPERS_NAME,
            defaultIsModuleExports
          );
        }
      }
      if (exports3.length) {
        exportDeclarations.push(`export { ${exports3.join(", ")} };`);
      }
      return `

${exportDeclarations.join("\n")}`;
    }
    function getExportsForReplacedModuleExports(magicString, exports3, exportDeclarations, moduleExportsAssignments, firstTopLevelModuleExportsAssignment, exportsName) {
      for (const { left } of moduleExportsAssignments) {
        magicString.overwrite(left.start, left.end, exportsName);
      }
      magicString.prependRight(firstTopLevelModuleExportsAssignment.left.start, "var ");
      exports3.push(`${exportsName} as __moduleExports`);
      exportDeclarations.push(`export default ${exportsName};`);
    }
    function getExportsWhenWrapping(exportDeclarations, exportsName, detectWrappedDefault, HELPERS_NAME, defaultIsModuleExports) {
      exportDeclarations.push(
        `export default ${detectWrappedDefault && defaultIsModuleExports === "auto" ? `/*@__PURE__*/${HELPERS_NAME}.getDefaultExportFromCjs(${exportsName})` : defaultIsModuleExports === false ? `${exportsName}.default` : exportsName};`
      );
    }
    function getExports2(magicString, exports3, exportDeclarations, moduleExportsAssignments, exportsAssignmentsByName, deconflictedExportNames, topLevelAssignments, moduleName, exportsName, defineCompiledEsmExpressions, HELPERS_NAME, defaultIsModuleExports) {
      let deconflictedDefaultExportName;
      for (const { left } of moduleExportsAssignments) {
        magicString.overwrite(left.start, left.end, `${moduleName}.exports`);
      }
      for (const [exportName, { nodes }] of exportsAssignmentsByName) {
        const deconflicted = deconflictedExportNames[exportName];
        let needsDeclaration = true;
        for (const node of nodes) {
          let replacement = `${deconflicted} = ${exportsName}.${exportName}`;
          if (needsDeclaration && topLevelAssignments.has(node)) {
            replacement = `var ${replacement}`;
            needsDeclaration = false;
          }
          magicString.overwrite(node.start, node.left.end, replacement);
        }
        if (needsDeclaration) {
          magicString.prepend(`var ${deconflicted};
`);
        }
        if (exportName === "default") {
          deconflictedDefaultExportName = deconflicted;
        } else {
          exports3.push(exportName === deconflicted ? exportName : `${deconflicted} as ${exportName}`);
        }
      }
      let isRestorableCompiledEsm = false;
      for (const expression of defineCompiledEsmExpressions) {
        isRestorableCompiledEsm = true;
        const moduleExportsExpression = expression.type === "CallExpression" ? expression.arguments[0] : expression.left.object;
        magicString.overwrite(moduleExportsExpression.start, moduleExportsExpression.end, exportsName);
      }
      if (!isRestorableCompiledEsm || defaultIsModuleExports === true) {
        exportDeclarations.push(`export default ${exportsName};`);
      } else if (moduleExportsAssignments.length === 0 || defaultIsModuleExports === false) {
        exports3.push(`${deconflictedDefaultExportName || exportsName} as default`);
      } else {
        exportDeclarations.push(
          `export default /*@__PURE__*/${HELPERS_NAME}.getDefaultExportFromCjs(${exportsName});`
        );
      }
    }
    function isRequireStatement(node, scope) {
      if (!node) return false;
      if (node.type !== "CallExpression") return false;
      if (node.arguments.length === 0) return false;
      return isRequire(node.callee, scope);
    }
    function isRequire(node, scope) {
      return node.type === "Identifier" && node.name === "require" && !scope.contains("require") || node.type === "MemberExpression" && isModuleRequire(node, scope);
    }
    function isModuleRequire({ object, property: property2 }, scope) {
      return object.type === "Identifier" && object.name === "module" && property2.type === "Identifier" && property2.name === "require" && !scope.contains("module");
    }
    function isStaticRequireStatement(node, scope) {
      if (!isRequireStatement(node, scope)) return false;
      return !hasDynamicArguments(node);
    }
    function hasDynamicArguments(node) {
      return node.arguments.length > 1 || node.arguments[0].type !== "Literal" && (node.arguments[0].type !== "TemplateLiteral" || node.arguments[0].expressions.length > 0);
    }
    var reservedMethod = { resolve: true, cache: true, main: true };
    function isNodeRequirePropertyAccess(parent) {
      return parent && parent.property && reservedMethod[parent.property.name];
    }
    function isIgnoredRequireStatement(requiredNode, ignoreRequire) {
      return ignoreRequire(requiredNode.arguments[0].value);
    }
    function getRequireStringArg(node) {
      return node.arguments[0].type === "Literal" ? node.arguments[0].value : node.arguments[0].quasis[0].value.cooked;
    }
    function hasDynamicModuleForPath(source, id, dynamicRequireModuleSet) {
      if (!/^(?:\.{0,2}[/\\]|[A-Za-z]:[/\\])/.test(source)) {
        try {
          const resolvedPath = normalizePathSlashes(resolve9.sync(source, { basedir: path6.dirname(id) }));
          if (dynamicRequireModuleSet.has(resolvedPath)) {
            return true;
          }
        } catch (ex) {
          return false;
        }
        return false;
      }
      for (const attemptExt of ["", ".js", ".json"]) {
        const resolvedPath = normalizePathSlashes(path6.resolve(path6.dirname(id), source + attemptExt));
        if (dynamicRequireModuleSet.has(resolvedPath)) {
          return true;
        }
      }
      return false;
    }
    function getRequireHandlers() {
      const requiredSources = [];
      const requiredBySource = /* @__PURE__ */ Object.create(null);
      const requiredByNode = /* @__PURE__ */ new Map();
      const requireExpressionsWithUsedReturnValue = [];
      function addRequireStatement(sourceId, node, scope, usesReturnValue) {
        const required = getRequired(sourceId);
        requiredByNode.set(node, { scope, required });
        if (usesReturnValue) {
          required.nodesUsingRequired.push(node);
          requireExpressionsWithUsedReturnValue.push(node);
        }
      }
      function getRequired(sourceId) {
        if (!requiredBySource[sourceId]) {
          requiredSources.push(sourceId);
          requiredBySource[sourceId] = {
            source: sourceId,
            name: null,
            nodesUsingRequired: []
          };
        }
        return requiredBySource[sourceId];
      }
      function rewriteRequireExpressionsAndGetImportBlock(magicString, topLevelDeclarations, topLevelRequireDeclarators, reassignedNames, helpersName, dynamicRegisterSources, moduleName, exportsName, id, exportMode) {
        setRemainingImportNamesAndRewriteRequires(
          requireExpressionsWithUsedReturnValue,
          requiredByNode,
          magicString
        );
        const imports = [];
        imports.push(`import * as ${helpersName} from "${HELPERS_ID}";`);
        if (exportMode === "module") {
          imports.push(
            `import { __module as ${moduleName}, exports as ${exportsName} } from ${JSON.stringify(
              wrapId(id, MODULE_SUFFIX)
            )}`
          );
        } else if (exportMode === "exports") {
          imports.push(
            `import { __exports as ${exportsName} } from ${JSON.stringify(wrapId(id, EXPORTS_SUFFIX))}`
          );
        }
        for (const source of dynamicRegisterSources) {
          imports.push(`import ${JSON.stringify(wrapId(source, REQUIRE_SUFFIX))};`);
        }
        for (const source of requiredSources) {
          if (!source.startsWith("\0")) {
            imports.push(`import ${JSON.stringify(wrapId(source, REQUIRE_SUFFIX))};`);
          }
          const { name, nodesUsingRequired } = requiredBySource[source];
          imports.push(
            `import ${nodesUsingRequired.length ? `${name} from ` : ""}${JSON.stringify(
              source.startsWith("\0") ? source : wrapId(source, PROXY_SUFFIX)
            )};`
          );
        }
        return imports.length ? `${imports.join("\n")}

` : "";
      }
      return {
        addRequireStatement,
        requiredSources,
        rewriteRequireExpressionsAndGetImportBlock
      };
    }
    function setRemainingImportNamesAndRewriteRequires(requireExpressionsWithUsedReturnValue, requiredByNode, magicString) {
      let uid = 0;
      for (const requireExpression of requireExpressionsWithUsedReturnValue) {
        const { required } = requiredByNode.get(requireExpression);
        if (!required.name) {
          let potentialName;
          const isUsedName = (node) => requiredByNode.get(node).scope.contains(potentialName);
          do {
            potentialName = `require$$${uid}`;
            uid += 1;
          } while (required.nodesUsingRequired.some(isUsedName));
          required.name = potentialName;
        }
        magicString.overwrite(requireExpression.start, requireExpression.end, required.name);
      }
    }
    var exportsPattern = /^(?:module\.)?exports(?:\.([a-zA-Z_$][a-zA-Z_$0-9]*))?$/;
    var functionType = /^(?:FunctionDeclaration|FunctionExpression|ArrowFunctionExpression)$/;
    function transformCommonjs(parse5, code, id, isEsModule, ignoreGlobal, ignoreRequire, ignoreDynamicRequires, getIgnoreTryCatchRequireStatementMode, sourceMap, isDynamicRequireModulesEnabled, dynamicRequireModuleSet, disableWrap, commonDir, astCache, defaultIsModuleExports) {
      const ast = astCache || tryParse(parse5, code, id);
      const magicString = new MagicString__default["default"](code);
      const uses = {
        module: false,
        exports: false,
        global: false,
        require: false
      };
      let usesDynamicRequire = false;
      const virtualDynamicRequirePath = isDynamicRequireModulesEnabled && getVirtualPathForDynamicRequirePath(path6.dirname(id), commonDir);
      let scope = pluginutils.attachScopes(ast, "scope");
      let lexicalDepth = 0;
      let programDepth = 0;
      let currentTryBlockEnd = null;
      let shouldWrap = false;
      const globals = /* @__PURE__ */ new Set();
      const HELPERS_NAME = deconflict([scope], globals, "commonjsHelpers");
      const dynamicRegisterSources = /* @__PURE__ */ new Set();
      let hasRemovedRequire = false;
      const {
        addRequireStatement,
        requiredSources,
        rewriteRequireExpressionsAndGetImportBlock
      } = getRequireHandlers();
      const reassignedNames = /* @__PURE__ */ new Set();
      const topLevelDeclarations = [];
      const topLevelRequireDeclarators = /* @__PURE__ */ new Set();
      const skippedNodes = /* @__PURE__ */ new Set();
      const moduleAccessScopes = /* @__PURE__ */ new Set([scope]);
      const exportsAccessScopes = /* @__PURE__ */ new Set([scope]);
      const moduleExportsAssignments = [];
      let firstTopLevelModuleExportsAssignment = null;
      const exportsAssignmentsByName = /* @__PURE__ */ new Map();
      const topLevelAssignments = /* @__PURE__ */ new Set();
      const topLevelDefineCompiledEsmExpressions = [];
      estreeWalker.walk(ast, {
        enter(node, parent) {
          if (skippedNodes.has(node)) {
            this.skip();
            return;
          }
          if (currentTryBlockEnd !== null && node.start > currentTryBlockEnd) {
            currentTryBlockEnd = null;
          }
          programDepth += 1;
          if (node.scope) ({ scope } = node);
          if (functionType.test(node.type)) lexicalDepth += 1;
          if (sourceMap) {
            magicString.addSourcemapLocation(node.start);
            magicString.addSourcemapLocation(node.end);
          }
          switch (node.type) {
            case "TryStatement":
              if (currentTryBlockEnd === null) {
                currentTryBlockEnd = node.block.end;
              }
              return;
            case "AssignmentExpression":
              if (node.left.type === "MemberExpression") {
                const flattened = getKeypath(node.left);
                if (!flattened || scope.contains(flattened.name)) return;
                const exportsPatternMatch = exportsPattern.exec(flattened.keypath);
                if (!exportsPatternMatch || flattened.keypath === "exports") return;
                const [, exportName] = exportsPatternMatch;
                uses[flattened.name] = true;
                if (flattened.keypath === "module.exports") {
                  moduleExportsAssignments.push(node);
                  if (programDepth > 3) {
                    moduleAccessScopes.add(scope);
                  } else if (!firstTopLevelModuleExportsAssignment) {
                    firstTopLevelModuleExportsAssignment = node;
                  }
                  if (defaultIsModuleExports === false) {
                    shouldWrap = true;
                  } else if (defaultIsModuleExports === "auto") {
                    if (node.right.type === "ObjectExpression") {
                      if (hasDefineEsmProperty(node.right)) {
                        shouldWrap = true;
                      }
                    } else if (defaultIsModuleExports === false) {
                      shouldWrap = true;
                    }
                  }
                } else if (exportName === KEY_COMPILED_ESM) {
                  if (programDepth > 3) {
                    shouldWrap = true;
                  } else {
                    topLevelDefineCompiledEsmExpressions.push(node);
                  }
                } else {
                  const exportsAssignments = exportsAssignmentsByName.get(exportName) || {
                    nodes: [],
                    scopes: /* @__PURE__ */ new Set()
                  };
                  exportsAssignments.nodes.push(node);
                  exportsAssignments.scopes.add(scope);
                  exportsAccessScopes.add(scope);
                  exportsAssignmentsByName.set(exportName, exportsAssignments);
                  if (programDepth <= 3) {
                    topLevelAssignments.add(node);
                  }
                }
                skippedNodes.add(node.left);
              } else {
                for (const name of pluginutils.extractAssignedNames(node.left)) {
                  reassignedNames.add(name);
                }
              }
              return;
            case "CallExpression": {
              if (isDefineCompiledEsm(node)) {
                if (programDepth === 3 && parent.type === "ExpressionStatement") {
                  skippedNodes.add(node.arguments[0]);
                  topLevelDefineCompiledEsmExpressions.push(node);
                } else {
                  shouldWrap = true;
                }
                return;
              }
              if (node.callee.object && node.callee.object.name === "require" && node.callee.property.name === "resolve" && hasDynamicModuleForPath(id, "/", dynamicRequireModuleSet)) {
                const requireNode = node.callee.object;
                magicString.appendLeft(
                  node.end - 1,
                  `,${JSON.stringify(
                    path6.dirname(id) === "." ? null : virtualDynamicRequirePath
                  )}`
                );
                magicString.overwrite(
                  requireNode.start,
                  requireNode.end,
                  `${HELPERS_NAME}.commonjsRequire`,
                  {
                    storeName: true
                  }
                );
                return;
              }
              if (!isStaticRequireStatement(node, scope)) return;
              if (!isDynamicRequireModulesEnabled) {
                skippedNodes.add(node.callee);
              }
              if (!isIgnoredRequireStatement(node, ignoreRequire)) {
                skippedNodes.add(node.callee);
                const usesReturnValue = parent.type !== "ExpressionStatement";
                let canConvertRequire = true;
                let shouldRemoveRequireStatement = false;
                if (currentTryBlockEnd !== null) {
                  ({
                    canConvertRequire,
                    shouldRemoveRequireStatement
                  } = getIgnoreTryCatchRequireStatementMode(node.arguments[0].value));
                  if (shouldRemoveRequireStatement) {
                    hasRemovedRequire = true;
                  }
                }
                let sourceId = getRequireStringArg(node);
                const isDynamicRegister = isWrappedId(sourceId, DYNAMIC_REGISTER_SUFFIX);
                if (isDynamicRegister) {
                  sourceId = unwrapId(sourceId, DYNAMIC_REGISTER_SUFFIX);
                  if (sourceId.endsWith(".json")) {
                    sourceId = DYNAMIC_JSON_PREFIX + sourceId;
                  }
                  dynamicRegisterSources.add(wrapId(sourceId, DYNAMIC_REGISTER_SUFFIX));
                } else {
                  if (!sourceId.endsWith(".json") && hasDynamicModuleForPath(sourceId, id, dynamicRequireModuleSet)) {
                    if (shouldRemoveRequireStatement) {
                      magicString.overwrite(node.start, node.end, `undefined`);
                    } else if (canConvertRequire) {
                      magicString.overwrite(
                        node.start,
                        node.end,
                        `${HELPERS_NAME}.commonjsRequire(${JSON.stringify(
                          getVirtualPathForDynamicRequirePath(sourceId, commonDir)
                        )}, ${JSON.stringify(
                          path6.dirname(id) === "." ? null : virtualDynamicRequirePath
                        )})`
                      );
                      usesDynamicRequire = true;
                    }
                    return;
                  }
                  if (canConvertRequire) {
                    addRequireStatement(sourceId, node, scope, usesReturnValue);
                  }
                }
                if (usesReturnValue) {
                  if (shouldRemoveRequireStatement) {
                    magicString.overwrite(node.start, node.end, `undefined`);
                    return;
                  }
                  if (parent.type === "VariableDeclarator" && !scope.parent && parent.id.type === "Identifier") {
                    topLevelRequireDeclarators.add(parent);
                  }
                } else {
                  if (!canConvertRequire && !shouldRemoveRequireStatement) {
                    return;
                  }
                  magicString.remove(parent.start, parent.end);
                }
              }
              return;
            }
            case "ConditionalExpression":
            case "IfStatement":
              if (isFalsy(node.test)) {
                skippedNodes.add(node.consequent);
              } else if (node.alternate && isTruthy(node.test)) {
                skippedNodes.add(node.alternate);
              }
              return;
            case "Identifier": {
              const { name } = node;
              if (!(isReference__default["default"](node, parent) && !scope.contains(name))) return;
              switch (name) {
                case "require":
                  if (isNodeRequirePropertyAccess(parent)) {
                    if (hasDynamicModuleForPath(id, "/", dynamicRequireModuleSet)) {
                      if (parent.property.name === "cache") {
                        magicString.overwrite(node.start, node.end, `${HELPERS_NAME}.commonjsRequire`, {
                          storeName: true
                        });
                      }
                    }
                    return;
                  }
                  if (isDynamicRequireModulesEnabled && isRequireStatement(parent, scope)) {
                    magicString.appendLeft(
                      parent.end - 1,
                      `,${JSON.stringify(
                        path6.dirname(id) === "." ? null : virtualDynamicRequirePath
                      )}`
                    );
                  }
                  if (!ignoreDynamicRequires) {
                    if (isShorthandProperty(parent)) {
                      magicString.appendRight(node.end, `: ${HELPERS_NAME}.commonjsRequire`);
                    } else {
                      magicString.overwrite(node.start, node.end, `${HELPERS_NAME}.commonjsRequire`, {
                        storeName: true
                      });
                    }
                  }
                  usesDynamicRequire = true;
                  return;
                case "module":
                case "exports":
                  shouldWrap = true;
                  uses[name] = true;
                  return;
                case "global":
                  uses.global = true;
                  if (!ignoreGlobal) {
                    magicString.overwrite(node.start, node.end, `${HELPERS_NAME}.commonjsGlobal`, {
                      storeName: true
                    });
                  }
                  return;
                case "define":
                  magicString.overwrite(node.start, node.end, "undefined", {
                    storeName: true
                  });
                  return;
                default:
                  globals.add(name);
                  return;
              }
            }
            case "MemberExpression":
              if (!isDynamicRequireModulesEnabled && isModuleRequire(node, scope)) {
                magicString.overwrite(node.start, node.end, `${HELPERS_NAME}.commonjsRequire`, {
                  storeName: true
                });
                skippedNodes.add(node.object);
                skippedNodes.add(node.property);
              }
              return;
            case "ReturnStatement":
              if (lexicalDepth === 0) {
                shouldWrap = true;
              }
              return;
            case "ThisExpression":
              if (lexicalDepth === 0) {
                uses.global = true;
                if (!ignoreGlobal) {
                  magicString.overwrite(node.start, node.end, `${HELPERS_NAME}.commonjsGlobal`, {
                    storeName: true
                  });
                }
              }
              return;
            case "UnaryExpression":
              if (node.operator === "typeof") {
                const flattened = getKeypath(node.argument);
                if (!flattened) return;
                if (scope.contains(flattened.name)) return;
                if (flattened.keypath === "module.exports" || flattened.keypath === "module" || flattened.keypath === "exports") {
                  magicString.overwrite(node.start, node.end, `'object'`, {
                    storeName: false
                  });
                }
              }
              return;
            case "VariableDeclaration":
              if (!scope.parent) {
                topLevelDeclarations.push(node);
              }
          }
        },
        leave(node) {
          programDepth -= 1;
          if (node.scope) scope = scope.parent;
          if (functionType.test(node.type)) lexicalDepth -= 1;
        }
      });
      const nameBase = getName(id);
      const exportsName = deconflict([...exportsAccessScopes], globals, nameBase);
      const moduleName = deconflict([...moduleAccessScopes], globals, `${nameBase}Module`);
      const deconflictedExportNames = /* @__PURE__ */ Object.create(null);
      for (const [exportName, { scopes }] of exportsAssignmentsByName) {
        deconflictedExportNames[exportName] = deconflict([...scopes], globals, exportName);
      }
      shouldWrap = !isEsModule && !disableWrap && (shouldWrap || uses.exports && moduleExportsAssignments.length > 0);
      const detectWrappedDefault = shouldWrap && (topLevelDefineCompiledEsmExpressions.length > 0 || code.indexOf("__esModule") >= 0);
      if (!(requiredSources.length || dynamicRegisterSources.size || uses.module || uses.exports || uses.require || usesDynamicRequire || hasRemovedRequire || topLevelDefineCompiledEsmExpressions.length > 0) && (ignoreGlobal || !uses.global)) {
        return { meta: { commonjs: { isCommonJS: false } } };
      }
      let leadingComment = "";
      if (code.startsWith("/*")) {
        const commentEnd = code.indexOf("*/", 2) + 2;
        leadingComment = `${code.slice(0, commentEnd)}
`;
        magicString.remove(0, commentEnd).trim();
      }
      const exportMode = shouldWrap ? uses.module ? "module" : "exports" : firstTopLevelModuleExportsAssignment ? exportsAssignmentsByName.size === 0 && topLevelDefineCompiledEsmExpressions.length === 0 ? "replace" : "module" : moduleExportsAssignments.length === 0 ? "exports" : "module";
      const importBlock = rewriteRequireExpressionsAndGetImportBlock(
        magicString,
        topLevelDeclarations,
        topLevelRequireDeclarators,
        reassignedNames,
        HELPERS_NAME,
        dynamicRegisterSources,
        moduleName,
        exportsName,
        id,
        exportMode
      );
      const exportBlock = isEsModule ? "" : rewriteExportsAndGetExportsBlock(
        magicString,
        moduleName,
        exportsName,
        shouldWrap,
        moduleExportsAssignments,
        firstTopLevelModuleExportsAssignment,
        exportsAssignmentsByName,
        topLevelAssignments,
        topLevelDefineCompiledEsmExpressions,
        deconflictedExportNames,
        code,
        HELPERS_NAME,
        exportMode,
        detectWrappedDefault,
        defaultIsModuleExports
      );
      if (shouldWrap) {
        wrapCode(magicString, uses, moduleName, exportsName);
      }
      magicString.trim().prepend(leadingComment + importBlock).append(exportBlock);
      return {
        code: magicString.toString(),
        map: sourceMap ? magicString.generateMap() : null,
        syntheticNamedExports: isEsModule ? false : "__moduleExports",
        meta: { commonjs: { isCommonJS: !isEsModule } }
      };
    }
    function commonjs(options = {}) {
      const extensions = options.extensions || [".js"];
      const filter2 = pluginutils.createFilter(options.include, options.exclude);
      const {
        ignoreGlobal,
        ignoreDynamicRequires,
        requireReturnsDefault: requireReturnsDefaultOption,
        defaultIsModuleExports: defaultIsModuleExportsOption,
        esmExternals
      } = options;
      const getRequireReturnsDefault = typeof requireReturnsDefaultOption === "function" ? requireReturnsDefaultOption : () => requireReturnsDefaultOption;
      let esmExternalIds;
      const isEsmExternal = typeof esmExternals === "function" ? esmExternals : Array.isArray(esmExternals) ? (esmExternalIds = new Set(esmExternals), (id) => esmExternalIds.has(id)) : () => esmExternals;
      const getDefaultIsModuleExports = typeof defaultIsModuleExportsOption === "function" ? defaultIsModuleExportsOption : () => typeof defaultIsModuleExportsOption === "boolean" ? defaultIsModuleExportsOption : "auto";
      const { dynamicRequireModuleSet, dynamicRequireModuleDirPaths } = getDynamicRequirePaths(
        options.dynamicRequireTargets
      );
      const isDynamicRequireModulesEnabled = dynamicRequireModuleSet.size > 0;
      const commonDir = isDynamicRequireModulesEnabled ? getCommonDir__default["default"](null, Array.from(dynamicRequireModuleSet).concat(process.cwd())) : null;
      const esModulesWithDefaultExport = /* @__PURE__ */ new Set();
      const esModulesWithNamedExports = /* @__PURE__ */ new Set();
      const commonJsMetaPromises = /* @__PURE__ */ new Map();
      const ignoreRequire = typeof options.ignore === "function" ? options.ignore : Array.isArray(options.ignore) ? (id) => options.ignore.includes(id) : () => false;
      const getIgnoreTryCatchRequireStatementMode = (id) => {
        const mode = typeof options.ignoreTryCatch === "function" ? options.ignoreTryCatch(id) : Array.isArray(options.ignoreTryCatch) ? options.ignoreTryCatch.includes(id) : typeof options.ignoreTryCatch !== "undefined" ? options.ignoreTryCatch : true;
        return {
          canConvertRequire: mode !== "remove" && mode !== true,
          shouldRemoveRequireStatement: mode === "remove"
        };
      };
      const resolveId3 = getResolveId(extensions);
      const sourceMap = options.sourceMap !== false;
      function transformAndCheckExports(code, id) {
        if (isDynamicRequireModulesEnabled && this.getModuleInfo(id).isEntry) {
          code = getDynamicPackagesEntryIntro(dynamicRequireModuleDirPaths, dynamicRequireModuleSet) + code;
        }
        const { isEsModule, hasDefaultExport, hasNamedExports, ast } = analyzeTopLevelStatements(
          this.parse,
          code,
          id
        );
        if (hasDefaultExport) {
          esModulesWithDefaultExport.add(id);
        }
        if (hasNamedExports) {
          esModulesWithNamedExports.add(id);
        }
        if (!dynamicRequireModuleSet.has(normalizePathSlashes(id)) && (!hasCjsKeywords(code, ignoreGlobal) || isEsModule && !options.transformMixedEsModules)) {
          return { meta: { commonjs: { isCommonJS: false } } };
        }
        const disableWrap = isWrappedId(id, DYNAMIC_REGISTER_SUFFIX);
        if (disableWrap) {
          id = unwrapId(id, DYNAMIC_REGISTER_SUFFIX);
        }
        return transformCommonjs(
          this.parse,
          code,
          id,
          isEsModule,
          ignoreGlobal || isEsModule,
          ignoreRequire,
          ignoreDynamicRequires && !isDynamicRequireModulesEnabled,
          getIgnoreTryCatchRequireStatementMode,
          sourceMap,
          isDynamicRequireModulesEnabled,
          dynamicRequireModuleSet,
          disableWrap,
          commonDir,
          ast,
          getDefaultIsModuleExports(id)
        );
      }
      return {
        name: "commonjs",
        buildStart() {
          validateRollupVersion(this.meta.rollupVersion, peerDependencies.rollup);
          if (options.namedExports != null) {
            this.warn(
              'The namedExports option from "@rollup/plugin-commonjs" is deprecated. Named exports are now handled automatically.'
            );
          }
        },
        resolveId: resolveId3,
        load(id) {
          if (id === HELPERS_ID) {
            return getHelpersModule(isDynamicRequireModulesEnabled, ignoreDynamicRequires);
          }
          if (id.startsWith(HELPERS_ID)) {
            return getSpecificHelperProxy(id);
          }
          if (isWrappedId(id, MODULE_SUFFIX)) {
            const actualId = unwrapId(id, MODULE_SUFFIX);
            let name = getName(actualId);
            let code;
            if (isDynamicRequireModulesEnabled) {
              if (["modulePath", "commonjsRequire", "createModule"].includes(name)) {
                name = `${name}_`;
              }
              code = `import {commonjsRequire, createModule} from "${HELPERS_ID}";
var ${name} = createModule(${JSON.stringify(
                getVirtualPathForDynamicRequirePath(path6.dirname(actualId), commonDir)
              )});
export {${name} as __module}`;
            } else {
              code = `var ${name} = {exports: {}}; export {${name} as __module}`;
            }
            return {
              code,
              syntheticNamedExports: "__module",
              meta: { commonjs: { isCommonJS: false } }
            };
          }
          if (isWrappedId(id, EXPORTS_SUFFIX)) {
            const actualId = unwrapId(id, EXPORTS_SUFFIX);
            const name = getName(actualId);
            return {
              code: `var ${name} = {}; export {${name} as __exports}`,
              meta: { commonjs: { isCommonJS: false } }
            };
          }
          if (isWrappedId(id, EXTERNAL_SUFFIX)) {
            const actualId = unwrapId(id, EXTERNAL_SUFFIX);
            return getUnknownRequireProxy(
              actualId,
              isEsmExternal(actualId) ? getRequireReturnsDefault(actualId) : true
            );
          }
          if (id === DYNAMIC_PACKAGES_ID) {
            return getDynamicPackagesModule(dynamicRequireModuleDirPaths, commonDir);
          }
          if (id.startsWith(DYNAMIC_JSON_PREFIX)) {
            return getDynamicJsonProxy(id, commonDir);
          }
          if (isDynamicModuleImport(id, dynamicRequireModuleSet)) {
            return `export default require(${JSON.stringify(normalizePathSlashes(id))});`;
          }
          if (isWrappedId(id, DYNAMIC_REGISTER_SUFFIX)) {
            return getDynamicRequireProxy(
              normalizePathSlashes(unwrapId(id, DYNAMIC_REGISTER_SUFFIX)),
              commonDir
            );
          }
          if (isWrappedId(id, PROXY_SUFFIX)) {
            const actualId = unwrapId(id, PROXY_SUFFIX);
            return getStaticRequireProxy(
              actualId,
              getRequireReturnsDefault(actualId),
              esModulesWithDefaultExport,
              esModulesWithNamedExports,
              commonJsMetaPromises
            );
          }
          return null;
        },
        transform(code, rawId) {
          let id = rawId;
          if (isWrappedId(id, DYNAMIC_REGISTER_SUFFIX)) {
            id = unwrapId(id, DYNAMIC_REGISTER_SUFFIX);
          }
          const extName = path6.extname(id);
          if (extName !== ".cjs" && id !== DYNAMIC_PACKAGES_ID && !id.startsWith(DYNAMIC_JSON_PREFIX) && (!filter2(id) || !extensions.includes(extName))) {
            return null;
          }
          try {
            return transformAndCheckExports.call(this, code, rawId);
          } catch (err2) {
            return this.error(err2, err2.loc);
          }
        },
        moduleParsed({ id, meta: { commonjs: commonjsMeta } }) {
          if (commonjsMeta && commonjsMeta.isCommonJS != null) {
            setCommonJSMetaPromise(commonJsMetaPromises, id, commonjsMeta);
            return;
          }
          setCommonJSMetaPromise(commonJsMetaPromises, id, null);
        }
      };
    }
    module2.exports = commonjs;
  }
});

// node_modules/builtin-modules/index.js
var require_builtin_modules = __commonJS({
  "node_modules/builtin-modules/index.js"(exports2, module2) {
    "use strict";
    var { builtinModules } = require("module");
    var ignoreList = [
      "sys"
    ];
    module2.exports = (builtinModules || (process.binding ? Object.keys(process.binding("natives")) : []) || []).filter((x) => !/^_|^(internal|v8|node-inspect)\/|\//.test(x) && !ignoreList.includes(x)).sort();
  }
});

// node_modules/deepmerge/dist/cjs.js
var require_cjs2 = __commonJS({
  "node_modules/deepmerge/dist/cjs.js"(exports2, module2) {
    "use strict";
    var isMergeableObject = function isMergeableObject2(value) {
      return isNonNullObject(value) && !isSpecial(value);
    };
    function isNonNullObject(value) {
      return !!value && typeof value === "object";
    }
    function isSpecial(value) {
      var stringValue = Object.prototype.toString.call(value);
      return stringValue === "[object RegExp]" || stringValue === "[object Date]" || isReactElement(value);
    }
    var canUseSymbol = typeof Symbol === "function" && Symbol.for;
    var REACT_ELEMENT_TYPE = canUseSymbol ? Symbol.for("react.element") : 60103;
    function isReactElement(value) {
      return value.$$typeof === REACT_ELEMENT_TYPE;
    }
    function emptyTarget(val) {
      return Array.isArray(val) ? [] : {};
    }
    function cloneUnlessOtherwiseSpecified(value, options) {
      return options.clone !== false && options.isMergeableObject(value) ? deepmerge(emptyTarget(value), value, options) : value;
    }
    function defaultArrayMerge(target, source, options) {
      return target.concat(source).map(function(element) {
        return cloneUnlessOtherwiseSpecified(element, options);
      });
    }
    function getMergeFunction(key, options) {
      if (!options.customMerge) {
        return deepmerge;
      }
      var customMerge = options.customMerge(key);
      return typeof customMerge === "function" ? customMerge : deepmerge;
    }
    function getEnumerableOwnPropertySymbols(target) {
      return Object.getOwnPropertySymbols ? Object.getOwnPropertySymbols(target).filter(function(symbol) {
        return Object.propertyIsEnumerable.call(target, symbol);
      }) : [];
    }
    function getKeys(target) {
      return Object.keys(target).concat(getEnumerableOwnPropertySymbols(target));
    }
    function propertyIsOnObject(object, property2) {
      try {
        return property2 in object;
      } catch (_) {
        return false;
      }
    }
    function propertyIsUnsafe(target, key) {
      return propertyIsOnObject(target, key) && !(Object.hasOwnProperty.call(target, key) && Object.propertyIsEnumerable.call(target, key));
    }
    function mergeObject(target, source, options) {
      var destination = {};
      if (options.isMergeableObject(target)) {
        getKeys(target).forEach(function(key) {
          destination[key] = cloneUnlessOtherwiseSpecified(target[key], options);
        });
      }
      getKeys(source).forEach(function(key) {
        if (propertyIsUnsafe(target, key)) {
          return;
        }
        if (propertyIsOnObject(target, key) && options.isMergeableObject(source[key])) {
          destination[key] = getMergeFunction(key, options)(target[key], source[key], options);
        } else {
          destination[key] = cloneUnlessOtherwiseSpecified(source[key], options);
        }
      });
      return destination;
    }
    function deepmerge(target, source, options) {
      options = options || {};
      options.arrayMerge = options.arrayMerge || defaultArrayMerge;
      options.isMergeableObject = options.isMergeableObject || isMergeableObject;
      options.cloneUnlessOtherwiseSpecified = cloneUnlessOtherwiseSpecified;
      var sourceIsArray = Array.isArray(source);
      var targetIsArray = Array.isArray(target);
      var sourceAndTargetTypesMatch = sourceIsArray === targetIsArray;
      if (!sourceAndTargetTypesMatch) {
        return cloneUnlessOtherwiseSpecified(source, options);
      } else if (sourceIsArray) {
        return options.arrayMerge(target, source, options);
      } else {
        return mergeObject(target, source, options);
      }
    }
    deepmerge.all = function deepmergeAll(array, options) {
      if (!Array.isArray(array)) {
        throw new Error("first argument should be an array");
      }
      return array.reduce(function(prev, next) {
        return deepmerge(prev, next, options);
      }, {});
    };
    var deepmerge_1 = deepmerge;
    module2.exports = deepmerge_1;
  }
});

// node_modules/is-module/index.js
var require_is_module = __commonJS({
  "node_modules/is-module/index.js"(exports2, module2) {
    var ES6ImportExportRegExp = /(?:^\s*|[}{\(\);,\n]\s*)(import\s+['"]|(import|module)\s+[^"'\(\)\n;]+\s+from\s+['"]|export\s+(\*|\{|default|function|var|const|let|[_$a-zA-Z\xA0-\uFFFF][_$a-zA-Z0-9\xA0-\uFFFF]*))/;
    var ES6AliasRegExp = /(?:^\s*|[}{\(\);,\n]\s*)(export\s*\*\s*from\s*(?:'([^']+)'|"([^"]+)"))/;
    module2.exports = function(sauce) {
      return ES6ImportExportRegExp.test(sauce) || ES6AliasRegExp.test(sauce);
    };
  }
});

// node_modules/rollup/dist/es/shared/rollup.js
function decode2(mappings) {
  var decoded = [];
  var line = [];
  var segment = [
    0,
    0,
    0,
    0,
    0
  ];
  var j = 0;
  for (var i = 0, shift = 0, value = 0; i < mappings.length; i++) {
    var c = mappings.charCodeAt(i);
    if (c === 44) {
      segmentify(line, segment, j);
      j = 0;
    } else if (c === 59) {
      segmentify(line, segment, j);
      j = 0;
      decoded.push(line);
      line = [];
      segment[0] = 0;
    } else {
      var integer = charToInteger[c];
      if (integer === void 0) {
        throw new Error("Invalid character (" + String.fromCharCode(c) + ")");
      }
      var hasContinuationBit = integer & 32;
      integer &= 31;
      value += integer << shift;
      if (hasContinuationBit) {
        shift += 5;
      } else {
        var shouldNegate = value & 1;
        value >>>= 1;
        if (shouldNegate) {
          value = value === 0 ? -2147483648 : -value;
        }
        segment[j] += value;
        j++;
        value = shift = 0;
      }
    }
  }
  segmentify(line, segment, j);
  decoded.push(line);
  return decoded;
}
function segmentify(line, segment, j) {
  if (j === 4)
    line.push([segment[0], segment[1], segment[2], segment[3]]);
  else if (j === 5)
    line.push([segment[0], segment[1], segment[2], segment[3], segment[4]]);
  else if (j === 1)
    line.push([segment[0]]);
}
function encode2(decoded) {
  var sourceFileIndex = 0;
  var sourceCodeLine = 0;
  var sourceCodeColumn = 0;
  var nameIndex = 0;
  var mappings = "";
  for (var i = 0; i < decoded.length; i++) {
    var line = decoded[i];
    if (i > 0)
      mappings += ";";
    if (line.length === 0)
      continue;
    var generatedCodeColumn = 0;
    var lineMappings = [];
    for (var _i = 0, line_1 = line; _i < line_1.length; _i++) {
      var segment = line_1[_i];
      var segmentMappings = encodeInteger2(segment[0] - generatedCodeColumn);
      generatedCodeColumn = segment[0];
      if (segment.length > 1) {
        segmentMappings += encodeInteger2(segment[1] - sourceFileIndex) + encodeInteger2(segment[2] - sourceCodeLine) + encodeInteger2(segment[3] - sourceCodeColumn);
        sourceFileIndex = segment[1];
        sourceCodeLine = segment[2];
        sourceCodeColumn = segment[3];
      }
      if (segment.length === 5) {
        segmentMappings += encodeInteger2(segment[4] - nameIndex);
        nameIndex = segment[4];
      }
      lineMappings.push(segmentMappings);
    }
    mappings += lineMappings.join(",");
  }
  return mappings;
}
function encodeInteger2(num) {
  var result2 = "";
  num = num < 0 ? -num << 1 | 1 : num << 1;
  do {
    var clamped = num & 31;
    num >>>= 5;
    if (num > 0) {
      clamped |= 32;
    }
    result2 += chars$1[clamped];
  } while (num > 0);
  return result2;
}
function guessIndent2(code) {
  var lines = code.split("\n");
  var tabbed = lines.filter(function(line) {
    return /^\t+/.test(line);
  });
  var spaced = lines.filter(function(line) {
    return /^ {2,}/.test(line);
  });
  if (tabbed.length === 0 && spaced.length === 0) {
    return null;
  }
  if (tabbed.length >= spaced.length) {
    return "	";
  }
  var min = spaced.reduce(function(previous, current2) {
    var numSpaces = /^ +/.exec(current2)[0].length;
    return Math.min(numSpaces, previous);
  }, Infinity);
  return new Array(min + 1).join(" ");
}
function getRelativePath2(from, to) {
  var fromParts = from.split(/[/\\]/);
  var toParts = to.split(/[/\\]/);
  fromParts.pop();
  while (fromParts[0] === toParts[0]) {
    fromParts.shift();
    toParts.shift();
  }
  if (fromParts.length) {
    var i = fromParts.length;
    while (i--) {
      fromParts[i] = "..";
    }
  }
  return fromParts.concat(toParts).join("/");
}
function isObject3(thing) {
  return toString$1.call(thing) === "[object Object]";
}
function getLocator$1(source) {
  var originalLines = source.split("\n");
  var lineOffsets = [];
  for (var i = 0, pos = 0; i < originalLines.length; i++) {
    lineOffsets.push(pos);
    pos += originalLines[i].length + 1;
  }
  return function locate2(index2) {
    var i2 = 0;
    var j = lineOffsets.length;
    while (i2 < j) {
      var m = i2 + j >> 1;
      if (index2 < lineOffsets[m]) {
        j = m;
      } else {
        i2 = m + 1;
      }
    }
    var line = i2 - 1;
    var column = index2 - lineOffsets[line];
    return { line, column };
  };
}
function relative3(from, to) {
  const fromParts = from.split(/[/\\]/).filter(Boolean);
  const toParts = to.split(/[/\\]/).filter(Boolean);
  if (fromParts[0] === ".")
    fromParts.shift();
  if (toParts[0] === ".")
    toParts.shift();
  while (fromParts[0] && toParts[0] && fromParts[0] === toParts[0]) {
    fromParts.shift();
    toParts.shift();
  }
  while (toParts[0] === ".." && fromParts.length > 0) {
    toParts.shift();
    fromParts.pop();
  }
  while (fromParts.pop()) {
    toParts.unshift("..");
  }
  return toParts.join("/");
}
function getOrCreate(map2, key, init) {
  const existing = map2.get(key);
  if (existing) {
    return existing;
  }
  const value = init();
  map2.set(key, value);
  return value;
}
function isLegal(str) {
  if (startsWithDigit(str) || blacklisted.has(str)) {
    return false;
  }
  return !illegalCharacters.test(str);
}
function makeLegal(str) {
  str = str.replace(/-(\w)/g, (_, letter) => letter.toUpperCase()).replace(illegalCharacters, "_");
  if (startsWithDigit(str) || blacklisted.has(str))
    str = `_${str}`;
  return str || "_";
}
function isAbsolute3(path6) {
  return absolutePath.test(path6);
}
function isRelative(path6) {
  return relativePath.test(path6);
}
function normalize2(path6) {
  if (path6.indexOf("\\") == -1)
    return path6;
  return path6.replace(/\\/g, "/");
}
function printQuotedStringList(list, verbs) {
  const isSingleItem = list.length <= 1;
  const quotedList = list.map((item) => `"${item}"`);
  let output = isSingleItem ? quotedList[0] : `${quotedList.slice(0, -1).join(", ")} and ${quotedList.slice(-1)[0]}`;
  if (verbs) {
    output += ` ${isSingleItem ? verbs[0] : verbs[1]}`;
  }
  return output;
}
function getAliasName(id) {
  const base2 = (0, import_path11.basename)(id);
  return base2.substr(0, base2.length - (0, import_path11.extname)(id).length);
}
function relativeId(id) {
  if (!isAbsolute3(id))
    return id;
  return (0, import_path11.relative)((0, import_path11.resolve)(), id);
}
function isPathFragment(name) {
  return name[0] === "/" || name[0] === "." && (name[1] === "/" || name[1] === ".") || isAbsolute3(name);
}
function getLocator2(source, options) {
  if (options === void 0) {
    options = {};
  }
  var offsetLine = options.offsetLine || 0;
  var offsetColumn = options.offsetColumn || 0;
  var originalLines = source.split("\n");
  var start = 0;
  var lineRanges = originalLines.map(function(line, i2) {
    var end = start + line.length + 1;
    var range = { start, end, line: i2 };
    start = end;
    return range;
  });
  var i = 0;
  function rangeContains(range, index2) {
    return range.start <= index2 && index2 < range.end;
  }
  function getLocation(range, index2) {
    return { line: offsetLine + range.line, column: offsetColumn + index2 - range.start, character: index2 };
  }
  function locate2(search, startIndex) {
    if (typeof search === "string") {
      search = source.indexOf(search, startIndex || 0);
    }
    var range = lineRanges[i];
    var d = search >= range.end ? 1 : -1;
    while (range) {
      if (rangeContains(range, search))
        return getLocation(range, search);
      i += d;
      range = lineRanges[i];
    }
  }
  return locate2;
}
function locate(source, search, options) {
  if (typeof options === "number") {
    throw new Error("locate takes a { startIndex, offsetLine, offsetColumn } object as the third argument");
  }
  return getLocator2(source, options)(search, options && options.startIndex);
}
function createInclusionContext() {
  return {
    brokenFlow: BROKEN_FLOW_NONE,
    includedCallArguments: /* @__PURE__ */ new Set(),
    includedLabels: /* @__PURE__ */ new Set()
  };
}
function createHasEffectsContext() {
  return {
    accessed: new PathTracker(),
    assigned: new PathTracker(),
    brokenFlow: BROKEN_FLOW_NONE,
    called: new DiscriminatedPathTracker(),
    ignore: {
      breaks: false,
      continues: false,
      labels: /* @__PURE__ */ new Set(),
      returnYield: false
    },
    includedLabels: /* @__PURE__ */ new Set(),
    instantiated: new DiscriminatedPathTracker(),
    replacedVariableInits: /* @__PURE__ */ new Map()
  };
}
function skipThrough(node, st, c) {
  c(node, st);
}
function ignore(_node, _st, _c) {
}
function handlePureAnnotationsOfNode(node, state, type = node.type) {
  const { annotations } = state;
  let comment = annotations[state.annotationIndex];
  while (comment && node.start >= comment.end) {
    markPureNode(node, comment, state.code);
    comment = annotations[++state.annotationIndex];
  }
  if (comment && comment.end <= node.end) {
    base$1[type](node, state, handlePureAnnotationsOfNode);
    while ((comment = annotations[state.annotationIndex]) && comment.end <= node.end) {
      ++state.annotationIndex;
      annotateNode(node, comment, false);
    }
  }
}
function markPureNode(node, comment, code) {
  const annotatedNodes = [];
  let invalidAnnotation;
  const codeInBetween = code.slice(comment.end, node.start);
  if (doesNotMatchOutsideComment(codeInBetween, neitherWithespaceNorBrackets)) {
    const parentStart = node.start;
    while (true) {
      annotatedNodes.push(node);
      switch (node.type) {
        case ExpressionStatement$1:
        case ChainExpression$1:
          node = node.expression;
          continue;
        case SequenceExpression$1:
          if (doesNotMatchOutsideComment(code.slice(parentStart, node.start), noWhitespace)) {
            node = node.expressions[0];
            continue;
          }
          invalidAnnotation = true;
          break;
        case ConditionalExpression$1:
          if (doesNotMatchOutsideComment(code.slice(parentStart, node.start), noWhitespace)) {
            node = node.test;
            continue;
          }
          invalidAnnotation = true;
          break;
        case LogicalExpression$1:
        case BinaryExpression$1:
          if (doesNotMatchOutsideComment(code.slice(parentStart, node.start), noWhitespace)) {
            node = node.left;
            continue;
          }
          invalidAnnotation = true;
          break;
        case CallExpression$1:
        case NewExpression$1:
          break;
        default:
          invalidAnnotation = true;
      }
      break;
    }
  } else {
    invalidAnnotation = true;
  }
  if (invalidAnnotation) {
    annotateNode(node, comment, false);
  } else {
    for (const node2 of annotatedNodes) {
      annotateNode(node2, comment, true);
    }
  }
}
function doesNotMatchOutsideComment(code, forbiddenChars) {
  let nextMatch;
  while ((nextMatch = forbiddenChars.exec(code)) !== null) {
    if (nextMatch[0] === "/") {
      const charCodeAfterSlash = code.charCodeAt(forbiddenChars.lastIndex);
      if (charCodeAfterSlash === 42) {
        forbiddenChars.lastIndex = code.indexOf("*/", forbiddenChars.lastIndex + 1) + 2;
        continue;
      } else if (charCodeAfterSlash === 47) {
        forbiddenChars.lastIndex = code.indexOf("\n", forbiddenChars.lastIndex + 1) + 1;
        continue;
      }
    }
    forbiddenChars.lastIndex = 0;
    return false;
  }
  return true;
}
function addAnnotations(comments, esTreeAst, code) {
  const annotations = [];
  const sourceMappingComments = [];
  for (const comment of comments) {
    if (pureCommentRegex.test(comment.value)) {
      annotations.push(comment);
    } else if (SOURCEMAPPING_URL_RE.test(comment.value)) {
      sourceMappingComments.push(comment);
    }
  }
  for (const comment of sourceMappingComments) {
    annotateNode(esTreeAst, comment, false);
  }
  handlePureAnnotationsOfNode(esTreeAst, {
    annotationIndex: 0,
    annotations,
    code
  });
}
function annotateNode(node, comment, valid) {
  const key = valid ? ANNOTATION_KEY : INVALID_COMMENT_KEY;
  const property2 = node[key];
  if (property2) {
    property2.push(comment);
  } else {
    node[key] = [comment];
  }
}
function getAndCreateKeys(esTreeNode) {
  keys[esTreeNode.type] = Object.keys(esTreeNode).filter(
    (key) => typeof esTreeNode[key] === "object" && key.charCodeAt(0) !== 95
    /* _ */
  );
  return keys[esTreeNode.type];
}
function treeshakeNode(node, code, start, end) {
  code.remove(start, end);
  if (node.annotations) {
    for (const annotation of node.annotations) {
      if (annotation.start < start) {
        code.remove(annotation.start, annotation.end);
      } else {
        return;
      }
    }
  }
}
function removeAnnotations(node, code) {
  if (!node.annotations && node.parent.type === ExpressionStatement$1) {
    node = node.parent;
  }
  if (node.annotations) {
    for (const annotation of node.annotations) {
      code.remove(annotation.start, annotation.end);
    }
  }
}
function findFirstOccurrenceOutsideComment(code, searchString, start = 0) {
  let searchPos, charCodeAfterSlash;
  searchPos = code.indexOf(searchString, start);
  while (true) {
    start = code.indexOf("/", start);
    if (start === -1 || start >= searchPos)
      return searchPos;
    charCodeAfterSlash = code.charCodeAt(++start);
    ++start;
    start = charCodeAfterSlash === 47 ? code.indexOf("\n", start) + 1 : code.indexOf("*/", start) + 2;
    if (start > searchPos) {
      searchPos = code.indexOf(searchString, start);
    }
  }
}
function findNonWhiteSpace(code, index2) {
  NON_WHITESPACE.lastIndex = index2;
  const result2 = NON_WHITESPACE.exec(code);
  return result2.index;
}
function findFirstLineBreakOutsideComment(code) {
  let lineBreakPos, charCodeAfterSlash, start = 0;
  lineBreakPos = code.indexOf("\n", start);
  while (true) {
    start = code.indexOf("/", start);
    if (start === -1 || start > lineBreakPos)
      return [lineBreakPos, lineBreakPos + 1];
    charCodeAfterSlash = code.charCodeAt(start + 1);
    if (charCodeAfterSlash === 47)
      return [start, lineBreakPos + 1];
    start = code.indexOf("*/", start + 3) + 2;
    if (start > lineBreakPos) {
      lineBreakPos = code.indexOf("\n", start);
    }
  }
}
function renderStatementList(statements, code, start, end, options) {
  let currentNode, currentNodeStart, currentNodeNeedsBoundaries, nextNodeStart;
  let nextNode = statements[0];
  let nextNodeNeedsBoundaries = !nextNode.included || nextNode.needsBoundaries;
  if (nextNodeNeedsBoundaries) {
    nextNodeStart = start + findFirstLineBreakOutsideComment(code.original.slice(start, nextNode.start))[1];
  }
  for (let nextIndex2 = 1; nextIndex2 <= statements.length; nextIndex2++) {
    currentNode = nextNode;
    currentNodeStart = nextNodeStart;
    currentNodeNeedsBoundaries = nextNodeNeedsBoundaries;
    nextNode = statements[nextIndex2];
    nextNodeNeedsBoundaries = nextNode === void 0 ? false : !nextNode.included || nextNode.needsBoundaries;
    if (currentNodeNeedsBoundaries || nextNodeNeedsBoundaries) {
      nextNodeStart = currentNode.end + findFirstLineBreakOutsideComment(code.original.slice(currentNode.end, nextNode === void 0 ? end : nextNode.start))[1];
      if (currentNode.included) {
        currentNodeNeedsBoundaries ? currentNode.render(code, options, {
          end: nextNodeStart,
          start: currentNodeStart
        }) : currentNode.render(code, options);
      } else {
        treeshakeNode(currentNode, code, currentNodeStart, nextNodeStart);
      }
    } else {
      currentNode.render(code, options);
    }
  }
}
function getCommaSeparatedNodesWithBoundaries(nodes, code, start, end) {
  const splitUpNodes = [];
  let node, nextNode, nextNodeStart, contentEnd, char;
  let separator = start - 1;
  for (let nextIndex2 = 0; nextIndex2 < nodes.length; nextIndex2++) {
    nextNode = nodes[nextIndex2];
    if (node !== void 0) {
      separator = node.end + findFirstOccurrenceOutsideComment(code.original.slice(node.end, nextNode.start), ",");
    }
    nextNodeStart = contentEnd = separator + 1 + findFirstLineBreakOutsideComment(code.original.slice(separator + 1, nextNode.start))[1];
    while (char = code.original.charCodeAt(nextNodeStart), char === 32 || char === 9 || char === 10 || char === 13)
      nextNodeStart++;
    if (node !== void 0) {
      splitUpNodes.push({
        contentEnd,
        end: nextNodeStart,
        node,
        separator,
        start
      });
    }
    node = nextNode;
    start = nextNodeStart;
  }
  splitUpNodes.push({
    contentEnd: end,
    end,
    node,
    separator: null,
    start
  });
  return splitUpNodes;
}
function removeLineBreaks(code, start, end) {
  while (true) {
    const [removeStart, removeEnd] = findFirstLineBreakOutsideComment(code.original.slice(start, end));
    if (removeStart === -1) {
      break;
    }
    code.remove(start + removeStart, start += removeEnd);
  }
}
function getSystemExportStatement(exportedVariables, { compact, exportNamesByVariable }, modifier = "") {
  const _ = compact ? "" : " ";
  if (exportedVariables.length === 1 && exportNamesByVariable.get(exportedVariables[0]).length === 1) {
    const variable = exportedVariables[0];
    return `exports('${exportNamesByVariable.get(variable)}',${_}${variable.getName()}${modifier})`;
  } else {
    return `exports({${_}${exportedVariables.map((variable) => {
      return exportNamesByVariable.get(variable).map((exportName) => `${exportName}:${_}${variable.getName()}${modifier}`).join(`,${_}`);
    }).join(`,${_}`)}${_}})`;
  }
}
function renderSystemExportExpression(exportedVariable, expressionStart, expressionEnd, code, { compact, exportNamesByVariable }) {
  const _ = compact ? "" : " ";
  code.prependRight(expressionStart, `exports('${exportNamesByVariable.get(exportedVariable)}',${_}`);
  code.appendLeft(expressionEnd, ")");
}
function renderSystemExportFunction(exportedVariables, expressionStart, expressionEnd, needsParens, code, options) {
  const _ = options.compact ? "" : " ";
  const s = options.compact ? "" : ";";
  code.prependRight(expressionStart, `function${_}(v)${_}{${_}return ${getSystemExportStatement(exportedVariables, options)},${_}v${s}${_}}(`);
  code.appendLeft(expressionEnd, ")");
  if (needsParens) {
    code.prependRight(expressionStart, "(");
    code.appendLeft(expressionEnd, ")");
  }
}
function renderSystemExportSequenceAfterExpression(exportedVariable, expressionStart, expressionEnd, needsParens, code, options) {
  const _ = options.compact ? "" : " ";
  code.appendLeft(expressionEnd, `,${_}${getSystemExportStatement([exportedVariable], options)},${_}${exportedVariable.getName()}`);
  if (needsParens) {
    code.prependRight(expressionStart, "(");
    code.appendLeft(expressionEnd, ")");
  }
}
function renderSystemExportSequenceBeforeExpression(exportedVariable, expressionStart, expressionEnd, needsParens, code, options, modifier) {
  const _ = options.compact ? "" : " ";
  code.prependRight(expressionStart, `${getSystemExportStatement([exportedVariable], options, modifier)},${_}`);
  if (needsParens) {
    code.prependRight(expressionStart, "(");
    code.appendLeft(expressionEnd, ")");
  }
}
function toBase64(num) {
  let outStr = "";
  do {
    const curDigit = num % base;
    num = Math.floor(num / base);
    outStr = chars2[curDigit] + outStr;
  } while (num !== 0);
  return outStr;
}
function getSafeName(baseName, usedNames) {
  let safeName = baseName;
  let count = 1;
  while (usedNames.has(safeName) || RESERVED_NAMES[safeName]) {
    safeName = `${baseName}$${toBase64(count++)}`;
  }
  usedNames.add(safeName);
  return safeName;
}
function assembleMemberDescriptions(memberDescriptions, inheritedDescriptions = null) {
  return Object.create(inheritedDescriptions, memberDescriptions);
}
function getLiteralMembersForValue(value) {
  switch (typeof value) {
    case "boolean":
      return literalBooleanMembers;
    case "number":
      return literalNumberMembers;
    case "string":
      return literalStringMembers;
    default:
      return /* @__PURE__ */ Object.create(null);
  }
}
function hasMemberEffectWhenCalled(members, memberName, callOptions, context) {
  if (typeof memberName !== "string" || !members[memberName]) {
    return true;
  }
  if (!members[memberName].callsArgs)
    return false;
  for (const argIndex of members[memberName].callsArgs) {
    if (callOptions.args[argIndex] && callOptions.args[argIndex].hasEffectsWhenCalledAtPath(EMPTY_PATH, {
      args: NO_ARGS,
      thisParam: null,
      withNew: false
    }, context))
      return true;
  }
  return false;
}
function getMemberReturnExpressionWhenCalled(members, memberName) {
  if (typeof memberName !== "string" || !members[memberName])
    return UNKNOWN_EXPRESSION;
  return members[memberName].returns;
}
function is_reference(node, parent) {
  if (node.type === "MemberExpression") {
    return !node.computed && is_reference(node.object, node);
  }
  if (node.type === "Identifier") {
    if (!parent) return true;
    switch (parent.type) {
      case "MemberExpression":
        return parent.computed || node === parent.object;
      case "MethodDefinition":
        return parent.computed;
      case "PropertyDefinition":
        return parent.computed || node === parent.value;
      case "Property":
        return parent.computed || node === parent.value;
      case "ExportSpecifier":
      case "ImportSpecifier":
        return node === parent.local;
      case "LabeledStatement":
      case "BreakStatement":
      case "ContinueStatement":
        return false;
      default:
        return true;
    }
  }
  return false;
}
function getGlobalAtPath(path6) {
  let currentGlobal = knownGlobals;
  for (const pathSegment of path6) {
    if (typeof pathSegment !== "string") {
      return null;
    }
    currentGlobal = currentGlobal[pathSegment];
    if (!currentGlobal) {
      return null;
    }
  }
  return currentGlobal[ValueProperties];
}
function isPureGlobal(path6) {
  const globalAtPath = getGlobalAtPath(path6);
  return globalAtPath !== null && globalAtPath.pure;
}
function isGlobalMember(path6) {
  if (path6.length === 1) {
    return path6[0] === "undefined" || getGlobalAtPath(path6) !== null;
  }
  return getGlobalAtPath(path6.slice(0, -1)) !== null;
}
function closestParentFunctionOrProgram(node) {
  while (node && !/^Program|Function/.test(node.type)) {
    node = node.parent;
  }
  return node;
}
function getDeclarationStart(code, start) {
  return findNonWhiteSpace(code, findFirstOccurrenceOutsideComment(code, "default", start) + 7);
}
function getIdInsertPosition(code, declarationKeyword, endMarker, start) {
  const declarationEnd = findFirstOccurrenceOutsideComment(code, declarationKeyword, start) + declarationKeyword.length;
  code = code.slice(declarationEnd, findFirstOccurrenceOutsideComment(code, endMarker, declarationEnd));
  const generatorStarPos = findFirstOccurrenceOutsideComment(code, "*");
  if (generatorStarPos === -1) {
    return declarationEnd;
  }
  return declarationEnd + generatorStarPos + 1;
}
function isReassignedExportsMember(variable, exportNamesByVariable) {
  return variable.renderBaseName !== null && exportNamesByVariable.has(variable) && variable.isReassigned;
}
function areAllDeclarationsIncludedAndNotExported(declarations, exportNamesByVariable) {
  for (const declarator of declarations) {
    if (!declarator.id.included)
      return false;
    if (declarator.id.type === Identifier$1) {
      if (exportNamesByVariable.has(declarator.id.variable))
        return false;
    } else {
      const exportedVariables = [];
      declarator.id.addExportedVariables(exportedVariables, exportNamesByVariable);
      if (exportedVariables.length > 0)
        return false;
    }
  }
  return true;
}
function gatherSystemExportsAndGetSingleExport(separatedNodes, options, aggregatedSystemExports) {
  var _a;
  let singleSystemExport = null;
  if (options.format === "system") {
    for (const { node } of separatedNodes) {
      if (node.id instanceof Identifier && node.init && aggregatedSystemExports.length === 0 && ((_a = options.exportNamesByVariable.get(node.id.variable)) === null || _a === void 0 ? void 0 : _a.length) === 1) {
        singleSystemExport = node.id.variable;
        aggregatedSystemExports.push(singleSystemExport);
      } else {
        node.id.addExportedVariables(aggregatedSystemExports, options.exportNamesByVariable);
      }
    }
    if (aggregatedSystemExports.length > 1) {
      singleSystemExport = null;
    } else if (singleSystemExport) {
      aggregatedSystemExports.length = 0;
    }
  }
  return singleSystemExport;
}
function getResolvablePropertyKey(memberExpression) {
  return memberExpression.computed ? getResolvableComputedPropertyKey(memberExpression.property) : memberExpression.property.name;
}
function getResolvableComputedPropertyKey(propertyKey) {
  if (propertyKey instanceof Literal) {
    return String(propertyKey.value);
  }
  return null;
}
function getPathIfNotComputed(memberExpression) {
  const nextPathKey = memberExpression.propertyKey;
  const object = memberExpression.object;
  if (typeof nextPathKey === "string") {
    if (object instanceof Identifier) {
      return [
        { key: object.name, pos: object.start },
        { key: nextPathKey, pos: memberExpression.property.start }
      ];
    }
    if (object instanceof MemberExpression) {
      const parentPath = getPathIfNotComputed(object);
      return parentPath && [...parentPath, { key: nextPathKey, pos: memberExpression.property.start }];
    }
  }
  return null;
}
function getStringFromPath(path6) {
  let pathString = path6[0].key;
  for (let index2 = 1; index2 < path6.length; index2++) {
    pathString += "." + path6[index2].key;
  }
  return pathString;
}
function isDefaultAProperty(interopType, externalLiveBindings) {
  return interopType === "esModule" || externalLiveBindings && (interopType === "auto" || interopType === "true");
}
function canDefaultBeTakenFromNamespace(interopType, externalLiveBindings) {
  return isDefaultAProperty(interopType, externalLiveBindings) && defaultInteropHelpersByInteropType[interopType] === INTEROP_DEFAULT_VARIABLE;
}
function getDefaultOnlyHelper() {
  return INTEROP_NAMESPACE_DEFAULT_ONLY_VARIABLE;
}
function getHelpersBlock(usedHelpers, accessedGlobals, _, n3, s, t, liveBindings, freeze, namespaceToStringTag) {
  return HELPER_NAMES.map((variable) => usedHelpers.has(variable) || accessedGlobals.has(variable) ? HELPER_GENERATORS[variable](_, n3, s, t, liveBindings, freeze, namespaceToStringTag, usedHelpers) : "").join("");
}
function getDefaultLiveBinding(_) {
  return `e${_}:${_}{${_}'default':${_}e${_}}`;
}
function getDefaultStatic(_) {
  return `e['default']${_}:${_}e`;
}
function createNamespaceObject(_, n3, t, i, liveBindings, freeze, namespaceToStringTag) {
  return `${i}var n${_}=${_}${namespaceToStringTag ? `{__proto__:${_}null,${_}[Symbol.toStringTag]:${_}'Module'}` : "Object.create(null)"};${n3}${i}if${_}(e)${_}{${n3}${i}${t}Object.keys(e).forEach(function${_}(k)${_}{${n3}` + (liveBindings ? copyPropertyLiveBinding : copyPropertyStatic)(_, n3, t, i + t + t) + `${i}${t}});${n3}${i}}${n3}${i}n['default']${_}=${_}e;${n3}${i}return ${getFrozen("n", freeze)};${n3}`;
}
function copyPropertyLiveBinding(_, n3, t, i) {
  return `${i}if${_}(k${_}!==${_}'default')${_}{${n3}${i}${t}var d${_}=${_}Object.getOwnPropertyDescriptor(e,${_}k);${n3}${i}${t}Object.defineProperty(n,${_}k,${_}d.get${_}?${_}d${_}:${_}{${n3}${i}${t}${t}enumerable:${_}true,${n3}${i}${t}${t}get:${_}function${_}()${_}{${n3}${i}${t}${t}${t}return e[k];${n3}${i}${t}${t}}${n3}${i}${t}});${n3}${i}}${n3}`;
}
function copyPropertyStatic(_, n3, _t, i) {
  return `${i}n[k]${_}=${_}e[k];${n3}`;
}
function getFrozen(fragment, freeze) {
  return freeze ? `Object.freeze(${fragment})` : fragment;
}
function getInteropHelper(resolution, exportMode, interop) {
  return exportMode === "external" ? namespaceInteropHelpersByInteropType[String(interop(resolution instanceof ExternalModule ? resolution.id : null))] : exportMode === "default" ? getDefaultOnlyHelper() : null;
}
function spaces(i) {
  let result2 = "";
  while (i--)
    result2 += " ";
  return result2;
}
function tabsToSpaces(str) {
  return str.replace(/^\t+/, (match2) => match2.split("	").join("  "));
}
function getCodeFrame(source, line, column) {
  let lines = source.split("\n");
  const frameStart = Math.max(0, line - 3);
  let frameEnd = Math.min(line + 2, lines.length);
  lines = lines.slice(frameStart, frameEnd);
  while (!/\S/.test(lines[lines.length - 1])) {
    lines.pop();
    frameEnd -= 1;
  }
  const digits = String(frameEnd).length;
  return lines.map((str, i) => {
    const isErrorLine = frameStart + i + 1 === line;
    let lineNum = String(i + frameStart + 1);
    while (lineNum.length < digits)
      lineNum = ` ${lineNum}`;
    if (isErrorLine) {
      const indicator = spaces(digits + 2 + tabsToSpaces(str.slice(0, column)).length) + "^";
      return `${lineNum}: ${tabsToSpaces(str)}
${indicator}`;
    }
    return `${lineNum}: ${tabsToSpaces(str)}`;
  }).join("\n");
}
function error(base2) {
  if (!(base2 instanceof Error))
    base2 = Object.assign(new Error(base2.message), base2);
  throw base2;
}
function augmentCodeLocation(props, pos, source, id) {
  if (typeof pos === "object") {
    const { line, column } = pos;
    props.loc = { column, file: id, line };
  } else {
    props.pos = pos;
    const { line, column } = locate(source, pos, { offsetLine: 1 });
    props.loc = { column, file: id, line };
  }
  if (props.frame === void 0) {
    const { line, column } = props.loc;
    props.frame = getCodeFrame(source, line, column);
  }
}
function errAssetNotFinalisedForFileName(name) {
  return {
    code: Errors.ASSET_NOT_FINALISED,
    message: `Plugin error - Unable to get file name for asset "${name}". Ensure that the source is set and that generate is called first.`
  };
}
function errCannotEmitFromOptionsHook() {
  return {
    code: Errors.CANNOT_EMIT_FROM_OPTIONS_HOOK,
    message: `Cannot emit files or set asset sources in the "outputOptions" hook, use the "renderStart" hook instead.`
  };
}
function errChunkNotGeneratedForFileName(name) {
  return {
    code: Errors.CHUNK_NOT_GENERATED,
    message: `Plugin error - Unable to get file name for chunk "${name}". Ensure that generate is called first.`
  };
}
function errChunkInvalid({ fileName, code }, exception) {
  const errorProps = {
    code: Errors.CHUNK_INVALID,
    message: `Chunk "${fileName}" is not valid JavaScript: ${exception.message}.`
  };
  augmentCodeLocation(errorProps, exception.loc, code, fileName);
  return errorProps;
}
function errCircularReexport(exportName, importedModule) {
  return {
    code: Errors.CIRCULAR_REEXPORT,
    id: importedModule,
    message: `"${exportName}" cannot be exported from ${relativeId(importedModule)} as it is a reexport that references itself.`
  };
}
function errCyclicCrossChunkReexport(exportName, exporter, reexporter, importer) {
  return {
    code: Errors.CYCLIC_CROSS_CHUNK_REEXPORT,
    exporter,
    importer,
    message: `Export "${exportName}" of module ${relativeId(exporter)} was reexported through module ${relativeId(reexporter)} while both modules are dependencies of each other and will end up in different chunks by current Rollup settings. This scenario is not well supported at the moment as it will produce a circular dependency between chunks and will likely lead to broken execution order.
Either change the import in ${relativeId(importer)} to point directly to the exporting module or do not use "preserveModules" to ensure these modules end up in the same chunk.`,
    reexporter
  };
}
function errAssetReferenceIdNotFoundForSetSource(assetReferenceId) {
  return {
    code: Errors.ASSET_NOT_FOUND,
    message: `Plugin error - Unable to set the source for unknown asset "${assetReferenceId}".`
  };
}
function errAssetSourceAlreadySet(name) {
  return {
    code: Errors.ASSET_SOURCE_ALREADY_SET,
    message: `Unable to set the source for asset "${name}", source already set.`
  };
}
function errNoAssetSourceSet(assetName) {
  return {
    code: Errors.ASSET_SOURCE_MISSING,
    message: `Plugin error creating asset "${assetName}" - no asset source set.`
  };
}
function errBadLoader(id) {
  return {
    code: Errors.BAD_LOADER,
    message: `Error loading ${relativeId(id)}: plugin load hook should return a string, a { code, map } object, or nothing/null`
  };
}
function errDeprecation(deprecation) {
  return {
    code: Errors.DEPRECATED_FEATURE,
    ...typeof deprecation === "string" ? { message: deprecation } : deprecation
  };
}
function errFileReferenceIdNotFoundForFilename(assetReferenceId) {
  return {
    code: Errors.FILE_NOT_FOUND,
    message: `Plugin error - Unable to get file name for unknown file "${assetReferenceId}".`
  };
}
function errFileNameConflict(fileName) {
  return {
    code: Errors.FILE_NAME_CONFLICT,
    message: `The emitted file "${fileName}" overwrites a previously emitted file of the same name.`
  };
}
function errInputHookInOutputPlugin(pluginName, hookName) {
  return {
    code: Errors.INPUT_HOOK_IN_OUTPUT_PLUGIN,
    message: `The "${hookName}" hook used by the output plugin ${pluginName} is a build time hook and will not be run for that plugin. Either this plugin cannot be used as an output plugin, or it should have an option to configure it as an output plugin.`
  };
}
function errCannotAssignModuleToChunk(moduleId, assignToAlias, currentAlias) {
  return {
    code: Errors.INVALID_CHUNK,
    message: `Cannot assign ${relativeId(moduleId)} to the "${assignToAlias}" chunk as it is already in the "${currentAlias}" chunk.`
  };
}
function errInvalidExportOptionValue(optionValue) {
  return {
    code: Errors.INVALID_EXPORT_OPTION,
    message: `"output.exports" must be "default", "named", "none", "auto", or left unspecified (defaults to "auto"), received "${optionValue}"`,
    url: `https://rollupjs.org/guide/en/#outputexports`
  };
}
function errIncompatibleExportOptionValue(optionValue, keys2, entryModule) {
  return {
    code: "INVALID_EXPORT_OPTION",
    message: `"${optionValue}" was specified for "output.exports", but entry module "${relativeId(entryModule)}" has the following exports: ${keys2.join(", ")}`
  };
}
function errInternalIdCannotBeExternal(source, importer) {
  return {
    code: Errors.INVALID_EXTERNAL_ID,
    message: `'${source}' is imported as an external by ${relativeId(importer)}, but is already an existing non-external module id.`
  };
}
function errInvalidOption(option, explanation) {
  return {
    code: Errors.INVALID_OPTION,
    message: `Invalid value for option "${option}" - ${explanation}.`
  };
}
function errInvalidRollupPhaseForAddWatchFile() {
  return {
    code: Errors.INVALID_ROLLUP_PHASE,
    message: `Cannot call addWatchFile after the build has finished.`
  };
}
function errInvalidRollupPhaseForChunkEmission() {
  return {
    code: Errors.INVALID_ROLLUP_PHASE,
    message: `Cannot emit chunks after module loading has finished.`
  };
}
function errMissingExport(exportName, importingModule, importedModule) {
  return {
    code: Errors.MISSING_EXPORT,
    message: `'${exportName}' is not exported by ${relativeId(importedModule)}, imported by ${relativeId(importingModule)}`,
    url: `https://rollupjs.org/guide/en/#error-name-is-not-exported-by-module`
  };
}
function errImplicitDependantCannotBeExternal(unresolvedId, implicitlyLoadedBefore) {
  return {
    code: Errors.MISSING_IMPLICIT_DEPENDANT,
    message: `Module "${relativeId(unresolvedId)}" that should be implicitly loaded before "${relativeId(implicitlyLoadedBefore)}" cannot be external.`
  };
}
function errUnresolvedImplicitDependant(unresolvedId, implicitlyLoadedBefore) {
  return {
    code: Errors.MISSING_IMPLICIT_DEPENDANT,
    message: `Module "${relativeId(unresolvedId)}" that should be implicitly loaded before "${relativeId(implicitlyLoadedBefore)}" could not be resolved.`
  };
}
function errImplicitDependantIsNotIncluded(module2) {
  const implicitDependencies = Array.from(module2.implicitlyLoadedBefore, (dependency) => relativeId(dependency.id)).sort();
  return {
    code: Errors.MISSING_IMPLICIT_DEPENDANT,
    message: `Module "${relativeId(module2.id)}" that should be implicitly loaded before ${printQuotedStringList(implicitDependencies)} is not included in the module graph. Either it was not imported by an included module or only via a tree-shaken dynamic import, or no imported bindings were used and it had otherwise no side-effects.`
  };
}
function errMixedExport(facadeModuleId, name) {
  return {
    code: Errors.MIXED_EXPORTS,
    id: facadeModuleId,
    message: `Entry module "${relativeId(facadeModuleId)}" is using named and default exports together. Consumers of your bundle will have to use \`${name || "chunk"}["default"]\` to access the default export, which may not be what you want. Use \`output.exports: "named"\` to disable this warning`,
    url: `https://rollupjs.org/guide/en/#outputexports`
  };
}
function errNamespaceConflict(name, reexportingModule, additionalExportAllModule) {
  return {
    code: Errors.NAMESPACE_CONFLICT,
    message: `Conflicting namespaces: "${relativeId(reexportingModule.id)}" re-exports "${name}" from both "${relativeId(reexportingModule.exportsAll[name])}" and "${relativeId(additionalExportAllModule.exportsAll[name])}" (will be ignored)`,
    name,
    reexporter: reexportingModule.id,
    sources: [reexportingModule.exportsAll[name], additionalExportAllModule.exportsAll[name]]
  };
}
function errAmbiguousExternalNamespaces(name, reexportingModule, usedExternalModule, externalModules) {
  return {
    code: Errors.AMBIGUOUS_EXTERNAL_NAMESPACES,
    message: `Ambiguous external namespace resolution: "${relativeId(reexportingModule)}" re-exports "${name}" from one of the external modules ${printQuotedStringList(externalModules.map((module2) => relativeId(module2)))}, guessing "${relativeId(usedExternalModule)}".`,
    name,
    reexporter: reexportingModule,
    sources: externalModules
  };
}
function errNoTransformMapOrAstWithoutCode(pluginName) {
  return {
    code: Errors.NO_TRANSFORM_MAP_OR_AST_WITHOUT_CODE,
    message: `The plugin "${pluginName}" returned a "map" or "ast" without returning a "code". This will be ignored.`
  };
}
function errPreferNamedExports(facadeModuleId) {
  const file = relativeId(facadeModuleId);
  return {
    code: Errors.PREFER_NAMED_EXPORTS,
    id: facadeModuleId,
    message: `Entry module "${file}" is implicitly using "default" export mode, which means for CommonJS output that its default export is assigned to "module.exports". For many tools, such CommonJS output will not be interchangeable with the original ES module. If this is intended, explicitly set "output.exports" to either "auto" or "default", otherwise you might want to consider changing the signature of "${file}" to use named exports only.`,
    url: `https://rollupjs.org/guide/en/#outputexports`
  };
}
function errSyntheticNamedExportsNeedNamespaceExport(id, syntheticNamedExportsOption) {
  return {
    code: Errors.SYNTHETIC_NAMED_EXPORTS_NEED_NAMESPACE_EXPORT,
    id,
    message: `Module "${relativeId(id)}" that is marked with 'syntheticNamedExports: ${JSON.stringify(syntheticNamedExportsOption)}' needs ${typeof syntheticNamedExportsOption === "string" && syntheticNamedExportsOption !== "default" ? `an export named "${syntheticNamedExportsOption}"` : "a default export"} that does not reexport an unresolved named export of the same module.`
  };
}
function errUnexpectedNamedImport(id, imported, isReexport) {
  const importType = isReexport ? "reexport" : "import";
  return {
    code: Errors.UNEXPECTED_NAMED_IMPORT,
    id,
    message: `The named export "${imported}" was ${importType}ed from the external module ${relativeId(id)} even though its interop type is "defaultOnly". Either remove or change this ${importType} or change the value of the "output.interop" option.`,
    url: "https://rollupjs.org/guide/en/#outputinterop"
  };
}
function errUnexpectedNamespaceReexport(id) {
  return {
    code: Errors.UNEXPECTED_NAMED_IMPORT,
    id,
    message: `There was a namespace "*" reexport from the external module ${relativeId(id)} even though its interop type is "defaultOnly". This will be ignored as namespace reexports only reexport named exports. If this is not intended, either remove or change this reexport or change the value of the "output.interop" option.`,
    url: "https://rollupjs.org/guide/en/#outputinterop"
  };
}
function errEntryCannotBeExternal(unresolvedId) {
  return {
    code: Errors.UNRESOLVED_ENTRY,
    message: `Entry module cannot be external (${relativeId(unresolvedId)}).`
  };
}
function errUnresolvedEntry(unresolvedId) {
  return {
    code: Errors.UNRESOLVED_ENTRY,
    message: `Could not resolve entry module (${relativeId(unresolvedId)}).`
  };
}
function errUnresolvedImport(source, importer) {
  return {
    code: Errors.UNRESOLVED_IMPORT,
    message: `Could not resolve '${source}' from ${relativeId(importer)}`
  };
}
function errUnresolvedImportTreatedAsExternal(source, importer) {
  return {
    code: Errors.UNRESOLVED_IMPORT,
    importer: relativeId(importer),
    message: `'${source}' is imported by ${relativeId(importer)}, but could not be resolved \u2013 treating it as an external dependency`,
    source,
    url: "https://rollupjs.org/guide/en/#warning-treating-module-as-external-dependency"
  };
}
function errExternalSyntheticExports(source, importer) {
  return {
    code: Errors.EXTERNAL_SYNTHETIC_EXPORTS,
    importer: relativeId(importer),
    message: `External '${source}' can not have 'syntheticNamedExports' enabled.`,
    source
  };
}
function errFailedValidation(message) {
  return {
    code: Errors.VALIDATION_ERROR,
    message
  };
}
function errAlreadyClosed() {
  return {
    code: Errors.ALREADY_CLOSED,
    message: 'Bundle is already closed, no more calls to "generate" or "write" are allowed.'
  };
}
function warnDeprecation(deprecation, activeDeprecation, options) {
  warnDeprecationWithOptions(deprecation, activeDeprecation, options.onwarn, options.strictDeprecations);
}
function warnDeprecationWithOptions(deprecation, activeDeprecation, warn, strictDeprecations) {
  if (activeDeprecation || strictDeprecations) {
    const warning = errDeprecation(deprecation);
    if (strictDeprecations) {
      return error(warning);
    }
    warn(warning);
  }
}
function getId(m) {
  return m.id;
}
function getOriginalLocation(sourcemapChain, location) {
  const filteredSourcemapChain = sourcemapChain.filter((sourcemap) => sourcemap.mappings);
  while (filteredSourcemapChain.length > 0) {
    const sourcemap = filteredSourcemapChain.pop();
    const line = sourcemap.mappings[location.line - 1];
    let locationFound = false;
    if (line !== void 0) {
      for (const segment of line) {
        if (segment[0] >= location.column) {
          if (segment.length === 1)
            break;
          location = {
            column: segment[3],
            line: segment[2] + 1,
            name: segment.length === 5 ? sourcemap.names[segment[4]] : void 0,
            source: sourcemap.sources[segment[1]]
          };
          locationFound = true;
          break;
        }
      }
    }
    if (!locationFound) {
      throw new Error("Can't resolve original location of error.");
    }
  }
  return location;
}
function setTimeHelpers() {
  if (typeof process !== "undefined" && typeof process.hrtime === "function") {
    getStartTime = process.hrtime.bind(process);
    getElapsedTime = (previous) => normalizeHrTime(process.hrtime(previous));
  } else if (typeof performance !== "undefined" && typeof performance.now === "function") {
    getStartTime = () => [performance.now(), 0];
    getElapsedTime = (previous) => performance.now() - previous[0];
  }
  if (typeof process !== "undefined" && typeof process.memoryUsage === "function") {
    getMemory = () => process.memoryUsage().heapUsed;
  }
}
function getPersistedLabel(label, level) {
  switch (level) {
    case 1:
      return `# ${label}`;
    case 2:
      return `## ${label}`;
    case 3:
      return label;
    default:
      return `${"  ".repeat(level - 4)}- ${label}`;
  }
}
function timeStartImpl(label, level = 3) {
  label = getPersistedLabel(label, level);
  if (!timers.hasOwnProperty(label)) {
    timers[label] = {
      memory: 0,
      startMemory: void 0,
      startTime: void 0,
      time: 0,
      totalMemory: 0
    };
  }
  const currentMemory = getMemory();
  timers[label].startTime = getStartTime();
  timers[label].startMemory = currentMemory;
}
function timeEndImpl(label, level = 3) {
  label = getPersistedLabel(label, level);
  if (timers.hasOwnProperty(label)) {
    const currentMemory = getMemory();
    timers[label].time += getElapsedTime(timers[label].startTime);
    timers[label].totalMemory = Math.max(timers[label].totalMemory, currentMemory);
    timers[label].memory += currentMemory - timers[label].startMemory;
  }
}
function getTimings() {
  const newTimings = {};
  for (const [label, { time, memory, totalMemory }] of Object.entries(timers)) {
    newTimings[label] = [time, memory, totalMemory];
  }
  return newTimings;
}
function getPluginWithTimers(plugin, index2) {
  const timedPlugin = {};
  for (const hook of Object.keys(plugin)) {
    if (TIMED_PLUGIN_HOOKS[hook] === true) {
      let timerLabel = `plugin ${index2}`;
      if (plugin.name) {
        timerLabel += ` (${plugin.name})`;
      }
      timerLabel += ` - ${hook}`;
      timedPlugin[hook] = function(...args) {
        timeStart(timerLabel, 4);
        let result2 = plugin[hook].apply(this === timedPlugin ? plugin : this, args);
        timeEnd(timerLabel, 4);
        if (result2 && typeof result2.then === "function") {
          timeStart(`${timerLabel} (async)`, 4);
          result2 = result2.then((hookResult) => {
            timeEnd(`${timerLabel} (async)`, 4);
            return hookResult;
          });
        }
        return result2;
      };
    } else {
      timedPlugin[hook] = plugin[hook];
    }
  }
  return timedPlugin;
}
function initialiseTimers(inputOptions) {
  if (inputOptions.perf) {
    timers = {};
    setTimeHelpers();
    timeStart = timeStartImpl;
    timeEnd = timeEndImpl;
    inputOptions.plugins = inputOptions.plugins.map(getPluginWithTimers);
  } else {
    timeStart = NOOP;
    timeEnd = NOOP;
  }
}
function markModuleAndImpureDependenciesAsExecuted(baseModule) {
  baseModule.isExecuted = true;
  const modules = [baseModule];
  const visitedModules = /* @__PURE__ */ new Set();
  for (const module2 of modules) {
    for (const dependency of [...module2.dependencies, ...module2.implicitlyLoadedBefore]) {
      if (!(dependency instanceof ExternalModule) && !dependency.isExecuted && (dependency.info.hasModuleSideEffects || module2.implicitlyLoadedBefore.has(dependency)) && !visitedModules.has(dependency.id)) {
        dependency.isExecuted = true;
        visitedModules.add(dependency.id);
        modules.push(dependency);
      }
    }
  }
}
function getVariableForExportNameRecursive(target, name, importerForSideEffects, isExportAllSearch, searchedNamesAndModules = /* @__PURE__ */ new Map(), skipExternalNamespaceReexports) {
  const searchedModules = searchedNamesAndModules.get(name);
  if (searchedModules) {
    if (searchedModules.has(target)) {
      return isExportAllSearch ? null : error(errCircularReexport(name, target.id));
    }
    searchedModules.add(target);
  } else {
    searchedNamesAndModules.set(name, /* @__PURE__ */ new Set([target]));
  }
  return target.getVariableForExportName(name, {
    importerForSideEffects,
    isExportAllSearch,
    searchedNamesAndModules,
    skipExternalNamespaceReexports
  });
}
function getAndExtendSideEffectModules(variable, module2) {
  const sideEffectModules = getOrCreate(module2.sideEffectDependenciesByVariable, variable, () => /* @__PURE__ */ new Set());
  let currentVariable = variable;
  const referencedVariables = /* @__PURE__ */ new Set([currentVariable]);
  while (true) {
    const importingModule = currentVariable.module;
    currentVariable = currentVariable instanceof ExportDefaultVariable ? currentVariable.getDirectOriginalVariable() : currentVariable instanceof SyntheticNamedExportVariable ? currentVariable.syntheticNamespace : null;
    if (!currentVariable || referencedVariables.has(currentVariable)) {
      break;
    }
    referencedVariables.add(currentVariable);
    sideEffectModules.add(importingModule);
    const originalSideEffects = importingModule.sideEffectDependenciesByVariable.get(currentVariable);
    if (originalSideEffects) {
      for (const module3 of originalSideEffects) {
        sideEffectModules.add(module3);
      }
    }
  }
  return sideEffectModules;
}
function setAlternativeExporterIfCyclic(variable, importer, reexporter) {
  if (variable.module instanceof Module && variable.module !== reexporter) {
    const exporterCycles = variable.module.cycles;
    if (exporterCycles.size > 0) {
      const importerCycles = reexporter.cycles;
      for (const cycleSymbol of importerCycles) {
        if (exporterCycles.has(cycleSymbol)) {
          importer.alternativeReexportModules.set(variable, reexporter);
          break;
        }
      }
    }
  }
}
function removeJsExtension(name) {
  return name.endsWith(".js") ? name.slice(0, -3) : name;
}
function getCompleteAmdId(options, chunkId) {
  if (!options.autoId) {
    return options.id || "";
  } else {
    return `${options.basePath ? options.basePath + "/" : ""}${removeJsExtension(chunkId)}`;
  }
}
function getExportBlock$1(exports2, dependencies, namedExportsMode, interop, compact, t, externalLiveBindings, mechanism = "return ") {
  const _ = compact ? "" : " ";
  const n3 = compact ? "" : "\n";
  if (!namedExportsMode) {
    return `${n3}${n3}${mechanism}${getSingleDefaultExport(exports2, dependencies, interop, externalLiveBindings)};`;
  }
  let exportBlock = "";
  for (const { defaultVariableName, id, isChunk, name, namedExportsMode: depNamedExportsMode, namespaceVariableName, reexports } of dependencies) {
    if (reexports && namedExportsMode) {
      for (const specifier of reexports) {
        if (specifier.reexported !== "*") {
          const importName = getReexportedImportName(name, specifier.imported, depNamedExportsMode, isChunk, defaultVariableName, namespaceVariableName, interop, id, externalLiveBindings);
          if (exportBlock)
            exportBlock += n3;
          exportBlock += specifier.imported !== "*" && specifier.needsLiveBinding ? `Object.defineProperty(exports,${_}'${specifier.reexported}',${_}{${n3}${t}enumerable:${_}true,${n3}${t}get:${_}function${_}()${_}{${n3}${t}${t}return ${importName};${n3}${t}}${n3}});` : `exports.${specifier.reexported}${_}=${_}${importName};`;
        }
      }
    }
  }
  for (const { exported, local } of exports2) {
    const lhs = `exports${RESERVED_NAMES[exported] ? `['${exported}']` : `.${exported}`}`;
    const rhs = local;
    if (lhs !== rhs) {
      if (exportBlock)
        exportBlock += n3;
      exportBlock += `${lhs}${_}=${_}${rhs};`;
    }
  }
  for (const { name, reexports } of dependencies) {
    if (reexports && namedExportsMode) {
      for (const specifier of reexports) {
        if (specifier.reexported === "*") {
          if (exportBlock)
            exportBlock += n3;
          if (specifier.needsLiveBinding) {
            exportBlock += `Object.keys(${name}).forEach(function${_}(k)${_}{${n3}${t}if${_}(k${_}!==${_}'default'${_}&&${_}!exports.hasOwnProperty(k))${_}Object.defineProperty(exports,${_}k,${_}{${n3}${t}${t}enumerable:${_}true,${n3}${t}${t}get:${_}function${_}()${_}{${n3}${t}${t}${t}return ${name}[k];${n3}${t}${t}}${n3}${t}});${n3}});`;
          } else {
            exportBlock += `Object.keys(${name}).forEach(function${_}(k)${_}{${n3}${t}if${_}(k${_}!==${_}'default'${_}&&${_}!exports.hasOwnProperty(k))${_}exports[k]${_}=${_}${name}[k];${n3}});`;
          }
        }
      }
    }
  }
  if (exportBlock) {
    return `${n3}${n3}${exportBlock}`;
  }
  return "";
}
function getSingleDefaultExport(exports2, dependencies, interop, externalLiveBindings) {
  if (exports2.length > 0) {
    return exports2[0].local;
  } else {
    for (const { defaultVariableName, id, isChunk, name, namedExportsMode: depNamedExportsMode, namespaceVariableName, reexports } of dependencies) {
      if (reexports) {
        return getReexportedImportName(name, reexports[0].imported, depNamedExportsMode, isChunk, defaultVariableName, namespaceVariableName, interop, id, externalLiveBindings);
      }
    }
  }
}
function getReexportedImportName(moduleVariableName, imported, depNamedExportsMode, isChunk, defaultVariableName, namespaceVariableName, interop, moduleId, externalLiveBindings) {
  if (imported === "default") {
    if (!isChunk) {
      const moduleInterop = String(interop(moduleId));
      const variableName = defaultInteropHelpersByInteropType[moduleInterop] ? defaultVariableName : moduleVariableName;
      return isDefaultAProperty(moduleInterop, externalLiveBindings) ? `${variableName}['default']` : variableName;
    }
    return depNamedExportsMode ? `${moduleVariableName}['default']` : moduleVariableName;
  }
  if (imported === "*") {
    return (isChunk ? !depNamedExportsMode : namespaceInteropHelpersByInteropType[String(interop(moduleId))]) ? namespaceVariableName : moduleVariableName;
  }
  return `${moduleVariableName}.${imported}`;
}
function getEsModuleExport(_) {
  return `Object.defineProperty(exports,${_}'__esModule',${_}{${_}value:${_}true${_}});`;
}
function getNamespaceToStringExport(_) {
  return `exports[Symbol.toStringTag]${_}=${_}'Module';`;
}
function getNamespaceMarkers(hasNamedExports, addEsModule, addNamespaceToStringTag, _, n3) {
  let namespaceMarkers = "";
  if (hasNamedExports) {
    if (addEsModule) {
      namespaceMarkers += getEsModuleExport(_);
    }
    if (addNamespaceToStringTag) {
      if (namespaceMarkers) {
        namespaceMarkers += n3;
      }
      namespaceMarkers += getNamespaceToStringExport(_);
    }
  }
  return namespaceMarkers;
}
function getInteropBlock(dependencies, varOrConst, interop, externalLiveBindings, freeze, namespaceToStringTag, accessedGlobals, _, n3, s, t) {
  const neededInteropHelpers = /* @__PURE__ */ new Set();
  const interopStatements = [];
  const addInteropStatement = (helperVariableName, helper, dependencyVariableName) => {
    neededInteropHelpers.add(helper);
    interopStatements.push(`${varOrConst} ${helperVariableName}${_}=${_}/*#__PURE__*/${helper}(${dependencyVariableName});`);
  };
  for (const { defaultVariableName, imports, id, isChunk, name, namedExportsMode, namespaceVariableName, reexports } of dependencies) {
    if (isChunk) {
      for (const { imported, reexported } of [
        ...imports || [],
        ...reexports || []
      ]) {
        if (imported === "*" && reexported !== "*") {
          if (!namedExportsMode) {
            addInteropStatement(namespaceVariableName, getDefaultOnlyHelper(), name);
          }
          break;
        }
      }
    } else {
      const moduleInterop = String(interop(id));
      let hasDefault = false;
      let hasNamespace = false;
      for (const { imported, reexported } of [
        ...imports || [],
        ...reexports || []
      ]) {
        let helper;
        let variableName;
        if (imported === "default") {
          if (!hasDefault) {
            hasDefault = true;
            if (defaultVariableName !== namespaceVariableName) {
              variableName = defaultVariableName;
              helper = defaultInteropHelpersByInteropType[moduleInterop];
            }
          }
        } else if (imported === "*" && reexported !== "*") {
          if (!hasNamespace) {
            hasNamespace = true;
            helper = namespaceInteropHelpersByInteropType[moduleInterop];
            variableName = namespaceVariableName;
          }
        }
        if (helper) {
          addInteropStatement(variableName, helper, name);
        }
      }
    }
  }
  return `${getHelpersBlock(neededInteropHelpers, accessedGlobals, _, n3, s, t, externalLiveBindings, freeze, namespaceToStringTag)}${interopStatements.length > 0 ? `${interopStatements.join(n3)}${n3}${n3}` : ""}`;
}
function removeExtensionFromRelativeAmdId(id) {
  return id[0] === "." ? removeJsExtension(id) : id;
}
function warnOnBuiltins(warn, dependencies) {
  const externalBuiltins = dependencies.map(({ id }) => id).filter((id) => id in builtins4);
  if (!externalBuiltins.length)
    return;
  warn({
    code: "MISSING_NODE_BUILTINS",
    message: `Creating a browser bundle that depends on Node.js built-in modules (${printQuotedStringList(externalBuiltins)}). You might need to include https://github.com/snowpackjs/rollup-plugin-polyfill-node`,
    modules: externalBuiltins
  });
}
function amd(magicString, { accessedGlobals, dependencies, exports: exports2, hasExports, id, indentString: t, intro, isEntryFacade, isModuleFacade, namedExportsMode, outro, varOrConst, warn }, { amd: amd2, compact, esModule, externalLiveBindings, freeze, interop, namespaceToStringTag, strict }) {
  warnOnBuiltins(warn, dependencies);
  const deps = dependencies.map((m) => `'${removeExtensionFromRelativeAmdId(m.id)}'`);
  const args = dependencies.map((m) => m.name);
  const n3 = compact ? "" : "\n";
  const s = compact ? "" : ";";
  const _ = compact ? "" : " ";
  if (namedExportsMode && hasExports) {
    args.unshift(`exports`);
    deps.unshift(`'exports'`);
  }
  if (accessedGlobals.has("require")) {
    args.unshift("require");
    deps.unshift(`'require'`);
  }
  if (accessedGlobals.has("module")) {
    args.unshift("module");
    deps.unshift(`'module'`);
  }
  const completeAmdId = getCompleteAmdId(amd2, id);
  const params = (completeAmdId ? `'${completeAmdId}',${_}` : ``) + (deps.length ? `[${deps.join(`,${_}`)}],${_}` : ``);
  const useStrict = strict ? `${_}'use strict';` : "";
  magicString.prepend(`${intro}${getInteropBlock(dependencies, varOrConst, interop, externalLiveBindings, freeze, namespaceToStringTag, accessedGlobals, _, n3, s, t)}`);
  const exportBlock = getExportBlock$1(exports2, dependencies, namedExportsMode, interop, compact, t, externalLiveBindings);
  let namespaceMarkers = getNamespaceMarkers(namedExportsMode && hasExports, isEntryFacade && esModule, isModuleFacade && namespaceToStringTag, _, n3);
  if (namespaceMarkers) {
    namespaceMarkers = n3 + n3 + namespaceMarkers;
  }
  magicString.append(`${exportBlock}${namespaceMarkers}${outro}`);
  return magicString.indent(t).prepend(`${amd2.define}(${params}function${_}(${args.join(`,${_}`)})${_}{${useStrict}${n3}${n3}`).append(`${n3}${n3}});`);
}
function cjs(magicString, { accessedGlobals, dependencies, exports: exports2, hasExports, indentString: t, intro, isEntryFacade, isModuleFacade, namedExportsMode, outro, varOrConst }, { compact, esModule, externalLiveBindings, freeze, interop, namespaceToStringTag, strict }) {
  const n3 = compact ? "" : "\n";
  const s = compact ? "" : ";";
  const _ = compact ? "" : " ";
  const useStrict = strict ? `'use strict';${n3}${n3}` : "";
  let namespaceMarkers = getNamespaceMarkers(namedExportsMode && hasExports, isEntryFacade && esModule, isModuleFacade && namespaceToStringTag, _, n3);
  if (namespaceMarkers) {
    namespaceMarkers += n3 + n3;
  }
  const importBlock = getImportBlock$1(dependencies, compact, varOrConst, n3, _);
  const interopBlock = getInteropBlock(dependencies, varOrConst, interop, externalLiveBindings, freeze, namespaceToStringTag, accessedGlobals, _, n3, s, t);
  magicString.prepend(`${useStrict}${intro}${namespaceMarkers}${importBlock}${interopBlock}`);
  const exportBlock = getExportBlock$1(exports2, dependencies, namedExportsMode, interop, compact, t, externalLiveBindings, `module.exports${_}=${_}`);
  return magicString.append(`${exportBlock}${outro}`);
}
function getImportBlock$1(dependencies, compact, varOrConst, n3, _) {
  let importBlock = "";
  let definingVariable = false;
  for (const { id, name, reexports, imports } of dependencies) {
    if (!reexports && !imports) {
      if (importBlock) {
        importBlock += !compact || definingVariable ? `;${n3}` : ",";
      }
      definingVariable = false;
      importBlock += `require('${id}')`;
    } else {
      importBlock += compact && definingVariable ? "," : `${importBlock ? `;${n3}` : ""}${varOrConst} `;
      definingVariable = true;
      importBlock += `${name}${_}=${_}require('${id}')`;
    }
  }
  if (importBlock) {
    return `${importBlock};${n3}${n3}`;
  }
  return "";
}
function es(magicString, { intro, outro, dependencies, exports: exports2, varOrConst }, { compact }) {
  const _ = compact ? "" : " ";
  const n3 = compact ? "" : "\n";
  const importBlock = getImportBlock(dependencies, _);
  if (importBlock.length > 0)
    intro += importBlock.join(n3) + n3 + n3;
  if (intro)
    magicString.prepend(intro);
  const exportBlock = getExportBlock(exports2, _, varOrConst);
  if (exportBlock.length)
    magicString.append(n3 + n3 + exportBlock.join(n3).trim());
  if (outro)
    magicString.append(outro);
  return magicString.trim();
}
function getImportBlock(dependencies, _) {
  const importBlock = [];
  for (const { id, reexports, imports, name } of dependencies) {
    if (!reexports && !imports) {
      importBlock.push(`import${_}'${id}';`);
      continue;
    }
    if (imports) {
      let defaultImport = null;
      let starImport = null;
      const importedNames = [];
      for (const specifier of imports) {
        if (specifier.imported === "default") {
          defaultImport = specifier;
        } else if (specifier.imported === "*") {
          starImport = specifier;
        } else {
          importedNames.push(specifier);
        }
      }
      if (starImport) {
        importBlock.push(`import${_}*${_}as ${starImport.local} from${_}'${id}';`);
      }
      if (defaultImport && importedNames.length === 0) {
        importBlock.push(`import ${defaultImport.local} from${_}'${id}';`);
      } else if (importedNames.length > 0) {
        importBlock.push(`import ${defaultImport ? `${defaultImport.local},${_}` : ""}{${_}${importedNames.map((specifier) => {
          if (specifier.imported === specifier.local) {
            return specifier.imported;
          } else {
            return `${specifier.imported} as ${specifier.local}`;
          }
        }).join(`,${_}`)}${_}}${_}from${_}'${id}';`);
      }
    }
    if (reexports) {
      let starExport = null;
      const namespaceReexports = [];
      const namedReexports = [];
      for (const specifier of reexports) {
        if (specifier.reexported === "*") {
          starExport = specifier;
        } else if (specifier.imported === "*") {
          namespaceReexports.push(specifier);
        } else {
          namedReexports.push(specifier);
        }
      }
      if (starExport) {
        importBlock.push(`export${_}*${_}from${_}'${id}';`);
      }
      if (namespaceReexports.length > 0) {
        if (!imports || !imports.some((specifier) => specifier.imported === "*" && specifier.local === name)) {
          importBlock.push(`import${_}*${_}as ${name} from${_}'${id}';`);
        }
        for (const specifier of namespaceReexports) {
          importBlock.push(`export${_}{${_}${name === specifier.reexported ? name : `${name} as ${specifier.reexported}`} };`);
        }
      }
      if (namedReexports.length > 0) {
        importBlock.push(`export${_}{${_}${namedReexports.map((specifier) => {
          if (specifier.imported === specifier.reexported) {
            return specifier.imported;
          } else {
            return `${specifier.imported} as ${specifier.reexported}`;
          }
        }).join(`,${_}`)}${_}}${_}from${_}'${id}';`);
      }
    }
  }
  return importBlock;
}
function getExportBlock(exports2, _, varOrConst) {
  const exportBlock = [];
  const exportDeclaration = [];
  for (const specifier of exports2) {
    if (specifier.expression) {
      exportBlock.push(`${varOrConst} ${specifier.local}${_}=${_}${specifier.expression};`);
    }
    exportDeclaration.push(specifier.exported === specifier.local ? specifier.local : `${specifier.local} as ${specifier.exported}`);
  }
  if (exportDeclaration.length) {
    exportBlock.push(`export${_}{${_}${exportDeclaration.join(`,${_}`)}${_}};`);
  }
  return exportBlock;
}
function property(prop) {
  return shouldUseDot.test(prop) ? `.${prop}` : `['${prop}']`;
}
function keypath(keypath2) {
  return keypath2.split(".").map(property).join("");
}
function setupNamespace(name, root, globals, compact) {
  const _ = compact ? "" : " ";
  const parts = name.split(".");
  parts[0] = (typeof globals === "function" ? globals(parts[0]) : globals[parts[0]]) || parts[0];
  parts.pop();
  let acc = root;
  return parts.map((part) => (acc += property(part), `${acc}${_}=${_}${acc}${_}||${_}{}${compact ? "" : ";"}`)).join(compact ? "," : "\n") + (compact && parts.length ? ";" : "\n");
}
function assignToDeepVariable(deepName, root, globals, compact, assignment) {
  const _ = compact ? "" : " ";
  const parts = deepName.split(".");
  parts[0] = (typeof globals === "function" ? globals(parts[0]) : globals[parts[0]]) || parts[0];
  const last = parts.pop();
  let acc = root;
  let deepAssignment = parts.map((part) => (acc += property(part), `${acc}${_}=${_}${acc}${_}||${_}{}`)).concat(`${acc}${property(last)}`).join(`,${_}`).concat(`${_}=${_}${assignment}`);
  if (parts.length > 0) {
    deepAssignment = `(${deepAssignment})`;
  }
  return deepAssignment;
}
function trimEmptyImports(dependencies) {
  let i = dependencies.length;
  while (i--) {
    const { imports, reexports } = dependencies[i];
    if (imports || reexports) {
      return dependencies.slice(0, i + 1);
    }
  }
  return [];
}
function iife(magicString, { accessedGlobals, dependencies, exports: exports2, hasExports, indentString: t, intro, namedExportsMode, outro, varOrConst, warn }, { compact, esModule, extend: extend2, freeze, externalLiveBindings, globals, interop, name, namespaceToStringTag, strict }) {
  const _ = compact ? "" : " ";
  const s = compact ? "" : ";";
  const n3 = compact ? "" : "\n";
  const isNamespaced = name && name.indexOf(".") !== -1;
  const useVariableAssignment = !extend2 && !isNamespaced;
  if (name && useVariableAssignment && !isLegal(name)) {
    return error({
      code: "ILLEGAL_IDENTIFIER_AS_NAME",
      message: `Given name "${name}" is not a legal JS identifier. If you need this, you can try "output.extend: true".`
    });
  }
  warnOnBuiltins(warn, dependencies);
  const external = trimEmptyImports(dependencies);
  const deps = external.map((dep) => dep.globalName || "null");
  const args = external.map((m) => m.name);
  if (hasExports && !name) {
    warn({
      code: "MISSING_NAME_OPTION_FOR_IIFE_EXPORT",
      message: `If you do not supply "output.name", you may not be able to access the exports of an IIFE bundle.`
    });
  }
  if (namedExportsMode && hasExports) {
    if (extend2) {
      deps.unshift(`${thisProp(name)}${_}=${_}${thisProp(name)}${_}||${_}{}`);
      args.unshift("exports");
    } else {
      deps.unshift("{}");
      args.unshift("exports");
    }
  }
  const useStrict = strict ? `${t}'use strict';${n3}` : "";
  const interopBlock = getInteropBlock(dependencies, varOrConst, interop, externalLiveBindings, freeze, namespaceToStringTag, accessedGlobals, _, n3, s, t);
  magicString.prepend(`${intro}${interopBlock}`);
  let wrapperIntro = `(function${_}(${args.join(`,${_}`)})${_}{${n3}${useStrict}${n3}`;
  if (hasExports) {
    if (name && !(extend2 && namedExportsMode)) {
      wrapperIntro = (useVariableAssignment ? `${varOrConst} ${name}` : thisProp(name)) + `${_}=${_}${wrapperIntro}`;
    }
    if (isNamespaced) {
      wrapperIntro = setupNamespace(name, "this", globals, compact) + wrapperIntro;
    }
  }
  let wrapperOutro = `${n3}${n3}}(${deps.join(`,${_}`)}));`;
  if (hasExports && !extend2 && namedExportsMode) {
    wrapperOutro = `${n3}${n3}${t}return exports;${wrapperOutro}`;
  }
  const exportBlock = getExportBlock$1(exports2, dependencies, namedExportsMode, interop, compact, t, externalLiveBindings);
  let namespaceMarkers = getNamespaceMarkers(namedExportsMode && hasExports, esModule, namespaceToStringTag, _, n3);
  if (namespaceMarkers) {
    namespaceMarkers = n3 + n3 + namespaceMarkers;
  }
  magicString.append(`${exportBlock}${namespaceMarkers}${outro}`);
  return magicString.indent(t).prepend(wrapperIntro).append(wrapperOutro);
}
function getStarExcludes({ dependencies, exports: exports2 }) {
  const starExcludes = new Set(exports2.map((expt) => expt.exported));
  starExcludes.add("default");
  for (const { reexports } of dependencies) {
    if (reexports) {
      for (const reexport of reexports) {
        if (reexport.imported !== "*")
          starExcludes.add(reexport.reexported);
      }
    }
  }
  return starExcludes;
}
function getExportsBlock(exports2, _, t, n3) {
  if (exports2.length === 0) {
    return "";
  }
  if (exports2.length === 1) {
    return `${t}${t}${t}exports('${exports2[0].name}',${_}${exports2[0].value});${n3}${n3}`;
  }
  return `${t}${t}${t}exports({${n3}` + exports2.map(({ name, value }) => `${t}${t}${t}${t}${name}:${_}${value}`).join(`,${n3}`) + `${n3}${t}${t}${t}});${n3}${n3}`;
}
function system(magicString, { accessedGlobals, dependencies, exports: exports2, hasExports, indentString: t, intro, outro, usesTopLevelAwait, varOrConst }, options) {
  const n3 = options.compact ? "" : "\n";
  const _ = options.compact ? "" : " ";
  const dependencyIds = dependencies.map((m) => `'${m.id}'`);
  const importBindings = [];
  let starExcludes;
  const setters = [];
  for (const { imports, reexports } of dependencies) {
    const setter = [];
    if (imports) {
      for (const specifier of imports) {
        importBindings.push(specifier.local);
        if (specifier.imported === "*") {
          setter.push(`${specifier.local}${_}=${_}module;`);
        } else {
          setter.push(`${specifier.local}${_}=${_}module.${specifier.imported};`);
        }
      }
    }
    if (reexports) {
      let createdSetter = false;
      if (reexports.length > 1 || reexports.length === 1 && (reexports[0].reexported === "*" || reexports[0].imported === "*")) {
        for (const specifier of reexports) {
          if (specifier.reexported !== "*")
            continue;
          if (!starExcludes) {
            starExcludes = getStarExcludes({ dependencies, exports: exports2 });
          }
          createdSetter = true;
          setter.push(`${varOrConst} _setter${_}=${_}{};`);
          setter.push(`for${_}(var _$p${_}in${_}module)${_}{`);
          setter.push(`${t}if${_}(!_starExcludes[_$p])${_}_setter[_$p]${_}=${_}module[_$p];`);
          setter.push("}");
        }
        for (const specifier of reexports) {
          if (specifier.imported !== "*" || specifier.reexported === "*")
            continue;
          setter.push(`exports('${specifier.reexported}',${_}module);`);
        }
        for (const specifier of reexports) {
          if (specifier.reexported === "*" || specifier.imported === "*")
            continue;
          if (!createdSetter) {
            setter.push(`${varOrConst} _setter${_}=${_}{};`);
            createdSetter = true;
          }
          setter.push(`_setter.${specifier.reexported}${_}=${_}module.${specifier.imported};`);
        }
        if (createdSetter) {
          setter.push("exports(_setter);");
        }
      } else {
        for (const specifier of reexports) {
          setter.push(`exports('${specifier.reexported}',${_}module.${specifier.imported});`);
        }
      }
    }
    setters.push(setter.join(`${n3}${t}${t}${t}`));
  }
  const registeredName = options.name ? `'${options.name}',${_}` : "";
  const wrapperParams = accessedGlobals.has("module") ? `exports,${_}module` : hasExports ? "exports" : "";
  let wrapperStart = `System.register(${registeredName}[` + dependencyIds.join(`,${_}`) + `],${_}function${_}(${wrapperParams})${_}{${n3}${t}${options.strict ? "'use strict';" : ""}` + getStarExcludesBlock(starExcludes, varOrConst, _, t, n3) + getImportBindingsBlock(importBindings, _, t, n3) + `${n3}${t}return${_}{${setters.length ? `${n3}${t}${t}setters:${_}[${setters.map((s) => s ? `function${_}(module)${_}{${n3}${t}${t}${t}${s}${n3}${t}${t}}` : options.systemNullSetters ? `null` : `function${_}()${_}{}`).join(`,${_}`)}],` : ""}${n3}`;
  wrapperStart += `${t}${t}execute:${_}${usesTopLevelAwait ? `async${_}` : ""}function${_}()${_}{${n3}${n3}` + getHoistedExportsBlock(exports2, _, t, n3);
  const wrapperEnd = `${n3}${n3}` + getSyntheticExportsBlock(exports2, _, t, n3) + getMissingExportsBlock(exports2, _, t, n3) + `${t}${t}}${n3}${t}}${options.compact ? "" : ";"}${n3}});`;
  if (intro)
    magicString.prepend(intro);
  if (outro)
    magicString.append(outro);
  return magicString.indent(`${t}${t}${t}`).append(wrapperEnd).prepend(wrapperStart);
}
function globalProp(name, globalVar) {
  if (!name)
    return "null";
  return `${globalVar}${keypath(name)}`;
}
function safeAccess(name, globalVar, _) {
  const parts = name.split(".");
  let acc = globalVar;
  return parts.map((part) => acc += property(part)).join(`${_}&&${_}`);
}
function umd(magicString, { accessedGlobals, dependencies, exports: exports2, hasExports, id, indentString: t, intro, namedExportsMode, outro, varOrConst, warn }, { amd: amd2, compact, esModule, extend: extend2, externalLiveBindings, freeze, interop, name, namespaceToStringTag, globals, noConflict, strict }) {
  const _ = compact ? "" : " ";
  const n3 = compact ? "" : "\n";
  const s = compact ? "" : ";";
  const factoryVar = compact ? "f" : "factory";
  const globalVar = compact ? "g" : "global";
  if (hasExports && !name) {
    return error({
      code: "MISSING_NAME_OPTION_FOR_IIFE_EXPORT",
      message: 'You must supply "output.name" for UMD bundles that have exports so that the exports are accessible in environments without a module loader.'
    });
  }
  warnOnBuiltins(warn, dependencies);
  const amdDeps = dependencies.map((m) => `'${removeExtensionFromRelativeAmdId(m.id)}'`);
  const cjsDeps = dependencies.map((m) => `require('${m.id}')`);
  const trimmedImports = trimEmptyImports(dependencies);
  const globalDeps = trimmedImports.map((module2) => globalProp(module2.globalName, globalVar));
  const factoryArgs = trimmedImports.map((m) => m.name);
  if (namedExportsMode && (hasExports || noConflict)) {
    amdDeps.unshift(`'exports'`);
    cjsDeps.unshift(`exports`);
    globalDeps.unshift(assignToDeepVariable(name, globalVar, globals, compact, `${extend2 ? `${globalProp(name, globalVar)}${_}||${_}` : ""}{}`));
    factoryArgs.unshift("exports");
  }
  const completeAmdId = getCompleteAmdId(amd2, id);
  const amdParams = (completeAmdId ? `'${completeAmdId}',${_}` : ``) + (amdDeps.length ? `[${amdDeps.join(`,${_}`)}],${_}` : ``);
  const define2 = amd2.define;
  const cjsExport = !namedExportsMode && hasExports ? `module.exports${_}=${_}` : ``;
  const useStrict = strict ? `${_}'use strict';${n3}` : ``;
  let iifeExport;
  if (noConflict) {
    const noConflictExportsVar = compact ? "e" : "exports";
    let factory;
    if (!namedExportsMode && hasExports) {
      factory = `var ${noConflictExportsVar}${_}=${_}${assignToDeepVariable(name, globalVar, globals, compact, `${factoryVar}(${globalDeps.join(`,${_}`)})`)};`;
    } else {
      const module2 = globalDeps.shift();
      factory = `var ${noConflictExportsVar}${_}=${_}${module2};${n3}${t}${t}${factoryVar}(${[noConflictExportsVar].concat(globalDeps).join(`,${_}`)});`;
    }
    iifeExport = `(function${_}()${_}{${n3}${t}${t}var current${_}=${_}${safeAccess(name, globalVar, _)};${n3}${t}${t}${factory}${n3}${t}${t}${noConflictExportsVar}.noConflict${_}=${_}function${_}()${_}{${_}${globalProp(name, globalVar)}${_}=${_}current;${_}return ${noConflictExportsVar}${compact ? "" : "; "}};${n3}${t}}())`;
  } else {
    iifeExport = `${factoryVar}(${globalDeps.join(`,${_}`)})`;
    if (!namedExportsMode && hasExports) {
      iifeExport = assignToDeepVariable(name, globalVar, globals, compact, iifeExport);
    }
  }
  const iifeNeedsGlobal = hasExports || noConflict && namedExportsMode || globalDeps.length > 0;
  const globalParam = iifeNeedsGlobal ? `${globalVar},${_}` : "";
  const globalArg = iifeNeedsGlobal ? `this,${_}` : "";
  const iifeStart = iifeNeedsGlobal ? `(${globalVar}${_}=${_}typeof globalThis${_}!==${_}'undefined'${_}?${_}globalThis${_}:${_}${globalVar}${_}||${_}self,${_}` : "";
  const iifeEnd = iifeNeedsGlobal ? ")" : "";
  const cjsIntro = iifeNeedsGlobal ? `${t}typeof exports${_}===${_}'object'${_}&&${_}typeof module${_}!==${_}'undefined'${_}?${_}${cjsExport}${factoryVar}(${cjsDeps.join(`,${_}`)})${_}:${n3}` : "";
  const wrapperIntro = `(function${_}(${globalParam}${factoryVar})${_}{${n3}` + cjsIntro + `${t}typeof ${define2}${_}===${_}'function'${_}&&${_}${define2}.amd${_}?${_}${define2}(${amdParams}${factoryVar})${_}:${n3}${t}${iifeStart}${iifeExport}${iifeEnd};${n3}}(${globalArg}(function${_}(${factoryArgs.join(", ")})${_}{${useStrict}${n3}`;
  const wrapperOutro = n3 + n3 + "})));";
  magicString.prepend(`${intro}${getInteropBlock(dependencies, varOrConst, interop, externalLiveBindings, freeze, namespaceToStringTag, accessedGlobals, _, n3, s, t)}`);
  const exportBlock = getExportBlock$1(exports2, dependencies, namedExportsMode, interop, compact, t, externalLiveBindings);
  let namespaceMarkers = getNamespaceMarkers(namedExportsMode && hasExports, esModule, namespaceToStringTag, _, n3);
  if (namespaceMarkers) {
    namespaceMarkers = n3 + n3 + namespaceMarkers;
  }
  magicString.append(`${exportBlock}${namespaceMarkers}${outro}`);
  return magicString.trim().indent(t).append(wrapperOutro).prepend(wrapperIntro);
}
function getLinkMap(warn) {
  return function linkMap(source, map2) {
    if (map2.mappings) {
      return new Link(map2, [source]);
    }
    warn({
      code: "SOURCEMAP_BROKEN",
      message: `Sourcemap is likely to be incorrect: a plugin (${map2.plugin}) was used to transform files, but didn't generate a sourcemap for the transformation. Consult the plugin documentation for help`,
      plugin: map2.plugin,
      url: `https://rollupjs.org/guide/en/#warning-sourcemap-is-likely-to-be-incorrect`
    });
    return new Link({
      mappings: [],
      names: []
    }, [source]);
  };
}
function getCollapsedSourcemap(id, originalCode, originalSourcemap, sourcemapChain, linkMap) {
  let source;
  if (!originalSourcemap) {
    source = new Source(id, originalCode);
  } else {
    const sources = originalSourcemap.sources;
    const sourcesContent = originalSourcemap.sourcesContent || [];
    const directory = (0, import_path11.dirname)(id) || ".";
    const sourceRoot = originalSourcemap.sourceRoot || ".";
    const baseSources = sources.map((source2, i) => new Source((0, import_path11.resolve)(directory, sourceRoot, source2), sourcesContent[i]));
    source = new Link(originalSourcemap, baseSources);
  }
  return sourcemapChain.reduce(linkMap, source);
}
function collapseSourcemaps(file, map2, modules, bundleSourcemapChain, excludeContent, warn) {
  const linkMap = getLinkMap(warn);
  const moduleSources = modules.filter((module2) => !module2.excludeFromSourcemap).map((module2) => getCollapsedSourcemap(module2.id, module2.originalCode, module2.originalSourcemap, module2.sourcemapChain, linkMap));
  let source = new Link(map2, moduleSources);
  source = bundleSourcemapChain.reduce(linkMap, source);
  let { sources, sourcesContent, names, mappings } = source.traceMappings();
  if (file) {
    const directory = (0, import_path11.dirname)(file);
    sources = sources.map((source2) => (0, import_path11.relative)(directory, source2));
    file = (0, import_path11.basename)(file);
  }
  sourcesContent = excludeContent ? null : sourcesContent;
  return new SourceMap2({ file, mappings, names, sources, sourcesContent });
}
function collapseSourcemap(id, originalCode, originalSourcemap, sourcemapChain, warn) {
  if (!sourcemapChain.length) {
    return originalSourcemap;
  }
  const source = getCollapsedSourcemap(id, originalCode, originalSourcemap, sourcemapChain, getLinkMap(warn));
  const map2 = source.traceMappings();
  return { version: 3, ...map2 };
}
function deconflictChunk(modules, dependenciesToBeDeconflicted, imports, usedNames, format, interop, preserveModules, externalLiveBindings, chunkByModule, syntheticExports, exportNamesByVariable, accessedGlobalsByScope, includedNamespaces) {
  const reversedModules = modules.slice().reverse();
  for (const module2 of reversedModules) {
    module2.scope.addUsedOutsideNames(usedNames, format, exportNamesByVariable, accessedGlobalsByScope);
  }
  deconflictTopLevelVariables(usedNames, reversedModules, includedNamespaces);
  DECONFLICT_IMPORTED_VARIABLES_BY_FORMAT[format](usedNames, imports, dependenciesToBeDeconflicted, interop, preserveModules, externalLiveBindings, chunkByModule, syntheticExports);
  for (const module2 of reversedModules) {
    module2.scope.deconflict(format, exportNamesByVariable, accessedGlobalsByScope);
  }
}
function deconflictImportsEsmOrSystem(usedNames, imports, dependenciesToBeDeconflicted, _interop, preserveModules, _externalLiveBindings, chunkByModule, syntheticExports) {
  for (const dependency of dependenciesToBeDeconflicted.dependencies) {
    if (preserveModules || dependency instanceof ExternalModule) {
      dependency.variableName = getSafeName(dependency.suggestedVariableName, usedNames);
    }
  }
  for (const variable of imports) {
    const module2 = variable.module;
    const name = variable.name;
    if (variable.isNamespace && (preserveModules || module2 instanceof ExternalModule)) {
      variable.setRenderNames(null, (module2 instanceof ExternalModule ? module2 : chunkByModule.get(module2)).variableName);
    } else if (module2 instanceof ExternalModule && name === "default") {
      variable.setRenderNames(null, getSafeName([...module2.exportedVariables].some(([exportedVariable, exportedName]) => exportedName === "*" && exportedVariable.included) ? module2.suggestedVariableName + "__default" : module2.suggestedVariableName, usedNames));
    } else {
      variable.setRenderNames(null, getSafeName(name, usedNames));
    }
  }
  for (const variable of syntheticExports) {
    variable.setRenderNames(null, getSafeName(variable.name, usedNames));
  }
}
function deconflictImportsOther(usedNames, imports, { deconflictedDefault, deconflictedNamespace, dependencies }, interop, preserveModules, externalLiveBindings, chunkByModule) {
  for (const chunkOrExternalModule of dependencies) {
    chunkOrExternalModule.variableName = getSafeName(chunkOrExternalModule.suggestedVariableName, usedNames);
  }
  for (const externalModuleOrChunk of deconflictedNamespace) {
    externalModuleOrChunk.namespaceVariableName = getSafeName(`${externalModuleOrChunk.suggestedVariableName}__namespace`, usedNames);
  }
  for (const externalModule of deconflictedDefault) {
    if (deconflictedNamespace.has(externalModule) && canDefaultBeTakenFromNamespace(String(interop(externalModule.id)), externalLiveBindings)) {
      externalModule.defaultVariableName = externalModule.namespaceVariableName;
    } else {
      externalModule.defaultVariableName = getSafeName(`${externalModule.suggestedVariableName}__default`, usedNames);
    }
  }
  for (const variable of imports) {
    const module2 = variable.module;
    if (module2 instanceof ExternalModule) {
      const name = variable.name;
      if (name === "default") {
        const moduleInterop = String(interop(module2.id));
        const variableName = defaultInteropHelpersByInteropType[moduleInterop] ? module2.defaultVariableName : module2.variableName;
        if (isDefaultAProperty(moduleInterop, externalLiveBindings)) {
          variable.setRenderNames(variableName, "default");
        } else {
          variable.setRenderNames(null, variableName);
        }
      } else if (name === "*") {
        variable.setRenderNames(null, namespaceInteropHelpersByInteropType[String(interop(module2.id))] ? module2.namespaceVariableName : module2.variableName);
      } else {
        variable.setRenderNames(module2.variableName, null);
      }
    } else {
      const chunk = chunkByModule.get(module2);
      if (preserveModules && variable.isNamespace) {
        variable.setRenderNames(null, chunk.exportMode === "default" ? chunk.namespaceVariableName : chunk.variableName);
      } else if (chunk.exportMode === "default") {
        variable.setRenderNames(null, chunk.variableName);
      } else {
        variable.setRenderNames(chunk.variableName, chunk.getVariableExportName(variable));
      }
    }
  }
}
function deconflictTopLevelVariables(usedNames, modules, includedNamespaces) {
  for (const module2 of modules) {
    for (const variable of module2.scope.variables.values()) {
      if (variable.included && // this will only happen for exports in some formats
      !(variable.renderBaseName || variable instanceof ExportDefaultVariable && variable.getOriginalVariable() !== variable)) {
        variable.setRenderNames(null, getSafeName(variable.name, usedNames));
      }
    }
    if (includedNamespaces.has(module2)) {
      const namespace = module2.namespace;
      namespace.setRenderNames(null, getSafeName(namespace.name, usedNames));
    }
  }
}
function escapeId(id) {
  if (!id.match(needsEscapeRegEx))
    return id;
  return id.replace(backSlashRegEx, "\\\\").replace(quoteNewlineRegEx, "\\$1");
}
function assignExportsToMangledNames(exports2, exportsByName, exportNamesByVariable) {
  let nameIndex = 0;
  for (const variable of exports2) {
    let exportName = variable.name[0];
    if (exportsByName[exportName]) {
      do {
        exportName = toBase64(++nameIndex);
        if (exportName.charCodeAt(0) === 49) {
          nameIndex += 9 * 64 ** (exportName.length - 1);
          exportName = toBase64(nameIndex);
        }
      } while (RESERVED_NAMES[exportName] || exportsByName[exportName]);
    }
    exportsByName[exportName] = variable;
    exportNamesByVariable.set(variable, [exportName]);
  }
}
function assignExportsToNames(exports2, exportsByName, exportNamesByVariable) {
  for (const variable of exports2) {
    let nameIndex = 0;
    let exportName = variable.name;
    while (exportsByName[exportName]) {
      exportName = variable.name + "$" + ++nameIndex;
    }
    exportsByName[exportName] = variable;
    exportNamesByVariable.set(variable, [exportName]);
  }
}
function getExportMode(chunk, { exports: exportMode, name, format }, unsetOptions, facadeModuleId, warn) {
  const exportKeys = chunk.getExportNames();
  if (exportMode === "default") {
    if (exportKeys.length !== 1 || exportKeys[0] !== "default") {
      return error(errIncompatibleExportOptionValue("default", exportKeys, facadeModuleId));
    }
  } else if (exportMode === "none" && exportKeys.length) {
    return error(errIncompatibleExportOptionValue("none", exportKeys, facadeModuleId));
  }
  if (exportMode === "auto") {
    if (exportKeys.length === 0) {
      exportMode = "none";
    } else if (exportKeys.length === 1 && exportKeys[0] === "default") {
      if (format === "cjs" && unsetOptions.has("exports")) {
        warn(errPreferNamedExports(facadeModuleId));
      }
      exportMode = "default";
    } else {
      if (format !== "es" && exportKeys.indexOf("default") !== -1) {
        warn(errMixedExport(facadeModuleId, name));
      }
      exportMode = "named";
    }
  }
  return exportMode;
}
function guessIndentString(code) {
  const lines = code.split("\n");
  const tabbed = lines.filter((line) => /^\t+/.test(line));
  const spaced = lines.filter((line) => /^ {2,}/.test(line));
  if (tabbed.length === 0 && spaced.length === 0) {
    return null;
  }
  if (tabbed.length >= spaced.length) {
    return "	";
  }
  const min = spaced.reduce((previous, current2) => {
    const numSpaces = /^ +/.exec(current2)[0].length;
    return Math.min(numSpaces, previous);
  }, Infinity);
  return new Array(min + 1).join(" ");
}
function getIndentString3(modules, options) {
  if (options.indent !== true)
    return options.indent;
  for (let i = 0; i < modules.length; i++) {
    const indent3 = guessIndentString(modules[i].originalCode);
    if (indent3 !== null)
      return indent3;
  }
  return "	";
}
function getStaticDependencies(chunk, orderedModules, chunkByModule) {
  const staticDependencyBlocks = [];
  const handledDependencies = /* @__PURE__ */ new Set();
  for (let modulePos = orderedModules.length - 1; modulePos >= 0; modulePos--) {
    const module2 = orderedModules[modulePos];
    if (!handledDependencies.has(module2)) {
      const staticDependencies = [];
      addStaticDependencies(module2, staticDependencies, handledDependencies, chunk, chunkByModule);
      staticDependencyBlocks.unshift(staticDependencies);
    }
  }
  const dependencies = /* @__PURE__ */ new Set();
  for (const block of staticDependencyBlocks) {
    for (const dependency of block) {
      dependencies.add(dependency);
    }
  }
  return dependencies;
}
function addStaticDependencies(module2, staticDependencies, handledModules, chunk, chunkByModule) {
  const dependencies = module2.getDependenciesToBeIncluded();
  for (const dependency of dependencies) {
    if (dependency instanceof ExternalModule) {
      staticDependencies.push(dependency);
      continue;
    }
    const dependencyChunk = chunkByModule.get(dependency);
    if (dependencyChunk !== chunk) {
      staticDependencies.push(dependencyChunk);
      continue;
    }
    if (!handledModules.has(dependency)) {
      handledModules.add(dependency);
      addStaticDependencies(dependency, staticDependencies, handledModules, chunk, chunkByModule);
    }
  }
}
function decodedSourcemap(map2) {
  if (!map2)
    return null;
  if (typeof map2 === "string") {
    map2 = JSON.parse(map2);
  }
  if (map2.mappings === "") {
    return {
      mappings: [],
      names: [],
      sources: [],
      version: 3
    };
  }
  let mappings;
  if (typeof map2.mappings === "string") {
    mappings = decode2(map2.mappings);
  } else {
    mappings = map2.mappings;
  }
  return { ...map2, mappings };
}
function renderChunk({ code, options, outputPluginDriver, renderChunk: renderChunk2, sourcemapChain }) {
  const renderChunkReducer = (code2, result2, plugin) => {
    if (result2 == null)
      return code2;
    if (typeof result2 === "string")
      result2 = {
        code: result2,
        map: void 0
      };
    if (result2.map !== null) {
      const map2 = decodedSourcemap(result2.map);
      sourcemapChain.push(map2 || { missing: true, plugin: plugin.name });
    }
    return result2.code;
  };
  return outputPluginDriver.hookReduceArg0("renderChunk", [code, renderChunk2, options], renderChunkReducer);
}
function renderNamePattern(pattern, patternName, replacements) {
  if (isPathFragment(pattern))
    return error(errFailedValidation(`Invalid pattern "${pattern}" for "${patternName}", patterns can be neither absolute nor relative paths.`));
  return pattern.replace(/\[(\w+)\]/g, (_match, type) => {
    if (!replacements.hasOwnProperty(type)) {
      return error(errFailedValidation(`"[${type}]" is not a valid placeholder in "${patternName}" pattern.`));
    }
    const replacement = replacements[type]();
    if (isPathFragment(replacement))
      return error(errFailedValidation(`Invalid substitution "${replacement}" for placeholder "[${type}]" in "${patternName}" pattern, can be neither absolute nor relative path.`));
    return replacement;
  });
}
function makeUnique(name, existingNames) {
  const existingNamesLowercase = new Set(Object.keys(existingNames).map((key) => key.toLowerCase()));
  if (!existingNamesLowercase.has(name.toLocaleLowerCase()))
    return name;
  const ext2 = (0, import_path11.extname)(name);
  name = name.substr(0, name.length - ext2.length);
  let uniqueName, uniqueIndex = 1;
  while (existingNamesLowercase.has((uniqueName = name + ++uniqueIndex + ext2).toLowerCase()))
    ;
  return uniqueName;
}
function getGlobalName(module2, globals, hasExports, warn) {
  const globalName = typeof globals === "function" ? globals(module2.id) : globals[module2.id];
  if (globalName) {
    return globalName;
  }
  if (hasExports) {
    warn({
      code: "MISSING_GLOBAL_NAME",
      guess: module2.variableName,
      message: `No name was provided for external module '${module2.id}' in output.globals \u2013 guessing '${module2.variableName}'`,
      source: module2.id
    });
    return module2.variableName;
  }
}
function getChunkNameFromModule(module2) {
  return module2.chunkName || getAliasName(module2.id);
}
function generateAssetFileName(name, source, outputOptions, bundle) {
  const emittedName = outputOptions.sanitizeFileName(name || "asset");
  return makeUnique(renderNamePattern(typeof outputOptions.assetFileNames === "function" ? outputOptions.assetFileNames({ name, source, type: "asset" }) : outputOptions.assetFileNames, "output.assetFileNames", {
    ext: () => (0, import_path11.extname)(emittedName).substr(1),
    extname: () => (0, import_path11.extname)(emittedName),
    hash() {
      const hash = createHash();
      hash.update(emittedName);
      hash.update(":");
      hash.update(source);
      return hash.digest("hex").substr(0, 8);
    },
    name: () => emittedName.substr(0, emittedName.length - (0, import_path11.extname)(emittedName).length)
  }), bundle);
}
function reserveFileNameInBundle(fileName, bundle, warn) {
  if (fileName in bundle) {
    warn(errFileNameConflict(fileName));
  }
  bundle[fileName] = FILE_PLACEHOLDER;
}
function hasValidType(emittedFile) {
  return Boolean(emittedFile && (emittedFile.type === "asset" || emittedFile.type === "chunk"));
}
function hasValidName(emittedFile) {
  const validatedName = emittedFile.fileName || emittedFile.name;
  return !validatedName || typeof validatedName === "string" && !isPathFragment(validatedName);
}
function getValidSource(source, emittedFile, fileReferenceId) {
  if (!(typeof source === "string" || source instanceof Uint8Array)) {
    const assetName = emittedFile.fileName || emittedFile.name || fileReferenceId;
    return error(errFailedValidation(`Could not set source for ${typeof assetName === "string" ? `asset "${assetName}"` : "unnamed asset"}, asset source needs to be a string, Uint8Array or Buffer.`));
  }
  return source;
}
function getAssetFileName(file, referenceId) {
  if (typeof file.fileName !== "string") {
    return error(errAssetNotFinalisedForFileName(file.name || referenceId));
  }
  return file.fileName;
}
function getChunkFileName(file, facadeChunkByModule) {
  var _a;
  const fileName = file.fileName || file.module && ((_a = facadeChunkByModule === null || facadeChunkByModule === void 0 ? void 0 : facadeChunkByModule.get(file.module)) === null || _a === void 0 ? void 0 : _a.id);
  if (!fileName)
    return error(errChunkNotGeneratedForFileName(file.fileName || file.name));
  return fileName;
}
function findExistingAssetFileNameWithSource(bundle, source) {
  for (const [fileName, outputFile] of Object.entries(bundle)) {
    if (outputFile.type === "asset" && areSourcesEqual(source, outputFile.source))
      return fileName;
  }
  return null;
}
function areSourcesEqual(sourceA, sourceB) {
  if (typeof sourceA === "string") {
    return sourceA === sourceB;
  }
  if (typeof sourceB === "string") {
    return false;
  }
  if ("equals" in sourceA) {
    return sourceA.equals(sourceB);
  }
  if (sourceA.length !== sourceB.length) {
    return false;
  }
  for (let index2 = 0; index2 < sourceA.length; index2++) {
    if (sourceA[index2] !== sourceB[index2]) {
      return false;
    }
  }
  return true;
}
async function createAddons(options, outputPluginDriver) {
  try {
    let [banner, footer, intro, outro] = await Promise.all([
      outputPluginDriver.hookReduceValue("banner", options.banner(), [], concatSep),
      outputPluginDriver.hookReduceValue("footer", options.footer(), [], concatSep),
      outputPluginDriver.hookReduceValue("intro", options.intro(), [], concatDblSep),
      outputPluginDriver.hookReduceValue("outro", options.outro(), [], concatDblSep)
    ]);
    if (intro)
      intro += "\n\n";
    if (outro)
      outro = `

${outro}`;
    if (banner.length)
      banner += "\n";
    if (footer.length)
      footer = "\n" + footer;
    return { banner, footer, intro, outro };
  } catch (err2) {
    return error({
      code: "ADDON_ERROR",
      message: `Could not retrieve ${err2.hook}. Check configuration of plugin ${err2.plugin}.
	Error Message: ${err2.message}`
    });
  }
}
function getChunkAssignments(entryModules, manualChunkAliasByEntry) {
  const chunkDefinitions = [];
  const modulesInManualChunks = new Set(manualChunkAliasByEntry.keys());
  const manualChunkModulesByAlias = /* @__PURE__ */ Object.create(null);
  for (const [entry, alias] of manualChunkAliasByEntry) {
    const chunkModules = manualChunkModulesByAlias[alias] = manualChunkModulesByAlias[alias] || [];
    addStaticDependenciesToManualChunk(entry, chunkModules, modulesInManualChunks);
  }
  for (const [alias, modules] of Object.entries(manualChunkModulesByAlias)) {
    chunkDefinitions.push({ alias, modules });
  }
  const assignedEntryPointsByModule = /* @__PURE__ */ new Map();
  const { dependentEntryPointsByModule, dynamicEntryModules } = analyzeModuleGraph(entryModules);
  const dynamicallyDependentEntryPointsByDynamicEntry = getDynamicDependentEntryPoints(dependentEntryPointsByModule, dynamicEntryModules);
  const staticEntries = new Set(entryModules);
  function assignEntryToStaticDependencies(entry, dynamicDependentEntryPoints) {
    const modulesToHandle = /* @__PURE__ */ new Set([entry]);
    for (const module2 of modulesToHandle) {
      const assignedEntryPoints = getOrCreate(assignedEntryPointsByModule, module2, () => /* @__PURE__ */ new Set());
      if (dynamicDependentEntryPoints && areEntryPointsContainedOrDynamicallyDependent(dynamicDependentEntryPoints, dependentEntryPointsByModule.get(module2))) {
        continue;
      } else {
        assignedEntryPoints.add(entry);
      }
      for (const dependency of module2.getDependenciesToBeIncluded()) {
        if (!(dependency instanceof ExternalModule || modulesInManualChunks.has(dependency))) {
          modulesToHandle.add(dependency);
        }
      }
    }
  }
  function areEntryPointsContainedOrDynamicallyDependent(entryPoints, containedIn) {
    const entriesToCheck = new Set(entryPoints);
    for (const entry of entriesToCheck) {
      if (!containedIn.has(entry)) {
        if (staticEntries.has(entry))
          return false;
        const dynamicallyDependentEntryPoints = dynamicallyDependentEntryPointsByDynamicEntry.get(entry);
        for (const dependentEntry of dynamicallyDependentEntryPoints) {
          entriesToCheck.add(dependentEntry);
        }
      }
    }
    return true;
  }
  for (const entry of entryModules) {
    if (!modulesInManualChunks.has(entry)) {
      assignEntryToStaticDependencies(entry, null);
    }
  }
  for (const entry of dynamicEntryModules) {
    if (!modulesInManualChunks.has(entry)) {
      assignEntryToStaticDependencies(entry, dynamicallyDependentEntryPointsByDynamicEntry.get(entry));
    }
  }
  chunkDefinitions.push(...createChunks([...entryModules, ...dynamicEntryModules], assignedEntryPointsByModule));
  return chunkDefinitions;
}
function addStaticDependenciesToManualChunk(entry, manualChunkModules, modulesInManualChunks) {
  const modulesToHandle = /* @__PURE__ */ new Set([entry]);
  for (const module2 of modulesToHandle) {
    modulesInManualChunks.add(module2);
    manualChunkModules.push(module2);
    for (const dependency of module2.dependencies) {
      if (!(dependency instanceof ExternalModule || modulesInManualChunks.has(dependency))) {
        modulesToHandle.add(dependency);
      }
    }
  }
}
function analyzeModuleGraph(entryModules) {
  const dynamicEntryModules = /* @__PURE__ */ new Set();
  const dependentEntryPointsByModule = /* @__PURE__ */ new Map();
  const entriesToHandle = new Set(entryModules);
  for (const currentEntry of entriesToHandle) {
    const modulesToHandle = /* @__PURE__ */ new Set([currentEntry]);
    for (const module2 of modulesToHandle) {
      getOrCreate(dependentEntryPointsByModule, module2, () => /* @__PURE__ */ new Set()).add(currentEntry);
      for (const dependency of module2.getDependenciesToBeIncluded()) {
        if (!(dependency instanceof ExternalModule)) {
          modulesToHandle.add(dependency);
        }
      }
      for (const { resolution } of module2.dynamicImports) {
        if (resolution instanceof Module && resolution.includedDynamicImporters.length > 0) {
          dynamicEntryModules.add(resolution);
          entriesToHandle.add(resolution);
        }
      }
      for (const dependency of module2.implicitlyLoadedBefore) {
        dynamicEntryModules.add(dependency);
        entriesToHandle.add(dependency);
      }
    }
  }
  return { dependentEntryPointsByModule, dynamicEntryModules };
}
function getDynamicDependentEntryPoints(dependentEntryPointsByModule, dynamicEntryModules) {
  const dynamicallyDependentEntryPointsByDynamicEntry = /* @__PURE__ */ new Map();
  for (const dynamicEntry of dynamicEntryModules) {
    const dynamicDependentEntryPoints = getOrCreate(dynamicallyDependentEntryPointsByDynamicEntry, dynamicEntry, () => /* @__PURE__ */ new Set());
    for (const importer of [
      ...dynamicEntry.includedDynamicImporters,
      ...dynamicEntry.implicitlyLoadedAfter
    ]) {
      for (const entryPoint of dependentEntryPointsByModule.get(importer)) {
        dynamicDependentEntryPoints.add(entryPoint);
      }
    }
  }
  return dynamicallyDependentEntryPointsByDynamicEntry;
}
function createChunks(allEntryPoints, assignedEntryPointsByModule) {
  const chunkModules = /* @__PURE__ */ Object.create(null);
  for (const [module2, assignedEntryPoints] of assignedEntryPointsByModule) {
    let chunkSignature = "";
    for (const entry of allEntryPoints) {
      chunkSignature += assignedEntryPoints.has(entry) ? "X" : "_";
    }
    const chunk = chunkModules[chunkSignature];
    if (chunk) {
      chunk.push(module2);
    } else {
      chunkModules[chunkSignature] = [module2];
    }
  }
  return Object.values(chunkModules).map((modules) => ({
    alias: null,
    modules
  }));
}
function commondir(files) {
  if (files.length === 0)
    return "/";
  if (files.length === 1)
    return (0, import_path11.dirname)(files[0]);
  const commonSegments = files.slice(1).reduce((commonSegments2, file) => {
    const pathSegements = file.split(/\/+|\\+/);
    let i;
    for (i = 0; commonSegments2[i] === pathSegements[i] && i < Math.min(commonSegments2.length, pathSegements.length); i++)
      ;
    return commonSegments2.slice(0, i);
  }, files[0].split(/\/+|\\+/));
  return commonSegments.length > 1 ? commonSegments.join("/") : "/";
}
function sortByExecutionOrder(units) {
  units.sort(compareExecIndex);
}
function analyseModuleExecution(entryModules) {
  let nextExecIndex = 0;
  const cyclePaths = [];
  const analysedModules = /* @__PURE__ */ new Set();
  const dynamicImports = /* @__PURE__ */ new Set();
  const parents = /* @__PURE__ */ new Map();
  const orderedModules = [];
  const analyseModule = (module2) => {
    if (module2 instanceof Module) {
      for (const dependency of module2.dependencies) {
        if (parents.has(dependency)) {
          if (!analysedModules.has(dependency)) {
            cyclePaths.push(getCyclePath(dependency, module2, parents));
          }
          continue;
        }
        parents.set(dependency, module2);
        analyseModule(dependency);
      }
      for (const dependency of module2.implicitlyLoadedBefore) {
        dynamicImports.add(dependency);
      }
      for (const { resolution } of module2.dynamicImports) {
        if (resolution instanceof Module) {
          dynamicImports.add(resolution);
        }
      }
      orderedModules.push(module2);
    }
    module2.execIndex = nextExecIndex++;
    analysedModules.add(module2);
  };
  for (const curEntry of entryModules) {
    if (!parents.has(curEntry)) {
      parents.set(curEntry, null);
      analyseModule(curEntry);
    }
  }
  for (const curEntry of dynamicImports) {
    if (!parents.has(curEntry)) {
      parents.set(curEntry, null);
      analyseModule(curEntry);
    }
  }
  return { cyclePaths, orderedModules };
}
function getCyclePath(module2, parent, parents) {
  const cycleSymbol = Symbol(module2.id);
  const path6 = [relativeId(module2.id)];
  let nextModule = parent;
  module2.cycles.add(cycleSymbol);
  while (nextModule !== module2) {
    nextModule.cycles.add(cycleSymbol);
    path6.push(relativeId(nextModule.id));
    nextModule = parents.get(nextModule);
  }
  path6.push(path6[0]);
  path6.reverse();
  return path6;
}
function getAbsoluteEntryModulePaths(chunks) {
  const absoluteEntryModulePaths = [];
  for (const chunk of chunks) {
    for (const entryModule of chunk.entryModules) {
      if (isAbsolute3(entryModule.id)) {
        absoluteEntryModulePaths.push(entryModule.id);
      }
    }
  }
  return absoluteEntryModulePaths;
}
function validateOptionsForMultiChunkOutput(outputOptions, onWarn) {
  if (outputOptions.format === "umd" || outputOptions.format === "iife")
    return error({
      code: "INVALID_OPTION",
      message: "UMD and IIFE output formats are not supported for code-splitting builds."
    });
  if (typeof outputOptions.file === "string")
    return error({
      code: "INVALID_OPTION",
      message: 'When building multiple chunks, the "output.dir" option must be used, not "output.file". To inline dynamic imports, set the "inlineDynamicImports" option.'
    });
  if (outputOptions.sourcemapFile)
    return error({
      code: "INVALID_OPTION",
      message: '"output.sourcemapFile" is only supported for single-file builds.'
    });
  if (!outputOptions.amd.autoId && outputOptions.amd.id)
    onWarn({
      code: "INVALID_OPTION",
      message: '"output.amd.id" is only properly supported for single-file builds. Use "output.amd.autoId" and "output.amd.basePath".'
    });
}
function getIncludedModules(modulesById) {
  return [...modulesById.values()].filter((module2) => module2 instanceof Module && (module2.isIncluded() || module2.info.isEntry || module2.includedDynamicImporters.length > 0));
}
function addModuleToManualChunk(alias, module2, manualChunkAliasByEntry) {
  const existingAlias = manualChunkAliasByEntry.get(module2);
  if (typeof existingAlias === "string" && existingAlias !== alias) {
    return error(errCannotAssignModuleToChunk(module2.id, alias, existingAlias));
  }
  manualChunkAliasByEntry.set(module2, alias);
}
function isInAstralSet(code, set) {
  var pos = 65536;
  for (var i = 0; i < set.length; i += 2) {
    pos += set[i];
    if (pos > code) {
      return false;
    }
    pos += set[i + 1];
    if (pos >= code) {
      return true;
    }
  }
}
function isIdentifierStart(code, astral) {
  if (code < 65) {
    return code === 36;
  }
  if (code < 91) {
    return true;
  }
  if (code < 97) {
    return code === 95;
  }
  if (code < 123) {
    return true;
  }
  if (code <= 65535) {
    return code >= 170 && nonASCIIidentifierStart.test(String.fromCharCode(code));
  }
  if (astral === false) {
    return false;
  }
  return isInAstralSet(code, astralIdentifierStartCodes);
}
function isIdentifierChar(code, astral) {
  if (code < 48) {
    return code === 36;
  }
  if (code < 58) {
    return true;
  }
  if (code < 65) {
    return false;
  }
  if (code < 91) {
    return true;
  }
  if (code < 97) {
    return code === 95;
  }
  if (code < 123) {
    return true;
  }
  if (code <= 65535) {
    return code >= 170 && nonASCIIidentifier.test(String.fromCharCode(code));
  }
  if (astral === false) {
    return false;
  }
  return isInAstralSet(code, astralIdentifierStartCodes) || isInAstralSet(code, astralIdentifierCodes);
}
function binop(name, prec) {
  return new TokenType(name, { beforeExpr: true, binop: prec });
}
function kw(name, options) {
  if (options === void 0) options = {};
  options.keyword = name;
  return keywords$1[name] = new TokenType(name, options);
}
function isNewLine(code, ecma2019String) {
  return code === 10 || code === 13 || !ecma2019String && (code === 8232 || code === 8233);
}
function has2(obj, propName) {
  return hasOwnProperty.call(obj, propName);
}
function wordsRegexp(words) {
  return new RegExp("^(?:" + words.replace(/ /g, "|") + ")$");
}
function getLineInfo(input, offset2) {
  for (var line = 1, cur = 0; ; ) {
    lineBreakG.lastIndex = cur;
    var match2 = lineBreakG.exec(input);
    if (match2 && match2.index < offset2) {
      ++line;
      cur = match2.index + match2[0].length;
    } else {
      return new Position(line, offset2 - cur);
    }
  }
}
function getOptions(opts) {
  var options = {};
  for (var opt in defaultOptions) {
    options[opt] = opts && has2(opts, opt) ? opts[opt] : defaultOptions[opt];
  }
  if (options.ecmaVersion === "latest") {
    options.ecmaVersion = 1e8;
  } else if (options.ecmaVersion == null) {
    if (!warnedAboutEcmaVersion && typeof console === "object" && console.warn) {
      warnedAboutEcmaVersion = true;
      console.warn("Since Acorn 8.0.0, options.ecmaVersion is required.\nDefaulting to 2020, but this will stop working in the future.");
    }
    options.ecmaVersion = 11;
  } else if (options.ecmaVersion >= 2015) {
    options.ecmaVersion -= 2009;
  }
  if (options.allowReserved == null) {
    options.allowReserved = options.ecmaVersion < 5;
  }
  if (options.allowAwaitOutsideFunction == null) {
    options.allowAwaitOutsideFunction = options.ecmaVersion >= 13;
  }
  if (isArray3(options.onToken)) {
    var tokens = options.onToken;
    options.onToken = function(token) {
      return tokens.push(token);
    };
  }
  if (isArray3(options.onComment)) {
    options.onComment = pushComment(options, options.onComment);
  }
  return options;
}
function pushComment(options, array) {
  return function(block, text, start, end, startLoc, endLoc) {
    var comment = {
      type: block ? "Block" : "Line",
      value: text,
      start,
      end
    };
    if (options.locations) {
      comment.loc = new SourceLocation(this, startLoc, endLoc);
    }
    if (options.ranges) {
      comment.range = [start, end];
    }
    array.push(comment);
  };
}
function functionFlags(async, generator) {
  return SCOPE_FUNCTION | (async ? SCOPE_ASYNC : 0) | (generator ? SCOPE_GENERATOR : 0);
}
function DestructuringErrors() {
  this.shorthandAssign = this.trailingComma = this.parenthesizedAssign = this.parenthesizedBind = this.doubleProto = -1;
}
function isPrivateNameConflicted(privateNameMap, element) {
  var name = element.key.name;
  var curr = privateNameMap[name];
  var next = "true";
  if (element.type === "MethodDefinition" && (element.kind === "get" || element.kind === "set")) {
    next = (element.static ? "s" : "i") + element.kind;
  }
  if (curr === "iget" && next === "iset" || curr === "iset" && next === "iget" || curr === "sget" && next === "sset" || curr === "sset" && next === "sget") {
    privateNameMap[name] = "true";
    return false;
  } else if (!curr) {
    privateNameMap[name] = next;
    return false;
  } else {
    return true;
  }
}
function checkKeyName(node, name) {
  var computed = node.computed;
  var key = node.key;
  return !computed && (key.type === "Identifier" && key.name === name || key.type === "Literal" && key.value === name);
}
function isPrivateFieldAccess(node) {
  return node.type === "MemberExpression" && node.property.type === "PrivateIdentifier" || node.type === "ChainExpression" && isPrivateFieldAccess(node.expression);
}
function finishNodeAt(node, type, pos, loc) {
  node.type = type;
  node.end = pos;
  if (this.options.locations) {
    node.loc.end = loc;
  }
  if (this.options.ranges) {
    node.range[1] = pos;
  }
  return node;
}
function buildUnicodeData(ecmaVersion) {
  var d = data[ecmaVersion] = {
    binary: wordsRegexp(unicodeBinaryProperties[ecmaVersion] + " " + unicodeGeneralCategoryValues),
    nonBinary: {
      General_Category: wordsRegexp(unicodeGeneralCategoryValues),
      Script: wordsRegexp(unicodeScriptValues[ecmaVersion])
    }
  };
  d.nonBinary.Script_Extensions = d.nonBinary.Script;
  d.nonBinary.gc = d.nonBinary.General_Category;
  d.nonBinary.sc = d.nonBinary.Script;
  d.nonBinary.scx = d.nonBinary.Script_Extensions;
}
function codePointToString(ch) {
  if (ch <= 65535) {
    return String.fromCharCode(ch);
  }
  ch -= 65536;
  return String.fromCharCode((ch >> 10) + 55296, (ch & 1023) + 56320);
}
function isSyntaxCharacter(ch) {
  return ch === 36 || ch >= 40 && ch <= 43 || ch === 46 || ch === 63 || ch >= 91 && ch <= 94 || ch >= 123 && ch <= 125;
}
function isRegExpIdentifierStart(ch) {
  return isIdentifierStart(ch, true) || ch === 36 || ch === 95;
}
function isRegExpIdentifierPart(ch) {
  return isIdentifierChar(ch, true) || ch === 36 || ch === 95 || ch === 8204 || ch === 8205;
}
function isControlLetter(ch) {
  return ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122;
}
function isValidUnicode(ch) {
  return ch >= 0 && ch <= 1114111;
}
function isCharacterClassEscape(ch) {
  return ch === 100 || ch === 68 || ch === 115 || ch === 83 || ch === 119 || ch === 87;
}
function isUnicodePropertyNameCharacter(ch) {
  return isControlLetter(ch) || ch === 95;
}
function isUnicodePropertyValueCharacter(ch) {
  return isUnicodePropertyNameCharacter(ch) || isDecimalDigit(ch);
}
function isDecimalDigit(ch) {
  return ch >= 48 && ch <= 57;
}
function isHexDigit(ch) {
  return ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102;
}
function hexToInt(ch) {
  if (ch >= 65 && ch <= 70) {
    return 10 + (ch - 65);
  }
  if (ch >= 97 && ch <= 102) {
    return 10 + (ch - 97);
  }
  return ch - 48;
}
function isOctalDigit(ch) {
  return ch >= 48 && ch <= 55;
}
function stringToNumber(str, isLegacyOctalNumericLiteral) {
  if (isLegacyOctalNumericLiteral) {
    return parseInt(str, 8);
  }
  return parseFloat(str.replace(/_/g, ""));
}
function stringToBigInt(str) {
  if (typeof BigInt !== "function") {
    return null;
  }
  return BigInt(str.replace(/_/g, ""));
}
function codePointToString$1(code) {
  if (code <= 65535) {
    return String.fromCharCode(code);
  }
  code -= 65536;
  return String.fromCharCode((code >> 10) + 55296, (code & 1023) + 56320);
}
function mkdirpath(path6) {
  const dir = (0, import_path11.dirname)(path6);
  try {
    import_fs2.default.readdirSync(dir);
  } catch (err2) {
    mkdirpath(dir);
    try {
      import_fs2.default.mkdirSync(dir);
    } catch (err22) {
      if (err22.code !== "EEXIST") {
        throw err22;
      }
    }
  }
}
function writeFile(dest, data2) {
  return new Promise((fulfil, reject) => {
    mkdirpath(dest);
    import_fs2.default.writeFile(dest, data2, (err2) => {
      if (err2) {
        reject(err2);
      } else {
        fulfil();
      }
    });
  });
}
function resolveIdViaPlugins(source, importer, pluginDriver, moduleLoaderResolveId, skip, customOptions) {
  let skipped = null;
  let replaceContext = null;
  if (skip) {
    skipped = /* @__PURE__ */ new Set();
    for (const skippedCall of skip) {
      if (source === skippedCall.source && importer === skippedCall.importer) {
        skipped.add(skippedCall.plugin);
      }
    }
    replaceContext = (pluginContext, plugin) => ({
      ...pluginContext,
      resolve: (source2, importer2, { custom, skipSelf } = BLANK) => {
        return moduleLoaderResolveId(source2, importer2, custom, skipSelf ? [...skip, { importer: importer2, plugin, source: source2 }] : skip);
      }
    });
  }
  return pluginDriver.hookFirst("resolveId", [source, importer, { custom: customOptions }], replaceContext, skipped);
}
async function resolveId2(source, importer, preserveSymlinks, pluginDriver, moduleLoaderResolveId, skip, customOptions) {
  const pluginResult = await resolveIdViaPlugins(source, importer, pluginDriver, moduleLoaderResolveId, skip, customOptions);
  if (pluginResult != null)
    return pluginResult;
  if (importer !== void 0 && !isAbsolute3(source) && source[0] !== ".")
    return null;
  return addJsExtensionIfNecessary(importer ? (0, import_path11.resolve)((0, import_path11.dirname)(importer), source) : (0, import_path11.resolve)(source), preserveSymlinks);
}
function addJsExtensionIfNecessary(file, preserveSymlinks) {
  let found2 = findFile(file, preserveSymlinks);
  if (found2)
    return found2;
  found2 = findFile(file + ".mjs", preserveSymlinks);
  if (found2)
    return found2;
  found2 = findFile(file + ".js", preserveSymlinks);
  return found2;
}
function findFile(file, preserveSymlinks) {
  try {
    const stats = (0, import_fs2.lstatSync)(file);
    if (!preserveSymlinks && stats.isSymbolicLink())
      return findFile((0, import_fs2.realpathSync)(file), preserveSymlinks);
    if (preserveSymlinks && stats.isSymbolicLink() || stats.isFile()) {
      const name = (0, import_path11.basename)(file);
      const files = (0, import_fs2.readdirSync)((0, import_path11.dirname)(file));
      if (files.indexOf(name) !== -1)
        return file;
    }
  } catch (_a) {
  }
}
function throwPluginError(err2, plugin, { hook, id } = {}) {
  if (typeof err2 === "string")
    err2 = { message: err2 };
  if (err2.code && err2.code !== Errors.PLUGIN_ERROR) {
    err2.pluginCode = err2.code;
  }
  err2.code = Errors.PLUGIN_ERROR;
  err2.plugin = plugin;
  if (hook) {
    err2.hook = hook;
  }
  if (id) {
    err2.id = id;
  }
  return error(err2);
}
function warnDeprecatedHooks(plugins, options) {
  for (const { active, deprecated, replacement } of deprecatedHooks) {
    for (const plugin of plugins) {
      if (deprecated in plugin) {
        warnDeprecation({
          message: `The "${deprecated}" hook used by plugin ${plugin.name} is deprecated. The "${replacement}" hook should be used instead.`,
          plugin: plugin.name
        }, active, options);
      }
    }
  }
}
function createPluginCache(cache) {
  return {
    delete(id) {
      return delete cache[id];
    },
    get(id) {
      const item = cache[id];
      if (!item)
        return void 0;
      item[0] = 0;
      return item[1];
    },
    has(id) {
      const item = cache[id];
      if (!item)
        return false;
      item[0] = 0;
      return true;
    },
    set(id, value) {
      cache[id] = [0, value];
    }
  };
}
function getTrackedPluginCache(pluginCache, onUse) {
  return {
    delete(id) {
      onUse();
      return pluginCache.delete(id);
    },
    get(id) {
      onUse();
      return pluginCache.get(id);
    },
    has(id) {
      onUse();
      return pluginCache.has(id);
    },
    set(id, value) {
      onUse();
      return pluginCache.set(id, value);
    }
  };
}
function uncacheablePluginError(pluginName) {
  if (pluginName.startsWith(ANONYMOUS_PLUGIN_PREFIX) || pluginName.startsWith(ANONYMOUS_OUTPUT_PLUGIN_PREFIX)) {
    return error({
      code: "ANONYMOUS_PLUGIN_CACHE",
      message: "A plugin is trying to use the Rollup cache but is not declaring a plugin name or cacheKey."
    });
  }
  return error({
    code: "DUPLICATE_PLUGIN_NAME",
    message: `The plugin name ${pluginName} is being used twice in the same build. Plugin names must be distinct or provide a cacheKey (please post an issue to the plugin if you are a plugin user).`
  });
}
function getCacheForUncacheablePlugin(pluginName) {
  return {
    delete() {
      return uncacheablePluginError(pluginName);
    },
    get() {
      return uncacheablePluginError(pluginName);
    },
    has() {
      return uncacheablePluginError(pluginName);
    },
    set() {
      return uncacheablePluginError(pluginName);
    }
  };
}
function transform(source, module2, pluginDriver, warn) {
  const id = module2.id;
  const sourcemapChain = [];
  let originalSourcemap = source.map === null ? null : decodedSourcemap(source.map);
  const originalCode = source.code;
  let ast = source.ast;
  const transformDependencies = [];
  const emittedFiles = [];
  let customTransformCache = false;
  const useCustomTransformCache = () => customTransformCache = true;
  let curPlugin;
  const curSource = source.code;
  function transformReducer(previousCode, result2, plugin) {
    let code;
    let map2;
    if (typeof result2 === "string") {
      code = result2;
    } else if (result2 && typeof result2 === "object") {
      module2.updateOptions(result2);
      if (result2.code == null) {
        if (result2.map || result2.ast) {
          warn(errNoTransformMapOrAstWithoutCode(plugin.name));
        }
        return previousCode;
      }
      ({ code, map: map2, ast } = result2);
    } else {
      return previousCode;
    }
    if (map2 !== null) {
      sourcemapChain.push(decodedSourcemap(typeof map2 === "string" ? JSON.parse(map2) : map2) || {
        missing: true,
        plugin: plugin.name
      });
    }
    return code;
  }
  return pluginDriver.hookReduceArg0("transform", [curSource, id], transformReducer, (pluginContext, plugin) => {
    curPlugin = plugin;
    return {
      ...pluginContext,
      addWatchFile(id2) {
        transformDependencies.push(id2);
        pluginContext.addWatchFile(id2);
      },
      cache: customTransformCache ? pluginContext.cache : getTrackedPluginCache(pluginContext.cache, useCustomTransformCache),
      emitAsset(name, source2) {
        emittedFiles.push({ name, source: source2, type: "asset" });
        return pluginContext.emitAsset(name, source2);
      },
      emitChunk(id2, options) {
        emittedFiles.push({ id: id2, name: options && options.name, type: "chunk" });
        return pluginContext.emitChunk(id2, options);
      },
      emitFile(emittedFile) {
        emittedFiles.push(emittedFile);
        return pluginDriver.emitFile(emittedFile);
      },
      error(err2, pos) {
        if (typeof err2 === "string")
          err2 = { message: err2 };
        if (pos)
          augmentCodeLocation(err2, pos, curSource, id);
        err2.id = id;
        err2.hook = "transform";
        return pluginContext.error(err2);
      },
      getCombinedSourcemap() {
        const combinedMap = collapseSourcemap(id, originalCode, originalSourcemap, sourcemapChain, warn);
        if (!combinedMap) {
          const magicString = new MagicString$1(originalCode);
          return magicString.generateMap({ hires: true, includeContent: true, source: id });
        }
        if (originalSourcemap !== combinedMap) {
          originalSourcemap = combinedMap;
          sourcemapChain.length = 0;
        }
        return new SourceMap2({
          ...combinedMap,
          file: null,
          sourcesContent: combinedMap.sourcesContent
        });
      },
      setAssetSource() {
        return this.error({
          code: "INVALID_SETASSETSOURCE",
          message: `setAssetSource cannot be called in transform for caching reasons. Use emitFile with a source, or call setAssetSource in another hook.`
        });
      },
      warn(warning, pos) {
        if (typeof warning === "string")
          warning = { message: warning };
        if (pos)
          augmentCodeLocation(warning, pos, curSource, id);
        warning.id = id;
        warning.hook = "transform";
        pluginContext.warn(warning);
      }
    };
  }).catch((err2) => throwPluginError(err2, curPlugin.name, { hook: "transform", id })).then((code) => {
    if (!customTransformCache) {
      if (emittedFiles.length)
        module2.transformFiles = emittedFiles;
    }
    return {
      ast,
      code,
      customTransformCache,
      meta: module2.info.meta,
      originalCode,
      originalSourcemap,
      sourcemapChain,
      transformDependencies
    };
  });
}
function normalizeRelativeExternalId(source, importer) {
  return isRelative(source) ? importer ? (0, import_path11.resolve)(importer, "..", source) : (0, import_path11.resolve)(source) : source;
}
function addChunkNamesToModule(module2, { fileName, name }, isUserDefined) {
  if (fileName !== null) {
    module2.chunkFileNames.add(fileName);
  } else if (name !== null) {
    if (module2.chunkName === null) {
      module2.chunkName = name;
    }
    if (isUserDefined) {
      module2.userChunkNames.add(name);
    }
  }
}
function isNotAbsoluteExternal(id, source, makeAbsoluteExternalsRelative) {
  return makeAbsoluteExternalsRelative === true || makeAbsoluteExternalsRelative === "ifRelativeSource" && isRelative(source) || !isAbsolute3(id);
}
function getDeprecatedContextHandler(handler, handlerName, newHandlerName, pluginName, activeDeprecation, options) {
  let deprecationWarningShown = false;
  return (...args) => {
    if (!deprecationWarningShown) {
      deprecationWarningShown = true;
      warnDeprecation({
        message: `The "this.${handlerName}" plugin context function used by plugin ${pluginName} is deprecated. The "this.${newHandlerName}" plugin context function should be used instead.`,
        plugin: pluginName
      }, activeDeprecation, options);
    }
    return handler(...args);
  };
}
function getPluginContext(plugin, pluginCache, graph, options, fileEmitter, existingPluginNames) {
  let cacheable = true;
  if (typeof plugin.cacheKey !== "string") {
    if (plugin.name.startsWith(ANONYMOUS_PLUGIN_PREFIX) || plugin.name.startsWith(ANONYMOUS_OUTPUT_PLUGIN_PREFIX) || existingPluginNames.has(plugin.name)) {
      cacheable = false;
    } else {
      existingPluginNames.add(plugin.name);
    }
  }
  let cacheInstance;
  if (!pluginCache) {
    cacheInstance = NO_CACHE;
  } else if (cacheable) {
    const cacheKey = plugin.cacheKey || plugin.name;
    cacheInstance = createPluginCache(pluginCache[cacheKey] || (pluginCache[cacheKey] = /* @__PURE__ */ Object.create(null)));
  } else {
    cacheInstance = getCacheForUncacheablePlugin(plugin.name);
  }
  const context = {
    addWatchFile(id) {
      if (graph.phase >= BuildPhase.GENERATE) {
        return this.error(errInvalidRollupPhaseForAddWatchFile());
      }
      graph.watchFiles[id] = true;
    },
    cache: cacheInstance,
    emitAsset: getDeprecatedContextHandler((name, source) => fileEmitter.emitFile({ name, source, type: "asset" }), "emitAsset", "emitFile", plugin.name, true, options),
    emitChunk: getDeprecatedContextHandler((id, options2) => fileEmitter.emitFile({ id, name: options2 && options2.name, type: "chunk" }), "emitChunk", "emitFile", plugin.name, true, options),
    emitFile: fileEmitter.emitFile.bind(fileEmitter),
    error(err2) {
      return throwPluginError(err2, plugin.name);
    },
    getAssetFileName: getDeprecatedContextHandler(fileEmitter.getFileName, "getAssetFileName", "getFileName", plugin.name, true, options),
    getChunkFileName: getDeprecatedContextHandler(fileEmitter.getFileName, "getChunkFileName", "getFileName", plugin.name, true, options),
    getFileName: fileEmitter.getFileName,
    getModuleIds: () => graph.modulesById.keys(),
    getModuleInfo: graph.getModuleInfo,
    getWatchFiles: () => Object.keys(graph.watchFiles),
    isExternal: getDeprecatedContextHandler((id, parentId, isResolved = false) => options.external(id, parentId, isResolved), "isExternal", "resolve", plugin.name, true, options),
    meta: {
      rollupVersion: version$1,
      watchMode: graph.watchMode
    },
    get moduleIds() {
      function* wrappedModuleIds() {
        warnDeprecation({
          message: `Accessing "this.moduleIds" on the plugin context by plugin ${plugin.name} is deprecated. The "this.getModuleIds" plugin context function should be used instead.`,
          plugin: plugin.name
        }, false, options);
        yield* moduleIds;
      }
      const moduleIds = graph.modulesById.keys();
      return wrappedModuleIds();
    },
    parse: graph.contextParse.bind(graph),
    resolve(source, importer, { custom, skipSelf } = BLANK) {
      return graph.moduleLoader.resolveId(source, importer, custom, skipSelf ? [{ importer, plugin, source }] : null);
    },
    resolveId: getDeprecatedContextHandler((source, importer) => graph.moduleLoader.resolveId(source, importer, BLANK).then((resolveId3) => resolveId3 && resolveId3.id), "resolveId", "resolve", plugin.name, true, options),
    setAssetSource: fileEmitter.setAssetSource,
    warn(warning) {
      if (typeof warning === "string")
        warning = { message: warning };
      if (warning.code)
        warning.pluginCode = warning.code;
      warning.code = "PLUGIN_WARNING";
      warning.plugin = plugin.name;
      options.onwarn(warning);
    }
  };
  return context;
}
function throwInvalidHookError(hookName, pluginName) {
  return error({
    code: "INVALID_PLUGIN_HOOK",
    message: `Error running plugin hook ${hookName} for ${pluginName}, expected a function hook.`
  });
}
function normalizeEntryModules(entryModules) {
  if (Array.isArray(entryModules)) {
    return entryModules.map((id) => ({
      fileName: null,
      id,
      implicitlyLoadedAfter: [],
      importer: void 0,
      name: null
    }));
  }
  return Object.entries(entryModules).map(([name, id]) => ({
    fileName: null,
    id,
    implicitlyLoadedAfter: [],
    importer: void 0,
    name
  }));
}
function ensureArray3(items) {
  if (Array.isArray(items)) {
    return items.filter(Boolean);
  }
  if (items) {
    return [items];
  }
  return [];
}
function warnUnknownOptions(passedOptions, validOptions, optionType, warn, ignoredKeys = /$./) {
  const validOptionSet = new Set(validOptions);
  const unknownOptions = Object.keys(passedOptions).filter((key) => !(validOptionSet.has(key) || ignoredKeys.test(key)));
  if (unknownOptions.length > 0) {
    warn({
      code: "UNKNOWN_OPTION",
      message: `Unknown ${optionType}: ${unknownOptions.join(", ")}. Allowed options: ${[
        ...validOptionSet
      ].sort().join(", ")}`
    });
  }
}
function normalizeInputOptions(config) {
  var _a, _b, _c;
  const unsetOptions = /* @__PURE__ */ new Set();
  const context = (_a = config.context) !== null && _a !== void 0 ? _a : "undefined";
  const onwarn = getOnwarn(config);
  const strictDeprecations = config.strictDeprecations || false;
  const options = {
    acorn: getAcorn(config),
    acornInjectPlugins: getAcornInjectPlugins(config),
    cache: getCache(config),
    context,
    experimentalCacheExpiry: (_b = config.experimentalCacheExpiry) !== null && _b !== void 0 ? _b : 10,
    external: getIdMatcher(config.external),
    inlineDynamicImports: getInlineDynamicImports$1(config, onwarn, strictDeprecations),
    input: getInput(config),
    makeAbsoluteExternalsRelative: (_c = config.makeAbsoluteExternalsRelative) !== null && _c !== void 0 ? _c : true,
    manualChunks: getManualChunks$1(config, onwarn, strictDeprecations),
    maxParallelFileReads: getMaxParallelFileReads(config),
    moduleContext: getModuleContext(config, context),
    onwarn,
    perf: config.perf || false,
    plugins: ensureArray3(config.plugins),
    preserveEntrySignatures: getPreserveEntrySignatures(config, unsetOptions),
    preserveModules: getPreserveModules$1(config, onwarn, strictDeprecations),
    preserveSymlinks: config.preserveSymlinks || false,
    shimMissingExports: config.shimMissingExports || false,
    strictDeprecations,
    treeshake: getTreeshake(config, onwarn, strictDeprecations)
  };
  warnUnknownOptions(config, [...Object.keys(options), "watch"], "input options", options.onwarn, /^(output)$/);
  return { options, unsetOptions };
}
function sanitizeFileName(name) {
  const match2 = /^[a-z]:/i.exec(name);
  const driveLetter = match2 ? match2[0] : "";
  return driveLetter + name.substr(driveLetter.length).replace(/[\0?*:]/g, "_");
}
function normalizeOutputOptions(config, inputOptions, unsetInputOptions) {
  var _a, _b, _c, _d, _e, _f, _g;
  const unsetOptions = new Set(unsetInputOptions);
  const compact = config.compact || false;
  const format = getFormat(config);
  const inlineDynamicImports = getInlineDynamicImports(config, inputOptions);
  const preserveModules = getPreserveModules(config, inlineDynamicImports, inputOptions);
  const file = getFile(config, preserveModules, inputOptions);
  const outputOptions = {
    amd: getAmd(config),
    assetFileNames: (_a = config.assetFileNames) !== null && _a !== void 0 ? _a : "assets/[name]-[hash][extname]",
    banner: getAddon(config, "banner"),
    chunkFileNames: (_b = config.chunkFileNames) !== null && _b !== void 0 ? _b : "[name]-[hash].js",
    compact,
    dir: getDir(config, file),
    dynamicImportFunction: getDynamicImportFunction(config, inputOptions),
    entryFileNames: getEntryFileNames(config, unsetOptions),
    esModule: (_c = config.esModule) !== null && _c !== void 0 ? _c : true,
    exports: getExports(config, unsetOptions),
    extend: config.extend || false,
    externalLiveBindings: (_d = config.externalLiveBindings) !== null && _d !== void 0 ? _d : true,
    file,
    footer: getAddon(config, "footer"),
    format,
    freeze: (_e = config.freeze) !== null && _e !== void 0 ? _e : true,
    globals: config.globals || {},
    hoistTransitiveImports: (_f = config.hoistTransitiveImports) !== null && _f !== void 0 ? _f : true,
    indent: getIndent(config, compact),
    inlineDynamicImports,
    interop: getInterop(config, inputOptions),
    intro: getAddon(config, "intro"),
    manualChunks: getManualChunks(config, inlineDynamicImports, preserveModules, inputOptions),
    minifyInternalExports: getMinifyInternalExports(config, format, compact),
    name: config.name,
    namespaceToStringTag: config.namespaceToStringTag || false,
    noConflict: config.noConflict || false,
    outro: getAddon(config, "outro"),
    paths: config.paths || {},
    plugins: ensureArray3(config.plugins),
    preferConst: config.preferConst || false,
    preserveModules,
    preserveModulesRoot: getPreserveModulesRoot(config),
    sanitizeFileName: typeof config.sanitizeFileName === "function" ? config.sanitizeFileName : config.sanitizeFileName === false ? (id) => id : sanitizeFileName,
    sourcemap: config.sourcemap || false,
    sourcemapExcludeSources: config.sourcemapExcludeSources || false,
    sourcemapFile: config.sourcemapFile,
    sourcemapPathTransform: config.sourcemapPathTransform,
    strict: (_g = config.strict) !== null && _g !== void 0 ? _g : true,
    systemNullSetters: config.systemNullSetters || false,
    validate: config.validate || false
  };
  warnUnknownOptions(config, Object.keys(outputOptions), "output options", inputOptions.onwarn);
  return { options: outputOptions, unsetOptions };
}
function getExports(config, unsetOptions) {
  const configExports = config.exports;
  if (configExports == null) {
    unsetOptions.add("exports");
  } else if (!["default", "named", "none", "auto"].includes(configExports)) {
    return error(errInvalidExportOptionValue(configExports));
  }
  return configExports || "auto";
}
function rollup(rawInputOptions) {
  return rollupInternal(rawInputOptions, null);
}
async function rollupInternal(rawInputOptions, watcher) {
  const { options: inputOptions, unsetOptions: unsetInputOptions } = await getInputOptions(rawInputOptions, watcher !== null);
  initialiseTimers(inputOptions);
  const graph = new Graph(inputOptions, watcher);
  const useCache = rawInputOptions.cache !== false;
  delete inputOptions.cache;
  delete rawInputOptions.cache;
  timeStart("BUILD", 1);
  try {
    await graph.pluginDriver.hookParallel("buildStart", [inputOptions]);
    await graph.build();
  } catch (err2) {
    const watchFiles = Object.keys(graph.watchFiles);
    if (watchFiles.length > 0) {
      err2.watchFiles = watchFiles;
    }
    await graph.pluginDriver.hookParallel("buildEnd", [err2]);
    await graph.pluginDriver.hookParallel("closeBundle", []);
    throw err2;
  }
  await graph.pluginDriver.hookParallel("buildEnd", []);
  timeEnd("BUILD", 1);
  const result2 = {
    cache: useCache ? graph.getCache() : void 0,
    async close() {
      if (result2.closed)
        return;
      result2.closed = true;
      await graph.pluginDriver.hookParallel("closeBundle", []);
    },
    closed: false,
    async generate(rawOutputOptions) {
      if (result2.closed)
        return error(errAlreadyClosed());
      return handleGenerateWrite(false, inputOptions, unsetInputOptions, rawOutputOptions, graph);
    },
    watchFiles: Object.keys(graph.watchFiles),
    async write(rawOutputOptions) {
      if (result2.closed)
        return error(errAlreadyClosed());
      return handleGenerateWrite(true, inputOptions, unsetInputOptions, rawOutputOptions, graph);
    }
  };
  if (inputOptions.perf)
    result2.getTimings = getTimings;
  return result2;
}
async function getInputOptions(rawInputOptions, watchMode) {
  if (!rawInputOptions) {
    throw new Error("You must supply an options object to rollup");
  }
  const rawPlugins = ensureArray3(rawInputOptions.plugins);
  const { options, unsetOptions } = normalizeInputOptions(await rawPlugins.reduce(applyOptionHook(watchMode), Promise.resolve(rawInputOptions)));
  normalizePlugins(options.plugins, ANONYMOUS_PLUGIN_PREFIX);
  return { options, unsetOptions };
}
function applyOptionHook(watchMode) {
  return async (inputOptions, plugin) => {
    if (plugin.options) {
      return await plugin.options.call({ meta: { rollupVersion: version$1, watchMode } }, await inputOptions) || inputOptions;
    }
    return inputOptions;
  };
}
function normalizePlugins(plugins, anonymousPrefix) {
  for (let pluginIndex = 0; pluginIndex < plugins.length; pluginIndex++) {
    const plugin = plugins[pluginIndex];
    if (!plugin.name) {
      plugin.name = `${anonymousPrefix}${pluginIndex + 1}`;
    }
  }
}
async function handleGenerateWrite(isWrite, inputOptions, unsetInputOptions, rawOutputOptions, graph) {
  const { options: outputOptions, outputPluginDriver, unsetOptions } = getOutputOptionsAndPluginDriver(rawOutputOptions, graph.pluginDriver, inputOptions, unsetInputOptions);
  const bundle = new Bundle2(outputOptions, unsetOptions, inputOptions, outputPluginDriver, graph);
  const generated = await bundle.generate(isWrite);
  if (isWrite) {
    if (!outputOptions.dir && !outputOptions.file) {
      return error({
        code: "MISSING_OPTION",
        message: 'You must specify "output.file" or "output.dir" for the build.'
      });
    }
    await Promise.all(Object.values(generated).map((chunk) => writeOutputFile(chunk, outputOptions)));
    await outputPluginDriver.hookParallel("writeBundle", [outputOptions, generated]);
  }
  return createOutput(generated);
}
function getOutputOptionsAndPluginDriver(rawOutputOptions, inputPluginDriver, inputOptions, unsetInputOptions) {
  if (!rawOutputOptions) {
    throw new Error("You must supply an options object");
  }
  const rawPlugins = ensureArray3(rawOutputOptions.plugins);
  normalizePlugins(rawPlugins, ANONYMOUS_OUTPUT_PLUGIN_PREFIX);
  const outputPluginDriver = inputPluginDriver.createOutputPluginDriver(rawPlugins);
  return {
    ...getOutputOptions(inputOptions, unsetInputOptions, rawOutputOptions, outputPluginDriver),
    outputPluginDriver
  };
}
function getOutputOptions(inputOptions, unsetInputOptions, rawOutputOptions, outputPluginDriver) {
  return normalizeOutputOptions(outputPluginDriver.hookReduceArg0Sync("outputOptions", [rawOutputOptions.output || rawOutputOptions], (outputOptions, result2) => result2 || outputOptions, (pluginContext) => {
    const emitError = () => pluginContext.error(errCannotEmitFromOptionsHook());
    return {
      ...pluginContext,
      emitFile: emitError,
      setAssetSource: emitError
    };
  }), inputOptions, unsetInputOptions);
}
function createOutput(outputBundle) {
  return {
    output: Object.values(outputBundle).filter((outputFile) => Object.keys(outputFile).length > 0).sort((outputFileA, outputFileB) => {
      const fileTypeA = getSortingFileType(outputFileA);
      const fileTypeB = getSortingFileType(outputFileB);
      if (fileTypeA === fileTypeB)
        return 0;
      return fileTypeA < fileTypeB ? -1 : 1;
    })
  };
}
function getSortingFileType(file) {
  if (file.type === "asset") {
    return SortingFileType.ASSET;
  }
  if (file.isEntry) {
    return SortingFileType.ENTRY_CHUNK;
  }
  return SortingFileType.SECONDARY_CHUNK;
}
function writeOutputFile(outputFile, outputOptions) {
  const fileName = (0, import_path11.resolve)(outputOptions.dir || (0, import_path11.dirname)(outputOptions.file), outputFile.fileName);
  let writeSourceMapPromise;
  let source;
  if (outputFile.type === "asset") {
    source = outputFile.source;
  } else {
    source = outputFile.code;
    if (outputOptions.sourcemap && outputFile.map) {
      let url;
      if (outputOptions.sourcemap === "inline") {
        url = outputFile.map.toUrl();
      } else {
        url = `${(0, import_path11.basename)(outputFile.fileName)}.map`;
        writeSourceMapPromise = writeFile(`${fileName}.map`, outputFile.map.toString());
      }
      if (outputOptions.sourcemap !== "hidden") {
        source += `//# ${SOURCEMAPPING_URL}=${url}
`;
      }
    }
  }
  return Promise.all([writeFile(fileName, source), writeSourceMapPromise]);
}
var import_path11, import_crypto, import_fs2, version$1, charToInteger, chars$1, i, BitSet2, Chunk$1, btoa3, SourceMap2, toString$1, Mappings2, n2, warned2, MagicString2, hasOwnProp, Bundle$1, MagicString$1, RESERVED_NAMES, UnknownKey, UnknownInteger, EMPTY_PATH, UNKNOWN_PATH, UNKNOWN_INTEGER_PATH, EntitiesKey, PathTracker, SHARED_RECURSION_TRACKER, DiscriminatedPathTracker, UnknownValue, ExpressionEntity, UNKNOWN_EXPRESSION, Variable, ExternalVariable, BLANK, EMPTY_OBJECT, EMPTY_ARRAY, reservedWords$1, builtins$1, blacklisted, illegalCharacters, startsWithDigit, absolutePath, relativePath, ExternalModule, extractors2, extractAssignedNames3, BROKEN_FLOW_NONE, BROKEN_FLOW_BREAK_CONTINUE, BROKEN_FLOW_ERROR_RETURN_LABEL, base$1, ArrowFunctionExpression$1, BinaryExpression$1, BlockStatement$1, CallExpression$1, ChainExpression$1, ConditionalExpression$1, ExpressionStatement$1, Identifier$1, ImportDefaultSpecifier$1, ImportNamespaceSpecifier$1, LogicalExpression$1, NewExpression$1, Program$1, Property$1, ReturnStatement$1, SequenceExpression$1, SOURCEMAPPING_URL, whiteSpaceNoNewline, SOURCEMAPPING_URL_RE, ANNOTATION_KEY, INVALID_COMMENT_KEY, neitherWithespaceNorBrackets, noWhitespace, pureCommentRegex, keys, INCLUDE_PARAMETERS, NodeBase, ExportAllDeclaration, NO_SEMICOLON, NON_WHITESPACE, chars2, base, NO_ARGS, UNDEFINED_EXPRESSION, returnsUnknown, UNKNOWN_LITERAL_BOOLEAN, returnsBoolean, UNKNOWN_LITERAL_NUMBER, returnsNumber, UNKNOWN_LITERAL_STRING, returnsString, objectMembers, literalBooleanMembers, literalNumberMembers, literalStringMembers, LocalVariable, Scope$1, ChildScope, ValueProperties, PURE, IMPURE, O, PF, C, PC, ARRAY_TYPE, INTL_MEMBER, knownGlobals, GlobalVariable, tdzVariableKinds, Identifier, EVENT_ACCESSED, EVENT_ASSIGNED, EVENT_CALLED, MethodBase, MethodDefinition, INTEGER_REG_EXP, ObjectEntity, ObjectMember, Method, METHOD_RETURNS_BOOLEAN, METHOD_RETURNS_STRING, METHOD_RETURNS_NUMBER, METHOD_RETURNS_UNKNOWN, OBJECT_PROTOTYPE, ClassNode, ClassDeclaration, ArgumentsVariable, ThisVariable, SpreadElement, ParameterScope, ReturnValueScope, FunctionScope, RestElement, FunctionNode, FunctionDeclaration, ExportDefaultDeclaration, Literal, Program, TemplateLiteral, VariableDeclaration, NEW_ARRAY_PROPERTIES, METHOD_CALLS_ARG_DEOPTS_SELF_RETURNS_BOOLEAN, METHOD_CALLS_ARG_DEOPTS_SELF_RETURNS_NUMBER, METHOD_MUTATES_SELF_RETURNS_NEW_ARRAY, METHOD_DEOPTS_SELF_RETURNS_NEW_ARRAY, METHOD_CALLS_ARG_DEOPTS_SELF_RETURNS_NEW_ARRAY, METHOD_MUTATES_SELF_RETURNS_NUMBER, METHOD_MUTATES_SELF_RETURNS_UNKNOWN, METHOD_DEOPTS_SELF_RETURNS_UNKNOWN, METHOD_CALLS_ARG_DEOPTS_SELF_RETURNS_UNKNOWN, METHOD_MUTATES_SELF_RETURNS_SELF, METHOD_CALLS_ARG_MUTATES_SELF_RETURNS_SELF, ARRAY_PROTOTYPE, ArrayExpression, ArrayPattern, BlockScope, ExpressionStatement, BlockStatement, ArrowFunctionExpression, ObjectPattern, AssignmentExpression, AssignmentPattern, AwaitExpression, binaryOperators, BinaryExpression, BreakStatement, MAX_PATH_DEPTH, MemberExpression, CallExpression, CatchScope, CatchClause, ChainExpression, ClassBodyScope, ClassBody, ClassExpression, MultiExpression, ConditionalExpression, ContinueStatement, DoWhileStatement, EmptyStatement, ExportNamedDeclaration, ExportSpecifier, ForInStatement, ForOfStatement, ForStatement, FunctionExpression, TrackingScope, unset, IfStatement, ImportDeclaration, ImportDefaultSpecifier, INTEROP_DEFAULT_VARIABLE, INTEROP_DEFAULT_LEGACY_VARIABLE, INTEROP_NAMESPACE_VARIABLE, INTEROP_NAMESPACE_DEFAULT_VARIABLE, INTEROP_NAMESPACE_DEFAULT_ONLY_VARIABLE, defaultInteropHelpersByInteropType, namespaceInteropHelpersByInteropType, HELPER_GENERATORS, HELPER_NAMES, ImportExpression, accessedImportGlobals, ImportNamespaceSpecifier, ImportSpecifier, LabeledStatement, LogicalExpression, Errors, ASSET_PREFIX, CHUNK_PREFIX, FILE_PREFIX, MetaProperty, accessedMetaUrlGlobals, accessedFileUrlGlobals, getResolveUrl, getRelativeUrlFromDocument, getGenericImportMetaMechanism, getUrlFromDocument, relativeUrlMechanisms, importMetaMechanisms, NewExpression, ObjectExpression, PrivateIdentifier, Property, PropertyDefinition, ReturnStatement, SequenceExpression, Super, SwitchCase, SwitchStatement, TaggedTemplateExpression, TemplateElement, UndefinedVariable, ExportDefaultVariable, ModuleScope, ThisExpression, ThrowStatement, TryStatement, unaryOperators, UnaryExpression, UnknownNode, UpdateExpression, VariableDeclarator, WhileStatement, YieldExpression, nodeConstructors, MISSING_EXPORT_SHIM_VARIABLE, ExportShimVariable, NamespaceVariable, SyntheticNamedExportVariable, getPropertyAccess, NOOP, getStartTime, getElapsedTime, getMemory, timers, normalizeHrTime, timeStart, timeEnd, TIMED_PLUGIN_HOOKS, MISSING_EXPORT_SHIM_DESCRIPTION, Module, builtins4, shouldUseDot, thisProp, getStarExcludesBlock, getImportBindingsBlock, getHoistedExportsBlock, getMissingExportsBlock, getSyntheticExportsBlock, finalisers, Source, Link, createHash, DECONFLICT_IMPORTED_VARIABLES_BY_FORMAT, needsEscapeRegEx, quoteNewlineRegEx, backSlashRegEx, NON_ASSET_EXTENSIONS, Chunk3, BuildPhase, FILE_PLACEHOLDER, FileEmitter, concatSep, concatDblSep, compareExecIndex, Bundle2, reservedWords3, ecma5AndLessKeywords, keywords, keywordRelationalOperator, nonASCIIidentifierStartChars, nonASCIIidentifierChars, nonASCIIidentifierStart, nonASCIIidentifier, astralIdentifierStartCodes, astralIdentifierCodes, TokenType, beforeExpr, startsExpr, keywords$1, types2, lineBreak, lineBreakG, nonASCIIwhitespace, skipWhiteSpace, ref, hasOwnProperty, toString6, isArray3, Position, SourceLocation, defaultOptions, warnedAboutEcmaVersion, SCOPE_TOP, SCOPE_FUNCTION, SCOPE_VAR, SCOPE_ASYNC, SCOPE_GENERATOR, SCOPE_ARROW, SCOPE_SIMPLE_CATCH, SCOPE_SUPER, SCOPE_DIRECT_SUPER, BIND_NONE, BIND_VAR, BIND_LEXICAL, BIND_FUNCTION, BIND_SIMPLE_CATCH, BIND_OUTSIDE, Parser, prototypeAccessors, pp, literal, pp$1, loopLabel, switchLabel, empty, FUNC_STATEMENT, FUNC_HANGING_STATEMENT, FUNC_NULLABLE_ID, pp$2, pp$3, empty$1, pp$4, pp$5, Scope2, Node, pp$6, TokContext, types$1, pp$7, ecma9BinaryProperties, ecma10BinaryProperties, ecma11BinaryProperties, ecma12BinaryProperties, unicodeBinaryProperties, unicodeGeneralCategoryValues, ecma9ScriptValues, ecma10ScriptValues, ecma11ScriptValues, ecma12ScriptValues, unicodeScriptValues, data, pp$8, RegExpValidationState, Token, pp$9, INVALID_TEMPLATE_ESCAPE_ERROR, version2, readFile2, Queue, ANONYMOUS_PLUGIN_PREFIX, ANONYMOUS_OUTPUT_PLUGIN_PREFIX, deprecatedHooks, NO_CACHE, ModuleLoader, GlobalScope, inputHookNames, inputHooks, PluginDriver, Graph, defaultOnWarn, treeshakePresets, getOnwarn, getAcorn, getAcornInjectPlugins, getCache, getIdMatcher, getInlineDynamicImports$1, getInput, getManualChunks$1, getMaxParallelFileReads, getModuleContext, getPreserveEntrySignatures, getPreserveModules$1, getTreeshake, getHasModuleSideEffects, getFile, getFormat, getInlineDynamicImports, getPreserveModules, getPreserveModulesRoot, getAmd, getAddon, getDir, getDynamicImportFunction, getEntryFileNames, getIndent, ALLOWED_INTEROP_TYPES, getInterop, getManualChunks, getMinifyInternalExports, SortingFileType;
var init_rollup = __esm({
  "node_modules/rollup/dist/es/shared/rollup.js"() {
    import_path11 = require("path");
    import_crypto = require("crypto");
    import_fs2 = __toESM(require("fs"), 1);
    /*
      @license
    	Rollup.js v2.56.3
    	Mon, 23 Aug 2021 05:06:39 GMT - commit c41d17ceedfa6c1d7430da70c6c80d86a91e9434
    
    
    	https://github.com/rollup/rollup
    
    	Released under the MIT License.
    */
    version$1 = "2.56.3";
    charToInteger = {};
    chars$1 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
    for (i = 0; i < chars$1.length; i++) {
      charToInteger[chars$1.charCodeAt(i)] = i;
    }
    BitSet2 = function BitSet3(arg) {
      this.bits = arg instanceof BitSet3 ? arg.bits.slice() : [];
    };
    BitSet2.prototype.add = function add(n3) {
      this.bits[n3 >> 5] |= 1 << (n3 & 31);
    };
    BitSet2.prototype.has = function has(n3) {
      return !!(this.bits[n3 >> 5] & 1 << (n3 & 31));
    };
    Chunk$1 = function Chunk2(start, end, content) {
      this.start = start;
      this.end = end;
      this.original = content;
      this.intro = "";
      this.outro = "";
      this.content = content;
      this.storeName = false;
      this.edited = false;
      Object.defineProperties(this, {
        previous: { writable: true, value: null },
        next: { writable: true, value: null }
      });
    };
    Chunk$1.prototype.appendLeft = function appendLeft(content) {
      this.outro += content;
    };
    Chunk$1.prototype.appendRight = function appendRight(content) {
      this.intro = this.intro + content;
    };
    Chunk$1.prototype.clone = function clone() {
      var chunk = new Chunk$1(this.start, this.end, this.original);
      chunk.intro = this.intro;
      chunk.outro = this.outro;
      chunk.content = this.content;
      chunk.storeName = this.storeName;
      chunk.edited = this.edited;
      return chunk;
    };
    Chunk$1.prototype.contains = function contains(index2) {
      return this.start < index2 && index2 < this.end;
    };
    Chunk$1.prototype.eachNext = function eachNext(fn) {
      var chunk = this;
      while (chunk) {
        fn(chunk);
        chunk = chunk.next;
      }
    };
    Chunk$1.prototype.eachPrevious = function eachPrevious(fn) {
      var chunk = this;
      while (chunk) {
        fn(chunk);
        chunk = chunk.previous;
      }
    };
    Chunk$1.prototype.edit = function edit(content, storeName, contentOnly) {
      this.content = content;
      if (!contentOnly) {
        this.intro = "";
        this.outro = "";
      }
      this.storeName = storeName;
      this.edited = true;
      return this;
    };
    Chunk$1.prototype.prependLeft = function prependLeft(content) {
      this.outro = content + this.outro;
    };
    Chunk$1.prototype.prependRight = function prependRight(content) {
      this.intro = content + this.intro;
    };
    Chunk$1.prototype.split = function split(index2) {
      var sliceIndex = index2 - this.start;
      var originalBefore = this.original.slice(0, sliceIndex);
      var originalAfter = this.original.slice(sliceIndex);
      this.original = originalBefore;
      var newChunk = new Chunk$1(index2, this.end, originalAfter);
      newChunk.outro = this.outro;
      this.outro = "";
      this.end = index2;
      if (this.edited) {
        newChunk.edit("", false);
        this.content = "";
      } else {
        this.content = originalBefore;
      }
      newChunk.next = this.next;
      if (newChunk.next) {
        newChunk.next.previous = newChunk;
      }
      newChunk.previous = this;
      this.next = newChunk;
      return newChunk;
    };
    Chunk$1.prototype.toString = function toString2() {
      return this.intro + this.content + this.outro;
    };
    Chunk$1.prototype.trimEnd = function trimEnd(rx) {
      this.outro = this.outro.replace(rx, "");
      if (this.outro.length) {
        return true;
      }
      var trimmed = this.content.replace(rx, "");
      if (trimmed.length) {
        if (trimmed !== this.content) {
          this.split(this.start + trimmed.length).edit("", void 0, true);
        }
        return true;
      } else {
        this.edit("", void 0, true);
        this.intro = this.intro.replace(rx, "");
        if (this.intro.length) {
          return true;
        }
      }
    };
    Chunk$1.prototype.trimStart = function trimStart(rx) {
      this.intro = this.intro.replace(rx, "");
      if (this.intro.length) {
        return true;
      }
      var trimmed = this.content.replace(rx, "");
      if (trimmed.length) {
        if (trimmed !== this.content) {
          this.split(this.end - trimmed.length);
          this.edit("", void 0, true);
        }
        return true;
      } else {
        this.edit("", void 0, true);
        this.outro = this.outro.replace(rx, "");
        if (this.outro.length) {
          return true;
        }
      }
    };
    btoa3 = function() {
      throw new Error("Unsupported environment: `window.btoa` or `Buffer` should be supported.");
    };
    if (typeof window !== "undefined" && typeof window.btoa === "function") {
      btoa3 = function(str) {
        return window.btoa(unescape(encodeURIComponent(str)));
      };
    } else if (typeof Buffer === "function") {
      btoa3 = function(str) {
        return Buffer.from(str, "utf-8").toString("base64");
      };
    }
    SourceMap2 = function SourceMap3(properties) {
      this.version = 3;
      this.file = properties.file;
      this.sources = properties.sources;
      this.sourcesContent = properties.sourcesContent;
      this.names = properties.names;
      this.mappings = encode2(properties.mappings);
    };
    SourceMap2.prototype.toString = function toString3() {
      return JSON.stringify(this);
    };
    SourceMap2.prototype.toUrl = function toUrl() {
      return "data:application/json;charset=utf-8;base64," + btoa3(this.toString());
    };
    toString$1 = Object.prototype.toString;
    Mappings2 = function Mappings3(hires) {
      this.hires = hires;
      this.generatedCodeLine = 0;
      this.generatedCodeColumn = 0;
      this.raw = [];
      this.rawSegments = this.raw[this.generatedCodeLine] = [];
      this.pending = null;
    };
    Mappings2.prototype.addEdit = function addEdit(sourceIndex2, content, loc, nameIndex) {
      if (content.length) {
        var segment = [this.generatedCodeColumn, sourceIndex2, loc.line, loc.column];
        if (nameIndex >= 0) {
          segment.push(nameIndex);
        }
        this.rawSegments.push(segment);
      } else if (this.pending) {
        this.rawSegments.push(this.pending);
      }
      this.advance(content);
      this.pending = null;
    };
    Mappings2.prototype.addUneditedChunk = function addUneditedChunk(sourceIndex2, chunk, original, loc, sourcemapLocations) {
      var originalCharIndex = chunk.start;
      var first = true;
      while (originalCharIndex < chunk.end) {
        if (this.hires || first || sourcemapLocations.has(originalCharIndex)) {
          this.rawSegments.push([this.generatedCodeColumn, sourceIndex2, loc.line, loc.column]);
        }
        if (original[originalCharIndex] === "\n") {
          loc.line += 1;
          loc.column = 0;
          this.generatedCodeLine += 1;
          this.raw[this.generatedCodeLine] = this.rawSegments = [];
          this.generatedCodeColumn = 0;
          first = true;
        } else {
          loc.column += 1;
          this.generatedCodeColumn += 1;
          first = false;
        }
        originalCharIndex += 1;
      }
      this.pending = null;
    };
    Mappings2.prototype.advance = function advance(str) {
      if (!str) {
        return;
      }
      var lines = str.split("\n");
      if (lines.length > 1) {
        for (var i = 0; i < lines.length - 1; i++) {
          this.generatedCodeLine++;
          this.raw[this.generatedCodeLine] = this.rawSegments = [];
        }
        this.generatedCodeColumn = 0;
      }
      this.generatedCodeColumn += lines[lines.length - 1].length;
    };
    n2 = "\n";
    warned2 = {
      insertLeft: false,
      insertRight: false,
      storeName: false
    };
    MagicString2 = function MagicString3(string, options) {
      if (options === void 0) options = {};
      var chunk = new Chunk$1(0, string.length, string);
      Object.defineProperties(this, {
        original: { writable: true, value: string },
        outro: { writable: true, value: "" },
        intro: { writable: true, value: "" },
        firstChunk: { writable: true, value: chunk },
        lastChunk: { writable: true, value: chunk },
        lastSearchedChunk: { writable: true, value: chunk },
        byStart: { writable: true, value: {} },
        byEnd: { writable: true, value: {} },
        filename: { writable: true, value: options.filename },
        indentExclusionRanges: { writable: true, value: options.indentExclusionRanges },
        sourcemapLocations: { writable: true, value: new BitSet2() },
        storedNames: { writable: true, value: {} },
        indentStr: { writable: true, value: guessIndent2(string) }
      });
      this.byStart[0] = chunk;
      this.byEnd[string.length] = chunk;
    };
    MagicString2.prototype.addSourcemapLocation = function addSourcemapLocation(char) {
      this.sourcemapLocations.add(char);
    };
    MagicString2.prototype.append = function append(content) {
      if (typeof content !== "string") {
        throw new TypeError("outro content must be a string");
      }
      this.outro += content;
      return this;
    };
    MagicString2.prototype.appendLeft = function appendLeft2(index2, content) {
      if (typeof content !== "string") {
        throw new TypeError("inserted content must be a string");
      }
      this._split(index2);
      var chunk = this.byEnd[index2];
      if (chunk) {
        chunk.appendLeft(content);
      } else {
        this.intro += content;
      }
      return this;
    };
    MagicString2.prototype.appendRight = function appendRight2(index2, content) {
      if (typeof content !== "string") {
        throw new TypeError("inserted content must be a string");
      }
      this._split(index2);
      var chunk = this.byStart[index2];
      if (chunk) {
        chunk.appendRight(content);
      } else {
        this.outro += content;
      }
      return this;
    };
    MagicString2.prototype.clone = function clone2() {
      var cloned = new MagicString2(this.original, { filename: this.filename });
      var originalChunk = this.firstChunk;
      var clonedChunk = cloned.firstChunk = cloned.lastSearchedChunk = originalChunk.clone();
      while (originalChunk) {
        cloned.byStart[clonedChunk.start] = clonedChunk;
        cloned.byEnd[clonedChunk.end] = clonedChunk;
        var nextOriginalChunk = originalChunk.next;
        var nextClonedChunk = nextOriginalChunk && nextOriginalChunk.clone();
        if (nextClonedChunk) {
          clonedChunk.next = nextClonedChunk;
          nextClonedChunk.previous = clonedChunk;
          clonedChunk = nextClonedChunk;
        }
        originalChunk = nextOriginalChunk;
      }
      cloned.lastChunk = clonedChunk;
      if (this.indentExclusionRanges) {
        cloned.indentExclusionRanges = this.indentExclusionRanges.slice();
      }
      cloned.sourcemapLocations = new BitSet2(this.sourcemapLocations);
      cloned.intro = this.intro;
      cloned.outro = this.outro;
      return cloned;
    };
    MagicString2.prototype.generateDecodedMap = function generateDecodedMap(options) {
      var this$1$1 = this;
      options = options || {};
      var sourceIndex2 = 0;
      var names = Object.keys(this.storedNames);
      var mappings = new Mappings2(options.hires);
      var locate2 = getLocator$1(this.original);
      if (this.intro) {
        mappings.advance(this.intro);
      }
      this.firstChunk.eachNext(function(chunk) {
        var loc = locate2(chunk.start);
        if (chunk.intro.length) {
          mappings.advance(chunk.intro);
        }
        if (chunk.edited) {
          mappings.addEdit(
            sourceIndex2,
            chunk.content,
            loc,
            chunk.storeName ? names.indexOf(chunk.original) : -1
          );
        } else {
          mappings.addUneditedChunk(sourceIndex2, chunk, this$1$1.original, loc, this$1$1.sourcemapLocations);
        }
        if (chunk.outro.length) {
          mappings.advance(chunk.outro);
        }
      });
      return {
        file: options.file ? options.file.split(/[/\\]/).pop() : null,
        sources: [options.source ? getRelativePath2(options.file || "", options.source) : null],
        sourcesContent: options.includeContent ? [this.original] : [null],
        names,
        mappings: mappings.raw
      };
    };
    MagicString2.prototype.generateMap = function generateMap(options) {
      return new SourceMap2(this.generateDecodedMap(options));
    };
    MagicString2.prototype.getIndentString = function getIndentString() {
      return this.indentStr === null ? "	" : this.indentStr;
    };
    MagicString2.prototype.indent = function indent(indentStr, options) {
      var pattern = /^[^\r\n]/gm;
      if (isObject3(indentStr)) {
        options = indentStr;
        indentStr = void 0;
      }
      indentStr = indentStr !== void 0 ? indentStr : this.indentStr || "	";
      if (indentStr === "") {
        return this;
      }
      options = options || {};
      var isExcluded = {};
      if (options.exclude) {
        var exclusions = typeof options.exclude[0] === "number" ? [options.exclude] : options.exclude;
        exclusions.forEach(function(exclusion) {
          for (var i = exclusion[0]; i < exclusion[1]; i += 1) {
            isExcluded[i] = true;
          }
        });
      }
      var shouldIndentNextCharacter = options.indentStart !== false;
      var replacer = function(match2) {
        if (shouldIndentNextCharacter) {
          return "" + indentStr + match2;
        }
        shouldIndentNextCharacter = true;
        return match2;
      };
      this.intro = this.intro.replace(pattern, replacer);
      var charIndex = 0;
      var chunk = this.firstChunk;
      while (chunk) {
        var end = chunk.end;
        if (chunk.edited) {
          if (!isExcluded[charIndex]) {
            chunk.content = chunk.content.replace(pattern, replacer);
            if (chunk.content.length) {
              shouldIndentNextCharacter = chunk.content[chunk.content.length - 1] === "\n";
            }
          }
        } else {
          charIndex = chunk.start;
          while (charIndex < end) {
            if (!isExcluded[charIndex]) {
              var char = this.original[charIndex];
              if (char === "\n") {
                shouldIndentNextCharacter = true;
              } else if (char !== "\r" && shouldIndentNextCharacter) {
                shouldIndentNextCharacter = false;
                if (charIndex === chunk.start) {
                  chunk.prependRight(indentStr);
                } else {
                  this._splitChunk(chunk, charIndex);
                  chunk = chunk.next;
                  chunk.prependRight(indentStr);
                }
              }
            }
            charIndex += 1;
          }
        }
        charIndex = chunk.end;
        chunk = chunk.next;
      }
      this.outro = this.outro.replace(pattern, replacer);
      return this;
    };
    MagicString2.prototype.insert = function insert() {
      throw new Error("magicString.insert(...) is deprecated. Use prependRight(...) or appendLeft(...)");
    };
    MagicString2.prototype.insertLeft = function insertLeft(index2, content) {
      if (!warned2.insertLeft) {
        console.warn("magicString.insertLeft(...) is deprecated. Use magicString.appendLeft(...) instead");
        warned2.insertLeft = true;
      }
      return this.appendLeft(index2, content);
    };
    MagicString2.prototype.insertRight = function insertRight(index2, content) {
      if (!warned2.insertRight) {
        console.warn("magicString.insertRight(...) is deprecated. Use magicString.prependRight(...) instead");
        warned2.insertRight = true;
      }
      return this.prependRight(index2, content);
    };
    MagicString2.prototype.move = function move(start, end, index2) {
      if (index2 >= start && index2 <= end) {
        throw new Error("Cannot move a selection inside itself");
      }
      this._split(start);
      this._split(end);
      this._split(index2);
      var first = this.byStart[start];
      var last = this.byEnd[end];
      var oldLeft = first.previous;
      var oldRight = last.next;
      var newRight = this.byStart[index2];
      if (!newRight && last === this.lastChunk) {
        return this;
      }
      var newLeft = newRight ? newRight.previous : this.lastChunk;
      if (oldLeft) {
        oldLeft.next = oldRight;
      }
      if (oldRight) {
        oldRight.previous = oldLeft;
      }
      if (newLeft) {
        newLeft.next = first;
      }
      if (newRight) {
        newRight.previous = last;
      }
      if (!first.previous) {
        this.firstChunk = last.next;
      }
      if (!last.next) {
        this.lastChunk = first.previous;
        this.lastChunk.next = null;
      }
      first.previous = newLeft;
      last.next = newRight || null;
      if (!newLeft) {
        this.firstChunk = first;
      }
      if (!newRight) {
        this.lastChunk = last;
      }
      return this;
    };
    MagicString2.prototype.overwrite = function overwrite(start, end, content, options) {
      if (typeof content !== "string") {
        throw new TypeError("replacement content must be a string");
      }
      while (start < 0) {
        start += this.original.length;
      }
      while (end < 0) {
        end += this.original.length;
      }
      if (end > this.original.length) {
        throw new Error("end is out of bounds");
      }
      if (start === end) {
        throw new Error("Cannot overwrite a zero-length range \u2013 use appendLeft or prependRight instead");
      }
      this._split(start);
      this._split(end);
      if (options === true) {
        if (!warned2.storeName) {
          console.warn("The final argument to magicString.overwrite(...) should be an options object. See https://github.com/rich-harris/magic-string");
          warned2.storeName = true;
        }
        options = { storeName: true };
      }
      var storeName = options !== void 0 ? options.storeName : false;
      var contentOnly = options !== void 0 ? options.contentOnly : false;
      if (storeName) {
        var original = this.original.slice(start, end);
        this.storedNames[original] = true;
      }
      var first = this.byStart[start];
      var last = this.byEnd[end];
      if (first) {
        if (end > first.end && first.next !== this.byStart[first.end]) {
          throw new Error("Cannot overwrite across a split point");
        }
        first.edit(content, storeName, contentOnly);
        if (first !== last) {
          var chunk = first.next;
          while (chunk !== last) {
            chunk.edit("", false);
            chunk = chunk.next;
          }
          chunk.edit("", false);
        }
      } else {
        var newChunk = new Chunk$1(start, end, "").edit(content, storeName);
        last.next = newChunk;
        newChunk.previous = last;
      }
      return this;
    };
    MagicString2.prototype.prepend = function prepend(content) {
      if (typeof content !== "string") {
        throw new TypeError("outro content must be a string");
      }
      this.intro = content + this.intro;
      return this;
    };
    MagicString2.prototype.prependLeft = function prependLeft2(index2, content) {
      if (typeof content !== "string") {
        throw new TypeError("inserted content must be a string");
      }
      this._split(index2);
      var chunk = this.byEnd[index2];
      if (chunk) {
        chunk.prependLeft(content);
      } else {
        this.intro = content + this.intro;
      }
      return this;
    };
    MagicString2.prototype.prependRight = function prependRight2(index2, content) {
      if (typeof content !== "string") {
        throw new TypeError("inserted content must be a string");
      }
      this._split(index2);
      var chunk = this.byStart[index2];
      if (chunk) {
        chunk.prependRight(content);
      } else {
        this.outro = content + this.outro;
      }
      return this;
    };
    MagicString2.prototype.remove = function remove(start, end) {
      while (start < 0) {
        start += this.original.length;
      }
      while (end < 0) {
        end += this.original.length;
      }
      if (start === end) {
        return this;
      }
      if (start < 0 || end > this.original.length) {
        throw new Error("Character is out of bounds");
      }
      if (start > end) {
        throw new Error("end must be greater than start");
      }
      this._split(start);
      this._split(end);
      var chunk = this.byStart[start];
      while (chunk) {
        chunk.intro = "";
        chunk.outro = "";
        chunk.edit("");
        chunk = end > chunk.end ? this.byStart[chunk.end] : null;
      }
      return this;
    };
    MagicString2.prototype.lastChar = function lastChar() {
      if (this.outro.length) {
        return this.outro[this.outro.length - 1];
      }
      var chunk = this.lastChunk;
      do {
        if (chunk.outro.length) {
          return chunk.outro[chunk.outro.length - 1];
        }
        if (chunk.content.length) {
          return chunk.content[chunk.content.length - 1];
        }
        if (chunk.intro.length) {
          return chunk.intro[chunk.intro.length - 1];
        }
      } while (chunk = chunk.previous);
      if (this.intro.length) {
        return this.intro[this.intro.length - 1];
      }
      return "";
    };
    MagicString2.prototype.lastLine = function lastLine() {
      var lineIndex = this.outro.lastIndexOf(n2);
      if (lineIndex !== -1) {
        return this.outro.substr(lineIndex + 1);
      }
      var lineStr = this.outro;
      var chunk = this.lastChunk;
      do {
        if (chunk.outro.length > 0) {
          lineIndex = chunk.outro.lastIndexOf(n2);
          if (lineIndex !== -1) {
            return chunk.outro.substr(lineIndex + 1) + lineStr;
          }
          lineStr = chunk.outro + lineStr;
        }
        if (chunk.content.length > 0) {
          lineIndex = chunk.content.lastIndexOf(n2);
          if (lineIndex !== -1) {
            return chunk.content.substr(lineIndex + 1) + lineStr;
          }
          lineStr = chunk.content + lineStr;
        }
        if (chunk.intro.length > 0) {
          lineIndex = chunk.intro.lastIndexOf(n2);
          if (lineIndex !== -1) {
            return chunk.intro.substr(lineIndex + 1) + lineStr;
          }
          lineStr = chunk.intro + lineStr;
        }
      } while (chunk = chunk.previous);
      lineIndex = this.intro.lastIndexOf(n2);
      if (lineIndex !== -1) {
        return this.intro.substr(lineIndex + 1) + lineStr;
      }
      return this.intro + lineStr;
    };
    MagicString2.prototype.slice = function slice(start, end) {
      if (start === void 0) start = 0;
      if (end === void 0) end = this.original.length;
      while (start < 0) {
        start += this.original.length;
      }
      while (end < 0) {
        end += this.original.length;
      }
      var result2 = "";
      var chunk = this.firstChunk;
      while (chunk && (chunk.start > start || chunk.end <= start)) {
        if (chunk.start < end && chunk.end >= end) {
          return result2;
        }
        chunk = chunk.next;
      }
      if (chunk && chunk.edited && chunk.start !== start) {
        throw new Error("Cannot use replaced character " + start + " as slice start anchor.");
      }
      var startChunk = chunk;
      while (chunk) {
        if (chunk.intro && (startChunk !== chunk || chunk.start === start)) {
          result2 += chunk.intro;
        }
        var containsEnd = chunk.start < end && chunk.end >= end;
        if (containsEnd && chunk.edited && chunk.end !== end) {
          throw new Error("Cannot use replaced character " + end + " as slice end anchor.");
        }
        var sliceStart = startChunk === chunk ? start - chunk.start : 0;
        var sliceEnd = containsEnd ? chunk.content.length + end - chunk.end : chunk.content.length;
        result2 += chunk.content.slice(sliceStart, sliceEnd);
        if (chunk.outro && (!containsEnd || chunk.end === end)) {
          result2 += chunk.outro;
        }
        if (containsEnd) {
          break;
        }
        chunk = chunk.next;
      }
      return result2;
    };
    MagicString2.prototype.snip = function snip(start, end) {
      var clone5 = this.clone();
      clone5.remove(0, start);
      clone5.remove(end, clone5.original.length);
      return clone5;
    };
    MagicString2.prototype._split = function _split(index2) {
      if (this.byStart[index2] || this.byEnd[index2]) {
        return;
      }
      var chunk = this.lastSearchedChunk;
      var searchForward = index2 > chunk.end;
      while (chunk) {
        if (chunk.contains(index2)) {
          return this._splitChunk(chunk, index2);
        }
        chunk = searchForward ? this.byStart[chunk.end] : this.byEnd[chunk.start];
      }
    };
    MagicString2.prototype._splitChunk = function _splitChunk(chunk, index2) {
      if (chunk.edited && chunk.content.length) {
        var loc = getLocator$1(this.original)(index2);
        throw new Error(
          "Cannot split a chunk that has already been edited (" + loc.line + ":" + loc.column + ' \u2013 "' + chunk.original + '")'
        );
      }
      var newChunk = chunk.split(index2);
      this.byEnd[index2] = chunk;
      this.byStart[index2] = newChunk;
      this.byEnd[newChunk.end] = newChunk;
      if (chunk === this.lastChunk) {
        this.lastChunk = newChunk;
      }
      this.lastSearchedChunk = chunk;
      return true;
    };
    MagicString2.prototype.toString = function toString4() {
      var str = this.intro;
      var chunk = this.firstChunk;
      while (chunk) {
        str += chunk.toString();
        chunk = chunk.next;
      }
      return str + this.outro;
    };
    MagicString2.prototype.isEmpty = function isEmpty() {
      var chunk = this.firstChunk;
      do {
        if (chunk.intro.length && chunk.intro.trim() || chunk.content.length && chunk.content.trim() || chunk.outro.length && chunk.outro.trim()) {
          return false;
        }
      } while (chunk = chunk.next);
      return true;
    };
    MagicString2.prototype.length = function length() {
      var chunk = this.firstChunk;
      var length3 = 0;
      do {
        length3 += chunk.intro.length + chunk.content.length + chunk.outro.length;
      } while (chunk = chunk.next);
      return length3;
    };
    MagicString2.prototype.trimLines = function trimLines() {
      return this.trim("[\\r\\n]");
    };
    MagicString2.prototype.trim = function trim(charType) {
      return this.trimStart(charType).trimEnd(charType);
    };
    MagicString2.prototype.trimEndAborted = function trimEndAborted(charType) {
      var rx = new RegExp((charType || "\\s") + "+$");
      this.outro = this.outro.replace(rx, "");
      if (this.outro.length) {
        return true;
      }
      var chunk = this.lastChunk;
      do {
        var end = chunk.end;
        var aborted = chunk.trimEnd(rx);
        if (chunk.end !== end) {
          if (this.lastChunk === chunk) {
            this.lastChunk = chunk.next;
          }
          this.byEnd[chunk.end] = chunk;
          this.byStart[chunk.next.start] = chunk.next;
          this.byEnd[chunk.next.end] = chunk.next;
        }
        if (aborted) {
          return true;
        }
        chunk = chunk.previous;
      } while (chunk);
      return false;
    };
    MagicString2.prototype.trimEnd = function trimEnd2(charType) {
      this.trimEndAborted(charType);
      return this;
    };
    MagicString2.prototype.trimStartAborted = function trimStartAborted(charType) {
      var rx = new RegExp("^" + (charType || "\\s") + "+");
      this.intro = this.intro.replace(rx, "");
      if (this.intro.length) {
        return true;
      }
      var chunk = this.firstChunk;
      do {
        var end = chunk.end;
        var aborted = chunk.trimStart(rx);
        if (chunk.end !== end) {
          if (chunk === this.lastChunk) {
            this.lastChunk = chunk.next;
          }
          this.byEnd[chunk.end] = chunk;
          this.byStart[chunk.next.start] = chunk.next;
          this.byEnd[chunk.next.end] = chunk.next;
        }
        if (aborted) {
          return true;
        }
        chunk = chunk.next;
      } while (chunk);
      return false;
    };
    MagicString2.prototype.trimStart = function trimStart2(charType) {
      this.trimStartAborted(charType);
      return this;
    };
    hasOwnProp = Object.prototype.hasOwnProperty;
    Bundle$1 = function Bundle(options) {
      if (options === void 0) options = {};
      this.intro = options.intro || "";
      this.separator = options.separator !== void 0 ? options.separator : "\n";
      this.sources = [];
      this.uniqueSources = [];
      this.uniqueSourceIndexByFilename = {};
    };
    Bundle$1.prototype.addSource = function addSource(source) {
      if (source instanceof MagicString2) {
        return this.addSource({
          content: source,
          filename: source.filename,
          separator: this.separator
        });
      }
      if (!isObject3(source) || !source.content) {
        throw new Error("bundle.addSource() takes an object with a `content` property, which should be an instance of MagicString, and an optional `filename`");
      }
      ["filename", "indentExclusionRanges", "separator"].forEach(function(option) {
        if (!hasOwnProp.call(source, option)) {
          source[option] = source.content[option];
        }
      });
      if (source.separator === void 0) {
        source.separator = this.separator;
      }
      if (source.filename) {
        if (!hasOwnProp.call(this.uniqueSourceIndexByFilename, source.filename)) {
          this.uniqueSourceIndexByFilename[source.filename] = this.uniqueSources.length;
          this.uniqueSources.push({ filename: source.filename, content: source.content.original });
        } else {
          var uniqueSource = this.uniqueSources[this.uniqueSourceIndexByFilename[source.filename]];
          if (source.content.original !== uniqueSource.content) {
            throw new Error("Illegal source: same filename (" + source.filename + "), different contents");
          }
        }
      }
      this.sources.push(source);
      return this;
    };
    Bundle$1.prototype.append = function append2(str, options) {
      this.addSource({
        content: new MagicString2(str),
        separator: options && options.separator || ""
      });
      return this;
    };
    Bundle$1.prototype.clone = function clone3() {
      var bundle = new Bundle$1({
        intro: this.intro,
        separator: this.separator
      });
      this.sources.forEach(function(source) {
        bundle.addSource({
          filename: source.filename,
          content: source.content.clone(),
          separator: source.separator
        });
      });
      return bundle;
    };
    Bundle$1.prototype.generateDecodedMap = function generateDecodedMap2(options) {
      var this$1$1 = this;
      if (options === void 0) options = {};
      var names = [];
      this.sources.forEach(function(source) {
        Object.keys(source.content.storedNames).forEach(function(name) {
          if (!~names.indexOf(name)) {
            names.push(name);
          }
        });
      });
      var mappings = new Mappings2(options.hires);
      if (this.intro) {
        mappings.advance(this.intro);
      }
      this.sources.forEach(function(source, i) {
        if (i > 0) {
          mappings.advance(this$1$1.separator);
        }
        var sourceIndex2 = source.filename ? this$1$1.uniqueSourceIndexByFilename[source.filename] : -1;
        var magicString = source.content;
        var locate2 = getLocator$1(magicString.original);
        if (magicString.intro) {
          mappings.advance(magicString.intro);
        }
        magicString.firstChunk.eachNext(function(chunk) {
          var loc = locate2(chunk.start);
          if (chunk.intro.length) {
            mappings.advance(chunk.intro);
          }
          if (source.filename) {
            if (chunk.edited) {
              mappings.addEdit(
                sourceIndex2,
                chunk.content,
                loc,
                chunk.storeName ? names.indexOf(chunk.original) : -1
              );
            } else {
              mappings.addUneditedChunk(
                sourceIndex2,
                chunk,
                magicString.original,
                loc,
                magicString.sourcemapLocations
              );
            }
          } else {
            mappings.advance(chunk.content);
          }
          if (chunk.outro.length) {
            mappings.advance(chunk.outro);
          }
        });
        if (magicString.outro) {
          mappings.advance(magicString.outro);
        }
      });
      return {
        file: options.file ? options.file.split(/[/\\]/).pop() : null,
        sources: this.uniqueSources.map(function(source) {
          return options.file ? getRelativePath2(options.file, source.filename) : source.filename;
        }),
        sourcesContent: this.uniqueSources.map(function(source) {
          return options.includeContent ? source.content : null;
        }),
        names,
        mappings: mappings.raw
      };
    };
    Bundle$1.prototype.generateMap = function generateMap2(options) {
      return new SourceMap2(this.generateDecodedMap(options));
    };
    Bundle$1.prototype.getIndentString = function getIndentString2() {
      var indentStringCounts = {};
      this.sources.forEach(function(source) {
        var indentStr = source.content.indentStr;
        if (indentStr === null) {
          return;
        }
        if (!indentStringCounts[indentStr]) {
          indentStringCounts[indentStr] = 0;
        }
        indentStringCounts[indentStr] += 1;
      });
      return Object.keys(indentStringCounts).sort(function(a, b) {
        return indentStringCounts[a] - indentStringCounts[b];
      })[0] || "	";
    };
    Bundle$1.prototype.indent = function indent2(indentStr) {
      var this$1$1 = this;
      if (!arguments.length) {
        indentStr = this.getIndentString();
      }
      if (indentStr === "") {
        return this;
      }
      var trailingNewline = !this.intro || this.intro.slice(-1) === "\n";
      this.sources.forEach(function(source, i) {
        var separator = source.separator !== void 0 ? source.separator : this$1$1.separator;
        var indentStart = trailingNewline || i > 0 && /\r?\n$/.test(separator);
        source.content.indent(indentStr, {
          exclude: source.indentExclusionRanges,
          indentStart
          //: trailingNewline || /\r?\n$/.test( separator )  //true///\r?\n/.test( separator )
        });
        trailingNewline = source.content.lastChar() === "\n";
      });
      if (this.intro) {
        this.intro = indentStr + this.intro.replace(/^[^\n]/gm, function(match2, index2) {
          return index2 > 0 ? indentStr + match2 : match2;
        });
      }
      return this;
    };
    Bundle$1.prototype.prepend = function prepend2(str) {
      this.intro = str + this.intro;
      return this;
    };
    Bundle$1.prototype.toString = function toString5() {
      var this$1$1 = this;
      var body = this.sources.map(function(source, i) {
        var separator = source.separator !== void 0 ? source.separator : this$1$1.separator;
        var str = (i > 0 ? separator : "") + source.content.toString();
        return str;
      }).join("");
      return this.intro + body;
    };
    Bundle$1.prototype.isEmpty = function isEmpty2() {
      if (this.intro.length && this.intro.trim()) {
        return false;
      }
      if (this.sources.some(function(source) {
        return !source.content.isEmpty();
      })) {
        return false;
      }
      return true;
    };
    Bundle$1.prototype.length = function length2() {
      return this.sources.reduce(function(length3, source) {
        return length3 + source.content.length();
      }, this.intro.length);
    };
    Bundle$1.prototype.trimLines = function trimLines2() {
      return this.trim("[\\r\\n]");
    };
    Bundle$1.prototype.trim = function trim2(charType) {
      return this.trimStart(charType).trimEnd(charType);
    };
    Bundle$1.prototype.trimStart = function trimStart3(charType) {
      var rx = new RegExp("^" + (charType || "\\s") + "+");
      this.intro = this.intro.replace(rx, "");
      if (!this.intro) {
        var source;
        var i = 0;
        do {
          source = this.sources[i++];
          if (!source) {
            break;
          }
        } while (!source.content.trimStartAborted(charType));
      }
      return this;
    };
    Bundle$1.prototype.trimEnd = function trimEnd3(charType) {
      var rx = new RegExp((charType || "\\s") + "+$");
      var source;
      var i = this.sources.length - 1;
      do {
        source = this.sources[i--];
        if (!source) {
          this.intro = this.intro.replace(rx, "");
          break;
        }
      } while (!source.content.trimEndAborted(charType));
      return this;
    };
    MagicString$1 = MagicString2;
    RESERVED_NAMES = {
      __proto__: null,
      await: true,
      break: true,
      case: true,
      catch: true,
      class: true,
      const: true,
      continue: true,
      debugger: true,
      default: true,
      delete: true,
      do: true,
      else: true,
      enum: true,
      eval: true,
      export: true,
      extends: true,
      false: true,
      finally: true,
      for: true,
      function: true,
      if: true,
      implements: true,
      import: true,
      in: true,
      instanceof: true,
      interface: true,
      let: true,
      new: true,
      null: true,
      package: true,
      private: true,
      protected: true,
      public: true,
      return: true,
      static: true,
      super: true,
      switch: true,
      this: true,
      throw: true,
      true: true,
      try: true,
      typeof: true,
      undefined: true,
      var: true,
      void: true,
      while: true,
      with: true,
      yield: true
    };
    UnknownKey = Symbol("Unknown Key");
    UnknownInteger = Symbol("Unknown Integer");
    EMPTY_PATH = [];
    UNKNOWN_PATH = [UnknownKey];
    UNKNOWN_INTEGER_PATH = [UnknownInteger];
    EntitiesKey = Symbol("Entities");
    PathTracker = class {
      constructor() {
        this.entityPaths = Object.create(null, {
          [EntitiesKey]: { value: /* @__PURE__ */ new Set() }
        });
      }
      trackEntityAtPathAndGetIfTracked(path6, entity) {
        const trackedEntities = this.getEntities(path6);
        if (trackedEntities.has(entity))
          return true;
        trackedEntities.add(entity);
        return false;
      }
      withTrackedEntityAtPath(path6, entity, onUntracked, returnIfTracked) {
        const trackedEntities = this.getEntities(path6);
        if (trackedEntities.has(entity))
          return returnIfTracked;
        trackedEntities.add(entity);
        const result2 = onUntracked();
        trackedEntities.delete(entity);
        return result2;
      }
      getEntities(path6) {
        let currentPaths = this.entityPaths;
        for (const pathSegment of path6) {
          currentPaths = currentPaths[pathSegment] = currentPaths[pathSegment] || Object.create(null, { [EntitiesKey]: { value: /* @__PURE__ */ new Set() } });
        }
        return currentPaths[EntitiesKey];
      }
    };
    SHARED_RECURSION_TRACKER = new PathTracker();
    DiscriminatedPathTracker = class {
      constructor() {
        this.entityPaths = Object.create(null, {
          [EntitiesKey]: { value: /* @__PURE__ */ new Map() }
        });
      }
      trackEntityAtPathAndGetIfTracked(path6, discriminator, entity) {
        let currentPaths = this.entityPaths;
        for (const pathSegment of path6) {
          currentPaths = currentPaths[pathSegment] = currentPaths[pathSegment] || Object.create(null, { [EntitiesKey]: { value: /* @__PURE__ */ new Map() } });
        }
        const trackedEntities = getOrCreate(currentPaths[EntitiesKey], discriminator, () => /* @__PURE__ */ new Set());
        if (trackedEntities.has(entity))
          return true;
        trackedEntities.add(entity);
        return false;
      }
    };
    UnknownValue = Symbol("Unknown Value");
    ExpressionEntity = class {
      constructor() {
        this.included = false;
      }
      deoptimizePath(_path) {
      }
      deoptimizeThisOnEventAtPath(_event, _path, thisParameter, _recursionTracker) {
        thisParameter.deoptimizePath(UNKNOWN_PATH);
      }
      /**
       * If possible it returns a stringifyable literal value for this node that can be used
       * for inlining or comparing values.
       * Otherwise it should return UnknownValue.
       */
      getLiteralValueAtPath(_path, _recursionTracker, _origin) {
        return UnknownValue;
      }
      getReturnExpressionWhenCalledAtPath(_path, _callOptions, _recursionTracker, _origin) {
        return UNKNOWN_EXPRESSION;
      }
      hasEffectsWhenAccessedAtPath(_path, _context) {
        return true;
      }
      hasEffectsWhenAssignedAtPath(_path, _context) {
        return true;
      }
      hasEffectsWhenCalledAtPath(_path, _callOptions, _context) {
        return true;
      }
      include(_context, _includeChildrenRecursively) {
        this.included = true;
      }
      includeCallArguments(context, args) {
        for (const arg of args) {
          arg.include(context, false);
        }
      }
    };
    UNKNOWN_EXPRESSION = new class UnknownExpression extends ExpressionEntity {
    }();
    Variable = class extends ExpressionEntity {
      constructor(name) {
        super();
        this.name = name;
        this.alwaysRendered = false;
        this.initReached = false;
        this.isId = false;
        this.isReassigned = false;
        this.kind = null;
        this.renderBaseName = null;
        this.renderName = null;
      }
      /**
       * Binds identifiers that reference this variable to this variable.
       * Necessary to be able to change variable names.
       */
      addReference(_identifier) {
      }
      getBaseVariableName() {
        return this.renderBaseName || this.renderName || this.name;
      }
      getName() {
        const name = this.renderName || this.name;
        return this.renderBaseName ? `${this.renderBaseName}${RESERVED_NAMES[name] ? `['${name}']` : `.${name}`}` : name;
      }
      hasEffectsWhenAccessedAtPath(path6, _context) {
        return path6.length > 0;
      }
      /**
       * Marks this variable as being part of the bundle, which is usually the case when one of
       * its identifiers becomes part of the bundle. Returns true if it has not been included
       * previously.
       * Once a variable is included, it should take care all its declarations are included.
       */
      include() {
        this.included = true;
      }
      markCalledFromTryStatement() {
      }
      setRenderNames(baseName, name) {
        this.renderBaseName = baseName;
        this.renderName = name;
      }
    };
    ExternalVariable = class extends Variable {
      constructor(module2, name) {
        super(name);
        this.module = module2;
        this.isNamespace = name === "*";
        this.referenced = false;
      }
      addReference(identifier) {
        this.referenced = true;
        if (this.name === "default" || this.name === "*") {
          this.module.suggestName(identifier.name);
        }
      }
      hasEffectsWhenAccessedAtPath(path6) {
        return path6.length > (this.isNamespace ? 1 : 0);
      }
      include() {
        if (!this.included) {
          this.included = true;
          this.module.used = true;
        }
      }
    };
    BLANK = Object.freeze(/* @__PURE__ */ Object.create(null));
    EMPTY_OBJECT = Object.freeze({});
    EMPTY_ARRAY = Object.freeze([]);
    reservedWords$1 = "break case class catch const continue debugger default delete do else export extends finally for function if import in instanceof let new return super switch this throw try typeof var void while with yield enum await implements package protected static interface private public".split(" ");
    builtins$1 = "Infinity NaN undefined null true false eval uneval isFinite isNaN parseFloat parseInt decodeURI decodeURIComponent encodeURI encodeURIComponent escape unescape Object Function Boolean Symbol Error EvalError InternalError RangeError ReferenceError SyntaxError TypeError URIError Number Math Date String RegExp Array Int8Array Uint8Array Uint8ClampedArray Int16Array Uint16Array Int32Array Uint32Array Float32Array Float64Array Map Set WeakMap WeakSet SIMD ArrayBuffer DataView JSON Promise Generator GeneratorFunction Reflect Proxy Intl".split(" ");
    blacklisted = new Set(reservedWords$1.concat(builtins$1));
    illegalCharacters = /[^$_a-zA-Z0-9]/g;
    startsWithDigit = (str) => /\d/.test(str[0]);
    absolutePath = /^(?:\/|(?:[A-Za-z]:)?[\\|/])/;
    relativePath = /^\.?\.\//;
    ExternalModule = class {
      constructor(options, id, hasModuleSideEffects, meta, renormalizeRenderPath) {
        this.options = options;
        this.id = id;
        this.renormalizeRenderPath = renormalizeRenderPath;
        this.defaultVariableName = "";
        this.dynamicImporters = [];
        this.importers = [];
        this.mostCommonSuggestion = 0;
        this.namespaceVariableName = "";
        this.reexported = false;
        this.renderPath = void 0;
        this.used = false;
        this.variableName = "";
        this.execIndex = Infinity;
        this.suggestedVariableName = makeLegal(id.split(/[\\/]/).pop());
        this.nameSuggestions = /* @__PURE__ */ Object.create(null);
        this.declarations = /* @__PURE__ */ Object.create(null);
        this.exportedVariables = /* @__PURE__ */ new Map();
        const { importers, dynamicImporters } = this;
        this.info = {
          ast: null,
          code: null,
          dynamicallyImportedIds: EMPTY_ARRAY,
          get dynamicImporters() {
            return dynamicImporters.sort();
          },
          hasModuleSideEffects,
          id,
          implicitlyLoadedAfterOneOf: EMPTY_ARRAY,
          implicitlyLoadedBefore: EMPTY_ARRAY,
          importedIds: EMPTY_ARRAY,
          get importers() {
            return importers.sort();
          },
          isEntry: false,
          isExternal: true,
          meta,
          syntheticNamedExports: false
        };
      }
      getVariableForExportName(name) {
        let declaration = this.declarations[name];
        if (declaration)
          return declaration;
        this.declarations[name] = declaration = new ExternalVariable(this, name);
        this.exportedVariables.set(declaration, name);
        return declaration;
      }
      setRenderPath(options, inputBase) {
        this.renderPath = typeof options.paths === "function" ? options.paths(this.id) : options.paths[this.id];
        if (!this.renderPath) {
          this.renderPath = this.renormalizeRenderPath ? normalize2((0, import_path11.relative)(inputBase, this.id)) : this.id;
        }
        return this.renderPath;
      }
      suggestName(name) {
        if (!this.nameSuggestions[name])
          this.nameSuggestions[name] = 0;
        this.nameSuggestions[name] += 1;
        if (this.nameSuggestions[name] > this.mostCommonSuggestion) {
          this.mostCommonSuggestion = this.nameSuggestions[name];
          this.suggestedVariableName = name;
        }
      }
      warnUnusedImports() {
        const unused = Object.keys(this.declarations).filter((name) => {
          if (name === "*")
            return false;
          const declaration = this.declarations[name];
          return !declaration.included && !this.reexported && !declaration.referenced;
        });
        if (unused.length === 0)
          return;
        const importersSet = /* @__PURE__ */ new Set();
        for (const name of unused) {
          const { importers } = this.declarations[name].module;
          for (const importer of importers) {
            importersSet.add(importer);
          }
        }
        const importersArray = [...importersSet];
        this.options.onwarn({
          code: "UNUSED_EXTERNAL_IMPORT",
          message: `${printQuotedStringList(unused, ["is", "are"])} imported from external module "${this.id}" but never used in ${printQuotedStringList(importersArray.map((importer) => relativeId(importer)))}.`,
          names: unused,
          source: this.id,
          sources: importersArray
        });
      }
    };
    extractors2 = {
      ArrayPattern(names, param) {
        for (const element of param.elements) {
          if (element)
            extractors2[element.type](names, element);
        }
      },
      AssignmentPattern(names, param) {
        extractors2[param.left.type](names, param.left);
      },
      Identifier(names, param) {
        names.push(param.name);
      },
      MemberExpression() {
      },
      ObjectPattern(names, param) {
        for (const prop of param.properties) {
          if (prop.type === "RestElement") {
            extractors2.RestElement(names, prop);
          } else {
            extractors2[prop.value.type](names, prop.value);
          }
        }
      },
      RestElement(names, param) {
        extractors2[param.argument.type](names, param.argument);
      }
    };
    extractAssignedNames3 = function extractAssignedNames4(param) {
      const names = [];
      extractors2[param.type](names, param);
      return names;
    };
    BROKEN_FLOW_NONE = 0;
    BROKEN_FLOW_BREAK_CONTINUE = 1;
    BROKEN_FLOW_ERROR_RETURN_LABEL = 2;
    base$1 = {};
    base$1.Program = base$1.BlockStatement = function(node, st, c) {
      for (var i = 0, list = node.body; i < list.length; i += 1) {
        var stmt = list[i];
        c(stmt, st, "Statement");
      }
    };
    base$1.Statement = skipThrough;
    base$1.EmptyStatement = ignore;
    base$1.ExpressionStatement = base$1.ParenthesizedExpression = base$1.ChainExpression = function(node, st, c) {
      return c(node.expression, st, "Expression");
    };
    base$1.IfStatement = function(node, st, c) {
      c(node.test, st, "Expression");
      c(node.consequent, st, "Statement");
      if (node.alternate) {
        c(node.alternate, st, "Statement");
      }
    };
    base$1.LabeledStatement = function(node, st, c) {
      return c(node.body, st, "Statement");
    };
    base$1.BreakStatement = base$1.ContinueStatement = ignore;
    base$1.WithStatement = function(node, st, c) {
      c(node.object, st, "Expression");
      c(node.body, st, "Statement");
    };
    base$1.SwitchStatement = function(node, st, c) {
      c(node.discriminant, st, "Expression");
      for (var i$1 = 0, list$1 = node.cases; i$1 < list$1.length; i$1 += 1) {
        var cs = list$1[i$1];
        if (cs.test) {
          c(cs.test, st, "Expression");
        }
        for (var i = 0, list = cs.consequent; i < list.length; i += 1) {
          var cons = list[i];
          c(cons, st, "Statement");
        }
      }
    };
    base$1.SwitchCase = function(node, st, c) {
      if (node.test) {
        c(node.test, st, "Expression");
      }
      for (var i = 0, list = node.consequent; i < list.length; i += 1) {
        var cons = list[i];
        c(cons, st, "Statement");
      }
    };
    base$1.ReturnStatement = base$1.YieldExpression = base$1.AwaitExpression = function(node, st, c) {
      if (node.argument) {
        c(node.argument, st, "Expression");
      }
    };
    base$1.ThrowStatement = base$1.SpreadElement = function(node, st, c) {
      return c(node.argument, st, "Expression");
    };
    base$1.TryStatement = function(node, st, c) {
      c(node.block, st, "Statement");
      if (node.handler) {
        c(node.handler, st);
      }
      if (node.finalizer) {
        c(node.finalizer, st, "Statement");
      }
    };
    base$1.CatchClause = function(node, st, c) {
      if (node.param) {
        c(node.param, st, "Pattern");
      }
      c(node.body, st, "Statement");
    };
    base$1.WhileStatement = base$1.DoWhileStatement = function(node, st, c) {
      c(node.test, st, "Expression");
      c(node.body, st, "Statement");
    };
    base$1.ForStatement = function(node, st, c) {
      if (node.init) {
        c(node.init, st, "ForInit");
      }
      if (node.test) {
        c(node.test, st, "Expression");
      }
      if (node.update) {
        c(node.update, st, "Expression");
      }
      c(node.body, st, "Statement");
    };
    base$1.ForInStatement = base$1.ForOfStatement = function(node, st, c) {
      c(node.left, st, "ForInit");
      c(node.right, st, "Expression");
      c(node.body, st, "Statement");
    };
    base$1.ForInit = function(node, st, c) {
      if (node.type === "VariableDeclaration") {
        c(node, st);
      } else {
        c(node, st, "Expression");
      }
    };
    base$1.DebuggerStatement = ignore;
    base$1.FunctionDeclaration = function(node, st, c) {
      return c(node, st, "Function");
    };
    base$1.VariableDeclaration = function(node, st, c) {
      for (var i = 0, list = node.declarations; i < list.length; i += 1) {
        var decl = list[i];
        c(decl, st);
      }
    };
    base$1.VariableDeclarator = function(node, st, c) {
      c(node.id, st, "Pattern");
      if (node.init) {
        c(node.init, st, "Expression");
      }
    };
    base$1.Function = function(node, st, c) {
      if (node.id) {
        c(node.id, st, "Pattern");
      }
      for (var i = 0, list = node.params; i < list.length; i += 1) {
        var param = list[i];
        c(param, st, "Pattern");
      }
      c(node.body, st, node.expression ? "Expression" : "Statement");
    };
    base$1.Pattern = function(node, st, c) {
      if (node.type === "Identifier") {
        c(node, st, "VariablePattern");
      } else if (node.type === "MemberExpression") {
        c(node, st, "MemberPattern");
      } else {
        c(node, st);
      }
    };
    base$1.VariablePattern = ignore;
    base$1.MemberPattern = skipThrough;
    base$1.RestElement = function(node, st, c) {
      return c(node.argument, st, "Pattern");
    };
    base$1.ArrayPattern = function(node, st, c) {
      for (var i = 0, list = node.elements; i < list.length; i += 1) {
        var elt = list[i];
        if (elt) {
          c(elt, st, "Pattern");
        }
      }
    };
    base$1.ObjectPattern = function(node, st, c) {
      for (var i = 0, list = node.properties; i < list.length; i += 1) {
        var prop = list[i];
        if (prop.type === "Property") {
          if (prop.computed) {
            c(prop.key, st, "Expression");
          }
          c(prop.value, st, "Pattern");
        } else if (prop.type === "RestElement") {
          c(prop.argument, st, "Pattern");
        }
      }
    };
    base$1.Expression = skipThrough;
    base$1.ThisExpression = base$1.Super = base$1.MetaProperty = ignore;
    base$1.ArrayExpression = function(node, st, c) {
      for (var i = 0, list = node.elements; i < list.length; i += 1) {
        var elt = list[i];
        if (elt) {
          c(elt, st, "Expression");
        }
      }
    };
    base$1.ObjectExpression = function(node, st, c) {
      for (var i = 0, list = node.properties; i < list.length; i += 1) {
        var prop = list[i];
        c(prop, st);
      }
    };
    base$1.FunctionExpression = base$1.ArrowFunctionExpression = base$1.FunctionDeclaration;
    base$1.SequenceExpression = function(node, st, c) {
      for (var i = 0, list = node.expressions; i < list.length; i += 1) {
        var expr = list[i];
        c(expr, st, "Expression");
      }
    };
    base$1.TemplateLiteral = function(node, st, c) {
      for (var i = 0, list = node.quasis; i < list.length; i += 1) {
        var quasi = list[i];
        c(quasi, st);
      }
      for (var i$1 = 0, list$1 = node.expressions; i$1 < list$1.length; i$1 += 1) {
        var expr = list$1[i$1];
        c(expr, st, "Expression");
      }
    };
    base$1.TemplateElement = ignore;
    base$1.UnaryExpression = base$1.UpdateExpression = function(node, st, c) {
      c(node.argument, st, "Expression");
    };
    base$1.BinaryExpression = base$1.LogicalExpression = function(node, st, c) {
      c(node.left, st, "Expression");
      c(node.right, st, "Expression");
    };
    base$1.AssignmentExpression = base$1.AssignmentPattern = function(node, st, c) {
      c(node.left, st, "Pattern");
      c(node.right, st, "Expression");
    };
    base$1.ConditionalExpression = function(node, st, c) {
      c(node.test, st, "Expression");
      c(node.consequent, st, "Expression");
      c(node.alternate, st, "Expression");
    };
    base$1.NewExpression = base$1.CallExpression = function(node, st, c) {
      c(node.callee, st, "Expression");
      if (node.arguments) {
        for (var i = 0, list = node.arguments; i < list.length; i += 1) {
          var arg = list[i];
          c(arg, st, "Expression");
        }
      }
    };
    base$1.MemberExpression = function(node, st, c) {
      c(node.object, st, "Expression");
      if (node.computed) {
        c(node.property, st, "Expression");
      }
    };
    base$1.ExportNamedDeclaration = base$1.ExportDefaultDeclaration = function(node, st, c) {
      if (node.declaration) {
        c(node.declaration, st, node.type === "ExportNamedDeclaration" || node.declaration.id ? "Statement" : "Expression");
      }
      if (node.source) {
        c(node.source, st, "Expression");
      }
    };
    base$1.ExportAllDeclaration = function(node, st, c) {
      if (node.exported) {
        c(node.exported, st);
      }
      c(node.source, st, "Expression");
    };
    base$1.ImportDeclaration = function(node, st, c) {
      for (var i = 0, list = node.specifiers; i < list.length; i += 1) {
        var spec = list[i];
        c(spec, st);
      }
      c(node.source, st, "Expression");
    };
    base$1.ImportExpression = function(node, st, c) {
      c(node.source, st, "Expression");
    };
    base$1.ImportSpecifier = base$1.ImportDefaultSpecifier = base$1.ImportNamespaceSpecifier = base$1.Identifier = base$1.PrivateIdentifier = base$1.Literal = ignore;
    base$1.TaggedTemplateExpression = function(node, st, c) {
      c(node.tag, st, "Expression");
      c(node.quasi, st, "Expression");
    };
    base$1.ClassDeclaration = base$1.ClassExpression = function(node, st, c) {
      return c(node, st, "Class");
    };
    base$1.Class = function(node, st, c) {
      if (node.id) {
        c(node.id, st, "Pattern");
      }
      if (node.superClass) {
        c(node.superClass, st, "Expression");
      }
      c(node.body, st);
    };
    base$1.ClassBody = function(node, st, c) {
      for (var i = 0, list = node.body; i < list.length; i += 1) {
        var elt = list[i];
        c(elt, st);
      }
    };
    base$1.MethodDefinition = base$1.PropertyDefinition = base$1.Property = function(node, st, c) {
      if (node.computed) {
        c(node.key, st, "Expression");
      }
      if (node.value) {
        c(node.value, st, "Expression");
      }
    };
    ArrowFunctionExpression$1 = "ArrowFunctionExpression";
    BinaryExpression$1 = "BinaryExpression";
    BlockStatement$1 = "BlockStatement";
    CallExpression$1 = "CallExpression";
    ChainExpression$1 = "ChainExpression";
    ConditionalExpression$1 = "ConditionalExpression";
    ExpressionStatement$1 = "ExpressionStatement";
    Identifier$1 = "Identifier";
    ImportDefaultSpecifier$1 = "ImportDefaultSpecifier";
    ImportNamespaceSpecifier$1 = "ImportNamespaceSpecifier";
    LogicalExpression$1 = "LogicalExpression";
    NewExpression$1 = "NewExpression";
    Program$1 = "Program";
    Property$1 = "Property";
    ReturnStatement$1 = "ReturnStatement";
    SequenceExpression$1 = "SequenceExpression";
    SOURCEMAPPING_URL = "sourceMa";
    SOURCEMAPPING_URL += "ppingURL";
    whiteSpaceNoNewline = "[ \\f\\r\\t\\v\\u00a0\\u1680\\u2000-\\u200a\\u2028\\u2029\\u202f\\u205f\\u3000\\ufeff]";
    SOURCEMAPPING_URL_RE = new RegExp(`^#${whiteSpaceNoNewline}+${SOURCEMAPPING_URL}=.+`);
    base$1.PropertyDefinition = function(node, st, c) {
      if (node.computed) {
        c(node.key, st, "Expression");
      }
      if (node.value) {
        c(node.value, st, "Expression");
      }
    };
    ANNOTATION_KEY = "_rollupAnnotations";
    INVALID_COMMENT_KEY = "_rollupRemoved";
    neitherWithespaceNorBrackets = /[^\s(]/g;
    noWhitespace = /\S/g;
    pureCommentRegex = /[@#]__PURE__/;
    keys = {
      Literal: [],
      Program: ["body"]
    };
    INCLUDE_PARAMETERS = "variables";
    NodeBase = class extends ExpressionEntity {
      constructor(esTreeNode, parent, parentScope) {
        super();
        this.esTreeNode = esTreeNode;
        this.keys = keys[esTreeNode.type] || getAndCreateKeys(esTreeNode);
        this.parent = parent;
        this.context = parent.context;
        this.createScope(parentScope);
        this.parseNode(esTreeNode);
        this.initialise();
        this.context.magicString.addSourcemapLocation(this.start);
        this.context.magicString.addSourcemapLocation(this.end);
      }
      addExportedVariables(_variables, _exportNamesByVariable) {
      }
      /**
       * Override this to bind assignments to variables and do any initialisations that
       * require the scopes to be populated with variables.
       */
      bind() {
        for (const key of this.keys) {
          const value = this[key];
          if (value === null)
            continue;
          if (Array.isArray(value)) {
            for (const child of value) {
              if (child !== null)
                child.bind();
            }
          } else {
            value.bind();
          }
        }
      }
      /**
       * Override if this node should receive a different scope than the parent scope.
       */
      createScope(parentScope) {
        this.scope = parentScope;
      }
      hasEffects(context) {
        if (this.deoptimized === false)
          this.applyDeoptimizations();
        for (const key of this.keys) {
          const value = this[key];
          if (value === null)
            continue;
          if (Array.isArray(value)) {
            for (const child of value) {
              if (child !== null && child.hasEffects(context))
                return true;
            }
          } else if (value.hasEffects(context))
            return true;
        }
        return false;
      }
      include(context, includeChildrenRecursively) {
        if (this.deoptimized === false)
          this.applyDeoptimizations();
        this.included = true;
        for (const key of this.keys) {
          const value = this[key];
          if (value === null)
            continue;
          if (Array.isArray(value)) {
            for (const child of value) {
              if (child !== null)
                child.include(context, includeChildrenRecursively);
            }
          } else {
            value.include(context, includeChildrenRecursively);
          }
        }
      }
      includeAsSingleStatement(context, includeChildrenRecursively) {
        this.include(context, includeChildrenRecursively);
      }
      /**
       * Override to perform special initialisation steps after the scope is initialised
       */
      initialise() {
      }
      insertSemicolon(code) {
        if (code.original[this.end - 1] !== ";") {
          code.appendLeft(this.end, ";");
        }
      }
      parseNode(esTreeNode) {
        for (const [key, value] of Object.entries(esTreeNode)) {
          if (this.hasOwnProperty(key))
            continue;
          if (key.charCodeAt(0) === 95) {
            if (key === ANNOTATION_KEY) {
              this.annotations = value;
            } else if (key === INVALID_COMMENT_KEY) {
              for (const { start, end } of value)
                this.context.magicString.remove(start, end);
            }
          } else if (typeof value !== "object" || value === null) {
            this[key] = value;
          } else if (Array.isArray(value)) {
            this[key] = [];
            for (const child of value) {
              this[key].push(child === null ? null : new (this.context.nodeConstructors[child.type] || this.context.nodeConstructors.UnknownNode)(child, this, this.scope));
            }
          } else {
            this[key] = new (this.context.nodeConstructors[value.type] || this.context.nodeConstructors.UnknownNode)(value, this, this.scope);
          }
        }
      }
      render(code, options) {
        for (const key of this.keys) {
          const value = this[key];
          if (value === null)
            continue;
          if (Array.isArray(value)) {
            for (const child of value) {
              if (child !== null)
                child.render(code, options);
            }
          } else {
            value.render(code, options);
          }
        }
      }
      shouldBeIncluded(context) {
        return this.included || !context.brokenFlow && this.hasEffects(createHasEffectsContext());
      }
      applyDeoptimizations() {
      }
    };
    ExportAllDeclaration = class extends NodeBase {
      hasEffects() {
        return false;
      }
      initialise() {
        this.context.addExport(this);
      }
      render(code, _options2, nodeRenderOptions) {
        code.remove(nodeRenderOptions.start, nodeRenderOptions.end);
      }
    };
    ExportAllDeclaration.prototype.needsBoundaries = true;
    NO_SEMICOLON = { isNoStatement: true };
    NON_WHITESPACE = /\S/g;
    chars2 = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_$";
    base = 64;
    NO_ARGS = [];
    UNDEFINED_EXPRESSION = new class UndefinedExpression extends ExpressionEntity {
      getLiteralValueAtPath() {
        return void 0;
      }
    }();
    returnsUnknown = {
      value: {
        callsArgs: null,
        returns: UNKNOWN_EXPRESSION
      }
    };
    UNKNOWN_LITERAL_BOOLEAN = new class UnknownBoolean extends ExpressionEntity {
      getReturnExpressionWhenCalledAtPath(path6) {
        if (path6.length === 1) {
          return getMemberReturnExpressionWhenCalled(literalBooleanMembers, path6[0]);
        }
        return UNKNOWN_EXPRESSION;
      }
      hasEffectsWhenAccessedAtPath(path6) {
        return path6.length > 1;
      }
      hasEffectsWhenCalledAtPath(path6, callOptions, context) {
        if (path6.length === 1) {
          return hasMemberEffectWhenCalled(literalBooleanMembers, path6[0], callOptions, context);
        }
        return true;
      }
    }();
    returnsBoolean = {
      value: {
        callsArgs: null,
        returns: UNKNOWN_LITERAL_BOOLEAN
      }
    };
    UNKNOWN_LITERAL_NUMBER = new class UnknownNumber extends ExpressionEntity {
      getReturnExpressionWhenCalledAtPath(path6) {
        if (path6.length === 1) {
          return getMemberReturnExpressionWhenCalled(literalNumberMembers, path6[0]);
        }
        return UNKNOWN_EXPRESSION;
      }
      hasEffectsWhenAccessedAtPath(path6) {
        return path6.length > 1;
      }
      hasEffectsWhenCalledAtPath(path6, callOptions, context) {
        if (path6.length === 1) {
          return hasMemberEffectWhenCalled(literalNumberMembers, path6[0], callOptions, context);
        }
        return true;
      }
    }();
    returnsNumber = {
      value: {
        callsArgs: null,
        returns: UNKNOWN_LITERAL_NUMBER
      }
    };
    UNKNOWN_LITERAL_STRING = new class UnknownString extends ExpressionEntity {
      getReturnExpressionWhenCalledAtPath(path6) {
        if (path6.length === 1) {
          return getMemberReturnExpressionWhenCalled(literalStringMembers, path6[0]);
        }
        return UNKNOWN_EXPRESSION;
      }
      hasEffectsWhenAccessedAtPath(path6) {
        return path6.length > 1;
      }
      hasEffectsWhenCalledAtPath(path6, callOptions, context) {
        if (path6.length === 1) {
          return hasMemberEffectWhenCalled(literalStringMembers, path6[0], callOptions, context);
        }
        return true;
      }
    }();
    returnsString = {
      value: {
        callsArgs: null,
        returns: UNKNOWN_LITERAL_STRING
      }
    };
    objectMembers = assembleMemberDescriptions({
      hasOwnProperty: returnsBoolean,
      isPrototypeOf: returnsBoolean,
      propertyIsEnumerable: returnsBoolean,
      toLocaleString: returnsString,
      toString: returnsString,
      valueOf: returnsUnknown
    });
    literalBooleanMembers = assembleMemberDescriptions({
      valueOf: returnsBoolean
    }, objectMembers);
    literalNumberMembers = assembleMemberDescriptions({
      toExponential: returnsString,
      toFixed: returnsString,
      toLocaleString: returnsString,
      toPrecision: returnsString,
      valueOf: returnsNumber
    }, objectMembers);
    literalStringMembers = assembleMemberDescriptions({
      charAt: returnsString,
      charCodeAt: returnsNumber,
      codePointAt: returnsNumber,
      concat: returnsString,
      endsWith: returnsBoolean,
      includes: returnsBoolean,
      indexOf: returnsNumber,
      lastIndexOf: returnsNumber,
      localeCompare: returnsNumber,
      match: returnsBoolean,
      normalize: returnsString,
      padEnd: returnsString,
      padStart: returnsString,
      repeat: returnsString,
      replace: {
        value: {
          callsArgs: [1],
          returns: UNKNOWN_LITERAL_STRING
        }
      },
      search: returnsNumber,
      slice: returnsString,
      split: returnsUnknown,
      startsWith: returnsBoolean,
      substr: returnsString,
      substring: returnsString,
      toLocaleLowerCase: returnsString,
      toLocaleUpperCase: returnsString,
      toLowerCase: returnsString,
      toUpperCase: returnsString,
      trim: returnsString,
      valueOf: returnsString
    }, objectMembers);
    LocalVariable = class extends Variable {
      constructor(name, declarator, init, context) {
        super(name);
        this.calledFromTryStatement = false;
        this.additionalInitializers = null;
        this.expressionsToBeDeoptimized = [];
        this.declarations = declarator ? [declarator] : [];
        this.init = init;
        this.deoptimizationTracker = context.deoptimizationTracker;
        this.module = context.module;
      }
      addDeclaration(identifier, init) {
        this.declarations.push(identifier);
        const additionalInitializers = this.markInitializersForDeoptimization();
        if (init !== null) {
          additionalInitializers.push(init);
        }
      }
      consolidateInitializers() {
        if (this.additionalInitializers !== null) {
          for (const initializer of this.additionalInitializers) {
            initializer.deoptimizePath(UNKNOWN_PATH);
          }
          this.additionalInitializers = null;
        }
      }
      deoptimizePath(path6) {
        var _a, _b;
        if (this.isReassigned || this.deoptimizationTracker.trackEntityAtPathAndGetIfTracked(path6, this)) {
          return;
        }
        if (path6.length === 0) {
          if (!this.isReassigned) {
            this.isReassigned = true;
            const expressionsToBeDeoptimized = this.expressionsToBeDeoptimized;
            this.expressionsToBeDeoptimized = [];
            for (const expression of expressionsToBeDeoptimized) {
              expression.deoptimizeCache();
            }
            (_a = this.init) === null || _a === void 0 ? void 0 : _a.deoptimizePath(UNKNOWN_PATH);
          }
        } else {
          (_b = this.init) === null || _b === void 0 ? void 0 : _b.deoptimizePath(path6);
        }
      }
      deoptimizeThisOnEventAtPath(event, path6, thisParameter, recursionTracker) {
        if (this.isReassigned || !this.init) {
          return thisParameter.deoptimizePath(UNKNOWN_PATH);
        }
        recursionTracker.withTrackedEntityAtPath(path6, this.init, () => this.init.deoptimizeThisOnEventAtPath(event, path6, thisParameter, recursionTracker), void 0);
      }
      getLiteralValueAtPath(path6, recursionTracker, origin) {
        if (this.isReassigned || !this.init) {
          return UnknownValue;
        }
        return recursionTracker.withTrackedEntityAtPath(path6, this.init, () => {
          this.expressionsToBeDeoptimized.push(origin);
          return this.init.getLiteralValueAtPath(path6, recursionTracker, origin);
        }, UnknownValue);
      }
      getReturnExpressionWhenCalledAtPath(path6, callOptions, recursionTracker, origin) {
        if (this.isReassigned || !this.init) {
          return UNKNOWN_EXPRESSION;
        }
        return recursionTracker.withTrackedEntityAtPath(path6, this.init, () => {
          this.expressionsToBeDeoptimized.push(origin);
          return this.init.getReturnExpressionWhenCalledAtPath(path6, callOptions, recursionTracker, origin);
        }, UNKNOWN_EXPRESSION);
      }
      hasEffectsWhenAccessedAtPath(path6, context) {
        if (this.isReassigned)
          return true;
        return this.init && !context.accessed.trackEntityAtPathAndGetIfTracked(path6, this) && this.init.hasEffectsWhenAccessedAtPath(path6, context);
      }
      hasEffectsWhenAssignedAtPath(path6, context) {
        if (this.included)
          return true;
        if (path6.length === 0)
          return false;
        if (this.isReassigned)
          return true;
        return this.init && !context.accessed.trackEntityAtPathAndGetIfTracked(path6, this) && this.init.hasEffectsWhenAssignedAtPath(path6, context);
      }
      hasEffectsWhenCalledAtPath(path6, callOptions, context) {
        if (this.isReassigned)
          return true;
        return this.init && !(callOptions.withNew ? context.instantiated : context.called).trackEntityAtPathAndGetIfTracked(path6, callOptions, this) && this.init.hasEffectsWhenCalledAtPath(path6, callOptions, context);
      }
      include() {
        if (!this.included) {
          this.included = true;
          for (const declaration of this.declarations) {
            if (!declaration.included)
              declaration.include(createInclusionContext(), false);
            let node = declaration.parent;
            while (!node.included) {
              node.included = true;
              if (node.type === Program$1)
                break;
              node = node.parent;
            }
          }
        }
      }
      includeCallArguments(context, args) {
        if (this.isReassigned || this.init && context.includedCallArguments.has(this.init)) {
          for (const arg of args) {
            arg.include(context, false);
          }
        } else if (this.init) {
          context.includedCallArguments.add(this.init);
          this.init.includeCallArguments(context, args);
          context.includedCallArguments.delete(this.init);
        }
      }
      markCalledFromTryStatement() {
        this.calledFromTryStatement = true;
      }
      markInitializersForDeoptimization() {
        if (this.additionalInitializers === null) {
          this.additionalInitializers = this.init === null ? [] : [this.init];
          this.init = UNKNOWN_EXPRESSION;
          this.isReassigned = true;
        }
        return this.additionalInitializers;
      }
    };
    Scope$1 = class {
      constructor() {
        this.children = [];
        this.variables = /* @__PURE__ */ new Map();
      }
      addDeclaration(identifier, context, init, _isHoisted) {
        const name = identifier.name;
        let variable = this.variables.get(name);
        if (variable) {
          variable.addDeclaration(identifier, init);
        } else {
          variable = new LocalVariable(identifier.name, identifier, init || UNDEFINED_EXPRESSION, context);
          this.variables.set(name, variable);
        }
        return variable;
      }
      contains(name) {
        return this.variables.has(name);
      }
      findVariable(_name) {
        throw new Error("Internal Error: findVariable needs to be implemented by a subclass");
      }
    };
    ChildScope = class _ChildScope extends Scope$1 {
      constructor(parent) {
        super();
        this.accessedOutsideVariables = /* @__PURE__ */ new Map();
        this.parent = parent;
        parent.children.push(this);
      }
      addAccessedDynamicImport(importExpression) {
        (this.accessedDynamicImports || (this.accessedDynamicImports = /* @__PURE__ */ new Set())).add(importExpression);
        if (this.parent instanceof _ChildScope) {
          this.parent.addAccessedDynamicImport(importExpression);
        }
      }
      addAccessedGlobals(globals, accessedGlobalsByScope) {
        const accessedGlobals = accessedGlobalsByScope.get(this) || /* @__PURE__ */ new Set();
        for (const name of globals) {
          accessedGlobals.add(name);
        }
        accessedGlobalsByScope.set(this, accessedGlobals);
        if (this.parent instanceof _ChildScope) {
          this.parent.addAccessedGlobals(globals, accessedGlobalsByScope);
        }
      }
      addNamespaceMemberAccess(name, variable) {
        this.accessedOutsideVariables.set(name, variable);
        this.parent.addNamespaceMemberAccess(name, variable);
      }
      addReturnExpression(expression) {
        this.parent instanceof _ChildScope && this.parent.addReturnExpression(expression);
      }
      addUsedOutsideNames(usedNames, format, exportNamesByVariable, accessedGlobalsByScope) {
        for (const variable of this.accessedOutsideVariables.values()) {
          if (variable.included) {
            usedNames.add(variable.getBaseVariableName());
            if (format === "system" && exportNamesByVariable.has(variable)) {
              usedNames.add("exports");
            }
          }
        }
        const accessedGlobals = accessedGlobalsByScope.get(this);
        if (accessedGlobals) {
          for (const name of accessedGlobals) {
            usedNames.add(name);
          }
        }
      }
      contains(name) {
        return this.variables.has(name) || this.parent.contains(name);
      }
      deconflict(format, exportNamesByVariable, accessedGlobalsByScope) {
        const usedNames = /* @__PURE__ */ new Set();
        this.addUsedOutsideNames(usedNames, format, exportNamesByVariable, accessedGlobalsByScope);
        if (this.accessedDynamicImports) {
          for (const importExpression of this.accessedDynamicImports) {
            if (importExpression.inlineNamespace) {
              usedNames.add(importExpression.inlineNamespace.getBaseVariableName());
            }
          }
        }
        for (const [name, variable] of this.variables) {
          if (variable.included || variable.alwaysRendered) {
            variable.setRenderNames(null, getSafeName(name, usedNames));
          }
        }
        for (const scope of this.children) {
          scope.deconflict(format, exportNamesByVariable, accessedGlobalsByScope);
        }
      }
      findLexicalBoundary() {
        return this.parent.findLexicalBoundary();
      }
      findVariable(name) {
        const knownVariable = this.variables.get(name) || this.accessedOutsideVariables.get(name);
        if (knownVariable) {
          return knownVariable;
        }
        const variable = this.parent.findVariable(name);
        this.accessedOutsideVariables.set(name, variable);
        return variable;
      }
    };
    ValueProperties = Symbol("Value Properties");
    PURE = { pure: true };
    IMPURE = { pure: false };
    O = {
      __proto__: null,
      [ValueProperties]: IMPURE
    };
    PF = {
      __proto__: null,
      [ValueProperties]: PURE
    };
    C = {
      __proto__: null,
      [ValueProperties]: IMPURE,
      prototype: O
    };
    PC = {
      __proto__: null,
      [ValueProperties]: PURE,
      prototype: O
    };
    ARRAY_TYPE = {
      __proto__: null,
      [ValueProperties]: PURE,
      from: PF,
      of: PF,
      prototype: O
    };
    INTL_MEMBER = {
      __proto__: null,
      [ValueProperties]: PURE,
      supportedLocalesOf: PC
    };
    knownGlobals = {
      // Placeholders for global objects to avoid shape mutations
      global: O,
      globalThis: O,
      self: O,
      window: O,
      // Common globals
      __proto__: null,
      [ValueProperties]: IMPURE,
      Array: {
        __proto__: null,
        [ValueProperties]: IMPURE,
        from: O,
        isArray: PF,
        of: PF,
        prototype: O
      },
      ArrayBuffer: {
        __proto__: null,
        [ValueProperties]: PURE,
        isView: PF,
        prototype: O
      },
      Atomics: O,
      BigInt: C,
      BigInt64Array: C,
      BigUint64Array: C,
      Boolean: PC,
      constructor: C,
      DataView: PC,
      Date: {
        __proto__: null,
        [ValueProperties]: PURE,
        now: PF,
        parse: PF,
        prototype: O,
        UTC: PF
      },
      decodeURI: PF,
      decodeURIComponent: PF,
      encodeURI: PF,
      encodeURIComponent: PF,
      Error: PC,
      escape: PF,
      eval: O,
      EvalError: PC,
      Float32Array: ARRAY_TYPE,
      Float64Array: ARRAY_TYPE,
      Function: C,
      hasOwnProperty: O,
      Infinity: O,
      Int16Array: ARRAY_TYPE,
      Int32Array: ARRAY_TYPE,
      Int8Array: ARRAY_TYPE,
      isFinite: PF,
      isNaN: PF,
      isPrototypeOf: O,
      JSON: O,
      Map: PC,
      Math: {
        __proto__: null,
        [ValueProperties]: IMPURE,
        abs: PF,
        acos: PF,
        acosh: PF,
        asin: PF,
        asinh: PF,
        atan: PF,
        atan2: PF,
        atanh: PF,
        cbrt: PF,
        ceil: PF,
        clz32: PF,
        cos: PF,
        cosh: PF,
        exp: PF,
        expm1: PF,
        floor: PF,
        fround: PF,
        hypot: PF,
        imul: PF,
        log: PF,
        log10: PF,
        log1p: PF,
        log2: PF,
        max: PF,
        min: PF,
        pow: PF,
        random: PF,
        round: PF,
        sign: PF,
        sin: PF,
        sinh: PF,
        sqrt: PF,
        tan: PF,
        tanh: PF,
        trunc: PF
      },
      NaN: O,
      Number: {
        __proto__: null,
        [ValueProperties]: PURE,
        isFinite: PF,
        isInteger: PF,
        isNaN: PF,
        isSafeInteger: PF,
        parseFloat: PF,
        parseInt: PF,
        prototype: O
      },
      Object: {
        __proto__: null,
        [ValueProperties]: PURE,
        create: PF,
        getNotifier: PF,
        getOwn: PF,
        getOwnPropertyDescriptor: PF,
        getOwnPropertyNames: PF,
        getOwnPropertySymbols: PF,
        getPrototypeOf: PF,
        is: PF,
        isExtensible: PF,
        isFrozen: PF,
        isSealed: PF,
        keys: PF,
        prototype: O
      },
      parseFloat: PF,
      parseInt: PF,
      Promise: {
        __proto__: null,
        [ValueProperties]: IMPURE,
        all: O,
        prototype: O,
        race: O,
        reject: O,
        resolve: O
      },
      propertyIsEnumerable: O,
      Proxy: O,
      RangeError: PC,
      ReferenceError: PC,
      Reflect: O,
      RegExp: PC,
      Set: PC,
      SharedArrayBuffer: C,
      String: {
        __proto__: null,
        [ValueProperties]: PURE,
        fromCharCode: PF,
        fromCodePoint: PF,
        prototype: O,
        raw: PF
      },
      Symbol: {
        __proto__: null,
        [ValueProperties]: PURE,
        for: PF,
        keyFor: PF,
        prototype: O
      },
      SyntaxError: PC,
      toLocaleString: O,
      toString: O,
      TypeError: PC,
      Uint16Array: ARRAY_TYPE,
      Uint32Array: ARRAY_TYPE,
      Uint8Array: ARRAY_TYPE,
      Uint8ClampedArray: ARRAY_TYPE,
      // Technically, this is a global, but it needs special handling
      // undefined: ?,
      unescape: PF,
      URIError: PC,
      valueOf: O,
      WeakMap: PC,
      WeakSet: PC,
      // Additional globals shared by Node and Browser that are not strictly part of the language
      clearInterval: C,
      clearTimeout: C,
      console: O,
      Intl: {
        __proto__: null,
        [ValueProperties]: IMPURE,
        Collator: INTL_MEMBER,
        DateTimeFormat: INTL_MEMBER,
        ListFormat: INTL_MEMBER,
        NumberFormat: INTL_MEMBER,
        PluralRules: INTL_MEMBER,
        RelativeTimeFormat: INTL_MEMBER
      },
      setInterval: C,
      setTimeout: C,
      TextDecoder: C,
      TextEncoder: C,
      URL: C,
      URLSearchParams: C,
      // Browser specific globals
      AbortController: C,
      AbortSignal: C,
      addEventListener: O,
      alert: O,
      AnalyserNode: C,
      Animation: C,
      AnimationEvent: C,
      applicationCache: O,
      ApplicationCache: C,
      ApplicationCacheErrorEvent: C,
      atob: O,
      Attr: C,
      Audio: C,
      AudioBuffer: C,
      AudioBufferSourceNode: C,
      AudioContext: C,
      AudioDestinationNode: C,
      AudioListener: C,
      AudioNode: C,
      AudioParam: C,
      AudioProcessingEvent: C,
      AudioScheduledSourceNode: C,
      AudioWorkletNode: C,
      BarProp: C,
      BaseAudioContext: C,
      BatteryManager: C,
      BeforeUnloadEvent: C,
      BiquadFilterNode: C,
      Blob: C,
      BlobEvent: C,
      blur: O,
      BroadcastChannel: C,
      btoa: O,
      ByteLengthQueuingStrategy: C,
      Cache: C,
      caches: O,
      CacheStorage: C,
      cancelAnimationFrame: O,
      cancelIdleCallback: O,
      CanvasCaptureMediaStreamTrack: C,
      CanvasGradient: C,
      CanvasPattern: C,
      CanvasRenderingContext2D: C,
      ChannelMergerNode: C,
      ChannelSplitterNode: C,
      CharacterData: C,
      clientInformation: O,
      ClipboardEvent: C,
      close: O,
      closed: O,
      CloseEvent: C,
      Comment: C,
      CompositionEvent: C,
      confirm: O,
      ConstantSourceNode: C,
      ConvolverNode: C,
      CountQueuingStrategy: C,
      createImageBitmap: O,
      Credential: C,
      CredentialsContainer: C,
      crypto: O,
      Crypto: C,
      CryptoKey: C,
      CSS: C,
      CSSConditionRule: C,
      CSSFontFaceRule: C,
      CSSGroupingRule: C,
      CSSImportRule: C,
      CSSKeyframeRule: C,
      CSSKeyframesRule: C,
      CSSMediaRule: C,
      CSSNamespaceRule: C,
      CSSPageRule: C,
      CSSRule: C,
      CSSRuleList: C,
      CSSStyleDeclaration: C,
      CSSStyleRule: C,
      CSSStyleSheet: C,
      CSSSupportsRule: C,
      CustomElementRegistry: C,
      customElements: O,
      CustomEvent: C,
      DataTransfer: C,
      DataTransferItem: C,
      DataTransferItemList: C,
      defaultstatus: O,
      defaultStatus: O,
      DelayNode: C,
      DeviceMotionEvent: C,
      DeviceOrientationEvent: C,
      devicePixelRatio: O,
      dispatchEvent: O,
      document: O,
      Document: C,
      DocumentFragment: C,
      DocumentType: C,
      DOMError: C,
      DOMException: C,
      DOMImplementation: C,
      DOMMatrix: C,
      DOMMatrixReadOnly: C,
      DOMParser: C,
      DOMPoint: C,
      DOMPointReadOnly: C,
      DOMQuad: C,
      DOMRect: C,
      DOMRectReadOnly: C,
      DOMStringList: C,
      DOMStringMap: C,
      DOMTokenList: C,
      DragEvent: C,
      DynamicsCompressorNode: C,
      Element: C,
      ErrorEvent: C,
      Event: C,
      EventSource: C,
      EventTarget: C,
      external: O,
      fetch: O,
      File: C,
      FileList: C,
      FileReader: C,
      find: O,
      focus: O,
      FocusEvent: C,
      FontFace: C,
      FontFaceSetLoadEvent: C,
      FormData: C,
      frames: O,
      GainNode: C,
      Gamepad: C,
      GamepadButton: C,
      GamepadEvent: C,
      getComputedStyle: O,
      getSelection: O,
      HashChangeEvent: C,
      Headers: C,
      history: O,
      History: C,
      HTMLAllCollection: C,
      HTMLAnchorElement: C,
      HTMLAreaElement: C,
      HTMLAudioElement: C,
      HTMLBaseElement: C,
      HTMLBodyElement: C,
      HTMLBRElement: C,
      HTMLButtonElement: C,
      HTMLCanvasElement: C,
      HTMLCollection: C,
      HTMLContentElement: C,
      HTMLDataElement: C,
      HTMLDataListElement: C,
      HTMLDetailsElement: C,
      HTMLDialogElement: C,
      HTMLDirectoryElement: C,
      HTMLDivElement: C,
      HTMLDListElement: C,
      HTMLDocument: C,
      HTMLElement: C,
      HTMLEmbedElement: C,
      HTMLFieldSetElement: C,
      HTMLFontElement: C,
      HTMLFormControlsCollection: C,
      HTMLFormElement: C,
      HTMLFrameElement: C,
      HTMLFrameSetElement: C,
      HTMLHeadElement: C,
      HTMLHeadingElement: C,
      HTMLHRElement: C,
      HTMLHtmlElement: C,
      HTMLIFrameElement: C,
      HTMLImageElement: C,
      HTMLInputElement: C,
      HTMLLabelElement: C,
      HTMLLegendElement: C,
      HTMLLIElement: C,
      HTMLLinkElement: C,
      HTMLMapElement: C,
      HTMLMarqueeElement: C,
      HTMLMediaElement: C,
      HTMLMenuElement: C,
      HTMLMetaElement: C,
      HTMLMeterElement: C,
      HTMLModElement: C,
      HTMLObjectElement: C,
      HTMLOListElement: C,
      HTMLOptGroupElement: C,
      HTMLOptionElement: C,
      HTMLOptionsCollection: C,
      HTMLOutputElement: C,
      HTMLParagraphElement: C,
      HTMLParamElement: C,
      HTMLPictureElement: C,
      HTMLPreElement: C,
      HTMLProgressElement: C,
      HTMLQuoteElement: C,
      HTMLScriptElement: C,
      HTMLSelectElement: C,
      HTMLShadowElement: C,
      HTMLSlotElement: C,
      HTMLSourceElement: C,
      HTMLSpanElement: C,
      HTMLStyleElement: C,
      HTMLTableCaptionElement: C,
      HTMLTableCellElement: C,
      HTMLTableColElement: C,
      HTMLTableElement: C,
      HTMLTableRowElement: C,
      HTMLTableSectionElement: C,
      HTMLTemplateElement: C,
      HTMLTextAreaElement: C,
      HTMLTimeElement: C,
      HTMLTitleElement: C,
      HTMLTrackElement: C,
      HTMLUListElement: C,
      HTMLUnknownElement: C,
      HTMLVideoElement: C,
      IDBCursor: C,
      IDBCursorWithValue: C,
      IDBDatabase: C,
      IDBFactory: C,
      IDBIndex: C,
      IDBKeyRange: C,
      IDBObjectStore: C,
      IDBOpenDBRequest: C,
      IDBRequest: C,
      IDBTransaction: C,
      IDBVersionChangeEvent: C,
      IdleDeadline: C,
      IIRFilterNode: C,
      Image: C,
      ImageBitmap: C,
      ImageBitmapRenderingContext: C,
      ImageCapture: C,
      ImageData: C,
      indexedDB: O,
      innerHeight: O,
      innerWidth: O,
      InputEvent: C,
      IntersectionObserver: C,
      IntersectionObserverEntry: C,
      isSecureContext: O,
      KeyboardEvent: C,
      KeyframeEffect: C,
      length: O,
      localStorage: O,
      location: O,
      Location: C,
      locationbar: O,
      matchMedia: O,
      MediaDeviceInfo: C,
      MediaDevices: C,
      MediaElementAudioSourceNode: C,
      MediaEncryptedEvent: C,
      MediaError: C,
      MediaKeyMessageEvent: C,
      MediaKeySession: C,
      MediaKeyStatusMap: C,
      MediaKeySystemAccess: C,
      MediaList: C,
      MediaQueryList: C,
      MediaQueryListEvent: C,
      MediaRecorder: C,
      MediaSettingsRange: C,
      MediaSource: C,
      MediaStream: C,
      MediaStreamAudioDestinationNode: C,
      MediaStreamAudioSourceNode: C,
      MediaStreamEvent: C,
      MediaStreamTrack: C,
      MediaStreamTrackEvent: C,
      menubar: O,
      MessageChannel: C,
      MessageEvent: C,
      MessagePort: C,
      MIDIAccess: C,
      MIDIConnectionEvent: C,
      MIDIInput: C,
      MIDIInputMap: C,
      MIDIMessageEvent: C,
      MIDIOutput: C,
      MIDIOutputMap: C,
      MIDIPort: C,
      MimeType: C,
      MimeTypeArray: C,
      MouseEvent: C,
      moveBy: O,
      moveTo: O,
      MutationEvent: C,
      MutationObserver: C,
      MutationRecord: C,
      name: O,
      NamedNodeMap: C,
      NavigationPreloadManager: C,
      navigator: O,
      Navigator: C,
      NetworkInformation: C,
      Node: C,
      NodeFilter: O,
      NodeIterator: C,
      NodeList: C,
      Notification: C,
      OfflineAudioCompletionEvent: C,
      OfflineAudioContext: C,
      offscreenBuffering: O,
      OffscreenCanvas: C,
      open: O,
      openDatabase: O,
      Option: C,
      origin: O,
      OscillatorNode: C,
      outerHeight: O,
      outerWidth: O,
      PageTransitionEvent: C,
      pageXOffset: O,
      pageYOffset: O,
      PannerNode: C,
      parent: O,
      Path2D: C,
      PaymentAddress: C,
      PaymentRequest: C,
      PaymentRequestUpdateEvent: C,
      PaymentResponse: C,
      performance: O,
      Performance: C,
      PerformanceEntry: C,
      PerformanceLongTaskTiming: C,
      PerformanceMark: C,
      PerformanceMeasure: C,
      PerformanceNavigation: C,
      PerformanceNavigationTiming: C,
      PerformanceObserver: C,
      PerformanceObserverEntryList: C,
      PerformancePaintTiming: C,
      PerformanceResourceTiming: C,
      PerformanceTiming: C,
      PeriodicWave: C,
      Permissions: C,
      PermissionStatus: C,
      personalbar: O,
      PhotoCapabilities: C,
      Plugin: C,
      PluginArray: C,
      PointerEvent: C,
      PopStateEvent: C,
      postMessage: O,
      Presentation: C,
      PresentationAvailability: C,
      PresentationConnection: C,
      PresentationConnectionAvailableEvent: C,
      PresentationConnectionCloseEvent: C,
      PresentationConnectionList: C,
      PresentationReceiver: C,
      PresentationRequest: C,
      print: O,
      ProcessingInstruction: C,
      ProgressEvent: C,
      PromiseRejectionEvent: C,
      prompt: O,
      PushManager: C,
      PushSubscription: C,
      PushSubscriptionOptions: C,
      queueMicrotask: O,
      RadioNodeList: C,
      Range: C,
      ReadableStream: C,
      RemotePlayback: C,
      removeEventListener: O,
      Request: C,
      requestAnimationFrame: O,
      requestIdleCallback: O,
      resizeBy: O,
      ResizeObserver: C,
      ResizeObserverEntry: C,
      resizeTo: O,
      Response: C,
      RTCCertificate: C,
      RTCDataChannel: C,
      RTCDataChannelEvent: C,
      RTCDtlsTransport: C,
      RTCIceCandidate: C,
      RTCIceTransport: C,
      RTCPeerConnection: C,
      RTCPeerConnectionIceEvent: C,
      RTCRtpReceiver: C,
      RTCRtpSender: C,
      RTCSctpTransport: C,
      RTCSessionDescription: C,
      RTCStatsReport: C,
      RTCTrackEvent: C,
      screen: O,
      Screen: C,
      screenLeft: O,
      ScreenOrientation: C,
      screenTop: O,
      screenX: O,
      screenY: O,
      ScriptProcessorNode: C,
      scroll: O,
      scrollbars: O,
      scrollBy: O,
      scrollTo: O,
      scrollX: O,
      scrollY: O,
      SecurityPolicyViolationEvent: C,
      Selection: C,
      ServiceWorker: C,
      ServiceWorkerContainer: C,
      ServiceWorkerRegistration: C,
      sessionStorage: O,
      ShadowRoot: C,
      SharedWorker: C,
      SourceBuffer: C,
      SourceBufferList: C,
      speechSynthesis: O,
      SpeechSynthesisEvent: C,
      SpeechSynthesisUtterance: C,
      StaticRange: C,
      status: O,
      statusbar: O,
      StereoPannerNode: C,
      stop: O,
      Storage: C,
      StorageEvent: C,
      StorageManager: C,
      styleMedia: O,
      StyleSheet: C,
      StyleSheetList: C,
      SubtleCrypto: C,
      SVGAElement: C,
      SVGAngle: C,
      SVGAnimatedAngle: C,
      SVGAnimatedBoolean: C,
      SVGAnimatedEnumeration: C,
      SVGAnimatedInteger: C,
      SVGAnimatedLength: C,
      SVGAnimatedLengthList: C,
      SVGAnimatedNumber: C,
      SVGAnimatedNumberList: C,
      SVGAnimatedPreserveAspectRatio: C,
      SVGAnimatedRect: C,
      SVGAnimatedString: C,
      SVGAnimatedTransformList: C,
      SVGAnimateElement: C,
      SVGAnimateMotionElement: C,
      SVGAnimateTransformElement: C,
      SVGAnimationElement: C,
      SVGCircleElement: C,
      SVGClipPathElement: C,
      SVGComponentTransferFunctionElement: C,
      SVGDefsElement: C,
      SVGDescElement: C,
      SVGDiscardElement: C,
      SVGElement: C,
      SVGEllipseElement: C,
      SVGFEBlendElement: C,
      SVGFEColorMatrixElement: C,
      SVGFEComponentTransferElement: C,
      SVGFECompositeElement: C,
      SVGFEConvolveMatrixElement: C,
      SVGFEDiffuseLightingElement: C,
      SVGFEDisplacementMapElement: C,
      SVGFEDistantLightElement: C,
      SVGFEDropShadowElement: C,
      SVGFEFloodElement: C,
      SVGFEFuncAElement: C,
      SVGFEFuncBElement: C,
      SVGFEFuncGElement: C,
      SVGFEFuncRElement: C,
      SVGFEGaussianBlurElement: C,
      SVGFEImageElement: C,
      SVGFEMergeElement: C,
      SVGFEMergeNodeElement: C,
      SVGFEMorphologyElement: C,
      SVGFEOffsetElement: C,
      SVGFEPointLightElement: C,
      SVGFESpecularLightingElement: C,
      SVGFESpotLightElement: C,
      SVGFETileElement: C,
      SVGFETurbulenceElement: C,
      SVGFilterElement: C,
      SVGForeignObjectElement: C,
      SVGGElement: C,
      SVGGeometryElement: C,
      SVGGradientElement: C,
      SVGGraphicsElement: C,
      SVGImageElement: C,
      SVGLength: C,
      SVGLengthList: C,
      SVGLinearGradientElement: C,
      SVGLineElement: C,
      SVGMarkerElement: C,
      SVGMaskElement: C,
      SVGMatrix: C,
      SVGMetadataElement: C,
      SVGMPathElement: C,
      SVGNumber: C,
      SVGNumberList: C,
      SVGPathElement: C,
      SVGPatternElement: C,
      SVGPoint: C,
      SVGPointList: C,
      SVGPolygonElement: C,
      SVGPolylineElement: C,
      SVGPreserveAspectRatio: C,
      SVGRadialGradientElement: C,
      SVGRect: C,
      SVGRectElement: C,
      SVGScriptElement: C,
      SVGSetElement: C,
      SVGStopElement: C,
      SVGStringList: C,
      SVGStyleElement: C,
      SVGSVGElement: C,
      SVGSwitchElement: C,
      SVGSymbolElement: C,
      SVGTextContentElement: C,
      SVGTextElement: C,
      SVGTextPathElement: C,
      SVGTextPositioningElement: C,
      SVGTitleElement: C,
      SVGTransform: C,
      SVGTransformList: C,
      SVGTSpanElement: C,
      SVGUnitTypes: C,
      SVGUseElement: C,
      SVGViewElement: C,
      TaskAttributionTiming: C,
      Text: C,
      TextEvent: C,
      TextMetrics: C,
      TextTrack: C,
      TextTrackCue: C,
      TextTrackCueList: C,
      TextTrackList: C,
      TimeRanges: C,
      toolbar: O,
      top: O,
      Touch: C,
      TouchEvent: C,
      TouchList: C,
      TrackEvent: C,
      TransitionEvent: C,
      TreeWalker: C,
      UIEvent: C,
      ValidityState: C,
      visualViewport: O,
      VisualViewport: C,
      VTTCue: C,
      WaveShaperNode: C,
      WebAssembly: O,
      WebGL2RenderingContext: C,
      WebGLActiveInfo: C,
      WebGLBuffer: C,
      WebGLContextEvent: C,
      WebGLFramebuffer: C,
      WebGLProgram: C,
      WebGLQuery: C,
      WebGLRenderbuffer: C,
      WebGLRenderingContext: C,
      WebGLSampler: C,
      WebGLShader: C,
      WebGLShaderPrecisionFormat: C,
      WebGLSync: C,
      WebGLTexture: C,
      WebGLTransformFeedback: C,
      WebGLUniformLocation: C,
      WebGLVertexArrayObject: C,
      WebSocket: C,
      WheelEvent: C,
      Window: C,
      Worker: C,
      WritableStream: C,
      XMLDocument: C,
      XMLHttpRequest: C,
      XMLHttpRequestEventTarget: C,
      XMLHttpRequestUpload: C,
      XMLSerializer: C,
      XPathEvaluator: C,
      XPathExpression: C,
      XPathResult: C,
      XSLTProcessor: C
    };
    for (const global2 of ["window", "global", "self", "globalThis"]) {
      knownGlobals[global2] = knownGlobals;
    }
    GlobalVariable = class extends Variable {
      constructor() {
        super(...arguments);
        this.isReassigned = true;
      }
      hasEffectsWhenAccessedAtPath(path6) {
        return !isGlobalMember([this.name, ...path6]);
      }
      hasEffectsWhenCalledAtPath(path6) {
        return !isPureGlobal([this.name, ...path6]);
      }
    };
    tdzVariableKinds = {
      __proto__: null,
      class: true,
      const: true,
      let: true,
      var: true
    };
    Identifier = class extends NodeBase {
      constructor() {
        super(...arguments);
        this.variable = null;
        this.deoptimized = false;
        this.isTDZAccess = null;
      }
      addExportedVariables(variables, exportNamesByVariable) {
        if (this.variable !== null && exportNamesByVariable.has(this.variable)) {
          variables.push(this.variable);
        }
      }
      bind() {
        if (this.variable === null && is_reference(this, this.parent)) {
          this.variable = this.scope.findVariable(this.name);
          this.variable.addReference(this);
        }
      }
      declare(kind, init) {
        let variable;
        const { treeshake } = this.context.options;
        switch (kind) {
          case "var":
            variable = this.scope.addDeclaration(this, this.context, init, true);
            if (treeshake && treeshake.correctVarValueBeforeDeclaration) {
              variable.markInitializersForDeoptimization();
            }
            break;
          case "function":
            variable = this.scope.addDeclaration(this, this.context, init, false);
            break;
          case "let":
          case "const":
          case "class":
            variable = this.scope.addDeclaration(this, this.context, init, false);
            break;
          case "parameter":
            variable = this.scope.addParameterDeclaration(this);
            break;
          default:
            throw new Error(`Internal Error: Unexpected identifier kind ${kind}.`);
        }
        variable.kind = kind;
        return [this.variable = variable];
      }
      deoptimizePath(path6) {
        if (path6.length === 0 && !this.scope.contains(this.name)) {
          this.disallowImportReassignment();
        }
        this.variable.deoptimizePath(path6);
      }
      deoptimizeThisOnEventAtPath(event, path6, thisParameter, recursionTracker) {
        this.variable.deoptimizeThisOnEventAtPath(event, path6, thisParameter, recursionTracker);
      }
      getLiteralValueAtPath(path6, recursionTracker, origin) {
        return this.getVariableRespectingTDZ().getLiteralValueAtPath(path6, recursionTracker, origin);
      }
      getReturnExpressionWhenCalledAtPath(path6, callOptions, recursionTracker, origin) {
        return this.getVariableRespectingTDZ().getReturnExpressionWhenCalledAtPath(path6, callOptions, recursionTracker, origin);
      }
      hasEffects() {
        if (!this.deoptimized)
          this.applyDeoptimizations();
        if (this.isPossibleTDZ() && this.variable.kind !== "var") {
          return true;
        }
        return this.context.options.treeshake.unknownGlobalSideEffects && this.variable instanceof GlobalVariable && this.variable.hasEffectsWhenAccessedAtPath(EMPTY_PATH);
      }
      hasEffectsWhenAccessedAtPath(path6, context) {
        return this.variable !== null && this.getVariableRespectingTDZ().hasEffectsWhenAccessedAtPath(path6, context);
      }
      hasEffectsWhenAssignedAtPath(path6, context) {
        return !this.variable || (path6.length > 0 ? this.getVariableRespectingTDZ() : this.variable).hasEffectsWhenAssignedAtPath(path6, context);
      }
      hasEffectsWhenCalledAtPath(path6, callOptions, context) {
        return !this.variable || this.getVariableRespectingTDZ().hasEffectsWhenCalledAtPath(path6, callOptions, context);
      }
      include() {
        if (!this.deoptimized)
          this.applyDeoptimizations();
        if (!this.included) {
          this.included = true;
          if (this.variable !== null) {
            this.context.includeVariableInModule(this.variable);
          }
        }
      }
      includeCallArguments(context, args) {
        this.getVariableRespectingTDZ().includeCallArguments(context, args);
      }
      isPossibleTDZ() {
        if (this.isTDZAccess !== null)
          return this.isTDZAccess;
        if (!(this.variable instanceof LocalVariable) || !this.variable.kind || !(this.variable.kind in tdzVariableKinds)) {
          return this.isTDZAccess = false;
        }
        let decl_id;
        if (this.variable.declarations && this.variable.declarations.length === 1 && (decl_id = this.variable.declarations[0]) && this.start < decl_id.start && closestParentFunctionOrProgram(this) === closestParentFunctionOrProgram(decl_id)) {
          return this.isTDZAccess = true;
        }
        if (!this.variable.initReached) {
          return this.isTDZAccess = true;
        }
        return this.isTDZAccess = false;
      }
      markDeclarationReached() {
        this.variable.initReached = true;
      }
      render(code, _options2, { renderedParentType, isCalleeOfRenderedParent, isShorthandProperty } = BLANK) {
        if (this.variable) {
          const name = this.variable.getName();
          if (name !== this.name) {
            code.overwrite(this.start, this.end, name, {
              contentOnly: true,
              storeName: true
            });
            if (isShorthandProperty) {
              code.prependRight(this.start, `${this.name}: `);
            }
          }
          if (name === "eval" && renderedParentType === CallExpression$1 && isCalleeOfRenderedParent) {
            code.appendRight(this.start, "0, ");
          }
        }
      }
      applyDeoptimizations() {
        this.deoptimized = true;
        if (this.variable !== null && this.variable instanceof LocalVariable) {
          this.variable.consolidateInitializers();
          this.context.requestTreeshakingPass();
        }
      }
      disallowImportReassignment() {
        return this.context.error({
          code: "ILLEGAL_REASSIGNMENT",
          message: `Illegal reassignment to import '${this.name}'`
        }, this.start);
      }
      getVariableRespectingTDZ() {
        if (this.isPossibleTDZ()) {
          return UNKNOWN_EXPRESSION;
        }
        return this.variable;
      }
    };
    EVENT_ACCESSED = 0;
    EVENT_ASSIGNED = 1;
    EVENT_CALLED = 2;
    MethodBase = class extends NodeBase {
      constructor() {
        super(...arguments);
        this.accessedValue = null;
        this.accessorCallOptions = {
          args: NO_ARGS,
          thisParam: null,
          withNew: false
        };
      }
      // As getter properties directly receive their values from fixed function
      // expressions, there is no known situation where a getter is deoptimized.
      deoptimizeCache() {
      }
      deoptimizePath(path6) {
        this.getAccessedValue().deoptimizePath(path6);
      }
      deoptimizeThisOnEventAtPath(event, path6, thisParameter, recursionTracker) {
        if (event === EVENT_ACCESSED && this.kind === "get" && path6.length === 0) {
          return this.value.deoptimizeThisOnEventAtPath(EVENT_CALLED, EMPTY_PATH, thisParameter, recursionTracker);
        }
        if (event === EVENT_ASSIGNED && this.kind === "set" && path6.length === 0) {
          return this.value.deoptimizeThisOnEventAtPath(EVENT_CALLED, EMPTY_PATH, thisParameter, recursionTracker);
        }
        this.getAccessedValue().deoptimizeThisOnEventAtPath(event, path6, thisParameter, recursionTracker);
      }
      getLiteralValueAtPath(path6, recursionTracker, origin) {
        return this.getAccessedValue().getLiteralValueAtPath(path6, recursionTracker, origin);
      }
      getReturnExpressionWhenCalledAtPath(path6, callOptions, recursionTracker, origin) {
        return this.getAccessedValue().getReturnExpressionWhenCalledAtPath(path6, callOptions, recursionTracker, origin);
      }
      hasEffects(context) {
        return this.key.hasEffects(context);
      }
      hasEffectsWhenAccessedAtPath(path6, context) {
        if (this.kind === "get" && path6.length === 0) {
          return this.value.hasEffectsWhenCalledAtPath(EMPTY_PATH, this.accessorCallOptions, context);
        }
        return this.getAccessedValue().hasEffectsWhenAccessedAtPath(path6, context);
      }
      hasEffectsWhenAssignedAtPath(path6, context) {
        if (this.kind === "set") {
          return this.value.hasEffectsWhenCalledAtPath(EMPTY_PATH, this.accessorCallOptions, context);
        }
        return this.getAccessedValue().hasEffectsWhenAssignedAtPath(path6, context);
      }
      hasEffectsWhenCalledAtPath(path6, callOptions, context) {
        return this.getAccessedValue().hasEffectsWhenCalledAtPath(path6, callOptions, context);
      }
      getAccessedValue() {
        if (this.accessedValue === null) {
          if (this.kind === "get") {
            this.accessedValue = UNKNOWN_EXPRESSION;
            return this.accessedValue = this.value.getReturnExpressionWhenCalledAtPath(EMPTY_PATH, this.accessorCallOptions, SHARED_RECURSION_TRACKER, this);
          } else {
            return this.accessedValue = this.value;
          }
        }
        return this.accessedValue;
      }
    };
    MethodDefinition = class extends MethodBase {
    };
    INTEGER_REG_EXP = /^\d+$/;
    ObjectEntity = class extends ExpressionEntity {
      // If a PropertyMap is used, this will be taken as propertiesAndGettersByKey
      // and we assume there are no setters or getters
      constructor(properties, prototypeExpression, immutable = false) {
        super();
        this.prototypeExpression = prototypeExpression;
        this.immutable = immutable;
        this.allProperties = [];
        this.deoptimizedPaths = /* @__PURE__ */ Object.create(null);
        this.expressionsToBeDeoptimizedByKey = /* @__PURE__ */ Object.create(null);
        this.gettersByKey = /* @__PURE__ */ Object.create(null);
        this.hasUnknownDeoptimizedInteger = false;
        this.hasUnknownDeoptimizedProperty = false;
        this.propertiesAndGettersByKey = /* @__PURE__ */ Object.create(null);
        this.propertiesAndSettersByKey = /* @__PURE__ */ Object.create(null);
        this.settersByKey = /* @__PURE__ */ Object.create(null);
        this.thisParametersToBeDeoptimized = /* @__PURE__ */ new Set();
        this.unknownIntegerProps = [];
        this.unmatchableGetters = [];
        this.unmatchablePropertiesAndGetters = [];
        this.unmatchableSetters = [];
        if (Array.isArray(properties)) {
          this.buildPropertyMaps(properties);
        } else {
          this.propertiesAndGettersByKey = this.propertiesAndSettersByKey = properties;
          for (const propertiesForKey of Object.values(properties)) {
            this.allProperties.push(...propertiesForKey);
          }
        }
      }
      deoptimizeAllProperties() {
        var _a;
        if (this.hasUnknownDeoptimizedProperty) {
          return;
        }
        this.hasUnknownDeoptimizedProperty = true;
        for (const properties of Object.values(this.propertiesAndGettersByKey).concat(Object.values(this.settersByKey))) {
          for (const property2 of properties) {
            property2.deoptimizePath(UNKNOWN_PATH);
          }
        }
        (_a = this.prototypeExpression) === null || _a === void 0 ? void 0 : _a.deoptimizePath([UnknownKey, UnknownKey]);
        this.deoptimizeCachedEntities();
      }
      deoptimizeIntegerProperties() {
        if (this.hasUnknownDeoptimizedProperty || this.hasUnknownDeoptimizedInteger) {
          return;
        }
        this.hasUnknownDeoptimizedInteger = true;
        for (const [key, propertiesAndGetters] of Object.entries(this.propertiesAndGettersByKey)) {
          if (INTEGER_REG_EXP.test(key)) {
            for (const property2 of propertiesAndGetters) {
              property2.deoptimizePath(UNKNOWN_PATH);
            }
          }
        }
        this.deoptimizeCachedIntegerEntities();
      }
      deoptimizePath(path6) {
        var _a;
        if (this.hasUnknownDeoptimizedProperty || this.immutable)
          return;
        const key = path6[0];
        if (path6.length === 1) {
          if (typeof key !== "string") {
            if (key === UnknownInteger) {
              return this.deoptimizeIntegerProperties();
            }
            return this.deoptimizeAllProperties();
          }
          if (!this.deoptimizedPaths[key]) {
            this.deoptimizedPaths[key] = true;
            const expressionsToBeDeoptimized = this.expressionsToBeDeoptimizedByKey[key];
            if (expressionsToBeDeoptimized) {
              for (const expression of expressionsToBeDeoptimized) {
                expression.deoptimizeCache();
              }
            }
          }
        }
        const subPath = path6.length === 1 ? UNKNOWN_PATH : path6.slice(1);
        for (const property2 of typeof key === "string" ? (this.propertiesAndGettersByKey[key] || this.unmatchablePropertiesAndGetters).concat(this.settersByKey[key] || this.unmatchableSetters) : this.allProperties) {
          property2.deoptimizePath(subPath);
        }
        (_a = this.prototypeExpression) === null || _a === void 0 ? void 0 : _a.deoptimizePath(path6.length === 1 ? [UnknownKey, UnknownKey] : path6);
      }
      deoptimizeThisOnEventAtPath(event, path6, thisParameter, recursionTracker) {
        var _a;
        const [key, ...subPath] = path6;
        if (this.hasUnknownDeoptimizedProperty || // single paths that are deoptimized will not become getters or setters
        (event === EVENT_CALLED || path6.length > 1) && typeof key === "string" && this.deoptimizedPaths[key]) {
          thisParameter.deoptimizePath(UNKNOWN_PATH);
          return;
        }
        const [propertiesForExactMatchByKey, relevantPropertiesByKey, relevantUnmatchableProperties] = event === EVENT_CALLED || path6.length > 1 ? [
          this.propertiesAndGettersByKey,
          this.propertiesAndGettersByKey,
          this.unmatchablePropertiesAndGetters
        ] : event === EVENT_ACCESSED ? [this.propertiesAndGettersByKey, this.gettersByKey, this.unmatchableGetters] : [this.propertiesAndSettersByKey, this.settersByKey, this.unmatchableSetters];
        if (typeof key === "string") {
          if (propertiesForExactMatchByKey[key]) {
            const properties = relevantPropertiesByKey[key];
            if (properties) {
              for (const property2 of properties) {
                property2.deoptimizeThisOnEventAtPath(event, subPath, thisParameter, recursionTracker);
              }
            }
            if (!this.immutable) {
              this.thisParametersToBeDeoptimized.add(thisParameter);
            }
            return;
          }
          for (const property2 of relevantUnmatchableProperties) {
            property2.deoptimizeThisOnEventAtPath(event, subPath, thisParameter, recursionTracker);
          }
          if (INTEGER_REG_EXP.test(key)) {
            for (const property2 of this.unknownIntegerProps) {
              property2.deoptimizeThisOnEventAtPath(event, subPath, thisParameter, recursionTracker);
            }
          }
        } else {
          for (const properties of Object.values(relevantPropertiesByKey).concat([
            relevantUnmatchableProperties
          ])) {
            for (const property2 of properties) {
              property2.deoptimizeThisOnEventAtPath(event, subPath, thisParameter, recursionTracker);
            }
          }
          for (const property2 of this.unknownIntegerProps) {
            property2.deoptimizeThisOnEventAtPath(event, subPath, thisParameter, recursionTracker);
          }
        }
        if (!this.immutable) {
          this.thisParametersToBeDeoptimized.add(thisParameter);
        }
        (_a = this.prototypeExpression) === null || _a === void 0 ? void 0 : _a.deoptimizeThisOnEventAtPath(event, path6, thisParameter, recursionTracker);
      }
      getLiteralValueAtPath(path6, recursionTracker, origin) {
        if (path6.length === 0) {
          return UnknownValue;
        }
        const key = path6[0];
        const expressionAtPath = this.getMemberExpressionAndTrackDeopt(key, origin);
        if (expressionAtPath) {
          return expressionAtPath.getLiteralValueAtPath(path6.slice(1), recursionTracker, origin);
        }
        if (this.prototypeExpression) {
          return this.prototypeExpression.getLiteralValueAtPath(path6, recursionTracker, origin);
        }
        if (path6.length === 1) {
          return void 0;
        }
        return UnknownValue;
      }
      getReturnExpressionWhenCalledAtPath(path6, callOptions, recursionTracker, origin) {
        if (path6.length === 0) {
          return UNKNOWN_EXPRESSION;
        }
        const key = path6[0];
        const expressionAtPath = this.getMemberExpressionAndTrackDeopt(key, origin);
        if (expressionAtPath) {
          return expressionAtPath.getReturnExpressionWhenCalledAtPath(path6.slice(1), callOptions, recursionTracker, origin);
        }
        if (this.prototypeExpression) {
          return this.prototypeExpression.getReturnExpressionWhenCalledAtPath(path6, callOptions, recursionTracker, origin);
        }
        return UNKNOWN_EXPRESSION;
      }
      hasEffectsWhenAccessedAtPath(path6, context) {
        const [key, ...subPath] = path6;
        if (path6.length > 1) {
          if (typeof key !== "string") {
            return true;
          }
          const expressionAtPath = this.getMemberExpression(key);
          if (expressionAtPath) {
            return expressionAtPath.hasEffectsWhenAccessedAtPath(subPath, context);
          }
          if (this.prototypeExpression) {
            return this.prototypeExpression.hasEffectsWhenAccessedAtPath(path6, context);
          }
          return true;
        }
        if (this.hasUnknownDeoptimizedProperty)
          return true;
        if (typeof key === "string") {
          if (this.propertiesAndGettersByKey[key]) {
            const getters = this.gettersByKey[key];
            if (getters) {
              for (const getter of getters) {
                if (getter.hasEffectsWhenAccessedAtPath(subPath, context))
                  return true;
              }
            }
            return false;
          }
          for (const getter of this.unmatchableGetters) {
            if (getter.hasEffectsWhenAccessedAtPath(subPath, context)) {
              return true;
            }
          }
        } else {
          for (const getters of Object.values(this.gettersByKey).concat([this.unmatchableGetters])) {
            for (const getter of getters) {
              if (getter.hasEffectsWhenAccessedAtPath(subPath, context))
                return true;
            }
          }
        }
        if (this.prototypeExpression) {
          return this.prototypeExpression.hasEffectsWhenAccessedAtPath(path6, context);
        }
        return false;
      }
      hasEffectsWhenAssignedAtPath(path6, context) {
        const [key, ...subPath] = path6;
        if (path6.length > 1) {
          if (typeof key !== "string") {
            return true;
          }
          const expressionAtPath = this.getMemberExpression(key);
          if (expressionAtPath) {
            return expressionAtPath.hasEffectsWhenAssignedAtPath(subPath, context);
          }
          if (this.prototypeExpression) {
            return this.prototypeExpression.hasEffectsWhenAssignedAtPath(path6, context);
          }
          return true;
        }
        if (this.hasUnknownDeoptimizedProperty)
          return true;
        if (typeof key === "string") {
          if (this.propertiesAndSettersByKey[key]) {
            const setters = this.settersByKey[key];
            if (setters) {
              for (const setter of setters) {
                if (setter.hasEffectsWhenAssignedAtPath(subPath, context))
                  return true;
              }
            }
            return false;
          }
          for (const property2 of this.unmatchableSetters) {
            if (property2.hasEffectsWhenAssignedAtPath(subPath, context)) {
              return true;
            }
          }
        }
        if (this.prototypeExpression) {
          return this.prototypeExpression.hasEffectsWhenAssignedAtPath(path6, context);
        }
        return false;
      }
      hasEffectsWhenCalledAtPath(path6, callOptions, context) {
        const key = path6[0];
        const expressionAtPath = this.getMemberExpression(key);
        if (expressionAtPath) {
          return expressionAtPath.hasEffectsWhenCalledAtPath(path6.slice(1), callOptions, context);
        }
        if (this.prototypeExpression) {
          return this.prototypeExpression.hasEffectsWhenCalledAtPath(path6, callOptions, context);
        }
        return true;
      }
      buildPropertyMaps(properties) {
        const { allProperties, propertiesAndGettersByKey, propertiesAndSettersByKey, settersByKey, gettersByKey, unknownIntegerProps, unmatchablePropertiesAndGetters, unmatchableGetters, unmatchableSetters } = this;
        const unmatchablePropertiesAndSetters = [];
        for (let index2 = properties.length - 1; index2 >= 0; index2--) {
          const { key, kind, property: property2 } = properties[index2];
          allProperties.push(property2);
          if (typeof key !== "string") {
            if (key === UnknownInteger) {
              unknownIntegerProps.push(property2);
              continue;
            }
            if (kind === "set")
              unmatchableSetters.push(property2);
            if (kind === "get")
              unmatchableGetters.push(property2);
            if (kind !== "get")
              unmatchablePropertiesAndSetters.push(property2);
            if (kind !== "set")
              unmatchablePropertiesAndGetters.push(property2);
          } else {
            if (kind === "set") {
              if (!propertiesAndSettersByKey[key]) {
                propertiesAndSettersByKey[key] = [property2, ...unmatchablePropertiesAndSetters];
                settersByKey[key] = [property2, ...unmatchableSetters];
              }
            } else if (kind === "get") {
              if (!propertiesAndGettersByKey[key]) {
                propertiesAndGettersByKey[key] = [property2, ...unmatchablePropertiesAndGetters];
                gettersByKey[key] = [property2, ...unmatchableGetters];
              }
            } else {
              if (!propertiesAndSettersByKey[key]) {
                propertiesAndSettersByKey[key] = [property2, ...unmatchablePropertiesAndSetters];
              }
              if (!propertiesAndGettersByKey[key]) {
                propertiesAndGettersByKey[key] = [property2, ...unmatchablePropertiesAndGetters];
              }
            }
          }
        }
      }
      deoptimizeCachedEntities() {
        for (const expressionsToBeDeoptimized of Object.values(this.expressionsToBeDeoptimizedByKey)) {
          for (const expression of expressionsToBeDeoptimized) {
            expression.deoptimizeCache();
          }
        }
        for (const expression of this.thisParametersToBeDeoptimized) {
          expression.deoptimizePath(UNKNOWN_PATH);
        }
      }
      deoptimizeCachedIntegerEntities() {
        for (const [key, expressionsToBeDeoptimized] of Object.entries(this.expressionsToBeDeoptimizedByKey)) {
          if (INTEGER_REG_EXP.test(key)) {
            for (const expression of expressionsToBeDeoptimized) {
              expression.deoptimizeCache();
            }
          }
        }
        for (const expression of this.thisParametersToBeDeoptimized) {
          expression.deoptimizePath(UNKNOWN_INTEGER_PATH);
        }
      }
      getMemberExpression(key) {
        if (this.hasUnknownDeoptimizedProperty || typeof key !== "string" || this.hasUnknownDeoptimizedInteger && INTEGER_REG_EXP.test(key) || this.deoptimizedPaths[key]) {
          return UNKNOWN_EXPRESSION;
        }
        const properties = this.propertiesAndGettersByKey[key];
        if ((properties === null || properties === void 0 ? void 0 : properties.length) === 1) {
          return properties[0];
        }
        if (properties || this.unmatchablePropertiesAndGetters.length > 0 || this.unknownIntegerProps.length && INTEGER_REG_EXP.test(key)) {
          return UNKNOWN_EXPRESSION;
        }
        return null;
      }
      getMemberExpressionAndTrackDeopt(key, origin) {
        if (typeof key !== "string") {
          return UNKNOWN_EXPRESSION;
        }
        const expression = this.getMemberExpression(key);
        if (!(expression === UNKNOWN_EXPRESSION || this.immutable)) {
          const expressionsToBeDeoptimized = this.expressionsToBeDeoptimizedByKey[key] = this.expressionsToBeDeoptimizedByKey[key] || [];
          expressionsToBeDeoptimized.push(origin);
        }
        return expression;
      }
    };
    ObjectMember = class extends ExpressionEntity {
      constructor(object, key) {
        super();
        this.object = object;
        this.key = key;
      }
      deoptimizePath(path6) {
        this.object.deoptimizePath([this.key, ...path6]);
      }
      deoptimizeThisOnEventAtPath(event, path6, thisParameter, recursionTracker) {
        this.object.deoptimizeThisOnEventAtPath(event, [this.key, ...path6], thisParameter, recursionTracker);
      }
      getLiteralValueAtPath(path6, recursionTracker, origin) {
        return this.object.getLiteralValueAtPath([this.key, ...path6], recursionTracker, origin);
      }
      getReturnExpressionWhenCalledAtPath(path6, callOptions, recursionTracker, origin) {
        return this.object.getReturnExpressionWhenCalledAtPath([this.key, ...path6], callOptions, recursionTracker, origin);
      }
      hasEffectsWhenAccessedAtPath(path6, context) {
        if (path6.length === 0)
          return false;
        return this.object.hasEffectsWhenAccessedAtPath([this.key, ...path6], context);
      }
      hasEffectsWhenAssignedAtPath(path6, context) {
        return this.object.hasEffectsWhenAssignedAtPath([this.key, ...path6], context);
      }
      hasEffectsWhenCalledAtPath(path6, callOptions, context) {
        return this.object.hasEffectsWhenCalledAtPath([this.key, ...path6], callOptions, context);
      }
    };
    Method = class extends ExpressionEntity {
      constructor(description) {
        super();
        this.description = description;
      }
      deoptimizeThisOnEventAtPath(event, path6, thisParameter) {
        if (event === EVENT_CALLED && path6.length === 0 && this.description.mutatesSelfAsArray) {
          thisParameter.deoptimizePath(UNKNOWN_INTEGER_PATH);
        }
      }
      getReturnExpressionWhenCalledAtPath(path6, callOptions) {
        if (path6.length > 0) {
          return UNKNOWN_EXPRESSION;
        }
        return this.description.returnsPrimitive || (this.description.returns === "self" ? callOptions.thisParam || UNKNOWN_EXPRESSION : this.description.returns());
      }
      hasEffectsWhenAccessedAtPath(path6) {
        return path6.length > 1;
      }
      hasEffectsWhenAssignedAtPath(path6) {
        return path6.length > 0;
      }
      hasEffectsWhenCalledAtPath(path6, callOptions, context) {
        var _a, _b;
        if (path6.length > 0 || this.description.mutatesSelfAsArray === true && ((_a = callOptions.thisParam) === null || _a === void 0 ? void 0 : _a.hasEffectsWhenAssignedAtPath(UNKNOWN_INTEGER_PATH, context))) {
          return true;
        }
        if (!this.description.callsArgs) {
          return false;
        }
        for (const argIndex of this.description.callsArgs) {
          if ((_b = callOptions.args[argIndex]) === null || _b === void 0 ? void 0 : _b.hasEffectsWhenCalledAtPath(EMPTY_PATH, {
            args: NO_ARGS,
            thisParam: null,
            withNew: false
          }, context)) {
            return true;
          }
        }
        return false;
      }
      includeCallArguments(context, args) {
        for (const arg of args) {
          arg.include(context, false);
        }
      }
    };
    METHOD_RETURNS_BOOLEAN = [
      new Method({
        callsArgs: null,
        mutatesSelfAsArray: false,
        returns: null,
        returnsPrimitive: UNKNOWN_LITERAL_BOOLEAN
      })
    ];
    METHOD_RETURNS_STRING = [
      new Method({
        callsArgs: null,
        mutatesSelfAsArray: false,
        returns: null,
        returnsPrimitive: UNKNOWN_LITERAL_STRING
      })
    ];
    METHOD_RETURNS_NUMBER = [
      new Method({
        callsArgs: null,
        mutatesSelfAsArray: false,
        returns: null,
        returnsPrimitive: UNKNOWN_LITERAL_NUMBER
      })
    ];
    METHOD_RETURNS_UNKNOWN = [
      new Method({
        callsArgs: null,
        mutatesSelfAsArray: false,
        returns: null,
        returnsPrimitive: UNKNOWN_EXPRESSION
      })
    ];
    OBJECT_PROTOTYPE = new ObjectEntity({
      __proto__: null,
      hasOwnProperty: METHOD_RETURNS_BOOLEAN,
      isPrototypeOf: METHOD_RETURNS_BOOLEAN,
      propertyIsEnumerable: METHOD_RETURNS_BOOLEAN,
      toLocaleString: METHOD_RETURNS_STRING,
      toString: METHOD_RETURNS_STRING,
      valueOf: METHOD_RETURNS_UNKNOWN
    }, null, true);
    ClassNode = class extends NodeBase {
      constructor() {
        super(...arguments);
        this.objectEntity = null;
      }
      createScope(parentScope) {
        this.scope = new ChildScope(parentScope);
      }
      deoptimizeCache() {
        this.getObjectEntity().deoptimizeAllProperties();
      }
      deoptimizePath(path6) {
        this.getObjectEntity().deoptimizePath(path6);
      }
      deoptimizeThisOnEventAtPath(event, path6, thisParameter, recursionTracker) {
        this.getObjectEntity().deoptimizeThisOnEventAtPath(event, path6, thisParameter, recursionTracker);
      }
      getLiteralValueAtPath(path6, recursionTracker, origin) {
        return this.getObjectEntity().getLiteralValueAtPath(path6, recursionTracker, origin);
      }
      getReturnExpressionWhenCalledAtPath(path6, callOptions, recursionTracker, origin) {
        return this.getObjectEntity().getReturnExpressionWhenCalledAtPath(path6, callOptions, recursionTracker, origin);
      }
      hasEffects(context) {
        var _a, _b;
        const initEffect = ((_a = this.superClass) === null || _a === void 0 ? void 0 : _a.hasEffects(context)) || this.body.hasEffects(context);
        (_b = this.id) === null || _b === void 0 ? void 0 : _b.markDeclarationReached();
        return initEffect || super.hasEffects(context);
      }
      hasEffectsWhenAccessedAtPath(path6, context) {
        return this.getObjectEntity().hasEffectsWhenAccessedAtPath(path6, context);
      }
      hasEffectsWhenAssignedAtPath(path6, context) {
        return this.getObjectEntity().hasEffectsWhenAssignedAtPath(path6, context);
      }
      hasEffectsWhenCalledAtPath(path6, callOptions, context) {
        if (path6.length === 0) {
          return !callOptions.withNew || (this.classConstructor !== null ? this.classConstructor.hasEffectsWhenCalledAtPath(EMPTY_PATH, callOptions, context) : this.superClass !== null && this.superClass.hasEffectsWhenCalledAtPath(path6, callOptions, context));
        } else {
          return this.getObjectEntity().hasEffectsWhenCalledAtPath(path6, callOptions, context);
        }
      }
      include(context, includeChildrenRecursively) {
        var _a;
        this.included = true;
        (_a = this.superClass) === null || _a === void 0 ? void 0 : _a.include(context, includeChildrenRecursively);
        this.body.include(context, includeChildrenRecursively);
        if (this.id) {
          this.id.markDeclarationReached();
          this.id.include();
        }
      }
      initialise() {
        var _a;
        (_a = this.id) === null || _a === void 0 ? void 0 : _a.declare("class", this);
        for (const method of this.body.body) {
          if (method instanceof MethodDefinition && method.kind === "constructor") {
            this.classConstructor = method;
            return;
          }
        }
        this.classConstructor = null;
      }
      getObjectEntity() {
        if (this.objectEntity !== null) {
          return this.objectEntity;
        }
        const staticProperties = [];
        const dynamicMethods = [];
        for (const definition of this.body.body) {
          const properties = definition.static ? staticProperties : dynamicMethods;
          const definitionKind = definition.kind;
          if (properties === dynamicMethods && !definitionKind)
            continue;
          const kind = definitionKind === "set" || definitionKind === "get" ? definitionKind : "init";
          let key;
          if (definition.computed) {
            const keyValue = definition.key.getLiteralValueAtPath(EMPTY_PATH, SHARED_RECURSION_TRACKER, this);
            if (keyValue === UnknownValue) {
              properties.push({ key: UnknownKey, kind, property: definition });
              continue;
            } else {
              key = String(keyValue);
            }
          } else {
            key = definition.key instanceof Identifier ? definition.key.name : String(definition.key.value);
          }
          properties.push({ key, kind, property: definition });
        }
        staticProperties.unshift({
          key: "prototype",
          kind: "init",
          property: new ObjectEntity(dynamicMethods, this.superClass ? new ObjectMember(this.superClass, "prototype") : OBJECT_PROTOTYPE)
        });
        return this.objectEntity = new ObjectEntity(staticProperties, this.superClass || OBJECT_PROTOTYPE);
      }
    };
    ClassDeclaration = class extends ClassNode {
      initialise() {
        super.initialise();
        if (this.id !== null) {
          this.id.variable.isId = true;
        }
      }
      parseNode(esTreeNode) {
        if (esTreeNode.id !== null) {
          this.id = new this.context.nodeConstructors.Identifier(esTreeNode.id, this, this.scope.parent);
        }
        super.parseNode(esTreeNode);
      }
      render(code, options) {
        if (options.format === "system" && this.id && options.exportNamesByVariable.has(this.id.variable)) {
          code.appendLeft(this.end, `${options.compact ? "" : " "}${getSystemExportStatement([this.id.variable], options)};`);
        }
        super.render(code, options);
      }
    };
    ArgumentsVariable = class extends LocalVariable {
      constructor(context) {
        super("arguments", null, UNKNOWN_EXPRESSION, context);
      }
      hasEffectsWhenAccessedAtPath(path6) {
        return path6.length > 1;
      }
      hasEffectsWhenAssignedAtPath() {
        return true;
      }
      hasEffectsWhenCalledAtPath() {
        return true;
      }
    };
    ThisVariable = class extends LocalVariable {
      constructor(context) {
        super("this", null, null, context);
        this.deoptimizedPaths = [];
        this.entitiesToBeDeoptimized = /* @__PURE__ */ new Set();
        this.thisDeoptimizationList = [];
        this.thisDeoptimizations = new DiscriminatedPathTracker();
      }
      addEntityToBeDeoptimized(entity) {
        for (const path6 of this.deoptimizedPaths) {
          entity.deoptimizePath(path6);
        }
        for (const thisDeoptimization of this.thisDeoptimizationList) {
          this.applyThisDeoptimizationEvent(entity, thisDeoptimization);
        }
        this.entitiesToBeDeoptimized.add(entity);
      }
      deoptimizePath(path6) {
        if (path6.length === 0 || this.deoptimizationTracker.trackEntityAtPathAndGetIfTracked(path6, this)) {
          return;
        }
        this.deoptimizedPaths.push(path6);
        for (const entity of this.entitiesToBeDeoptimized) {
          entity.deoptimizePath(path6);
        }
      }
      deoptimizeThisOnEventAtPath(event, path6, thisParameter) {
        const thisDeoptimization = {
          event,
          path: path6,
          thisParameter
        };
        if (!this.thisDeoptimizations.trackEntityAtPathAndGetIfTracked(path6, event, thisParameter)) {
          for (const entity of this.entitiesToBeDeoptimized) {
            this.applyThisDeoptimizationEvent(entity, thisDeoptimization);
          }
          this.thisDeoptimizationList.push(thisDeoptimization);
        }
      }
      hasEffectsWhenAccessedAtPath(path6, context) {
        return this.getInit(context).hasEffectsWhenAccessedAtPath(path6, context) || super.hasEffectsWhenAccessedAtPath(path6, context);
      }
      hasEffectsWhenAssignedAtPath(path6, context) {
        return this.getInit(context).hasEffectsWhenAssignedAtPath(path6, context) || super.hasEffectsWhenAssignedAtPath(path6, context);
      }
      applyThisDeoptimizationEvent(entity, { event, path: path6, thisParameter }) {
        entity.deoptimizeThisOnEventAtPath(event, path6, thisParameter === this ? entity : thisParameter, SHARED_RECURSION_TRACKER);
      }
      getInit(context) {
        return context.replacedVariableInits.get(this) || UNKNOWN_EXPRESSION;
      }
    };
    SpreadElement = class extends NodeBase {
      constructor() {
        super(...arguments);
        this.deoptimized = false;
      }
      deoptimizeThisOnEventAtPath(event, path6, thisParameter, recursionTracker) {
        if (path6.length > 0) {
          this.argument.deoptimizeThisOnEventAtPath(event, [UnknownKey, ...path6], thisParameter, recursionTracker);
        }
      }
      hasEffects(context) {
        if (!this.deoptimized)
          this.applyDeoptimizations();
        const { propertyReadSideEffects } = this.context.options.treeshake;
        return this.argument.hasEffects(context) || propertyReadSideEffects && (propertyReadSideEffects === "always" || this.argument.hasEffectsWhenAccessedAtPath(UNKNOWN_PATH, context));
      }
      applyDeoptimizations() {
        this.deoptimized = true;
        this.argument.deoptimizePath([UnknownKey, UnknownKey]);
        this.context.requestTreeshakingPass();
      }
    };
    ParameterScope = class extends ChildScope {
      constructor(parent, context) {
        super(parent);
        this.parameters = [];
        this.hasRest = false;
        this.context = context;
        this.hoistedBodyVarScope = new ChildScope(this);
      }
      /**
       * Adds a parameter to this scope. Parameters must be added in the correct
       * order, e.g. from left to right.
       */
      addParameterDeclaration(identifier) {
        const name = identifier.name;
        let variable = this.hoistedBodyVarScope.variables.get(name);
        if (variable) {
          variable.addDeclaration(identifier, null);
        } else {
          variable = new LocalVariable(name, identifier, UNKNOWN_EXPRESSION, this.context);
        }
        this.variables.set(name, variable);
        return variable;
      }
      addParameterVariables(parameters, hasRest) {
        this.parameters = parameters;
        for (const parameterList of parameters) {
          for (const parameter of parameterList) {
            parameter.alwaysRendered = true;
          }
        }
        this.hasRest = hasRest;
      }
      includeCallArguments(context, args) {
        let calledFromTryStatement = false;
        let argIncluded = false;
        const restParam = this.hasRest && this.parameters[this.parameters.length - 1];
        for (const checkedArg of args) {
          if (checkedArg instanceof SpreadElement) {
            for (const arg of args) {
              arg.include(context, false);
            }
            break;
          }
        }
        for (let index2 = args.length - 1; index2 >= 0; index2--) {
          const paramVars = this.parameters[index2] || restParam;
          const arg = args[index2];
          if (paramVars) {
            calledFromTryStatement = false;
            if (paramVars.length === 0) {
              argIncluded = true;
            } else {
              for (const variable of paramVars) {
                if (variable.included) {
                  argIncluded = true;
                }
                if (variable.calledFromTryStatement) {
                  calledFromTryStatement = true;
                }
              }
            }
          }
          if (!argIncluded && arg.shouldBeIncluded(context)) {
            argIncluded = true;
          }
          if (argIncluded) {
            arg.include(context, calledFromTryStatement);
          }
        }
      }
    };
    ReturnValueScope = class extends ParameterScope {
      constructor() {
        super(...arguments);
        this.returnExpression = null;
        this.returnExpressions = [];
      }
      addReturnExpression(expression) {
        this.returnExpressions.push(expression);
      }
      getReturnExpression() {
        if (this.returnExpression === null)
          this.updateReturnExpression();
        return this.returnExpression;
      }
      updateReturnExpression() {
        if (this.returnExpressions.length === 1) {
          this.returnExpression = this.returnExpressions[0];
        } else {
          this.returnExpression = UNKNOWN_EXPRESSION;
          for (const expression of this.returnExpressions) {
            expression.deoptimizePath(UNKNOWN_PATH);
          }
        }
      }
    };
    FunctionScope = class extends ReturnValueScope {
      constructor(parent, context) {
        super(parent, context);
        this.variables.set("arguments", this.argumentsVariable = new ArgumentsVariable(context));
        this.variables.set("this", this.thisVariable = new ThisVariable(context));
      }
      findLexicalBoundary() {
        return this;
      }
      includeCallArguments(context, args) {
        super.includeCallArguments(context, args);
        if (this.argumentsVariable.included) {
          for (const arg of args) {
            if (!arg.included) {
              arg.include(context, false);
            }
          }
        }
      }
    };
    RestElement = class extends NodeBase {
      constructor() {
        super(...arguments);
        this.deoptimized = false;
        this.declarationInit = null;
      }
      addExportedVariables(variables, exportNamesByVariable) {
        this.argument.addExportedVariables(variables, exportNamesByVariable);
      }
      declare(kind, init) {
        this.declarationInit = init;
        return this.argument.declare(kind, UNKNOWN_EXPRESSION);
      }
      deoptimizePath(path6) {
        path6.length === 0 && this.argument.deoptimizePath(EMPTY_PATH);
      }
      hasEffectsWhenAssignedAtPath(path6, context) {
        return path6.length > 0 || this.argument.hasEffectsWhenAssignedAtPath(EMPTY_PATH, context);
      }
      markDeclarationReached() {
        this.argument.markDeclarationReached();
      }
      applyDeoptimizations() {
        this.deoptimized = true;
        if (this.declarationInit !== null) {
          this.declarationInit.deoptimizePath([UnknownKey, UnknownKey]);
          this.context.requestTreeshakingPass();
        }
      }
    };
    FunctionNode = class extends NodeBase {
      constructor() {
        super(...arguments);
        this.deoptimizedReturn = false;
        this.isPrototypeDeoptimized = false;
      }
      createScope(parentScope) {
        this.scope = new FunctionScope(parentScope, this.context);
      }
      deoptimizePath(path6) {
        if (path6.length === 1) {
          if (path6[0] === "prototype") {
            this.isPrototypeDeoptimized = true;
          } else if (path6[0] === UnknownKey) {
            this.isPrototypeDeoptimized = true;
            this.scope.getReturnExpression().deoptimizePath(UNKNOWN_PATH);
          }
        }
      }
      // TODO for completeness, we should also track other events here
      deoptimizeThisOnEventAtPath(event, path6, thisParameter) {
        if (event === EVENT_CALLED) {
          if (path6.length > 0) {
            thisParameter.deoptimizePath(UNKNOWN_PATH);
          } else {
            this.scope.thisVariable.addEntityToBeDeoptimized(thisParameter);
          }
        }
      }
      getReturnExpressionWhenCalledAtPath(path6) {
        if (path6.length !== 0) {
          return UNKNOWN_EXPRESSION;
        }
        if (this.async) {
          if (!this.deoptimizedReturn) {
            this.deoptimizedReturn = true;
            this.scope.getReturnExpression().deoptimizePath(UNKNOWN_PATH);
            this.context.requestTreeshakingPass();
          }
          return UNKNOWN_EXPRESSION;
        }
        return this.scope.getReturnExpression();
      }
      hasEffects() {
        return this.id !== null && this.id.hasEffects();
      }
      hasEffectsWhenAccessedAtPath(path6) {
        if (path6.length <= 1)
          return false;
        return path6.length > 2 || path6[0] !== "prototype" || this.isPrototypeDeoptimized;
      }
      hasEffectsWhenAssignedAtPath(path6) {
        if (path6.length <= 1) {
          return false;
        }
        return path6.length > 2 || path6[0] !== "prototype" || this.isPrototypeDeoptimized;
      }
      hasEffectsWhenCalledAtPath(path6, callOptions, context) {
        if (path6.length > 0)
          return true;
        if (this.async) {
          const { propertyReadSideEffects } = this.context.options.treeshake;
          const returnExpression = this.scope.getReturnExpression();
          if (returnExpression.hasEffectsWhenCalledAtPath(["then"], { args: NO_ARGS, thisParam: null, withNew: false }, context) || propertyReadSideEffects && (propertyReadSideEffects === "always" || returnExpression.hasEffectsWhenAccessedAtPath(["then"], context))) {
            return true;
          }
        }
        for (const param of this.params) {
          if (param.hasEffects(context))
            return true;
        }
        const thisInit = context.replacedVariableInits.get(this.scope.thisVariable);
        context.replacedVariableInits.set(this.scope.thisVariable, callOptions.withNew ? new ObjectEntity(/* @__PURE__ */ Object.create(null), OBJECT_PROTOTYPE) : UNKNOWN_EXPRESSION);
        const { brokenFlow, ignore: ignore2 } = context;
        context.ignore = {
          breaks: false,
          continues: false,
          labels: /* @__PURE__ */ new Set(),
          returnYield: true
        };
        if (this.body.hasEffects(context))
          return true;
        context.brokenFlow = brokenFlow;
        if (thisInit) {
          context.replacedVariableInits.set(this.scope.thisVariable, thisInit);
        } else {
          context.replacedVariableInits.delete(this.scope.thisVariable);
        }
        context.ignore = ignore2;
        return false;
      }
      include(context, includeChildrenRecursively) {
        this.included = true;
        if (this.id)
          this.id.include();
        const hasArguments = this.scope.argumentsVariable.included;
        for (const param of this.params) {
          if (!(param instanceof Identifier) || hasArguments) {
            param.include(context, includeChildrenRecursively);
          }
        }
        const { brokenFlow } = context;
        context.brokenFlow = BROKEN_FLOW_NONE;
        this.body.include(context, includeChildrenRecursively);
        context.brokenFlow = brokenFlow;
      }
      includeCallArguments(context, args) {
        this.scope.includeCallArguments(context, args);
      }
      initialise() {
        if (this.id !== null) {
          this.id.declare("function", this);
        }
        this.scope.addParameterVariables(this.params.map((param) => param.declare("parameter", UNKNOWN_EXPRESSION)), this.params[this.params.length - 1] instanceof RestElement);
        this.body.addImplicitReturnExpressionToScope();
      }
      parseNode(esTreeNode) {
        this.body = new this.context.nodeConstructors.BlockStatement(esTreeNode.body, this, this.scope.hoistedBodyVarScope);
        super.parseNode(esTreeNode);
      }
    };
    FunctionNode.prototype.preventChildBlockScope = true;
    FunctionDeclaration = class extends FunctionNode {
      initialise() {
        super.initialise();
        if (this.id !== null) {
          this.id.variable.isId = true;
        }
      }
      parseNode(esTreeNode) {
        if (esTreeNode.id !== null) {
          this.id = new this.context.nodeConstructors.Identifier(esTreeNode.id, this, this.scope.parent);
        }
        super.parseNode(esTreeNode);
      }
    };
    ExportDefaultDeclaration = class extends NodeBase {
      include(context, includeChildrenRecursively) {
        super.include(context, includeChildrenRecursively);
        if (includeChildrenRecursively) {
          this.context.includeVariableInModule(this.variable);
        }
      }
      initialise() {
        const declaration = this.declaration;
        this.declarationName = declaration.id && declaration.id.name || this.declaration.name;
        this.variable = this.scope.addExportDefaultDeclaration(this.declarationName || this.context.getModuleName(), this, this.context);
        this.context.addExport(this);
      }
      render(code, options, nodeRenderOptions) {
        const { start, end } = nodeRenderOptions;
        const declarationStart = getDeclarationStart(code.original, this.start);
        if (this.declaration instanceof FunctionDeclaration) {
          this.renderNamedDeclaration(code, declarationStart, "function", "(", this.declaration.id === null, options);
        } else if (this.declaration instanceof ClassDeclaration) {
          this.renderNamedDeclaration(code, declarationStart, "class", "{", this.declaration.id === null, options);
        } else if (this.variable.getOriginalVariable() !== this.variable) {
          treeshakeNode(this, code, start, end);
          return;
        } else if (this.variable.included) {
          this.renderVariableDeclaration(code, declarationStart, options);
        } else {
          code.remove(this.start, declarationStart);
          this.declaration.render(code, options, {
            renderedSurroundingElement: ExpressionStatement$1
          });
          if (code.original[this.end - 1] !== ";") {
            code.appendLeft(this.end, ";");
          }
          return;
        }
        this.declaration.render(code, options);
      }
      renderNamedDeclaration(code, declarationStart, declarationKeyword, endMarker, needsId, options) {
        const name = this.variable.getName();
        code.remove(this.start, declarationStart);
        if (needsId) {
          code.appendLeft(getIdInsertPosition(code.original, declarationKeyword, endMarker, declarationStart), ` ${name}`);
        }
        if (options.format === "system" && this.declaration instanceof ClassDeclaration && options.exportNamesByVariable.has(this.variable)) {
          code.appendLeft(this.end, ` ${getSystemExportStatement([this.variable], options)};`);
        }
      }
      renderVariableDeclaration(code, declarationStart, options) {
        const hasTrailingSemicolon = code.original.charCodeAt(this.end - 1) === 59;
        const systemExportNames = options.format === "system" && options.exportNamesByVariable.get(this.variable);
        if (systemExportNames) {
          code.overwrite(this.start, declarationStart, `${options.varOrConst} ${this.variable.getName()} = exports('${systemExportNames[0]}', `);
          code.appendRight(hasTrailingSemicolon ? this.end - 1 : this.end, ")" + (hasTrailingSemicolon ? "" : ";"));
        } else {
          code.overwrite(this.start, declarationStart, `${options.varOrConst} ${this.variable.getName()} = `);
          if (!hasTrailingSemicolon) {
            code.appendLeft(this.end, ";");
          }
        }
      }
    };
    ExportDefaultDeclaration.prototype.needsBoundaries = true;
    Literal = class extends NodeBase {
      deoptimizeThisOnEventAtPath() {
      }
      getLiteralValueAtPath(path6) {
        if (path6.length > 0 || // unknown literals can also be null but do not start with an "n"
        this.value === null && this.context.code.charCodeAt(this.start) !== 110 || typeof this.value === "bigint" || // to support shims for regular expressions
        this.context.code.charCodeAt(this.start) === 47) {
          return UnknownValue;
        }
        return this.value;
      }
      getReturnExpressionWhenCalledAtPath(path6) {
        if (path6.length !== 1)
          return UNKNOWN_EXPRESSION;
        return getMemberReturnExpressionWhenCalled(this.members, path6[0]);
      }
      hasEffectsWhenAccessedAtPath(path6) {
        if (this.value === null) {
          return path6.length > 0;
        }
        return path6.length > 1;
      }
      hasEffectsWhenAssignedAtPath(path6) {
        return path6.length > 0;
      }
      hasEffectsWhenCalledAtPath(path6, callOptions, context) {
        if (path6.length === 1) {
          return hasMemberEffectWhenCalled(this.members, path6[0], callOptions, context);
        }
        return true;
      }
      initialise() {
        this.members = getLiteralMembersForValue(this.value);
      }
      parseNode(esTreeNode) {
        this.value = esTreeNode.value;
        this.regex = esTreeNode.regex;
        super.parseNode(esTreeNode);
      }
      render(code) {
        if (typeof this.value === "string") {
          code.indentExclusionRanges.push([this.start + 1, this.end - 1]);
        }
      }
    };
    Program = class extends NodeBase {
      constructor() {
        super(...arguments);
        this.hasCachedEffect = false;
      }
      hasEffects(context) {
        if (this.hasCachedEffect)
          return true;
        for (const node of this.body) {
          if (node.hasEffects(context)) {
            return this.hasCachedEffect = true;
          }
        }
        return false;
      }
      include(context, includeChildrenRecursively) {
        this.included = true;
        for (const node of this.body) {
          if (includeChildrenRecursively || node.shouldBeIncluded(context)) {
            node.include(context, includeChildrenRecursively);
          }
        }
      }
      render(code, options) {
        if (this.body.length) {
          renderStatementList(this.body, code, this.start, this.end, options);
        } else {
          super.render(code, options);
        }
      }
    };
    TemplateLiteral = class extends NodeBase {
      getLiteralValueAtPath(path6) {
        if (path6.length > 0 || this.quasis.length !== 1) {
          return UnknownValue;
        }
        return this.quasis[0].value.cooked;
      }
      render(code, options) {
        code.indentExclusionRanges.push([this.start, this.end]);
        super.render(code, options);
      }
    };
    VariableDeclaration = class extends NodeBase {
      deoptimizePath() {
        for (const declarator of this.declarations) {
          declarator.deoptimizePath(EMPTY_PATH);
        }
      }
      hasEffectsWhenAssignedAtPath() {
        return false;
      }
      include(context, includeChildrenRecursively) {
        this.included = true;
        for (const declarator of this.declarations) {
          if (includeChildrenRecursively || declarator.shouldBeIncluded(context))
            declarator.include(context, includeChildrenRecursively);
        }
      }
      includeAsSingleStatement(context, includeChildrenRecursively) {
        this.included = true;
        for (const declarator of this.declarations) {
          if (includeChildrenRecursively || declarator.shouldBeIncluded(context)) {
            declarator.include(context, includeChildrenRecursively);
            declarator.id.include(context, includeChildrenRecursively);
          }
        }
      }
      initialise() {
        for (const declarator of this.declarations) {
          declarator.declareDeclarator(this.kind);
        }
      }
      render(code, options, nodeRenderOptions = BLANK) {
        if (areAllDeclarationsIncludedAndNotExported(this.declarations, options.exportNamesByVariable)) {
          for (const declarator of this.declarations) {
            declarator.render(code, options);
          }
          if (!nodeRenderOptions.isNoStatement && code.original.charCodeAt(this.end - 1) !== 59) {
            code.appendLeft(this.end, ";");
          }
        } else {
          this.renderReplacedDeclarations(code, options, nodeRenderOptions);
        }
      }
      renderDeclarationEnd(code, separatorString, lastSeparatorPos, actualContentEnd, renderedContentEnd, systemPatternExports, options, isNoStatement) {
        if (code.original.charCodeAt(this.end - 1) === 59) {
          code.remove(this.end - 1, this.end);
        }
        if (!isNoStatement) {
          separatorString += ";";
        }
        if (lastSeparatorPos !== null) {
          if (code.original.charCodeAt(actualContentEnd - 1) === 10 && (code.original.charCodeAt(this.end) === 10 || code.original.charCodeAt(this.end) === 13)) {
            actualContentEnd--;
            if (code.original.charCodeAt(actualContentEnd) === 13) {
              actualContentEnd--;
            }
          }
          if (actualContentEnd === lastSeparatorPos + 1) {
            code.overwrite(lastSeparatorPos, renderedContentEnd, separatorString);
          } else {
            code.overwrite(lastSeparatorPos, lastSeparatorPos + 1, separatorString);
            code.remove(actualContentEnd, renderedContentEnd);
          }
        } else {
          code.appendLeft(renderedContentEnd, separatorString);
        }
        if (systemPatternExports.length > 0) {
          code.appendLeft(renderedContentEnd, ` ${getSystemExportStatement(systemPatternExports, options)};`);
        }
      }
      renderReplacedDeclarations(code, options, { isNoStatement }) {
        const separatedNodes = getCommaSeparatedNodesWithBoundaries(this.declarations, code, this.start + this.kind.length, this.end - (code.original.charCodeAt(this.end - 1) === 59 ? 1 : 0));
        let actualContentEnd, renderedContentEnd;
        renderedContentEnd = findNonWhiteSpace(code.original, this.start + this.kind.length);
        let lastSeparatorPos = renderedContentEnd - 1;
        code.remove(this.start, lastSeparatorPos);
        let isInDeclaration = false;
        let hasRenderedContent = false;
        let separatorString = "", leadingString, nextSeparatorString;
        const aggregatedSystemExports = [];
        const singleSystemExport = gatherSystemExportsAndGetSingleExport(separatedNodes, options, aggregatedSystemExports);
        for (const { node, start, separator, contentEnd, end } of separatedNodes) {
          if (!node.included) {
            code.remove(start, end);
            continue;
          }
          node.render(code, options);
          leadingString = "";
          nextSeparatorString = "";
          if (!node.id.included || node.id instanceof Identifier && isReassignedExportsMember(node.id.variable, options.exportNamesByVariable)) {
            if (hasRenderedContent) {
              separatorString += ";";
            }
            isInDeclaration = false;
          } else {
            if (singleSystemExport && singleSystemExport === node.id.variable) {
              const operatorPos = findFirstOccurrenceOutsideComment(code.original, "=", node.id.end);
              renderSystemExportExpression(singleSystemExport, findNonWhiteSpace(code.original, operatorPos + 1), separator === null ? contentEnd : separator, code, options);
            }
            if (isInDeclaration) {
              separatorString += ",";
            } else {
              if (hasRenderedContent) {
                separatorString += ";";
              }
              leadingString += `${this.kind} `;
              isInDeclaration = true;
            }
          }
          if (renderedContentEnd === lastSeparatorPos + 1) {
            code.overwrite(lastSeparatorPos, renderedContentEnd, separatorString + leadingString);
          } else {
            code.overwrite(lastSeparatorPos, lastSeparatorPos + 1, separatorString);
            code.appendLeft(renderedContentEnd, leadingString);
          }
          actualContentEnd = contentEnd;
          renderedContentEnd = end;
          hasRenderedContent = true;
          lastSeparatorPos = separator;
          separatorString = nextSeparatorString;
        }
        this.renderDeclarationEnd(code, separatorString, lastSeparatorPos, actualContentEnd, renderedContentEnd, aggregatedSystemExports, options, isNoStatement);
      }
    };
    NEW_ARRAY_PROPERTIES = [
      { key: UnknownInteger, kind: "init", property: UNKNOWN_EXPRESSION },
      { key: "length", kind: "init", property: UNKNOWN_LITERAL_NUMBER }
    ];
    METHOD_CALLS_ARG_DEOPTS_SELF_RETURNS_BOOLEAN = [
      new Method({
        callsArgs: [0],
        mutatesSelfAsArray: "deopt-only",
        returns: null,
        returnsPrimitive: UNKNOWN_LITERAL_BOOLEAN
      })
    ];
    METHOD_CALLS_ARG_DEOPTS_SELF_RETURNS_NUMBER = [
      new Method({
        callsArgs: [0],
        mutatesSelfAsArray: "deopt-only",
        returns: null,
        returnsPrimitive: UNKNOWN_LITERAL_NUMBER
      })
    ];
    METHOD_MUTATES_SELF_RETURNS_NEW_ARRAY = [
      new Method({
        callsArgs: null,
        mutatesSelfAsArray: true,
        returns: () => new ObjectEntity(NEW_ARRAY_PROPERTIES, ARRAY_PROTOTYPE),
        returnsPrimitive: null
      })
    ];
    METHOD_DEOPTS_SELF_RETURNS_NEW_ARRAY = [
      new Method({
        callsArgs: null,
        mutatesSelfAsArray: "deopt-only",
        returns: () => new ObjectEntity(NEW_ARRAY_PROPERTIES, ARRAY_PROTOTYPE),
        returnsPrimitive: null
      })
    ];
    METHOD_CALLS_ARG_DEOPTS_SELF_RETURNS_NEW_ARRAY = [
      new Method({
        callsArgs: [0],
        mutatesSelfAsArray: "deopt-only",
        returns: () => new ObjectEntity(NEW_ARRAY_PROPERTIES, ARRAY_PROTOTYPE),
        returnsPrimitive: null
      })
    ];
    METHOD_MUTATES_SELF_RETURNS_NUMBER = [
      new Method({
        callsArgs: null,
        mutatesSelfAsArray: true,
        returns: null,
        returnsPrimitive: UNKNOWN_LITERAL_NUMBER
      })
    ];
    METHOD_MUTATES_SELF_RETURNS_UNKNOWN = [
      new Method({
        callsArgs: null,
        mutatesSelfAsArray: true,
        returns: null,
        returnsPrimitive: UNKNOWN_EXPRESSION
      })
    ];
    METHOD_DEOPTS_SELF_RETURNS_UNKNOWN = [
      new Method({
        callsArgs: null,
        mutatesSelfAsArray: "deopt-only",
        returns: null,
        returnsPrimitive: UNKNOWN_EXPRESSION
      })
    ];
    METHOD_CALLS_ARG_DEOPTS_SELF_RETURNS_UNKNOWN = [
      new Method({
        callsArgs: [0],
        mutatesSelfAsArray: "deopt-only",
        returns: null,
        returnsPrimitive: UNKNOWN_EXPRESSION
      })
    ];
    METHOD_MUTATES_SELF_RETURNS_SELF = [
      new Method({
        callsArgs: null,
        mutatesSelfAsArray: true,
        returns: "self",
        returnsPrimitive: null
      })
    ];
    METHOD_CALLS_ARG_MUTATES_SELF_RETURNS_SELF = [
      new Method({
        callsArgs: [0],
        mutatesSelfAsArray: true,
        returns: "self",
        returnsPrimitive: null
      })
    ];
    ARRAY_PROTOTYPE = new ObjectEntity({
      __proto__: null,
      // We assume that accessors have effects as we do not track the accessed value afterwards
      at: METHOD_DEOPTS_SELF_RETURNS_UNKNOWN,
      concat: METHOD_DEOPTS_SELF_RETURNS_NEW_ARRAY,
      copyWithin: METHOD_MUTATES_SELF_RETURNS_SELF,
      entries: METHOD_DEOPTS_SELF_RETURNS_NEW_ARRAY,
      every: METHOD_CALLS_ARG_DEOPTS_SELF_RETURNS_BOOLEAN,
      fill: METHOD_MUTATES_SELF_RETURNS_SELF,
      filter: METHOD_CALLS_ARG_DEOPTS_SELF_RETURNS_NEW_ARRAY,
      find: METHOD_CALLS_ARG_DEOPTS_SELF_RETURNS_UNKNOWN,
      findIndex: METHOD_CALLS_ARG_DEOPTS_SELF_RETURNS_NUMBER,
      forEach: METHOD_CALLS_ARG_DEOPTS_SELF_RETURNS_UNKNOWN,
      includes: METHOD_RETURNS_BOOLEAN,
      indexOf: METHOD_RETURNS_NUMBER,
      join: METHOD_RETURNS_STRING,
      keys: METHOD_RETURNS_UNKNOWN,
      lastIndexOf: METHOD_RETURNS_NUMBER,
      map: METHOD_CALLS_ARG_DEOPTS_SELF_RETURNS_NEW_ARRAY,
      pop: METHOD_MUTATES_SELF_RETURNS_UNKNOWN,
      push: METHOD_MUTATES_SELF_RETURNS_NUMBER,
      reduce: METHOD_CALLS_ARG_DEOPTS_SELF_RETURNS_UNKNOWN,
      reduceRight: METHOD_CALLS_ARG_DEOPTS_SELF_RETURNS_UNKNOWN,
      reverse: METHOD_MUTATES_SELF_RETURNS_SELF,
      shift: METHOD_MUTATES_SELF_RETURNS_UNKNOWN,
      slice: METHOD_DEOPTS_SELF_RETURNS_NEW_ARRAY,
      some: METHOD_CALLS_ARG_DEOPTS_SELF_RETURNS_BOOLEAN,
      sort: METHOD_CALLS_ARG_MUTATES_SELF_RETURNS_SELF,
      splice: METHOD_MUTATES_SELF_RETURNS_NEW_ARRAY,
      unshift: METHOD_MUTATES_SELF_RETURNS_NUMBER,
      values: METHOD_DEOPTS_SELF_RETURNS_UNKNOWN
    }, OBJECT_PROTOTYPE, true);
    ArrayExpression = class extends NodeBase {
      constructor() {
        super(...arguments);
        this.objectEntity = null;
      }
      deoptimizePath(path6) {
        this.getObjectEntity().deoptimizePath(path6);
      }
      deoptimizeThisOnEventAtPath(event, path6, thisParameter, recursionTracker) {
        this.getObjectEntity().deoptimizeThisOnEventAtPath(event, path6, thisParameter, recursionTracker);
      }
      getLiteralValueAtPath(path6, recursionTracker, origin) {
        return this.getObjectEntity().getLiteralValueAtPath(path6, recursionTracker, origin);
      }
      getReturnExpressionWhenCalledAtPath(path6, callOptions, recursionTracker, origin) {
        return this.getObjectEntity().getReturnExpressionWhenCalledAtPath(path6, callOptions, recursionTracker, origin);
      }
      hasEffectsWhenAccessedAtPath(path6, context) {
        return this.getObjectEntity().hasEffectsWhenAccessedAtPath(path6, context);
      }
      hasEffectsWhenAssignedAtPath(path6, context) {
        return this.getObjectEntity().hasEffectsWhenAssignedAtPath(path6, context);
      }
      hasEffectsWhenCalledAtPath(path6, callOptions, context) {
        return this.getObjectEntity().hasEffectsWhenCalledAtPath(path6, callOptions, context);
      }
      getObjectEntity() {
        if (this.objectEntity !== null) {
          return this.objectEntity;
        }
        const properties = [
          { key: "length", kind: "init", property: UNKNOWN_LITERAL_NUMBER }
        ];
        let hasSpread = false;
        for (let index2 = 0; index2 < this.elements.length; index2++) {
          const element = this.elements[index2];
          if (element instanceof SpreadElement || hasSpread) {
            if (element) {
              hasSpread = true;
              properties.unshift({ key: UnknownInteger, kind: "init", property: element });
            }
          } else if (!element) {
            properties.push({ key: String(index2), kind: "init", property: UNDEFINED_EXPRESSION });
          } else {
            properties.push({ key: String(index2), kind: "init", property: element });
          }
        }
        return this.objectEntity = new ObjectEntity(properties, ARRAY_PROTOTYPE);
      }
    };
    ArrayPattern = class extends NodeBase {
      addExportedVariables(variables, exportNamesByVariable) {
        for (const element of this.elements) {
          if (element !== null) {
            element.addExportedVariables(variables, exportNamesByVariable);
          }
        }
      }
      declare(kind) {
        const variables = [];
        for (const element of this.elements) {
          if (element !== null) {
            variables.push(...element.declare(kind, UNKNOWN_EXPRESSION));
          }
        }
        return variables;
      }
      deoptimizePath(path6) {
        if (path6.length === 0) {
          for (const element of this.elements) {
            if (element !== null) {
              element.deoptimizePath(path6);
            }
          }
        }
      }
      hasEffectsWhenAssignedAtPath(path6, context) {
        if (path6.length > 0)
          return true;
        for (const element of this.elements) {
          if (element !== null && element.hasEffectsWhenAssignedAtPath(EMPTY_PATH, context))
            return true;
        }
        return false;
      }
      markDeclarationReached() {
        for (const element of this.elements) {
          if (element !== null) {
            element.markDeclarationReached();
          }
        }
      }
    };
    BlockScope = class extends ChildScope {
      addDeclaration(identifier, context, init, isHoisted) {
        if (isHoisted) {
          const variable = this.parent.addDeclaration(identifier, context, init, isHoisted);
          variable.markInitializersForDeoptimization();
          return variable;
        } else {
          return super.addDeclaration(identifier, context, init, false);
        }
      }
    };
    ExpressionStatement = class extends NodeBase {
      initialise() {
        if (this.directive && this.directive !== "use strict" && this.parent.type === Program$1) {
          this.context.warn(
            // This is necessary, because either way (deleting or not) can lead to errors.
            {
              code: "MODULE_LEVEL_DIRECTIVE",
              message: `Module level directives cause errors when bundled, '${this.directive}' was ignored.`
            },
            this.start
          );
        }
      }
      render(code, options) {
        super.render(code, options);
        if (this.included)
          this.insertSemicolon(code);
      }
      shouldBeIncluded(context) {
        if (this.directive && this.directive !== "use strict")
          return this.parent.type !== Program$1;
        return super.shouldBeIncluded(context);
      }
    };
    BlockStatement = class extends NodeBase {
      constructor() {
        super(...arguments);
        this.directlyIncluded = false;
      }
      addImplicitReturnExpressionToScope() {
        const lastStatement = this.body[this.body.length - 1];
        if (!lastStatement || lastStatement.type !== ReturnStatement$1) {
          this.scope.addReturnExpression(UNKNOWN_EXPRESSION);
        }
      }
      createScope(parentScope) {
        this.scope = this.parent.preventChildBlockScope ? parentScope : new BlockScope(parentScope);
      }
      hasEffects(context) {
        if (this.deoptimizeBody)
          return true;
        for (const node of this.body) {
          if (node.hasEffects(context))
            return true;
          if (context.brokenFlow)
            break;
        }
        return false;
      }
      include(context, includeChildrenRecursively) {
        if (!this.deoptimizeBody || !this.directlyIncluded) {
          this.included = true;
          this.directlyIncluded = true;
          if (this.deoptimizeBody)
            includeChildrenRecursively = true;
          for (const node of this.body) {
            if (includeChildrenRecursively || node.shouldBeIncluded(context))
              node.include(context, includeChildrenRecursively);
          }
        }
      }
      initialise() {
        const firstBodyStatement = this.body[0];
        this.deoptimizeBody = firstBodyStatement instanceof ExpressionStatement && firstBodyStatement.directive === "use asm";
      }
      render(code, options) {
        if (this.body.length) {
          renderStatementList(this.body, code, this.start + 1, this.end - 1, options);
        } else {
          super.render(code, options);
        }
      }
    };
    ArrowFunctionExpression = class extends NodeBase {
      constructor() {
        super(...arguments);
        this.deoptimizedReturn = false;
      }
      createScope(parentScope) {
        this.scope = new ReturnValueScope(parentScope, this.context);
      }
      deoptimizePath(path6) {
        if (path6.length === 1 && path6[0] === UnknownKey) {
          this.scope.getReturnExpression().deoptimizePath(UNKNOWN_PATH);
        }
      }
      // Arrow functions do not mutate their context
      deoptimizeThisOnEventAtPath() {
      }
      getReturnExpressionWhenCalledAtPath(path6) {
        if (path6.length !== 0) {
          return UNKNOWN_EXPRESSION;
        }
        if (this.async) {
          if (!this.deoptimizedReturn) {
            this.deoptimizedReturn = true;
            this.scope.getReturnExpression().deoptimizePath(UNKNOWN_PATH);
            this.context.requestTreeshakingPass();
          }
          return UNKNOWN_EXPRESSION;
        }
        return this.scope.getReturnExpression();
      }
      hasEffects() {
        return false;
      }
      hasEffectsWhenAccessedAtPath(path6) {
        return path6.length > 1;
      }
      hasEffectsWhenAssignedAtPath(path6) {
        return path6.length > 1;
      }
      hasEffectsWhenCalledAtPath(path6, _callOptions, context) {
        if (path6.length > 0)
          return true;
        if (this.async) {
          const { propertyReadSideEffects } = this.context.options.treeshake;
          const returnExpression = this.scope.getReturnExpression();
          if (returnExpression.hasEffectsWhenCalledAtPath(["then"], { args: NO_ARGS, thisParam: null, withNew: false }, context) || propertyReadSideEffects && (propertyReadSideEffects === "always" || returnExpression.hasEffectsWhenAccessedAtPath(["then"], context))) {
            return true;
          }
        }
        for (const param of this.params) {
          if (param.hasEffects(context))
            return true;
        }
        const { ignore: ignore2, brokenFlow } = context;
        context.ignore = {
          breaks: false,
          continues: false,
          labels: /* @__PURE__ */ new Set(),
          returnYield: true
        };
        if (this.body.hasEffects(context))
          return true;
        context.ignore = ignore2;
        context.brokenFlow = brokenFlow;
        return false;
      }
      include(context, includeChildrenRecursively) {
        this.included = true;
        for (const param of this.params) {
          if (!(param instanceof Identifier)) {
            param.include(context, includeChildrenRecursively);
          }
        }
        const { brokenFlow } = context;
        context.brokenFlow = BROKEN_FLOW_NONE;
        this.body.include(context, includeChildrenRecursively);
        context.brokenFlow = brokenFlow;
      }
      includeCallArguments(context, args) {
        this.scope.includeCallArguments(context, args);
      }
      initialise() {
        this.scope.addParameterVariables(this.params.map((param) => param.declare("parameter", UNKNOWN_EXPRESSION)), this.params[this.params.length - 1] instanceof RestElement);
        if (this.body instanceof BlockStatement) {
          this.body.addImplicitReturnExpressionToScope();
        } else {
          this.scope.addReturnExpression(this.body);
        }
      }
      parseNode(esTreeNode) {
        if (esTreeNode.body.type === BlockStatement$1) {
          this.body = new this.context.nodeConstructors.BlockStatement(esTreeNode.body, this, this.scope.hoistedBodyVarScope);
        }
        super.parseNode(esTreeNode);
      }
    };
    ArrowFunctionExpression.prototype.preventChildBlockScope = true;
    ObjectPattern = class extends NodeBase {
      addExportedVariables(variables, exportNamesByVariable) {
        for (const property2 of this.properties) {
          if (property2.type === Property$1) {
            property2.value.addExportedVariables(variables, exportNamesByVariable);
          } else {
            property2.argument.addExportedVariables(variables, exportNamesByVariable);
          }
        }
      }
      declare(kind, init) {
        const variables = [];
        for (const property2 of this.properties) {
          variables.push(...property2.declare(kind, init));
        }
        return variables;
      }
      deoptimizePath(path6) {
        if (path6.length === 0) {
          for (const property2 of this.properties) {
            property2.deoptimizePath(path6);
          }
        }
      }
      hasEffectsWhenAssignedAtPath(path6, context) {
        if (path6.length > 0)
          return true;
        for (const property2 of this.properties) {
          if (property2.hasEffectsWhenAssignedAtPath(EMPTY_PATH, context))
            return true;
        }
        return false;
      }
      markDeclarationReached() {
        for (const property2 of this.properties) {
          property2.markDeclarationReached();
        }
      }
    };
    AssignmentExpression = class extends NodeBase {
      constructor() {
        super(...arguments);
        this.deoptimized = false;
      }
      hasEffects(context) {
        if (!this.deoptimized)
          this.applyDeoptimizations();
        return this.right.hasEffects(context) || this.left.hasEffects(context) || this.left.hasEffectsWhenAssignedAtPath(EMPTY_PATH, context);
      }
      hasEffectsWhenAccessedAtPath(path6, context) {
        return path6.length > 0 && this.right.hasEffectsWhenAccessedAtPath(path6, context);
      }
      include(context, includeChildrenRecursively) {
        if (!this.deoptimized)
          this.applyDeoptimizations();
        this.included = true;
        let hasEffectsContext;
        if (includeChildrenRecursively || this.operator !== "=" || this.left.included || (hasEffectsContext = createHasEffectsContext(), this.left.hasEffects(hasEffectsContext) || this.left.hasEffectsWhenAssignedAtPath(EMPTY_PATH, hasEffectsContext))) {
          this.left.include(context, includeChildrenRecursively);
        }
        this.right.include(context, includeChildrenRecursively);
      }
      render(code, options, { preventASI, renderedParentType, renderedSurroundingElement } = BLANK) {
        if (this.left.included) {
          this.left.render(code, options);
          this.right.render(code, options);
        } else {
          const inclusionStart = findNonWhiteSpace(code.original, findFirstOccurrenceOutsideComment(code.original, "=", this.left.end) + 1);
          code.remove(this.start, inclusionStart);
          if (preventASI) {
            removeLineBreaks(code, inclusionStart, this.right.start);
          }
          this.right.render(code, options, {
            renderedParentType: renderedParentType || this.parent.type,
            renderedSurroundingElement: renderedSurroundingElement || this.parent.type
          });
        }
        if (options.format === "system") {
          if (this.left instanceof Identifier) {
            const variable = this.left.variable;
            const exportNames = options.exportNamesByVariable.get(variable);
            if (exportNames) {
              if (exportNames.length === 1) {
                renderSystemExportExpression(variable, this.start, this.end, code, options);
              } else {
                renderSystemExportSequenceAfterExpression(variable, this.start, this.end, this.parent.type !== ExpressionStatement$1, code, options);
              }
              return;
            }
          } else {
            const systemPatternExports = [];
            this.left.addExportedVariables(systemPatternExports, options.exportNamesByVariable);
            if (systemPatternExports.length > 0) {
              renderSystemExportFunction(systemPatternExports, this.start, this.end, renderedSurroundingElement === ExpressionStatement$1, code, options);
              return;
            }
          }
        }
        if (this.left.included && this.left instanceof ObjectPattern && (renderedSurroundingElement === ExpressionStatement$1 || renderedSurroundingElement === ArrowFunctionExpression$1)) {
          code.appendRight(this.start, "(");
          code.prependLeft(this.end, ")");
        }
      }
      applyDeoptimizations() {
        this.deoptimized = true;
        this.left.deoptimizePath(EMPTY_PATH);
        this.right.deoptimizePath(UNKNOWN_PATH);
        this.context.requestTreeshakingPass();
      }
    };
    AssignmentPattern = class extends NodeBase {
      constructor() {
        super(...arguments);
        this.deoptimized = false;
      }
      addExportedVariables(variables, exportNamesByVariable) {
        this.left.addExportedVariables(variables, exportNamesByVariable);
      }
      declare(kind, init) {
        return this.left.declare(kind, init);
      }
      deoptimizePath(path6) {
        path6.length === 0 && this.left.deoptimizePath(path6);
      }
      hasEffectsWhenAssignedAtPath(path6, context) {
        return path6.length > 0 || this.left.hasEffectsWhenAssignedAtPath(EMPTY_PATH, context);
      }
      markDeclarationReached() {
        this.left.markDeclarationReached();
      }
      render(code, options, { isShorthandProperty } = BLANK) {
        this.left.render(code, options, { isShorthandProperty });
        this.right.render(code, options);
      }
      applyDeoptimizations() {
        this.deoptimized = true;
        this.left.deoptimizePath(EMPTY_PATH);
        this.right.deoptimizePath(UNKNOWN_PATH);
        this.context.requestTreeshakingPass();
      }
    };
    AwaitExpression = class extends NodeBase {
      constructor() {
        super(...arguments);
        this.deoptimized = false;
      }
      hasEffects() {
        if (!this.deoptimized)
          this.applyDeoptimizations();
        return true;
      }
      include(context, includeChildrenRecursively) {
        if (!this.deoptimized)
          this.applyDeoptimizations();
        if (!this.included) {
          this.included = true;
          checkTopLevelAwait: if (!this.context.usesTopLevelAwait) {
            let parent = this.parent;
            do {
              if (parent instanceof FunctionNode || parent instanceof ArrowFunctionExpression)
                break checkTopLevelAwait;
            } while (parent = parent.parent);
            this.context.usesTopLevelAwait = true;
          }
        }
        this.argument.include(context, includeChildrenRecursively);
      }
      applyDeoptimizations() {
        this.deoptimized = true;
        this.argument.deoptimizePath(UNKNOWN_PATH);
        this.context.requestTreeshakingPass();
      }
    };
    binaryOperators = {
      "!=": (left, right) => left != right,
      "!==": (left, right) => left !== right,
      "%": (left, right) => left % right,
      "&": (left, right) => left & right,
      "*": (left, right) => left * right,
      // At the moment, "**" will be transpiled to Math.pow
      "**": (left, right) => left ** right,
      "+": (left, right) => left + right,
      "-": (left, right) => left - right,
      "/": (left, right) => left / right,
      "<": (left, right) => left < right,
      "<<": (left, right) => left << right,
      "<=": (left, right) => left <= right,
      "==": (left, right) => left == right,
      "===": (left, right) => left === right,
      ">": (left, right) => left > right,
      ">=": (left, right) => left >= right,
      ">>": (left, right) => left >> right,
      ">>>": (left, right) => left >>> right,
      "^": (left, right) => left ^ right,
      in: () => UnknownValue,
      instanceof: () => UnknownValue,
      "|": (left, right) => left | right
    };
    BinaryExpression = class extends NodeBase {
      deoptimizeCache() {
      }
      getLiteralValueAtPath(path6, recursionTracker, origin) {
        if (path6.length > 0)
          return UnknownValue;
        const leftValue = this.left.getLiteralValueAtPath(EMPTY_PATH, recursionTracker, origin);
        if (leftValue === UnknownValue)
          return UnknownValue;
        const rightValue = this.right.getLiteralValueAtPath(EMPTY_PATH, recursionTracker, origin);
        if (rightValue === UnknownValue)
          return UnknownValue;
        const operatorFn = binaryOperators[this.operator];
        if (!operatorFn)
          return UnknownValue;
        return operatorFn(leftValue, rightValue);
      }
      hasEffects(context) {
        if (this.operator === "+" && this.parent instanceof ExpressionStatement && this.left.getLiteralValueAtPath(EMPTY_PATH, SHARED_RECURSION_TRACKER, this) === "")
          return true;
        return super.hasEffects(context);
      }
      hasEffectsWhenAccessedAtPath(path6) {
        return path6.length > 1;
      }
      render(code, options, { renderedSurroundingElement } = BLANK) {
        this.left.render(code, options, { renderedSurroundingElement });
        this.right.render(code, options);
      }
    };
    BreakStatement = class extends NodeBase {
      hasEffects(context) {
        if (this.label) {
          if (!context.ignore.labels.has(this.label.name))
            return true;
          context.includedLabels.add(this.label.name);
          context.brokenFlow = BROKEN_FLOW_ERROR_RETURN_LABEL;
        } else {
          if (!context.ignore.breaks)
            return true;
          context.brokenFlow = BROKEN_FLOW_BREAK_CONTINUE;
        }
        return false;
      }
      include(context) {
        this.included = true;
        if (this.label) {
          this.label.include();
          context.includedLabels.add(this.label.name);
        }
        context.brokenFlow = this.label ? BROKEN_FLOW_ERROR_RETURN_LABEL : BROKEN_FLOW_BREAK_CONTINUE;
      }
    };
    MAX_PATH_DEPTH = 7;
    MemberExpression = class extends NodeBase {
      constructor() {
        super(...arguments);
        this.variable = null;
        this.deoptimized = false;
        this.bound = false;
        this.expressionsToBeDeoptimized = [];
        this.replacement = null;
      }
      bind() {
        this.bound = true;
        const path6 = getPathIfNotComputed(this);
        const baseVariable = path6 && this.scope.findVariable(path6[0].key);
        if (baseVariable && baseVariable.isNamespace) {
          const resolvedVariable = this.resolveNamespaceVariables(baseVariable, path6.slice(1));
          if (!resolvedVariable) {
            super.bind();
          } else if (typeof resolvedVariable === "string") {
            this.replacement = resolvedVariable;
          } else {
            this.variable = resolvedVariable;
            this.scope.addNamespaceMemberAccess(getStringFromPath(path6), resolvedVariable);
          }
        } else {
          super.bind();
        }
      }
      deoptimizeCache() {
        const expressionsToBeDeoptimized = this.expressionsToBeDeoptimized;
        this.expressionsToBeDeoptimized = [];
        this.propertyKey = UnknownKey;
        this.object.deoptimizePath(UNKNOWN_PATH);
        for (const expression of expressionsToBeDeoptimized) {
          expression.deoptimizeCache();
        }
      }
      deoptimizePath(path6) {
        if (path6.length === 0)
          this.disallowNamespaceReassignment();
        if (this.variable) {
          this.variable.deoptimizePath(path6);
        } else if (!this.replacement) {
          if (path6.length < MAX_PATH_DEPTH) {
            this.object.deoptimizePath([this.getPropertyKey(), ...path6]);
          }
        }
      }
      deoptimizeThisOnEventAtPath(event, path6, thisParameter, recursionTracker) {
        if (this.variable) {
          this.variable.deoptimizeThisOnEventAtPath(event, path6, thisParameter, recursionTracker);
        } else if (!this.replacement) {
          if (path6.length < MAX_PATH_DEPTH) {
            this.object.deoptimizeThisOnEventAtPath(event, [this.getPropertyKey(), ...path6], thisParameter, recursionTracker);
          } else {
            thisParameter.deoptimizePath(UNKNOWN_PATH);
          }
        }
      }
      getLiteralValueAtPath(path6, recursionTracker, origin) {
        if (this.variable !== null) {
          return this.variable.getLiteralValueAtPath(path6, recursionTracker, origin);
        }
        if (this.replacement) {
          return UnknownValue;
        }
        this.expressionsToBeDeoptimized.push(origin);
        if (path6.length < MAX_PATH_DEPTH) {
          return this.object.getLiteralValueAtPath([this.getPropertyKey(), ...path6], recursionTracker, origin);
        }
        return UnknownValue;
      }
      getReturnExpressionWhenCalledAtPath(path6, callOptions, recursionTracker, origin) {
        if (this.variable !== null) {
          return this.variable.getReturnExpressionWhenCalledAtPath(path6, callOptions, recursionTracker, origin);
        }
        if (this.replacement) {
          return UNKNOWN_EXPRESSION;
        }
        this.expressionsToBeDeoptimized.push(origin);
        if (path6.length < MAX_PATH_DEPTH) {
          return this.object.getReturnExpressionWhenCalledAtPath([this.getPropertyKey(), ...path6], callOptions, recursionTracker, origin);
        }
        return UNKNOWN_EXPRESSION;
      }
      hasEffects(context) {
        if (!this.deoptimized)
          this.applyDeoptimizations();
        const { propertyReadSideEffects } = this.context.options.treeshake;
        return this.property.hasEffects(context) || this.object.hasEffects(context) || // Assignments do not access the property before assigning
        !(this.variable || this.replacement || this.parent instanceof AssignmentExpression && this.parent.operator === "=") && propertyReadSideEffects && (propertyReadSideEffects === "always" || this.object.hasEffectsWhenAccessedAtPath([this.getPropertyKey()], context));
      }
      hasEffectsWhenAccessedAtPath(path6, context) {
        if (this.variable !== null) {
          return this.variable.hasEffectsWhenAccessedAtPath(path6, context);
        }
        if (this.replacement) {
          return true;
        }
        if (path6.length < MAX_PATH_DEPTH) {
          return this.object.hasEffectsWhenAccessedAtPath([this.getPropertyKey(), ...path6], context);
        }
        return true;
      }
      hasEffectsWhenAssignedAtPath(path6, context) {
        if (this.variable !== null) {
          return this.variable.hasEffectsWhenAssignedAtPath(path6, context);
        }
        if (this.replacement) {
          return true;
        }
        if (path6.length < MAX_PATH_DEPTH) {
          return this.object.hasEffectsWhenAssignedAtPath([this.getPropertyKey(), ...path6], context);
        }
        return true;
      }
      hasEffectsWhenCalledAtPath(path6, callOptions, context) {
        if (this.variable !== null) {
          return this.variable.hasEffectsWhenCalledAtPath(path6, callOptions, context);
        }
        if (this.replacement) {
          return true;
        }
        if (path6.length < MAX_PATH_DEPTH) {
          return this.object.hasEffectsWhenCalledAtPath([this.getPropertyKey(), ...path6], callOptions, context);
        }
        return true;
      }
      include(context, includeChildrenRecursively) {
        if (!this.deoptimized)
          this.applyDeoptimizations();
        if (!this.included) {
          this.included = true;
          if (this.variable !== null) {
            this.context.includeVariableInModule(this.variable);
          }
        }
        this.object.include(context, includeChildrenRecursively);
        this.property.include(context, includeChildrenRecursively);
      }
      includeCallArguments(context, args) {
        if (this.variable) {
          this.variable.includeCallArguments(context, args);
        } else {
          super.includeCallArguments(context, args);
        }
      }
      initialise() {
        this.propertyKey = getResolvablePropertyKey(this);
      }
      render(code, options, { renderedParentType, isCalleeOfRenderedParent, renderedSurroundingElement } = BLANK) {
        if (this.variable || this.replacement) {
          let replacement = this.variable ? this.variable.getName() : this.replacement;
          if (renderedParentType && isCalleeOfRenderedParent)
            replacement = "0, " + replacement;
          code.overwrite(this.start, this.end, replacement, {
            contentOnly: true,
            storeName: true
          });
        } else {
          if (renderedParentType && isCalleeOfRenderedParent) {
            code.appendRight(this.start, "0, ");
          }
          this.object.render(code, options, { renderedSurroundingElement });
          this.property.render(code, options);
        }
      }
      applyDeoptimizations() {
        this.deoptimized = true;
        const { propertyReadSideEffects } = this.context.options.treeshake;
        if (
          // Namespaces are not bound and should not be deoptimized
          this.bound && propertyReadSideEffects && !(this.variable || this.replacement)
        ) {
          if (!(this.parent instanceof AssignmentExpression && this.parent.operator === "=")) {
            this.object.deoptimizeThisOnEventAtPath(EVENT_ACCESSED, [this.propertyKey], this.object, SHARED_RECURSION_TRACKER);
          }
          if (this.parent instanceof AssignmentExpression) {
            this.object.deoptimizeThisOnEventAtPath(EVENT_ASSIGNED, [this.propertyKey], this.object, SHARED_RECURSION_TRACKER);
          }
          this.context.requestTreeshakingPass();
        }
      }
      disallowNamespaceReassignment() {
        if (this.object instanceof Identifier) {
          const variable = this.scope.findVariable(this.object.name);
          if (variable.isNamespace) {
            if (this.variable) {
              this.context.includeVariableInModule(this.variable);
            }
            this.context.warn({
              code: "ILLEGAL_NAMESPACE_REASSIGNMENT",
              message: `Illegal reassignment to import '${this.object.name}'`
            }, this.start);
          }
        }
      }
      getPropertyKey() {
        if (this.propertyKey === null) {
          this.propertyKey = UnknownKey;
          const value = this.property.getLiteralValueAtPath(EMPTY_PATH, SHARED_RECURSION_TRACKER, this);
          return this.propertyKey = value === UnknownValue ? UnknownKey : String(value);
        }
        return this.propertyKey;
      }
      resolveNamespaceVariables(baseVariable, path6) {
        if (path6.length === 0)
          return baseVariable;
        if (!baseVariable.isNamespace || baseVariable instanceof ExternalVariable)
          return null;
        const exportName = path6[0].key;
        const variable = baseVariable.context.traceExport(exportName);
        if (!variable) {
          const fileName = baseVariable.context.fileName;
          this.context.warn({
            code: "MISSING_EXPORT",
            exporter: relativeId(fileName),
            importer: relativeId(this.context.fileName),
            message: `'${exportName}' is not exported by '${relativeId(fileName)}'`,
            missing: exportName,
            url: `https://rollupjs.org/guide/en/#error-name-is-not-exported-by-module`
          }, path6[0].pos);
          return "undefined";
        }
        return this.resolveNamespaceVariables(variable, path6.slice(1));
      }
    };
    CallExpression = class extends NodeBase {
      constructor() {
        super(...arguments);
        this.deoptimized = false;
        this.deoptimizableDependentExpressions = [];
        this.expressionsToBeDeoptimized = /* @__PURE__ */ new Set();
        this.returnExpression = null;
      }
      bind() {
        super.bind();
        if (this.callee instanceof Identifier) {
          const variable = this.scope.findVariable(this.callee.name);
          if (variable.isNamespace) {
            this.context.warn({
              code: "CANNOT_CALL_NAMESPACE",
              message: `Cannot call a namespace ('${this.callee.name}')`
            }, this.start);
          }
          if (this.callee.name === "eval") {
            this.context.warn({
              code: "EVAL",
              message: `Use of eval is strongly discouraged, as it poses security risks and may cause issues with minification`,
              url: "https://rollupjs.org/guide/en/#avoiding-eval"
            }, this.start);
          }
        }
        this.callOptions = {
          args: this.arguments,
          thisParam: this.callee instanceof MemberExpression && !this.callee.variable ? this.callee.object : null,
          withNew: false
        };
      }
      deoptimizeCache() {
        if (this.returnExpression !== UNKNOWN_EXPRESSION) {
          this.returnExpression = UNKNOWN_EXPRESSION;
          for (const expression of this.deoptimizableDependentExpressions) {
            expression.deoptimizeCache();
          }
          for (const expression of this.expressionsToBeDeoptimized) {
            expression.deoptimizePath(UNKNOWN_PATH);
          }
        }
      }
      deoptimizePath(path6) {
        if (path6.length === 0 || this.context.deoptimizationTracker.trackEntityAtPathAndGetIfTracked(path6, this)) {
          return;
        }
        const returnExpression = this.getReturnExpression();
        if (returnExpression !== UNKNOWN_EXPRESSION) {
          returnExpression.deoptimizePath(path6);
        }
      }
      deoptimizeThisOnEventAtPath(event, path6, thisParameter, recursionTracker) {
        const returnExpression = this.getReturnExpression(recursionTracker);
        if (returnExpression === UNKNOWN_EXPRESSION) {
          thisParameter.deoptimizePath(UNKNOWN_PATH);
        } else {
          recursionTracker.withTrackedEntityAtPath(path6, returnExpression, () => {
            this.expressionsToBeDeoptimized.add(thisParameter);
            returnExpression.deoptimizeThisOnEventAtPath(event, path6, thisParameter, recursionTracker);
          }, void 0);
        }
      }
      getLiteralValueAtPath(path6, recursionTracker, origin) {
        const returnExpression = this.getReturnExpression(recursionTracker);
        if (returnExpression === UNKNOWN_EXPRESSION) {
          return UnknownValue;
        }
        return recursionTracker.withTrackedEntityAtPath(path6, returnExpression, () => {
          this.deoptimizableDependentExpressions.push(origin);
          return returnExpression.getLiteralValueAtPath(path6, recursionTracker, origin);
        }, UnknownValue);
      }
      getReturnExpressionWhenCalledAtPath(path6, callOptions, recursionTracker, origin) {
        const returnExpression = this.getReturnExpression(recursionTracker);
        if (this.returnExpression === UNKNOWN_EXPRESSION) {
          return UNKNOWN_EXPRESSION;
        }
        return recursionTracker.withTrackedEntityAtPath(path6, returnExpression, () => {
          this.deoptimizableDependentExpressions.push(origin);
          return returnExpression.getReturnExpressionWhenCalledAtPath(path6, callOptions, recursionTracker, origin);
        }, UNKNOWN_EXPRESSION);
      }
      hasEffects(context) {
        try {
          for (const argument of this.arguments) {
            if (argument.hasEffects(context))
              return true;
          }
          if (this.context.options.treeshake.annotations && this.annotations)
            return false;
          return this.callee.hasEffects(context) || this.callee.hasEffectsWhenCalledAtPath(EMPTY_PATH, this.callOptions, context);
        } finally {
          if (!this.deoptimized)
            this.applyDeoptimizations();
        }
      }
      hasEffectsWhenAccessedAtPath(path6, context) {
        return !context.accessed.trackEntityAtPathAndGetIfTracked(path6, this) && this.getReturnExpression().hasEffectsWhenAccessedAtPath(path6, context);
      }
      hasEffectsWhenAssignedAtPath(path6, context) {
        return !context.assigned.trackEntityAtPathAndGetIfTracked(path6, this) && this.getReturnExpression().hasEffectsWhenAssignedAtPath(path6, context);
      }
      hasEffectsWhenCalledAtPath(path6, callOptions, context) {
        return !(callOptions.withNew ? context.instantiated : context.called).trackEntityAtPathAndGetIfTracked(path6, callOptions, this) && this.getReturnExpression().hasEffectsWhenCalledAtPath(path6, callOptions, context);
      }
      include(context, includeChildrenRecursively) {
        if (!this.deoptimized)
          this.applyDeoptimizations();
        if (includeChildrenRecursively) {
          super.include(context, includeChildrenRecursively);
          if (includeChildrenRecursively === INCLUDE_PARAMETERS && this.callee instanceof Identifier && this.callee.variable) {
            this.callee.variable.markCalledFromTryStatement();
          }
        } else {
          this.included = true;
          this.callee.include(context, false);
        }
        this.callee.includeCallArguments(context, this.arguments);
        const returnExpression = this.getReturnExpression();
        if (!returnExpression.included) {
          returnExpression.include(context, false);
        }
      }
      render(code, options, { renderedSurroundingElement } = BLANK) {
        this.callee.render(code, options, {
          isCalleeOfRenderedParent: true,
          renderedSurroundingElement
        });
        if (this.arguments.length > 0) {
          if (this.arguments[this.arguments.length - 1].included) {
            for (const arg of this.arguments) {
              arg.render(code, options);
            }
          } else {
            let lastIncludedIndex = this.arguments.length - 2;
            while (lastIncludedIndex >= 0 && !this.arguments[lastIncludedIndex].included) {
              lastIncludedIndex--;
            }
            if (lastIncludedIndex >= 0) {
              for (let index2 = 0; index2 <= lastIncludedIndex; index2++) {
                this.arguments[index2].render(code, options);
              }
              code.remove(findFirstOccurrenceOutsideComment(code.original, ",", this.arguments[lastIncludedIndex].end), this.end - 1);
            } else {
              code.remove(findFirstOccurrenceOutsideComment(code.original, "(", this.callee.end) + 1, this.end - 1);
            }
          }
        }
      }
      applyDeoptimizations() {
        this.deoptimized = true;
        const { thisParam } = this.callOptions;
        if (thisParam) {
          this.callee.deoptimizeThisOnEventAtPath(EVENT_CALLED, EMPTY_PATH, thisParam, SHARED_RECURSION_TRACKER);
        }
        for (const argument of this.arguments) {
          argument.deoptimizePath(UNKNOWN_PATH);
        }
        this.context.requestTreeshakingPass();
      }
      getReturnExpression(recursionTracker = SHARED_RECURSION_TRACKER) {
        if (this.returnExpression === null) {
          this.returnExpression = UNKNOWN_EXPRESSION;
          return this.returnExpression = this.callee.getReturnExpressionWhenCalledAtPath(EMPTY_PATH, this.callOptions, recursionTracker, this);
        }
        return this.returnExpression;
      }
    };
    CatchScope = class extends ParameterScope {
      addDeclaration(identifier, context, init, isHoisted) {
        const existingParameter = this.variables.get(identifier.name);
        if (existingParameter) {
          this.parent.addDeclaration(identifier, context, UNDEFINED_EXPRESSION, isHoisted);
          existingParameter.addDeclaration(identifier, init);
          return existingParameter;
        }
        return this.parent.addDeclaration(identifier, context, init, isHoisted);
      }
    };
    CatchClause = class extends NodeBase {
      createScope(parentScope) {
        this.scope = new CatchScope(parentScope, this.context);
      }
      parseNode(esTreeNode) {
        const { param } = esTreeNode;
        if (param) {
          this.param = new (this.context.nodeConstructors[param.type] || this.context.nodeConstructors.UnknownNode)(param, this, this.scope);
          this.param.declare("parameter", UNKNOWN_EXPRESSION);
        }
        super.parseNode(esTreeNode);
      }
    };
    ChainExpression = class extends NodeBase {
    };
    ClassBodyScope = class extends ChildScope {
      constructor(parent, classNode, context) {
        super(parent);
        this.variables.set("this", this.thisVariable = new LocalVariable("this", null, classNode, context));
        this.instanceScope = new ChildScope(this);
        this.instanceScope.variables.set("this", new ThisVariable(context));
      }
      findLexicalBoundary() {
        return this;
      }
    };
    ClassBody = class extends NodeBase {
      createScope(parentScope) {
        this.scope = new ClassBodyScope(parentScope, this.parent, this.context);
      }
      include(context, includeChildrenRecursively) {
        this.included = true;
        this.context.includeVariableInModule(this.scope.thisVariable);
        for (const definition of this.body) {
          definition.include(context, includeChildrenRecursively);
        }
      }
      parseNode(esTreeNode) {
        const body = this.body = [];
        for (const definition of esTreeNode.body) {
          body.push(new this.context.nodeConstructors[definition.type](definition, this, definition.static ? this.scope : this.scope.instanceScope));
        }
        super.parseNode(esTreeNode);
      }
    };
    ClassExpression = class extends ClassNode {
      render(code, options, { renderedSurroundingElement } = BLANK) {
        super.render(code, options);
        if (renderedSurroundingElement === ExpressionStatement$1) {
          code.appendRight(this.start, "(");
          code.prependLeft(this.end, ")");
        }
      }
    };
    MultiExpression = class _MultiExpression extends ExpressionEntity {
      constructor(expressions) {
        super();
        this.expressions = expressions;
        this.included = false;
      }
      deoptimizePath(path6) {
        for (const expression of this.expressions) {
          expression.deoptimizePath(path6);
        }
      }
      getReturnExpressionWhenCalledAtPath(path6, callOptions, recursionTracker, origin) {
        return new _MultiExpression(this.expressions.map((expression) => expression.getReturnExpressionWhenCalledAtPath(path6, callOptions, recursionTracker, origin)));
      }
      hasEffectsWhenAccessedAtPath(path6, context) {
        for (const expression of this.expressions) {
          if (expression.hasEffectsWhenAccessedAtPath(path6, context))
            return true;
        }
        return false;
      }
      hasEffectsWhenAssignedAtPath(path6, context) {
        for (const expression of this.expressions) {
          if (expression.hasEffectsWhenAssignedAtPath(path6, context))
            return true;
        }
        return false;
      }
      hasEffectsWhenCalledAtPath(path6, callOptions, context) {
        for (const expression of this.expressions) {
          if (expression.hasEffectsWhenCalledAtPath(path6, callOptions, context))
            return true;
        }
        return false;
      }
      include(context, includeChildrenRecursively) {
        for (const expression of this.expressions) {
          if (!expression.included) {
            expression.include(context, includeChildrenRecursively);
          }
        }
      }
    };
    ConditionalExpression = class extends NodeBase {
      constructor() {
        super(...arguments);
        this.expressionsToBeDeoptimized = [];
        this.isBranchResolutionAnalysed = false;
        this.usedBranch = null;
      }
      deoptimizeCache() {
        if (this.usedBranch !== null) {
          const unusedBranch = this.usedBranch === this.consequent ? this.alternate : this.consequent;
          this.usedBranch = null;
          unusedBranch.deoptimizePath(UNKNOWN_PATH);
          for (const expression of this.expressionsToBeDeoptimized) {
            expression.deoptimizeCache();
          }
        }
      }
      deoptimizePath(path6) {
        const usedBranch = this.getUsedBranch();
        if (usedBranch === null) {
          this.consequent.deoptimizePath(path6);
          this.alternate.deoptimizePath(path6);
        } else {
          usedBranch.deoptimizePath(path6);
        }
      }
      deoptimizeThisOnEventAtPath(event, path6, thisParameter, recursionTracker) {
        this.consequent.deoptimizeThisOnEventAtPath(event, path6, thisParameter, recursionTracker);
        this.alternate.deoptimizeThisOnEventAtPath(event, path6, thisParameter, recursionTracker);
      }
      getLiteralValueAtPath(path6, recursionTracker, origin) {
        const usedBranch = this.getUsedBranch();
        if (usedBranch === null)
          return UnknownValue;
        this.expressionsToBeDeoptimized.push(origin);
        return usedBranch.getLiteralValueAtPath(path6, recursionTracker, origin);
      }
      getReturnExpressionWhenCalledAtPath(path6, callOptions, recursionTracker, origin) {
        const usedBranch = this.getUsedBranch();
        if (usedBranch === null)
          return new MultiExpression([
            this.consequent.getReturnExpressionWhenCalledAtPath(path6, callOptions, recursionTracker, origin),
            this.alternate.getReturnExpressionWhenCalledAtPath(path6, callOptions, recursionTracker, origin)
          ]);
        this.expressionsToBeDeoptimized.push(origin);
        return usedBranch.getReturnExpressionWhenCalledAtPath(path6, callOptions, recursionTracker, origin);
      }
      hasEffects(context) {
        if (this.test.hasEffects(context))
          return true;
        const usedBranch = this.getUsedBranch();
        if (usedBranch === null) {
          return this.consequent.hasEffects(context) || this.alternate.hasEffects(context);
        }
        return usedBranch.hasEffects(context);
      }
      hasEffectsWhenAccessedAtPath(path6, context) {
        const usedBranch = this.getUsedBranch();
        if (usedBranch === null) {
          return this.consequent.hasEffectsWhenAccessedAtPath(path6, context) || this.alternate.hasEffectsWhenAccessedAtPath(path6, context);
        }
        return usedBranch.hasEffectsWhenAccessedAtPath(path6, context);
      }
      hasEffectsWhenAssignedAtPath(path6, context) {
        const usedBranch = this.getUsedBranch();
        if (usedBranch === null) {
          return this.consequent.hasEffectsWhenAssignedAtPath(path6, context) || this.alternate.hasEffectsWhenAssignedAtPath(path6, context);
        }
        return usedBranch.hasEffectsWhenAssignedAtPath(path6, context);
      }
      hasEffectsWhenCalledAtPath(path6, callOptions, context) {
        const usedBranch = this.getUsedBranch();
        if (usedBranch === null) {
          return this.consequent.hasEffectsWhenCalledAtPath(path6, callOptions, context) || this.alternate.hasEffectsWhenCalledAtPath(path6, callOptions, context);
        }
        return usedBranch.hasEffectsWhenCalledAtPath(path6, callOptions, context);
      }
      include(context, includeChildrenRecursively) {
        this.included = true;
        const usedBranch = this.getUsedBranch();
        if (includeChildrenRecursively || this.test.shouldBeIncluded(context) || usedBranch === null) {
          this.test.include(context, includeChildrenRecursively);
          this.consequent.include(context, includeChildrenRecursively);
          this.alternate.include(context, includeChildrenRecursively);
        } else {
          usedBranch.include(context, includeChildrenRecursively);
        }
      }
      includeCallArguments(context, args) {
        const usedBranch = this.getUsedBranch();
        if (usedBranch === null) {
          this.consequent.includeCallArguments(context, args);
          this.alternate.includeCallArguments(context, args);
        } else {
          usedBranch.includeCallArguments(context, args);
        }
      }
      render(code, options, { isCalleeOfRenderedParent, preventASI, renderedParentType, renderedSurroundingElement } = BLANK) {
        const usedBranch = this.getUsedBranch();
        if (!this.test.included) {
          const colonPos = findFirstOccurrenceOutsideComment(code.original, ":", this.consequent.end);
          const inclusionStart = findNonWhiteSpace(code.original, (this.consequent.included ? findFirstOccurrenceOutsideComment(code.original, "?", this.test.end) : colonPos) + 1);
          if (preventASI) {
            removeLineBreaks(code, inclusionStart, usedBranch.start);
          }
          code.remove(this.start, inclusionStart);
          if (this.consequent.included) {
            code.remove(colonPos, this.end);
          }
          removeAnnotations(this, code);
          usedBranch.render(code, options, {
            isCalleeOfRenderedParent,
            preventASI: true,
            renderedParentType: renderedParentType || this.parent.type,
            renderedSurroundingElement: renderedSurroundingElement || this.parent.type
          });
        } else {
          this.test.render(code, options, { renderedSurroundingElement });
          this.consequent.render(code, options);
          this.alternate.render(code, options);
        }
      }
      getUsedBranch() {
        if (this.isBranchResolutionAnalysed) {
          return this.usedBranch;
        }
        this.isBranchResolutionAnalysed = true;
        const testValue = this.test.getLiteralValueAtPath(EMPTY_PATH, SHARED_RECURSION_TRACKER, this);
        return testValue === UnknownValue ? null : this.usedBranch = testValue ? this.consequent : this.alternate;
      }
    };
    ContinueStatement = class extends NodeBase {
      hasEffects(context) {
        if (this.label) {
          if (!context.ignore.labels.has(this.label.name))
            return true;
          context.includedLabels.add(this.label.name);
          context.brokenFlow = BROKEN_FLOW_ERROR_RETURN_LABEL;
        } else {
          if (!context.ignore.continues)
            return true;
          context.brokenFlow = BROKEN_FLOW_BREAK_CONTINUE;
        }
        return false;
      }
      include(context) {
        this.included = true;
        if (this.label) {
          this.label.include();
          context.includedLabels.add(this.label.name);
        }
        context.brokenFlow = this.label ? BROKEN_FLOW_ERROR_RETURN_LABEL : BROKEN_FLOW_BREAK_CONTINUE;
      }
    };
    DoWhileStatement = class extends NodeBase {
      hasEffects(context) {
        if (this.test.hasEffects(context))
          return true;
        const { brokenFlow, ignore: { breaks, continues } } = context;
        context.ignore.breaks = true;
        context.ignore.continues = true;
        if (this.body.hasEffects(context))
          return true;
        context.ignore.breaks = breaks;
        context.ignore.continues = continues;
        context.brokenFlow = brokenFlow;
        return false;
      }
      include(context, includeChildrenRecursively) {
        this.included = true;
        this.test.include(context, includeChildrenRecursively);
        const { brokenFlow } = context;
        this.body.includeAsSingleStatement(context, includeChildrenRecursively);
        context.brokenFlow = brokenFlow;
      }
    };
    EmptyStatement = class extends NodeBase {
      hasEffects() {
        return false;
      }
    };
    ExportNamedDeclaration = class extends NodeBase {
      bind() {
        if (this.declaration !== null)
          this.declaration.bind();
      }
      hasEffects(context) {
        return this.declaration !== null && this.declaration.hasEffects(context);
      }
      initialise() {
        this.context.addExport(this);
      }
      render(code, options, nodeRenderOptions) {
        const { start, end } = nodeRenderOptions;
        if (this.declaration === null) {
          code.remove(start, end);
        } else {
          code.remove(this.start, this.declaration.start);
          this.declaration.render(code, options, { end, start });
        }
      }
    };
    ExportNamedDeclaration.prototype.needsBoundaries = true;
    ExportSpecifier = class extends NodeBase {
    };
    ForInStatement = class extends NodeBase {
      constructor() {
        super(...arguments);
        this.deoptimized = false;
      }
      createScope(parentScope) {
        this.scope = new BlockScope(parentScope);
      }
      hasEffects(context) {
        if (!this.deoptimized)
          this.applyDeoptimizations();
        if (this.left && (this.left.hasEffects(context) || this.left.hasEffectsWhenAssignedAtPath(EMPTY_PATH, context)) || this.right && this.right.hasEffects(context))
          return true;
        const { brokenFlow, ignore: { breaks, continues } } = context;
        context.ignore.breaks = true;
        context.ignore.continues = true;
        if (this.body.hasEffects(context))
          return true;
        context.ignore.breaks = breaks;
        context.ignore.continues = continues;
        context.brokenFlow = brokenFlow;
        return false;
      }
      include(context, includeChildrenRecursively) {
        if (!this.deoptimized)
          this.applyDeoptimizations();
        this.included = true;
        this.left.include(context, includeChildrenRecursively || true);
        this.right.include(context, includeChildrenRecursively);
        const { brokenFlow } = context;
        this.body.includeAsSingleStatement(context, includeChildrenRecursively);
        context.brokenFlow = brokenFlow;
      }
      render(code, options) {
        this.left.render(code, options, NO_SEMICOLON);
        this.right.render(code, options, NO_SEMICOLON);
        if (code.original.charCodeAt(this.right.start - 1) === 110) {
          code.prependLeft(this.right.start, " ");
        }
        this.body.render(code, options);
      }
      applyDeoptimizations() {
        this.deoptimized = true;
        this.left.deoptimizePath(EMPTY_PATH);
        this.context.requestTreeshakingPass();
      }
    };
    ForOfStatement = class extends NodeBase {
      constructor() {
        super(...arguments);
        this.deoptimized = false;
      }
      createScope(parentScope) {
        this.scope = new BlockScope(parentScope);
      }
      hasEffects() {
        if (!this.deoptimized)
          this.applyDeoptimizations();
        return true;
      }
      include(context, includeChildrenRecursively) {
        if (!this.deoptimized)
          this.applyDeoptimizations();
        this.included = true;
        this.left.include(context, includeChildrenRecursively || true);
        this.right.include(context, includeChildrenRecursively);
        const { brokenFlow } = context;
        this.body.includeAsSingleStatement(context, includeChildrenRecursively);
        context.brokenFlow = brokenFlow;
      }
      render(code, options) {
        this.left.render(code, options, NO_SEMICOLON);
        this.right.render(code, options, NO_SEMICOLON);
        if (code.original.charCodeAt(this.right.start - 1) === 102) {
          code.prependLeft(this.right.start, " ");
        }
        this.body.render(code, options);
      }
      applyDeoptimizations() {
        this.deoptimized = true;
        this.left.deoptimizePath(EMPTY_PATH);
        this.context.requestTreeshakingPass();
      }
    };
    ForStatement = class extends NodeBase {
      createScope(parentScope) {
        this.scope = new BlockScope(parentScope);
      }
      hasEffects(context) {
        if (this.init && this.init.hasEffects(context) || this.test && this.test.hasEffects(context) || this.update && this.update.hasEffects(context))
          return true;
        const { brokenFlow, ignore: { breaks, continues } } = context;
        context.ignore.breaks = true;
        context.ignore.continues = true;
        if (this.body.hasEffects(context))
          return true;
        context.ignore.breaks = breaks;
        context.ignore.continues = continues;
        context.brokenFlow = brokenFlow;
        return false;
      }
      include(context, includeChildrenRecursively) {
        this.included = true;
        if (this.init)
          this.init.includeAsSingleStatement(context, includeChildrenRecursively);
        if (this.test)
          this.test.include(context, includeChildrenRecursively);
        const { brokenFlow } = context;
        if (this.update)
          this.update.include(context, includeChildrenRecursively);
        this.body.includeAsSingleStatement(context, includeChildrenRecursively);
        context.brokenFlow = brokenFlow;
      }
      render(code, options) {
        if (this.init)
          this.init.render(code, options, NO_SEMICOLON);
        if (this.test)
          this.test.render(code, options, NO_SEMICOLON);
        if (this.update)
          this.update.render(code, options, NO_SEMICOLON);
        this.body.render(code, options);
      }
    };
    FunctionExpression = class extends FunctionNode {
      render(code, options, { renderedSurroundingElement } = BLANK) {
        super.render(code, options);
        if (renderedSurroundingElement === ExpressionStatement$1) {
          code.appendRight(this.start, "(");
          code.prependLeft(this.end, ")");
        }
      }
    };
    TrackingScope = class extends BlockScope {
      constructor() {
        super(...arguments);
        this.hoistedDeclarations = [];
      }
      addDeclaration(identifier, context, init, isHoisted) {
        this.hoistedDeclarations.push(identifier);
        return super.addDeclaration(identifier, context, init, isHoisted);
      }
    };
    unset = Symbol("unset");
    IfStatement = class _IfStatement extends NodeBase {
      constructor() {
        super(...arguments);
        this.testValue = unset;
      }
      deoptimizeCache() {
        this.testValue = UnknownValue;
      }
      hasEffects(context) {
        if (this.test.hasEffects(context)) {
          return true;
        }
        const testValue = this.getTestValue();
        if (testValue === UnknownValue) {
          const { brokenFlow } = context;
          if (this.consequent.hasEffects(context))
            return true;
          const consequentBrokenFlow = context.brokenFlow;
          context.brokenFlow = brokenFlow;
          if (this.alternate === null)
            return false;
          if (this.alternate.hasEffects(context))
            return true;
          context.brokenFlow = context.brokenFlow < consequentBrokenFlow ? context.brokenFlow : consequentBrokenFlow;
          return false;
        }
        return testValue ? this.consequent.hasEffects(context) : this.alternate !== null && this.alternate.hasEffects(context);
      }
      include(context, includeChildrenRecursively) {
        this.included = true;
        if (includeChildrenRecursively) {
          this.includeRecursively(includeChildrenRecursively, context);
        } else {
          const testValue = this.getTestValue();
          if (testValue === UnknownValue) {
            this.includeUnknownTest(context);
          } else {
            this.includeKnownTest(context, testValue);
          }
        }
      }
      parseNode(esTreeNode) {
        this.consequentScope = new TrackingScope(this.scope);
        this.consequent = new (this.context.nodeConstructors[esTreeNode.consequent.type] || this.context.nodeConstructors.UnknownNode)(esTreeNode.consequent, this, this.consequentScope);
        if (esTreeNode.alternate) {
          this.alternateScope = new TrackingScope(this.scope);
          this.alternate = new (this.context.nodeConstructors[esTreeNode.alternate.type] || this.context.nodeConstructors.UnknownNode)(esTreeNode.alternate, this, this.alternateScope);
        }
        super.parseNode(esTreeNode);
      }
      render(code, options) {
        const testValue = this.getTestValue();
        const hoistedDeclarations = [];
        const includesIfElse = this.test.included;
        const noTreeshake = !this.context.options.treeshake;
        if (includesIfElse) {
          this.test.render(code, options);
        } else {
          code.remove(this.start, this.consequent.start);
        }
        if (this.consequent.included && (noTreeshake || testValue === UnknownValue || testValue)) {
          this.consequent.render(code, options);
        } else {
          code.overwrite(this.consequent.start, this.consequent.end, includesIfElse ? ";" : "");
          hoistedDeclarations.push(...this.consequentScope.hoistedDeclarations);
        }
        if (this.alternate) {
          if (this.alternate.included && (noTreeshake || testValue === UnknownValue || !testValue)) {
            if (includesIfElse) {
              if (code.original.charCodeAt(this.alternate.start - 1) === 101) {
                code.prependLeft(this.alternate.start, " ");
              }
            } else {
              code.remove(this.consequent.end, this.alternate.start);
            }
            this.alternate.render(code, options);
          } else {
            if (includesIfElse && this.shouldKeepAlternateBranch()) {
              code.overwrite(this.alternate.start, this.end, ";");
            } else {
              code.remove(this.consequent.end, this.end);
            }
            hoistedDeclarations.push(...this.alternateScope.hoistedDeclarations);
          }
        }
        this.renderHoistedDeclarations(hoistedDeclarations, code);
      }
      getTestValue() {
        if (this.testValue === unset) {
          return this.testValue = this.test.getLiteralValueAtPath(EMPTY_PATH, SHARED_RECURSION_TRACKER, this);
        }
        return this.testValue;
      }
      includeKnownTest(context, testValue) {
        if (this.test.shouldBeIncluded(context)) {
          this.test.include(context, false);
        }
        if (testValue && this.consequent.shouldBeIncluded(context)) {
          this.consequent.includeAsSingleStatement(context, false);
        }
        if (this.alternate !== null && !testValue && this.alternate.shouldBeIncluded(context)) {
          this.alternate.includeAsSingleStatement(context, false);
        }
      }
      includeRecursively(includeChildrenRecursively, context) {
        this.test.include(context, includeChildrenRecursively);
        this.consequent.include(context, includeChildrenRecursively);
        if (this.alternate !== null) {
          this.alternate.include(context, includeChildrenRecursively);
        }
      }
      includeUnknownTest(context) {
        this.test.include(context, false);
        const { brokenFlow } = context;
        let consequentBrokenFlow = BROKEN_FLOW_NONE;
        if (this.consequent.shouldBeIncluded(context)) {
          this.consequent.includeAsSingleStatement(context, false);
          consequentBrokenFlow = context.brokenFlow;
          context.brokenFlow = brokenFlow;
        }
        if (this.alternate !== null && this.alternate.shouldBeIncluded(context)) {
          this.alternate.includeAsSingleStatement(context, false);
          context.brokenFlow = context.brokenFlow < consequentBrokenFlow ? context.brokenFlow : consequentBrokenFlow;
        }
      }
      renderHoistedDeclarations(hoistedDeclarations, code) {
        const hoistedVars = [
          ...new Set(hoistedDeclarations.map((identifier) => {
            const variable = identifier.variable;
            return variable.included ? variable.getName() : "";
          }))
        ].filter(Boolean).join(", ");
        if (hoistedVars) {
          const parentType = this.parent.type;
          const needsBraces = parentType !== Program$1 && parentType !== BlockStatement$1;
          code.prependRight(this.start, `${needsBraces ? "{ " : ""}var ${hoistedVars}; `);
          if (needsBraces) {
            code.appendLeft(this.end, ` }`);
          }
        }
      }
      shouldKeepAlternateBranch() {
        let currentParent = this.parent;
        do {
          if (currentParent instanceof _IfStatement && currentParent.alternate) {
            return true;
          }
          if (currentParent instanceof BlockStatement) {
            return false;
          }
          currentParent = currentParent.parent;
        } while (currentParent);
        return false;
      }
    };
    ImportDeclaration = class extends NodeBase {
      // Do not bind specifiers
      bind() {
      }
      hasEffects() {
        return false;
      }
      initialise() {
        this.context.addImport(this);
      }
      render(code, _options2, nodeRenderOptions) {
        code.remove(nodeRenderOptions.start, nodeRenderOptions.end);
      }
    };
    ImportDeclaration.prototype.needsBoundaries = true;
    ImportDefaultSpecifier = class extends NodeBase {
    };
    INTEROP_DEFAULT_VARIABLE = "_interopDefault";
    INTEROP_DEFAULT_LEGACY_VARIABLE = "_interopDefaultLegacy";
    INTEROP_NAMESPACE_VARIABLE = "_interopNamespace";
    INTEROP_NAMESPACE_DEFAULT_VARIABLE = "_interopNamespaceDefault";
    INTEROP_NAMESPACE_DEFAULT_ONLY_VARIABLE = "_interopNamespaceDefaultOnly";
    defaultInteropHelpersByInteropType = {
      auto: INTEROP_DEFAULT_VARIABLE,
      default: null,
      defaultOnly: null,
      esModule: null,
      false: null,
      true: INTEROP_DEFAULT_LEGACY_VARIABLE
    };
    namespaceInteropHelpersByInteropType = {
      auto: INTEROP_NAMESPACE_VARIABLE,
      default: INTEROP_NAMESPACE_DEFAULT_VARIABLE,
      defaultOnly: INTEROP_NAMESPACE_DEFAULT_ONLY_VARIABLE,
      esModule: null,
      false: null,
      true: INTEROP_NAMESPACE_VARIABLE
    };
    HELPER_GENERATORS = {
      [INTEROP_DEFAULT_LEGACY_VARIABLE]: (_, n3, s, _t, liveBindings) => `function ${INTEROP_DEFAULT_LEGACY_VARIABLE}${_}(e)${_}{${_}return e${_}&&${_}typeof e${_}===${_}'object'${_}&&${_}'default'${_}in e${_}?${_}${liveBindings ? getDefaultLiveBinding(_) : getDefaultStatic(_)}${s}${_}}${n3}${n3}`,
      [INTEROP_DEFAULT_VARIABLE]: (_, n3, s, _t, liveBindings) => `function ${INTEROP_DEFAULT_VARIABLE}${_}(e)${_}{${_}return e${_}&&${_}e.__esModule${_}?${_}${liveBindings ? getDefaultLiveBinding(_) : getDefaultStatic(_)}${s}${_}}${n3}${n3}`,
      [INTEROP_NAMESPACE_DEFAULT_ONLY_VARIABLE]: (_, n3, _s, t, _liveBindings, freeze, namespaceToStringTag) => `function ${INTEROP_NAMESPACE_DEFAULT_ONLY_VARIABLE}(e)${_}{${n3}${t}return ${getFrozen(`{__proto__: null,${namespaceToStringTag ? `${_}[Symbol.toStringTag]:${_}'Module',` : ""}${_}'default':${_}e}`, freeze)};${n3}}${n3}${n3}`,
      [INTEROP_NAMESPACE_DEFAULT_VARIABLE]: (_, n3, _s, t, liveBindings, freeze, namespaceToStringTag) => `function ${INTEROP_NAMESPACE_DEFAULT_VARIABLE}(e)${_}{${n3}` + createNamespaceObject(_, n3, t, t, liveBindings, freeze, namespaceToStringTag) + `}${n3}${n3}`,
      [INTEROP_NAMESPACE_VARIABLE]: (_, n3, s, t, liveBindings, freeze, namespaceToStringTag, usedHelpers) => `function ${INTEROP_NAMESPACE_VARIABLE}(e)${_}{${n3}` + (usedHelpers.has(INTEROP_NAMESPACE_DEFAULT_VARIABLE) ? `${t}return e${_}&&${_}e.__esModule${_}?${_}e${_}:${_}${INTEROP_NAMESPACE_DEFAULT_VARIABLE}(e)${s}${n3}` : `${t}if${_}(e${_}&&${_}e.__esModule)${_}return e;${n3}` + createNamespaceObject(_, n3, t, t, liveBindings, freeze, namespaceToStringTag)) + `}${n3}${n3}`
    };
    HELPER_NAMES = Object.keys(HELPER_GENERATORS);
    ImportExpression = class extends NodeBase {
      constructor() {
        super(...arguments);
        this.inlineNamespace = null;
        this.mechanism = null;
        this.resolution = null;
      }
      hasEffects() {
        return true;
      }
      include(context, includeChildrenRecursively) {
        if (!this.included) {
          this.included = true;
          this.context.includeDynamicImport(this);
          this.scope.addAccessedDynamicImport(this);
        }
        this.source.include(context, includeChildrenRecursively);
      }
      initialise() {
        this.context.addDynamicImport(this);
      }
      render(code, options) {
        if (this.inlineNamespace) {
          const _ = options.compact ? "" : " ";
          const s = options.compact ? "" : ";";
          code.overwrite(this.start, this.end, `Promise.resolve().then(function${_}()${_}{${_}return ${this.inlineNamespace.getName()}${s}${_}})`, { contentOnly: true });
          return;
        }
        if (this.mechanism) {
          code.overwrite(this.start, findFirstOccurrenceOutsideComment(code.original, "(", this.start + 6) + 1, this.mechanism.left, { contentOnly: true });
          code.overwrite(this.end - 1, this.end, this.mechanism.right, { contentOnly: true });
        }
        this.source.render(code, options);
      }
      renderFinalResolution(code, resolution, namespaceExportName, options) {
        code.overwrite(this.source.start, this.source.end, resolution);
        if (namespaceExportName) {
          const _ = options.compact ? "" : " ";
          const s = options.compact ? "" : ";";
          code.prependLeft(this.end, `.then(function${_}(n)${_}{${_}return n.${namespaceExportName}${s}${_}})`);
        }
      }
      setExternalResolution(exportMode, resolution, options, pluginDriver, accessedGlobalsByScope) {
        this.resolution = resolution;
        const accessedGlobals = [...accessedImportGlobals[options.format] || []];
        let helper;
        ({ helper, mechanism: this.mechanism } = this.getDynamicImportMechanismAndHelper(resolution, exportMode, options, pluginDriver));
        if (helper) {
          accessedGlobals.push(helper);
        }
        if (accessedGlobals.length > 0) {
          this.scope.addAccessedGlobals(accessedGlobals, accessedGlobalsByScope);
        }
      }
      setInternalResolution(inlineNamespace) {
        this.inlineNamespace = inlineNamespace;
      }
      getDynamicImportMechanismAndHelper(resolution, exportMode, options, pluginDriver) {
        const mechanism = pluginDriver.hookFirstSync("renderDynamicImport", [
          {
            customResolution: typeof this.resolution === "string" ? this.resolution : null,
            format: options.format,
            moduleId: this.context.module.id,
            targetModuleId: this.resolution && typeof this.resolution !== "string" ? this.resolution.id : null
          }
        ]);
        if (mechanism) {
          return { helper: null, mechanism };
        }
        switch (options.format) {
          case "cjs": {
            const _ = options.compact ? "" : " ";
            const s = options.compact ? "" : ";";
            const leftStart = `Promise.resolve().then(function${_}()${_}{${_}return`;
            const helper = getInteropHelper(resolution, exportMode, options.interop);
            return {
              helper,
              mechanism: helper ? {
                left: `${leftStart} /*#__PURE__*/${helper}(require(`,
                right: `))${s}${_}})`
              } : {
                left: `${leftStart} require(`,
                right: `)${s}${_}})`
              }
            };
          }
          case "amd": {
            const _ = options.compact ? "" : " ";
            const resolve9 = options.compact ? "c" : "resolve";
            const reject = options.compact ? "e" : "reject";
            const helper = getInteropHelper(resolution, exportMode, options.interop);
            const resolveNamespace = helper ? `function${_}(m)${_}{${_}${resolve9}(/*#__PURE__*/${helper}(m));${_}}` : resolve9;
            return {
              helper,
              mechanism: {
                left: `new Promise(function${_}(${resolve9},${_}${reject})${_}{${_}require([`,
                right: `],${_}${resolveNamespace},${_}${reject})${_}})`
              }
            };
          }
          case "system":
            return {
              helper: null,
              mechanism: {
                left: "module.import(",
                right: ")"
              }
            };
          case "es":
            if (options.dynamicImportFunction) {
              return {
                helper: null,
                mechanism: {
                  left: `${options.dynamicImportFunction}(`,
                  right: ")"
                }
              };
            }
        }
        return { helper: null, mechanism: null };
      }
    };
    accessedImportGlobals = {
      amd: ["require"],
      cjs: ["require"],
      system: ["module"]
    };
    ImportNamespaceSpecifier = class extends NodeBase {
    };
    ImportSpecifier = class extends NodeBase {
    };
    LabeledStatement = class extends NodeBase {
      hasEffects(context) {
        const brokenFlow = context.brokenFlow;
        context.ignore.labels.add(this.label.name);
        if (this.body.hasEffects(context))
          return true;
        context.ignore.labels.delete(this.label.name);
        if (context.includedLabels.has(this.label.name)) {
          context.includedLabels.delete(this.label.name);
          context.brokenFlow = brokenFlow;
        }
        return false;
      }
      include(context, includeChildrenRecursively) {
        this.included = true;
        const brokenFlow = context.brokenFlow;
        this.body.include(context, includeChildrenRecursively);
        if (includeChildrenRecursively || context.includedLabels.has(this.label.name)) {
          this.label.include();
          context.includedLabels.delete(this.label.name);
          context.brokenFlow = brokenFlow;
        }
      }
      render(code, options) {
        if (this.label.included) {
          this.label.render(code, options);
        } else {
          code.remove(this.start, findNonWhiteSpace(code.original, findFirstOccurrenceOutsideComment(code.original, ":", this.label.end) + 1));
        }
        this.body.render(code, options);
      }
    };
    LogicalExpression = class extends NodeBase {
      constructor() {
        super(...arguments);
        this.expressionsToBeDeoptimized = [];
        this.isBranchResolutionAnalysed = false;
        this.usedBranch = null;
      }
      deoptimizeCache() {
        if (this.usedBranch !== null) {
          const unusedBranch = this.usedBranch === this.left ? this.right : this.left;
          this.usedBranch = null;
          unusedBranch.deoptimizePath(UNKNOWN_PATH);
          for (const expression of this.expressionsToBeDeoptimized) {
            expression.deoptimizeCache();
          }
        }
      }
      deoptimizePath(path6) {
        const usedBranch = this.getUsedBranch();
        if (usedBranch === null) {
          this.left.deoptimizePath(path6);
          this.right.deoptimizePath(path6);
        } else {
          usedBranch.deoptimizePath(path6);
        }
      }
      deoptimizeThisOnEventAtPath(event, path6, thisParameter, recursionTracker) {
        this.left.deoptimizeThisOnEventAtPath(event, path6, thisParameter, recursionTracker);
        this.right.deoptimizeThisOnEventAtPath(event, path6, thisParameter, recursionTracker);
      }
      getLiteralValueAtPath(path6, recursionTracker, origin) {
        const usedBranch = this.getUsedBranch();
        if (usedBranch === null)
          return UnknownValue;
        this.expressionsToBeDeoptimized.push(origin);
        return usedBranch.getLiteralValueAtPath(path6, recursionTracker, origin);
      }
      getReturnExpressionWhenCalledAtPath(path6, callOptions, recursionTracker, origin) {
        const usedBranch = this.getUsedBranch();
        if (usedBranch === null)
          return new MultiExpression([
            this.left.getReturnExpressionWhenCalledAtPath(path6, callOptions, recursionTracker, origin),
            this.right.getReturnExpressionWhenCalledAtPath(path6, callOptions, recursionTracker, origin)
          ]);
        this.expressionsToBeDeoptimized.push(origin);
        return usedBranch.getReturnExpressionWhenCalledAtPath(path6, callOptions, recursionTracker, origin);
      }
      hasEffects(context) {
        if (this.left.hasEffects(context)) {
          return true;
        }
        if (this.getUsedBranch() !== this.left) {
          return this.right.hasEffects(context);
        }
        return false;
      }
      hasEffectsWhenAccessedAtPath(path6, context) {
        const usedBranch = this.getUsedBranch();
        if (usedBranch === null) {
          return this.left.hasEffectsWhenAccessedAtPath(path6, context) || this.right.hasEffectsWhenAccessedAtPath(path6, context);
        }
        return usedBranch.hasEffectsWhenAccessedAtPath(path6, context);
      }
      hasEffectsWhenAssignedAtPath(path6, context) {
        const usedBranch = this.getUsedBranch();
        if (usedBranch === null) {
          return this.left.hasEffectsWhenAssignedAtPath(path6, context) || this.right.hasEffectsWhenAssignedAtPath(path6, context);
        }
        return usedBranch.hasEffectsWhenAssignedAtPath(path6, context);
      }
      hasEffectsWhenCalledAtPath(path6, callOptions, context) {
        const usedBranch = this.getUsedBranch();
        if (usedBranch === null) {
          return this.left.hasEffectsWhenCalledAtPath(path6, callOptions, context) || this.right.hasEffectsWhenCalledAtPath(path6, callOptions, context);
        }
        return usedBranch.hasEffectsWhenCalledAtPath(path6, callOptions, context);
      }
      include(context, includeChildrenRecursively) {
        this.included = true;
        const usedBranch = this.getUsedBranch();
        if (includeChildrenRecursively || usedBranch === this.right && this.left.shouldBeIncluded(context) || usedBranch === null) {
          this.left.include(context, includeChildrenRecursively);
          this.right.include(context, includeChildrenRecursively);
        } else {
          usedBranch.include(context, includeChildrenRecursively);
        }
      }
      render(code, options, { isCalleeOfRenderedParent, preventASI, renderedParentType, renderedSurroundingElement } = BLANK) {
        if (!this.left.included || !this.right.included) {
          const operatorPos = findFirstOccurrenceOutsideComment(code.original, this.operator, this.left.end);
          if (this.right.included) {
            const removePos = findNonWhiteSpace(code.original, operatorPos + 2);
            code.remove(this.start, removePos);
            if (preventASI) {
              removeLineBreaks(code, removePos, this.right.start);
            }
          } else {
            code.remove(operatorPos, this.end);
          }
          removeAnnotations(this, code);
          this.getUsedBranch().render(code, options, {
            isCalleeOfRenderedParent,
            preventASI,
            renderedParentType: renderedParentType || this.parent.type,
            renderedSurroundingElement: renderedSurroundingElement || this.parent.type
          });
        } else {
          this.left.render(code, options, {
            preventASI,
            renderedSurroundingElement
          });
          this.right.render(code, options);
        }
      }
      getUsedBranch() {
        if (!this.isBranchResolutionAnalysed) {
          this.isBranchResolutionAnalysed = true;
          const leftValue = this.left.getLiteralValueAtPath(EMPTY_PATH, SHARED_RECURSION_TRACKER, this);
          if (leftValue === UnknownValue) {
            return null;
          } else {
            this.usedBranch = this.operator === "||" && leftValue || this.operator === "&&" && !leftValue || this.operator === "??" && leftValue != null ? this.left : this.right;
          }
        }
        return this.usedBranch;
      }
    };
    (function(Errors2) {
      Errors2["ALREADY_CLOSED"] = "ALREADY_CLOSED";
      Errors2["ASSET_NOT_FINALISED"] = "ASSET_NOT_FINALISED";
      Errors2["ASSET_NOT_FOUND"] = "ASSET_NOT_FOUND";
      Errors2["ASSET_SOURCE_ALREADY_SET"] = "ASSET_SOURCE_ALREADY_SET";
      Errors2["ASSET_SOURCE_MISSING"] = "ASSET_SOURCE_MISSING";
      Errors2["BAD_LOADER"] = "BAD_LOADER";
      Errors2["CANNOT_EMIT_FROM_OPTIONS_HOOK"] = "CANNOT_EMIT_FROM_OPTIONS_HOOK";
      Errors2["CHUNK_NOT_GENERATED"] = "CHUNK_NOT_GENERATED";
      Errors2["CHUNK_INVALID"] = "CHUNK_INVALID";
      Errors2["CIRCULAR_REEXPORT"] = "CIRCULAR_REEXPORT";
      Errors2["CYCLIC_CROSS_CHUNK_REEXPORT"] = "CYCLIC_CROSS_CHUNK_REEXPORT";
      Errors2["DEPRECATED_FEATURE"] = "DEPRECATED_FEATURE";
      Errors2["EXTERNAL_SYNTHETIC_EXPORTS"] = "EXTERNAL_SYNTHETIC_EXPORTS";
      Errors2["FILE_NAME_CONFLICT"] = "FILE_NAME_CONFLICT";
      Errors2["FILE_NOT_FOUND"] = "FILE_NOT_FOUND";
      Errors2["INPUT_HOOK_IN_OUTPUT_PLUGIN"] = "INPUT_HOOK_IN_OUTPUT_PLUGIN";
      Errors2["INVALID_CHUNK"] = "INVALID_CHUNK";
      Errors2["INVALID_EXPORT_OPTION"] = "INVALID_EXPORT_OPTION";
      Errors2["INVALID_EXTERNAL_ID"] = "INVALID_EXTERNAL_ID";
      Errors2["INVALID_OPTION"] = "INVALID_OPTION";
      Errors2["INVALID_PLUGIN_HOOK"] = "INVALID_PLUGIN_HOOK";
      Errors2["INVALID_ROLLUP_PHASE"] = "INVALID_ROLLUP_PHASE";
      Errors2["MISSING_EXPORT"] = "MISSING_EXPORT";
      Errors2["MISSING_IMPLICIT_DEPENDANT"] = "MISSING_IMPLICIT_DEPENDANT";
      Errors2["MIXED_EXPORTS"] = "MIXED_EXPORTS";
      Errors2["NAMESPACE_CONFLICT"] = "NAMESPACE_CONFLICT";
      Errors2["AMBIGUOUS_EXTERNAL_NAMESPACES"] = "AMBIGUOUS_EXTERNAL_NAMESPACES";
      Errors2["NO_TRANSFORM_MAP_OR_AST_WITHOUT_CODE"] = "NO_TRANSFORM_MAP_OR_AST_WITHOUT_CODE";
      Errors2["PLUGIN_ERROR"] = "PLUGIN_ERROR";
      Errors2["PREFER_NAMED_EXPORTS"] = "PREFER_NAMED_EXPORTS";
      Errors2["SYNTHETIC_NAMED_EXPORTS_NEED_NAMESPACE_EXPORT"] = "SYNTHETIC_NAMED_EXPORTS_NEED_NAMESPACE_EXPORT";
      Errors2["UNEXPECTED_NAMED_IMPORT"] = "UNEXPECTED_NAMED_IMPORT";
      Errors2["UNRESOLVED_ENTRY"] = "UNRESOLVED_ENTRY";
      Errors2["UNRESOLVED_IMPORT"] = "UNRESOLVED_IMPORT";
      Errors2["VALIDATION_ERROR"] = "VALIDATION_ERROR";
    })(Errors || (Errors = {}));
    ASSET_PREFIX = "ROLLUP_ASSET_URL_";
    CHUNK_PREFIX = "ROLLUP_CHUNK_URL_";
    FILE_PREFIX = "ROLLUP_FILE_URL_";
    MetaProperty = class extends NodeBase {
      addAccessedGlobals(format, accessedGlobalsByScope) {
        const metaProperty = this.metaProperty;
        const accessedGlobals = (metaProperty && (metaProperty.startsWith(FILE_PREFIX) || metaProperty.startsWith(ASSET_PREFIX) || metaProperty.startsWith(CHUNK_PREFIX)) ? accessedFileUrlGlobals : accessedMetaUrlGlobals)[format];
        if (accessedGlobals.length > 0) {
          this.scope.addAccessedGlobals(accessedGlobals, accessedGlobalsByScope);
        }
      }
      getReferencedFileName(outputPluginDriver) {
        const metaProperty = this.metaProperty;
        if (metaProperty && metaProperty.startsWith(FILE_PREFIX)) {
          return outputPluginDriver.getFileName(metaProperty.substr(FILE_PREFIX.length));
        }
        return null;
      }
      hasEffects() {
        return false;
      }
      hasEffectsWhenAccessedAtPath(path6) {
        return path6.length > 1;
      }
      include() {
        if (!this.included) {
          this.included = true;
          if (this.meta.name === "import") {
            this.context.addImportMeta(this);
            const parent = this.parent;
            this.metaProperty = parent instanceof MemberExpression && typeof parent.propertyKey === "string" ? parent.propertyKey : null;
          }
        }
      }
      renderFinalMechanism(code, chunkId, format, outputPluginDriver) {
        var _a;
        const parent = this.parent;
        const metaProperty = this.metaProperty;
        if (metaProperty && (metaProperty.startsWith(FILE_PREFIX) || metaProperty.startsWith(ASSET_PREFIX) || metaProperty.startsWith(CHUNK_PREFIX))) {
          let referenceId = null;
          let assetReferenceId = null;
          let chunkReferenceId = null;
          let fileName;
          if (metaProperty.startsWith(FILE_PREFIX)) {
            referenceId = metaProperty.substr(FILE_PREFIX.length);
            fileName = outputPluginDriver.getFileName(referenceId);
          } else if (metaProperty.startsWith(ASSET_PREFIX)) {
            warnDeprecation(`Using the "${ASSET_PREFIX}" prefix to reference files is deprecated. Use the "${FILE_PREFIX}" prefix instead.`, true, this.context.options);
            assetReferenceId = metaProperty.substr(ASSET_PREFIX.length);
            fileName = outputPluginDriver.getFileName(assetReferenceId);
          } else {
            warnDeprecation(`Using the "${CHUNK_PREFIX}" prefix to reference files is deprecated. Use the "${FILE_PREFIX}" prefix instead.`, true, this.context.options);
            chunkReferenceId = metaProperty.substr(CHUNK_PREFIX.length);
            fileName = outputPluginDriver.getFileName(chunkReferenceId);
          }
          const relativePath3 = normalize2((0, import_path11.relative)((0, import_path11.dirname)(chunkId), fileName));
          let replacement2;
          if (assetReferenceId !== null) {
            replacement2 = outputPluginDriver.hookFirstSync("resolveAssetUrl", [
              {
                assetFileName: fileName,
                chunkId,
                format,
                moduleId: this.context.module.id,
                relativeAssetPath: relativePath3
              }
            ]);
          }
          if (!replacement2) {
            replacement2 = outputPluginDriver.hookFirstSync("resolveFileUrl", [
              {
                assetReferenceId,
                chunkId,
                chunkReferenceId,
                fileName,
                format,
                moduleId: this.context.module.id,
                referenceId: referenceId || assetReferenceId || chunkReferenceId,
                relativePath: relativePath3
              }
            ]) || relativeUrlMechanisms[format](relativePath3);
          }
          code.overwrite(parent.start, parent.end, replacement2, { contentOnly: true });
          return;
        }
        const replacement = outputPluginDriver.hookFirstSync("resolveImportMeta", [
          metaProperty,
          {
            chunkId,
            format,
            moduleId: this.context.module.id
          }
        ]) || ((_a = importMetaMechanisms[format]) === null || _a === void 0 ? void 0 : _a.call(importMetaMechanisms, metaProperty, chunkId));
        if (typeof replacement === "string") {
          if (parent instanceof MemberExpression) {
            code.overwrite(parent.start, parent.end, replacement, { contentOnly: true });
          } else {
            code.overwrite(this.start, this.end, replacement, { contentOnly: true });
          }
        }
      }
    };
    accessedMetaUrlGlobals = {
      amd: ["document", "module", "URL"],
      cjs: ["document", "require", "URL"],
      es: [],
      iife: ["document", "URL"],
      system: ["module"],
      umd: ["document", "require", "URL"]
    };
    accessedFileUrlGlobals = {
      amd: ["document", "require", "URL"],
      cjs: ["document", "require", "URL"],
      es: [],
      iife: ["document", "URL"],
      system: ["module", "URL"],
      umd: ["document", "require", "URL"]
    };
    getResolveUrl = (path6, URL2 = "URL") => `new ${URL2}(${path6}).href`;
    getRelativeUrlFromDocument = (relativePath3, umd2 = false) => getResolveUrl(`'${relativePath3}', ${umd2 ? `typeof document === 'undefined' ? location.href : ` : ""}document.currentScript && document.currentScript.src || document.baseURI`);
    getGenericImportMetaMechanism = (getUrl) => (prop, chunkId) => {
      const urlMechanism = getUrl(chunkId);
      return prop === null ? `({ url: ${urlMechanism} })` : prop === "url" ? urlMechanism : "undefined";
    };
    getUrlFromDocument = (chunkId, umd2 = false) => `${umd2 ? `typeof document === 'undefined' ? location.href : ` : ""}(document.currentScript && document.currentScript.src || new URL('${chunkId}', document.baseURI).href)`;
    relativeUrlMechanisms = {
      amd: (relativePath3) => {
        if (relativePath3[0] !== ".")
          relativePath3 = "./" + relativePath3;
        return getResolveUrl(`require.toUrl('${relativePath3}'), document.baseURI`);
      },
      cjs: (relativePath3) => `(typeof document === 'undefined' ? ${getResolveUrl(`'file:' + __dirname + '/${relativePath3}'`, `(require('u' + 'rl').URL)`)} : ${getRelativeUrlFromDocument(relativePath3)})`,
      es: (relativePath3) => getResolveUrl(`'${relativePath3}', import.meta.url`),
      iife: (relativePath3) => getRelativeUrlFromDocument(relativePath3),
      system: (relativePath3) => getResolveUrl(`'${relativePath3}', module.meta.url`),
      umd: (relativePath3) => `(typeof document === 'undefined' && typeof location === 'undefined' ? ${getResolveUrl(`'file:' + __dirname + '/${relativePath3}'`, `(require('u' + 'rl').URL)`)} : ${getRelativeUrlFromDocument(relativePath3, true)})`
    };
    importMetaMechanisms = {
      amd: getGenericImportMetaMechanism(() => getResolveUrl(`module.uri, document.baseURI`)),
      cjs: getGenericImportMetaMechanism((chunkId) => `(typeof document === 'undefined' ? ${getResolveUrl(`'file:' + __filename`, `(require('u' + 'rl').URL)`)} : ${getUrlFromDocument(chunkId)})`),
      iife: getGenericImportMetaMechanism((chunkId) => getUrlFromDocument(chunkId)),
      system: (prop) => prop === null ? `module.meta` : `module.meta.${prop}`,
      umd: getGenericImportMetaMechanism((chunkId) => `(typeof document === 'undefined' && typeof location === 'undefined' ? ${getResolveUrl(`'file:' + __filename`, `(require('u' + 'rl').URL)`)} : ${getUrlFromDocument(chunkId, true)})`)
    };
    NewExpression = class extends NodeBase {
      constructor() {
        super(...arguments);
        this.deoptimized = false;
      }
      hasEffects(context) {
        if (!this.deoptimized)
          this.applyDeoptimizations();
        for (const argument of this.arguments) {
          if (argument.hasEffects(context))
            return true;
        }
        if (this.context.options.treeshake.annotations && this.annotations)
          return false;
        return this.callee.hasEffects(context) || this.callee.hasEffectsWhenCalledAtPath(EMPTY_PATH, this.callOptions, context);
      }
      hasEffectsWhenAccessedAtPath(path6) {
        return path6.length > 0;
      }
      initialise() {
        this.callOptions = {
          args: this.arguments,
          thisParam: null,
          withNew: true
        };
      }
      applyDeoptimizations() {
        this.deoptimized = true;
        for (const argument of this.arguments) {
          argument.deoptimizePath(UNKNOWN_PATH);
        }
        this.context.requestTreeshakingPass();
      }
    };
    ObjectExpression = class extends NodeBase {
      constructor() {
        super(...arguments);
        this.objectEntity = null;
      }
      deoptimizeCache() {
        this.getObjectEntity().deoptimizeAllProperties();
      }
      deoptimizePath(path6) {
        this.getObjectEntity().deoptimizePath(path6);
      }
      deoptimizeThisOnEventAtPath(event, path6, thisParameter, recursionTracker) {
        this.getObjectEntity().deoptimizeThisOnEventAtPath(event, path6, thisParameter, recursionTracker);
      }
      getLiteralValueAtPath(path6, recursionTracker, origin) {
        return this.getObjectEntity().getLiteralValueAtPath(path6, recursionTracker, origin);
      }
      getReturnExpressionWhenCalledAtPath(path6, callOptions, recursionTracker, origin) {
        return this.getObjectEntity().getReturnExpressionWhenCalledAtPath(path6, callOptions, recursionTracker, origin);
      }
      hasEffectsWhenAccessedAtPath(path6, context) {
        return this.getObjectEntity().hasEffectsWhenAccessedAtPath(path6, context);
      }
      hasEffectsWhenAssignedAtPath(path6, context) {
        return this.getObjectEntity().hasEffectsWhenAssignedAtPath(path6, context);
      }
      hasEffectsWhenCalledAtPath(path6, callOptions, context) {
        return this.getObjectEntity().hasEffectsWhenCalledAtPath(path6, callOptions, context);
      }
      render(code, options, { renderedSurroundingElement } = BLANK) {
        super.render(code, options);
        if (renderedSurroundingElement === ExpressionStatement$1 || renderedSurroundingElement === ArrowFunctionExpression$1) {
          code.appendRight(this.start, "(");
          code.prependLeft(this.end, ")");
        }
      }
      getObjectEntity() {
        if (this.objectEntity !== null) {
          return this.objectEntity;
        }
        let prototype = OBJECT_PROTOTYPE;
        const properties = [];
        for (const property2 of this.properties) {
          if (property2 instanceof SpreadElement) {
            properties.push({ key: UnknownKey, kind: "init", property: property2 });
            continue;
          }
          let key;
          if (property2.computed) {
            const keyValue = property2.key.getLiteralValueAtPath(EMPTY_PATH, SHARED_RECURSION_TRACKER, this);
            if (keyValue === UnknownValue) {
              properties.push({ key: UnknownKey, kind: property2.kind, property: property2 });
              continue;
            } else {
              key = String(keyValue);
            }
          } else {
            key = property2.key instanceof Identifier ? property2.key.name : String(property2.key.value);
            if (key === "__proto__" && property2.kind === "init") {
              prototype = property2.value instanceof Literal && property2.value.value === null ? null : property2.value;
              continue;
            }
          }
          properties.push({ key, kind: property2.kind, property: property2 });
        }
        return this.objectEntity = new ObjectEntity(properties, prototype);
      }
    };
    PrivateIdentifier = class extends NodeBase {
    };
    Property = class extends MethodBase {
      constructor() {
        super(...arguments);
        this.deoptimized = false;
        this.declarationInit = null;
      }
      declare(kind, init) {
        this.declarationInit = init;
        return this.value.declare(kind, UNKNOWN_EXPRESSION);
      }
      hasEffects(context) {
        if (!this.deoptimized)
          this.applyDeoptimizations();
        const propertyReadSideEffects = this.context.options.treeshake.propertyReadSideEffects;
        return this.parent.type === "ObjectPattern" && propertyReadSideEffects === "always" || this.key.hasEffects(context) || this.value.hasEffects(context);
      }
      markDeclarationReached() {
        this.value.markDeclarationReached();
      }
      render(code, options) {
        if (!this.shorthand) {
          this.key.render(code, options);
        }
        this.value.render(code, options, { isShorthandProperty: this.shorthand });
      }
      applyDeoptimizations() {
        this.deoptimized = true;
        if (this.declarationInit !== null) {
          this.declarationInit.deoptimizePath([UnknownKey, UnknownKey]);
          this.context.requestTreeshakingPass();
        }
      }
    };
    PropertyDefinition = class extends NodeBase {
      deoptimizePath(path6) {
        var _a;
        (_a = this.value) === null || _a === void 0 ? void 0 : _a.deoptimizePath(path6);
      }
      deoptimizeThisOnEventAtPath(event, path6, thisParameter, recursionTracker) {
        var _a;
        (_a = this.value) === null || _a === void 0 ? void 0 : _a.deoptimizeThisOnEventAtPath(event, path6, thisParameter, recursionTracker);
      }
      getLiteralValueAtPath(path6, recursionTracker, origin) {
        return this.value ? this.value.getLiteralValueAtPath(path6, recursionTracker, origin) : UnknownValue;
      }
      getReturnExpressionWhenCalledAtPath(path6, callOptions, recursionTracker, origin) {
        return this.value ? this.value.getReturnExpressionWhenCalledAtPath(path6, callOptions, recursionTracker, origin) : UNKNOWN_EXPRESSION;
      }
      hasEffects(context) {
        return this.key.hasEffects(context) || this.static && this.value !== null && this.value.hasEffects(context);
      }
      hasEffectsWhenAccessedAtPath(path6, context) {
        return !this.value || this.value.hasEffectsWhenAccessedAtPath(path6, context);
      }
      hasEffectsWhenAssignedAtPath(path6, context) {
        return !this.value || this.value.hasEffectsWhenAssignedAtPath(path6, context);
      }
      hasEffectsWhenCalledAtPath(path6, callOptions, context) {
        return !this.value || this.value.hasEffectsWhenCalledAtPath(path6, callOptions, context);
      }
    };
    ReturnStatement = class extends NodeBase {
      hasEffects(context) {
        if (!context.ignore.returnYield || this.argument !== null && this.argument.hasEffects(context))
          return true;
        context.brokenFlow = BROKEN_FLOW_ERROR_RETURN_LABEL;
        return false;
      }
      include(context, includeChildrenRecursively) {
        this.included = true;
        if (this.argument) {
          this.argument.include(context, includeChildrenRecursively);
        }
        context.brokenFlow = BROKEN_FLOW_ERROR_RETURN_LABEL;
      }
      initialise() {
        this.scope.addReturnExpression(this.argument || UNKNOWN_EXPRESSION);
      }
      render(code, options) {
        if (this.argument) {
          this.argument.render(code, options, { preventASI: true });
          if (this.argument.start === this.start + 6) {
            code.prependLeft(this.start + 6, " ");
          }
        }
      }
    };
    SequenceExpression = class extends NodeBase {
      deoptimizePath(path6) {
        this.expressions[this.expressions.length - 1].deoptimizePath(path6);
      }
      deoptimizeThisOnEventAtPath(event, path6, thisParameter, recursionTracker) {
        this.expressions[this.expressions.length - 1].deoptimizeThisOnEventAtPath(event, path6, thisParameter, recursionTracker);
      }
      getLiteralValueAtPath(path6, recursionTracker, origin) {
        return this.expressions[this.expressions.length - 1].getLiteralValueAtPath(path6, recursionTracker, origin);
      }
      hasEffects(context) {
        for (const expression of this.expressions) {
          if (expression.hasEffects(context))
            return true;
        }
        return false;
      }
      hasEffectsWhenAccessedAtPath(path6, context) {
        return path6.length > 0 && this.expressions[this.expressions.length - 1].hasEffectsWhenAccessedAtPath(path6, context);
      }
      hasEffectsWhenAssignedAtPath(path6, context) {
        return this.expressions[this.expressions.length - 1].hasEffectsWhenAssignedAtPath(path6, context);
      }
      hasEffectsWhenCalledAtPath(path6, callOptions, context) {
        return this.expressions[this.expressions.length - 1].hasEffectsWhenCalledAtPath(path6, callOptions, context);
      }
      include(context, includeChildrenRecursively) {
        this.included = true;
        const lastExpression = this.expressions[this.expressions.length - 1];
        for (const expression of this.expressions) {
          if (includeChildrenRecursively || expression === lastExpression && !(this.parent instanceof ExpressionStatement) || expression.shouldBeIncluded(context))
            expression.include(context, includeChildrenRecursively);
        }
      }
      render(code, options, { renderedParentType, isCalleeOfRenderedParent, preventASI } = BLANK) {
        let includedNodes = 0;
        let lastSeparatorPos = null;
        const lastNode = this.expressions[this.expressions.length - 1];
        for (const { node, separator, start, end } of getCommaSeparatedNodesWithBoundaries(this.expressions, code, this.start, this.end)) {
          if (!node.included) {
            treeshakeNode(node, code, start, end);
            continue;
          }
          includedNodes++;
          lastSeparatorPos = separator;
          if (includedNodes === 1 && preventASI) {
            removeLineBreaks(code, start, node.start);
          }
          if (includedNodes === 1) {
            const parentType = renderedParentType || this.parent.type;
            node.render(code, options, {
              isCalleeOfRenderedParent: isCalleeOfRenderedParent && node === lastNode,
              renderedParentType: parentType,
              renderedSurroundingElement: parentType
            });
          } else {
            node.render(code, options);
          }
        }
        if (lastSeparatorPos) {
          code.remove(lastSeparatorPos, this.end);
        }
      }
    };
    Super = class extends NodeBase {
      bind() {
        this.variable = this.scope.findVariable("this");
      }
      deoptimizePath(path6) {
        this.variable.deoptimizePath(path6);
      }
      include() {
        if (!this.included) {
          this.included = true;
          this.context.includeVariableInModule(this.variable);
        }
      }
    };
    SwitchCase = class extends NodeBase {
      hasEffects(context) {
        if (this.test && this.test.hasEffects(context))
          return true;
        for (const node of this.consequent) {
          if (context.brokenFlow)
            break;
          if (node.hasEffects(context))
            return true;
        }
        return false;
      }
      include(context, includeChildrenRecursively) {
        this.included = true;
        if (this.test)
          this.test.include(context, includeChildrenRecursively);
        for (const node of this.consequent) {
          if (includeChildrenRecursively || node.shouldBeIncluded(context))
            node.include(context, includeChildrenRecursively);
        }
      }
      render(code, options, nodeRenderOptions) {
        if (this.consequent.length) {
          this.test && this.test.render(code, options);
          const testEnd = this.test ? this.test.end : findFirstOccurrenceOutsideComment(code.original, "default", this.start) + 7;
          const consequentStart = findFirstOccurrenceOutsideComment(code.original, ":", testEnd) + 1;
          renderStatementList(this.consequent, code, consequentStart, nodeRenderOptions.end, options);
        } else {
          super.render(code, options);
        }
      }
    };
    SwitchCase.prototype.needsBoundaries = true;
    SwitchStatement = class extends NodeBase {
      createScope(parentScope) {
        this.scope = new BlockScope(parentScope);
      }
      hasEffects(context) {
        if (this.discriminant.hasEffects(context))
          return true;
        const { brokenFlow, ignore: { breaks } } = context;
        let minBrokenFlow = Infinity;
        context.ignore.breaks = true;
        for (const switchCase of this.cases) {
          if (switchCase.hasEffects(context))
            return true;
          minBrokenFlow = context.brokenFlow < minBrokenFlow ? context.brokenFlow : minBrokenFlow;
          context.brokenFlow = brokenFlow;
        }
        if (this.defaultCase !== null && !(minBrokenFlow === BROKEN_FLOW_BREAK_CONTINUE)) {
          context.brokenFlow = minBrokenFlow;
        }
        context.ignore.breaks = breaks;
        return false;
      }
      include(context, includeChildrenRecursively) {
        this.included = true;
        this.discriminant.include(context, includeChildrenRecursively);
        const { brokenFlow } = context;
        let minBrokenFlow = Infinity;
        let isCaseIncluded = includeChildrenRecursively || this.defaultCase !== null && this.defaultCase < this.cases.length - 1;
        for (let caseIndex = this.cases.length - 1; caseIndex >= 0; caseIndex--) {
          const switchCase = this.cases[caseIndex];
          if (switchCase.included) {
            isCaseIncluded = true;
          }
          if (!isCaseIncluded) {
            const hasEffectsContext = createHasEffectsContext();
            hasEffectsContext.ignore.breaks = true;
            isCaseIncluded = switchCase.hasEffects(hasEffectsContext);
          }
          if (isCaseIncluded) {
            switchCase.include(context, includeChildrenRecursively);
            minBrokenFlow = minBrokenFlow < context.brokenFlow ? minBrokenFlow : context.brokenFlow;
            context.brokenFlow = brokenFlow;
          } else {
            minBrokenFlow = brokenFlow;
          }
        }
        if (isCaseIncluded && this.defaultCase !== null && !(minBrokenFlow === BROKEN_FLOW_BREAK_CONTINUE)) {
          context.brokenFlow = minBrokenFlow;
        }
      }
      initialise() {
        for (let caseIndex = 0; caseIndex < this.cases.length; caseIndex++) {
          if (this.cases[caseIndex].test === null) {
            this.defaultCase = caseIndex;
            return;
          }
        }
        this.defaultCase = null;
      }
      render(code, options) {
        this.discriminant.render(code, options);
        if (this.cases.length > 0) {
          renderStatementList(this.cases, code, this.cases[0].start, this.end - 1, options);
        }
      }
    };
    TaggedTemplateExpression = class extends NodeBase {
      bind() {
        super.bind();
        if (this.tag.type === Identifier$1) {
          const name = this.tag.name;
          const variable = this.scope.findVariable(name);
          if (variable.isNamespace) {
            this.context.warn({
              code: "CANNOT_CALL_NAMESPACE",
              message: `Cannot call a namespace ('${name}')`
            }, this.start);
          }
        }
      }
      hasEffects(context) {
        return super.hasEffects(context) || this.tag.hasEffectsWhenCalledAtPath(EMPTY_PATH, this.callOptions, context);
      }
      initialise() {
        this.callOptions = {
          args: NO_ARGS,
          thisParam: null,
          withNew: false
        };
      }
      render(code, options) {
        this.tag.render(code, options, { isCalleeOfRenderedParent: true });
        this.quasi.render(code, options);
      }
    };
    TemplateElement = class extends NodeBase {
      // Do not try to bind value
      bind() {
      }
      hasEffects() {
        return false;
      }
      include() {
        this.included = true;
      }
      parseNode(esTreeNode) {
        this.value = esTreeNode.value;
        super.parseNode(esTreeNode);
      }
      render() {
      }
    };
    UndefinedVariable = class extends Variable {
      constructor() {
        super("undefined");
      }
      getLiteralValueAtPath() {
        return void 0;
      }
    };
    ExportDefaultVariable = class _ExportDefaultVariable extends LocalVariable {
      constructor(name, exportDefaultDeclaration, context) {
        super(name, exportDefaultDeclaration, exportDefaultDeclaration.declaration, context);
        this.hasId = false;
        this.originalId = null;
        this.originalVariable = null;
        const declaration = exportDefaultDeclaration.declaration;
        if ((declaration instanceof FunctionDeclaration || declaration instanceof ClassDeclaration) && declaration.id) {
          this.hasId = true;
          this.originalId = declaration.id;
        } else if (declaration instanceof Identifier) {
          this.originalId = declaration;
        }
      }
      addReference(identifier) {
        if (!this.hasId) {
          this.name = identifier.name;
        }
      }
      getAssignedVariableName() {
        return this.originalId && this.originalId.name || null;
      }
      getBaseVariableName() {
        const original = this.getOriginalVariable();
        if (original === this) {
          return super.getBaseVariableName();
        } else {
          return original.getBaseVariableName();
        }
      }
      getDirectOriginalVariable() {
        return this.originalId && (this.hasId || !(this.originalId.isPossibleTDZ() || this.originalId.variable.isReassigned || this.originalId.variable instanceof UndefinedVariable || // this avoids a circular dependency
        "syntheticNamespace" in this.originalId.variable)) ? this.originalId.variable : null;
      }
      getName() {
        const original = this.getOriginalVariable();
        if (original === this) {
          return super.getName();
        } else {
          return original.getName();
        }
      }
      getOriginalVariable() {
        if (this.originalVariable)
          return this.originalVariable;
        let original = this;
        let currentVariable;
        const checkedVariables = /* @__PURE__ */ new Set();
        do {
          checkedVariables.add(original);
          currentVariable = original;
          original = currentVariable.getDirectOriginalVariable();
        } while (original instanceof _ExportDefaultVariable && !checkedVariables.has(original));
        return this.originalVariable = original || currentVariable;
      }
    };
    ModuleScope = class extends ChildScope {
      constructor(parent, context) {
        super(parent);
        this.context = context;
        this.variables.set("this", new LocalVariable("this", null, UNDEFINED_EXPRESSION, context));
      }
      addExportDefaultDeclaration(name, exportDefaultDeclaration, context) {
        const variable = new ExportDefaultVariable(name, exportDefaultDeclaration, context);
        this.variables.set("default", variable);
        return variable;
      }
      addNamespaceMemberAccess() {
      }
      deconflict(format, exportNamesByVariable, accessedGlobalsByScope) {
        for (const scope of this.children)
          scope.deconflict(format, exportNamesByVariable, accessedGlobalsByScope);
      }
      findLexicalBoundary() {
        return this;
      }
      findVariable(name) {
        const knownVariable = this.variables.get(name) || this.accessedOutsideVariables.get(name);
        if (knownVariable) {
          return knownVariable;
        }
        const variable = this.context.traceVariable(name) || this.parent.findVariable(name);
        if (variable instanceof GlobalVariable) {
          this.accessedOutsideVariables.set(name, variable);
        }
        return variable;
      }
    };
    ThisExpression = class extends NodeBase {
      bind() {
        this.variable = this.scope.findVariable("this");
      }
      deoptimizePath(path6) {
        this.variable.deoptimizePath(path6);
      }
      deoptimizeThisOnEventAtPath(event, path6, thisParameter, recursionTracker) {
        this.variable.deoptimizeThisOnEventAtPath(
          event,
          path6,
          // We rewrite the parameter so that a ThisVariable can detect self-mutations
          thisParameter === this ? this.variable : thisParameter,
          recursionTracker
        );
      }
      hasEffectsWhenAccessedAtPath(path6, context) {
        return path6.length > 0 && this.variable.hasEffectsWhenAccessedAtPath(path6, context);
      }
      hasEffectsWhenAssignedAtPath(path6, context) {
        return this.variable.hasEffectsWhenAssignedAtPath(path6, context);
      }
      include() {
        if (!this.included) {
          this.included = true;
          this.context.includeVariableInModule(this.variable);
        }
      }
      initialise() {
        this.alias = this.scope.findLexicalBoundary() instanceof ModuleScope ? this.context.moduleContext : null;
        if (this.alias === "undefined") {
          this.context.warn({
            code: "THIS_IS_UNDEFINED",
            message: `The 'this' keyword is equivalent to 'undefined' at the top level of an ES module, and has been rewritten`,
            url: `https://rollupjs.org/guide/en/#error-this-is-undefined`
          }, this.start);
        }
      }
      render(code) {
        if (this.alias !== null) {
          code.overwrite(this.start, this.end, this.alias, {
            contentOnly: false,
            storeName: true
          });
        }
      }
    };
    ThrowStatement = class extends NodeBase {
      hasEffects() {
        return true;
      }
      include(context, includeChildrenRecursively) {
        this.included = true;
        this.argument.include(context, includeChildrenRecursively);
        context.brokenFlow = BROKEN_FLOW_ERROR_RETURN_LABEL;
      }
      render(code, options) {
        this.argument.render(code, options, { preventASI: true });
        if (this.argument.start === this.start + 5) {
          code.prependLeft(this.start + 5, " ");
        }
      }
    };
    TryStatement = class extends NodeBase {
      constructor() {
        super(...arguments);
        this.directlyIncluded = false;
        this.includedLabelsAfterBlock = null;
      }
      hasEffects(context) {
        return (this.context.options.treeshake.tryCatchDeoptimization ? this.block.body.length > 0 : this.block.hasEffects(context)) || this.finalizer !== null && this.finalizer.hasEffects(context);
      }
      include(context, includeChildrenRecursively) {
        var _a;
        const tryCatchDeoptimization = (_a = this.context.options.treeshake) === null || _a === void 0 ? void 0 : _a.tryCatchDeoptimization;
        const { brokenFlow } = context;
        if (!this.directlyIncluded || !tryCatchDeoptimization) {
          this.included = true;
          this.directlyIncluded = true;
          this.block.include(context, tryCatchDeoptimization ? INCLUDE_PARAMETERS : includeChildrenRecursively);
          if (context.includedLabels.size > 0) {
            this.includedLabelsAfterBlock = [...context.includedLabels];
          }
          context.brokenFlow = brokenFlow;
        } else if (this.includedLabelsAfterBlock) {
          for (const label of this.includedLabelsAfterBlock) {
            context.includedLabels.add(label);
          }
        }
        if (this.handler !== null) {
          this.handler.include(context, includeChildrenRecursively);
          context.brokenFlow = brokenFlow;
        }
        if (this.finalizer !== null) {
          this.finalizer.include(context, includeChildrenRecursively);
        }
      }
    };
    unaryOperators = {
      "!": (value) => !value,
      "+": (value) => +value,
      "-": (value) => -value,
      delete: () => UnknownValue,
      typeof: (value) => typeof value,
      void: () => void 0,
      "~": (value) => ~value
    };
    UnaryExpression = class extends NodeBase {
      constructor() {
        super(...arguments);
        this.deoptimized = false;
      }
      getLiteralValueAtPath(path6, recursionTracker, origin) {
        if (path6.length > 0)
          return UnknownValue;
        const argumentValue = this.argument.getLiteralValueAtPath(EMPTY_PATH, recursionTracker, origin);
        if (argumentValue === UnknownValue)
          return UnknownValue;
        return unaryOperators[this.operator](argumentValue);
      }
      hasEffects(context) {
        if (!this.deoptimized)
          this.applyDeoptimizations();
        if (this.operator === "typeof" && this.argument instanceof Identifier)
          return false;
        return this.argument.hasEffects(context) || this.operator === "delete" && this.argument.hasEffectsWhenAssignedAtPath(EMPTY_PATH, context);
      }
      hasEffectsWhenAccessedAtPath(path6) {
        if (this.operator === "void") {
          return path6.length > 0;
        }
        return path6.length > 1;
      }
      applyDeoptimizations() {
        this.deoptimized = true;
        if (this.operator === "delete") {
          this.argument.deoptimizePath(EMPTY_PATH);
          this.context.requestTreeshakingPass();
        }
      }
    };
    UnknownNode = class extends NodeBase {
      hasEffects() {
        return true;
      }
      include(context) {
        super.include(context, true);
      }
    };
    UpdateExpression = class extends NodeBase {
      constructor() {
        super(...arguments);
        this.deoptimized = false;
      }
      hasEffects(context) {
        if (!this.deoptimized)
          this.applyDeoptimizations();
        return this.argument.hasEffects(context) || this.argument.hasEffectsWhenAssignedAtPath(EMPTY_PATH, context);
      }
      hasEffectsWhenAccessedAtPath(path6) {
        return path6.length > 1;
      }
      render(code, options) {
        this.argument.render(code, options);
        if (options.format === "system") {
          const variable = this.argument.variable;
          const exportNames = options.exportNamesByVariable.get(variable);
          if (exportNames) {
            const _ = options.compact ? "" : " ";
            if (this.prefix) {
              if (exportNames.length === 1) {
                renderSystemExportExpression(variable, this.start, this.end, code, options);
              } else {
                renderSystemExportSequenceAfterExpression(variable, this.start, this.end, this.parent.type !== ExpressionStatement$1, code, options);
              }
            } else {
              const operator = this.operator[0];
              renderSystemExportSequenceBeforeExpression(variable, this.start, this.end, this.parent.type !== ExpressionStatement$1, code, options, `${_}${operator}${_}1`);
            }
          }
        }
      }
      applyDeoptimizations() {
        this.deoptimized = true;
        this.argument.deoptimizePath(EMPTY_PATH);
        if (this.argument instanceof Identifier) {
          const variable = this.scope.findVariable(this.argument.name);
          variable.isReassigned = true;
        }
        this.context.requestTreeshakingPass();
      }
    };
    VariableDeclarator = class extends NodeBase {
      declareDeclarator(kind) {
        this.id.declare(kind, this.init || UNDEFINED_EXPRESSION);
      }
      deoptimizePath(path6) {
        this.id.deoptimizePath(path6);
      }
      hasEffects(context) {
        const initEffect = this.init !== null && this.init.hasEffects(context);
        this.id.markDeclarationReached();
        return initEffect || this.id.hasEffects(context);
      }
      include(context, includeChildrenRecursively) {
        this.included = true;
        if (this.init) {
          this.init.include(context, includeChildrenRecursively);
        }
        this.id.markDeclarationReached();
        if (includeChildrenRecursively || this.id.shouldBeIncluded(context)) {
          this.id.include(context, includeChildrenRecursively);
        }
      }
      render(code, options) {
        const renderId = this.id.included;
        if (renderId) {
          this.id.render(code, options);
        } else {
          const operatorPos = findFirstOccurrenceOutsideComment(code.original, "=", this.id.end);
          code.remove(this.start, findNonWhiteSpace(code.original, operatorPos + 1));
        }
        if (this.init) {
          this.init.render(code, options, renderId ? BLANK : { renderedSurroundingElement: ExpressionStatement$1 });
        } else if (this.id instanceof Identifier && isReassignedExportsMember(this.id.variable, options.exportNamesByVariable)) {
          const _ = options.compact ? "" : " ";
          code.appendLeft(this.end, `${_}=${_}void 0`);
        }
      }
    };
    WhileStatement = class extends NodeBase {
      hasEffects(context) {
        if (this.test.hasEffects(context))
          return true;
        const { brokenFlow, ignore: { breaks, continues } } = context;
        context.ignore.breaks = true;
        context.ignore.continues = true;
        if (this.body.hasEffects(context))
          return true;
        context.ignore.breaks = breaks;
        context.ignore.continues = continues;
        context.brokenFlow = brokenFlow;
        return false;
      }
      include(context, includeChildrenRecursively) {
        this.included = true;
        this.test.include(context, includeChildrenRecursively);
        const { brokenFlow } = context;
        this.body.includeAsSingleStatement(context, includeChildrenRecursively);
        context.brokenFlow = brokenFlow;
      }
    };
    YieldExpression = class extends NodeBase {
      constructor() {
        super(...arguments);
        this.deoptimized = false;
      }
      hasEffects(context) {
        if (!this.deoptimized)
          this.applyDeoptimizations();
        return !context.ignore.returnYield || this.argument !== null && this.argument.hasEffects(context);
      }
      render(code, options) {
        if (this.argument) {
          this.argument.render(code, options, { preventASI: true });
          if (this.argument.start === this.start + 5) {
            code.prependLeft(this.start + 5, " ");
          }
        }
      }
      applyDeoptimizations() {
        this.deoptimized = true;
        const { argument } = this;
        if (argument) {
          argument.deoptimizePath(UNKNOWN_PATH);
          this.context.requestTreeshakingPass();
        }
      }
    };
    nodeConstructors = {
      ArrayExpression,
      ArrayPattern,
      ArrowFunctionExpression,
      AssignmentExpression,
      AssignmentPattern,
      AwaitExpression,
      BinaryExpression,
      BlockStatement,
      BreakStatement,
      CallExpression,
      CatchClause,
      ChainExpression,
      ClassBody,
      ClassDeclaration,
      ClassExpression,
      ConditionalExpression,
      ContinueStatement,
      DoWhileStatement,
      EmptyStatement,
      ExportAllDeclaration,
      ExportDefaultDeclaration,
      ExportNamedDeclaration,
      ExportSpecifier,
      ExpressionStatement,
      ForInStatement,
      ForOfStatement,
      ForStatement,
      FunctionDeclaration,
      FunctionExpression,
      Identifier,
      IfStatement,
      ImportDeclaration,
      ImportDefaultSpecifier,
      ImportExpression,
      ImportNamespaceSpecifier,
      ImportSpecifier,
      LabeledStatement,
      Literal,
      LogicalExpression,
      MemberExpression,
      MetaProperty,
      MethodDefinition,
      NewExpression,
      ObjectExpression,
      ObjectPattern,
      PrivateIdentifier,
      Program,
      Property,
      PropertyDefinition,
      RestElement,
      ReturnStatement,
      SequenceExpression,
      SpreadElement,
      Super,
      SwitchCase,
      SwitchStatement,
      TaggedTemplateExpression,
      TemplateElement,
      TemplateLiteral,
      ThisExpression,
      ThrowStatement,
      TryStatement,
      UnaryExpression,
      UnknownNode,
      UpdateExpression,
      VariableDeclaration,
      VariableDeclarator,
      WhileStatement,
      YieldExpression
    };
    MISSING_EXPORT_SHIM_VARIABLE = "_missingExportShim";
    ExportShimVariable = class extends Variable {
      constructor(module2) {
        super(MISSING_EXPORT_SHIM_VARIABLE);
        this.module = module2;
      }
    };
    NamespaceVariable = class extends Variable {
      constructor(context, syntheticNamedExports) {
        super(context.getModuleName());
        this.memberVariables = null;
        this.mergedNamespaces = [];
        this.referencedEarly = false;
        this.references = [];
        this.context = context;
        this.module = context.module;
        this.syntheticNamedExports = syntheticNamedExports;
      }
      addReference(identifier) {
        this.references.push(identifier);
        this.name = identifier.name;
      }
      getMemberVariables() {
        if (this.memberVariables) {
          return this.memberVariables;
        }
        const memberVariables = /* @__PURE__ */ Object.create(null);
        for (const name of this.context.getExports().concat(this.context.getReexports())) {
          if (name[0] !== "*" && name !== this.module.info.syntheticNamedExports) {
            const exportedVariable = this.context.traceExport(name);
            if (exportedVariable) {
              memberVariables[name] = exportedVariable;
            }
          }
        }
        return this.memberVariables = memberVariables;
      }
      include() {
        this.included = true;
        this.context.includeAllExports();
      }
      prepareNamespace(mergedNamespaces) {
        this.mergedNamespaces = mergedNamespaces;
        const moduleExecIndex = this.context.getModuleExecIndex();
        for (const identifier of this.references) {
          if (identifier.context.getModuleExecIndex() <= moduleExecIndex) {
            this.referencedEarly = true;
            break;
          }
        }
      }
      renderBlock(options) {
        const _ = options.compact ? "" : " ";
        const n3 = options.compact ? "" : "\n";
        const t = options.indent;
        const memberVariables = this.getMemberVariables();
        const members = Object.entries(memberVariables).map(([name2, original]) => {
          if (this.referencedEarly || original.isReassigned) {
            return `${t}get ${name2}${_}()${_}{${_}return ${original.getName()}${options.compact ? "" : ";"}${_}}`;
          }
          const safeName = RESERVED_NAMES[name2] ? `'${name2}'` : name2;
          return `${t}${safeName}: ${original.getName()}`;
        });
        if (options.namespaceToStringTag) {
          members.unshift(`${t}[Symbol.toStringTag]:${_}'Module'`);
        }
        const needsObjectAssign = this.mergedNamespaces.length > 0 || this.syntheticNamedExports;
        if (!needsObjectAssign)
          members.unshift(`${t}__proto__:${_}null`);
        let output = `{${n3}${members.join(`,${n3}`)}${n3}}`;
        if (needsObjectAssign) {
          const assignmentArgs = ["/*#__PURE__*/Object.create(null)"];
          if (this.mergedNamespaces.length > 0) {
            assignmentArgs.push(...this.mergedNamespaces.map((variable) => variable.getName()));
          }
          if (this.syntheticNamedExports) {
            assignmentArgs.push(this.module.getSyntheticNamespace().getName());
          }
          if (members.length > 0) {
            assignmentArgs.push(output);
          }
          output = `/*#__PURE__*/Object.assign(${assignmentArgs.join(`,${_}`)})`;
        }
        if (options.freeze) {
          output = `/*#__PURE__*/Object.freeze(${output})`;
        }
        const name = this.getName();
        output = `${options.varOrConst} ${name}${_}=${_}${output};`;
        if (options.format === "system" && options.exportNamesByVariable.has(this)) {
          output += `${n3}${getSystemExportStatement([this], options)};`;
        }
        return output;
      }
      renderFirst() {
        return this.referencedEarly;
      }
    };
    NamespaceVariable.prototype.isNamespace = true;
    SyntheticNamedExportVariable = class _SyntheticNamedExportVariable extends Variable {
      constructor(context, name, syntheticNamespace) {
        super(name);
        this.baseVariable = null;
        this.context = context;
        this.module = context.module;
        this.syntheticNamespace = syntheticNamespace;
      }
      getBaseVariable() {
        if (this.baseVariable)
          return this.baseVariable;
        let baseVariable = this.syntheticNamespace;
        while (baseVariable instanceof ExportDefaultVariable || baseVariable instanceof _SyntheticNamedExportVariable) {
          if (baseVariable instanceof ExportDefaultVariable) {
            const original = baseVariable.getOriginalVariable();
            if (original === baseVariable)
              break;
            baseVariable = original;
          }
          if (baseVariable instanceof _SyntheticNamedExportVariable) {
            baseVariable = baseVariable.syntheticNamespace;
          }
        }
        return this.baseVariable = baseVariable;
      }
      getBaseVariableName() {
        return this.syntheticNamespace.getBaseVariableName();
      }
      getName() {
        const name = this.name;
        return `${this.syntheticNamespace.getName()}${getPropertyAccess(name)}`;
      }
      include() {
        if (!this.included) {
          this.included = true;
          this.context.includeVariableInModule(this.syntheticNamespace);
        }
      }
      setRenderNames(baseName, name) {
        super.setRenderNames(baseName, name);
      }
    };
    getPropertyAccess = (name) => {
      return !RESERVED_NAMES[name] && /^(?!\d)[\w$]+$/.test(name) ? `.${name}` : `[${JSON.stringify(name)}]`;
    };
    NOOP = () => {
    };
    getStartTime = () => [0, 0];
    getElapsedTime = () => 0;
    getMemory = () => 0;
    timers = {};
    normalizeHrTime = (time) => time[0] * 1e3 + time[1] / 1e6;
    timeStart = NOOP;
    timeEnd = NOOP;
    TIMED_PLUGIN_HOOKS = {
      load: true,
      resolveDynamicImport: true,
      resolveId: true,
      transform: true
    };
    MISSING_EXPORT_SHIM_DESCRIPTION = {
      identifier: null,
      localName: MISSING_EXPORT_SHIM_VARIABLE
    };
    Module = class _Module {
      constructor(graph, id, options, isEntry, hasModuleSideEffects, syntheticNamedExports, meta) {
        this.graph = graph;
        this.id = id;
        this.options = options;
        this.alternativeReexportModules = /* @__PURE__ */ new Map();
        this.ast = null;
        this.chunkFileNames = /* @__PURE__ */ new Set();
        this.chunkName = null;
        this.cycles = /* @__PURE__ */ new Set();
        this.dependencies = /* @__PURE__ */ new Set();
        this.dynamicDependencies = /* @__PURE__ */ new Set();
        this.dynamicImporters = [];
        this.dynamicImports = [];
        this.execIndex = Infinity;
        this.exportAllSources = /* @__PURE__ */ new Set();
        this.exports = /* @__PURE__ */ Object.create(null);
        this.exportsAll = /* @__PURE__ */ Object.create(null);
        this.implicitlyLoadedAfter = /* @__PURE__ */ new Set();
        this.implicitlyLoadedBefore = /* @__PURE__ */ new Set();
        this.importDescriptions = /* @__PURE__ */ Object.create(null);
        this.importMetas = [];
        this.importedFromNotTreeshaken = false;
        this.importers = [];
        this.imports = /* @__PURE__ */ new Set();
        this.includedDynamicImporters = [];
        this.isExecuted = false;
        this.isUserDefinedEntryPoint = false;
        this.preserveSignature = this.options.preserveEntrySignatures;
        this.reexportDescriptions = /* @__PURE__ */ Object.create(null);
        this.sideEffectDependenciesByVariable = /* @__PURE__ */ new Map();
        this.sources = /* @__PURE__ */ new Set();
        this.userChunkNames = /* @__PURE__ */ new Set();
        this.usesTopLevelAwait = false;
        this.allExportNames = null;
        this.exportAllModules = [];
        this.exportNamesByVariable = null;
        this.exportShimVariable = new ExportShimVariable(this);
        this.namespaceReexportsByName = /* @__PURE__ */ Object.create(null);
        this.relevantDependencies = null;
        this.syntheticExports = /* @__PURE__ */ new Map();
        this.syntheticNamespace = null;
        this.transformDependencies = [];
        this.transitiveReexports = null;
        this.excludeFromSourcemap = /\0/.test(id);
        this.context = options.moduleContext(id);
        const module2 = this;
        this.info = {
          ast: null,
          code: null,
          get dynamicallyImportedIds() {
            const dynamicallyImportedIds = [];
            for (const { id: id2 } of module2.dynamicImports) {
              if (id2) {
                dynamicallyImportedIds.push(id2);
              }
            }
            return dynamicallyImportedIds;
          },
          get dynamicImporters() {
            return module2.dynamicImporters.sort();
          },
          hasModuleSideEffects,
          id,
          get implicitlyLoadedAfterOneOf() {
            return Array.from(module2.implicitlyLoadedAfter, getId);
          },
          get implicitlyLoadedBefore() {
            return Array.from(module2.implicitlyLoadedBefore, getId);
          },
          get importedIds() {
            return Array.from(module2.sources, (source) => module2.resolvedIds[source].id);
          },
          get importers() {
            return module2.importers.sort();
          },
          isEntry,
          isExternal: false,
          meta,
          syntheticNamedExports
        };
      }
      basename() {
        const base2 = (0, import_path11.basename)(this.id);
        const ext2 = (0, import_path11.extname)(this.id);
        return makeLegal(ext2 ? base2.slice(0, -ext2.length) : base2);
      }
      bindReferences() {
        this.ast.bind();
      }
      error(props, pos) {
        this.addLocationToLogProps(props, pos);
        return error(props);
      }
      getAllExportNames() {
        if (this.allExportNames) {
          return this.allExportNames;
        }
        const allExportNames = this.allExportNames = /* @__PURE__ */ new Set();
        for (const name of Object.keys(this.exports)) {
          allExportNames.add(name);
        }
        for (const name of Object.keys(this.reexportDescriptions)) {
          allExportNames.add(name);
        }
        for (const module2 of this.exportAllModules) {
          if (module2 instanceof ExternalModule) {
            allExportNames.add(`*${module2.id}`);
            continue;
          }
          for (const name of module2.getAllExportNames()) {
            if (name !== "default")
              allExportNames.add(name);
          }
        }
        return allExportNames;
      }
      getDependenciesToBeIncluded() {
        if (this.relevantDependencies)
          return this.relevantDependencies;
        const relevantDependencies = /* @__PURE__ */ new Set();
        const necessaryDependencies = /* @__PURE__ */ new Set();
        const alwaysCheckedDependencies = /* @__PURE__ */ new Set();
        let dependencyVariables = this.imports.keys();
        if (this.info.isEntry || this.includedDynamicImporters.length > 0 || this.namespace.included || this.implicitlyLoadedAfter.size > 0) {
          dependencyVariables = new Set(dependencyVariables);
          for (const exportName of [...this.getReexports(), ...this.getExports()]) {
            const exportedVariable = this.getVariableForExportName(exportName);
            if (exportedVariable) {
              dependencyVariables.add(exportedVariable);
            }
          }
        }
        for (let variable of dependencyVariables) {
          const sideEffectDependencies = this.sideEffectDependenciesByVariable.get(variable);
          if (sideEffectDependencies) {
            for (const module2 of sideEffectDependencies) {
              alwaysCheckedDependencies.add(module2);
            }
          }
          if (variable instanceof SyntheticNamedExportVariable) {
            variable = variable.getBaseVariable();
          } else if (variable instanceof ExportDefaultVariable) {
            variable = variable.getOriginalVariable();
          }
          necessaryDependencies.add(variable.module);
        }
        if (!this.options.treeshake || this.info.hasModuleSideEffects === "no-treeshake") {
          for (const dependency of this.dependencies) {
            relevantDependencies.add(dependency);
          }
        } else {
          this.addRelevantSideEffectDependencies(relevantDependencies, necessaryDependencies, alwaysCheckedDependencies);
        }
        for (const dependency of necessaryDependencies) {
          relevantDependencies.add(dependency);
        }
        return this.relevantDependencies = relevantDependencies;
      }
      getExportNamesByVariable() {
        if (this.exportNamesByVariable) {
          return this.exportNamesByVariable;
        }
        const exportNamesByVariable = /* @__PURE__ */ new Map();
        for (const exportName of this.getAllExportNames()) {
          if (exportName === this.info.syntheticNamedExports)
            continue;
          let tracedVariable = this.getVariableForExportName(exportName);
          if (tracedVariable instanceof ExportDefaultVariable) {
            tracedVariable = tracedVariable.getOriginalVariable();
          }
          if (!tracedVariable || !(tracedVariable.included || tracedVariable instanceof ExternalVariable)) {
            continue;
          }
          const existingExportNames = exportNamesByVariable.get(tracedVariable);
          if (existingExportNames) {
            existingExportNames.push(exportName);
          } else {
            exportNamesByVariable.set(tracedVariable, [exportName]);
          }
        }
        return this.exportNamesByVariable = exportNamesByVariable;
      }
      getExports() {
        return Object.keys(this.exports);
      }
      getReexports() {
        if (this.transitiveReexports) {
          return this.transitiveReexports;
        }
        this.transitiveReexports = [];
        const reexports = /* @__PURE__ */ new Set();
        for (const name in this.reexportDescriptions) {
          reexports.add(name);
        }
        for (const module2 of this.exportAllModules) {
          if (module2 instanceof ExternalModule) {
            reexports.add(`*${module2.id}`);
          } else {
            for (const name of [...module2.getReexports(), ...module2.getExports()]) {
              if (name !== "default")
                reexports.add(name);
            }
          }
        }
        return this.transitiveReexports = [...reexports];
      }
      getRenderedExports() {
        const renderedExports = [];
        const removedExports = [];
        for (const exportName in this.exports) {
          const variable = this.getVariableForExportName(exportName);
          (variable && variable.included ? renderedExports : removedExports).push(exportName);
        }
        return { removedExports, renderedExports };
      }
      getSyntheticNamespace() {
        if (this.syntheticNamespace === null) {
          this.syntheticNamespace = void 0;
          this.syntheticNamespace = this.getVariableForExportName(typeof this.info.syntheticNamedExports === "string" ? this.info.syntheticNamedExports : "default");
        }
        if (!this.syntheticNamespace) {
          return error(errSyntheticNamedExportsNeedNamespaceExport(this.id, this.info.syntheticNamedExports));
        }
        return this.syntheticNamespace;
      }
      getVariableForExportName(name, { importerForSideEffects, isExportAllSearch, searchedNamesAndModules, skipExternalNamespaceReexports } = EMPTY_OBJECT) {
        if (name[0] === "*") {
          if (name.length === 1) {
            return this.namespace;
          } else {
            const module2 = this.graph.modulesById.get(name.slice(1));
            return module2.getVariableForExportName("*");
          }
        }
        const reexportDeclaration = this.reexportDescriptions[name];
        if (reexportDeclaration) {
          const variable = getVariableForExportNameRecursive(reexportDeclaration.module, reexportDeclaration.localName, importerForSideEffects, false, searchedNamesAndModules, false);
          if (!variable) {
            return this.error(errMissingExport(reexportDeclaration.localName, this.id, reexportDeclaration.module.id), reexportDeclaration.start);
          }
          if (importerForSideEffects) {
            setAlternativeExporterIfCyclic(variable, importerForSideEffects, this);
          }
          return variable;
        }
        const exportDeclaration = this.exports[name];
        if (exportDeclaration) {
          if (exportDeclaration === MISSING_EXPORT_SHIM_DESCRIPTION) {
            return this.exportShimVariable;
          }
          const name2 = exportDeclaration.localName;
          const variable = this.traceVariable(name2, importerForSideEffects);
          if (importerForSideEffects) {
            getOrCreate(importerForSideEffects.sideEffectDependenciesByVariable, variable, () => /* @__PURE__ */ new Set()).add(this);
            setAlternativeExporterIfCyclic(variable, importerForSideEffects, this);
          }
          return variable;
        }
        if (name !== "default") {
          const foundNamespaceReexport = name in this.namespaceReexportsByName ? this.namespaceReexportsByName[name] : this.getVariableFromNamespaceReexports(name, importerForSideEffects, searchedNamesAndModules, skipExternalNamespaceReexports);
          if (!skipExternalNamespaceReexports) {
            this.namespaceReexportsByName[name] = foundNamespaceReexport;
          }
          if (foundNamespaceReexport) {
            return foundNamespaceReexport;
          }
        }
        if (this.info.syntheticNamedExports) {
          let syntheticExport = this.syntheticExports.get(name);
          if (!syntheticExport) {
            const syntheticNamespace = this.getSyntheticNamespace();
            syntheticExport = new SyntheticNamedExportVariable(this.astContext, name, syntheticNamespace);
            this.syntheticExports.set(name, syntheticExport);
            return syntheticExport;
          }
          return syntheticExport;
        }
        if (!isExportAllSearch) {
          if (this.options.shimMissingExports) {
            this.shimMissingExport(name);
            return this.exportShimVariable;
          }
        }
        return null;
      }
      hasEffects() {
        return this.info.hasModuleSideEffects === "no-treeshake" || this.ast.included && this.ast.hasEffects(createHasEffectsContext());
      }
      include() {
        const context = createInclusionContext();
        if (this.ast.shouldBeIncluded(context))
          this.ast.include(context, false);
      }
      includeAllExports(includeNamespaceMembers) {
        if (!this.isExecuted) {
          markModuleAndImpureDependenciesAsExecuted(this);
          this.graph.needsTreeshakingPass = true;
        }
        for (const exportName of this.getExports()) {
          if (includeNamespaceMembers || exportName !== this.info.syntheticNamedExports) {
            const variable = this.getVariableForExportName(exportName);
            variable.deoptimizePath(UNKNOWN_PATH);
            if (!variable.included) {
              this.includeVariable(variable);
            }
          }
        }
        for (const name of this.getReexports()) {
          const variable = this.getVariableForExportName(name);
          if (variable) {
            variable.deoptimizePath(UNKNOWN_PATH);
            if (!variable.included) {
              this.includeVariable(variable);
            }
            if (variable instanceof ExternalVariable) {
              variable.module.reexported = true;
            }
          }
        }
        if (includeNamespaceMembers) {
          this.namespace.prepareNamespace(this.includeAndGetAdditionalMergedNamespaces());
        }
      }
      includeAllInBundle() {
        this.ast.include(createInclusionContext(), true);
        this.includeAllExports(false);
      }
      isIncluded() {
        return this.ast.included || this.namespace.included || this.importedFromNotTreeshaken;
      }
      linkImports() {
        this.addModulesToImportDescriptions(this.importDescriptions);
        this.addModulesToImportDescriptions(this.reexportDescriptions);
        for (const name in this.exports) {
          if (name !== "default" && name !== this.info.syntheticNamedExports) {
            this.exportsAll[name] = this.id;
          }
        }
        const externalExportAllModules = [];
        for (const source of this.exportAllSources) {
          const module2 = this.graph.modulesById.get(this.resolvedIds[source].id);
          if (module2 instanceof ExternalModule) {
            externalExportAllModules.push(module2);
            continue;
          }
          this.exportAllModules.push(module2);
          for (const name in module2.exportsAll) {
            if (name in this.exportsAll) {
              this.options.onwarn(errNamespaceConflict(name, this, module2));
            } else {
              this.exportsAll[name] = module2.exportsAll[name];
            }
          }
        }
        this.exportAllModules.push(...externalExportAllModules);
      }
      render(options) {
        const magicString = this.magicString.clone();
        this.ast.render(magicString, options);
        this.usesTopLevelAwait = this.astContext.usesTopLevelAwait;
        return magicString;
      }
      setSource({ ast, code, customTransformCache, originalCode, originalSourcemap, resolvedIds, sourcemapChain, transformDependencies, transformFiles, ...moduleOptions }) {
        this.info.code = code;
        this.originalCode = originalCode;
        this.originalSourcemap = originalSourcemap;
        this.sourcemapChain = sourcemapChain;
        if (transformFiles) {
          this.transformFiles = transformFiles;
        }
        this.transformDependencies = transformDependencies;
        this.customTransformCache = customTransformCache;
        this.updateOptions(moduleOptions);
        timeStart("generate ast", 3);
        if (!ast) {
          ast = this.tryParse();
        }
        timeEnd("generate ast", 3);
        this.resolvedIds = resolvedIds || /* @__PURE__ */ Object.create(null);
        const fileName = this.id;
        this.magicString = new MagicString$1(code, {
          filename: this.excludeFromSourcemap ? null : fileName,
          indentExclusionRanges: []
        });
        timeStart("analyse ast", 3);
        this.astContext = {
          addDynamicImport: this.addDynamicImport.bind(this),
          addExport: this.addExport.bind(this),
          addImport: this.addImport.bind(this),
          addImportMeta: this.addImportMeta.bind(this),
          code,
          deoptimizationTracker: this.graph.deoptimizationTracker,
          error: this.error.bind(this),
          fileName,
          getExports: this.getExports.bind(this),
          getModuleExecIndex: () => this.execIndex,
          getModuleName: this.basename.bind(this),
          getReexports: this.getReexports.bind(this),
          importDescriptions: this.importDescriptions,
          includeAllExports: () => this.includeAllExports(true),
          includeDynamicImport: this.includeDynamicImport.bind(this),
          includeVariableInModule: this.includeVariableInModule.bind(this),
          magicString: this.magicString,
          module: this,
          moduleContext: this.context,
          nodeConstructors,
          options: this.options,
          requestTreeshakingPass: () => this.graph.needsTreeshakingPass = true,
          traceExport: this.getVariableForExportName.bind(this),
          traceVariable: this.traceVariable.bind(this),
          usesTopLevelAwait: false,
          warn: this.warn.bind(this)
        };
        this.scope = new ModuleScope(this.graph.scope, this.astContext);
        this.namespace = new NamespaceVariable(this.astContext, this.info.syntheticNamedExports);
        this.ast = new Program(ast, { context: this.astContext, type: "Module" }, this.scope);
        this.info.ast = ast;
        timeEnd("analyse ast", 3);
      }
      toJSON() {
        return {
          ast: this.ast.esTreeNode,
          code: this.info.code,
          customTransformCache: this.customTransformCache,
          dependencies: Array.from(this.dependencies, getId),
          id: this.id,
          meta: this.info.meta,
          moduleSideEffects: this.info.hasModuleSideEffects,
          originalCode: this.originalCode,
          originalSourcemap: this.originalSourcemap,
          resolvedIds: this.resolvedIds,
          sourcemapChain: this.sourcemapChain,
          syntheticNamedExports: this.info.syntheticNamedExports,
          transformDependencies: this.transformDependencies,
          transformFiles: this.transformFiles
        };
      }
      traceVariable(name, importerForSideEffects) {
        const localVariable = this.scope.variables.get(name);
        if (localVariable) {
          return localVariable;
        }
        if (name in this.importDescriptions) {
          const importDeclaration = this.importDescriptions[name];
          const otherModule = importDeclaration.module;
          if (otherModule instanceof _Module && importDeclaration.name === "*") {
            return otherModule.namespace;
          }
          const declaration = otherModule.getVariableForExportName(importDeclaration.name, {
            importerForSideEffects: importerForSideEffects || this
          });
          if (!declaration) {
            return this.error(errMissingExport(importDeclaration.name, this.id, otherModule.id), importDeclaration.start);
          }
          return declaration;
        }
        return null;
      }
      tryParse() {
        try {
          return this.graph.contextParse(this.info.code);
        } catch (err2) {
          let message = err2.message.replace(/ \(\d+:\d+\)$/, "");
          if (this.id.endsWith(".json")) {
            message += " (Note that you need @rollup/plugin-json to import JSON files)";
          } else if (!this.id.endsWith(".js")) {
            message += " (Note that you need plugins to import files that are not JavaScript)";
          }
          return this.error({
            code: "PARSE_ERROR",
            message,
            parserError: err2
          }, err2.pos);
        }
      }
      updateOptions({ meta, moduleSideEffects, syntheticNamedExports }) {
        if (moduleSideEffects != null) {
          this.info.hasModuleSideEffects = moduleSideEffects;
        }
        if (syntheticNamedExports != null) {
          this.info.syntheticNamedExports = syntheticNamedExports;
        }
        if (meta != null) {
          this.info.meta = { ...this.info.meta, ...meta };
        }
      }
      warn(props, pos) {
        this.addLocationToLogProps(props, pos);
        this.options.onwarn(props);
      }
      addDynamicImport(node) {
        let argument = node.source;
        if (argument instanceof TemplateLiteral) {
          if (argument.quasis.length === 1 && argument.quasis[0].value.cooked) {
            argument = argument.quasis[0].value.cooked;
          }
        } else if (argument instanceof Literal && typeof argument.value === "string") {
          argument = argument.value;
        }
        this.dynamicImports.push({ argument, id: null, node, resolution: null });
      }
      addExport(node) {
        if (node instanceof ExportDefaultDeclaration) {
          this.exports.default = {
            identifier: node.variable.getAssignedVariableName(),
            localName: "default"
          };
        } else if (node instanceof ExportAllDeclaration) {
          const source = node.source.value;
          this.sources.add(source);
          if (node.exported) {
            const name = node.exported.name;
            this.reexportDescriptions[name] = {
              localName: "*",
              module: null,
              source,
              start: node.start
            };
          } else {
            this.exportAllSources.add(source);
          }
        } else if (node.source instanceof Literal) {
          const source = node.source.value;
          this.sources.add(source);
          for (const specifier of node.specifiers) {
            const name = specifier.exported.name;
            this.reexportDescriptions[name] = {
              localName: specifier.local.name,
              module: null,
              source,
              start: specifier.start
            };
          }
        } else if (node.declaration) {
          const declaration = node.declaration;
          if (declaration instanceof VariableDeclaration) {
            for (const declarator of declaration.declarations) {
              for (const localName of extractAssignedNames3(declarator.id)) {
                this.exports[localName] = { identifier: null, localName };
              }
            }
          } else {
            const localName = declaration.id.name;
            this.exports[localName] = { identifier: null, localName };
          }
        } else {
          for (const specifier of node.specifiers) {
            const localName = specifier.local.name;
            const exportedName = specifier.exported.name;
            this.exports[exportedName] = { identifier: null, localName };
          }
        }
      }
      addImport(node) {
        const source = node.source.value;
        this.sources.add(source);
        for (const specifier of node.specifiers) {
          const isDefault = specifier.type === ImportDefaultSpecifier$1;
          const isNamespace = specifier.type === ImportNamespaceSpecifier$1;
          const name = isDefault ? "default" : isNamespace ? "*" : specifier.imported.name;
          this.importDescriptions[specifier.local.name] = {
            module: null,
            name,
            source,
            start: specifier.start
          };
        }
      }
      addImportMeta(node) {
        this.importMetas.push(node);
      }
      addLocationToLogProps(props, pos) {
        props.id = this.id;
        props.pos = pos;
        let code = this.info.code;
        const location = locate(code, pos, { offsetLine: 1 });
        if (location) {
          let { column, line } = location;
          try {
            ({ column, line } = getOriginalLocation(this.sourcemapChain, { column, line }));
            code = this.originalCode;
          } catch (e) {
            this.options.onwarn({
              code: "SOURCEMAP_ERROR",
              id: this.id,
              loc: {
                column,
                file: this.id,
                line
              },
              message: `Error when using sourcemap for reporting an error: ${e.message}`,
              pos
            });
          }
          augmentCodeLocation(props, { column, line }, code, this.id);
        }
      }
      addModulesToImportDescriptions(importDescription) {
        for (const specifier of Object.values(importDescription)) {
          const id = this.resolvedIds[specifier.source].id;
          specifier.module = this.graph.modulesById.get(id);
        }
      }
      addRelevantSideEffectDependencies(relevantDependencies, necessaryDependencies, alwaysCheckedDependencies) {
        const handledDependencies = /* @__PURE__ */ new Set();
        const addSideEffectDependencies = (possibleDependencies) => {
          for (const dependency of possibleDependencies) {
            if (handledDependencies.has(dependency)) {
              continue;
            }
            handledDependencies.add(dependency);
            if (necessaryDependencies.has(dependency)) {
              relevantDependencies.add(dependency);
              continue;
            }
            if (!(dependency.info.hasModuleSideEffects || alwaysCheckedDependencies.has(dependency))) {
              continue;
            }
            if (dependency instanceof ExternalModule || dependency.hasEffects()) {
              relevantDependencies.add(dependency);
              continue;
            }
            addSideEffectDependencies(dependency.dependencies);
          }
        };
        addSideEffectDependencies(this.dependencies);
        addSideEffectDependencies(alwaysCheckedDependencies);
      }
      getVariableFromNamespaceReexports(name, importerForSideEffects, searchedNamesAndModules, skipExternalNamespaceReexports = false) {
        let foundSyntheticDeclaration = null;
        const skipExternalNamespaceValues = [{ searchedNamesAndModules, skipExternalNamespaces: true }];
        if (!skipExternalNamespaceReexports) {
          const clonedSearchedNamesAndModules = /* @__PURE__ */ new Map();
          for (const [name2, modules] of searchedNamesAndModules || []) {
            clonedSearchedNamesAndModules.set(name2, new Set(modules));
          }
          skipExternalNamespaceValues.push({
            searchedNamesAndModules: clonedSearchedNamesAndModules,
            skipExternalNamespaces: false
          });
        }
        for (const { skipExternalNamespaces, searchedNamesAndModules: searchedNamesAndModules2 } of skipExternalNamespaceValues) {
          const foundDeclarations = /* @__PURE__ */ new Set();
          for (const module2 of this.exportAllModules) {
            if (module2 instanceof _Module || !skipExternalNamespaces) {
              const declaration = getVariableForExportNameRecursive(module2, name, importerForSideEffects, true, searchedNamesAndModules2, skipExternalNamespaces);
              if (declaration) {
                if (!(declaration instanceof SyntheticNamedExportVariable)) {
                  foundDeclarations.add(declaration);
                } else if (!foundSyntheticDeclaration) {
                  foundSyntheticDeclaration = declaration;
                }
              }
            }
          }
          if (foundDeclarations.size === 1) {
            return [...foundDeclarations][0];
          }
          if (foundDeclarations.size > 1) {
            if (skipExternalNamespaces) {
              return null;
            }
            const foundDeclarationList = [...foundDeclarations];
            const usedDeclaration = foundDeclarationList[0];
            this.options.onwarn(errAmbiguousExternalNamespaces(name, this.id, usedDeclaration.module.id, foundDeclarationList.map((declaration) => declaration.module.id)));
            return usedDeclaration;
          }
        }
        if (foundSyntheticDeclaration) {
          return foundSyntheticDeclaration;
        }
        return null;
      }
      includeAndGetAdditionalMergedNamespaces() {
        const mergedNamespaces = [];
        for (const module2 of this.exportAllModules) {
          if (module2 instanceof ExternalModule) {
            const externalVariable = module2.getVariableForExportName("*");
            externalVariable.include();
            this.imports.add(externalVariable);
            mergedNamespaces.push(externalVariable);
          } else if (module2.info.syntheticNamedExports) {
            const syntheticNamespace = module2.getSyntheticNamespace();
            syntheticNamespace.include();
            this.imports.add(syntheticNamespace);
            mergedNamespaces.push(syntheticNamespace);
          }
        }
        return mergedNamespaces;
      }
      includeDynamicImport(node) {
        const resolution = this.dynamicImports.find((dynamicImport) => dynamicImport.node === node).resolution;
        if (resolution instanceof _Module) {
          resolution.includedDynamicImporters.push(this);
          resolution.includeAllExports(true);
        }
      }
      includeVariable(variable) {
        if (!variable.included) {
          variable.include();
          this.graph.needsTreeshakingPass = true;
          const variableModule = variable.module;
          if (variableModule && variableModule instanceof _Module) {
            if (!variableModule.isExecuted) {
              markModuleAndImpureDependenciesAsExecuted(variableModule);
            }
            if (variableModule !== this) {
              const sideEffectModules = getAndExtendSideEffectModules(variable, this);
              for (const module2 of sideEffectModules) {
                if (!module2.isExecuted) {
                  markModuleAndImpureDependenciesAsExecuted(module2);
                }
              }
            }
          }
        }
      }
      includeVariableInModule(variable) {
        this.includeVariable(variable);
        const variableModule = variable.module;
        if (variableModule && variableModule !== this) {
          this.imports.add(variable);
        }
      }
      shimMissingExport(name) {
        this.options.onwarn({
          code: "SHIMMED_EXPORT",
          exporter: relativeId(this.id),
          exportName: name,
          message: `Missing export "${name}" has been shimmed in module ${relativeId(this.id)}.`
        });
        this.exports[name] = MISSING_EXPORT_SHIM_DESCRIPTION;
      }
    };
    builtins4 = {
      assert: true,
      buffer: true,
      console: true,
      constants: true,
      domain: true,
      events: true,
      http: true,
      https: true,
      os: true,
      path: true,
      process: true,
      punycode: true,
      querystring: true,
      stream: true,
      string_decoder: true,
      timers: true,
      tty: true,
      url: true,
      util: true,
      vm: true,
      zlib: true
    };
    shouldUseDot = /^[a-zA-Z$_][a-zA-Z0-9$_]*$/;
    thisProp = (name) => `this${keypath(name)}`;
    getStarExcludesBlock = (starExcludes, varOrConst, _, t, n3) => starExcludes ? `${n3}${t}${varOrConst} _starExcludes${_}=${_}{${_}${[...starExcludes].map((prop) => `${prop}:${_}1`).join(`,${_}`)}${_}};` : "";
    getImportBindingsBlock = (importBindings, _, t, n3) => importBindings.length ? `${n3}${t}var ${importBindings.join(`,${_}`)};` : "";
    getHoistedExportsBlock = (exports2, _, t, n3) => getExportsBlock(exports2.filter((expt) => expt.hoisted).map((expt) => ({ name: expt.exported, value: expt.local })), _, t, n3);
    getMissingExportsBlock = (exports2, _, t, n3) => getExportsBlock(exports2.filter((expt) => expt.local === MISSING_EXPORT_SHIM_VARIABLE).map((expt) => ({ name: expt.exported, value: MISSING_EXPORT_SHIM_VARIABLE })), _, t, n3);
    getSyntheticExportsBlock = (exports2, _, t, n3) => getExportsBlock(exports2.filter((expt) => expt.expression).map((expt) => ({ name: expt.exported, value: expt.local })), _, t, n3);
    finalisers = { amd, cjs, es, iife, system, umd };
    Source = class {
      constructor(filename, content) {
        this.isOriginal = true;
        this.filename = filename;
        this.content = content;
      }
      traceSegment(line, column, name) {
        return { column, line, name, source: this };
      }
    };
    Link = class {
      constructor(map2, sources) {
        this.sources = sources;
        this.names = map2.names;
        this.mappings = map2.mappings;
      }
      traceMappings() {
        const sources = [];
        const sourcesContent = [];
        const names = [];
        const nameIndexMap = /* @__PURE__ */ new Map();
        const mappings = [];
        for (const line of this.mappings) {
          const tracedLine = [];
          for (const segment of line) {
            if (segment.length == 1)
              continue;
            const source = this.sources[segment[1]];
            if (!source)
              continue;
            const traced = source.traceSegment(segment[2], segment[3], segment.length === 5 ? this.names[segment[4]] : "");
            if (traced) {
              let sourceIndex2 = sources.lastIndexOf(traced.source.filename);
              if (sourceIndex2 === -1) {
                sourceIndex2 = sources.length;
                sources.push(traced.source.filename);
                sourcesContent[sourceIndex2] = traced.source.content;
              } else if (sourcesContent[sourceIndex2] == null) {
                sourcesContent[sourceIndex2] = traced.source.content;
              } else if (traced.source.content != null && sourcesContent[sourceIndex2] !== traced.source.content) {
                return error({
                  message: `Multiple conflicting contents for sourcemap source ${traced.source.filename}`
                });
              }
              const tracedSegment = [
                segment[0],
                sourceIndex2,
                traced.line,
                traced.column
              ];
              if (traced.name) {
                let nameIndex = nameIndexMap.get(traced.name);
                if (nameIndex === void 0) {
                  nameIndex = names.length;
                  names.push(traced.name);
                  nameIndexMap.set(traced.name, nameIndex);
                }
                tracedSegment[4] = nameIndex;
              }
              tracedLine.push(tracedSegment);
            }
          }
          mappings.push(tracedLine);
        }
        return { mappings, names, sources, sourcesContent };
      }
      traceSegment(line, column, name) {
        const segments = this.mappings[line];
        if (!segments)
          return null;
        let i = 0;
        let j = segments.length - 1;
        while (i <= j) {
          const m = i + j >> 1;
          const segment = segments[m];
          if (segment[0] === column) {
            if (segment.length == 1)
              return null;
            const source = this.sources[segment[1]];
            if (!source)
              return null;
            return source.traceSegment(segment[2], segment[3], segment.length === 5 ? this.names[segment[4]] : name);
          }
          if (segment[0] > column) {
            j = m - 1;
          } else {
            i = m + 1;
          }
        }
        return null;
      }
    };
    createHash = () => (0, import_crypto.createHash)("sha256");
    DECONFLICT_IMPORTED_VARIABLES_BY_FORMAT = {
      amd: deconflictImportsOther,
      cjs: deconflictImportsOther,
      es: deconflictImportsEsmOrSystem,
      iife: deconflictImportsOther,
      system: deconflictImportsEsmOrSystem,
      umd: deconflictImportsOther
    };
    needsEscapeRegEx = /[\\'\r\n\u2028\u2029]/;
    quoteNewlineRegEx = /(['\r\n\u2028\u2029])/g;
    backSlashRegEx = /\\/g;
    NON_ASSET_EXTENSIONS = [".js", ".jsx", ".ts", ".tsx"];
    Chunk3 = class _Chunk {
      constructor(orderedModules, inputOptions, outputOptions, unsetOptions, pluginDriver, modulesById, chunkByModule, facadeChunkByModule, includedNamespaces, manualChunkAlias) {
        this.orderedModules = orderedModules;
        this.inputOptions = inputOptions;
        this.outputOptions = outputOptions;
        this.unsetOptions = unsetOptions;
        this.pluginDriver = pluginDriver;
        this.modulesById = modulesById;
        this.chunkByModule = chunkByModule;
        this.facadeChunkByModule = facadeChunkByModule;
        this.includedNamespaces = includedNamespaces;
        this.manualChunkAlias = manualChunkAlias;
        this.entryModules = [];
        this.exportMode = "named";
        this.facadeModule = null;
        this.id = null;
        this.namespaceVariableName = "";
        this.variableName = "";
        this.accessedGlobalsByScope = /* @__PURE__ */ new Map();
        this.dependencies = /* @__PURE__ */ new Set();
        this.dynamicDependencies = /* @__PURE__ */ new Set();
        this.dynamicEntryModules = [];
        this.dynamicName = null;
        this.exportNamesByVariable = /* @__PURE__ */ new Map();
        this.exports = /* @__PURE__ */ new Set();
        this.exportsByName = /* @__PURE__ */ Object.create(null);
        this.fileName = null;
        this.implicitEntryModules = [];
        this.implicitlyLoadedBefore = /* @__PURE__ */ new Set();
        this.imports = /* @__PURE__ */ new Set();
        this.indentString = void 0;
        this.isEmpty = true;
        this.name = null;
        this.needsExportsShim = false;
        this.renderedDependencies = null;
        this.renderedExports = null;
        this.renderedHash = void 0;
        this.renderedModuleSources = /* @__PURE__ */ new Map();
        this.renderedModules = /* @__PURE__ */ Object.create(null);
        this.renderedSource = null;
        this.sortedExportNames = null;
        this.strictFacade = false;
        this.usedModules = void 0;
        this.execIndex = orderedModules.length > 0 ? orderedModules[0].execIndex : Infinity;
        const chunkModules = new Set(orderedModules);
        for (const module2 of orderedModules) {
          if (module2.namespace.included) {
            includedNamespaces.add(module2);
          }
          if (this.isEmpty && module2.isIncluded()) {
            this.isEmpty = false;
          }
          if (module2.info.isEntry || outputOptions.preserveModules) {
            this.entryModules.push(module2);
          }
          for (const importer of module2.includedDynamicImporters) {
            if (!chunkModules.has(importer)) {
              this.dynamicEntryModules.push(module2);
              if (module2.info.syntheticNamedExports && !outputOptions.preserveModules) {
                includedNamespaces.add(module2);
                this.exports.add(module2.namespace);
              }
            }
          }
          if (module2.implicitlyLoadedAfter.size > 0) {
            this.implicitEntryModules.push(module2);
          }
        }
        this.suggestedVariableName = makeLegal(this.generateVariableName());
      }
      static generateFacade(inputOptions, outputOptions, unsetOptions, pluginDriver, modulesById, chunkByModule, facadeChunkByModule, includedNamespaces, facadedModule, facadeName) {
        const chunk = new _Chunk([], inputOptions, outputOptions, unsetOptions, pluginDriver, modulesById, chunkByModule, facadeChunkByModule, includedNamespaces, null);
        chunk.assignFacadeName(facadeName, facadedModule);
        if (!facadeChunkByModule.has(facadedModule)) {
          facadeChunkByModule.set(facadedModule, chunk);
        }
        for (const dependency of facadedModule.getDependenciesToBeIncluded()) {
          chunk.dependencies.add(dependency instanceof Module ? chunkByModule.get(dependency) : dependency);
        }
        if (!chunk.dependencies.has(chunkByModule.get(facadedModule)) && facadedModule.info.hasModuleSideEffects && facadedModule.hasEffects()) {
          chunk.dependencies.add(chunkByModule.get(facadedModule));
        }
        chunk.ensureReexportsAreAvailableForModule(facadedModule);
        chunk.facadeModule = facadedModule;
        chunk.strictFacade = true;
        return chunk;
      }
      canModuleBeFacade(module2, exposedVariables) {
        const moduleExportNamesByVariable = module2.getExportNamesByVariable();
        for (const exposedVariable of this.exports) {
          if (!moduleExportNamesByVariable.has(exposedVariable)) {
            if (moduleExportNamesByVariable.size === 0 && module2.isUserDefinedEntryPoint && module2.preserveSignature === "strict" && this.unsetOptions.has("preserveEntrySignatures")) {
              this.inputOptions.onwarn({
                code: "EMPTY_FACADE",
                id: module2.id,
                message: `To preserve the export signature of the entry module "${relativeId(module2.id)}", an empty facade chunk was created. This often happens when creating a bundle for a web app where chunks are placed in script tags and exports are ignored. In this case it is recommended to set "preserveEntrySignatures: false" to avoid this and reduce the number of chunks. Otherwise if this is intentional, set "preserveEntrySignatures: 'strict'" explicitly to silence this warning.`,
                url: "https://rollupjs.org/guide/en/#preserveentrysignatures"
              });
            }
            return false;
          }
        }
        for (const exposedVariable of exposedVariables) {
          if (!(moduleExportNamesByVariable.has(exposedVariable) || exposedVariable.module === module2)) {
            return false;
          }
        }
        return true;
      }
      generateExports() {
        this.sortedExportNames = null;
        const remainingExports = new Set(this.exports);
        if (this.facadeModule !== null && (this.facadeModule.preserveSignature !== false || this.strictFacade)) {
          const exportNamesByVariable = this.facadeModule.getExportNamesByVariable();
          for (const [variable, exportNames] of exportNamesByVariable) {
            this.exportNamesByVariable.set(variable, [...exportNames]);
            for (const exportName of exportNames) {
              this.exportsByName[exportName] = variable;
            }
            remainingExports.delete(variable);
          }
        }
        if (this.outputOptions.minifyInternalExports) {
          assignExportsToMangledNames(remainingExports, this.exportsByName, this.exportNamesByVariable);
        } else {
          assignExportsToNames(remainingExports, this.exportsByName, this.exportNamesByVariable);
        }
        if (this.outputOptions.preserveModules || this.facadeModule && this.facadeModule.info.isEntry)
          this.exportMode = getExportMode(this, this.outputOptions, this.unsetOptions, this.facadeModule.id, this.inputOptions.onwarn);
      }
      generateFacades() {
        var _a;
        const facades = [];
        const entryModules = /* @__PURE__ */ new Set([...this.entryModules, ...this.implicitEntryModules]);
        const exposedVariables = new Set(this.dynamicEntryModules.map((module2) => module2.namespace));
        for (const module2 of entryModules) {
          if (module2.preserveSignature) {
            for (const exportedVariable of module2.getExportNamesByVariable().keys()) {
              exposedVariables.add(exportedVariable);
            }
          }
        }
        for (const module2 of entryModules) {
          const requiredFacades = Array.from(module2.userChunkNames, (name) => ({
            name
          }));
          if (requiredFacades.length === 0 && module2.isUserDefinedEntryPoint) {
            requiredFacades.push({});
          }
          requiredFacades.push(...Array.from(module2.chunkFileNames, (fileName) => ({ fileName })));
          if (requiredFacades.length === 0) {
            requiredFacades.push({});
          }
          if (!this.facadeModule) {
            const needsStrictFacade = module2.preserveSignature === "strict" || module2.preserveSignature === "exports-only" && module2.getExportNamesByVariable().size !== 0;
            if (!needsStrictFacade || this.outputOptions.preserveModules || this.canModuleBeFacade(module2, exposedVariables)) {
              this.facadeModule = module2;
              this.facadeChunkByModule.set(module2, this);
              if (module2.preserveSignature) {
                this.strictFacade = needsStrictFacade;
              }
              this.assignFacadeName(requiredFacades.shift(), module2);
            }
          }
          for (const facadeName of requiredFacades) {
            facades.push(_Chunk.generateFacade(this.inputOptions, this.outputOptions, this.unsetOptions, this.pluginDriver, this.modulesById, this.chunkByModule, this.facadeChunkByModule, this.includedNamespaces, module2, facadeName));
          }
        }
        for (const module2 of this.dynamicEntryModules) {
          if (module2.info.syntheticNamedExports)
            continue;
          if (!this.facadeModule && this.canModuleBeFacade(module2, exposedVariables)) {
            this.facadeModule = module2;
            this.facadeChunkByModule.set(module2, this);
            this.strictFacade = true;
            this.dynamicName = getChunkNameFromModule(module2);
          } else if (this.facadeModule === module2 && !this.strictFacade && this.canModuleBeFacade(module2, exposedVariables)) {
            this.strictFacade = true;
          } else if (!((_a = this.facadeChunkByModule.get(module2)) === null || _a === void 0 ? void 0 : _a.strictFacade)) {
            this.includedNamespaces.add(module2);
            this.exports.add(module2.namespace);
          }
        }
        return facades;
      }
      generateId(addons, options, existingNames, includeHash) {
        if (this.fileName !== null) {
          return this.fileName;
        }
        const [pattern, patternName] = this.facadeModule && this.facadeModule.isUserDefinedEntryPoint ? [options.entryFileNames, "output.entryFileNames"] : [options.chunkFileNames, "output.chunkFileNames"];
        return makeUnique(renderNamePattern(typeof pattern === "function" ? pattern(this.getChunkInfo()) : pattern, patternName, {
          format: () => options.format,
          hash: () => includeHash ? this.computeContentHashWithDependencies(addons, options, existingNames) : "[hash]",
          name: () => this.getChunkName()
        }), existingNames);
      }
      generateIdPreserveModules(preserveModulesRelativeDir, options, existingNames, unsetOptions) {
        const id = this.orderedModules[0].id;
        const sanitizedId = this.outputOptions.sanitizeFileName(id);
        let path6;
        if (isAbsolute3(id)) {
          const extension = (0, import_path11.extname)(id);
          const pattern = unsetOptions.has("entryFileNames") ? "[name][assetExtname].js" : options.entryFileNames;
          const currentDir = (0, import_path11.dirname)(sanitizedId);
          const fileName = renderNamePattern(typeof pattern === "function" ? pattern(this.getChunkInfo()) : pattern, "output.entryFileNames", {
            assetExtname: () => NON_ASSET_EXTENSIONS.includes(extension) ? "" : extension,
            ext: () => extension.substr(1),
            extname: () => extension,
            format: () => options.format,
            name: () => this.getChunkName()
          });
          const currentPath = `${currentDir}/${fileName}`;
          const { preserveModulesRoot } = options;
          if (preserveModulesRoot && currentPath.startsWith(preserveModulesRoot)) {
            path6 = currentPath.slice(preserveModulesRoot.length).replace(/^[\\/]/, "");
          } else {
            path6 = relative3(preserveModulesRelativeDir, currentPath);
          }
        } else {
          path6 = `_virtual/${(0, import_path11.basename)(sanitizedId)}`;
        }
        return makeUnique(normalize2(path6), existingNames);
      }
      getChunkInfo() {
        const facadeModule = this.facadeModule;
        const getChunkName = this.getChunkName.bind(this);
        return {
          exports: this.getExportNames(),
          facadeModuleId: facadeModule && facadeModule.id,
          isDynamicEntry: this.dynamicEntryModules.length > 0,
          isEntry: facadeModule !== null && facadeModule.info.isEntry,
          isImplicitEntry: this.implicitEntryModules.length > 0,
          modules: this.renderedModules,
          get name() {
            return getChunkName();
          },
          type: "chunk"
        };
      }
      getChunkInfoWithFileNames() {
        return Object.assign(this.getChunkInfo(), {
          code: void 0,
          dynamicImports: Array.from(this.dynamicDependencies, getId),
          fileName: this.id,
          implicitlyLoadedBefore: Array.from(this.implicitlyLoadedBefore, getId),
          importedBindings: this.getImportedBindingsPerDependency(),
          imports: Array.from(this.dependencies, getId),
          map: void 0,
          referencedFiles: this.getReferencedFiles()
        });
      }
      getChunkName() {
        return this.name || (this.name = this.outputOptions.sanitizeFileName(this.getFallbackChunkName()));
      }
      getExportNames() {
        return this.sortedExportNames || (this.sortedExportNames = Object.keys(this.exportsByName).sort());
      }
      getRenderedHash() {
        if (this.renderedHash)
          return this.renderedHash;
        const hash = createHash();
        const hashAugmentation = this.pluginDriver.hookReduceValueSync("augmentChunkHash", "", [this.getChunkInfo()], (augmentation, pluginHash) => {
          if (pluginHash) {
            augmentation += pluginHash;
          }
          return augmentation;
        });
        hash.update(hashAugmentation);
        hash.update(this.renderedSource.toString());
        hash.update(this.getExportNames().map((exportName) => {
          const variable = this.exportsByName[exportName];
          return `${relativeId(variable.module.id).replace(/\\/g, "/")}:${variable.name}:${exportName}`;
        }).join(","));
        return this.renderedHash = hash.digest("hex");
      }
      getVariableExportName(variable) {
        if (this.outputOptions.preserveModules && variable instanceof NamespaceVariable) {
          return "*";
        }
        return this.exportNamesByVariable.get(variable)[0];
      }
      link() {
        this.dependencies = getStaticDependencies(this, this.orderedModules, this.chunkByModule);
        for (const module2 of this.orderedModules) {
          this.addDependenciesToChunk(module2.dynamicDependencies, this.dynamicDependencies);
          this.addDependenciesToChunk(module2.implicitlyLoadedBefore, this.implicitlyLoadedBefore);
          this.setUpChunkImportsAndExportsForModule(module2);
        }
      }
      // prerender allows chunk hashes and names to be generated before finalizing
      preRender(options, inputBase) {
        const magicString = new Bundle$1({ separator: options.compact ? "" : "\n\n" });
        this.usedModules = [];
        this.indentString = getIndentString3(this.orderedModules, options);
        const n3 = options.compact ? "" : "\n";
        const _ = options.compact ? "" : " ";
        const renderOptions = {
          compact: options.compact,
          dynamicImportFunction: options.dynamicImportFunction,
          exportNamesByVariable: this.exportNamesByVariable,
          format: options.format,
          freeze: options.freeze,
          indent: this.indentString,
          namespaceToStringTag: options.namespaceToStringTag,
          outputPluginDriver: this.pluginDriver,
          varOrConst: options.preferConst ? "const" : "var"
        };
        if (options.hoistTransitiveImports && !this.outputOptions.preserveModules && this.facadeModule !== null) {
          for (const dep of this.dependencies) {
            if (dep instanceof _Chunk)
              this.inlineChunkDependencies(dep);
          }
        }
        this.prepareDynamicImportsAndImportMetas();
        this.setIdentifierRenderResolutions(options);
        let hoistedSource = "";
        const renderedModules = this.renderedModules;
        for (const module2 of this.orderedModules) {
          let renderedLength = 0;
          if (module2.isIncluded() || this.includedNamespaces.has(module2)) {
            const source = module2.render(renderOptions).trim();
            renderedLength = source.length();
            if (renderedLength) {
              if (options.compact && source.lastLine().indexOf("//") !== -1)
                source.append("\n");
              this.renderedModuleSources.set(module2, source);
              magicString.addSource(source);
              this.usedModules.push(module2);
            }
            const namespace = module2.namespace;
            if (this.includedNamespaces.has(module2) && !this.outputOptions.preserveModules) {
              const rendered = namespace.renderBlock(renderOptions);
              if (namespace.renderFirst())
                hoistedSource += n3 + rendered;
              else
                magicString.addSource(new MagicString$1(rendered));
            }
          }
          const { renderedExports, removedExports } = module2.getRenderedExports();
          const { renderedModuleSources } = this;
          renderedModules[module2.id] = {
            get code() {
              var _a, _b;
              return (_b = (_a = renderedModuleSources.get(module2)) === null || _a === void 0 ? void 0 : _a.toString()) !== null && _b !== void 0 ? _b : null;
            },
            originalLength: module2.originalCode.length,
            removedExports,
            renderedExports,
            renderedLength
          };
        }
        if (hoistedSource)
          magicString.prepend(hoistedSource + n3 + n3);
        if (this.needsExportsShim) {
          magicString.prepend(`${n3}${renderOptions.varOrConst} ${MISSING_EXPORT_SHIM_VARIABLE}${_}=${_}void 0;${n3}${n3}`);
        }
        if (options.compact) {
          this.renderedSource = magicString;
        } else {
          this.renderedSource = magicString.trim();
        }
        this.renderedHash = void 0;
        if (this.isEmpty && this.getExportNames().length === 0 && this.dependencies.size === 0) {
          const chunkName = this.getChunkName();
          this.inputOptions.onwarn({
            chunkName,
            code: "EMPTY_BUNDLE",
            message: `Generated an empty chunk: "${chunkName}"`
          });
        }
        this.setExternalRenderPaths(options, inputBase);
        this.renderedDependencies = this.getChunkDependencyDeclarations(options);
        this.renderedExports = this.exportMode === "none" ? [] : this.getChunkExportDeclarations(options.format);
      }
      async render(options, addons, outputChunk) {
        timeStart("render format", 2);
        const format = options.format;
        const finalise = finalisers[format];
        if (options.dynamicImportFunction && format !== "es") {
          this.inputOptions.onwarn({
            code: "INVALID_OPTION",
            message: '"output.dynamicImportFunction" is ignored for formats other than "es".'
          });
        }
        for (const dependency of this.dependencies) {
          const renderedDependency = this.renderedDependencies.get(dependency);
          if (dependency instanceof ExternalModule) {
            const originalId = dependency.renderPath;
            renderedDependency.id = escapeId(dependency.renormalizeRenderPath ? this.getRelativePath(originalId, false) : originalId);
          } else {
            renderedDependency.namedExportsMode = dependency.exportMode !== "default";
            renderedDependency.id = escapeId(this.getRelativePath(dependency.id, false));
          }
        }
        this.finaliseDynamicImports(options);
        this.finaliseImportMetas(format);
        const hasExports = this.renderedExports.length !== 0 || [...this.renderedDependencies.values()].some((dep) => dep.reexports && dep.reexports.length !== 0);
        let usesTopLevelAwait = false;
        const accessedGlobals = /* @__PURE__ */ new Set();
        for (const module2 of this.orderedModules) {
          if (module2.usesTopLevelAwait) {
            usesTopLevelAwait = true;
          }
          const accessedGlobalVariables = this.accessedGlobalsByScope.get(module2.scope);
          if (accessedGlobalVariables) {
            for (const name of accessedGlobalVariables) {
              accessedGlobals.add(name);
            }
          }
        }
        if (usesTopLevelAwait && format !== "es" && format !== "system") {
          return error({
            code: "INVALID_TLA_FORMAT",
            message: `Module format ${format} does not support top-level await. Use the "es" or "system" output formats rather.`
          });
        }
        if (!this.id) {
          throw new Error("Internal Error: expecting chunk id");
        }
        const magicString = finalise(this.renderedSource, {
          accessedGlobals,
          dependencies: [...this.renderedDependencies.values()],
          exports: this.renderedExports,
          hasExports,
          id: this.id,
          indentString: this.indentString,
          intro: addons.intro,
          isEntryFacade: this.outputOptions.preserveModules || this.facadeModule !== null && this.facadeModule.info.isEntry,
          isModuleFacade: this.facadeModule !== null,
          namedExportsMode: this.exportMode !== "default",
          outro: addons.outro,
          usesTopLevelAwait,
          varOrConst: options.preferConst ? "const" : "var",
          warn: this.inputOptions.onwarn
        }, options);
        if (addons.banner)
          magicString.prepend(addons.banner);
        if (addons.footer)
          magicString.append(addons.footer);
        const prevCode = magicString.toString();
        timeEnd("render format", 2);
        let map2 = null;
        const chunkSourcemapChain = [];
        let code = await renderChunk({
          code: prevCode,
          options,
          outputPluginDriver: this.pluginDriver,
          renderChunk: outputChunk,
          sourcemapChain: chunkSourcemapChain
        });
        if (options.sourcemap) {
          timeStart("sourcemap", 2);
          let file;
          if (options.file)
            file = (0, import_path11.resolve)(options.sourcemapFile || options.file);
          else if (options.dir)
            file = (0, import_path11.resolve)(options.dir, this.id);
          else
            file = (0, import_path11.resolve)(this.id);
          const decodedMap = magicString.generateDecodedMap({});
          map2 = collapseSourcemaps(file, decodedMap, this.usedModules, chunkSourcemapChain, options.sourcemapExcludeSources, this.inputOptions.onwarn);
          map2.sources = map2.sources.map((sourcePath) => {
            const { sourcemapPathTransform } = options;
            if (sourcemapPathTransform) {
              const newSourcePath = sourcemapPathTransform(sourcePath, `${file}.map`);
              if (typeof newSourcePath !== "string") {
                error(errFailedValidation(`sourcemapPathTransform function must return a string.`));
              }
              return newSourcePath;
            }
            return sourcePath;
          }).map(normalize2);
          timeEnd("sourcemap", 2);
        }
        if (!options.compact && code[code.length - 1] !== "\n")
          code += "\n";
        return { code, map: map2 };
      }
      addDependenciesToChunk(moduleDependencies, chunkDependencies) {
        for (const module2 of moduleDependencies) {
          if (module2 instanceof Module) {
            const chunk = this.chunkByModule.get(module2);
            if (chunk && chunk !== this) {
              chunkDependencies.add(chunk);
            }
          } else {
            chunkDependencies.add(module2);
          }
        }
      }
      assignFacadeName({ fileName, name }, facadedModule) {
        if (fileName) {
          this.fileName = fileName;
        } else {
          this.name = this.outputOptions.sanitizeFileName(name || getChunkNameFromModule(facadedModule));
        }
      }
      checkCircularDependencyImport(variable, importingModule) {
        const variableModule = variable.module;
        if (variableModule instanceof Module) {
          const exportChunk = this.chunkByModule.get(variableModule);
          let alternativeReexportModule;
          do {
            alternativeReexportModule = importingModule.alternativeReexportModules.get(variable);
            if (alternativeReexportModule) {
              const exportingChunk = this.chunkByModule.get(alternativeReexportModule);
              if (exportingChunk && exportingChunk !== exportChunk) {
                this.inputOptions.onwarn(errCyclicCrossChunkReexport(variableModule.getExportNamesByVariable().get(variable)[0], variableModule.id, alternativeReexportModule.id, importingModule.id));
              }
              importingModule = alternativeReexportModule;
            }
          } while (alternativeReexportModule);
        }
      }
      computeContentHashWithDependencies(addons, options, existingNames) {
        const hash = createHash();
        hash.update([addons.intro, addons.outro, addons.banner, addons.footer].map((addon) => addon || "").join(":"));
        hash.update(options.format);
        const dependenciesForHashing = /* @__PURE__ */ new Set([this]);
        for (const current2 of dependenciesForHashing) {
          if (current2 instanceof ExternalModule) {
            hash.update(":" + current2.renderPath);
          } else {
            hash.update(current2.getRenderedHash());
            hash.update(current2.generateId(addons, options, existingNames, false));
          }
          if (current2 instanceof ExternalModule)
            continue;
          for (const dependency of [...current2.dependencies, ...current2.dynamicDependencies]) {
            dependenciesForHashing.add(dependency);
          }
        }
        return hash.digest("hex").substr(0, 8);
      }
      ensureReexportsAreAvailableForModule(module2) {
        const map2 = module2.getExportNamesByVariable();
        for (const exportedVariable of map2.keys()) {
          const isSynthetic = exportedVariable instanceof SyntheticNamedExportVariable;
          const importedVariable = isSynthetic ? exportedVariable.getBaseVariable() : exportedVariable;
          if (!(importedVariable instanceof NamespaceVariable && this.outputOptions.preserveModules)) {
            this.checkCircularDependencyImport(importedVariable, module2);
            const exportingModule = importedVariable.module;
            if (exportingModule instanceof Module) {
              const chunk = this.chunkByModule.get(exportingModule);
              if (chunk && chunk !== this) {
                chunk.exports.add(importedVariable);
                if (isSynthetic) {
                  this.imports.add(importedVariable);
                }
              }
            }
          }
        }
      }
      finaliseDynamicImports(options) {
        const stripKnownJsExtensions = options.format === "amd";
        for (const [module2, code] of this.renderedModuleSources) {
          for (const { node, resolution } of module2.dynamicImports) {
            const chunk = this.chunkByModule.get(resolution);
            const facadeChunk = this.facadeChunkByModule.get(resolution);
            if (!resolution || !node.included || chunk === this) {
              continue;
            }
            const renderedResolution = resolution instanceof Module ? `'${this.getRelativePath((facadeChunk || chunk).id, stripKnownJsExtensions)}'` : resolution instanceof ExternalModule ? `'${resolution.renormalizeRenderPath ? this.getRelativePath(resolution.renderPath, stripKnownJsExtensions) : resolution.renderPath}'` : resolution;
            node.renderFinalResolution(code, renderedResolution, resolution instanceof Module && !(facadeChunk === null || facadeChunk === void 0 ? void 0 : facadeChunk.strictFacade) && chunk.exportNamesByVariable.get(resolution.namespace)[0], options);
          }
        }
      }
      finaliseImportMetas(format) {
        for (const [module2, code] of this.renderedModuleSources) {
          for (const importMeta of module2.importMetas) {
            importMeta.renderFinalMechanism(code, this.id, format, this.pluginDriver);
          }
        }
      }
      generateVariableName() {
        if (this.manualChunkAlias) {
          return this.manualChunkAlias;
        }
        const moduleForNaming = this.entryModules[0] || this.implicitEntryModules[0] || this.dynamicEntryModules[0] || this.orderedModules[this.orderedModules.length - 1];
        if (moduleForNaming) {
          return moduleForNaming.chunkName || getAliasName(moduleForNaming.id);
        }
        return "chunk";
      }
      getChunkDependencyDeclarations(options) {
        const importSpecifiers = this.getImportSpecifiers();
        const reexportSpecifiers = this.getReexportSpecifiers();
        const dependencyDeclaration = /* @__PURE__ */ new Map();
        for (const dep of this.dependencies) {
          const imports = importSpecifiers.get(dep) || null;
          const reexports = reexportSpecifiers.get(dep) || null;
          const namedExportsMode = dep instanceof ExternalModule || dep.exportMode !== "default";
          dependencyDeclaration.set(dep, {
            defaultVariableName: dep.defaultVariableName,
            globalName: dep instanceof ExternalModule && (options.format === "umd" || options.format === "iife") && getGlobalName(dep, options.globals, (imports || reexports) !== null, this.inputOptions.onwarn),
            id: void 0,
            imports,
            isChunk: dep instanceof _Chunk,
            name: dep.variableName,
            namedExportsMode,
            namespaceVariableName: dep.namespaceVariableName,
            reexports
          });
        }
        return dependencyDeclaration;
      }
      getChunkExportDeclarations(format) {
        const exports2 = [];
        for (const exportName of this.getExportNames()) {
          if (exportName[0] === "*")
            continue;
          const variable = this.exportsByName[exportName];
          if (!(variable instanceof SyntheticNamedExportVariable)) {
            const module2 = variable.module;
            if (module2 && this.chunkByModule.get(module2) !== this)
              continue;
          }
          let expression = null;
          let hoisted = false;
          let local = variable.getName();
          if (variable instanceof LocalVariable) {
            for (const declaration of variable.declarations) {
              if (declaration.parent instanceof FunctionDeclaration || declaration instanceof ExportDefaultDeclaration && declaration.declaration instanceof FunctionDeclaration) {
                hoisted = true;
                break;
              }
            }
          } else if (variable instanceof SyntheticNamedExportVariable) {
            expression = local;
            if (format === "es") {
              local = variable.renderName;
            }
          }
          exports2.push({
            exported: exportName,
            expression,
            hoisted,
            local
          });
        }
        return exports2;
      }
      getDependenciesToBeDeconflicted(addNonNamespacesAndInteropHelpers, addDependenciesWithoutBindings, interop) {
        const dependencies = /* @__PURE__ */ new Set();
        const deconflictedDefault = /* @__PURE__ */ new Set();
        const deconflictedNamespace = /* @__PURE__ */ new Set();
        for (const variable of [...this.exportNamesByVariable.keys(), ...this.imports]) {
          if (addNonNamespacesAndInteropHelpers || variable.isNamespace) {
            const module2 = variable.module;
            if (module2 instanceof ExternalModule) {
              dependencies.add(module2);
              if (addNonNamespacesAndInteropHelpers) {
                if (variable.name === "default") {
                  if (defaultInteropHelpersByInteropType[String(interop(module2.id))]) {
                    deconflictedDefault.add(module2);
                  }
                } else if (variable.name === "*") {
                  if (namespaceInteropHelpersByInteropType[String(interop(module2.id))]) {
                    deconflictedNamespace.add(module2);
                  }
                }
              }
            } else {
              const chunk = this.chunkByModule.get(module2);
              if (chunk !== this) {
                dependencies.add(chunk);
                if (addNonNamespacesAndInteropHelpers && chunk.exportMode === "default" && variable.isNamespace) {
                  deconflictedNamespace.add(chunk);
                }
              }
            }
          }
        }
        if (addDependenciesWithoutBindings) {
          for (const dependency of this.dependencies) {
            dependencies.add(dependency);
          }
        }
        return { deconflictedDefault, deconflictedNamespace, dependencies };
      }
      getFallbackChunkName() {
        if (this.manualChunkAlias) {
          return this.manualChunkAlias;
        }
        if (this.dynamicName) {
          return this.dynamicName;
        }
        if (this.fileName) {
          return getAliasName(this.fileName);
        }
        return getAliasName(this.orderedModules[this.orderedModules.length - 1].id);
      }
      getImportSpecifiers() {
        const { interop } = this.outputOptions;
        const importsByDependency = /* @__PURE__ */ new Map();
        for (const variable of this.imports) {
          const module2 = variable.module;
          let dependency;
          let imported;
          if (module2 instanceof ExternalModule) {
            dependency = module2;
            imported = variable.name;
            if (imported !== "default" && imported !== "*" && interop(module2.id) === "defaultOnly") {
              return error(errUnexpectedNamedImport(module2.id, imported, false));
            }
          } else {
            dependency = this.chunkByModule.get(module2);
            imported = dependency.getVariableExportName(variable);
          }
          getOrCreate(importsByDependency, dependency, () => []).push({
            imported,
            local: variable.getName()
          });
        }
        return importsByDependency;
      }
      getImportedBindingsPerDependency() {
        const importSpecifiers = {};
        for (const [dependency, declaration] of this.renderedDependencies) {
          const specifiers = /* @__PURE__ */ new Set();
          if (declaration.imports) {
            for (const { imported } of declaration.imports) {
              specifiers.add(imported);
            }
          }
          if (declaration.reexports) {
            for (const { imported } of declaration.reexports) {
              specifiers.add(imported);
            }
          }
          importSpecifiers[dependency.id] = [...specifiers];
        }
        return importSpecifiers;
      }
      getReexportSpecifiers() {
        const { externalLiveBindings, interop } = this.outputOptions;
        const reexportSpecifiers = /* @__PURE__ */ new Map();
        for (let exportName of this.getExportNames()) {
          let dependency;
          let imported;
          let needsLiveBinding = false;
          if (exportName[0] === "*") {
            const id = exportName.substr(1);
            if (interop(id) === "defaultOnly") {
              this.inputOptions.onwarn(errUnexpectedNamespaceReexport(id));
            }
            needsLiveBinding = externalLiveBindings;
            dependency = this.modulesById.get(id);
            imported = exportName = "*";
          } else {
            const variable = this.exportsByName[exportName];
            if (variable instanceof SyntheticNamedExportVariable)
              continue;
            const module2 = variable.module;
            if (module2 instanceof Module) {
              dependency = this.chunkByModule.get(module2);
              if (dependency === this)
                continue;
              imported = dependency.getVariableExportName(variable);
              needsLiveBinding = variable.isReassigned;
            } else {
              dependency = module2;
              imported = variable.name;
              if (imported !== "default" && imported !== "*" && interop(module2.id) === "defaultOnly") {
                return error(errUnexpectedNamedImport(module2.id, imported, true));
              }
              needsLiveBinding = externalLiveBindings && (imported !== "default" || isDefaultAProperty(String(interop(module2.id)), true));
            }
          }
          getOrCreate(reexportSpecifiers, dependency, () => []).push({
            imported,
            needsLiveBinding,
            reexported: exportName
          });
        }
        return reexportSpecifiers;
      }
      getReferencedFiles() {
        const referencedFiles = [];
        for (const module2 of this.orderedModules) {
          for (const meta of module2.importMetas) {
            const fileName = meta.getReferencedFileName(this.pluginDriver);
            if (fileName) {
              referencedFiles.push(fileName);
            }
          }
        }
        return referencedFiles;
      }
      getRelativePath(targetPath, stripJsExtension) {
        let relativePath3 = normalize2(relative3((0, import_path11.dirname)(this.id), targetPath));
        if (stripJsExtension && relativePath3.endsWith(".js")) {
          relativePath3 = relativePath3.slice(0, -3);
        }
        if (relativePath3 === "..")
          return "../../" + (0, import_path11.basename)(targetPath);
        if (relativePath3 === "")
          return "../" + (0, import_path11.basename)(targetPath);
        return relativePath3.startsWith("../") ? relativePath3 : "./" + relativePath3;
      }
      inlineChunkDependencies(chunk) {
        for (const dep of chunk.dependencies) {
          if (this.dependencies.has(dep))
            continue;
          this.dependencies.add(dep);
          if (dep instanceof _Chunk) {
            this.inlineChunkDependencies(dep);
          }
        }
      }
      prepareDynamicImportsAndImportMetas() {
        var _a;
        const accessedGlobalsByScope = this.accessedGlobalsByScope;
        for (const module2 of this.orderedModules) {
          for (const { node, resolution } of module2.dynamicImports) {
            if (node.included) {
              if (resolution instanceof Module) {
                const chunk = this.chunkByModule.get(resolution);
                if (chunk === this) {
                  node.setInternalResolution(resolution.namespace);
                } else {
                  node.setExternalResolution(((_a = this.facadeChunkByModule.get(resolution)) === null || _a === void 0 ? void 0 : _a.exportMode) || chunk.exportMode, resolution, this.outputOptions, this.pluginDriver, accessedGlobalsByScope);
                }
              } else {
                node.setExternalResolution("external", resolution, this.outputOptions, this.pluginDriver, accessedGlobalsByScope);
              }
            }
          }
          for (const importMeta of module2.importMetas) {
            importMeta.addAccessedGlobals(this.outputOptions.format, accessedGlobalsByScope);
          }
        }
      }
      setExternalRenderPaths(options, inputBase) {
        for (const dependency of [...this.dependencies, ...this.dynamicDependencies]) {
          if (dependency instanceof ExternalModule) {
            dependency.setRenderPath(options, inputBase);
          }
        }
      }
      setIdentifierRenderResolutions({ format, interop, namespaceToStringTag }) {
        const syntheticExports = /* @__PURE__ */ new Set();
        for (const exportName of this.getExportNames()) {
          const exportVariable = this.exportsByName[exportName];
          if (exportVariable instanceof ExportShimVariable) {
            this.needsExportsShim = true;
          }
          if (format !== "es" && format !== "system" && exportVariable.isReassigned && !exportVariable.isId) {
            exportVariable.setRenderNames("exports", exportName);
          } else if (exportVariable instanceof SyntheticNamedExportVariable) {
            syntheticExports.add(exportVariable);
          } else {
            exportVariable.setRenderNames(null, null);
          }
        }
        const usedNames = /* @__PURE__ */ new Set(["Object", "Promise"]);
        if (this.needsExportsShim) {
          usedNames.add(MISSING_EXPORT_SHIM_VARIABLE);
        }
        if (namespaceToStringTag) {
          usedNames.add("Symbol");
        }
        switch (format) {
          case "system":
            usedNames.add("module").add("exports");
            break;
          case "es":
            break;
          case "cjs":
            usedNames.add("module").add("require").add("__filename").add("__dirname");
          default:
            usedNames.add("exports");
            for (const helper of HELPER_NAMES) {
              usedNames.add(helper);
            }
        }
        deconflictChunk(this.orderedModules, this.getDependenciesToBeDeconflicted(format !== "es" && format !== "system", format === "amd" || format === "umd" || format === "iife", interop), this.imports, usedNames, format, interop, this.outputOptions.preserveModules, this.outputOptions.externalLiveBindings, this.chunkByModule, syntheticExports, this.exportNamesByVariable, this.accessedGlobalsByScope, this.includedNamespaces);
      }
      setUpChunkImportsAndExportsForModule(module2) {
        const moduleImports = new Set(module2.imports);
        if (!this.outputOptions.preserveModules) {
          if (this.includedNamespaces.has(module2)) {
            const memberVariables = module2.namespace.getMemberVariables();
            for (const variable of Object.values(memberVariables)) {
              moduleImports.add(variable);
            }
          }
        }
        for (let variable of moduleImports) {
          if (variable instanceof ExportDefaultVariable) {
            variable = variable.getOriginalVariable();
          }
          if (variable instanceof SyntheticNamedExportVariable) {
            variable = variable.getBaseVariable();
          }
          const chunk = this.chunkByModule.get(variable.module);
          if (chunk !== this) {
            this.imports.add(variable);
            if (!(variable instanceof NamespaceVariable && this.outputOptions.preserveModules) && variable.module instanceof Module) {
              chunk.exports.add(variable);
              this.checkCircularDependencyImport(variable, module2);
            }
          }
        }
        if (this.includedNamespaces.has(module2) || module2.info.isEntry && module2.preserveSignature !== false || module2.includedDynamicImporters.some((importer) => this.chunkByModule.get(importer) !== this)) {
          this.ensureReexportsAreAvailableForModule(module2);
        }
        for (const { node, resolution } of module2.dynamicImports) {
          if (node.included && resolution instanceof Module && this.chunkByModule.get(resolution) === this && !this.includedNamespaces.has(resolution)) {
            this.includedNamespaces.add(resolution);
            this.ensureReexportsAreAvailableForModule(resolution);
          }
        }
      }
    };
    (function(BuildPhase2) {
      BuildPhase2[BuildPhase2["LOAD_AND_PARSE"] = 0] = "LOAD_AND_PARSE";
      BuildPhase2[BuildPhase2["ANALYSE"] = 1] = "ANALYSE";
      BuildPhase2[BuildPhase2["GENERATE"] = 2] = "GENERATE";
    })(BuildPhase || (BuildPhase = {}));
    FILE_PLACEHOLDER = {
      type: "placeholder"
    };
    FileEmitter = class {
      constructor(graph, options, baseFileEmitter) {
        this.graph = graph;
        this.options = options;
        this.bundle = null;
        this.facadeChunkByModule = null;
        this.outputOptions = null;
        this.assertAssetsFinalized = () => {
          for (const [referenceId, emittedFile] of this.filesByReferenceId.entries()) {
            if (emittedFile.type === "asset" && typeof emittedFile.fileName !== "string")
              return error(errNoAssetSourceSet(emittedFile.name || referenceId));
          }
        };
        this.emitFile = (emittedFile) => {
          if (!hasValidType(emittedFile)) {
            return error(errFailedValidation(`Emitted files must be of type "asset" or "chunk", received "${emittedFile && emittedFile.type}".`));
          }
          if (!hasValidName(emittedFile)) {
            return error(errFailedValidation(`The "fileName" or "name" properties of emitted files must be strings that are neither absolute nor relative paths, received "${emittedFile.fileName || emittedFile.name}".`));
          }
          if (emittedFile.type === "chunk") {
            return this.emitChunk(emittedFile);
          } else {
            return this.emitAsset(emittedFile);
          }
        };
        this.getFileName = (fileReferenceId) => {
          const emittedFile = this.filesByReferenceId.get(fileReferenceId);
          if (!emittedFile)
            return error(errFileReferenceIdNotFoundForFilename(fileReferenceId));
          if (emittedFile.type === "chunk") {
            return getChunkFileName(emittedFile, this.facadeChunkByModule);
          } else {
            return getAssetFileName(emittedFile, fileReferenceId);
          }
        };
        this.setAssetSource = (referenceId, requestedSource) => {
          const consumedFile = this.filesByReferenceId.get(referenceId);
          if (!consumedFile)
            return error(errAssetReferenceIdNotFoundForSetSource(referenceId));
          if (consumedFile.type !== "asset") {
            return error(errFailedValidation(`Asset sources can only be set for emitted assets but "${referenceId}" is an emitted chunk.`));
          }
          if (consumedFile.source !== void 0) {
            return error(errAssetSourceAlreadySet(consumedFile.name || referenceId));
          }
          const source = getValidSource(requestedSource, consumedFile, referenceId);
          if (this.bundle) {
            this.finalizeAsset(consumedFile, source, referenceId, this.bundle);
          } else {
            consumedFile.source = source;
          }
        };
        this.setOutputBundle = (outputBundle, outputOptions, facadeChunkByModule) => {
          this.outputOptions = outputOptions;
          this.bundle = outputBundle;
          this.facadeChunkByModule = facadeChunkByModule;
          for (const emittedFile of this.filesByReferenceId.values()) {
            if (emittedFile.fileName) {
              reserveFileNameInBundle(emittedFile.fileName, this.bundle, this.options.onwarn);
            }
          }
          for (const [referenceId, consumedFile] of this.filesByReferenceId.entries()) {
            if (consumedFile.type === "asset" && consumedFile.source !== void 0) {
              this.finalizeAsset(consumedFile, consumedFile.source, referenceId, this.bundle);
            }
          }
        };
        this.filesByReferenceId = baseFileEmitter ? new Map(baseFileEmitter.filesByReferenceId) : /* @__PURE__ */ new Map();
      }
      assignReferenceId(file, idBase) {
        let referenceId;
        do {
          const hash = createHash();
          if (referenceId) {
            hash.update(referenceId);
          } else {
            hash.update(idBase);
          }
          referenceId = hash.digest("hex").substr(0, 8);
        } while (this.filesByReferenceId.has(referenceId));
        this.filesByReferenceId.set(referenceId, file);
        return referenceId;
      }
      emitAsset(emittedAsset) {
        const source = typeof emittedAsset.source !== "undefined" ? getValidSource(emittedAsset.source, emittedAsset, null) : void 0;
        const consumedAsset = {
          fileName: emittedAsset.fileName,
          name: emittedAsset.name,
          source,
          type: "asset"
        };
        const referenceId = this.assignReferenceId(consumedAsset, emittedAsset.fileName || emittedAsset.name || emittedAsset.type);
        if (this.bundle) {
          if (emittedAsset.fileName) {
            reserveFileNameInBundle(emittedAsset.fileName, this.bundle, this.options.onwarn);
          }
          if (source !== void 0) {
            this.finalizeAsset(consumedAsset, source, referenceId, this.bundle);
          }
        }
        return referenceId;
      }
      emitChunk(emittedChunk) {
        if (this.graph.phase > BuildPhase.LOAD_AND_PARSE) {
          return error(errInvalidRollupPhaseForChunkEmission());
        }
        if (typeof emittedChunk.id !== "string") {
          return error(errFailedValidation(`Emitted chunks need to have a valid string id, received "${emittedChunk.id}"`));
        }
        const consumedChunk = {
          fileName: emittedChunk.fileName,
          module: null,
          name: emittedChunk.name || emittedChunk.id,
          type: "chunk"
        };
        this.graph.moduleLoader.emitChunk(emittedChunk).then((module2) => consumedChunk.module = module2).catch(() => {
        });
        return this.assignReferenceId(consumedChunk, emittedChunk.id);
      }
      finalizeAsset(consumedFile, source, referenceId, bundle) {
        const fileName = consumedFile.fileName || findExistingAssetFileNameWithSource(bundle, source) || generateAssetFileName(consumedFile.name, source, this.outputOptions, bundle);
        const assetWithFileName = { ...consumedFile, fileName, source };
        this.filesByReferenceId.set(referenceId, assetWithFileName);
        const { options } = this;
        bundle[fileName] = {
          fileName,
          get isAsset() {
            warnDeprecation(`Accessing "isAsset" on files in the bundle is deprecated, please use "type === 'asset'" instead`, true, options);
            return true;
          },
          name: consumedFile.name,
          source,
          type: "asset"
        };
      }
    };
    concatSep = (out, next) => next ? `${out}
${next}` : out;
    concatDblSep = (out, next) => next ? `${out}

${next}` : out;
    compareExecIndex = (unitA, unitB) => unitA.execIndex > unitB.execIndex ? 1 : -1;
    Bundle2 = class {
      constructor(outputOptions, unsetOptions, inputOptions, pluginDriver, graph) {
        this.outputOptions = outputOptions;
        this.unsetOptions = unsetOptions;
        this.inputOptions = inputOptions;
        this.pluginDriver = pluginDriver;
        this.graph = graph;
        this.facadeChunkByModule = /* @__PURE__ */ new Map();
        this.includedNamespaces = /* @__PURE__ */ new Set();
      }
      async generate(isWrite) {
        timeStart("GENERATE", 1);
        const outputBundle = /* @__PURE__ */ Object.create(null);
        this.pluginDriver.setOutputBundle(outputBundle, this.outputOptions, this.facadeChunkByModule);
        try {
          await this.pluginDriver.hookParallel("renderStart", [this.outputOptions, this.inputOptions]);
          timeStart("generate chunks", 2);
          const chunks = await this.generateChunks();
          if (chunks.length > 1) {
            validateOptionsForMultiChunkOutput(this.outputOptions, this.inputOptions.onwarn);
          }
          const inputBase = commondir(getAbsoluteEntryModulePaths(chunks));
          timeEnd("generate chunks", 2);
          timeStart("render modules", 2);
          const addons = await createAddons(this.outputOptions, this.pluginDriver);
          this.prerenderChunks(chunks, inputBase);
          timeEnd("render modules", 2);
          await this.addFinalizedChunksToBundle(chunks, inputBase, addons, outputBundle);
        } catch (error2) {
          await this.pluginDriver.hookParallel("renderError", [error2]);
          throw error2;
        }
        await this.pluginDriver.hookSeq("generateBundle", [
          this.outputOptions,
          outputBundle,
          isWrite
        ]);
        this.finaliseAssets(outputBundle);
        timeEnd("GENERATE", 1);
        return outputBundle;
      }
      async addFinalizedChunksToBundle(chunks, inputBase, addons, outputBundle) {
        this.assignChunkIds(chunks, inputBase, addons, outputBundle);
        for (const chunk of chunks) {
          outputBundle[chunk.id] = chunk.getChunkInfoWithFileNames();
        }
        await Promise.all(chunks.map(async (chunk) => {
          const outputChunk = outputBundle[chunk.id];
          Object.assign(outputChunk, await chunk.render(this.outputOptions, addons, outputChunk));
        }));
      }
      async addManualChunks(manualChunks) {
        const manualChunkAliasByEntry = /* @__PURE__ */ new Map();
        const chunkEntries = await Promise.all(Object.entries(manualChunks).map(async ([alias, files]) => ({
          alias,
          entries: await this.graph.moduleLoader.addAdditionalModules(files)
        })));
        for (const { alias, entries } of chunkEntries) {
          for (const entry of entries) {
            addModuleToManualChunk(alias, entry, manualChunkAliasByEntry);
          }
        }
        return manualChunkAliasByEntry;
      }
      assignChunkIds(chunks, inputBase, addons, bundle) {
        const entryChunks = [];
        const otherChunks = [];
        for (const chunk of chunks) {
          (chunk.facadeModule && chunk.facadeModule.isUserDefinedEntryPoint ? entryChunks : otherChunks).push(chunk);
        }
        const chunksForNaming = entryChunks.concat(otherChunks);
        for (const chunk of chunksForNaming) {
          if (this.outputOptions.file) {
            chunk.id = (0, import_path11.basename)(this.outputOptions.file);
          } else if (this.outputOptions.preserveModules) {
            chunk.id = chunk.generateIdPreserveModules(inputBase, this.outputOptions, bundle, this.unsetOptions);
          } else {
            chunk.id = chunk.generateId(addons, this.outputOptions, bundle, true);
          }
          bundle[chunk.id] = FILE_PLACEHOLDER;
        }
      }
      assignManualChunks(getManualChunk) {
        const manualChunkAliasByEntry = /* @__PURE__ */ new Map();
        const manualChunksApi = {
          getModuleIds: () => this.graph.modulesById.keys(),
          getModuleInfo: this.graph.getModuleInfo
        };
        for (const module2 of this.graph.modulesById.values()) {
          if (module2 instanceof Module) {
            const manualChunkAlias = getManualChunk(module2.id, manualChunksApi);
            if (typeof manualChunkAlias === "string") {
              addModuleToManualChunk(manualChunkAlias, module2, manualChunkAliasByEntry);
            }
          }
        }
        return manualChunkAliasByEntry;
      }
      finaliseAssets(outputBundle) {
        for (const file of Object.values(outputBundle)) {
          if (!file.type) {
            warnDeprecation('A plugin is directly adding properties to the bundle object in the "generateBundle" hook. This is deprecated and will be removed in a future Rollup version, please use "this.emitFile" instead.', true, this.inputOptions);
            file.type = "asset";
          }
          if (this.outputOptions.validate && typeof file.code == "string") {
            try {
              this.graph.contextParse(file.code, {
                allowHashBang: true,
                ecmaVersion: "latest"
              });
            } catch (exception) {
              this.inputOptions.onwarn(errChunkInvalid(file, exception));
            }
          }
        }
        this.pluginDriver.finaliseAssets();
      }
      async generateChunks() {
        const { manualChunks } = this.outputOptions;
        const manualChunkAliasByEntry = typeof manualChunks === "object" ? await this.addManualChunks(manualChunks) : this.assignManualChunks(manualChunks);
        const chunks = [];
        const chunkByModule = /* @__PURE__ */ new Map();
        for (const { alias, modules } of this.outputOptions.inlineDynamicImports ? [{ alias: null, modules: getIncludedModules(this.graph.modulesById) }] : this.outputOptions.preserveModules ? getIncludedModules(this.graph.modulesById).map((module2) => ({
          alias: null,
          modules: [module2]
        })) : getChunkAssignments(this.graph.entryModules, manualChunkAliasByEntry)) {
          sortByExecutionOrder(modules);
          const chunk = new Chunk3(modules, this.inputOptions, this.outputOptions, this.unsetOptions, this.pluginDriver, this.graph.modulesById, chunkByModule, this.facadeChunkByModule, this.includedNamespaces, alias);
          chunks.push(chunk);
          for (const module2 of modules) {
            chunkByModule.set(module2, chunk);
          }
        }
        for (const chunk of chunks) {
          chunk.link();
        }
        const facades = [];
        for (const chunk of chunks) {
          facades.push(...chunk.generateFacades());
        }
        return [...chunks, ...facades];
      }
      prerenderChunks(chunks, inputBase) {
        for (const chunk of chunks) {
          chunk.generateExports();
        }
        for (const chunk of chunks) {
          chunk.preRender(this.outputOptions, inputBase);
        }
      }
    };
    reservedWords3 = {
      3: "abstract boolean byte char class double enum export extends final float goto implements import int interface long native package private protected public short static super synchronized throws transient volatile",
      5: "class enum extends super const export import",
      6: "enum",
      strict: "implements interface let package private protected public static yield",
      strictBind: "eval arguments"
    };
    ecma5AndLessKeywords = "break case catch continue debugger default do else finally for function if return switch throw try var while with null true false instanceof typeof void delete new in this";
    keywords = {
      5: ecma5AndLessKeywords,
      "5module": ecma5AndLessKeywords + " export import",
      6: ecma5AndLessKeywords + " const class extends export import super"
    };
    keywordRelationalOperator = /^in(stanceof)?$/;
    nonASCIIidentifierStartChars = "\xAA\xB5\xBA\xC0-\xD6\xD8-\xF6\xF8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0370-\u0374\u0376\u0377\u037A-\u037D\u037F\u0386\u0388-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5\u03F7-\u0481\u048A-\u052F\u0531-\u0556\u0559\u0560-\u0588\u05D0-\u05EA\u05EF-\u05F2\u0620-\u064A\u066E\u066F\u0671-\u06D3\u06D5\u06E5\u06E6\u06EE\u06EF\u06FA-\u06FC\u06FF\u0710\u0712-\u072F\u074D-\u07A5\u07B1\u07CA-\u07EA\u07F4\u07F5\u07FA\u0800-\u0815\u081A\u0824\u0828\u0840-\u0858\u0860-\u086A\u08A0-\u08B4\u08B6-\u08C7\u0904-\u0939\u093D\u0950\u0958-\u0961\u0971-\u0980\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2\u09B6-\u09B9\u09BD\u09CE\u09DC\u09DD\u09DF-\u09E1\u09F0\u09F1\u09FC\u0A05-\u0A0A\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39\u0A59-\u0A5C\u0A5E\u0A72-\u0A74\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABD\u0AD0\u0AE0\u0AE1\u0AF9\u0B05-\u0B0C\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3D\u0B5C\u0B5D\u0B5F-\u0B61\u0B71\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BD0\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C39\u0C3D\u0C58-\u0C5A\u0C60\u0C61\u0C80\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3\u0CB5-\u0CB9\u0CBD\u0CDE\u0CE0\u0CE1\u0CF1\u0CF2\u0D04-\u0D0C\u0D0E-\u0D10\u0D12-\u0D3A\u0D3D\u0D4E\u0D54-\u0D56\u0D5F-\u0D61\u0D7A-\u0D7F\u0D85-\u0D96\u0D9A-\u0DB1\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0E01-\u0E30\u0E32\u0E33\u0E40-\u0E46\u0E81\u0E82\u0E84\u0E86-\u0E8A\u0E8C-\u0EA3\u0EA5\u0EA7-\u0EB0\u0EB2\u0EB3\u0EBD\u0EC0-\u0EC4\u0EC6\u0EDC-\u0EDF\u0F00\u0F40-\u0F47\u0F49-\u0F6C\u0F88-\u0F8C\u1000-\u102A\u103F\u1050-\u1055\u105A-\u105D\u1061\u1065\u1066\u106E-\u1070\u1075-\u1081\u108E\u10A0-\u10C5\u10C7\u10CD\u10D0-\u10FA\u10FC-\u1248\u124A-\u124D\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310\u1312-\u1315\u1318-\u135A\u1380-\u138F\u13A0-\u13F5\u13F8-\u13FD\u1401-\u166C\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u16EE-\u16F8\u1700-\u170C\u170E-\u1711\u1720-\u1731\u1740-\u1751\u1760-\u176C\u176E-\u1770\u1780-\u17B3\u17D7\u17DC\u1820-\u1878\u1880-\u18A8\u18AA\u18B0-\u18F5\u1900-\u191E\u1950-\u196D\u1970-\u1974\u1980-\u19AB\u19B0-\u19C9\u1A00-\u1A16\u1A20-\u1A54\u1AA7\u1B05-\u1B33\u1B45-\u1B4B\u1B83-\u1BA0\u1BAE\u1BAF\u1BBA-\u1BE5\u1C00-\u1C23\u1C4D-\u1C4F\u1C5A-\u1C7D\u1C80-\u1C88\u1C90-\u1CBA\u1CBD-\u1CBF\u1CE9-\u1CEC\u1CEE-\u1CF3\u1CF5\u1CF6\u1CFA\u1D00-\u1DBF\u1E00-\u1F15\u1F18-\u1F1D\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u2071\u207F\u2090-\u209C\u2102\u2107\u210A-\u2113\u2115\u2118-\u211D\u2124\u2126\u2128\u212A-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2160-\u2188\u2C00-\u2C2E\u2C30-\u2C5E\u2C60-\u2CE4\u2CEB-\u2CEE\u2CF2\u2CF3\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D80-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\u3005-\u3007\u3021-\u3029\u3031-\u3035\u3038-\u303C\u3041-\u3096\u309B-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312F\u3131-\u318E\u31A0-\u31BF\u31F0-\u31FF\u3400-\u4DBF\u4E00-\u9FFC\uA000-\uA48C\uA4D0-\uA4FD\uA500-\uA60C\uA610-\uA61F\uA62A\uA62B\uA640-\uA66E\uA67F-\uA69D\uA6A0-\uA6EF\uA717-\uA71F\uA722-\uA788\uA78B-\uA7BF\uA7C2-\uA7CA\uA7F5-\uA801\uA803-\uA805\uA807-\uA80A\uA80C-\uA822\uA840-\uA873\uA882-\uA8B3\uA8F2-\uA8F7\uA8FB\uA8FD\uA8FE\uA90A-\uA925\uA930-\uA946\uA960-\uA97C\uA984-\uA9B2\uA9CF\uA9E0-\uA9E4\uA9E6-\uA9EF\uA9FA-\uA9FE\uAA00-\uAA28\uAA40-\uAA42\uAA44-\uAA4B\uAA60-\uAA76\uAA7A\uAA7E-\uAAAF\uAAB1\uAAB5\uAAB6\uAAB9-\uAABD\uAAC0\uAAC2\uAADB-\uAADD\uAAE0-\uAAEA\uAAF2-\uAAF4\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E\uAB30-\uAB5A\uAB5C-\uAB69\uAB70-\uABE2\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFB1D\uFB1F-\uFB28\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE70-\uFE74\uFE76-\uFEFC\uFF21-\uFF3A\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC";
    nonASCIIidentifierChars = "\u200C\u200D\xB7\u0300-\u036F\u0387\u0483-\u0487\u0591-\u05BD\u05BF\u05C1\u05C2\u05C4\u05C5\u05C7\u0610-\u061A\u064B-\u0669\u0670\u06D6-\u06DC\u06DF-\u06E4\u06E7\u06E8\u06EA-\u06ED\u06F0-\u06F9\u0711\u0730-\u074A\u07A6-\u07B0\u07C0-\u07C9\u07EB-\u07F3\u07FD\u0816-\u0819\u081B-\u0823\u0825-\u0827\u0829-\u082D\u0859-\u085B\u08D3-\u08E1\u08E3-\u0903\u093A-\u093C\u093E-\u094F\u0951-\u0957\u0962\u0963\u0966-\u096F\u0981-\u0983\u09BC\u09BE-\u09C4\u09C7\u09C8\u09CB-\u09CD\u09D7\u09E2\u09E3\u09E6-\u09EF\u09FE\u0A01-\u0A03\u0A3C\u0A3E-\u0A42\u0A47\u0A48\u0A4B-\u0A4D\u0A51\u0A66-\u0A71\u0A75\u0A81-\u0A83\u0ABC\u0ABE-\u0AC5\u0AC7-\u0AC9\u0ACB-\u0ACD\u0AE2\u0AE3\u0AE6-\u0AEF\u0AFA-\u0AFF\u0B01-\u0B03\u0B3C\u0B3E-\u0B44\u0B47\u0B48\u0B4B-\u0B4D\u0B55-\u0B57\u0B62\u0B63\u0B66-\u0B6F\u0B82\u0BBE-\u0BC2\u0BC6-\u0BC8\u0BCA-\u0BCD\u0BD7\u0BE6-\u0BEF\u0C00-\u0C04\u0C3E-\u0C44\u0C46-\u0C48\u0C4A-\u0C4D\u0C55\u0C56\u0C62\u0C63\u0C66-\u0C6F\u0C81-\u0C83\u0CBC\u0CBE-\u0CC4\u0CC6-\u0CC8\u0CCA-\u0CCD\u0CD5\u0CD6\u0CE2\u0CE3\u0CE6-\u0CEF\u0D00-\u0D03\u0D3B\u0D3C\u0D3E-\u0D44\u0D46-\u0D48\u0D4A-\u0D4D\u0D57\u0D62\u0D63\u0D66-\u0D6F\u0D81-\u0D83\u0DCA\u0DCF-\u0DD4\u0DD6\u0DD8-\u0DDF\u0DE6-\u0DEF\u0DF2\u0DF3\u0E31\u0E34-\u0E3A\u0E47-\u0E4E\u0E50-\u0E59\u0EB1\u0EB4-\u0EBC\u0EC8-\u0ECD\u0ED0-\u0ED9\u0F18\u0F19\u0F20-\u0F29\u0F35\u0F37\u0F39\u0F3E\u0F3F\u0F71-\u0F84\u0F86\u0F87\u0F8D-\u0F97\u0F99-\u0FBC\u0FC6\u102B-\u103E\u1040-\u1049\u1056-\u1059\u105E-\u1060\u1062-\u1064\u1067-\u106D\u1071-\u1074\u1082-\u108D\u108F-\u109D\u135D-\u135F\u1369-\u1371\u1712-\u1714\u1732-\u1734\u1752\u1753\u1772\u1773\u17B4-\u17D3\u17DD\u17E0-\u17E9\u180B-\u180D\u1810-\u1819\u18A9\u1920-\u192B\u1930-\u193B\u1946-\u194F\u19D0-\u19DA\u1A17-\u1A1B\u1A55-\u1A5E\u1A60-\u1A7C\u1A7F-\u1A89\u1A90-\u1A99\u1AB0-\u1ABD\u1ABF\u1AC0\u1B00-\u1B04\u1B34-\u1B44\u1B50-\u1B59\u1B6B-\u1B73\u1B80-\u1B82\u1BA1-\u1BAD\u1BB0-\u1BB9\u1BE6-\u1BF3\u1C24-\u1C37\u1C40-\u1C49\u1C50-\u1C59\u1CD0-\u1CD2\u1CD4-\u1CE8\u1CED\u1CF4\u1CF7-\u1CF9\u1DC0-\u1DF9\u1DFB-\u1DFF\u203F\u2040\u2054\u20D0-\u20DC\u20E1\u20E5-\u20F0\u2CEF-\u2CF1\u2D7F\u2DE0-\u2DFF\u302A-\u302F\u3099\u309A\uA620-\uA629\uA66F\uA674-\uA67D\uA69E\uA69F\uA6F0\uA6F1\uA802\uA806\uA80B\uA823-\uA827\uA82C\uA880\uA881\uA8B4-\uA8C5\uA8D0-\uA8D9\uA8E0-\uA8F1\uA8FF-\uA909\uA926-\uA92D\uA947-\uA953\uA980-\uA983\uA9B3-\uA9C0\uA9D0-\uA9D9\uA9E5\uA9F0-\uA9F9\uAA29-\uAA36\uAA43\uAA4C\uAA4D\uAA50-\uAA59\uAA7B-\uAA7D\uAAB0\uAAB2-\uAAB4\uAAB7\uAAB8\uAABE\uAABF\uAAC1\uAAEB-\uAAEF\uAAF5\uAAF6\uABE3-\uABEA\uABEC\uABED\uABF0-\uABF9\uFB1E\uFE00-\uFE0F\uFE20-\uFE2F\uFE33\uFE34\uFE4D-\uFE4F\uFF10-\uFF19\uFF3F";
    nonASCIIidentifierStart = new RegExp("[" + nonASCIIidentifierStartChars + "]");
    nonASCIIidentifier = new RegExp("[" + nonASCIIidentifierStartChars + nonASCIIidentifierChars + "]");
    nonASCIIidentifierStartChars = nonASCIIidentifierChars = null;
    astralIdentifierStartCodes = [0, 11, 2, 25, 2, 18, 2, 1, 2, 14, 3, 13, 35, 122, 70, 52, 268, 28, 4, 48, 48, 31, 14, 29, 6, 37, 11, 29, 3, 35, 5, 7, 2, 4, 43, 157, 19, 35, 5, 35, 5, 39, 9, 51, 157, 310, 10, 21, 11, 7, 153, 5, 3, 0, 2, 43, 2, 1, 4, 0, 3, 22, 11, 22, 10, 30, 66, 18, 2, 1, 11, 21, 11, 25, 71, 55, 7, 1, 65, 0, 16, 3, 2, 2, 2, 28, 43, 28, 4, 28, 36, 7, 2, 27, 28, 53, 11, 21, 11, 18, 14, 17, 111, 72, 56, 50, 14, 50, 14, 35, 349, 41, 7, 1, 79, 28, 11, 0, 9, 21, 107, 20, 28, 22, 13, 52, 76, 44, 33, 24, 27, 35, 30, 0, 3, 0, 9, 34, 4, 0, 13, 47, 15, 3, 22, 0, 2, 0, 36, 17, 2, 24, 85, 6, 2, 0, 2, 3, 2, 14, 2, 9, 8, 46, 39, 7, 3, 1, 3, 21, 2, 6, 2, 1, 2, 4, 4, 0, 19, 0, 13, 4, 159, 52, 19, 3, 21, 2, 31, 47, 21, 1, 2, 0, 185, 46, 42, 3, 37, 47, 21, 0, 60, 42, 14, 0, 72, 26, 230, 43, 117, 63, 32, 7, 3, 0, 3, 7, 2, 1, 2, 23, 16, 0, 2, 0, 95, 7, 3, 38, 17, 0, 2, 0, 29, 0, 11, 39, 8, 0, 22, 0, 12, 45, 20, 0, 35, 56, 264, 8, 2, 36, 18, 0, 50, 29, 113, 6, 2, 1, 2, 37, 22, 0, 26, 5, 2, 1, 2, 31, 15, 0, 328, 18, 190, 0, 80, 921, 103, 110, 18, 195, 2749, 1070, 4050, 582, 8634, 568, 8, 30, 114, 29, 19, 47, 17, 3, 32, 20, 6, 18, 689, 63, 129, 74, 6, 0, 67, 12, 65, 1, 2, 0, 29, 6135, 9, 1237, 43, 8, 8952, 286, 50, 2, 18, 3, 9, 395, 2309, 106, 6, 12, 4, 8, 8, 9, 5991, 84, 2, 70, 2, 1, 3, 0, 3, 1, 3, 3, 2, 11, 2, 0, 2, 6, 2, 64, 2, 3, 3, 7, 2, 6, 2, 27, 2, 3, 2, 4, 2, 0, 4, 6, 2, 339, 3, 24, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 7, 2357, 44, 11, 6, 17, 0, 370, 43, 1301, 196, 60, 67, 8, 0, 1205, 3, 2, 26, 2, 1, 2, 0, 3, 0, 2, 9, 2, 3, 2, 0, 2, 0, 7, 0, 5, 0, 2, 0, 2, 0, 2, 2, 2, 1, 2, 0, 3, 0, 2, 0, 2, 0, 2, 0, 2, 0, 2, 1, 2, 0, 3, 3, 2, 6, 2, 3, 2, 3, 2, 0, 2, 9, 2, 16, 6, 2, 2, 4, 2, 16, 4421, 42717, 35, 4148, 12, 221, 3, 5761, 15, 7472, 3104, 541, 1507, 4938];
    astralIdentifierCodes = [509, 0, 227, 0, 150, 4, 294, 9, 1368, 2, 2, 1, 6, 3, 41, 2, 5, 0, 166, 1, 574, 3, 9, 9, 370, 1, 154, 10, 176, 2, 54, 14, 32, 9, 16, 3, 46, 10, 54, 9, 7, 2, 37, 13, 2, 9, 6, 1, 45, 0, 13, 2, 49, 13, 9, 3, 2, 11, 83, 11, 7, 0, 161, 11, 6, 9, 7, 3, 56, 1, 2, 6, 3, 1, 3, 2, 10, 0, 11, 1, 3, 6, 4, 4, 193, 17, 10, 9, 5, 0, 82, 19, 13, 9, 214, 6, 3, 8, 28, 1, 83, 16, 16, 9, 82, 12, 9, 9, 84, 14, 5, 9, 243, 14, 166, 9, 71, 5, 2, 1, 3, 3, 2, 0, 2, 1, 13, 9, 120, 6, 3, 6, 4, 0, 29, 9, 41, 6, 2, 3, 9, 0, 10, 10, 47, 15, 406, 7, 2, 7, 17, 9, 57, 21, 2, 13, 123, 5, 4, 0, 2, 1, 2, 6, 2, 0, 9, 9, 49, 4, 2, 1, 2, 4, 9, 9, 330, 3, 19306, 9, 135, 4, 60, 6, 26, 9, 1014, 0, 2, 54, 8, 3, 82, 0, 12, 1, 19628, 1, 5319, 4, 4, 5, 9, 7, 3, 6, 31, 3, 149, 2, 1418, 49, 513, 54, 5, 49, 9, 0, 15, 0, 23, 4, 2, 14, 1361, 6, 2, 16, 3, 6, 2, 1, 2, 4, 262, 6, 10, 9, 419, 13, 1495, 6, 110, 6, 6, 9, 4759, 9, 787719, 239];
    TokenType = function TokenType2(label, conf) {
      if (conf === void 0) conf = {};
      this.label = label;
      this.keyword = conf.keyword;
      this.beforeExpr = !!conf.beforeExpr;
      this.startsExpr = !!conf.startsExpr;
      this.isLoop = !!conf.isLoop;
      this.isAssign = !!conf.isAssign;
      this.prefix = !!conf.prefix;
      this.postfix = !!conf.postfix;
      this.binop = conf.binop || null;
      this.updateContext = null;
    };
    beforeExpr = { beforeExpr: true };
    startsExpr = { startsExpr: true };
    keywords$1 = {};
    types2 = {
      num: new TokenType("num", startsExpr),
      regexp: new TokenType("regexp", startsExpr),
      string: new TokenType("string", startsExpr),
      name: new TokenType("name", startsExpr),
      privateId: new TokenType("privateId", startsExpr),
      eof: new TokenType("eof"),
      // Punctuation token types.
      bracketL: new TokenType("[", { beforeExpr: true, startsExpr: true }),
      bracketR: new TokenType("]"),
      braceL: new TokenType("{", { beforeExpr: true, startsExpr: true }),
      braceR: new TokenType("}"),
      parenL: new TokenType("(", { beforeExpr: true, startsExpr: true }),
      parenR: new TokenType(")"),
      comma: new TokenType(",", beforeExpr),
      semi: new TokenType(";", beforeExpr),
      colon: new TokenType(":", beforeExpr),
      dot: new TokenType("."),
      question: new TokenType("?", beforeExpr),
      questionDot: new TokenType("?."),
      arrow: new TokenType("=>", beforeExpr),
      template: new TokenType("template"),
      invalidTemplate: new TokenType("invalidTemplate"),
      ellipsis: new TokenType("...", beforeExpr),
      backQuote: new TokenType("`", startsExpr),
      dollarBraceL: new TokenType("${", { beforeExpr: true, startsExpr: true }),
      // Operators. These carry several kinds of properties to help the
      // parser use them properly (the presence of these properties is
      // what categorizes them as operators).
      //
      // `binop`, when present, specifies that this operator is a binary
      // operator, and will refer to its precedence.
      //
      // `prefix` and `postfix` mark the operator as a prefix or postfix
      // unary operator.
      //
      // `isAssign` marks all of `=`, `+=`, `-=` etcetera, which act as
      // binary operators with a very low precedence, that should result
      // in AssignmentExpression nodes.
      eq: new TokenType("=", { beforeExpr: true, isAssign: true }),
      assign: new TokenType("_=", { beforeExpr: true, isAssign: true }),
      incDec: new TokenType("++/--", { prefix: true, postfix: true, startsExpr: true }),
      prefix: new TokenType("!/~", { beforeExpr: true, prefix: true, startsExpr: true }),
      logicalOR: binop("||", 1),
      logicalAND: binop("&&", 2),
      bitwiseOR: binop("|", 3),
      bitwiseXOR: binop("^", 4),
      bitwiseAND: binop("&", 5),
      equality: binop("==/!=/===/!==", 6),
      relational: binop("</>/<=/>=", 7),
      bitShift: binop("<</>>/>>>", 8),
      plusMin: new TokenType("+/-", { beforeExpr: true, binop: 9, prefix: true, startsExpr: true }),
      modulo: binop("%", 10),
      star: binop("*", 10),
      slash: binop("/", 10),
      starstar: new TokenType("**", { beforeExpr: true }),
      coalesce: binop("??", 1),
      // Keyword token types.
      _break: kw("break"),
      _case: kw("case", beforeExpr),
      _catch: kw("catch"),
      _continue: kw("continue"),
      _debugger: kw("debugger"),
      _default: kw("default", beforeExpr),
      _do: kw("do", { isLoop: true, beforeExpr: true }),
      _else: kw("else", beforeExpr),
      _finally: kw("finally"),
      _for: kw("for", { isLoop: true }),
      _function: kw("function", startsExpr),
      _if: kw("if"),
      _return: kw("return", beforeExpr),
      _switch: kw("switch"),
      _throw: kw("throw", beforeExpr),
      _try: kw("try"),
      _var: kw("var"),
      _const: kw("const"),
      _while: kw("while", { isLoop: true }),
      _with: kw("with"),
      _new: kw("new", { beforeExpr: true, startsExpr: true }),
      _this: kw("this", startsExpr),
      _super: kw("super", startsExpr),
      _class: kw("class", startsExpr),
      _extends: kw("extends", beforeExpr),
      _export: kw("export"),
      _import: kw("import", startsExpr),
      _null: kw("null", startsExpr),
      _true: kw("true", startsExpr),
      _false: kw("false", startsExpr),
      _in: kw("in", { beforeExpr: true, binop: 7 }),
      _instanceof: kw("instanceof", { beforeExpr: true, binop: 7 }),
      _typeof: kw("typeof", { beforeExpr: true, prefix: true, startsExpr: true }),
      _void: kw("void", { beforeExpr: true, prefix: true, startsExpr: true }),
      _delete: kw("delete", { beforeExpr: true, prefix: true, startsExpr: true })
    };
    lineBreak = /\r\n?|\n|\u2028|\u2029/;
    lineBreakG = new RegExp(lineBreak.source, "g");
    nonASCIIwhitespace = /[\u1680\u2000-\u200a\u202f\u205f\u3000\ufeff]/;
    skipWhiteSpace = /(?:\s|\/\/.*|\/\*[^]*?\*\/)*/g;
    ref = Object.prototype;
    hasOwnProperty = ref.hasOwnProperty;
    toString6 = ref.toString;
    isArray3 = Array.isArray || function(obj) {
      return toString6.call(obj) === "[object Array]";
    };
    Position = function Position2(line, col) {
      this.line = line;
      this.column = col;
    };
    Position.prototype.offset = function offset(n3) {
      return new Position(this.line, this.column + n3);
    };
    SourceLocation = function SourceLocation2(p, start, end) {
      this.start = start;
      this.end = end;
      if (p.sourceFile !== null) {
        this.source = p.sourceFile;
      }
    };
    defaultOptions = {
      // `ecmaVersion` indicates the ECMAScript version to parse. Must be
      // either 3, 5, 6 (or 2015), 7 (2016), 8 (2017), 9 (2018), 10
      // (2019), 11 (2020), 12 (2021), 13 (2022), or `"latest"` (the
      // latest version the library supports). This influences support
      // for strict mode, the set of reserved words, and support for
      // new syntax features.
      ecmaVersion: null,
      // `sourceType` indicates the mode the code should be parsed in.
      // Can be either `"script"` or `"module"`. This influences global
      // strict mode and parsing of `import` and `export` declarations.
      sourceType: "script",
      // `onInsertedSemicolon` can be a callback that will be called
      // when a semicolon is automatically inserted. It will be passed
      // the position of the comma as an offset, and if `locations` is
      // enabled, it is given the location as a `{line, column}` object
      // as second argument.
      onInsertedSemicolon: null,
      // `onTrailingComma` is similar to `onInsertedSemicolon`, but for
      // trailing commas.
      onTrailingComma: null,
      // By default, reserved words are only enforced if ecmaVersion >= 5.
      // Set `allowReserved` to a boolean value to explicitly turn this on
      // an off. When this option has the value "never", reserved words
      // and keywords can also not be used as property names.
      allowReserved: null,
      // When enabled, a return at the top level is not considered an
      // error.
      allowReturnOutsideFunction: false,
      // When enabled, import/export statements are not constrained to
      // appearing at the top of the program, and an import.meta expression
      // in a script isn't considered an error.
      allowImportExportEverywhere: false,
      // By default, await identifiers are allowed to appear at the top-level scope only if ecmaVersion >= 2022.
      // When enabled, await identifiers are allowed to appear at the top-level scope,
      // but they are still not allowed in non-async functions.
      allowAwaitOutsideFunction: null,
      // When enabled, super identifiers are not constrained to
      // appearing in methods and do not raise an error when they appear elsewhere.
      allowSuperOutsideMethod: null,
      // When enabled, hashbang directive in the beginning of file
      // is allowed and treated as a line comment.
      allowHashBang: false,
      // When `locations` is on, `loc` properties holding objects with
      // `start` and `end` properties in `{line, column}` form (with
      // line being 1-based and column 0-based) will be attached to the
      // nodes.
      locations: false,
      // A function can be passed as `onToken` option, which will
      // cause Acorn to call that function with object in the same
      // format as tokens returned from `tokenizer().getToken()`. Note
      // that you are not allowed to call the parser from the
      // callback—that will corrupt its internal state.
      onToken: null,
      // A function can be passed as `onComment` option, which will
      // cause Acorn to call that function with `(block, text, start,
      // end)` parameters whenever a comment is skipped. `block` is a
      // boolean indicating whether this is a block (`/* */`) comment,
      // `text` is the content of the comment, and `start` and `end` are
      // character offsets that denote the start and end of the comment.
      // When the `locations` option is on, two more parameters are
      // passed, the full `{line, column}` locations of the start and
      // end of the comments. Note that you are not allowed to call the
      // parser from the callback—that will corrupt its internal state.
      onComment: null,
      // Nodes have their start and end characters offsets recorded in
      // `start` and `end` properties (directly on the node, rather than
      // the `loc` object, which holds line/column data. To also add a
      // [semi-standardized][range] `range` property holding a `[start,
      // end]` array with the same numbers, set the `ranges` option to
      // `true`.
      //
      // [range]: https://bugzilla.mozilla.org/show_bug.cgi?id=745678
      ranges: false,
      // It is possible to parse multiple files into a single AST by
      // passing the tree produced by parsing the first file as
      // `program` option in subsequent parses. This will add the
      // toplevel forms of the parsed file to the `Program` (top) node
      // of an existing parse tree.
      program: null,
      // When `locations` is on, you can pass this to record the source
      // file in every node's `loc` object.
      sourceFile: null,
      // This value, if given, is stored in every node, whether
      // `locations` is on or off.
      directSourceFile: null,
      // When enabled, parenthesized expressions are represented by
      // (non-standard) ParenthesizedExpression nodes
      preserveParens: false
    };
    warnedAboutEcmaVersion = false;
    SCOPE_TOP = 1;
    SCOPE_FUNCTION = 2;
    SCOPE_VAR = SCOPE_TOP | SCOPE_FUNCTION;
    SCOPE_ASYNC = 4;
    SCOPE_GENERATOR = 8;
    SCOPE_ARROW = 16;
    SCOPE_SIMPLE_CATCH = 32;
    SCOPE_SUPER = 64;
    SCOPE_DIRECT_SUPER = 128;
    BIND_NONE = 0;
    BIND_VAR = 1;
    BIND_LEXICAL = 2;
    BIND_FUNCTION = 3;
    BIND_SIMPLE_CATCH = 4;
    BIND_OUTSIDE = 5;
    Parser = function Parser2(options, input, startPos) {
      this.options = options = getOptions(options);
      this.sourceFile = options.sourceFile;
      this.keywords = wordsRegexp(keywords[options.ecmaVersion >= 6 ? 6 : options.sourceType === "module" ? "5module" : 5]);
      var reserved = "";
      if (options.allowReserved !== true) {
        reserved = reservedWords3[options.ecmaVersion >= 6 ? 6 : options.ecmaVersion === 5 ? 5 : 3];
        if (options.sourceType === "module") {
          reserved += " await";
        }
      }
      this.reservedWords = wordsRegexp(reserved);
      var reservedStrict = (reserved ? reserved + " " : "") + reservedWords3.strict;
      this.reservedWordsStrict = wordsRegexp(reservedStrict);
      this.reservedWordsStrictBind = wordsRegexp(reservedStrict + " " + reservedWords3.strictBind);
      this.input = String(input);
      this.containsEsc = false;
      if (startPos) {
        this.pos = startPos;
        this.lineStart = this.input.lastIndexOf("\n", startPos - 1) + 1;
        this.curLine = this.input.slice(0, this.lineStart).split(lineBreak).length;
      } else {
        this.pos = this.lineStart = 0;
        this.curLine = 1;
      }
      this.type = types2.eof;
      this.value = null;
      this.start = this.end = this.pos;
      this.startLoc = this.endLoc = this.curPosition();
      this.lastTokEndLoc = this.lastTokStartLoc = null;
      this.lastTokStart = this.lastTokEnd = this.pos;
      this.context = this.initialContext();
      this.exprAllowed = true;
      this.inModule = options.sourceType === "module";
      this.strict = this.inModule || this.strictDirective(this.pos);
      this.potentialArrowAt = -1;
      this.potentialArrowInForAwait = false;
      this.yieldPos = this.awaitPos = this.awaitIdentPos = 0;
      this.labels = [];
      this.undefinedExports = /* @__PURE__ */ Object.create(null);
      if (this.pos === 0 && options.allowHashBang && this.input.slice(0, 2) === "#!") {
        this.skipLineComment(2);
      }
      this.scopeStack = [];
      this.enterScope(SCOPE_TOP);
      this.regexpState = null;
      this.privateNameStack = [];
    };
    prototypeAccessors = { inFunction: { configurable: true }, inGenerator: { configurable: true }, inAsync: { configurable: true }, allowSuper: { configurable: true }, allowDirectSuper: { configurable: true }, treatFunctionsAsVar: { configurable: true }, inNonArrowFunction: { configurable: true } };
    Parser.prototype.parse = function parse() {
      var node = this.options.program || this.startNode();
      this.nextToken();
      return this.parseTopLevel(node);
    };
    prototypeAccessors.inFunction.get = function() {
      return (this.currentVarScope().flags & SCOPE_FUNCTION) > 0;
    };
    prototypeAccessors.inGenerator.get = function() {
      return (this.currentVarScope().flags & SCOPE_GENERATOR) > 0 && !this.currentVarScope().inClassFieldInit;
    };
    prototypeAccessors.inAsync.get = function() {
      return (this.currentVarScope().flags & SCOPE_ASYNC) > 0 && !this.currentVarScope().inClassFieldInit;
    };
    prototypeAccessors.allowSuper.get = function() {
      var ref2 = this.currentThisScope();
      var flags = ref2.flags;
      var inClassFieldInit = ref2.inClassFieldInit;
      return (flags & SCOPE_SUPER) > 0 || inClassFieldInit || this.options.allowSuperOutsideMethod;
    };
    prototypeAccessors.allowDirectSuper.get = function() {
      return (this.currentThisScope().flags & SCOPE_DIRECT_SUPER) > 0;
    };
    prototypeAccessors.treatFunctionsAsVar.get = function() {
      return this.treatFunctionsAsVarInScope(this.currentScope());
    };
    prototypeAccessors.inNonArrowFunction.get = function() {
      var ref2 = this.currentThisScope();
      var flags = ref2.flags;
      var inClassFieldInit = ref2.inClassFieldInit;
      return (flags & SCOPE_FUNCTION) > 0 || inClassFieldInit;
    };
    Parser.extend = function extend() {
      var plugins = [], len = arguments.length;
      while (len--) plugins[len] = arguments[len];
      var cls = this;
      for (var i = 0; i < plugins.length; i++) {
        cls = plugins[i](cls);
      }
      return cls;
    };
    Parser.parse = function parse2(input, options) {
      return new this(options, input).parse();
    };
    Parser.parseExpressionAt = function parseExpressionAt(input, pos, options) {
      var parser = new this(options, input, pos);
      parser.nextToken();
      return parser.parseExpression();
    };
    Parser.tokenizer = function tokenizer(input, options) {
      return new this(options, input);
    };
    Object.defineProperties(Parser.prototype, prototypeAccessors);
    pp = Parser.prototype;
    literal = /^(?:'((?:\\.|[^'\\])*?)'|"((?:\\.|[^"\\])*?)")/;
    pp.strictDirective = function(start) {
      for (; ; ) {
        skipWhiteSpace.lastIndex = start;
        start += skipWhiteSpace.exec(this.input)[0].length;
        var match2 = literal.exec(this.input.slice(start));
        if (!match2) {
          return false;
        }
        if ((match2[1] || match2[2]) === "use strict") {
          skipWhiteSpace.lastIndex = start + match2[0].length;
          var spaceAfter = skipWhiteSpace.exec(this.input), end = spaceAfter.index + spaceAfter[0].length;
          var next = this.input.charAt(end);
          return next === ";" || next === "}" || lineBreak.test(spaceAfter[0]) && !(/[(`.[+\-/*%<>=,?^&]/.test(next) || next === "!" && this.input.charAt(end + 1) === "=");
        }
        start += match2[0].length;
        skipWhiteSpace.lastIndex = start;
        start += skipWhiteSpace.exec(this.input)[0].length;
        if (this.input[start] === ";") {
          start++;
        }
      }
    };
    pp.eat = function(type) {
      if (this.type === type) {
        this.next();
        return true;
      } else {
        return false;
      }
    };
    pp.isContextual = function(name) {
      return this.type === types2.name && this.value === name && !this.containsEsc;
    };
    pp.eatContextual = function(name) {
      if (!this.isContextual(name)) {
        return false;
      }
      this.next();
      return true;
    };
    pp.expectContextual = function(name) {
      if (!this.eatContextual(name)) {
        this.unexpected();
      }
    };
    pp.canInsertSemicolon = function() {
      return this.type === types2.eof || this.type === types2.braceR || lineBreak.test(this.input.slice(this.lastTokEnd, this.start));
    };
    pp.insertSemicolon = function() {
      if (this.canInsertSemicolon()) {
        if (this.options.onInsertedSemicolon) {
          this.options.onInsertedSemicolon(this.lastTokEnd, this.lastTokEndLoc);
        }
        return true;
      }
    };
    pp.semicolon = function() {
      if (!this.eat(types2.semi) && !this.insertSemicolon()) {
        this.unexpected();
      }
    };
    pp.afterTrailingComma = function(tokType, notNext) {
      if (this.type === tokType) {
        if (this.options.onTrailingComma) {
          this.options.onTrailingComma(this.lastTokStart, this.lastTokStartLoc);
        }
        if (!notNext) {
          this.next();
        }
        return true;
      }
    };
    pp.expect = function(type) {
      this.eat(type) || this.unexpected();
    };
    pp.unexpected = function(pos) {
      this.raise(pos != null ? pos : this.start, "Unexpected token");
    };
    pp.checkPatternErrors = function(refDestructuringErrors, isAssign) {
      if (!refDestructuringErrors) {
        return;
      }
      if (refDestructuringErrors.trailingComma > -1) {
        this.raiseRecoverable(refDestructuringErrors.trailingComma, "Comma is not permitted after the rest element");
      }
      var parens = isAssign ? refDestructuringErrors.parenthesizedAssign : refDestructuringErrors.parenthesizedBind;
      if (parens > -1) {
        this.raiseRecoverable(parens, "Parenthesized pattern");
      }
    };
    pp.checkExpressionErrors = function(refDestructuringErrors, andThrow) {
      if (!refDestructuringErrors) {
        return false;
      }
      var shorthandAssign = refDestructuringErrors.shorthandAssign;
      var doubleProto = refDestructuringErrors.doubleProto;
      if (!andThrow) {
        return shorthandAssign >= 0 || doubleProto >= 0;
      }
      if (shorthandAssign >= 0) {
        this.raise(shorthandAssign, "Shorthand property assignments are valid only in destructuring patterns");
      }
      if (doubleProto >= 0) {
        this.raiseRecoverable(doubleProto, "Redefinition of __proto__ property");
      }
    };
    pp.checkYieldAwaitInDefaultParams = function() {
      if (this.yieldPos && (!this.awaitPos || this.yieldPos < this.awaitPos)) {
        this.raise(this.yieldPos, "Yield expression cannot be a default value");
      }
      if (this.awaitPos) {
        this.raise(this.awaitPos, "Await expression cannot be a default value");
      }
    };
    pp.isSimpleAssignTarget = function(expr) {
      if (expr.type === "ParenthesizedExpression") {
        return this.isSimpleAssignTarget(expr.expression);
      }
      return expr.type === "Identifier" || expr.type === "MemberExpression";
    };
    pp$1 = Parser.prototype;
    pp$1.parseTopLevel = function(node) {
      var exports2 = /* @__PURE__ */ Object.create(null);
      if (!node.body) {
        node.body = [];
      }
      while (this.type !== types2.eof) {
        var stmt = this.parseStatement(null, true, exports2);
        node.body.push(stmt);
      }
      if (this.inModule) {
        for (var i = 0, list = Object.keys(this.undefinedExports); i < list.length; i += 1) {
          var name = list[i];
          this.raiseRecoverable(this.undefinedExports[name].start, "Export '" + name + "' is not defined");
        }
      }
      this.adaptDirectivePrologue(node.body);
      this.next();
      node.sourceType = this.options.sourceType;
      return this.finishNode(node, "Program");
    };
    loopLabel = { kind: "loop" };
    switchLabel = { kind: "switch" };
    pp$1.isLet = function(context) {
      if (this.options.ecmaVersion < 6 || !this.isContextual("let")) {
        return false;
      }
      skipWhiteSpace.lastIndex = this.pos;
      var skip = skipWhiteSpace.exec(this.input);
      var next = this.pos + skip[0].length, nextCh = this.input.charCodeAt(next);
      if (nextCh === 91 || nextCh === 92 || nextCh > 55295 && nextCh < 56320) {
        return true;
      }
      if (context) {
        return false;
      }
      if (nextCh === 123) {
        return true;
      }
      if (isIdentifierStart(nextCh, true)) {
        var pos = next + 1;
        while (isIdentifierChar(nextCh = this.input.charCodeAt(pos), true)) {
          ++pos;
        }
        if (nextCh === 92 || nextCh > 55295 && nextCh < 56320) {
          return true;
        }
        var ident = this.input.slice(next, pos);
        if (!keywordRelationalOperator.test(ident)) {
          return true;
        }
      }
      return false;
    };
    pp$1.isAsyncFunction = function() {
      if (this.options.ecmaVersion < 8 || !this.isContextual("async")) {
        return false;
      }
      skipWhiteSpace.lastIndex = this.pos;
      var skip = skipWhiteSpace.exec(this.input);
      var next = this.pos + skip[0].length, after;
      return !lineBreak.test(this.input.slice(this.pos, next)) && this.input.slice(next, next + 8) === "function" && (next + 8 === this.input.length || !(isIdentifierChar(after = this.input.charCodeAt(next + 8)) || after > 55295 && after < 56320));
    };
    pp$1.parseStatement = function(context, topLevel, exports2) {
      var starttype = this.type, node = this.startNode(), kind;
      if (this.isLet(context)) {
        starttype = types2._var;
        kind = "let";
      }
      switch (starttype) {
        case types2._break:
        case types2._continue:
          return this.parseBreakContinueStatement(node, starttype.keyword);
        case types2._debugger:
          return this.parseDebuggerStatement(node);
        case types2._do:
          return this.parseDoStatement(node);
        case types2._for:
          return this.parseForStatement(node);
        case types2._function:
          if (context && (this.strict || context !== "if" && context !== "label") && this.options.ecmaVersion >= 6) {
            this.unexpected();
          }
          return this.parseFunctionStatement(node, false, !context);
        case types2._class:
          if (context) {
            this.unexpected();
          }
          return this.parseClass(node, true);
        case types2._if:
          return this.parseIfStatement(node);
        case types2._return:
          return this.parseReturnStatement(node);
        case types2._switch:
          return this.parseSwitchStatement(node);
        case types2._throw:
          return this.parseThrowStatement(node);
        case types2._try:
          return this.parseTryStatement(node);
        case types2._const:
        case types2._var:
          kind = kind || this.value;
          if (context && kind !== "var") {
            this.unexpected();
          }
          return this.parseVarStatement(node, kind);
        case types2._while:
          return this.parseWhileStatement(node);
        case types2._with:
          return this.parseWithStatement(node);
        case types2.braceL:
          return this.parseBlock(true, node);
        case types2.semi:
          return this.parseEmptyStatement(node);
        case types2._export:
        case types2._import:
          if (this.options.ecmaVersion > 10 && starttype === types2._import) {
            skipWhiteSpace.lastIndex = this.pos;
            var skip = skipWhiteSpace.exec(this.input);
            var next = this.pos + skip[0].length, nextCh = this.input.charCodeAt(next);
            if (nextCh === 40 || nextCh === 46) {
              return this.parseExpressionStatement(node, this.parseExpression());
            }
          }
          if (!this.options.allowImportExportEverywhere) {
            if (!topLevel) {
              this.raise(this.start, "'import' and 'export' may only appear at the top level");
            }
            if (!this.inModule) {
              this.raise(this.start, "'import' and 'export' may appear only with 'sourceType: module'");
            }
          }
          return starttype === types2._import ? this.parseImport(node) : this.parseExport(node, exports2);
        default:
          if (this.isAsyncFunction()) {
            if (context) {
              this.unexpected();
            }
            this.next();
            return this.parseFunctionStatement(node, true, !context);
          }
          var maybeName = this.value, expr = this.parseExpression();
          if (starttype === types2.name && expr.type === "Identifier" && this.eat(types2.colon)) {
            return this.parseLabeledStatement(node, maybeName, expr, context);
          } else {
            return this.parseExpressionStatement(node, expr);
          }
      }
    };
    pp$1.parseBreakContinueStatement = function(node, keyword) {
      var isBreak = keyword === "break";
      this.next();
      if (this.eat(types2.semi) || this.insertSemicolon()) {
        node.label = null;
      } else if (this.type !== types2.name) {
        this.unexpected();
      } else {
        node.label = this.parseIdent();
        this.semicolon();
      }
      var i = 0;
      for (; i < this.labels.length; ++i) {
        var lab = this.labels[i];
        if (node.label == null || lab.name === node.label.name) {
          if (lab.kind != null && (isBreak || lab.kind === "loop")) {
            break;
          }
          if (node.label && isBreak) {
            break;
          }
        }
      }
      if (i === this.labels.length) {
        this.raise(node.start, "Unsyntactic " + keyword);
      }
      return this.finishNode(node, isBreak ? "BreakStatement" : "ContinueStatement");
    };
    pp$1.parseDebuggerStatement = function(node) {
      this.next();
      this.semicolon();
      return this.finishNode(node, "DebuggerStatement");
    };
    pp$1.parseDoStatement = function(node) {
      this.next();
      this.labels.push(loopLabel);
      node.body = this.parseStatement("do");
      this.labels.pop();
      this.expect(types2._while);
      node.test = this.parseParenExpression();
      if (this.options.ecmaVersion >= 6) {
        this.eat(types2.semi);
      } else {
        this.semicolon();
      }
      return this.finishNode(node, "DoWhileStatement");
    };
    pp$1.parseForStatement = function(node) {
      this.next();
      var awaitAt = this.options.ecmaVersion >= 9 && (this.inAsync || !this.inFunction && this.options.allowAwaitOutsideFunction) && this.eatContextual("await") ? this.lastTokStart : -1;
      this.labels.push(loopLabel);
      this.enterScope(0);
      this.expect(types2.parenL);
      if (this.type === types2.semi) {
        if (awaitAt > -1) {
          this.unexpected(awaitAt);
        }
        return this.parseFor(node, null);
      }
      var isLet = this.isLet();
      if (this.type === types2._var || this.type === types2._const || isLet) {
        var init$1 = this.startNode(), kind = isLet ? "let" : this.value;
        this.next();
        this.parseVar(init$1, true, kind);
        this.finishNode(init$1, "VariableDeclaration");
        if ((this.type === types2._in || this.options.ecmaVersion >= 6 && this.isContextual("of")) && init$1.declarations.length === 1) {
          if (this.options.ecmaVersion >= 9) {
            if (this.type === types2._in) {
              if (awaitAt > -1) {
                this.unexpected(awaitAt);
              }
            } else {
              node.await = awaitAt > -1;
            }
          }
          return this.parseForIn(node, init$1);
        }
        if (awaitAt > -1) {
          this.unexpected(awaitAt);
        }
        return this.parseFor(node, init$1);
      }
      var refDestructuringErrors = new DestructuringErrors();
      var init = this.parseExpression(awaitAt > -1 ? "await" : true, refDestructuringErrors);
      if (this.type === types2._in || this.options.ecmaVersion >= 6 && this.isContextual("of")) {
        if (this.options.ecmaVersion >= 9) {
          if (this.type === types2._in) {
            if (awaitAt > -1) {
              this.unexpected(awaitAt);
            }
          } else {
            node.await = awaitAt > -1;
          }
        }
        this.toAssignable(init, false, refDestructuringErrors);
        this.checkLValPattern(init);
        return this.parseForIn(node, init);
      } else {
        this.checkExpressionErrors(refDestructuringErrors, true);
      }
      if (awaitAt > -1) {
        this.unexpected(awaitAt);
      }
      return this.parseFor(node, init);
    };
    pp$1.parseFunctionStatement = function(node, isAsync, declarationPosition) {
      this.next();
      return this.parseFunction(node, FUNC_STATEMENT | (declarationPosition ? 0 : FUNC_HANGING_STATEMENT), false, isAsync);
    };
    pp$1.parseIfStatement = function(node) {
      this.next();
      node.test = this.parseParenExpression();
      node.consequent = this.parseStatement("if");
      node.alternate = this.eat(types2._else) ? this.parseStatement("if") : null;
      return this.finishNode(node, "IfStatement");
    };
    pp$1.parseReturnStatement = function(node) {
      if (!this.inFunction && !this.options.allowReturnOutsideFunction) {
        this.raise(this.start, "'return' outside of function");
      }
      this.next();
      if (this.eat(types2.semi) || this.insertSemicolon()) {
        node.argument = null;
      } else {
        node.argument = this.parseExpression();
        this.semicolon();
      }
      return this.finishNode(node, "ReturnStatement");
    };
    pp$1.parseSwitchStatement = function(node) {
      this.next();
      node.discriminant = this.parseParenExpression();
      node.cases = [];
      this.expect(types2.braceL);
      this.labels.push(switchLabel);
      this.enterScope(0);
      var cur;
      for (var sawDefault = false; this.type !== types2.braceR; ) {
        if (this.type === types2._case || this.type === types2._default) {
          var isCase = this.type === types2._case;
          if (cur) {
            this.finishNode(cur, "SwitchCase");
          }
          node.cases.push(cur = this.startNode());
          cur.consequent = [];
          this.next();
          if (isCase) {
            cur.test = this.parseExpression();
          } else {
            if (sawDefault) {
              this.raiseRecoverable(this.lastTokStart, "Multiple default clauses");
            }
            sawDefault = true;
            cur.test = null;
          }
          this.expect(types2.colon);
        } else {
          if (!cur) {
            this.unexpected();
          }
          cur.consequent.push(this.parseStatement(null));
        }
      }
      this.exitScope();
      if (cur) {
        this.finishNode(cur, "SwitchCase");
      }
      this.next();
      this.labels.pop();
      return this.finishNode(node, "SwitchStatement");
    };
    pp$1.parseThrowStatement = function(node) {
      this.next();
      if (lineBreak.test(this.input.slice(this.lastTokEnd, this.start))) {
        this.raise(this.lastTokEnd, "Illegal newline after throw");
      }
      node.argument = this.parseExpression();
      this.semicolon();
      return this.finishNode(node, "ThrowStatement");
    };
    empty = [];
    pp$1.parseTryStatement = function(node) {
      this.next();
      node.block = this.parseBlock();
      node.handler = null;
      if (this.type === types2._catch) {
        var clause = this.startNode();
        this.next();
        if (this.eat(types2.parenL)) {
          clause.param = this.parseBindingAtom();
          var simple = clause.param.type === "Identifier";
          this.enterScope(simple ? SCOPE_SIMPLE_CATCH : 0);
          this.checkLValPattern(clause.param, simple ? BIND_SIMPLE_CATCH : BIND_LEXICAL);
          this.expect(types2.parenR);
        } else {
          if (this.options.ecmaVersion < 10) {
            this.unexpected();
          }
          clause.param = null;
          this.enterScope(0);
        }
        clause.body = this.parseBlock(false);
        this.exitScope();
        node.handler = this.finishNode(clause, "CatchClause");
      }
      node.finalizer = this.eat(types2._finally) ? this.parseBlock() : null;
      if (!node.handler && !node.finalizer) {
        this.raise(node.start, "Missing catch or finally clause");
      }
      return this.finishNode(node, "TryStatement");
    };
    pp$1.parseVarStatement = function(node, kind) {
      this.next();
      this.parseVar(node, false, kind);
      this.semicolon();
      return this.finishNode(node, "VariableDeclaration");
    };
    pp$1.parseWhileStatement = function(node) {
      this.next();
      node.test = this.parseParenExpression();
      this.labels.push(loopLabel);
      node.body = this.parseStatement("while");
      this.labels.pop();
      return this.finishNode(node, "WhileStatement");
    };
    pp$1.parseWithStatement = function(node) {
      if (this.strict) {
        this.raise(this.start, "'with' in strict mode");
      }
      this.next();
      node.object = this.parseParenExpression();
      node.body = this.parseStatement("with");
      return this.finishNode(node, "WithStatement");
    };
    pp$1.parseEmptyStatement = function(node) {
      this.next();
      return this.finishNode(node, "EmptyStatement");
    };
    pp$1.parseLabeledStatement = function(node, maybeName, expr, context) {
      for (var i$1 = 0, list = this.labels; i$1 < list.length; i$1 += 1) {
        var label = list[i$1];
        if (label.name === maybeName) {
          this.raise(expr.start, "Label '" + maybeName + "' is already declared");
        }
      }
      var kind = this.type.isLoop ? "loop" : this.type === types2._switch ? "switch" : null;
      for (var i = this.labels.length - 1; i >= 0; i--) {
        var label$1 = this.labels[i];
        if (label$1.statementStart === node.start) {
          label$1.statementStart = this.start;
          label$1.kind = kind;
        } else {
          break;
        }
      }
      this.labels.push({ name: maybeName, kind, statementStart: this.start });
      node.body = this.parseStatement(context ? context.indexOf("label") === -1 ? context + "label" : context : "label");
      this.labels.pop();
      node.label = expr;
      return this.finishNode(node, "LabeledStatement");
    };
    pp$1.parseExpressionStatement = function(node, expr) {
      node.expression = expr;
      this.semicolon();
      return this.finishNode(node, "ExpressionStatement");
    };
    pp$1.parseBlock = function(createNewLexicalScope, node, exitStrict) {
      if (createNewLexicalScope === void 0) createNewLexicalScope = true;
      if (node === void 0) node = this.startNode();
      node.body = [];
      this.expect(types2.braceL);
      if (createNewLexicalScope) {
        this.enterScope(0);
      }
      while (this.type !== types2.braceR) {
        var stmt = this.parseStatement(null);
        node.body.push(stmt);
      }
      if (exitStrict) {
        this.strict = false;
      }
      this.next();
      if (createNewLexicalScope) {
        this.exitScope();
      }
      return this.finishNode(node, "BlockStatement");
    };
    pp$1.parseFor = function(node, init) {
      node.init = init;
      this.expect(types2.semi);
      node.test = this.type === types2.semi ? null : this.parseExpression();
      this.expect(types2.semi);
      node.update = this.type === types2.parenR ? null : this.parseExpression();
      this.expect(types2.parenR);
      node.body = this.parseStatement("for");
      this.exitScope();
      this.labels.pop();
      return this.finishNode(node, "ForStatement");
    };
    pp$1.parseForIn = function(node, init) {
      var isForIn = this.type === types2._in;
      this.next();
      if (init.type === "VariableDeclaration" && init.declarations[0].init != null && (!isForIn || this.options.ecmaVersion < 8 || this.strict || init.kind !== "var" || init.declarations[0].id.type !== "Identifier")) {
        this.raise(
          init.start,
          (isForIn ? "for-in" : "for-of") + " loop variable declaration may not have an initializer"
        );
      }
      node.left = init;
      node.right = isForIn ? this.parseExpression() : this.parseMaybeAssign();
      this.expect(types2.parenR);
      node.body = this.parseStatement("for");
      this.exitScope();
      this.labels.pop();
      return this.finishNode(node, isForIn ? "ForInStatement" : "ForOfStatement");
    };
    pp$1.parseVar = function(node, isFor, kind) {
      node.declarations = [];
      node.kind = kind;
      for (; ; ) {
        var decl = this.startNode();
        this.parseVarId(decl, kind);
        if (this.eat(types2.eq)) {
          decl.init = this.parseMaybeAssign(isFor);
        } else if (kind === "const" && !(this.type === types2._in || this.options.ecmaVersion >= 6 && this.isContextual("of"))) {
          this.unexpected();
        } else if (decl.id.type !== "Identifier" && !(isFor && (this.type === types2._in || this.isContextual("of")))) {
          this.raise(this.lastTokEnd, "Complex binding patterns require an initialization value");
        } else {
          decl.init = null;
        }
        node.declarations.push(this.finishNode(decl, "VariableDeclarator"));
        if (!this.eat(types2.comma)) {
          break;
        }
      }
      return node;
    };
    pp$1.parseVarId = function(decl, kind) {
      decl.id = this.parseBindingAtom();
      this.checkLValPattern(decl.id, kind === "var" ? BIND_VAR : BIND_LEXICAL, false);
    };
    FUNC_STATEMENT = 1;
    FUNC_HANGING_STATEMENT = 2;
    FUNC_NULLABLE_ID = 4;
    pp$1.parseFunction = function(node, statement, allowExpressionBody, isAsync) {
      this.initFunction(node);
      if (this.options.ecmaVersion >= 9 || this.options.ecmaVersion >= 6 && !isAsync) {
        if (this.type === types2.star && statement & FUNC_HANGING_STATEMENT) {
          this.unexpected();
        }
        node.generator = this.eat(types2.star);
      }
      if (this.options.ecmaVersion >= 8) {
        node.async = !!isAsync;
      }
      if (statement & FUNC_STATEMENT) {
        node.id = statement & FUNC_NULLABLE_ID && this.type !== types2.name ? null : this.parseIdent();
        if (node.id && !(statement & FUNC_HANGING_STATEMENT)) {
          this.checkLValSimple(node.id, this.strict || node.generator || node.async ? this.treatFunctionsAsVar ? BIND_VAR : BIND_LEXICAL : BIND_FUNCTION);
        }
      }
      var oldYieldPos = this.yieldPos, oldAwaitPos = this.awaitPos, oldAwaitIdentPos = this.awaitIdentPos;
      this.yieldPos = 0;
      this.awaitPos = 0;
      this.awaitIdentPos = 0;
      this.enterScope(functionFlags(node.async, node.generator));
      if (!(statement & FUNC_STATEMENT)) {
        node.id = this.type === types2.name ? this.parseIdent() : null;
      }
      this.parseFunctionParams(node);
      this.parseFunctionBody(node, allowExpressionBody, false);
      this.yieldPos = oldYieldPos;
      this.awaitPos = oldAwaitPos;
      this.awaitIdentPos = oldAwaitIdentPos;
      return this.finishNode(node, statement & FUNC_STATEMENT ? "FunctionDeclaration" : "FunctionExpression");
    };
    pp$1.parseFunctionParams = function(node) {
      this.expect(types2.parenL);
      node.params = this.parseBindingList(types2.parenR, false, this.options.ecmaVersion >= 8);
      this.checkYieldAwaitInDefaultParams();
    };
    pp$1.parseClass = function(node, isStatement) {
      this.next();
      var oldStrict = this.strict;
      this.strict = true;
      this.parseClassId(node, isStatement);
      this.parseClassSuper(node);
      var privateNameMap = this.enterClassBody();
      var classBody = this.startNode();
      var hadConstructor = false;
      classBody.body = [];
      this.expect(types2.braceL);
      while (this.type !== types2.braceR) {
        var element = this.parseClassElement(node.superClass !== null);
        if (element) {
          classBody.body.push(element);
          if (element.type === "MethodDefinition" && element.kind === "constructor") {
            if (hadConstructor) {
              this.raise(element.start, "Duplicate constructor in the same class");
            }
            hadConstructor = true;
          } else if (element.key.type === "PrivateIdentifier" && isPrivateNameConflicted(privateNameMap, element)) {
            this.raiseRecoverable(element.key.start, "Identifier '#" + element.key.name + "' has already been declared");
          }
        }
      }
      this.strict = oldStrict;
      this.next();
      node.body = this.finishNode(classBody, "ClassBody");
      this.exitClassBody();
      return this.finishNode(node, isStatement ? "ClassDeclaration" : "ClassExpression");
    };
    pp$1.parseClassElement = function(constructorAllowsSuper) {
      if (this.eat(types2.semi)) {
        return null;
      }
      var ecmaVersion = this.options.ecmaVersion;
      var node = this.startNode();
      var keyName = "";
      var isGenerator = false;
      var isAsync = false;
      var kind = "method";
      node.static = false;
      if (this.eatContextual("static")) {
        if (this.isClassElementNameStart() || this.type === types2.star) {
          node.static = true;
        } else {
          keyName = "static";
        }
      }
      if (!keyName && ecmaVersion >= 8 && this.eatContextual("async")) {
        if ((this.isClassElementNameStart() || this.type === types2.star) && !this.canInsertSemicolon()) {
          isAsync = true;
        } else {
          keyName = "async";
        }
      }
      if (!keyName && (ecmaVersion >= 9 || !isAsync) && this.eat(types2.star)) {
        isGenerator = true;
      }
      if (!keyName && !isAsync && !isGenerator) {
        var lastValue = this.value;
        if (this.eatContextual("get") || this.eatContextual("set")) {
          if (this.isClassElementNameStart()) {
            kind = lastValue;
          } else {
            keyName = lastValue;
          }
        }
      }
      if (keyName) {
        node.computed = false;
        node.key = this.startNodeAt(this.lastTokStart, this.lastTokStartLoc);
        node.key.name = keyName;
        this.finishNode(node.key, "Identifier");
      } else {
        this.parseClassElementName(node);
      }
      if (ecmaVersion < 13 || this.type === types2.parenL || kind !== "method" || isGenerator || isAsync) {
        var isConstructor = !node.static && checkKeyName(node, "constructor");
        var allowsDirectSuper = isConstructor && constructorAllowsSuper;
        if (isConstructor && kind !== "method") {
          this.raise(node.key.start, "Constructor can't have get/set modifier");
        }
        node.kind = isConstructor ? "constructor" : kind;
        this.parseClassMethod(node, isGenerator, isAsync, allowsDirectSuper);
      } else {
        this.parseClassField(node);
      }
      return node;
    };
    pp$1.isClassElementNameStart = function() {
      return this.type === types2.name || this.type === types2.privateId || this.type === types2.num || this.type === types2.string || this.type === types2.bracketL || this.type.keyword;
    };
    pp$1.parseClassElementName = function(element) {
      if (this.type === types2.privateId) {
        if (this.value === "constructor") {
          this.raise(this.start, "Classes can't have an element named '#constructor'");
        }
        element.computed = false;
        element.key = this.parsePrivateIdent();
      } else {
        this.parsePropertyName(element);
      }
    };
    pp$1.parseClassMethod = function(method, isGenerator, isAsync, allowsDirectSuper) {
      var key = method.key;
      if (method.kind === "constructor") {
        if (isGenerator) {
          this.raise(key.start, "Constructor can't be a generator");
        }
        if (isAsync) {
          this.raise(key.start, "Constructor can't be an async method");
        }
      } else if (method.static && checkKeyName(method, "prototype")) {
        this.raise(key.start, "Classes may not have a static property named prototype");
      }
      var value = method.value = this.parseMethod(isGenerator, isAsync, allowsDirectSuper);
      if (method.kind === "get" && value.params.length !== 0) {
        this.raiseRecoverable(value.start, "getter should have no params");
      }
      if (method.kind === "set" && value.params.length !== 1) {
        this.raiseRecoverable(value.start, "setter should have exactly one param");
      }
      if (method.kind === "set" && value.params[0].type === "RestElement") {
        this.raiseRecoverable(value.params[0].start, "Setter cannot use rest params");
      }
      return this.finishNode(method, "MethodDefinition");
    };
    pp$1.parseClassField = function(field) {
      if (checkKeyName(field, "constructor")) {
        this.raise(field.key.start, "Classes can't have a field named 'constructor'");
      } else if (field.static && checkKeyName(field, "prototype")) {
        this.raise(field.key.start, "Classes can't have a static field named 'prototype'");
      }
      if (this.eat(types2.eq)) {
        var scope = this.currentThisScope();
        var inClassFieldInit = scope.inClassFieldInit;
        scope.inClassFieldInit = true;
        field.value = this.parseMaybeAssign();
        scope.inClassFieldInit = inClassFieldInit;
      } else {
        field.value = null;
      }
      this.semicolon();
      return this.finishNode(field, "PropertyDefinition");
    };
    pp$1.parseClassId = function(node, isStatement) {
      if (this.type === types2.name) {
        node.id = this.parseIdent();
        if (isStatement) {
          this.checkLValSimple(node.id, BIND_LEXICAL, false);
        }
      } else {
        if (isStatement === true) {
          this.unexpected();
        }
        node.id = null;
      }
    };
    pp$1.parseClassSuper = function(node) {
      node.superClass = this.eat(types2._extends) ? this.parseExprSubscripts() : null;
    };
    pp$1.enterClassBody = function() {
      var element = { declared: /* @__PURE__ */ Object.create(null), used: [] };
      this.privateNameStack.push(element);
      return element.declared;
    };
    pp$1.exitClassBody = function() {
      var ref2 = this.privateNameStack.pop();
      var declared = ref2.declared;
      var used = ref2.used;
      var len = this.privateNameStack.length;
      var parent = len === 0 ? null : this.privateNameStack[len - 1];
      for (var i = 0; i < used.length; ++i) {
        var id = used[i];
        if (!has2(declared, id.name)) {
          if (parent) {
            parent.used.push(id);
          } else {
            this.raiseRecoverable(id.start, "Private field '#" + id.name + "' must be declared in an enclosing class");
          }
        }
      }
    };
    pp$1.parseExport = function(node, exports2) {
      this.next();
      if (this.eat(types2.star)) {
        if (this.options.ecmaVersion >= 11) {
          if (this.eatContextual("as")) {
            node.exported = this.parseIdent(true);
            this.checkExport(exports2, node.exported.name, this.lastTokStart);
          } else {
            node.exported = null;
          }
        }
        this.expectContextual("from");
        if (this.type !== types2.string) {
          this.unexpected();
        }
        node.source = this.parseExprAtom();
        this.semicolon();
        return this.finishNode(node, "ExportAllDeclaration");
      }
      if (this.eat(types2._default)) {
        this.checkExport(exports2, "default", this.lastTokStart);
        var isAsync;
        if (this.type === types2._function || (isAsync = this.isAsyncFunction())) {
          var fNode = this.startNode();
          this.next();
          if (isAsync) {
            this.next();
          }
          node.declaration = this.parseFunction(fNode, FUNC_STATEMENT | FUNC_NULLABLE_ID, false, isAsync);
        } else if (this.type === types2._class) {
          var cNode = this.startNode();
          node.declaration = this.parseClass(cNode, "nullableID");
        } else {
          node.declaration = this.parseMaybeAssign();
          this.semicolon();
        }
        return this.finishNode(node, "ExportDefaultDeclaration");
      }
      if (this.shouldParseExportStatement()) {
        node.declaration = this.parseStatement(null);
        if (node.declaration.type === "VariableDeclaration") {
          this.checkVariableExport(exports2, node.declaration.declarations);
        } else {
          this.checkExport(exports2, node.declaration.id.name, node.declaration.id.start);
        }
        node.specifiers = [];
        node.source = null;
      } else {
        node.declaration = null;
        node.specifiers = this.parseExportSpecifiers(exports2);
        if (this.eatContextual("from")) {
          if (this.type !== types2.string) {
            this.unexpected();
          }
          node.source = this.parseExprAtom();
        } else {
          for (var i = 0, list = node.specifiers; i < list.length; i += 1) {
            var spec = list[i];
            this.checkUnreserved(spec.local);
            this.checkLocalExport(spec.local);
          }
          node.source = null;
        }
        this.semicolon();
      }
      return this.finishNode(node, "ExportNamedDeclaration");
    };
    pp$1.checkExport = function(exports2, name, pos) {
      if (!exports2) {
        return;
      }
      if (has2(exports2, name)) {
        this.raiseRecoverable(pos, "Duplicate export '" + name + "'");
      }
      exports2[name] = true;
    };
    pp$1.checkPatternExport = function(exports2, pat) {
      var type = pat.type;
      if (type === "Identifier") {
        this.checkExport(exports2, pat.name, pat.start);
      } else if (type === "ObjectPattern") {
        for (var i = 0, list = pat.properties; i < list.length; i += 1) {
          var prop = list[i];
          this.checkPatternExport(exports2, prop);
        }
      } else if (type === "ArrayPattern") {
        for (var i$1 = 0, list$1 = pat.elements; i$1 < list$1.length; i$1 += 1) {
          var elt = list$1[i$1];
          if (elt) {
            this.checkPatternExport(exports2, elt);
          }
        }
      } else if (type === "Property") {
        this.checkPatternExport(exports2, pat.value);
      } else if (type === "AssignmentPattern") {
        this.checkPatternExport(exports2, pat.left);
      } else if (type === "RestElement") {
        this.checkPatternExport(exports2, pat.argument);
      } else if (type === "ParenthesizedExpression") {
        this.checkPatternExport(exports2, pat.expression);
      }
    };
    pp$1.checkVariableExport = function(exports2, decls) {
      if (!exports2) {
        return;
      }
      for (var i = 0, list = decls; i < list.length; i += 1) {
        var decl = list[i];
        this.checkPatternExport(exports2, decl.id);
      }
    };
    pp$1.shouldParseExportStatement = function() {
      return this.type.keyword === "var" || this.type.keyword === "const" || this.type.keyword === "class" || this.type.keyword === "function" || this.isLet() || this.isAsyncFunction();
    };
    pp$1.parseExportSpecifiers = function(exports2) {
      var nodes = [], first = true;
      this.expect(types2.braceL);
      while (!this.eat(types2.braceR)) {
        if (!first) {
          this.expect(types2.comma);
          if (this.afterTrailingComma(types2.braceR)) {
            break;
          }
        } else {
          first = false;
        }
        var node = this.startNode();
        node.local = this.parseIdent(true);
        node.exported = this.eatContextual("as") ? this.parseIdent(true) : node.local;
        this.checkExport(exports2, node.exported.name, node.exported.start);
        nodes.push(this.finishNode(node, "ExportSpecifier"));
      }
      return nodes;
    };
    pp$1.parseImport = function(node) {
      this.next();
      if (this.type === types2.string) {
        node.specifiers = empty;
        node.source = this.parseExprAtom();
      } else {
        node.specifiers = this.parseImportSpecifiers();
        this.expectContextual("from");
        node.source = this.type === types2.string ? this.parseExprAtom() : this.unexpected();
      }
      this.semicolon();
      return this.finishNode(node, "ImportDeclaration");
    };
    pp$1.parseImportSpecifiers = function() {
      var nodes = [], first = true;
      if (this.type === types2.name) {
        var node = this.startNode();
        node.local = this.parseIdent();
        this.checkLValSimple(node.local, BIND_LEXICAL);
        nodes.push(this.finishNode(node, "ImportDefaultSpecifier"));
        if (!this.eat(types2.comma)) {
          return nodes;
        }
      }
      if (this.type === types2.star) {
        var node$1 = this.startNode();
        this.next();
        this.expectContextual("as");
        node$1.local = this.parseIdent();
        this.checkLValSimple(node$1.local, BIND_LEXICAL);
        nodes.push(this.finishNode(node$1, "ImportNamespaceSpecifier"));
        return nodes;
      }
      this.expect(types2.braceL);
      while (!this.eat(types2.braceR)) {
        if (!first) {
          this.expect(types2.comma);
          if (this.afterTrailingComma(types2.braceR)) {
            break;
          }
        } else {
          first = false;
        }
        var node$2 = this.startNode();
        node$2.imported = this.parseIdent(true);
        if (this.eatContextual("as")) {
          node$2.local = this.parseIdent();
        } else {
          this.checkUnreserved(node$2.imported);
          node$2.local = node$2.imported;
        }
        this.checkLValSimple(node$2.local, BIND_LEXICAL);
        nodes.push(this.finishNode(node$2, "ImportSpecifier"));
      }
      return nodes;
    };
    pp$1.adaptDirectivePrologue = function(statements) {
      for (var i = 0; i < statements.length && this.isDirectiveCandidate(statements[i]); ++i) {
        statements[i].directive = statements[i].expression.raw.slice(1, -1);
      }
    };
    pp$1.isDirectiveCandidate = function(statement) {
      return statement.type === "ExpressionStatement" && statement.expression.type === "Literal" && typeof statement.expression.value === "string" && // Reject parenthesized strings.
      (this.input[statement.start] === '"' || this.input[statement.start] === "'");
    };
    pp$2 = Parser.prototype;
    pp$2.toAssignable = function(node, isBinding, refDestructuringErrors) {
      if (this.options.ecmaVersion >= 6 && node) {
        switch (node.type) {
          case "Identifier":
            if (this.inAsync && node.name === "await") {
              this.raise(node.start, "Cannot use 'await' as identifier inside an async function");
            }
            break;
          case "ObjectPattern":
          case "ArrayPattern":
          case "AssignmentPattern":
          case "RestElement":
            break;
          case "ObjectExpression":
            node.type = "ObjectPattern";
            if (refDestructuringErrors) {
              this.checkPatternErrors(refDestructuringErrors, true);
            }
            for (var i = 0, list = node.properties; i < list.length; i += 1) {
              var prop = list[i];
              this.toAssignable(prop, isBinding);
              if (prop.type === "RestElement" && (prop.argument.type === "ArrayPattern" || prop.argument.type === "ObjectPattern")) {
                this.raise(prop.argument.start, "Unexpected token");
              }
            }
            break;
          case "Property":
            if (node.kind !== "init") {
              this.raise(node.key.start, "Object pattern can't contain getter or setter");
            }
            this.toAssignable(node.value, isBinding);
            break;
          case "ArrayExpression":
            node.type = "ArrayPattern";
            if (refDestructuringErrors) {
              this.checkPatternErrors(refDestructuringErrors, true);
            }
            this.toAssignableList(node.elements, isBinding);
            break;
          case "SpreadElement":
            node.type = "RestElement";
            this.toAssignable(node.argument, isBinding);
            if (node.argument.type === "AssignmentPattern") {
              this.raise(node.argument.start, "Rest elements cannot have a default value");
            }
            break;
          case "AssignmentExpression":
            if (node.operator !== "=") {
              this.raise(node.left.end, "Only '=' operator can be used for specifying default value.");
            }
            node.type = "AssignmentPattern";
            delete node.operator;
            this.toAssignable(node.left, isBinding);
            break;
          case "ParenthesizedExpression":
            this.toAssignable(node.expression, isBinding, refDestructuringErrors);
            break;
          case "ChainExpression":
            this.raiseRecoverable(node.start, "Optional chaining cannot appear in left-hand side");
            break;
          case "MemberExpression":
            if (!isBinding) {
              break;
            }
          default:
            this.raise(node.start, "Assigning to rvalue");
        }
      } else if (refDestructuringErrors) {
        this.checkPatternErrors(refDestructuringErrors, true);
      }
      return node;
    };
    pp$2.toAssignableList = function(exprList, isBinding) {
      var end = exprList.length;
      for (var i = 0; i < end; i++) {
        var elt = exprList[i];
        if (elt) {
          this.toAssignable(elt, isBinding);
        }
      }
      if (end) {
        var last = exprList[end - 1];
        if (this.options.ecmaVersion === 6 && isBinding && last && last.type === "RestElement" && last.argument.type !== "Identifier") {
          this.unexpected(last.argument.start);
        }
      }
      return exprList;
    };
    pp$2.parseSpread = function(refDestructuringErrors) {
      var node = this.startNode();
      this.next();
      node.argument = this.parseMaybeAssign(false, refDestructuringErrors);
      return this.finishNode(node, "SpreadElement");
    };
    pp$2.parseRestBinding = function() {
      var node = this.startNode();
      this.next();
      if (this.options.ecmaVersion === 6 && this.type !== types2.name) {
        this.unexpected();
      }
      node.argument = this.parseBindingAtom();
      return this.finishNode(node, "RestElement");
    };
    pp$2.parseBindingAtom = function() {
      if (this.options.ecmaVersion >= 6) {
        switch (this.type) {
          case types2.bracketL:
            var node = this.startNode();
            this.next();
            node.elements = this.parseBindingList(types2.bracketR, true, true);
            return this.finishNode(node, "ArrayPattern");
          case types2.braceL:
            return this.parseObj(true);
        }
      }
      return this.parseIdent();
    };
    pp$2.parseBindingList = function(close, allowEmpty, allowTrailingComma) {
      var elts = [], first = true;
      while (!this.eat(close)) {
        if (first) {
          first = false;
        } else {
          this.expect(types2.comma);
        }
        if (allowEmpty && this.type === types2.comma) {
          elts.push(null);
        } else if (allowTrailingComma && this.afterTrailingComma(close)) {
          break;
        } else if (this.type === types2.ellipsis) {
          var rest = this.parseRestBinding();
          this.parseBindingListItem(rest);
          elts.push(rest);
          if (this.type === types2.comma) {
            this.raise(this.start, "Comma is not permitted after the rest element");
          }
          this.expect(close);
          break;
        } else {
          var elem = this.parseMaybeDefault(this.start, this.startLoc);
          this.parseBindingListItem(elem);
          elts.push(elem);
        }
      }
      return elts;
    };
    pp$2.parseBindingListItem = function(param) {
      return param;
    };
    pp$2.parseMaybeDefault = function(startPos, startLoc, left) {
      left = left || this.parseBindingAtom();
      if (this.options.ecmaVersion < 6 || !this.eat(types2.eq)) {
        return left;
      }
      var node = this.startNodeAt(startPos, startLoc);
      node.left = left;
      node.right = this.parseMaybeAssign();
      return this.finishNode(node, "AssignmentPattern");
    };
    pp$2.checkLValSimple = function(expr, bindingType, checkClashes) {
      if (bindingType === void 0) bindingType = BIND_NONE;
      var isBind = bindingType !== BIND_NONE;
      switch (expr.type) {
        case "Identifier":
          if (this.strict && this.reservedWordsStrictBind.test(expr.name)) {
            this.raiseRecoverable(expr.start, (isBind ? "Binding " : "Assigning to ") + expr.name + " in strict mode");
          }
          if (isBind) {
            if (bindingType === BIND_LEXICAL && expr.name === "let") {
              this.raiseRecoverable(expr.start, "let is disallowed as a lexically bound name");
            }
            if (checkClashes) {
              if (has2(checkClashes, expr.name)) {
                this.raiseRecoverable(expr.start, "Argument name clash");
              }
              checkClashes[expr.name] = true;
            }
            if (bindingType !== BIND_OUTSIDE) {
              this.declareName(expr.name, bindingType, expr.start);
            }
          }
          break;
        case "ChainExpression":
          this.raiseRecoverable(expr.start, "Optional chaining cannot appear in left-hand side");
          break;
        case "MemberExpression":
          if (isBind) {
            this.raiseRecoverable(expr.start, "Binding member expression");
          }
          break;
        case "ParenthesizedExpression":
          if (isBind) {
            this.raiseRecoverable(expr.start, "Binding parenthesized expression");
          }
          return this.checkLValSimple(expr.expression, bindingType, checkClashes);
        default:
          this.raise(expr.start, (isBind ? "Binding" : "Assigning to") + " rvalue");
      }
    };
    pp$2.checkLValPattern = function(expr, bindingType, checkClashes) {
      if (bindingType === void 0) bindingType = BIND_NONE;
      switch (expr.type) {
        case "ObjectPattern":
          for (var i = 0, list = expr.properties; i < list.length; i += 1) {
            var prop = list[i];
            this.checkLValInnerPattern(prop, bindingType, checkClashes);
          }
          break;
        case "ArrayPattern":
          for (var i$1 = 0, list$1 = expr.elements; i$1 < list$1.length; i$1 += 1) {
            var elem = list$1[i$1];
            if (elem) {
              this.checkLValInnerPattern(elem, bindingType, checkClashes);
            }
          }
          break;
        default:
          this.checkLValSimple(expr, bindingType, checkClashes);
      }
    };
    pp$2.checkLValInnerPattern = function(expr, bindingType, checkClashes) {
      if (bindingType === void 0) bindingType = BIND_NONE;
      switch (expr.type) {
        case "Property":
          this.checkLValInnerPattern(expr.value, bindingType, checkClashes);
          break;
        case "AssignmentPattern":
          this.checkLValPattern(expr.left, bindingType, checkClashes);
          break;
        case "RestElement":
          this.checkLValPattern(expr.argument, bindingType, checkClashes);
          break;
        default:
          this.checkLValPattern(expr, bindingType, checkClashes);
      }
    };
    pp$3 = Parser.prototype;
    pp$3.checkPropClash = function(prop, propHash, refDestructuringErrors) {
      if (this.options.ecmaVersion >= 9 && prop.type === "SpreadElement") {
        return;
      }
      if (this.options.ecmaVersion >= 6 && (prop.computed || prop.method || prop.shorthand)) {
        return;
      }
      var key = prop.key;
      var name;
      switch (key.type) {
        case "Identifier":
          name = key.name;
          break;
        case "Literal":
          name = String(key.value);
          break;
        default:
          return;
      }
      var kind = prop.kind;
      if (this.options.ecmaVersion >= 6) {
        if (name === "__proto__" && kind === "init") {
          if (propHash.proto) {
            if (refDestructuringErrors) {
              if (refDestructuringErrors.doubleProto < 0) {
                refDestructuringErrors.doubleProto = key.start;
              }
            } else {
              this.raiseRecoverable(key.start, "Redefinition of __proto__ property");
            }
          }
          propHash.proto = true;
        }
        return;
      }
      name = "$" + name;
      var other = propHash[name];
      if (other) {
        var redefinition;
        if (kind === "init") {
          redefinition = this.strict && other.init || other.get || other.set;
        } else {
          redefinition = other.init || other[kind];
        }
        if (redefinition) {
          this.raiseRecoverable(key.start, "Redefinition of property");
        }
      } else {
        other = propHash[name] = {
          init: false,
          get: false,
          set: false
        };
      }
      other[kind] = true;
    };
    pp$3.parseExpression = function(forInit, refDestructuringErrors) {
      var startPos = this.start, startLoc = this.startLoc;
      var expr = this.parseMaybeAssign(forInit, refDestructuringErrors);
      if (this.type === types2.comma) {
        var node = this.startNodeAt(startPos, startLoc);
        node.expressions = [expr];
        while (this.eat(types2.comma)) {
          node.expressions.push(this.parseMaybeAssign(forInit, refDestructuringErrors));
        }
        return this.finishNode(node, "SequenceExpression");
      }
      return expr;
    };
    pp$3.parseMaybeAssign = function(forInit, refDestructuringErrors, afterLeftParse) {
      if (this.isContextual("yield")) {
        if (this.inGenerator) {
          return this.parseYield(forInit);
        } else {
          this.exprAllowed = false;
        }
      }
      var ownDestructuringErrors = false, oldParenAssign = -1, oldTrailingComma = -1;
      if (refDestructuringErrors) {
        oldParenAssign = refDestructuringErrors.parenthesizedAssign;
        oldTrailingComma = refDestructuringErrors.trailingComma;
        refDestructuringErrors.parenthesizedAssign = refDestructuringErrors.trailingComma = -1;
      } else {
        refDestructuringErrors = new DestructuringErrors();
        ownDestructuringErrors = true;
      }
      var startPos = this.start, startLoc = this.startLoc;
      if (this.type === types2.parenL || this.type === types2.name) {
        this.potentialArrowAt = this.start;
        this.potentialArrowInForAwait = forInit === "await";
      }
      var left = this.parseMaybeConditional(forInit, refDestructuringErrors);
      if (afterLeftParse) {
        left = afterLeftParse.call(this, left, startPos, startLoc);
      }
      if (this.type.isAssign) {
        var node = this.startNodeAt(startPos, startLoc);
        node.operator = this.value;
        if (this.type === types2.eq) {
          left = this.toAssignable(left, false, refDestructuringErrors);
        }
        if (!ownDestructuringErrors) {
          refDestructuringErrors.parenthesizedAssign = refDestructuringErrors.trailingComma = refDestructuringErrors.doubleProto = -1;
        }
        if (refDestructuringErrors.shorthandAssign >= left.start) {
          refDestructuringErrors.shorthandAssign = -1;
        }
        if (this.type === types2.eq) {
          this.checkLValPattern(left);
        } else {
          this.checkLValSimple(left);
        }
        node.left = left;
        this.next();
        node.right = this.parseMaybeAssign(forInit);
        return this.finishNode(node, "AssignmentExpression");
      } else {
        if (ownDestructuringErrors) {
          this.checkExpressionErrors(refDestructuringErrors, true);
        }
      }
      if (oldParenAssign > -1) {
        refDestructuringErrors.parenthesizedAssign = oldParenAssign;
      }
      if (oldTrailingComma > -1) {
        refDestructuringErrors.trailingComma = oldTrailingComma;
      }
      return left;
    };
    pp$3.parseMaybeConditional = function(forInit, refDestructuringErrors) {
      var startPos = this.start, startLoc = this.startLoc;
      var expr = this.parseExprOps(forInit, refDestructuringErrors);
      if (this.checkExpressionErrors(refDestructuringErrors)) {
        return expr;
      }
      if (this.eat(types2.question)) {
        var node = this.startNodeAt(startPos, startLoc);
        node.test = expr;
        node.consequent = this.parseMaybeAssign();
        this.expect(types2.colon);
        node.alternate = this.parseMaybeAssign(forInit);
        return this.finishNode(node, "ConditionalExpression");
      }
      return expr;
    };
    pp$3.parseExprOps = function(forInit, refDestructuringErrors) {
      var startPos = this.start, startLoc = this.startLoc;
      var expr = this.parseMaybeUnary(refDestructuringErrors, false);
      if (this.checkExpressionErrors(refDestructuringErrors)) {
        return expr;
      }
      return expr.start === startPos && expr.type === "ArrowFunctionExpression" ? expr : this.parseExprOp(expr, startPos, startLoc, -1, forInit);
    };
    pp$3.parseExprOp = function(left, leftStartPos, leftStartLoc, minPrec, forInit) {
      var prec = this.type.binop;
      if (prec != null && (!forInit || this.type !== types2._in)) {
        if (prec > minPrec) {
          var logical = this.type === types2.logicalOR || this.type === types2.logicalAND;
          var coalesce = this.type === types2.coalesce;
          if (coalesce) {
            prec = types2.logicalAND.binop;
          }
          var op = this.value;
          this.next();
          var startPos = this.start, startLoc = this.startLoc;
          var right = this.parseExprOp(this.parseMaybeUnary(null, false), startPos, startLoc, prec, forInit);
          var node = this.buildBinary(leftStartPos, leftStartLoc, left, right, op, logical || coalesce);
          if (logical && this.type === types2.coalesce || coalesce && (this.type === types2.logicalOR || this.type === types2.logicalAND)) {
            this.raiseRecoverable(this.start, "Logical expressions and coalesce expressions cannot be mixed. Wrap either by parentheses");
          }
          return this.parseExprOp(node, leftStartPos, leftStartLoc, minPrec, forInit);
        }
      }
      return left;
    };
    pp$3.buildBinary = function(startPos, startLoc, left, right, op, logical) {
      var node = this.startNodeAt(startPos, startLoc);
      node.left = left;
      node.operator = op;
      node.right = right;
      return this.finishNode(node, logical ? "LogicalExpression" : "BinaryExpression");
    };
    pp$3.parseMaybeUnary = function(refDestructuringErrors, sawUnary, incDec) {
      var startPos = this.start, startLoc = this.startLoc, expr;
      if (this.isContextual("await") && (this.inAsync || !this.inFunction && this.options.allowAwaitOutsideFunction)) {
        expr = this.parseAwait();
        sawUnary = true;
      } else if (this.type.prefix) {
        var node = this.startNode(), update = this.type === types2.incDec;
        node.operator = this.value;
        node.prefix = true;
        this.next();
        node.argument = this.parseMaybeUnary(null, true, update);
        this.checkExpressionErrors(refDestructuringErrors, true);
        if (update) {
          this.checkLValSimple(node.argument);
        } else if (this.strict && node.operator === "delete" && node.argument.type === "Identifier") {
          this.raiseRecoverable(node.start, "Deleting local variable in strict mode");
        } else if (node.operator === "delete" && isPrivateFieldAccess(node.argument)) {
          this.raiseRecoverable(node.start, "Private fields can not be deleted");
        } else {
          sawUnary = true;
        }
        expr = this.finishNode(node, update ? "UpdateExpression" : "UnaryExpression");
      } else {
        expr = this.parseExprSubscripts(refDestructuringErrors);
        if (this.checkExpressionErrors(refDestructuringErrors)) {
          return expr;
        }
        while (this.type.postfix && !this.canInsertSemicolon()) {
          var node$1 = this.startNodeAt(startPos, startLoc);
          node$1.operator = this.value;
          node$1.prefix = false;
          node$1.argument = expr;
          this.checkLValSimple(expr);
          this.next();
          expr = this.finishNode(node$1, "UpdateExpression");
        }
      }
      if (!incDec && this.eat(types2.starstar)) {
        if (sawUnary) {
          this.unexpected(this.lastTokStart);
        } else {
          return this.buildBinary(startPos, startLoc, expr, this.parseMaybeUnary(null, false), "**", false);
        }
      } else {
        return expr;
      }
    };
    pp$3.parseExprSubscripts = function(refDestructuringErrors) {
      var startPos = this.start, startLoc = this.startLoc;
      var expr = this.parseExprAtom(refDestructuringErrors);
      if (expr.type === "ArrowFunctionExpression" && this.input.slice(this.lastTokStart, this.lastTokEnd) !== ")") {
        return expr;
      }
      var result2 = this.parseSubscripts(expr, startPos, startLoc);
      if (refDestructuringErrors && result2.type === "MemberExpression") {
        if (refDestructuringErrors.parenthesizedAssign >= result2.start) {
          refDestructuringErrors.parenthesizedAssign = -1;
        }
        if (refDestructuringErrors.parenthesizedBind >= result2.start) {
          refDestructuringErrors.parenthesizedBind = -1;
        }
        if (refDestructuringErrors.trailingComma >= result2.start) {
          refDestructuringErrors.trailingComma = -1;
        }
      }
      return result2;
    };
    pp$3.parseSubscripts = function(base2, startPos, startLoc, noCalls) {
      var maybeAsyncArrow = this.options.ecmaVersion >= 8 && base2.type === "Identifier" && base2.name === "async" && this.lastTokEnd === base2.end && !this.canInsertSemicolon() && base2.end - base2.start === 5 && this.potentialArrowAt === base2.start;
      var optionalChained = false;
      while (true) {
        var element = this.parseSubscript(base2, startPos, startLoc, noCalls, maybeAsyncArrow, optionalChained);
        if (element.optional) {
          optionalChained = true;
        }
        if (element === base2 || element.type === "ArrowFunctionExpression") {
          if (optionalChained) {
            var chainNode = this.startNodeAt(startPos, startLoc);
            chainNode.expression = element;
            element = this.finishNode(chainNode, "ChainExpression");
          }
          return element;
        }
        base2 = element;
      }
    };
    pp$3.parseSubscript = function(base2, startPos, startLoc, noCalls, maybeAsyncArrow, optionalChained) {
      var optionalSupported = this.options.ecmaVersion >= 11;
      var optional = optionalSupported && this.eat(types2.questionDot);
      if (noCalls && optional) {
        this.raise(this.lastTokStart, "Optional chaining cannot appear in the callee of new expressions");
      }
      var computed = this.eat(types2.bracketL);
      if (computed || optional && this.type !== types2.parenL && this.type !== types2.backQuote || this.eat(types2.dot)) {
        var node = this.startNodeAt(startPos, startLoc);
        node.object = base2;
        if (computed) {
          node.property = this.parseExpression();
          this.expect(types2.bracketR);
        } else if (this.type === types2.privateId && base2.type !== "Super") {
          node.property = this.parsePrivateIdent();
        } else {
          node.property = this.parseIdent(this.options.allowReserved !== "never");
        }
        node.computed = !!computed;
        if (optionalSupported) {
          node.optional = optional;
        }
        base2 = this.finishNode(node, "MemberExpression");
      } else if (!noCalls && this.eat(types2.parenL)) {
        var refDestructuringErrors = new DestructuringErrors(), oldYieldPos = this.yieldPos, oldAwaitPos = this.awaitPos, oldAwaitIdentPos = this.awaitIdentPos;
        this.yieldPos = 0;
        this.awaitPos = 0;
        this.awaitIdentPos = 0;
        var exprList = this.parseExprList(types2.parenR, this.options.ecmaVersion >= 8, false, refDestructuringErrors);
        if (maybeAsyncArrow && !optional && !this.canInsertSemicolon() && this.eat(types2.arrow)) {
          this.checkPatternErrors(refDestructuringErrors, false);
          this.checkYieldAwaitInDefaultParams();
          if (this.awaitIdentPos > 0) {
            this.raise(this.awaitIdentPos, "Cannot use 'await' as identifier inside an async function");
          }
          this.yieldPos = oldYieldPos;
          this.awaitPos = oldAwaitPos;
          this.awaitIdentPos = oldAwaitIdentPos;
          return this.parseArrowExpression(this.startNodeAt(startPos, startLoc), exprList, true);
        }
        this.checkExpressionErrors(refDestructuringErrors, true);
        this.yieldPos = oldYieldPos || this.yieldPos;
        this.awaitPos = oldAwaitPos || this.awaitPos;
        this.awaitIdentPos = oldAwaitIdentPos || this.awaitIdentPos;
        var node$1 = this.startNodeAt(startPos, startLoc);
        node$1.callee = base2;
        node$1.arguments = exprList;
        if (optionalSupported) {
          node$1.optional = optional;
        }
        base2 = this.finishNode(node$1, "CallExpression");
      } else if (this.type === types2.backQuote) {
        if (optional || optionalChained) {
          this.raise(this.start, "Optional chaining cannot appear in the tag of tagged template expressions");
        }
        var node$2 = this.startNodeAt(startPos, startLoc);
        node$2.tag = base2;
        node$2.quasi = this.parseTemplate({ isTagged: true });
        base2 = this.finishNode(node$2, "TaggedTemplateExpression");
      }
      return base2;
    };
    pp$3.parseExprAtom = function(refDestructuringErrors) {
      if (this.type === types2.slash) {
        this.readRegexp();
      }
      var node, canBeArrow = this.potentialArrowAt === this.start;
      switch (this.type) {
        case types2._super:
          if (!this.allowSuper) {
            this.raise(this.start, "'super' keyword outside a method");
          }
          node = this.startNode();
          this.next();
          if (this.type === types2.parenL && !this.allowDirectSuper) {
            this.raise(node.start, "super() call outside constructor of a subclass");
          }
          if (this.type !== types2.dot && this.type !== types2.bracketL && this.type !== types2.parenL) {
            this.unexpected();
          }
          return this.finishNode(node, "Super");
        case types2._this:
          node = this.startNode();
          this.next();
          return this.finishNode(node, "ThisExpression");
        case types2.name:
          var startPos = this.start, startLoc = this.startLoc, containsEsc = this.containsEsc;
          var id = this.parseIdent(false);
          if (this.options.ecmaVersion >= 8 && !containsEsc && id.name === "async" && !this.canInsertSemicolon() && this.eat(types2._function)) {
            return this.parseFunction(this.startNodeAt(startPos, startLoc), 0, false, true);
          }
          if (canBeArrow && !this.canInsertSemicolon()) {
            if (this.eat(types2.arrow)) {
              return this.parseArrowExpression(this.startNodeAt(startPos, startLoc), [id], false);
            }
            if (this.options.ecmaVersion >= 8 && id.name === "async" && this.type === types2.name && !containsEsc && (!this.potentialArrowInForAwait || this.value !== "of" || this.containsEsc)) {
              id = this.parseIdent(false);
              if (this.canInsertSemicolon() || !this.eat(types2.arrow)) {
                this.unexpected();
              }
              return this.parseArrowExpression(this.startNodeAt(startPos, startLoc), [id], true);
            }
          }
          return id;
        case types2.regexp:
          var value = this.value;
          node = this.parseLiteral(value.value);
          node.regex = { pattern: value.pattern, flags: value.flags };
          return node;
        case types2.num:
        case types2.string:
          return this.parseLiteral(this.value);
        case types2._null:
        case types2._true:
        case types2._false:
          node = this.startNode();
          node.value = this.type === types2._null ? null : this.type === types2._true;
          node.raw = this.type.keyword;
          this.next();
          return this.finishNode(node, "Literal");
        case types2.parenL:
          var start = this.start, expr = this.parseParenAndDistinguishExpression(canBeArrow);
          if (refDestructuringErrors) {
            if (refDestructuringErrors.parenthesizedAssign < 0 && !this.isSimpleAssignTarget(expr)) {
              refDestructuringErrors.parenthesizedAssign = start;
            }
            if (refDestructuringErrors.parenthesizedBind < 0) {
              refDestructuringErrors.parenthesizedBind = start;
            }
          }
          return expr;
        case types2.bracketL:
          node = this.startNode();
          this.next();
          node.elements = this.parseExprList(types2.bracketR, true, true, refDestructuringErrors);
          return this.finishNode(node, "ArrayExpression");
        case types2.braceL:
          return this.parseObj(false, refDestructuringErrors);
        case types2._function:
          node = this.startNode();
          this.next();
          return this.parseFunction(node, 0);
        case types2._class:
          return this.parseClass(this.startNode(), false);
        case types2._new:
          return this.parseNew();
        case types2.backQuote:
          return this.parseTemplate();
        case types2._import:
          if (this.options.ecmaVersion >= 11) {
            return this.parseExprImport();
          } else {
            return this.unexpected();
          }
        default:
          this.unexpected();
      }
    };
    pp$3.parseExprImport = function() {
      var node = this.startNode();
      if (this.containsEsc) {
        this.raiseRecoverable(this.start, "Escape sequence in keyword import");
      }
      var meta = this.parseIdent(true);
      switch (this.type) {
        case types2.parenL:
          return this.parseDynamicImport(node);
        case types2.dot:
          node.meta = meta;
          return this.parseImportMeta(node);
        default:
          this.unexpected();
      }
    };
    pp$3.parseDynamicImport = function(node) {
      this.next();
      node.source = this.parseMaybeAssign();
      if (!this.eat(types2.parenR)) {
        var errorPos = this.start;
        if (this.eat(types2.comma) && this.eat(types2.parenR)) {
          this.raiseRecoverable(errorPos, "Trailing comma is not allowed in import()");
        } else {
          this.unexpected(errorPos);
        }
      }
      return this.finishNode(node, "ImportExpression");
    };
    pp$3.parseImportMeta = function(node) {
      this.next();
      var containsEsc = this.containsEsc;
      node.property = this.parseIdent(true);
      if (node.property.name !== "meta") {
        this.raiseRecoverable(node.property.start, "The only valid meta property for import is 'import.meta'");
      }
      if (containsEsc) {
        this.raiseRecoverable(node.start, "'import.meta' must not contain escaped characters");
      }
      if (this.options.sourceType !== "module" && !this.options.allowImportExportEverywhere) {
        this.raiseRecoverable(node.start, "Cannot use 'import.meta' outside a module");
      }
      return this.finishNode(node, "MetaProperty");
    };
    pp$3.parseLiteral = function(value) {
      var node = this.startNode();
      node.value = value;
      node.raw = this.input.slice(this.start, this.end);
      if (node.raw.charCodeAt(node.raw.length - 1) === 110) {
        node.bigint = node.raw.slice(0, -1).replace(/_/g, "");
      }
      this.next();
      return this.finishNode(node, "Literal");
    };
    pp$3.parseParenExpression = function() {
      this.expect(types2.parenL);
      var val = this.parseExpression();
      this.expect(types2.parenR);
      return val;
    };
    pp$3.parseParenAndDistinguishExpression = function(canBeArrow) {
      var startPos = this.start, startLoc = this.startLoc, val, allowTrailingComma = this.options.ecmaVersion >= 8;
      if (this.options.ecmaVersion >= 6) {
        this.next();
        var innerStartPos = this.start, innerStartLoc = this.startLoc;
        var exprList = [], first = true, lastIsComma = false;
        var refDestructuringErrors = new DestructuringErrors(), oldYieldPos = this.yieldPos, oldAwaitPos = this.awaitPos, spreadStart;
        this.yieldPos = 0;
        this.awaitPos = 0;
        while (this.type !== types2.parenR) {
          first ? first = false : this.expect(types2.comma);
          if (allowTrailingComma && this.afterTrailingComma(types2.parenR, true)) {
            lastIsComma = true;
            break;
          } else if (this.type === types2.ellipsis) {
            spreadStart = this.start;
            exprList.push(this.parseParenItem(this.parseRestBinding()));
            if (this.type === types2.comma) {
              this.raise(this.start, "Comma is not permitted after the rest element");
            }
            break;
          } else {
            exprList.push(this.parseMaybeAssign(false, refDestructuringErrors, this.parseParenItem));
          }
        }
        var innerEndPos = this.start, innerEndLoc = this.startLoc;
        this.expect(types2.parenR);
        if (canBeArrow && !this.canInsertSemicolon() && this.eat(types2.arrow)) {
          this.checkPatternErrors(refDestructuringErrors, false);
          this.checkYieldAwaitInDefaultParams();
          this.yieldPos = oldYieldPos;
          this.awaitPos = oldAwaitPos;
          return this.parseParenArrowList(startPos, startLoc, exprList);
        }
        if (!exprList.length || lastIsComma) {
          this.unexpected(this.lastTokStart);
        }
        if (spreadStart) {
          this.unexpected(spreadStart);
        }
        this.checkExpressionErrors(refDestructuringErrors, true);
        this.yieldPos = oldYieldPos || this.yieldPos;
        this.awaitPos = oldAwaitPos || this.awaitPos;
        if (exprList.length > 1) {
          val = this.startNodeAt(innerStartPos, innerStartLoc);
          val.expressions = exprList;
          this.finishNodeAt(val, "SequenceExpression", innerEndPos, innerEndLoc);
        } else {
          val = exprList[0];
        }
      } else {
        val = this.parseParenExpression();
      }
      if (this.options.preserveParens) {
        var par = this.startNodeAt(startPos, startLoc);
        par.expression = val;
        return this.finishNode(par, "ParenthesizedExpression");
      } else {
        return val;
      }
    };
    pp$3.parseParenItem = function(item) {
      return item;
    };
    pp$3.parseParenArrowList = function(startPos, startLoc, exprList) {
      return this.parseArrowExpression(this.startNodeAt(startPos, startLoc), exprList);
    };
    empty$1 = [];
    pp$3.parseNew = function() {
      if (this.containsEsc) {
        this.raiseRecoverable(this.start, "Escape sequence in keyword new");
      }
      var node = this.startNode();
      var meta = this.parseIdent(true);
      if (this.options.ecmaVersion >= 6 && this.eat(types2.dot)) {
        node.meta = meta;
        var containsEsc = this.containsEsc;
        node.property = this.parseIdent(true);
        if (node.property.name !== "target") {
          this.raiseRecoverable(node.property.start, "The only valid meta property for new is 'new.target'");
        }
        if (containsEsc) {
          this.raiseRecoverable(node.start, "'new.target' must not contain escaped characters");
        }
        if (!this.inNonArrowFunction) {
          this.raiseRecoverable(node.start, "'new.target' can only be used in functions");
        }
        return this.finishNode(node, "MetaProperty");
      }
      var startPos = this.start, startLoc = this.startLoc, isImport = this.type === types2._import;
      node.callee = this.parseSubscripts(this.parseExprAtom(), startPos, startLoc, true);
      if (isImport && node.callee.type === "ImportExpression") {
        this.raise(startPos, "Cannot use new with import()");
      }
      if (this.eat(types2.parenL)) {
        node.arguments = this.parseExprList(types2.parenR, this.options.ecmaVersion >= 8, false);
      } else {
        node.arguments = empty$1;
      }
      return this.finishNode(node, "NewExpression");
    };
    pp$3.parseTemplateElement = function(ref2) {
      var isTagged = ref2.isTagged;
      var elem = this.startNode();
      if (this.type === types2.invalidTemplate) {
        if (!isTagged) {
          this.raiseRecoverable(this.start, "Bad escape sequence in untagged template literal");
        }
        elem.value = {
          raw: this.value,
          cooked: null
        };
      } else {
        elem.value = {
          raw: this.input.slice(this.start, this.end).replace(/\r\n?/g, "\n"),
          cooked: this.value
        };
      }
      this.next();
      elem.tail = this.type === types2.backQuote;
      return this.finishNode(elem, "TemplateElement");
    };
    pp$3.parseTemplate = function(ref2) {
      if (ref2 === void 0) ref2 = {};
      var isTagged = ref2.isTagged;
      if (isTagged === void 0) isTagged = false;
      var node = this.startNode();
      this.next();
      node.expressions = [];
      var curElt = this.parseTemplateElement({ isTagged });
      node.quasis = [curElt];
      while (!curElt.tail) {
        if (this.type === types2.eof) {
          this.raise(this.pos, "Unterminated template literal");
        }
        this.expect(types2.dollarBraceL);
        node.expressions.push(this.parseExpression());
        this.expect(types2.braceR);
        node.quasis.push(curElt = this.parseTemplateElement({ isTagged }));
      }
      this.next();
      return this.finishNode(node, "TemplateLiteral");
    };
    pp$3.isAsyncProp = function(prop) {
      return !prop.computed && prop.key.type === "Identifier" && prop.key.name === "async" && (this.type === types2.name || this.type === types2.num || this.type === types2.string || this.type === types2.bracketL || this.type.keyword || this.options.ecmaVersion >= 9 && this.type === types2.star) && !lineBreak.test(this.input.slice(this.lastTokEnd, this.start));
    };
    pp$3.parseObj = function(isPattern, refDestructuringErrors) {
      var node = this.startNode(), first = true, propHash = {};
      node.properties = [];
      this.next();
      while (!this.eat(types2.braceR)) {
        if (!first) {
          this.expect(types2.comma);
          if (this.options.ecmaVersion >= 5 && this.afterTrailingComma(types2.braceR)) {
            break;
          }
        } else {
          first = false;
        }
        var prop = this.parseProperty(isPattern, refDestructuringErrors);
        if (!isPattern) {
          this.checkPropClash(prop, propHash, refDestructuringErrors);
        }
        node.properties.push(prop);
      }
      return this.finishNode(node, isPattern ? "ObjectPattern" : "ObjectExpression");
    };
    pp$3.parseProperty = function(isPattern, refDestructuringErrors) {
      var prop = this.startNode(), isGenerator, isAsync, startPos, startLoc;
      if (this.options.ecmaVersion >= 9 && this.eat(types2.ellipsis)) {
        if (isPattern) {
          prop.argument = this.parseIdent(false);
          if (this.type === types2.comma) {
            this.raise(this.start, "Comma is not permitted after the rest element");
          }
          return this.finishNode(prop, "RestElement");
        }
        if (this.type === types2.parenL && refDestructuringErrors) {
          if (refDestructuringErrors.parenthesizedAssign < 0) {
            refDestructuringErrors.parenthesizedAssign = this.start;
          }
          if (refDestructuringErrors.parenthesizedBind < 0) {
            refDestructuringErrors.parenthesizedBind = this.start;
          }
        }
        prop.argument = this.parseMaybeAssign(false, refDestructuringErrors);
        if (this.type === types2.comma && refDestructuringErrors && refDestructuringErrors.trailingComma < 0) {
          refDestructuringErrors.trailingComma = this.start;
        }
        return this.finishNode(prop, "SpreadElement");
      }
      if (this.options.ecmaVersion >= 6) {
        prop.method = false;
        prop.shorthand = false;
        if (isPattern || refDestructuringErrors) {
          startPos = this.start;
          startLoc = this.startLoc;
        }
        if (!isPattern) {
          isGenerator = this.eat(types2.star);
        }
      }
      var containsEsc = this.containsEsc;
      this.parsePropertyName(prop);
      if (!isPattern && !containsEsc && this.options.ecmaVersion >= 8 && !isGenerator && this.isAsyncProp(prop)) {
        isAsync = true;
        isGenerator = this.options.ecmaVersion >= 9 && this.eat(types2.star);
        this.parsePropertyName(prop, refDestructuringErrors);
      } else {
        isAsync = false;
      }
      this.parsePropertyValue(prop, isPattern, isGenerator, isAsync, startPos, startLoc, refDestructuringErrors, containsEsc);
      return this.finishNode(prop, "Property");
    };
    pp$3.parsePropertyValue = function(prop, isPattern, isGenerator, isAsync, startPos, startLoc, refDestructuringErrors, containsEsc) {
      if ((isGenerator || isAsync) && this.type === types2.colon) {
        this.unexpected();
      }
      if (this.eat(types2.colon)) {
        prop.value = isPattern ? this.parseMaybeDefault(this.start, this.startLoc) : this.parseMaybeAssign(false, refDestructuringErrors);
        prop.kind = "init";
      } else if (this.options.ecmaVersion >= 6 && this.type === types2.parenL) {
        if (isPattern) {
          this.unexpected();
        }
        prop.kind = "init";
        prop.method = true;
        prop.value = this.parseMethod(isGenerator, isAsync);
      } else if (!isPattern && !containsEsc && this.options.ecmaVersion >= 5 && !prop.computed && prop.key.type === "Identifier" && (prop.key.name === "get" || prop.key.name === "set") && (this.type !== types2.comma && this.type !== types2.braceR && this.type !== types2.eq)) {
        if (isGenerator || isAsync) {
          this.unexpected();
        }
        prop.kind = prop.key.name;
        this.parsePropertyName(prop);
        prop.value = this.parseMethod(false);
        var paramCount = prop.kind === "get" ? 0 : 1;
        if (prop.value.params.length !== paramCount) {
          var start = prop.value.start;
          if (prop.kind === "get") {
            this.raiseRecoverable(start, "getter should have no params");
          } else {
            this.raiseRecoverable(start, "setter should have exactly one param");
          }
        } else {
          if (prop.kind === "set" && prop.value.params[0].type === "RestElement") {
            this.raiseRecoverable(prop.value.params[0].start, "Setter cannot use rest params");
          }
        }
      } else if (this.options.ecmaVersion >= 6 && !prop.computed && prop.key.type === "Identifier") {
        if (isGenerator || isAsync) {
          this.unexpected();
        }
        this.checkUnreserved(prop.key);
        if (prop.key.name === "await" && !this.awaitIdentPos) {
          this.awaitIdentPos = startPos;
        }
        prop.kind = "init";
        if (isPattern) {
          prop.value = this.parseMaybeDefault(startPos, startLoc, this.copyNode(prop.key));
        } else if (this.type === types2.eq && refDestructuringErrors) {
          if (refDestructuringErrors.shorthandAssign < 0) {
            refDestructuringErrors.shorthandAssign = this.start;
          }
          prop.value = this.parseMaybeDefault(startPos, startLoc, this.copyNode(prop.key));
        } else {
          prop.value = this.copyNode(prop.key);
        }
        prop.shorthand = true;
      } else {
        this.unexpected();
      }
    };
    pp$3.parsePropertyName = function(prop) {
      if (this.options.ecmaVersion >= 6) {
        if (this.eat(types2.bracketL)) {
          prop.computed = true;
          prop.key = this.parseMaybeAssign();
          this.expect(types2.bracketR);
          return prop.key;
        } else {
          prop.computed = false;
        }
      }
      return prop.key = this.type === types2.num || this.type === types2.string ? this.parseExprAtom() : this.parseIdent(this.options.allowReserved !== "never");
    };
    pp$3.initFunction = function(node) {
      node.id = null;
      if (this.options.ecmaVersion >= 6) {
        node.generator = node.expression = false;
      }
      if (this.options.ecmaVersion >= 8) {
        node.async = false;
      }
    };
    pp$3.parseMethod = function(isGenerator, isAsync, allowDirectSuper) {
      var node = this.startNode(), oldYieldPos = this.yieldPos, oldAwaitPos = this.awaitPos, oldAwaitIdentPos = this.awaitIdentPos;
      this.initFunction(node);
      if (this.options.ecmaVersion >= 6) {
        node.generator = isGenerator;
      }
      if (this.options.ecmaVersion >= 8) {
        node.async = !!isAsync;
      }
      this.yieldPos = 0;
      this.awaitPos = 0;
      this.awaitIdentPos = 0;
      this.enterScope(functionFlags(isAsync, node.generator) | SCOPE_SUPER | (allowDirectSuper ? SCOPE_DIRECT_SUPER : 0));
      this.expect(types2.parenL);
      node.params = this.parseBindingList(types2.parenR, false, this.options.ecmaVersion >= 8);
      this.checkYieldAwaitInDefaultParams();
      this.parseFunctionBody(node, false, true);
      this.yieldPos = oldYieldPos;
      this.awaitPos = oldAwaitPos;
      this.awaitIdentPos = oldAwaitIdentPos;
      return this.finishNode(node, "FunctionExpression");
    };
    pp$3.parseArrowExpression = function(node, params, isAsync) {
      var oldYieldPos = this.yieldPos, oldAwaitPos = this.awaitPos, oldAwaitIdentPos = this.awaitIdentPos;
      this.enterScope(functionFlags(isAsync, false) | SCOPE_ARROW);
      this.initFunction(node);
      if (this.options.ecmaVersion >= 8) {
        node.async = !!isAsync;
      }
      this.yieldPos = 0;
      this.awaitPos = 0;
      this.awaitIdentPos = 0;
      node.params = this.toAssignableList(params, true);
      this.parseFunctionBody(node, true, false);
      this.yieldPos = oldYieldPos;
      this.awaitPos = oldAwaitPos;
      this.awaitIdentPos = oldAwaitIdentPos;
      return this.finishNode(node, "ArrowFunctionExpression");
    };
    pp$3.parseFunctionBody = function(node, isArrowFunction, isMethod2) {
      var isExpression = isArrowFunction && this.type !== types2.braceL;
      var oldStrict = this.strict, useStrict = false;
      if (isExpression) {
        node.body = this.parseMaybeAssign();
        node.expression = true;
        this.checkParams(node, false);
      } else {
        var nonSimple = this.options.ecmaVersion >= 7 && !this.isSimpleParamList(node.params);
        if (!oldStrict || nonSimple) {
          useStrict = this.strictDirective(this.end);
          if (useStrict && nonSimple) {
            this.raiseRecoverable(node.start, "Illegal 'use strict' directive in function with non-simple parameter list");
          }
        }
        var oldLabels = this.labels;
        this.labels = [];
        if (useStrict) {
          this.strict = true;
        }
        this.checkParams(node, !oldStrict && !useStrict && !isArrowFunction && !isMethod2 && this.isSimpleParamList(node.params));
        if (this.strict && node.id) {
          this.checkLValSimple(node.id, BIND_OUTSIDE);
        }
        node.body = this.parseBlock(false, void 0, useStrict && !oldStrict);
        node.expression = false;
        this.adaptDirectivePrologue(node.body.body);
        this.labels = oldLabels;
      }
      this.exitScope();
    };
    pp$3.isSimpleParamList = function(params) {
      for (var i = 0, list = params; i < list.length; i += 1) {
        var param = list[i];
        if (param.type !== "Identifier") {
          return false;
        }
      }
      return true;
    };
    pp$3.checkParams = function(node, allowDuplicates) {
      var nameHash = /* @__PURE__ */ Object.create(null);
      for (var i = 0, list = node.params; i < list.length; i += 1) {
        var param = list[i];
        this.checkLValInnerPattern(param, BIND_VAR, allowDuplicates ? null : nameHash);
      }
    };
    pp$3.parseExprList = function(close, allowTrailingComma, allowEmpty, refDestructuringErrors) {
      var elts = [], first = true;
      while (!this.eat(close)) {
        if (!first) {
          this.expect(types2.comma);
          if (allowTrailingComma && this.afterTrailingComma(close)) {
            break;
          }
        } else {
          first = false;
        }
        var elt = void 0;
        if (allowEmpty && this.type === types2.comma) {
          elt = null;
        } else if (this.type === types2.ellipsis) {
          elt = this.parseSpread(refDestructuringErrors);
          if (refDestructuringErrors && this.type === types2.comma && refDestructuringErrors.trailingComma < 0) {
            refDestructuringErrors.trailingComma = this.start;
          }
        } else {
          elt = this.parseMaybeAssign(false, refDestructuringErrors);
        }
        elts.push(elt);
      }
      return elts;
    };
    pp$3.checkUnreserved = function(ref2) {
      var start = ref2.start;
      var end = ref2.end;
      var name = ref2.name;
      if (this.inGenerator && name === "yield") {
        this.raiseRecoverable(start, "Cannot use 'yield' as identifier inside a generator");
      }
      if (this.inAsync && name === "await") {
        this.raiseRecoverable(start, "Cannot use 'await' as identifier inside an async function");
      }
      if (this.currentThisScope().inClassFieldInit && name === "arguments") {
        this.raiseRecoverable(start, "Cannot use 'arguments' in class field initializer");
      }
      if (this.keywords.test(name)) {
        this.raise(start, "Unexpected keyword '" + name + "'");
      }
      if (this.options.ecmaVersion < 6 && this.input.slice(start, end).indexOf("\\") !== -1) {
        return;
      }
      var re = this.strict ? this.reservedWordsStrict : this.reservedWords;
      if (re.test(name)) {
        if (!this.inAsync && name === "await") {
          this.raiseRecoverable(start, "Cannot use keyword 'await' outside an async function");
        }
        this.raiseRecoverable(start, "The keyword '" + name + "' is reserved");
      }
    };
    pp$3.parseIdent = function(liberal, isBinding) {
      var node = this.startNode();
      if (this.type === types2.name) {
        node.name = this.value;
      } else if (this.type.keyword) {
        node.name = this.type.keyword;
        if ((node.name === "class" || node.name === "function") && (this.lastTokEnd !== this.lastTokStart + 1 || this.input.charCodeAt(this.lastTokStart) !== 46)) {
          this.context.pop();
        }
      } else {
        this.unexpected();
      }
      this.next(!!liberal);
      this.finishNode(node, "Identifier");
      if (!liberal) {
        this.checkUnreserved(node);
        if (node.name === "await" && !this.awaitIdentPos) {
          this.awaitIdentPos = node.start;
        }
      }
      return node;
    };
    pp$3.parsePrivateIdent = function() {
      var node = this.startNode();
      if (this.type === types2.privateId) {
        node.name = this.value;
      } else {
        this.unexpected();
      }
      this.next();
      this.finishNode(node, "PrivateIdentifier");
      if (this.privateNameStack.length === 0) {
        this.raise(node.start, "Private field '#" + node.name + "' must be declared in an enclosing class");
      } else {
        this.privateNameStack[this.privateNameStack.length - 1].used.push(node);
      }
      return node;
    };
    pp$3.parseYield = function(forInit) {
      if (!this.yieldPos) {
        this.yieldPos = this.start;
      }
      var node = this.startNode();
      this.next();
      if (this.type === types2.semi || this.canInsertSemicolon() || this.type !== types2.star && !this.type.startsExpr) {
        node.delegate = false;
        node.argument = null;
      } else {
        node.delegate = this.eat(types2.star);
        node.argument = this.parseMaybeAssign(forInit);
      }
      return this.finishNode(node, "YieldExpression");
    };
    pp$3.parseAwait = function() {
      if (!this.awaitPos) {
        this.awaitPos = this.start;
      }
      var node = this.startNode();
      this.next();
      node.argument = this.parseMaybeUnary(null, true);
      return this.finishNode(node, "AwaitExpression");
    };
    pp$4 = Parser.prototype;
    pp$4.raise = function(pos, message) {
      var loc = getLineInfo(this.input, pos);
      message += " (" + loc.line + ":" + loc.column + ")";
      var err2 = new SyntaxError(message);
      err2.pos = pos;
      err2.loc = loc;
      err2.raisedAt = this.pos;
      throw err2;
    };
    pp$4.raiseRecoverable = pp$4.raise;
    pp$4.curPosition = function() {
      if (this.options.locations) {
        return new Position(this.curLine, this.pos - this.lineStart);
      }
    };
    pp$5 = Parser.prototype;
    Scope2 = function Scope3(flags) {
      this.flags = flags;
      this.var = [];
      this.lexical = [];
      this.functions = [];
      this.inClassFieldInit = false;
    };
    pp$5.enterScope = function(flags) {
      this.scopeStack.push(new Scope2(flags));
    };
    pp$5.exitScope = function() {
      this.scopeStack.pop();
    };
    pp$5.treatFunctionsAsVarInScope = function(scope) {
      return scope.flags & SCOPE_FUNCTION || !this.inModule && scope.flags & SCOPE_TOP;
    };
    pp$5.declareName = function(name, bindingType, pos) {
      var redeclared = false;
      if (bindingType === BIND_LEXICAL) {
        var scope = this.currentScope();
        redeclared = scope.lexical.indexOf(name) > -1 || scope.functions.indexOf(name) > -1 || scope.var.indexOf(name) > -1;
        scope.lexical.push(name);
        if (this.inModule && scope.flags & SCOPE_TOP) {
          delete this.undefinedExports[name];
        }
      } else if (bindingType === BIND_SIMPLE_CATCH) {
        var scope$1 = this.currentScope();
        scope$1.lexical.push(name);
      } else if (bindingType === BIND_FUNCTION) {
        var scope$2 = this.currentScope();
        if (this.treatFunctionsAsVar) {
          redeclared = scope$2.lexical.indexOf(name) > -1;
        } else {
          redeclared = scope$2.lexical.indexOf(name) > -1 || scope$2.var.indexOf(name) > -1;
        }
        scope$2.functions.push(name);
      } else {
        for (var i = this.scopeStack.length - 1; i >= 0; --i) {
          var scope$3 = this.scopeStack[i];
          if (scope$3.lexical.indexOf(name) > -1 && !(scope$3.flags & SCOPE_SIMPLE_CATCH && scope$3.lexical[0] === name) || !this.treatFunctionsAsVarInScope(scope$3) && scope$3.functions.indexOf(name) > -1) {
            redeclared = true;
            break;
          }
          scope$3.var.push(name);
          if (this.inModule && scope$3.flags & SCOPE_TOP) {
            delete this.undefinedExports[name];
          }
          if (scope$3.flags & SCOPE_VAR) {
            break;
          }
        }
      }
      if (redeclared) {
        this.raiseRecoverable(pos, "Identifier '" + name + "' has already been declared");
      }
    };
    pp$5.checkLocalExport = function(id) {
      if (this.scopeStack[0].lexical.indexOf(id.name) === -1 && this.scopeStack[0].var.indexOf(id.name) === -1) {
        this.undefinedExports[id.name] = id;
      }
    };
    pp$5.currentScope = function() {
      return this.scopeStack[this.scopeStack.length - 1];
    };
    pp$5.currentVarScope = function() {
      for (var i = this.scopeStack.length - 1; ; i--) {
        var scope = this.scopeStack[i];
        if (scope.flags & SCOPE_VAR) {
          return scope;
        }
      }
    };
    pp$5.currentThisScope = function() {
      for (var i = this.scopeStack.length - 1; ; i--) {
        var scope = this.scopeStack[i];
        if (scope.flags & SCOPE_VAR && !(scope.flags & SCOPE_ARROW)) {
          return scope;
        }
      }
    };
    Node = function Node2(parser, pos, loc) {
      this.type = "";
      this.start = pos;
      this.end = 0;
      if (parser.options.locations) {
        this.loc = new SourceLocation(parser, loc);
      }
      if (parser.options.directSourceFile) {
        this.sourceFile = parser.options.directSourceFile;
      }
      if (parser.options.ranges) {
        this.range = [pos, 0];
      }
    };
    pp$6 = Parser.prototype;
    pp$6.startNode = function() {
      return new Node(this, this.start, this.startLoc);
    };
    pp$6.startNodeAt = function(pos, loc) {
      return new Node(this, pos, loc);
    };
    pp$6.finishNode = function(node, type) {
      return finishNodeAt.call(this, node, type, this.lastTokEnd, this.lastTokEndLoc);
    };
    pp$6.finishNodeAt = function(node, type, pos, loc) {
      return finishNodeAt.call(this, node, type, pos, loc);
    };
    pp$6.copyNode = function(node) {
      var newNode = new Node(this, node.start, this.startLoc);
      for (var prop in node) {
        newNode[prop] = node[prop];
      }
      return newNode;
    };
    TokContext = function TokContext2(token, isExpr, preserveSpace, override, generator) {
      this.token = token;
      this.isExpr = !!isExpr;
      this.preserveSpace = !!preserveSpace;
      this.override = override;
      this.generator = !!generator;
    };
    types$1 = {
      b_stat: new TokContext("{", false),
      b_expr: new TokContext("{", true),
      b_tmpl: new TokContext("${", false),
      p_stat: new TokContext("(", false),
      p_expr: new TokContext("(", true),
      q_tmpl: new TokContext("`", true, true, function(p) {
        return p.tryReadTemplateToken();
      }),
      f_stat: new TokContext("function", false),
      f_expr: new TokContext("function", true),
      f_expr_gen: new TokContext("function", true, false, null, true),
      f_gen: new TokContext("function", false, false, null, true)
    };
    pp$7 = Parser.prototype;
    pp$7.initialContext = function() {
      return [types$1.b_stat];
    };
    pp$7.braceIsBlock = function(prevType) {
      var parent = this.curContext();
      if (parent === types$1.f_expr || parent === types$1.f_stat) {
        return true;
      }
      if (prevType === types2.colon && (parent === types$1.b_stat || parent === types$1.b_expr)) {
        return !parent.isExpr;
      }
      if (prevType === types2._return || prevType === types2.name && this.exprAllowed) {
        return lineBreak.test(this.input.slice(this.lastTokEnd, this.start));
      }
      if (prevType === types2._else || prevType === types2.semi || prevType === types2.eof || prevType === types2.parenR || prevType === types2.arrow) {
        return true;
      }
      if (prevType === types2.braceL) {
        return parent === types$1.b_stat;
      }
      if (prevType === types2._var || prevType === types2._const || prevType === types2.name) {
        return false;
      }
      return !this.exprAllowed;
    };
    pp$7.inGeneratorContext = function() {
      for (var i = this.context.length - 1; i >= 1; i--) {
        var context = this.context[i];
        if (context.token === "function") {
          return context.generator;
        }
      }
      return false;
    };
    pp$7.updateContext = function(prevType) {
      var update, type = this.type;
      if (type.keyword && prevType === types2.dot) {
        this.exprAllowed = false;
      } else if (update = type.updateContext) {
        update.call(this, prevType);
      } else {
        this.exprAllowed = type.beforeExpr;
      }
    };
    types2.parenR.updateContext = types2.braceR.updateContext = function() {
      if (this.context.length === 1) {
        this.exprAllowed = true;
        return;
      }
      var out = this.context.pop();
      if (out === types$1.b_stat && this.curContext().token === "function") {
        out = this.context.pop();
      }
      this.exprAllowed = !out.isExpr;
    };
    types2.braceL.updateContext = function(prevType) {
      this.context.push(this.braceIsBlock(prevType) ? types$1.b_stat : types$1.b_expr);
      this.exprAllowed = true;
    };
    types2.dollarBraceL.updateContext = function() {
      this.context.push(types$1.b_tmpl);
      this.exprAllowed = true;
    };
    types2.parenL.updateContext = function(prevType) {
      var statementParens = prevType === types2._if || prevType === types2._for || prevType === types2._with || prevType === types2._while;
      this.context.push(statementParens ? types$1.p_stat : types$1.p_expr);
      this.exprAllowed = true;
    };
    types2.incDec.updateContext = function() {
    };
    types2._function.updateContext = types2._class.updateContext = function(prevType) {
      if (prevType.beforeExpr && prevType !== types2._else && !(prevType === types2.semi && this.curContext() !== types$1.p_stat) && !(prevType === types2._return && lineBreak.test(this.input.slice(this.lastTokEnd, this.start))) && !((prevType === types2.colon || prevType === types2.braceL) && this.curContext() === types$1.b_stat)) {
        this.context.push(types$1.f_expr);
      } else {
        this.context.push(types$1.f_stat);
      }
      this.exprAllowed = false;
    };
    types2.backQuote.updateContext = function() {
      if (this.curContext() === types$1.q_tmpl) {
        this.context.pop();
      } else {
        this.context.push(types$1.q_tmpl);
      }
      this.exprAllowed = false;
    };
    types2.star.updateContext = function(prevType) {
      if (prevType === types2._function) {
        var index2 = this.context.length - 1;
        if (this.context[index2] === types$1.f_expr) {
          this.context[index2] = types$1.f_expr_gen;
        } else {
          this.context[index2] = types$1.f_gen;
        }
      }
      this.exprAllowed = true;
    };
    types2.name.updateContext = function(prevType) {
      var allowed = false;
      if (this.options.ecmaVersion >= 6 && prevType !== types2.dot) {
        if (this.value === "of" && !this.exprAllowed || this.value === "yield" && this.inGeneratorContext()) {
          allowed = true;
        }
      }
      this.exprAllowed = allowed;
    };
    ecma9BinaryProperties = "ASCII ASCII_Hex_Digit AHex Alphabetic Alpha Any Assigned Bidi_Control Bidi_C Bidi_Mirrored Bidi_M Case_Ignorable CI Cased Changes_When_Casefolded CWCF Changes_When_Casemapped CWCM Changes_When_Lowercased CWL Changes_When_NFKC_Casefolded CWKCF Changes_When_Titlecased CWT Changes_When_Uppercased CWU Dash Default_Ignorable_Code_Point DI Deprecated Dep Diacritic Dia Emoji Emoji_Component Emoji_Modifier Emoji_Modifier_Base Emoji_Presentation Extender Ext Grapheme_Base Gr_Base Grapheme_Extend Gr_Ext Hex_Digit Hex IDS_Binary_Operator IDSB IDS_Trinary_Operator IDST ID_Continue IDC ID_Start IDS Ideographic Ideo Join_Control Join_C Logical_Order_Exception LOE Lowercase Lower Math Noncharacter_Code_Point NChar Pattern_Syntax Pat_Syn Pattern_White_Space Pat_WS Quotation_Mark QMark Radical Regional_Indicator RI Sentence_Terminal STerm Soft_Dotted SD Terminal_Punctuation Term Unified_Ideograph UIdeo Uppercase Upper Variation_Selector VS White_Space space XID_Continue XIDC XID_Start XIDS";
    ecma10BinaryProperties = ecma9BinaryProperties + " Extended_Pictographic";
    ecma11BinaryProperties = ecma10BinaryProperties;
    ecma12BinaryProperties = ecma11BinaryProperties + " EBase EComp EMod EPres ExtPict";
    unicodeBinaryProperties = {
      9: ecma9BinaryProperties,
      10: ecma10BinaryProperties,
      11: ecma11BinaryProperties,
      12: ecma12BinaryProperties
    };
    unicodeGeneralCategoryValues = "Cased_Letter LC Close_Punctuation Pe Connector_Punctuation Pc Control Cc cntrl Currency_Symbol Sc Dash_Punctuation Pd Decimal_Number Nd digit Enclosing_Mark Me Final_Punctuation Pf Format Cf Initial_Punctuation Pi Letter L Letter_Number Nl Line_Separator Zl Lowercase_Letter Ll Mark M Combining_Mark Math_Symbol Sm Modifier_Letter Lm Modifier_Symbol Sk Nonspacing_Mark Mn Number N Open_Punctuation Ps Other C Other_Letter Lo Other_Number No Other_Punctuation Po Other_Symbol So Paragraph_Separator Zp Private_Use Co Punctuation P punct Separator Z Space_Separator Zs Spacing_Mark Mc Surrogate Cs Symbol S Titlecase_Letter Lt Unassigned Cn Uppercase_Letter Lu";
    ecma9ScriptValues = "Adlam Adlm Ahom Ahom Anatolian_Hieroglyphs Hluw Arabic Arab Armenian Armn Avestan Avst Balinese Bali Bamum Bamu Bassa_Vah Bass Batak Batk Bengali Beng Bhaiksuki Bhks Bopomofo Bopo Brahmi Brah Braille Brai Buginese Bugi Buhid Buhd Canadian_Aboriginal Cans Carian Cari Caucasian_Albanian Aghb Chakma Cakm Cham Cham Cherokee Cher Common Zyyy Coptic Copt Qaac Cuneiform Xsux Cypriot Cprt Cyrillic Cyrl Deseret Dsrt Devanagari Deva Duployan Dupl Egyptian_Hieroglyphs Egyp Elbasan Elba Ethiopic Ethi Georgian Geor Glagolitic Glag Gothic Goth Grantha Gran Greek Grek Gujarati Gujr Gurmukhi Guru Han Hani Hangul Hang Hanunoo Hano Hatran Hatr Hebrew Hebr Hiragana Hira Imperial_Aramaic Armi Inherited Zinh Qaai Inscriptional_Pahlavi Phli Inscriptional_Parthian Prti Javanese Java Kaithi Kthi Kannada Knda Katakana Kana Kayah_Li Kali Kharoshthi Khar Khmer Khmr Khojki Khoj Khudawadi Sind Lao Laoo Latin Latn Lepcha Lepc Limbu Limb Linear_A Lina Linear_B Linb Lisu Lisu Lycian Lyci Lydian Lydi Mahajani Mahj Malayalam Mlym Mandaic Mand Manichaean Mani Marchen Marc Masaram_Gondi Gonm Meetei_Mayek Mtei Mende_Kikakui Mend Meroitic_Cursive Merc Meroitic_Hieroglyphs Mero Miao Plrd Modi Modi Mongolian Mong Mro Mroo Multani Mult Myanmar Mymr Nabataean Nbat New_Tai_Lue Talu Newa Newa Nko Nkoo Nushu Nshu Ogham Ogam Ol_Chiki Olck Old_Hungarian Hung Old_Italic Ital Old_North_Arabian Narb Old_Permic Perm Old_Persian Xpeo Old_South_Arabian Sarb Old_Turkic Orkh Oriya Orya Osage Osge Osmanya Osma Pahawh_Hmong Hmng Palmyrene Palm Pau_Cin_Hau Pauc Phags_Pa Phag Phoenician Phnx Psalter_Pahlavi Phlp Rejang Rjng Runic Runr Samaritan Samr Saurashtra Saur Sharada Shrd Shavian Shaw Siddham Sidd SignWriting Sgnw Sinhala Sinh Sora_Sompeng Sora Soyombo Soyo Sundanese Sund Syloti_Nagri Sylo Syriac Syrc Tagalog Tglg Tagbanwa Tagb Tai_Le Tale Tai_Tham Lana Tai_Viet Tavt Takri Takr Tamil Taml Tangut Tang Telugu Telu Thaana Thaa Thai Thai Tibetan Tibt Tifinagh Tfng Tirhuta Tirh Ugaritic Ugar Vai Vaii Warang_Citi Wara Yi Yiii Zanabazar_Square Zanb";
    ecma10ScriptValues = ecma9ScriptValues + " Dogra Dogr Gunjala_Gondi Gong Hanifi_Rohingya Rohg Makasar Maka Medefaidrin Medf Old_Sogdian Sogo Sogdian Sogd";
    ecma11ScriptValues = ecma10ScriptValues + " Elymaic Elym Nandinagari Nand Nyiakeng_Puachue_Hmong Hmnp Wancho Wcho";
    ecma12ScriptValues = ecma11ScriptValues + " Chorasmian Chrs Diak Dives_Akuru Khitan_Small_Script Kits Yezi Yezidi";
    unicodeScriptValues = {
      9: ecma9ScriptValues,
      10: ecma10ScriptValues,
      11: ecma11ScriptValues,
      12: ecma12ScriptValues
    };
    data = {};
    buildUnicodeData(9);
    buildUnicodeData(10);
    buildUnicodeData(11);
    buildUnicodeData(12);
    pp$8 = Parser.prototype;
    RegExpValidationState = function RegExpValidationState2(parser) {
      this.parser = parser;
      this.validFlags = "gim" + (parser.options.ecmaVersion >= 6 ? "uy" : "") + (parser.options.ecmaVersion >= 9 ? "s" : "") + (parser.options.ecmaVersion >= 13 ? "d" : "");
      this.unicodeProperties = data[parser.options.ecmaVersion >= 12 ? 12 : parser.options.ecmaVersion];
      this.source = "";
      this.flags = "";
      this.start = 0;
      this.switchU = false;
      this.switchN = false;
      this.pos = 0;
      this.lastIntValue = 0;
      this.lastStringValue = "";
      this.lastAssertionIsQuantifiable = false;
      this.numCapturingParens = 0;
      this.maxBackReference = 0;
      this.groupNames = [];
      this.backReferenceNames = [];
    };
    RegExpValidationState.prototype.reset = function reset(start, pattern, flags) {
      var unicode = flags.indexOf("u") !== -1;
      this.start = start | 0;
      this.source = pattern + "";
      this.flags = flags;
      this.switchU = unicode && this.parser.options.ecmaVersion >= 6;
      this.switchN = unicode && this.parser.options.ecmaVersion >= 9;
    };
    RegExpValidationState.prototype.raise = function raise(message) {
      this.parser.raiseRecoverable(this.start, "Invalid regular expression: /" + this.source + "/: " + message);
    };
    RegExpValidationState.prototype.at = function at(i, forceU) {
      if (forceU === void 0) forceU = false;
      var s = this.source;
      var l = s.length;
      if (i >= l) {
        return -1;
      }
      var c = s.charCodeAt(i);
      if (!(forceU || this.switchU) || c <= 55295 || c >= 57344 || i + 1 >= l) {
        return c;
      }
      var next = s.charCodeAt(i + 1);
      return next >= 56320 && next <= 57343 ? (c << 10) + next - 56613888 : c;
    };
    RegExpValidationState.prototype.nextIndex = function nextIndex(i, forceU) {
      if (forceU === void 0) forceU = false;
      var s = this.source;
      var l = s.length;
      if (i >= l) {
        return l;
      }
      var c = s.charCodeAt(i), next;
      if (!(forceU || this.switchU) || c <= 55295 || c >= 57344 || i + 1 >= l || (next = s.charCodeAt(i + 1)) < 56320 || next > 57343) {
        return i + 1;
      }
      return i + 2;
    };
    RegExpValidationState.prototype.current = function current(forceU) {
      if (forceU === void 0) forceU = false;
      return this.at(this.pos, forceU);
    };
    RegExpValidationState.prototype.lookahead = function lookahead(forceU) {
      if (forceU === void 0) forceU = false;
      return this.at(this.nextIndex(this.pos, forceU), forceU);
    };
    RegExpValidationState.prototype.advance = function advance2(forceU) {
      if (forceU === void 0) forceU = false;
      this.pos = this.nextIndex(this.pos, forceU);
    };
    RegExpValidationState.prototype.eat = function eat(ch, forceU) {
      if (forceU === void 0) forceU = false;
      if (this.current(forceU) === ch) {
        this.advance(forceU);
        return true;
      }
      return false;
    };
    pp$8.validateRegExpFlags = function(state) {
      var validFlags = state.validFlags;
      var flags = state.flags;
      for (var i = 0; i < flags.length; i++) {
        var flag = flags.charAt(i);
        if (validFlags.indexOf(flag) === -1) {
          this.raise(state.start, "Invalid regular expression flag");
        }
        if (flags.indexOf(flag, i + 1) > -1) {
          this.raise(state.start, "Duplicate regular expression flag");
        }
      }
    };
    pp$8.validateRegExpPattern = function(state) {
      this.regexp_pattern(state);
      if (!state.switchN && this.options.ecmaVersion >= 9 && state.groupNames.length > 0) {
        state.switchN = true;
        this.regexp_pattern(state);
      }
    };
    pp$8.regexp_pattern = function(state) {
      state.pos = 0;
      state.lastIntValue = 0;
      state.lastStringValue = "";
      state.lastAssertionIsQuantifiable = false;
      state.numCapturingParens = 0;
      state.maxBackReference = 0;
      state.groupNames.length = 0;
      state.backReferenceNames.length = 0;
      this.regexp_disjunction(state);
      if (state.pos !== state.source.length) {
        if (state.eat(
          41
          /* ) */
        )) {
          state.raise("Unmatched ')'");
        }
        if (state.eat(
          93
          /* ] */
        ) || state.eat(
          125
          /* } */
        )) {
          state.raise("Lone quantifier brackets");
        }
      }
      if (state.maxBackReference > state.numCapturingParens) {
        state.raise("Invalid escape");
      }
      for (var i = 0, list = state.backReferenceNames; i < list.length; i += 1) {
        var name = list[i];
        if (state.groupNames.indexOf(name) === -1) {
          state.raise("Invalid named capture referenced");
        }
      }
    };
    pp$8.regexp_disjunction = function(state) {
      this.regexp_alternative(state);
      while (state.eat(
        124
        /* | */
      )) {
        this.regexp_alternative(state);
      }
      if (this.regexp_eatQuantifier(state, true)) {
        state.raise("Nothing to repeat");
      }
      if (state.eat(
        123
        /* { */
      )) {
        state.raise("Lone quantifier brackets");
      }
    };
    pp$8.regexp_alternative = function(state) {
      while (state.pos < state.source.length && this.regexp_eatTerm(state)) {
      }
    };
    pp$8.regexp_eatTerm = function(state) {
      if (this.regexp_eatAssertion(state)) {
        if (state.lastAssertionIsQuantifiable && this.regexp_eatQuantifier(state)) {
          if (state.switchU) {
            state.raise("Invalid quantifier");
          }
        }
        return true;
      }
      if (state.switchU ? this.regexp_eatAtom(state) : this.regexp_eatExtendedAtom(state)) {
        this.regexp_eatQuantifier(state);
        return true;
      }
      return false;
    };
    pp$8.regexp_eatAssertion = function(state) {
      var start = state.pos;
      state.lastAssertionIsQuantifiable = false;
      if (state.eat(
        94
        /* ^ */
      ) || state.eat(
        36
        /* $ */
      )) {
        return true;
      }
      if (state.eat(
        92
        /* \ */
      )) {
        if (state.eat(
          66
          /* B */
        ) || state.eat(
          98
          /* b */
        )) {
          return true;
        }
        state.pos = start;
      }
      if (state.eat(
        40
        /* ( */
      ) && state.eat(
        63
        /* ? */
      )) {
        var lookbehind = false;
        if (this.options.ecmaVersion >= 9) {
          lookbehind = state.eat(
            60
            /* < */
          );
        }
        if (state.eat(
          61
          /* = */
        ) || state.eat(
          33
          /* ! */
        )) {
          this.regexp_disjunction(state);
          if (!state.eat(
            41
            /* ) */
          )) {
            state.raise("Unterminated group");
          }
          state.lastAssertionIsQuantifiable = !lookbehind;
          return true;
        }
      }
      state.pos = start;
      return false;
    };
    pp$8.regexp_eatQuantifier = function(state, noError) {
      if (noError === void 0) noError = false;
      if (this.regexp_eatQuantifierPrefix(state, noError)) {
        state.eat(
          63
          /* ? */
        );
        return true;
      }
      return false;
    };
    pp$8.regexp_eatQuantifierPrefix = function(state, noError) {
      return state.eat(
        42
        /* * */
      ) || state.eat(
        43
        /* + */
      ) || state.eat(
        63
        /* ? */
      ) || this.regexp_eatBracedQuantifier(state, noError);
    };
    pp$8.regexp_eatBracedQuantifier = function(state, noError) {
      var start = state.pos;
      if (state.eat(
        123
        /* { */
      )) {
        var min = 0, max = -1;
        if (this.regexp_eatDecimalDigits(state)) {
          min = state.lastIntValue;
          if (state.eat(
            44
            /* , */
          ) && this.regexp_eatDecimalDigits(state)) {
            max = state.lastIntValue;
          }
          if (state.eat(
            125
            /* } */
          )) {
            if (max !== -1 && max < min && !noError) {
              state.raise("numbers out of order in {} quantifier");
            }
            return true;
          }
        }
        if (state.switchU && !noError) {
          state.raise("Incomplete quantifier");
        }
        state.pos = start;
      }
      return false;
    };
    pp$8.regexp_eatAtom = function(state) {
      return this.regexp_eatPatternCharacters(state) || state.eat(
        46
        /* . */
      ) || this.regexp_eatReverseSolidusAtomEscape(state) || this.regexp_eatCharacterClass(state) || this.regexp_eatUncapturingGroup(state) || this.regexp_eatCapturingGroup(state);
    };
    pp$8.regexp_eatReverseSolidusAtomEscape = function(state) {
      var start = state.pos;
      if (state.eat(
        92
        /* \ */
      )) {
        if (this.regexp_eatAtomEscape(state)) {
          return true;
        }
        state.pos = start;
      }
      return false;
    };
    pp$8.regexp_eatUncapturingGroup = function(state) {
      var start = state.pos;
      if (state.eat(
        40
        /* ( */
      )) {
        if (state.eat(
          63
          /* ? */
        ) && state.eat(
          58
          /* : */
        )) {
          this.regexp_disjunction(state);
          if (state.eat(
            41
            /* ) */
          )) {
            return true;
          }
          state.raise("Unterminated group");
        }
        state.pos = start;
      }
      return false;
    };
    pp$8.regexp_eatCapturingGroup = function(state) {
      if (state.eat(
        40
        /* ( */
      )) {
        if (this.options.ecmaVersion >= 9) {
          this.regexp_groupSpecifier(state);
        } else if (state.current() === 63) {
          state.raise("Invalid group");
        }
        this.regexp_disjunction(state);
        if (state.eat(
          41
          /* ) */
        )) {
          state.numCapturingParens += 1;
          return true;
        }
        state.raise("Unterminated group");
      }
      return false;
    };
    pp$8.regexp_eatExtendedAtom = function(state) {
      return state.eat(
        46
        /* . */
      ) || this.regexp_eatReverseSolidusAtomEscape(state) || this.regexp_eatCharacterClass(state) || this.regexp_eatUncapturingGroup(state) || this.regexp_eatCapturingGroup(state) || this.regexp_eatInvalidBracedQuantifier(state) || this.regexp_eatExtendedPatternCharacter(state);
    };
    pp$8.regexp_eatInvalidBracedQuantifier = function(state) {
      if (this.regexp_eatBracedQuantifier(state, true)) {
        state.raise("Nothing to repeat");
      }
      return false;
    };
    pp$8.regexp_eatSyntaxCharacter = function(state) {
      var ch = state.current();
      if (isSyntaxCharacter(ch)) {
        state.lastIntValue = ch;
        state.advance();
        return true;
      }
      return false;
    };
    pp$8.regexp_eatPatternCharacters = function(state) {
      var start = state.pos;
      var ch = 0;
      while ((ch = state.current()) !== -1 && !isSyntaxCharacter(ch)) {
        state.advance();
      }
      return state.pos !== start;
    };
    pp$8.regexp_eatExtendedPatternCharacter = function(state) {
      var ch = state.current();
      if (ch !== -1 && ch !== 36 && !(ch >= 40 && ch <= 43) && ch !== 46 && ch !== 63 && ch !== 91 && ch !== 94 && ch !== 124) {
        state.advance();
        return true;
      }
      return false;
    };
    pp$8.regexp_groupSpecifier = function(state) {
      if (state.eat(
        63
        /* ? */
      )) {
        if (this.regexp_eatGroupName(state)) {
          if (state.groupNames.indexOf(state.lastStringValue) !== -1) {
            state.raise("Duplicate capture group name");
          }
          state.groupNames.push(state.lastStringValue);
          return;
        }
        state.raise("Invalid group");
      }
    };
    pp$8.regexp_eatGroupName = function(state) {
      state.lastStringValue = "";
      if (state.eat(
        60
        /* < */
      )) {
        if (this.regexp_eatRegExpIdentifierName(state) && state.eat(
          62
          /* > */
        )) {
          return true;
        }
        state.raise("Invalid capture group name");
      }
      return false;
    };
    pp$8.regexp_eatRegExpIdentifierName = function(state) {
      state.lastStringValue = "";
      if (this.regexp_eatRegExpIdentifierStart(state)) {
        state.lastStringValue += codePointToString(state.lastIntValue);
        while (this.regexp_eatRegExpIdentifierPart(state)) {
          state.lastStringValue += codePointToString(state.lastIntValue);
        }
        return true;
      }
      return false;
    };
    pp$8.regexp_eatRegExpIdentifierStart = function(state) {
      var start = state.pos;
      var forceU = this.options.ecmaVersion >= 11;
      var ch = state.current(forceU);
      state.advance(forceU);
      if (ch === 92 && this.regexp_eatRegExpUnicodeEscapeSequence(state, forceU)) {
        ch = state.lastIntValue;
      }
      if (isRegExpIdentifierStart(ch)) {
        state.lastIntValue = ch;
        return true;
      }
      state.pos = start;
      return false;
    };
    pp$8.regexp_eatRegExpIdentifierPart = function(state) {
      var start = state.pos;
      var forceU = this.options.ecmaVersion >= 11;
      var ch = state.current(forceU);
      state.advance(forceU);
      if (ch === 92 && this.regexp_eatRegExpUnicodeEscapeSequence(state, forceU)) {
        ch = state.lastIntValue;
      }
      if (isRegExpIdentifierPart(ch)) {
        state.lastIntValue = ch;
        return true;
      }
      state.pos = start;
      return false;
    };
    pp$8.regexp_eatAtomEscape = function(state) {
      if (this.regexp_eatBackReference(state) || this.regexp_eatCharacterClass