import { defineComponent, ref, getCurrentInstance, inject, h, withDirectives, computed, provide, shallowRef, watch, onUnmounted, Teleport, onMounted } from 'vue';
import { defineCustomElement } from '@ionic/core/components/ion-accordion.js';
import { defineCustomElement as defineCustomElement$1 } from '@ionic/core/components/ion-accordion-group.js';
import { defineCustomElement as defineCustomElement$2 } from '@ionic/core/components/ion-avatar.js';
import { defineCustomElement as defineCustomElement$3 } from '@ionic/core/components/ion-backdrop.js';
import { defineCustomElement as defineCustomElement$4 } from '@ionic/core/components/ion-badge.js';
import { defineCustomElement as defineCustomElement$5 } from '@ionic/core/components/ion-breadcrumb.js';
import { defineCustomElement as defineCustomElement$6 } from '@ionic/core/components/ion-breadcrumbs.js';
import { defineCustomElement as defineCustomElement$7 } from '@ionic/core/components/ion-button.js';
import { defineCustomElement as defineCustomElement$8 } from '@ionic/core/components/ion-buttons.js';
import { defineCustomElement as defineCustomElement$9 } from '@ionic/core/components/ion-card.js';
import { defineCustomElement as defineCustomElement$a } from '@ionic/core/components/ion-card-content.js';
import { defineCustomElement as defineCustomElement$b } from '@ionic/core/components/ion-card-header.js';
import { defineCustomElement as defineCustomElement$c } from '@ionic/core/components/ion-card-subtitle.js';
import { defineCustomElement as defineCustomElement$d } from '@ionic/core/components/ion-card-title.js';
import { defineCustomElement as defineCustomElement$e } from '@ionic/core/components/ion-checkbox.js';
import { defineCustomElement as defineCustomElement$f } from '@ionic/core/components/ion-chip.js';
import { defineCustomElement as defineCustomElement$g } from '@ionic/core/components/ion-col.js';
import { defineCustomElement as defineCustomElement$h } from '@ionic/core/components/ion-content.js';
import { defineCustomElement as defineCustomElement$i } from '@ionic/core/components/ion-datetime.js';
import { defineCustomElement as defineCustomElement$j } from '@ionic/core/components/ion-datetime-button.js';
import { defineCustomElement as defineCustomElement$k } from '@ionic/core/components/ion-fab.js';
import { defineCustomElement as defineCustomElement$l } from '@ionic/core/components/ion-fab-button.js';
import { defineCustomElement as defineCustomElement$m } from '@ionic/core/components/ion-fab-list.js';
import { defineCustomElement as defineCustomElement$n } from '@ionic/core/components/ion-footer.js';
import { defineCustomElement as defineCustomElement$o } from '@ionic/core/components/ion-grid.js';
import { defineCustomElement as defineCustomElement$p } from '@ionic/core/components/ion-header.js';
import { defineCustomElement as defineCustomElement$q } from '@ionic/core/components/ion-img.js';
import { defineCustomElement as defineCustomElement$r } from '@ionic/core/components/ion-infinite-scroll.js';
import { defineCustomElement as defineCustomElement$s } from '@ionic/core/components/ion-infinite-scroll-content.js';
import { defineCustomElement as defineCustomElement$t } from '@ionic/core/components/ion-input.js';
import { defineCustomElement as defineCustomElement$u } from '@ionic/core/components/ion-input-password-toggle.js';
import { defineCustomElement as defineCustomElement$v } from '@ionic/core/components/ion-item.js';
import { defineCustomElement as defineCustomElement$w } from '@ionic/core/components/ion-item-divider.js';
import { defineCustomElement as defineCustomElement$x } from '@ionic/core/components/ion-item-group.js';
import { defineCustomElement as defineCustomElement$y } from '@ionic/core/components/ion-item-option.js';
import { defineCustomElement as defineCustomElement$z } from '@ionic/core/components/ion-item-options.js';
import { defineCustomElement as defineCustomElement$A } from '@ionic/core/components/ion-item-sliding.js';
import { defineCustomElement as defineCustomElement$B } from '@ionic/core/components/ion-label.js';
import { defineCustomElement as defineCustomElement$C } from '@ionic/core/components/ion-list.js';
import { defineCustomElement as defineCustomElement$D } from '@ionic/core/components/ion-list-header.js';
import { defineCustomElement as defineCustomElement$E } from '@ionic/core/components/ion-menu.js';
import { defineCustomElement as defineCustomElement$F } from '@ionic/core/components/ion-menu-button.js';
import { defineCustomElement as defineCustomElement$G } from '@ionic/core/components/ion-menu-toggle.js';
import { defineCustomElement as defineCustomElement$1d } from '@ionic/core/components/ion-nav.js';
import { defineCustomElement as defineCustomElement$H } from '@ionic/core/components/ion-nav-link.js';
import { defineCustomElement as defineCustomElement$I } from '@ionic/core/components/ion-note.js';
import { defineCustomElement as defineCustomElement$J } from '@ionic/core/components/ion-picker.js';
import { defineCustomElement as defineCustomElement$K } from '@ionic/core/components/ion-picker-column.js';
import { defineCustomElement as defineCustomElement$L } from '@ionic/core/components/ion-picker-column-option.js';
import { defineCustomElement as defineCustomElement$M } from '@ionic/core/components/ion-progress-bar.js';
import { defineCustomElement as defineCustomElement$N } from '@ionic/core/components/ion-radio.js';
import { defineCustomElement as defineCustomElement$O } from '@ionic/core/components/ion-radio-group.js';
import { defineCustomElement as defineCustomElement$P } from '@ionic/core/components/ion-range.js';
import { defineCustomElement as defineCustomElement$Q } from '@ionic/core/components/ion-refresher.js';
import { defineCustomElement as defineCustomElement$R } from '@ionic/core/components/ion-refresher-content.js';
import { defineCustomElement as defineCustomElement$S } from '@ionic/core/components/ion-reorder.js';
import { defineCustomElement as defineCustomElement$T } from '@ionic/core/components/ion-reorder-group.js';
import { defineCustomElement as defineCustomElement$U } from '@ionic/core/components/ion-ripple-effect.js';
import { defineCustomElement as defineCustomElement$V } from '@ionic/core/components/ion-row.js';
import { defineCustomElement as defineCustomElement$W } from '@ionic/core/components/ion-searchbar.js';
import { defineCustomElement as defineCustomElement$X } from '@ionic/core/components/ion-segment.js';
import { defineCustomElement as defineCustomElement$Y } from '@ionic/core/components/ion-segment-button.js';
import { defineCustomElement as defineCustomElement$Z } from '@ionic/core/components/ion-select.js';
import { defineCustomElement as defineCustomElement$_ } from '@ionic/core/components/ion-select-option.js';
import { defineCustomElement as defineCustomElement$$ } from '@ionic/core/components/ion-skeleton-text.js';
import { defineCustomElement as defineCustomElement$10 } from '@ionic/core/components/ion-spinner.js';
import { defineCustomElement as defineCustomElement$11 } from '@ionic/core/components/ion-split-pane.js';
import { defineCustomElement as defineCustomElement$12 } from '@ionic/core/components/ion-text.js';
import { defineCustomElement as defineCustomElement$13 } from '@ionic/core/components/ion-textarea.js';
import { defineCustomElement as defineCustomElement$14 } from '@ionic/core/components/ion-thumbnail.js';
import { defineCustomElement as defineCustomElement$15 } from '@ionic/core/components/ion-title.js';
import { defineCustomElement as defineCustomElement$16 } from '@ionic/core/components/ion-toggle.js';
import { defineCustomElement as defineCustomElement$17 } from '@ionic/core/components/ion-toolbar.js';
import { LIFECYCLE_WILL_ENTER, LIFECYCLE_DID_ENTER, LIFECYCLE_WILL_LEAVE, LIFECYCLE_DID_LEAVE, initialize, modalController as modalController$1, popoverController as popoverController$1, alertController as alertController$1, actionSheetController as actionSheetController$1, loadingController as loadingController$1, pickerController as pickerController$1, toastController as toastController$1 } from '@ionic/core/components';
export { IonicSafeString, IonicSlides, createAnimation, createGesture, getIonPageElement, getPlatforms, getTimeGivenProgression, iosTransitionAnimation, isPlatform, mdTransitionAnimation, menuController, openURL } from '@ionic/core/components';
import { defineCustomElement as defineCustomElement$18 } from '@ionic/core/components/ion-back-button.js';
import { defineCustomElement as defineCustomElement$19 } from '@ionic/core/components/ion-router-outlet.js';
import { routeLocationKey, useRoute, matchedRouteKey } from 'vue-router';
import { defineCustomElement as defineCustomElement$1a } from '@ionic/core/components/ion-tab-button.js';
import { defineCustomElement as defineCustomElement$1b } from '@ionic/core/components/ion-tab-bar.js';
import { defineCustomElement as defineCustomElement$1c } from '@ionic/core/components/ion-app.js';
import { defineCustomElement as defineCustomElement$1e } from 'ionicons/components/ion-icon.js';
import { defineCustomElement as defineCustomElement$1f } from '@ionic/core/components/ion-action-sheet.js';
import { defineCustomElement as defineCustomElement$1g } from '@ionic/core/components/ion-alert.js';
import { defineCustomElement as defineCustomElement$1h } from '@ionic/core/components/ion-loading.js';
import { defineCustomElement as defineCustomElement$1i } from '@ionic/core/components/ion-picker-legacy.js';
import { defineCustomElement as defineCustomElement$1j } from '@ionic/core/components/ion-toast.js';
import { defineCustomElement as defineCustomElement$1k } from '@ionic/core/components/ion-modal.js';
import { defineCustomElement as defineCustomElement$1l } from '@ionic/core/components/ion-popover.js';

// @ts-nocheck
// It's easier and safer for Volar to disable typechecking and let the return type inference do its job.
const UPDATE_VALUE_EVENT = 'update:modelValue';
const MODEL_VALUE = 'modelValue';
const ROUTER_LINK_VALUE = 'routerLink';
const NAV_MANAGER = 'navManager';
const ROUTER_PROP_PREFIX = 'router';
const ARIA_PROP_PREFIX = 'aria';
/**
 * Starting in Vue 3.1.0, all properties are
 * added as keys to the props object, even if
 * they are not being used. In order to correctly
 * account for both value props and v-model props,
 * we need to check if the key exists for Vue <3.1.0
 * and then check if it is not undefined for Vue >= 3.1.0.
 * See https://github.com/vuejs/vue-next/issues/3889
 */
const EMPTY_PROP$1 = Symbol();
const DEFAULT_EMPTY_PROP$1 = { default: EMPTY_PROP$1 };
const getComponentClasses = (classes) => {
    return (classes === null || classes === void 0 ? void 0 : classes.split(' ')) || [];
};
const getElementClasses = (ref, componentClasses, defaultClasses = []) => {
    var _a;
    return [...Array.from(((_a = ref.value) === null || _a === void 0 ? void 0 : _a.classList) || []), ...defaultClasses].filter((c, i, self) => !componentClasses.has(c) && self.indexOf(c) === i);
};
/**
 * Create a callback to define a Vue component wrapper around a Web Component.
 *
 * @prop name - The component tag name (i.e. `ion-button`)
 * @prop componentProps - An array of properties on the
 * component. These usually match up with the @Prop definitions
 * in each component's TSX file.
 * @prop customElement - An option custom element instance to pass
 * to customElements.define. Only set if `includeImportCustomElements: true` in your config.
 * @prop modelProp - The prop that v-model binds to (i.e. value)
 * @prop modelUpdateEvent - The event that is fired from your Web Component when the value changes (i.e. ionChange)
 */
const defineContainer = (name, defineCustomElement, componentProps = [], modelProp, modelUpdateEvent) => {
    /**
     * Create a Vue component wrapper around a Web Component.
     * Note: The `props` here are not all properties on a component.
     * They refer to whatever properties are set on an instance of a component.
     */
    if (defineCustomElement !== undefined) {
        defineCustomElement();
    }
    const Container = defineComponent((props, { attrs, slots, emit }) => {
        var _a;
        let modelPropValue = props[modelProp];
        const containerRef = ref();
        const classes = new Set(getComponentClasses(attrs.class));
        /**
         * This directive is responsible for updating any reactive
         * reference associated with v-model on the component.
         * This code must be run inside of the "created" callback.
         * Since the following listener callbacks as well as any potential
         * event callback defined in the developer's app are set on
         * the same element, we need to make sure the following callbacks
         * are set first so they fire first. If the developer's callback fires first
         * then the reactive reference will not have been updated yet.
         */
        const vModelDirective = {
            created: (el) => {
                const eventsNames = Array.isArray(modelUpdateEvent) ? modelUpdateEvent : [modelUpdateEvent];
                eventsNames.forEach((eventName) => {
                    el.addEventListener(eventName.toLowerCase(), (e) => {
                        modelPropValue = (e === null || e === void 0 ? void 0 : e.target)[modelProp];
                        emit(UPDATE_VALUE_EVENT, modelPropValue);
                    });
                });
            },
        };
        const currentInstance = getCurrentInstance();
        const hasRouter = (_a = currentInstance === null || currentInstance === void 0 ? void 0 : currentInstance.appContext) === null || _a === void 0 ? void 0 : _a.provides[NAV_MANAGER];
        const navManager = hasRouter ? inject(NAV_MANAGER) : undefined;
        const handleRouterLink = (ev) => {
            const { routerLink } = props;
            if (routerLink === EMPTY_PROP$1)
                return;
            if (navManager !== undefined) {
                let navigationPayload = { event: ev };
                for (const key in props) {
                    const value = props[key];
                    if (props.hasOwnProperty(key) && key.startsWith(ROUTER_PROP_PREFIX) && value !== EMPTY_PROP$1) {
                        navigationPayload[key] = value;
                    }
                }
                navManager.navigate(navigationPayload);
            }
            else {
                console.warn('Tried to navigate, but no router was found. Make sure you have mounted Vue Router.');
            }
        };
        return () => {
            modelPropValue = props[modelProp];
            getComponentClasses(attrs.class).forEach((value) => {
                classes.add(value);
            });
            const oldClick = props.onClick;
            const handleClick = (ev) => {
                if (oldClick !== undefined) {
                    oldClick(ev);
                }
                if (!ev.defaultPrevented) {
                    handleRouterLink(ev);
                }
            };
            let propsToAdd = {
                ref: containerRef,
                class: getElementClasses(containerRef, classes),
                onClick: handleClick,
            };
            /**
             * We can use Object.entries here
             * to avoid the hasOwnProperty check,
             * but that would require 2 iterations
             * where as this only requires 1.
             */
            for (const key in props) {
                const value = props[key];
                if ((props.hasOwnProperty(key) && value !== EMPTY_PROP$1) || key.startsWith(ARIA_PROP_PREFIX)) {
                    propsToAdd[key] = value;
                }
            }
            if (modelProp) {
                /**
                 * If form value property was set using v-model
                 * then we should use that value.
                 * Otherwise, check to see if form value property
                 * was set as a static value (i.e. no v-model).
                 */
                if (props[MODEL_VALUE] !== EMPTY_PROP$1) {
                    propsToAdd = Object.assign(Object.assign({}, propsToAdd), { [modelProp]: props[MODEL_VALUE] });
                }
                else if (modelPropValue !== EMPTY_PROP$1) {
                    propsToAdd = Object.assign(Object.assign({}, propsToAdd), { [modelProp]: modelPropValue });
                }
            }
            /**
             * vModelDirective is only needed on components that support v-model.
             * As a result, we conditionally call withDirectives with v-model components.
             */
            const node = h(name, propsToAdd, slots.default && slots.default());
            return modelProp === undefined ? node : withDirectives(node, [[vModelDirective]]);
        };
    });
    if (typeof Container !== 'function') {
        Container.name = name;
        Container.props = {
            [ROUTER_LINK_VALUE]: DEFAULT_EMPTY_PROP$1,
        };
        componentProps.forEach((componentProp) => {
            Container.props[componentProp] = DEFAULT_EMPTY_PROP$1;
        });
        if (modelProp) {
            Container.props[MODEL_VALUE] = DEFAULT_EMPTY_PROP$1;
            Container.emits = [UPDATE_VALUE_EVENT];
        }
    }
    return Container;
};

/* eslint-disable */
/* tslint:disable */
/* auto-generated vue proxies */
const IonAccordion = /*@__PURE__*/ defineContainer('ion-accordion', defineCustomElement, [
    'value',
    'disabled',
    'readonly',
    'toggleIcon',
    'toggleIconSlot'
]);
const IonAccordionGroup = /*@__PURE__*/ defineContainer('ion-accordion-group', defineCustomElement$1, [
    'animated',
    'multiple',
    'value',
    'disabled',
    'readonly',
    'expand',
    'ionChange',
    'ionValueChange'
], 'value', 'ion-change');
const IonAvatar = /*@__PURE__*/ defineContainer('ion-avatar', defineCustomElement$2);
const IonBackdrop = /*@__PURE__*/ defineContainer('ion-backdrop', defineCustomElement$3, [
    'visible',
    'tappable',
    'stopPropagation',
    'ionBackdropTap'
]);
const IonBadge = /*@__PURE__*/ defineContainer('ion-badge', defineCustomElement$4, [
    'color'
]);
const IonBreadcrumb = /*@__PURE__*/ defineContainer('ion-breadcrumb', defineCustomElement$5, [
    'collapsed',
    'last',
    'showCollapsedIndicator',
    'color',
    'active',
    'disabled',
    'download',
    'href',
    'rel',
    'separator',
    'target',
    'routerDirection',
    'routerAnimation',
    'ionFocus',
    'ionBlur',
    'collapsedClick'
]);
const IonBreadcrumbs = /*@__PURE__*/ defineContainer('ion-breadcrumbs', defineCustomElement$6, [
    'color',
    'maxItems',
    'itemsBeforeCollapse',
    'itemsAfterCollapse',
    'ionCollapsedClick'
]);
const IonButton = /*@__PURE__*/ defineContainer('ion-button', defineCustomElement$7, [
    'color',
    'buttonType',
    'disabled',
    'expand',
    'fill',
    'routerDirection',
    'routerAnimation',
    'download',
    'href',
    'rel',
    'shape',
    'size',
    'strong',
    'target',
    'type',
    'form',
    'ionFocus',
    'ionBlur'
]);
const IonButtons = /*@__PURE__*/ defineContainer('ion-buttons', defineCustomElement$8, [
    'collapse'
]);
const IonCard = /*@__PURE__*/ defineContainer('ion-card', defineCustomElement$9, [
    'color',
    'button',
    'type',
    'disabled',
    'download',
    'href',
    'rel',
    'routerDirection',
    'routerAnimation',
    'target'
]);
const IonCardContent = /*@__PURE__*/ defineContainer('ion-card-content', defineCustomElement$a);
const IonCardHeader = /*@__PURE__*/ defineContainer('ion-card-header', defineCustomElement$b, [
    'color',
    'translucent'
]);
const IonCardSubtitle = /*@__PURE__*/ defineContainer('ion-card-subtitle', defineCustomElement$c, [
    'color'
]);
const IonCardTitle = /*@__PURE__*/ defineContainer('ion-card-title', defineCustomElement$d, [
    'color'
]);
const IonCheckbox = /*@__PURE__*/ defineContainer('ion-checkbox', defineCustomElement$e, [
    'color',
    'name',
    'checked',
    'indeterminate',
    'disabled',
    'value',
    'labelPlacement',
    'justify',
    'alignment',
    'ionChange',
    'ionFocus',
    'ionBlur'
], 'checked', 'ion-change');
const IonChip = /*@__PURE__*/ defineContainer('ion-chip', defineCustomElement$f, [
    'color',
    'outline',
    'disabled'
]);
const IonCol = /*@__PURE__*/ defineContainer('ion-col', defineCustomElement$g, [
    'offset',
    'offsetXs',
    'offsetSm',
    'offsetMd',
    'offsetLg',
    'offsetXl',
    'pull',
    'pullXs',
    'pullSm',
    'pullMd',
    'pullLg',
    'pullXl',
    'push',
    'pushXs',
    'pushSm',
    'pushMd',
    'pushLg',
    'pushXl',
    'size',
    'sizeXs',
    'sizeSm',
    'sizeMd',
    'sizeLg',
    'sizeXl'
]);
const IonContent = /*@__PURE__*/ defineContainer('ion-content', defineCustomElement$h, [
    'color',
    'fullscreen',
    'fixedSlotPlacement',
    'forceOverscroll',
    'scrollX',
    'scrollY',
    'scrollEvents',
    'ionScrollStart',
    'ionScroll',
    'ionScrollEnd'
]);
const IonDatetime = /*@__PURE__*/ defineContainer('ion-datetime', defineCustomElement$i, [
    'color',
    'name',
    'disabled',
    'formatOptions',
    'readonly',
    'isDateEnabled',
    'min',
    'max',
    'presentation',
    'cancelText',
    'doneText',
    'clearText',
    'yearValues',
    'monthValues',
    'dayValues',
    'hourValues',
    'minuteValues',
    'locale',
    'firstDayOfWeek',
    'titleSelectedDatesFormatter',
    'multiple',
    'highlightedDates',
    'value',
    'showDefaultTitle',
    'showDefaultButtons',
    'showClearButton',
    'showDefaultTimeLabel',
    'hourCycle',
    'size',
    'preferWheel',
    'ionCancel',
    'ionChange',
    'ionValueChange',
    'ionFocus',
    'ionBlur',
    'ionStyle',
    'ionRender'
], 'value', 'ion-change');
const IonDatetimeButton = /*@__PURE__*/ defineContainer('ion-datetime-button', defineCustomElement$j, [
    'color',
    'disabled',
    'datetime'
]);
const IonFab = /*@__PURE__*/ defineContainer('ion-fab', defineCustomElement$k, [
    'horizontal',
    'vertical',
    'edge',
    'activated'
]);
const IonFabButton = /*@__PURE__*/ defineContainer('ion-fab-button', defineCustomElement$l, [
    'color',
    'activated',
    'disabled',
    'download',
    'href',
    'rel',
    'routerDirection',
    'routerAnimation',
    'target',
    'show',
    'translucent',
    'type',
    'size',
    'closeIcon',
    'ionFocus',
    'ionBlur'
]);
const IonFabList = /*@__PURE__*/ defineContainer('ion-fab-list', defineCustomElement$m, [
    'activated',
    'side'
]);
const IonFooter = /*@__PURE__*/ defineContainer('ion-footer', defineCustomElement$n, [
    'collapse',
    'translucent'
]);
const IonGrid = /*@__PURE__*/ defineContainer('ion-grid', defineCustomElement$o, [
    'fixed'
]);
const IonHeader = /*@__PURE__*/ defineContainer('ion-header', defineCustomElement$p, [
    'collapse',
    'translucent'
]);
const IonImg = /*@__PURE__*/ defineContainer('ion-img', defineCustomElement$q, [
    'alt',
    'src',
    'ionImgWillLoad',
    'ionImgDidLoad',
    'ionError'
]);
const IonInfiniteScroll = /*@__PURE__*/ defineContainer('ion-infinite-scroll', defineCustomElement$r, [
    'threshold',
    'disabled',
    'position',
    'ionInfinite'
]);
const IonInfiniteScrollContent = /*@__PURE__*/ defineContainer('ion-infinite-scroll-content', defineCustomElement$s, [
    'loadingSpinner',
    'loadingText'
]);
const IonInput = /*@__PURE__*/ defineContainer('ion-input', defineCustomElement$t, [
    'color',
    'autocapitalize',
    'autocomplete',
    'autocorrect',
    'autofocus',
    'clearInput',
    'clearInputIcon',
    'clearOnEdit',
    'counter',
    'counterFormatter',
    'debounce',
    'disabled',
    'enterkeyhint',
    'errorText',
    'fill',
    'inputmode',
    'helperText',
    'label',
    'labelPlacement',
    'max',
    'maxlength',
    'min',
    'minlength',
    'multiple',
    'name',
    'pattern',
    'placeholder',
    'readonly',
    'required',
    'shape',
    'spellcheck',
    'step',
    'type',
    'value',
    'ionInput',
    'ionChange',
    'ionBlur',
    'ionFocus'
], 'value', 'ion-input');
const IonInputPasswordToggle = /*@__PURE__*/ defineContainer('ion-input-password-toggle', defineCustomElement$u, [
    'color',
    'showIcon',
    'hideIcon',
    'type'
]);
const IonItem = /*@__PURE__*/ defineContainer('ion-item', defineCustomElement$v, [
    'color',
    'button',
    'detail',
    'detailIcon',
    'disabled',
    'download',
    'href',
    'rel',
    'lines',
    'routerAnimation',
    'routerDirection',
    'target',
    'type'
]);
const IonItemDivider = /*@__PURE__*/ defineContainer('ion-item-divider', defineCustomElement$w, [
    'color',
    'sticky'
]);
const IonItemGroup = /*@__PURE__*/ defineContainer('ion-item-group', defineCustomElement$x);
const IonItemOption = /*@__PURE__*/ defineContainer('ion-item-option', defineCustomElement$y, [
    'color',
    'disabled',
    'download',
    'expandable',
    'href',
    'rel',
    'target',
    'type'
]);
const IonItemOptions = /*@__PURE__*/ defineContainer('ion-item-options', defineCustomElement$z, [
    'side',
    'ionSwipe'
]);
const IonItemSliding = /*@__PURE__*/ defineContainer('ion-item-sliding', defineCustomElement$A, [
    'disabled',
    'ionDrag'
]);
const IonLabel = /*@__PURE__*/ defineContainer('ion-label', defineCustomElement$B, [
    'color',
    'position',
    'ionColor',
    'ionStyle'
]);
const IonList = /*@__PURE__*/ defineContainer('ion-list', defineCustomElement$C, [
    'lines',
    'inset'
]);
const IonListHeader = /*@__PURE__*/ defineContainer('ion-list-header', defineCustomElement$D, [
    'color',
    'lines'
]);
const IonMenu = /*@__PURE__*/ defineContainer('ion-menu', defineCustomElement$E, [
    'contentId',
    'menuId',
    'type',
    'disabled',
    'side',
    'swipeGesture',
    'maxEdgeStart',
    'ionWillOpen',
    'ionWillClose',
    'ionDidOpen',
    'ionDidClose',
    'ionMenuChange'
]);
const IonMenuButton = /*@__PURE__*/ defineContainer('ion-menu-button', defineCustomElement$F, [
    'color',
    'disabled',
    'menu',
    'autoHide',
    'type'
]);
const IonMenuToggle = /*@__PURE__*/ defineContainer('ion-menu-toggle', defineCustomElement$G, [
    'menu',
    'autoHide'
]);
const IonNavLink = /*@__PURE__*/ defineContainer('ion-nav-link', defineCustomElement$H, [
    'component',
    'componentProps',
    'routerDirection',
    'routerAnimation'
]);
const IonNote = /*@__PURE__*/ defineContainer('ion-note', defineCustomElement$I, [
    'color'
]);
const IonPicker = /*@__PURE__*/ defineContainer('ion-picker', defineCustomElement$J, [
    'ionInputModeChange'
]);
const IonPickerColumn = /*@__PURE__*/ defineContainer('ion-picker-column', defineCustomElement$K, [
    'disabled',
    'value',
    'color',
    'numericInput',
    'ionChange'
]);
const IonPickerColumnOption = /*@__PURE__*/ defineContainer('ion-picker-column-option', defineCustomElement$L, [
    'disabled',
    'value',
    'color'
]);
const IonProgressBar = /*@__PURE__*/ defineContainer('ion-progress-bar', defineCustomElement$M, [
    'type',
    'reversed',
    'value',
    'buffer',
    'color'
]);
const IonRadio = /*@__PURE__*/ defineContainer('ion-radio', defineCustomElement$N, [
    'color',
    'name',
    'disabled',
    'value',
    'labelPlacement',
    'justify',
    'alignment',
    'ionFocus',
    'ionBlur'
], 'value', 'ion-change');
const IonRadioGroup = /*@__PURE__*/ defineContainer('ion-radio-group', defineCustomElement$O, [
    'allowEmptySelection',
    'compareWith',
    'name',
    'value',
    'ionChange',
    'ionValueChange'
], 'value', 'ion-change');
const IonRange = /*@__PURE__*/ defineContainer('ion-range', defineCustomElement$P, [
    'color',
    'debounce',
    'name',
    'label',
    'dualKnobs',
    'min',
    'max',
    'pin',
    'pinFormatter',
    'snaps',
    'step',
    'ticks',
    'activeBarStart',
    'disabled',
    'value',
    'labelPlacement',
    'ionChange',
    'ionInput',
    'ionFocus',
    'ionBlur',
    'ionKnobMoveStart',
    'ionKnobMoveEnd'
], 'value', 'ion-input');
const IonRefresher = /*@__PURE__*/ defineContainer('ion-refresher', defineCustomElement$Q, [
    'pullMin',
    'pullMax',
    'closeDuration',
    'snapbackDuration',
    'pullFactor',
    'disabled',
    'ionRefresh',
    'ionPull',
    'ionStart'
]);
const IonRefresherContent = /*@__PURE__*/ defineContainer('ion-refresher-content', defineCustomElement$R, [
    'pullingIcon',
    'pullingText',
    'refreshingSpinner',
    'refreshingText'
]);
const IonReorder = /*@__PURE__*/ defineContainer('ion-reorder', defineCustomElement$S);
const IonReorderGroup = /*@__PURE__*/ defineContainer('ion-reorder-group', defineCustomElement$T, [
    'disabled',
    'ionItemReorder'
]);
const IonRippleEffect = /*@__PURE__*/ defineContainer('ion-ripple-effect', defineCustomElement$U, [
    'type'
]);
const IonRow = /*@__PURE__*/ defineContainer('ion-row', defineCustomElement$V);
const IonSearchbar = /*@__PURE__*/ defineContainer('ion-searchbar', defineCustomElement$W, [
    'color',
    'animated',
    'autocapitalize',
    'autocomplete',
    'autocorrect',
    'cancelButtonIcon',
    'cancelButtonText',
    'clearIcon',
    'debounce',
    'disabled',
    'inputmode',
    'enterkeyhint',
    'maxlength',
    'minlength',
    'name',
    'placeholder',
    'searchIcon',
    'showCancelButton',
    'showClearButton',
    'spellcheck',
    'type',
    'value',
    'ionInput',
    'ionChange',
    'ionCancel',
    'ionClear',
    'ionBlur',
    'ionFocus',
    'ionStyle'
], 'value', 'ion-input');
const IonSegment = /*@__PURE__*/ defineContainer('ion-segment', defineCustomElement$X, [
    'color',
    'disabled',
    'scrollable',
    'swipeGesture',
    'value',
    'selectOnFocus',
    'ionChange',
    'ionSelect',
    'ionStyle'
], 'value', 'ion-change');
const IonSegmentButton = /*@__PURE__*/ defineContainer('ion-segment-button', defineCustomElement$Y, [
    'disabled',
    'layout',
    'type',
    'value'
], 'value', 'ion-change');
const IonSelect = /*@__PURE__*/ defineContainer('ion-select', defineCustomElement$Z, [
    'cancelText',
    'color',
    'compareWith',
    'disabled',
    'fill',
    'interface',
    'interfaceOptions',
    'justify',
    'label',
    'labelPlacement',
    'multiple',
    'name',
    'okText',
    'placeholder',
    'selectedText',
    'toggleIcon',
    'expandedIcon',
    'shape',
    'value',
    'ionChange',
    'ionCancel',
    'ionDismiss',
    'ionFocus',
    'ionBlur',
    'ionStyle'
], 'value', 'ion-change');
const IonSelectOption = /*@__PURE__*/ defineContainer('ion-select-option', defineCustomElement$_, [
    'disabled',
    'value'
]);
const IonSkeletonText = /*@__PURE__*/ defineContainer('ion-skeleton-text', defineCustomElement$$, [
    'animated',
    'ionStyle'
]);
const IonSpinner = /*@__PURE__*/ defineContainer('ion-spinner', defineCustomElement$10, [
    'color',
    'duration',
    'name',
    'paused'
]);
const IonSplitPane = /*@__PURE__*/ defineContainer('ion-split-pane', defineCustomElement$11, [
    'contentId',
    'disabled',
    'when',
    'ionSplitPaneVisible'
]);
const IonText = /*@__PURE__*/ defineContainer('ion-text', defineCustomElement$12, [
    'color'
]);
const IonTextarea = /*@__PURE__*/ defineContainer('ion-textarea', defineCustomElement$13, [
    'color',
    'autocapitalize',
    'autofocus',
    'clearOnEdit',
    'debounce',
    'disabled',
    'fill',
    'inputmode',
    'enterkeyhint',
    'maxlength',
    'minlength',
    'name',
    'placeholder',
    'readonly',
    'required',
    'spellcheck',
    'cols',
    'rows',
    'wrap',
    'autoGrow',
    'value',
    'counter',
    'counterFormatter',
    'errorText',
    'helperText',
    'label',
    'labelPlacement',
    'shape',
    'ionChange',
    'ionInput',
    'ionBlur',
    'ionFocus'
], 'value', 'ion-input');
const IonThumbnail = /*@__PURE__*/ defineContainer('ion-thumbnail', defineCustomElement$14);
const IonTitle = /*@__PURE__*/ defineContainer('ion-title', defineCustomElement$15, [
    'color',
    'size',
    'ionStyle'
]);
const IonToggle = /*@__PURE__*/ defineContainer('ion-toggle', defineCustomElement$16, [
    'color',
    'name',
    'checked',
    'disabled',
    'value',
    'enableOnOffLabels',
    'labelPlacement',
    'justify',
    'alignment',
    'ionChange',
    'ionFocus',
    'ionBlur'
], 'checked', 'ion-change');
const IonToolbar = /*@__PURE__*/ defineContainer('ion-toolbar', defineCustomElement$17, [
    'color'
]);

const useBackButton = (priority, handler) => {
    const callback = (ev) => ev.detail.register(priority, handler);
    const unregister = () => document.removeEventListener("ionBackButton", callback);
    document.addEventListener("ionBackButton", callback);
    return { unregister };
};

const useKeyboard = () => {
    const isOpen = ref(false);
    const keyboardHeight = ref(0);
    const showCallback = (ev) => {
        isOpen.value = true;
        keyboardHeight.value = ev.detail.keyboardHeight;
    };
    const hideCallback = () => {
        isOpen.value = false;
        keyboardHeight.value = 0;
    };
    const unregister = () => {
        if (typeof window !== "undefined") {
            window.removeEventListener("ionKeyboardDidShow", showCallback);
            window.removeEventListener("ionKeyboardDidHide", hideCallback);
        }
    };
    if (typeof window !== "undefined") {
        window.addEventListener("ionKeyboardDidShow", showCallback);
        window.addEventListener("ionKeyboardDidHide", hideCallback);
    }
    return {
        isOpen,
        keyboardHeight,
        unregister,
    };
};

// TODO(FW-2969): types
var LifecycleHooks;
(function (LifecycleHooks) {
    LifecycleHooks["WillEnter"] = "onIonViewWillEnter";
    LifecycleHooks["DidEnter"] = "onIonViewDidEnter";
    LifecycleHooks["WillLeave"] = "onIonViewWillLeave";
    LifecycleHooks["DidLeave"] = "onIonViewDidLeave";
})(LifecycleHooks || (LifecycleHooks = {}));
const hookNames = {
    [LIFECYCLE_WILL_ENTER]: LifecycleHooks.WillEnter,
    [LIFECYCLE_DID_ENTER]: LifecycleHooks.DidEnter,
    [LIFECYCLE_WILL_LEAVE]: LifecycleHooks.WillLeave,
    [LIFECYCLE_DID_LEAVE]: LifecycleHooks.DidLeave,
};
const ids = { main: 0 };
const generateId = (type = "main") => {
    var _a;
    const id = ((_a = ids[type]) !== null && _a !== void 0 ? _a : 0) + 1;
    ids[type] = id;
    return id.toString();
};
const fireLifecycle = (vueComponent, vueInstance, lifecycle) => {
    if (vueComponent === null || vueComponent === void 0 ? void 0 : vueComponent[lifecycle]) {
        vueComponent[lifecycle].bind(vueInstance === null || vueInstance === void 0 ? void 0 : vueInstance.value)();
    }
    const instance = vueInstance === null || vueInstance === void 0 ? void 0 : vueInstance.value;
    if (instance === null || instance === void 0 ? void 0 : instance[lifecycle]) {
        instance[lifecycle]();
    }
    /**
     * Fire any Composition API
     * Ionic Lifecycle hooks
     */
    if (instance) {
        const hook = hookNames[lifecycle];
        const hooks = instance[hook];
        if (hooks) {
            hooks.forEach((hook) => hook());
        }
    }
};
const getConfig = () => {
    if (typeof window !== "undefined") {
        const Ionic = window.Ionic;
        if (Ionic && Ionic.config) {
            return Ionic.config;
        }
    }
    return null;
};

/**
 * Creates an returns a function that
 * can be used to provide a lifecycle hook.
 */
const injectHook = (lifecycleType, hook, component) => {
    if (component) {
        // Add to public instance so it is accessible to IonRouterOutlet
        const target = component;
        const hooks = target.proxy[lifecycleType] || (target.proxy[lifecycleType] = []);
        /**
         * Define property on public instances using `setup` syntax in Vue 3.x
         */
        if (target.exposed) {
            target.exposed[lifecycleType] = hooks;
        }
        const wrappedHook = (...args) => {
            if (target.isUnmounted) {
                return;
            }
            return args ? hook(...args) : hook();
        };
        hooks.push(wrappedHook);
        return wrappedHook;
    }
    else {
        console.warn("[@ionic/vue]: Ionic Lifecycle Hooks can only be used during execution of setup().");
    }
};
const createHook = (lifecycle) => {
    return (hook, target = getCurrentInstance()) => injectHook(lifecycle, hook, target);
};
const onIonViewWillEnter = createHook(LifecycleHooks.WillEnter);
const onIonViewDidEnter = createHook(LifecycleHooks.DidEnter);
const onIonViewWillLeave = createHook(LifecycleHooks.WillLeave);
const onIonViewDidLeave = createHook(LifecycleHooks.DidLeave);

/**
 * Used to navigate within Vue Router
 * while controlling the animation.
 */
const useIonRouter = () => {
    const { canGoBack, goBack, goForward, handleNavigate } = inject("navManager");
    const navigate = (location, routerDirection, routerAction, routerAnimation) => handleNavigate(location, routerAction, routerDirection, routerAnimation);
    const push = (location, routerAnimation) => navigate(location, "forward", "push", routerAnimation);
    const replace = (location, routerAnimation) => navigate(location, "root", "replace", routerAnimation);
    const back = (routerAnimation) => goBack(routerAnimation);
    const forward = (routerAnimation) => goForward(routerAnimation);
    return {
        canGoBack,
        push,
        replace,
        back,
        forward,
        navigate,
    };
};

// TODO(FW-2969): types
const toKebabCase = (eventName) => {
    return eventName
        .replace(/([a-z0-9]|(?=[A-Z]))([A-Z])/g, "$1-$2")
        .toLowerCase();
};
const getHelperFunctions = () => {
    return {
        ael: (el, eventName, cb, opts) => el.addEventListener(toKebabCase(eventName), cb, opts),
        rel: (el, eventName, cb, opts) => el.removeEventListener(toKebabCase(eventName), cb, opts),
        ce: (eventName, opts) => new CustomEvent(toKebabCase(eventName), opts),
    };
};
const IonicVue = {
    async install(_, config = {}) {
        /**
         * By default Ionic Framework hides elements that
         * are not hydrated, but in the CE build there is no
         * hydration.
         * TODO FW-2797: Remove when all integrations have been
         * migrated to CE build.
         */
        if (typeof document !== "undefined") {
            document.documentElement.classList.add("ion-ce");
        }
        const { ael, rel, ce } = getHelperFunctions();
        initialize(Object.assign(Object.assign({}, config), { _ael: ael, _rel: rel, _ce: ce }));
    },
};

const IonBackButton = /*@__PURE__*/ defineComponent((_, { attrs, slots }) => {
    defineCustomElement$18();
    // TODO(FW-2969): type
    const ionRouter = inject("navManager");
    const onClick = () => {
        /**
         * When using ion-back-button outside of
         * a routing context, ionRouter is undefined.
         */
        if (ionRouter === undefined) {
            return;
        }
        const defaultHref = attrs["default-href"] || attrs["defaultHref"];
        const routerAnimation = attrs["router-animation"] || attrs["routerAnimation"];
        ionRouter.handleNavigateBack(defaultHref, routerAnimation);
    };
    return () => {
        return h("ion-back-button", Object.assign({ onClick }, attrs), slots.default && slots.default());
    };
});
IonBackButton.name = "IonBackButton";

const IonPage = /*@__PURE__*/ defineComponent({
    name: "IonPage",
    props: {
        // eslint-disable-next-line @typescript-eslint/no-empty-function
        registerIonPage: { type: Function, default: () => { } },
    },
    mounted() {
        this.$props.registerIonPage(this.$refs.ionPage);
    },
    setup(_, { attrs, slots }) {
        return () => {
            return h("div", Object.assign(Object.assign({}, attrs), { ["class"]: "ion-page", ref: "ionPage" }), slots.default && slots.default());
        };
    },
});

// TODO(FW-2969): types
const isViewVisible = (enteringEl) => {
    return (!enteringEl.classList.contains("ion-page-hidden") &&
        !enteringEl.classList.contains("ion-page-invisible"));
};
const viewDepthKey = Symbol(0);
const IonRouterOutlet = /*@__PURE__*/ defineComponent({
    name: "IonRouterOutlet",
    setup() {
        defineCustomElement$19();
        const injectedRoute = inject(routeLocationKey);
        const route = useRoute();
        const depth = inject(viewDepthKey, 0);
        const matchedRouteRef = computed(() => route.matched[depth]);
        let previousMatchedRouteRef;
        let previousMatchedPath;
        provide(viewDepthKey, depth + 1);
        provide(matchedRouteKey, matchedRouteRef);
        const ionRouterOutlet = ref();
        const id = generateId("ion-router-outlet");
        const ionRouter = inject("navManager");
        const viewStacks = inject("viewStacks");
        const components = shallowRef([]);
        let skipTransition = false;
        // The base url for this router outlet
        let parentOutletPath;
        /**
         * Note: Do not listen for matchedRouteRef by itself here
         * as the callback will not fire for parameterized routes (i.e. /page/:id).
         * So going from /page/1 to /page/2 would not fire this callback if we
         * only listened for changes to matchedRouteRef.
         */
        watch(() => [route, matchedRouteRef.value], ([currentRoute, currentMatchedRouteRef]) => {
            /**
             * This callback checks whether or not a router outlet
             * needs to respond to a change in the matched route.
             * It handles a few cases:
             * 1. The matched route is undefined. This means that
             * the matched route is not applicable to this outlet.
             * For example, a /settings route is not applicable
             * to a /tabs/... route.
             *
             * Note: When going back to a tabs outlet from a non-tabs outlet,
             * the tabs outlet should NOT attempt a page transition from the
             * previous tab to the active tab. To do this we compare the current
             * route with the previous route. Unfortunately, we cannot rely on the
             * previous value provided by Vue in the watch callback. This is because
             * when coming back to the tabs context, the previous matched route will
             * be undefined (because nothing in the tabs context matches /settings)
             * but the current matched route will be defined and so a transition
             * will always occur.
             *
             * 2. The matched route is defined and is different than
             * the previously matched route. This is the most
             * common case such as when you go from /page1 to /page2.
             *
             * 3. The matched route is the same but the parameters are different.
             * This is a special case for parameterized routes (i.e. /page/:id).
             * When going from /page/1 to /page/2, the matched route object will
             * be the same, but we still need to perform a page transition. To do this
             * we check if the parameters are different (i.e. 1 vs 2). To avoid enumerating
             * all of the keys in the params object, we check the url path to
             * see if they are different after ensuring we are in a parameterized route.
             */
            if (currentMatchedRouteRef !== undefined) {
                const matchedDifferentRoutes = currentMatchedRouteRef !== previousMatchedRouteRef;
                const matchedDifferentParameterRoutes = currentRoute.matched[currentRoute.matched.length - 1] ===
                    currentMatchedRouteRef &&
                    currentRoute.path !== previousMatchedPath;
                if (matchedDifferentRoutes || matchedDifferentParameterRoutes) {
                    setupViewItem(matchedRouteRef);
                }
            }
            previousMatchedRouteRef = currentMatchedRouteRef;
            previousMatchedPath = currentRoute.path;
        }, 
        /**
         * Future versions of Vue may default watching nested
         * reactive objects to "deep: false".
         * We explicitly set this watcher to "deep: true" to
         * account for that.
         * https://github.com/vuejs/core/issues/9965#issuecomment-1875067499
         */
        { deep: true });
        const canStart = () => {
            const config = getConfig();
            const swipeEnabled = config &&
                config.get("swipeBackEnabled", ionRouterOutlet.value.mode === "ios");
            if (!swipeEnabled)
                return false;
            const stack = viewStacks.getViewStack(id);
            if (!stack || stack.length <= 1)
                return false;
            /**
             * We only want to outlet of the entering view
             * to respond to this gesture, so check
             * to make sure the view is in the outlet we want.
             */
            const routeInfo = ionRouter.getLeavingRouteInfo();
            const enteringViewItem = viewStacks.findViewItemByRouteInfo({ pathname: routeInfo.pushedByRoute || "" }, id);
            return !!enteringViewItem;
        };
        const onStart = async () => {
            const routeInfo = ionRouter.getLeavingRouteInfo();
            const { routerAnimation } = routeInfo;
            const enteringViewItem = viewStacks.findViewItemByRouteInfo({ pathname: routeInfo.pushedByRoute || "" }, id);
            const leavingViewItem = viewStacks.findViewItemByRouteInfo(routeInfo, id);
            if (leavingViewItem) {
                let animationBuilder = routerAnimation;
                const enteringEl = enteringViewItem.ionPageElement;
                const leavingEl = leavingViewItem.ionPageElement;
                /**
                 * If we are going back from a page that
                 * was presented using a custom animation
                 * we should default to using that
                 * unless the developer explicitly
                 * provided another animation.
                 */
                const customAnimation = enteringViewItem.routerAnimation;
                if (animationBuilder === undefined && customAnimation !== undefined) {
                    animationBuilder = customAnimation;
                }
                leavingViewItem.routerAnimation = animationBuilder;
                await transition(enteringEl, leavingEl, "back", ionRouter.canGoBack(2), true, animationBuilder);
            }
            return Promise.resolve();
        };
        const onEnd = (shouldContinue) => {
            if (shouldContinue) {
                skipTransition = true;
                /**
                 * Use the same logic as clicking
                 * ion-back-button to determine where
                 * to go back to.
                 */
                ionRouter.handleNavigateBack();
            }
            else {
                /**
                 * In the event that the swipe
                 * gesture was aborted, we should
                 * re-hide the page that was going to enter.
                 */
                const routeInfo = ionRouter.getCurrentRouteInfo();
                const enteringViewItem = viewStacks.findViewItemByRouteInfo({ pathname: routeInfo.pushedByRoute || "" }, id);
                enteringViewItem.ionPageElement.setAttribute("aria-hidden", "true");
                enteringViewItem.ionPageElement.classList.add("ion-page-hidden");
            }
        };
        watch(ionRouterOutlet, () => {
            ionRouterOutlet.value.swipeHandler = {
                canStart,
                onStart,
                onEnd,
            };
        });
        const transition = async (enteringEl, leavingEl, direction, showGoBack, progressAnimation, animationBuilder) => {
            if (skipTransition) {
                skipTransition = false;
                return Promise.resolve(false);
            }
            if (enteringEl === leavingEl) {
                return Promise.resolve(false);
            }
            enteringEl.classList.add("ion-page-invisible");
            const hasRootDirection = direction === undefined || direction === "root" || direction === "none";
            const result = await ionRouterOutlet.value.commit(enteringEl, leavingEl, {
                /**
                 * replace operations result in a direction of none.
                 * These typically do not have need animations, so we set
                 * the duration to 0. However, if a developer explicitly
                 * passes an animationBuilder, we should assume that
                 * they want an animation to be played even
                 * though it is a replace operation.
                 */
                duration: hasRootDirection && animationBuilder === undefined ? 0 : undefined,
                direction,
                showGoBack,
                progressAnimation,
                animationBuilder,
            });
            return result;
        };
        const handlePageTransition = async () => {
            const routeInfo = ionRouter.getCurrentRouteInfo();
            const { routerDirection, routerAction, routerAnimation, prevRouteLastPathname, delta, } = routeInfo;
            const enteringViewItem = viewStacks.findViewItemByRouteInfo(routeInfo, id);
            let leavingViewItem = viewStacks.findLeavingViewItemByRouteInfo(routeInfo, id);
            const enteringEl = enteringViewItem.ionPageElement;
            /**
             * All views that can be transitioned to must have
             * an `<ion-page>` element for transitions and lifecycle
             * methods to work properly.
             */
            if (enteringEl === undefined) {
                console.warn(`[@ionic/vue Warning]: The view you are trying to render for path ${routeInfo.pathname} does not have the required <ion-page> component. Transitions and lifecycle methods may not work as expected.

See https://ionicframework.com/docs/vue/navigation#ionpage for more information.`);
            }
            if (enteringViewItem === leavingViewItem)
                return;
            if (!leavingViewItem && prevRouteLastPathname) {
                leavingViewItem = viewStacks.findViewItemByPathname(prevRouteLastPathname, id);
            }
            /**
             * If the entering view is already
             * visible, then no transition is needed.
             * This is most common when navigating
             * from a tabs page to a non-tabs page
             * and then back to the tabs page.
             * Even when the tabs context navigated away,
             * the inner tabs page was still active.
             * This also avoids an issue where
             * the previous tabs page is incorrectly
             * unmounted since it would automatically
             * unmount the previous view.
             *
             * This should also only apply to entering and
             * leaving items in the same router outlet (i.e.
             * Tab1 and Tab2), otherwise this will
             * return early for swipe to go back when
             * going from a non-tabs page to a tabs page.
             */
            if (isViewVisible(enteringEl) &&
                (leavingViewItem === null || leavingViewItem === void 0 ? void 0 : leavingViewItem.ionPageElement) !== undefined &&
                !isViewVisible(leavingViewItem.ionPageElement)) {
                return;
            }
            fireLifecycle(enteringViewItem.vueComponent, enteringViewItem.vueComponentRef, LIFECYCLE_WILL_ENTER);
            if ((leavingViewItem === null || leavingViewItem === void 0 ? void 0 : leavingViewItem.ionPageElement) &&
                enteringViewItem !== leavingViewItem) {
                let animationBuilder = routerAnimation;
                const leavingEl = leavingViewItem.ionPageElement;
                fireLifecycle(leavingViewItem.vueComponent, leavingViewItem.vueComponentRef, LIFECYCLE_WILL_LEAVE);
                /**
                 * If we are going back from a page that
                 * was presented using a custom animation
                 * we should default to using that
                 * unless the developer explicitly
                 * provided another animation.
                 */
                const customAnimation = enteringViewItem.routerAnimation;
                if (animationBuilder === undefined &&
                    routerDirection === "back" &&
                    customAnimation !== undefined) {
                    animationBuilder = customAnimation;
                }
                leavingViewItem.routerAnimation = animationBuilder;
                await transition(enteringEl, leavingEl, routerDirection, !!routeInfo.pushedByRoute, false, animationBuilder);
                leavingEl.classList.add("ion-page-hidden");
                leavingEl.setAttribute("aria-hidden", "true");
                const usingLinearNavigation = viewStacks.size() === 1;
                if (routerAction === "replace") {
                    leavingViewItem.mount = false;
                    leavingViewItem.ionPageElement = undefined;
                    leavingViewItem.ionRoute = false;
                }
                else if (!(routerAction === "push" && routerDirection === "forward")) {
                    const shouldLeavingViewBeRemoved = routerDirection !== "none" &&
                        leavingViewItem &&
                        enteringViewItem !== leavingViewItem;
                    if (shouldLeavingViewBeRemoved) {
                        leavingViewItem.mount = false;
                        leavingViewItem.ionPageElement = undefined;
                        leavingViewItem.ionRoute = false;
                        /**
                         * router.go() expects navigation to be
                         * linear. If an app is using multiple stacks then
                         * it is not using linear navigation. As a result, router.go()
                         * will not give the results that developers are expecting.
                         */
                        if (usingLinearNavigation) {
                            viewStacks.unmountLeavingViews(id, enteringViewItem, delta);
                        }
                    }
                }
                else if (usingLinearNavigation) {
                    viewStacks.mountIntermediaryViews(id, leavingViewItem, delta);
                }
                fireLifecycle(leavingViewItem.vueComponent, leavingViewItem.vueComponentRef, LIFECYCLE_DID_LEAVE);
            }
            else {
                /**
                 * If there is no leaving element, just show
                 * the entering element. Wrap it in an raf
                 * in case ion-content's fullscreen callback
                 * is running. Otherwise we'd have a flicker.
                 */
                requestAnimationFrame(() => enteringEl.classList.remove("ion-page-invisible"));
            }
            fireLifecycle(enteringViewItem.vueComponent, enteringViewItem.vueComponentRef, LIFECYCLE_DID_ENTER);
            components.value = viewStacks.getChildrenToRender(id);
        };
        const setupViewItem = (matchedRouteRef) => {
            const firstMatchedRoute = route.matched[0];
            if (!parentOutletPath) {
                parentOutletPath = firstMatchedRoute.path;
            }
            /**
             * If no matched route, do not do anything in this outlet.
             * If there is a match, but it the first matched path
             * is not the root path for this outlet, then this view
             * change needs to be rendered in a different outlet.
             * We also add an exception for when the matchedRouteRef is
             * equal to the first matched route (i.e. the base router outlet).
             * This logic is mainly to help nested outlets/multi-tab
             * setups work better.
             */
            if (!matchedRouteRef.value ||
                (matchedRouteRef.value !== firstMatchedRoute &&
                    firstMatchedRoute.path !== parentOutletPath)) {
                return;
            }
            const currentRoute = ionRouter.getCurrentRouteInfo();
            let enteringViewItem = viewStacks.findViewItemByRouteInfo(currentRoute, id);
            if (!enteringViewItem) {
                enteringViewItem = viewStacks.createViewItem(id, matchedRouteRef.value.components.default, matchedRouteRef.value, currentRoute);
                viewStacks.add(enteringViewItem);
            }
            if (!enteringViewItem.mount) {
                enteringViewItem.mount = true;
                enteringViewItem.registerCallback = () => {
                    handlePageTransition();
                    enteringViewItem.registerCallback = undefined;
                };
            }
            else {
                handlePageTransition();
            }
            components.value = viewStacks.getChildrenToRender(id);
        };
        if (matchedRouteRef.value) {
            setupViewItem(matchedRouteRef);
        }
        /**
         * Remove stack data for this outlet
         * when outlet is destroyed otherwise
         * we will see cached view data.
         */
        onUnmounted(() => viewStacks.clear(id));
        const registerIonPage = (viewItem, ionPageEl) => {
            const oldIonPageEl = viewItem.ionPageElement;
            viewStacks.registerIonPage(viewItem, ionPageEl);
            /**
             * If there is a registerCallback,
             * then this component is being registered
             * as a result of a navigation change.
             */
            if (viewItem.registerCallback) {
                /**
                 * Page should be hidden initially
                 * to avoid flickering.
                 */
                ionPageEl.classList.add("ion-page-invisible");
                viewItem.registerCallback();
                /**
                 * If there is no registerCallback, then
                 * this component is likely being re-registered
                 * as a result of a hot module replacement.
                 * We need to see if the oldIonPageEl has
                 * .ion-page-invisible. If it does not then we
                 * need to remove it from the new ionPageEl otherwise
                 * the page will be hidden when it is replaced.
                 */
            }
            else if (oldIonPageEl &&
                !oldIonPageEl.classList.contains("ion-page-invisible")) {
                ionPageEl.classList.remove("ion-page-invisible");
            }
        };
        return {
            id,
            components,
            injectedRoute,
            ionRouterOutlet,
            registerIonPage,
        };
    },
    render() {
        const { components, registerIonPage, injectedRoute } = this;
        return h("ion-router-outlet", { ref: "ionRouterOutlet" }, components &&
            components.map((c) => {
                var _a, _b;
                let props = {
                    ref: c.vueComponentRef,
                    key: c.pathname,
                    registerIonPage: (ionPageEl) => registerIonPage(c, ionPageEl),
                };
                /**
                 * IonRouterOutlet does not support named outlets.
                 */
                const routePropsOption = (_b = (_a = c.matchedRoute) === null || _a === void 0 ? void 0 : _a.props) === null || _b === void 0 ? void 0 : _b.default;
                /**
                 * Since IonRouterOutlet renders multiple components,
                 * each render will cause all props functions to be
                 * called again. As a result, we need to cache the function
                 * result and provide it on each render so that the props
                 * are not lost when navigating from and back to a page.
                 * When a component is destroyed and re-created, the
                 * function is called again.
                 */
                const getPropsFunctionResult = () => {
                    var _a;
                    const cachedPropsResult = (_a = c.vueComponentData) === null || _a === void 0 ? void 0 : _a.propsFunctionResult;
                    if (cachedPropsResult) {
                        return cachedPropsResult;
                    }
                    else {
                        const propsFunctionResult = routePropsOption(injectedRoute);
                        c.vueComponentData = Object.assign(Object.assign({}, c.vueComponentData), { propsFunctionResult });
                        return propsFunctionResult;
                    }
                };
                const routeProps = routePropsOption
                    ? routePropsOption === true
                        ? c.params
                        : typeof routePropsOption === "function"
                            ? getPropsFunctionResult()
                            : routePropsOption
                    : null;
                props = Object.assign(Object.assign({}, props), routeProps);
                return h(c.vueComponent, props);
            }));
    },
});

const IonTabButton = /*@__PURE__*/ defineComponent({
    name: "IonTabButton",
    props: {
        _getTabState: {
            type: Function,
            default: () => {
                return {};
            },
        },
        disabled: Boolean,
        download: String,
        href: String,
        rel: String,
        layout: String,
        selected: Boolean,
        tab: String,
        target: String,
    },
    setup(props, { slots }) {
        defineCustomElement$1a();
        // TODO(FW-2969): type
        const ionRouter = inject("navManager");
        const onClick = (ev) => {
            if (ev.cancelable) {
                ev.preventDefault();
            }
            /**
             * Keeping track of the originalHref
             * (i.e. /tabs/tab1) lets us redirect
             * users back to a child page using currentHref
             * (i.e. /tabs/tab1/child).
             */
            const { tab, href, _getTabState } = props;
            const tabState = _getTabState();
            const tappedTab = tabState.tabs[tab] || {};
            const originalHref = tappedTab.originalHref || href;
            const currentHref = tappedTab.currentHref || href;
            const prevActiveTab = tabState.activeTab;
            /**
             * If we are still on the same
             * tab as before, but the base href
             * does not equal the current href,
             * then we must be on a child page and
             * should direct users back to the root
             * of the tab.
             */
            if (prevActiveTab === tab) {
                if (originalHref !== currentHref) {
                    ionRouter.resetTab(tab);
                }
            }
            else {
                ionRouter.changeTab(tab, currentHref);
            }
        };
        return () => {
            return h("ion-tab-button", Object.assign({ onClick }, props), slots.default && slots.default());
        };
    },
});

const WILL_CHANGE = "ionTabsWillChange";
const DID_CHANGE = "ionTabsDidChange";
// TODO(FW-2969): types
/**
 * Vue 3.2.38 fixed an issue where Web Component
 * names are respected using kebab case instead of pascal case.
 * As a result, we need to account for both here since we support
 * versions of Vue < 3.2.38.
 */
// TODO FW-5904
const isRouterOutlet = (node) => {
    return (node.type &&
        (node.type.name === "IonRouterOutlet" ||
            node.type === "ion-router-outlet"));
};
const isTabBar = (node) => {
    return (node.type &&
        (node.type.name === "IonTabBar" || node.type === "ion-tab-bar"));
};
const IonTabs = /*@__PURE__*/ defineComponent({
    name: "IonTabs",
    emits: [WILL_CHANGE, DID_CHANGE],
    render() {
        var _a;
        const { $slots: slots, $emit } = this;
        const slottedContent = slots.default && slots.default();
        let routerOutlet;
        /**
         * Developers must pass an ion-router-outlet
         * inside of ion-tabs.
         */
        if (slottedContent && slottedContent.length > 0) {
            routerOutlet = slottedContent.find((child) => isRouterOutlet(child));
        }
        if (!routerOutlet) {
            throw new Error("IonTabs must contain an IonRouterOutlet. See https://ionicframework.com/docs/vue/navigation#working-with-tabs for more information.");
        }
        let childrenToRender = [
            h("div", {
                class: "tabs-inner",
                style: {
                    position: "relative",
                    flex: "1",
                    contain: "layout size style",
                },
            }, routerOutlet),
        ];
        /**
         * If ion-tab-bar has slot="top" it needs to be
         * rendered before `.tabs-inner` otherwise it will
         * not show above the tab content.
         */
        if (slottedContent && slottedContent.length > 0) {
            /**
             * Render all content except for router outlet
             * since that needs to be inside of `.tabs-inner`.
             */
            const filteredContent = slottedContent.filter((child) => !child.type || !isRouterOutlet(child));
            const slottedTabBar = filteredContent.find((child) => isTabBar(child));
            const hasTopSlotTabBar = slottedTabBar && ((_a = slottedTabBar.props) === null || _a === void 0 ? void 0 : _a.slot) === "top";
            if (slottedTabBar) {
                if (!slottedTabBar.props) {
                    slottedTabBar.props = {};
                }
                /**
                 * ionTabsWillChange and ionTabsDidChange are
                 * fired from `ion-tabs`, so we need to pass these down
                 * as props so they can fire when the active tab changes.
                 * TODO: We may want to move logic from the tab bar into here
                 * so we do not have code split across two components.
                 */
                slottedTabBar.props._tabsWillChange = (tab) => $emit(WILL_CHANGE, { tab });
                slottedTabBar.props._tabsDidChange = (tab) => $emit(DID_CHANGE, { tab });
            }
            if (hasTopSlotTabBar) {
                childrenToRender = [...filteredContent, ...childrenToRender];
            }
            else {
                childrenToRender = [...childrenToRender, ...filteredContent];
            }
        }
        return h("ion-tabs", {
            style: {
                display: "flex",
                position: "absolute",
                top: "0",
                left: "0",
                right: "0",
                bottom: "0",
                "flex-direction": "column",
                width: "100%",
                height: "100%",
                contain: "layout size style",
                "z-index": "0",
            },
        }, childrenToRender);
    },
});

const isTabButton = (child) => { var _a; return ((_a = child.type) === null || _a === void 0 ? void 0 : _a.name) === "IonTabButton"; };
const getTabs = (nodes) => {
    let tabs = [];
    nodes.forEach((node) => {
        if (isTabButton(node)) {
            tabs.push(node);
        }
        else if (Array.isArray(node.children) && node.children.length > 1) {
            const childTabs = getTabs(node.children);
            tabs = [...tabs, ...childTabs];
        }
    });
    return tabs;
};
const IonTabBar = defineComponent({
    name: "IonTabBar",
    props: {
        /* eslint-disable @typescript-eslint/no-empty-function */
        _tabsWillChange: { type: Function, default: () => { } },
        _tabsDidChange: { type: Function, default: () => { } },
        /* eslint-enable @typescript-eslint/no-empty-function */
    },
    data() {
        return {
            tabState: {
                activeTab: undefined,
                tabs: {},
            },
            tabVnodes: [],
        };
    },
    updated() {
        this.setupTabState(inject("navManager"));
    },
    methods: {
        setupTabState(ionRouter) {
            /**
             * For each tab, we need to keep track of its
             * base href as well as any child page that
             * is active in its stack so that when we go back
             * to a tab from another tab, we can correctly
             * show any child pages if necessary.
             */
            const tabState = this.$data.tabState;
            const currentInstance = getCurrentInstance();
            const tabs = (this.$data.tabVnodes = getTabs((currentInstance.subTree.children || [])));
            tabs.forEach((child) => {
                tabState.tabs[child.props.tab] = {
                    originalHref: child.props.href,
                    currentHref: child.props.href,
                    ref: child,
                };
                /**
                 * Passing this prop to each tab button
                 * lets it be aware of the state that
                 * ion-tab-bar is managing for it.
                 */
                child.component.props._getTabState = () => tabState;
            });
            this.checkActiveTab(ionRouter);
        },
        checkActiveTab(ionRouter) {
            const currentRoute = ionRouter.getCurrentRouteInfo();
            const childNodes = this.$data.tabVnodes;
            const { tabs, activeTab: prevActiveTab } = this.$data.tabState;
            const tabState = this.$data.tabState;
            const tabKeys = Object.keys(tabs);
            const activeTab = tabKeys.find((key) => {
                const href = tabs[key].originalHref;
                return currentRoute.pathname.startsWith(href);
            });
            /**
             * For each tab, check to see if the
             * base href has changed. If so, update
             * it in the tabs state.
             */
            childNodes.forEach((child) => {
                const tab = tabs[child.props.tab];
                if (!tab || tab.originalHref !== child.props.href) {
                    tabs[child.props.tab] = {
                        originalHref: child.props.href,
                        currentHref: child.props.href,
                        ref: child,
                    };
                }
            });
            if (activeTab && prevActiveTab) {
                const prevHref = this.$data.tabState.tabs[prevActiveTab].currentHref;
                /**
                 * If the tabs change or the url changes,
                 * update the currentHref for the active tab.
                 * Ex: url changes from /tabs/tab1 --> /tabs/tab1/child
                 * If we went to tab2 then back to tab1, we should
                 * land on /tabs/tab1/child instead of /tabs/tab1.
                 */
                if (activeTab !== prevActiveTab || prevHref !== currentRoute.pathname) {
                    /**
                     * By default the search is `undefined` in Ionic Vue,
                     * but Vue Router can set the search to the empty string.
                     * We check for truthy here because empty string is falsy
                     * and currentRoute.search cannot ever be a boolean.
                     */
                    const search = currentRoute.search ? `?${currentRoute.search}` : "";
                    tabs[activeTab] = Object.assign(Object.assign({}, tabs[activeTab]), { currentHref: currentRoute.pathname + search });
                }
                /**
                 * If navigating back and the tabs change,
                 * set the previous tab back to its original href.
                 */
                if (currentRoute.routerAction === "pop" &&
                    activeTab !== prevActiveTab) {
                    tabs[prevActiveTab] = Object.assign(Object.assign({}, tabs[prevActiveTab]), { currentHref: tabs[prevActiveTab].originalHref });
                }
            }
            const activeChild = childNodes.find((child) => { var _a; return isTabButton(child) && ((_a = child.props) === null || _a === void 0 ? void 0 : _a.tab) === activeTab; });
            const tabBar = this.$refs.ionTabBar;
            const tabDidChange = activeTab !== prevActiveTab;
            if (tabBar) {
                if (activeChild) {
                    tabDidChange && this.$props._tabsWillChange(activeTab);
                    ionRouter.handleSetCurrentTab(activeTab);
                    tabBar.selectedTab = tabState.activeTab = activeTab;
                    tabDidChange && this.$props._tabsDidChange(activeTab);
                    /**
                     * When going to a tab that does
                     * not have an associated ion-tab-button
                     * we need to remove the selected state from
                     * the old tab.
                     */
                }
                else {
                    tabBar.selectedTab = tabState.activeTab = "";
                }
            }
        },
    },
    mounted() {
        const ionRouter = inject("navManager");
        this.setupTabState(ionRouter);
        ionRouter.registerHistoryChangeListener(() => this.checkActiveTab(ionRouter));
    },
    setup(_, { slots }) {
        defineCustomElement$1b();
        return () => {
            return h("ion-tab-bar", { ref: "ionTabBar" }, slots.default && slots.default());
        };
    },
});

const userComponents = shallowRef([]);
const IonApp = /*@__PURE__*/ defineComponent((_, { attrs, slots }) => {
    defineCustomElement$1c();
    return () => {
        return h("ion-app", Object.assign({}, attrs), [slots.default && slots.default(), ...userComponents.value]);
    };
});
IonApp.name = "IonApp";
/**
 * When rendering user components inside of
 * ion-modal, or ion-popover the component
 * needs to be created inside of the current application
 * context otherwise libraries such as vue-i18n or vuex
 * will not work properly.
 *
 * `userComponents` renders teleported components as children
 * of `ion-app` within the current application context.
 */
const addTeleportedUserComponent = (component) => {
    userComponents.value = [...userComponents.value, component];
};
const removeTeleportedUserComponent = (component) => {
    userComponents.value = userComponents.value.filter((cmp) => cmp !== component);
};

const VueDelegate = (addFn = addTeleportedUserComponent, removeFn = removeTeleportedUserComponent) => {
    // `h` doesn't provide a type for the component argument
    const refMap = new WeakMap();
    // TODO(FW-2969): types
    const attachViewToDom = (parentElement, componentOrTagName, componentProps = {}, classes) => {
        const div = document.createElement("div");
        classes && div.classList.add(...classes);
        parentElement.appendChild(div);
        const hostComponent = h(Teleport, { to: div }, h(componentOrTagName, Object.assign({}, componentProps)));
        /**
         * Ionic Framework will use what is returned from `attachViewToDom`
         * as the `component` argument in `removeViewFromDom`.
         *
         * We will store a reference to the div element and the host component,
         * so we can later look-up and unmount the correct instance.
         */
        refMap.set(div, hostComponent);
        addFn(hostComponent);
        return Promise.resolve(div);
    };
    const removeViewFromDom = (_container, component) => {
        const hostComponent = refMap.get(component);
        hostComponent && removeFn(hostComponent);
        return Promise.resolve();
    };
    return { attachViewToDom, removeViewFromDom };
};

const IonNav = /*@__PURE__*/ defineComponent((props) => {
    defineCustomElement$1d();
    const views = shallowRef([]);
    /**
     * Allows us to create the component
     * within the Vue application context.
     */
    const addView = (component) => (views.value = [...views.value, component]);
    const removeView = (component) => (views.value = views.value.filter((cmp) => cmp !== component));
    const delegate = VueDelegate(addView, removeView);
    return () => {
        return h("ion-nav", Object.assign(Object.assign({}, props), { delegate }), views.value);
    };
});
IonNav.name = "IonNav";
/**
 * The default values follow what is defined at
 * https://ionicframework.com/docs/api/nav#properties
 * otherwise the default values on the Web Component
 * may be overridden. For example, if the default animated value
 * is not `true` below, then Vue would default the prop to `false`
 * which would override the Web Component default of `true`.
 */
IonNav.props = {
    animated: {
        type: Boolean,
        default: true,
    },
    animation: {
        type: Function,
        default: undefined,
    },
    root: {
        type: [Function, Object, String],
        default: undefined,
    },
    rootParams: {
        type: Object,
        default: undefined,
    },
    swipeGesture: {
        type: Boolean,
        default: undefined,
    },
};

const IonIcon = /*@__PURE__*/ defineComponent({
    name: "IonIcon",
    props: {
        color: String,
        flipRtl: Boolean,
        icon: String,
        ios: String,
        lazy: String,
        md: String,
        mode: String,
        name: String,
        size: String,
        src: String,
    },
    setup(props, { slots }) {
        defineCustomElement$1e();
        return () => {
            var _a, _b;
            const { icon, ios, md, mode } = props;
            let iconToUse;
            const config = getConfig();
            const iconMode = mode || (config === null || config === void 0 ? void 0 : config.get("mode"));
            if (ios || md) {
                if (iconMode === "ios") {
                    iconToUse = (_a = ios !== null && ios !== void 0 ? ios : md) !== null && _a !== void 0 ? _a : icon;
                }
                else {
                    iconToUse = (_b = md !== null && md !== void 0 ? md : ios) !== null && _b !== void 0 ? _b : icon;
                }
            }
            else {
                iconToUse = icon;
            }
            return h("ion-icon", Object.assign(Object.assign({}, props), { icon: iconToUse }), slots);
        };
    },
});

const EMPTY_PROP = Symbol();
const DEFAULT_EMPTY_PROP = { default: EMPTY_PROP };
const defineOverlayContainer = (name, defineCustomElement, componentProps = [], hasDelegateHost, controller) => {
    const createControllerComponent = () => {
        return defineComponent((props, { slots, emit }) => {
            const eventListeners = [
                { componentEv: `${name}-will-present`, frameworkEv: 'willPresent' },
                { componentEv: `${name}-did-present`, frameworkEv: 'didPresent' },
                { componentEv: `${name}-will-dismiss`, frameworkEv: 'willDismiss' },
                { componentEv: `${name}-did-dismiss`, frameworkEv: 'didDismiss' },
            ];
            if (defineCustomElement !== undefined) {
                defineCustomElement();
            }
            const overlay = ref();
            const onVnodeMounted = async () => {
                const isOpen = props.isOpen;
                isOpen && (await present(props));
            };
            const onVnodeUpdated = async (node, prevNode) => {
                const isOpen = node.props.isOpen;
                const prevIsOpen = prevNode.props.isOpen;
                /**
                 * Do not do anything if this prop
                 * did not change.
                 */
                if (isOpen === prevIsOpen)
                    return;
                if (isOpen) {
                    await present(props);
                }
                else {
                    await dismiss();
                }
            };
            const onVnodeBeforeUnmount = async () => {
                await dismiss();
            };
            const dismiss = async () => {
                if (!overlay.value)
                    return;
                await overlay.value;
                overlay.value = overlay.value.dismiss();
                await overlay.value;
                overlay.value = undefined;
            };
            const present = async (props) => {
                var _a;
                /**
                 * Do not open another instance
                 * if one is already opened.
                 */
                if (overlay.value) {
                    await overlay.value;
                }
                if ((_a = overlay.value) === null || _a === void 0 ? void 0 : _a.present) {
                    await overlay.value.present();
                    return;
                }
                let restOfProps = {};
                /**
                 * We can use Object.entries here
                 * to avoid the hasOwnProperty check,
                 * but that would require 2 iterations
                 * where as this only requires 1.
                 */
                for (const key in props) {
                    const value = props[key];
                    if (props.hasOwnProperty(key) && value !== EMPTY_PROP) {
                        restOfProps[key] = value;
                    }
                }
                /**
                 * These are getting passed as props.
                 * Potentially a Vue bug with Web Components?
                 */
                delete restOfProps.onWillPresent;
                delete restOfProps.onDidPresent;
                delete restOfProps.onWillDismiss;
                delete restOfProps.onDidDismiss;
                const component = slots.default && slots.default()[0];
                overlay.value = controller.create(Object.assign(Object.assign({}, restOfProps), { component }));
                overlay.value = await overlay.value;
                eventListeners.forEach(eventListener => {
                    overlay.value.addEventListener(eventListener.componentEv, () => {
                        emit(eventListener.frameworkEv);
                    });
                });
                await overlay.value.present();
            };
            return () => {
                return h('div', {
                    style: { display: 'none' },
                    onVnodeMounted,
                    onVnodeUpdated,
                    onVnodeBeforeUnmount,
                    isOpen: props.isOpen === true
                });
            };
        });
    };
    const createInlineComponent = () => {
        return defineComponent((props, { slots }) => {
            if (defineCustomElement !== undefined) {
                defineCustomElement();
            }
            const isOpen = ref(false);
            const elementRef = ref();
            onMounted(() => {
                elementRef.value.addEventListener('ion-mount', () => isOpen.value = true);
                elementRef.value.addEventListener('will-present', () => isOpen.value = true);
                elementRef.value.addEventListener('did-dismiss', () => isOpen.value = false);
            });
            return () => {
                let restOfProps = {};
                /**
                 * We can use Object.entries here
                 * to avoid the hasOwnProperty check,
                 * but that would require 2 iterations
                 * where as this only requires 1.
                 */
                for (const key in props) {
                    const value = props[key];
                    if (props.hasOwnProperty(key) && value !== EMPTY_PROP) {
                        restOfProps[key] = value;
                    }
                }
                /**
                 * Some overlays need a wrapper element so content
                 * takes up the full size of the parent overlay.
                 */
                const renderChildren = () => {
                    if (hasDelegateHost) {
                        return h('div', { className: 'ion-delegate-host ion-page' }, slots);
                    }
                    return slots;
                };
                return h(name, Object.assign(Object.assign({}, restOfProps), { ref: elementRef }), 
                /**
                 * When binding keepContentsMounted as an attribute
                 * i.e. <ion-modal keep-contents-mounted></ion-modal>
                 * the value of the prop will be the empty string which is
                 * why we still call renderChildren() in that case.
                 */
                (isOpen.value || restOfProps.keepContentsMounted || restOfProps.keepContentsMounted === '') ? renderChildren() : undefined);
            };
        });
    };
    const Container = (controller !== undefined) ? createControllerComponent() : createInlineComponent();
    Container.name = name;
    Container.props = {
        'isOpen': DEFAULT_EMPTY_PROP
    };
    componentProps.forEach(componentProp => {
        Container.props[componentProp] = DEFAULT_EMPTY_PROP;
    });
    if (controller !== undefined) {
        Container.emits = ['willPresent', 'didPresent', 'willDismiss', 'didDismiss'];
    }
    return Container;
};

/**
 * This is an autogenerated file created by 'scripts/copy-overlays.js'.
 * Changes made to this file will be overwritten on build.
 */
const IonActionSheet = /*@__PURE__*/ defineOverlayContainer('ion-action-sheet', defineCustomElement$1f, ['animated', 'backdropDismiss', 'buttons', 'cssClass', 'enterAnimation', 'header', 'htmlAttributes', 'isOpen', 'keyboardClose', 'leaveAnimation', 'mode', 'subHeader', 'translucent', 'trigger']);
const IonAlert = /*@__PURE__*/ defineOverlayContainer('ion-alert', defineCustomElement$1g, ['animated', 'backdropDismiss', 'buttons', 'cssClass', 'enterAnimation', 'header', 'htmlAttributes', 'inputs', 'isOpen', 'keyboardClose', 'leaveAnimation', 'message', 'mode', 'subHeader', 'translucent', 'trigger']);
const IonLoading = /*@__PURE__*/ defineOverlayContainer('ion-loading', defineCustomElement$1h, ['animated', 'backdropDismiss', 'cssClass', 'duration', 'enterAnimation', 'htmlAttributes', 'isOpen', 'keyboardClose', 'leaveAnimation', 'message', 'mode', 'showBackdrop', 'spinner', 'translucent', 'trigger']);
const IonPickerLegacy = /*@__PURE__*/ defineOverlayContainer('ion-picker-legacy', defineCustomElement$1i, ['animated', 'backdropDismiss', 'buttons', 'columns', 'cssClass', 'duration', 'enterAnimation', 'htmlAttributes', 'isOpen', 'keyboardClose', 'leaveAnimation', 'mode', 'showBackdrop', 'trigger']);
const IonToast = /*@__PURE__*/ defineOverlayContainer('ion-toast', defineCustomElement$1j, ['animated', 'buttons', 'color', 'cssClass', 'duration', 'enterAnimation', 'header', 'htmlAttributes', 'icon', 'isOpen', 'keyboardClose', 'layout', 'leaveAnimation', 'message', 'mode', 'position', 'positionAnchor', 'swipeGesture', 'translucent', 'trigger']);
const IonModal = /*@__PURE__*/ defineOverlayContainer('ion-modal', defineCustomElement$1k, ['animated', 'backdropBreakpoint', 'backdropDismiss', 'breakpoints', 'canDismiss', 'enterAnimation', 'focusTrap', 'handle', 'handleBehavior', 'htmlAttributes', 'initialBreakpoint', 'isOpen', 'keepContentsMounted', 'keyboardClose', 'leaveAnimation', 'mode', 'presentingElement', 'showBackdrop', 'trigger'], true);
const IonPopover = /*@__PURE__*/ defineOverlayContainer('ion-popover', defineCustomElement$1l, ['alignment', 'animated', 'arrow', 'backdropDismiss', 'component', 'componentProps', 'dismissOnSelect', 'enterAnimation', 'event', 'focusTrap', 'htmlAttributes', 'isOpen', 'keepContentsMounted', 'keyboardClose', 'leaveAnimation', 'mode', 'reference', 'showBackdrop', 'side', 'size', 'translucent', 'trigger', 'triggerAction']);

// TODO(FW-2969): types
/**
 * Wrap the controllers export from @ionic/core
 * register the underlying Web Component and
 * (optionally) provide a framework delegate.
 */
const createController = (defineCustomElement, oldController, useDelegate = false) => {
    const delegate = useDelegate ? VueDelegate() : undefined;
    const oldCreate = oldController.create.bind(oldController);
    oldController.create = (options) => {
        defineCustomElement();
        return oldCreate(Object.assign(Object.assign({}, options), { delegate }));
    };
    return oldController;
};
const modalController = /*@__PURE__*/ createController(defineCustomElement$1k, modalController$1, true);
const popoverController = /*@__PURE__*/ createController(defineCustomElement$1l, popoverController$1, true);
const alertController = /*@__PURE__*/ createController(defineCustomElement$1g, alertController$1);
const actionSheetController = /*@__PURE__*/ createController(defineCustomElement$1f, actionSheetController$1);
const loadingController = /*@__PURE__*/ createController(defineCustomElement$1h, loadingController$1);
/**
 * @deprecated Use the inline ion-picker component instead.
 */
const pickerController = /*@__PURE__*/ createController(defineCustomElement$1i, pickerController$1);
const toastController = /*@__PURE__*/ createController(defineCustomElement$1j, toastController$1);

export { IonAccordion, IonAccordionGroup, IonActionSheet, IonAlert, IonApp, IonAvatar, IonBackButton, IonBackdrop, IonBadge, IonBreadcrumb, IonBreadcrumbs, IonButton, IonButtons, IonCard, IonCardContent, IonCardHeader, IonCardSubtitle, IonCardTitle, IonCheckbox, IonChip, IonCol, IonContent, IonDatetime, IonDatetimeButton, IonFab, IonFabButton, IonFabList, IonFooter, IonGrid, IonHeader, IonIcon, IonImg, IonInfiniteScroll, IonInfiniteScrollContent, IonInput, IonInputPasswordToggle, IonItem, IonItemDivider, IonItemGroup, IonItemOption, IonItemOptions, IonItemSliding, IonLabel, IonList, IonListHeader, IonLoading, IonMenu, IonMenuButton, IonMenuToggle, IonModal, IonNav, IonNavLink, IonNote, IonPage, IonPicker, IonPickerColumn, IonPickerColumnOption, IonPickerLegacy, IonPopover, IonProgressBar, IonRadio, IonRadioGroup, IonRange, IonRefresher, IonRefresherContent, IonReorder, IonReorderGroup, IonRippleEffect, IonRouterOutlet, IonRow, IonSearchbar, IonSegment, IonSegmentButton, IonSelect, IonSelectOption, IonSkeletonText, IonSpinner, IonSplitPane, IonTabBar, IonTabButton, IonTabs, IonText, IonTextarea, IonThumbnail, IonTitle, IonToast, IonToggle, IonToolbar, IonicVue, actionSheetController, alertController, loadingController, modalController, onIonViewDidEnter, onIonViewDidLeave, onIonViewWillEnter, onIonViewWillLeave, pickerController, popoverController, toastController, useBackButton, useIonRouter, useKeyboard };
//# sourceMappingURL=index.js.map
