'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var core = require('@capacitor/core');

const Dialog = core.registerPlugin('Dialog', {
    web: () => Promise.resolve().then(function () { return web; }).then(m => new m.DialogWeb()),
});

class DialogWeb extends core.WebPlugin {
    async alert(options) {
        window.alert(options.message);
    }
    async prompt(options) {
        const val = window.prompt(options.message, options.inputText || '');
        return {
            value: val !== null ? val : '',
            cancelled: val === null,
        };
    }
    async confirm(options) {
        const val = window.confirm(options.message);
        return {
            value: val,
        };
    }
}

var web = /*#__PURE__*/Object.freeze({
    __proto__: null,
    DialogWeb: DialogWeb
});

exports.Dialog = Dialog;
//# sourceMappingURL=plugin.cjs.js.map
