package agrigolo.opendrummer

import android.view.View
import android.widget.TextView
import androidx.recyclerview.widget.RecyclerView

class RecyclerViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
    private val textView: TextView = itemView.findViewById(R.id.text_view)
    private var onItemClickListener: ((String) -> Unit)? = null
    private val stylesHelper = StylesHelper()
    
    fun bind(item: String, onItemClickListener: ((String) -> Unit)?) {
        // Get beautified style name
        textView.text = stylesHelper.getStyleInfo(item)["description"]
        this.onItemClickListener = onItemClickListener
        itemView.setOnClickListener { onItemClickListener?.invoke(item) }

    }
}