package agrigolo.opendrummer.ui.home

import agrigolo.opendrummer.databinding.FragmentHomeBinding
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import androidx.fragment.app.Fragment
import androidx.lifecycle.ViewModelProvider

class HomeFragment() : Fragment() {

    private var _binding: FragmentHomeBinding? = null

    private val binding get() = _binding!!
    private var title: String? = null
    private var bpm: String? = null

    companion object {
        private const val ARG_TITLE = "title"
        private const val ARG_BPM = "bpm"

        fun newInstance(title:String,bpm:String): HomeFragment {
            val fragment = HomeFragment()
            val args = Bundle()
            args.putString(ARG_TITLE, title )
            args.putString(ARG_BPM, bpm)
            fragment.arguments = args
            return fragment
        }
    }

    @OptIn(ExperimentalStdlibApi::class)
    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View {
        val homeViewModel =
            ViewModelProvider(this)[HomeViewModel::class]

        _binding = FragmentHomeBinding.inflate(inflater, container, false)
        val root: View = binding.root

        val styleTitle: TextView = binding.styleTitle
        val styleBpm: TextView = binding.styleBpm
        homeViewModel.text.observe(viewLifecycleOwner) {
            styleTitle.text = title?.let { title }
            styleBpm.text = bpm?.let { "$bpm bpm" }
        }

        return root
    }

    override fun onDestroyView() {
        super.onDestroyView()
        _binding = null
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        title = arguments?.getString(ARG_TITLE)
        bpm = arguments?.getString(ARG_BPM)
    }
}