package agrigolo.opendrummer

import java.lang.reflect.Field
import java.util.Locale

class StylesHelper {

    private var fileNames: List<String> = listOf()
    init {
        val filenames = mutableListOf<String>()
        val fields: Array<Field> =
            R.raw::class.java.getFields()
        fields.forEach {field ->
            filenames.add(field.name)
        }
        fileNames = filenames
    }

    fun getStyleFileNames(): List<String> {
        return fileNames
    }


    fun getStyleInfo(filename: String): HashMap<String, String> {

        //Split filename by "_" and capitalize all words
        val itemStrings = filename.split("_").map { it ->
            it.replaceFirstChar {
                if (it.isLowerCase()) it.titlecase(
                    Locale.getDefault()
                ) else it.toString()
            }
        }
        val styleBpm =itemStrings.last()
        val styleName = itemStrings.dropLast(1).joinToString(separator=" ")
        val styleDesc = "$styleName - $styleBpm bpm"

        return hashMapOf(
            "bpm" to styleBpm,
            "name" to styleName,
            "description" to styleDesc
        )
    }
}