import * as React from 'react';
import { Animated } from 'react-native';
import { EdgeInsets } from 'react-native-safe-area-context';
import { NavigationState as StackNavigationState } from 'react-navigation';
import { Props as HeaderContainerProps } from '../Header/HeaderContainer';
import { Route, Layout, StackHeaderMode, StackCardMode, Scene, StackDescriptorMap } from '../../types';
declare type GestureValues = {
    [key: string]: Animated.Value;
};
declare type Props = {
    mode: StackCardMode;
    insets: EdgeInsets;
    state: StackNavigationState;
    descriptors: StackDescriptorMap;
    routes: Route<string>[];
    openingRouteKeys: string[];
    closingRouteKeys: string[];
    onOpenRoute: (props: {
        route: Route<string>;
    }) => void;
    onCloseRoute: (props: {
        route: Route<string>;
    }) => void;
    getPreviousRoute: (props: {
        route: Route<string>;
    }) => Route<string> | undefined;
    getGesturesEnabled: (props: {
        route: Route<string>;
    }) => boolean;
    renderHeader: (props: HeaderContainerProps) => React.ReactNode;
    renderScene: (props: {
        route: Route<string>;
    }) => React.ReactNode;
    headerMode: StackHeaderMode;
    onTransitionStart: (props: {
        route: Route<string>;
    }, closing: boolean) => void;
    onTransitionEnd: (props: {
        route: Route<string>;
    }, closing: boolean) => void;
    onPageChangeStart?: () => void;
    onPageChangeConfirm?: () => void;
    onPageChangeCancel?: () => void;
};
declare type State = {
    routes: Route<string>[];
    descriptors: StackDescriptorMap;
    scenes: Scene<Route<string>>[];
    gestures: GestureValues;
    layout: Layout;
    headerHeights: Record<string, number>;
};
export default class CardStack extends React.Component<Props, State> {
    static getDerivedStateFromProps(props: Props, state: State): {
        routes: import("react-navigation").NavigationRoute<import("react-navigation").NavigationParams>[];
        scenes: Scene<import("react-navigation").NavigationRoute<import("react-navigation").NavigationParams>>[];
        gestures: GestureValues;
        descriptors: StackDescriptorMap;
        headerHeights: Record<string, number>;
    } | null;
    state: State;
    private handleLayout;
    private handleHeaderLayout;
    render(): JSX.Element;
}
export {};
