import * as React from 'react';
import { Animated, StyleProp, ViewStyle } from 'react-native';
import { NavigationState as StackNavigationState } from 'react-navigation';
import { Props as HeaderContainerProps } from '../Header/HeaderContainer';
import { Route, Scene, Layout, StackHeaderMode, TransitionPreset } from '../../types';
declare type Props = TransitionPreset & {
    index: number;
    active: boolean;
    focused: boolean;
    closing: boolean;
    layout: Layout;
    gesture: Animated.Value;
    previousScene?: Scene<Route<string>>;
    scene: Scene<Route<string>>;
    state: StackNavigationState;
    safeAreaInsetTop: number;
    safeAreaInsetRight: number;
    safeAreaInsetBottom: number;
    safeAreaInsetLeft: number;
    cardOverlayEnabled?: boolean;
    cardShadowEnabled?: boolean;
    cardStyle?: StyleProp<ViewStyle>;
    getPreviousRoute: (props: {
        route: Route<string>;
    }) => Route<string> | undefined;
    renderHeader: (props: HeaderContainerProps) => React.ReactNode;
    renderScene: (props: {
        route: Route<string>;
    }) => React.ReactNode;
    onOpenRoute: (props: {
        route: Route<string>;
    }) => void;
    onCloseRoute: (props: {
        route: Route<string>;
    }) => void;
    onTransitionStart?: (props: {
        route: Route<string>;
    }, closing: boolean) => void;
    onTransitionEnd?: (props: {
        route: Route<string>;
    }, closing: boolean) => void;
    onPageChangeStart?: () => void;
    onPageChangeConfirm?: () => void;
    onPageChangeCancel?: () => void;
    gestureEnabled?: boolean;
    gestureResponseDistance?: {
        vertical?: number;
        horizontal?: number;
    };
    gestureVelocityImpact?: number;
    headerMode: StackHeaderMode;
    headerShown?: boolean;
    headerTransparent?: boolean;
    headerHeight: number;
    onHeaderHeightChange: (props: {
        route: Route<string>;
        height: number;
    }) => void;
};
declare function CardContainer({ active, cardOverlayEnabled, cardShadowEnabled, cardStyle, cardStyleInterpolator, closing, gesture, focused, gestureDirection, gestureEnabled, gestureResponseDistance, gestureVelocityImpact, getPreviousRoute, headerMode, headerShown, headerStyleInterpolator, headerTransparent, headerHeight, onHeaderHeightChange, index, layout, onCloseRoute, onOpenRoute, onPageChangeCancel, onPageChangeConfirm, onPageChangeStart, onTransitionEnd, onTransitionStart, previousScene, renderHeader, renderScene, safeAreaInsetBottom, safeAreaInsetLeft, safeAreaInsetRight, safeAreaInsetTop, scene, state, transitionSpec, }: Props): JSX.Element;
declare const _default: React.MemoExoticComponent<typeof CardContainer>;
export default _default;
