import * as React from 'react';
import { Animated, ViewProps, StyleProp, ViewStyle } from 'react-native';
import { EdgeInsets } from 'react-native-safe-area-context';
import { TransitionSpec, StackCardStyleInterpolator, GestureDirection, Layout } from '../../types';
declare type Props = ViewProps & {
    index: number;
    closing: boolean;
    next?: Animated.AnimatedInterpolation;
    current: Animated.AnimatedInterpolation;
    gesture: Animated.Value;
    layout: Layout;
    insets: EdgeInsets;
    gestureDirection: GestureDirection;
    onOpen: () => void;
    onClose: () => void;
    onTransitionStart?: (props: {
        closing: boolean;
    }) => void;
    onGestureBegin?: () => void;
    onGestureCanceled?: () => void;
    onGestureEnd?: () => void;
    children: React.ReactNode;
    overlayEnabled: boolean;
    shadowEnabled: boolean;
    gestureEnabled: boolean;
    gestureResponseDistance?: {
        vertical?: number;
        horizontal?: number;
    };
    gestureVelocityImpact: number;
    transitionSpec: {
        open: TransitionSpec;
        close: TransitionSpec;
    };
    styleInterpolator: StackCardStyleInterpolator;
    containerStyle?: StyleProp<ViewStyle>;
    contentStyle?: StyleProp<ViewStyle>;
};
export default class Card extends React.Component<Props> {
    static defaultProps: {
        overlayEnabled: boolean;
        shadowEnabled: boolean;
        gestureEnabled: boolean;
        gestureVelocityImpact: number;
    };
    componentDidMount(): void;
    componentDidUpdate(prevProps: Props): void;
    componentWillUnmount(): void;
    private isClosing;
    private inverted;
    private layout;
    private isSwiping;
    private interactionHandle;
    private animate;
    private getAnimateToValue;
    private setPointerEventsEnabled;
    private content;
    private handleStartInteraction;
    private handleEndInteraction;
    private handleGestureStateChange;
    private getInterpolatedStyle;
    private getCardAnimationContext;
    private gestureActivationCriteria;
    private gestureRef;
    render(): JSX.Element;
}
export {};
