import { StyleProp, ViewStyle } from 'react-native';
import { NavigationState as StackNavigationState } from 'react-navigation';
import { EdgeInsets } from 'react-native-safe-area-context';
import { Route, Layout, Scene, StackHeaderStyleInterpolator, GestureDirection } from '../../types';
export declare type Props = {
    mode: 'float' | 'screen';
    layout: Layout;
    insets: EdgeInsets;
    scenes: (Scene<Route<string>> | undefined)[];
    state: StackNavigationState;
    getPreviousRoute: (props: {
        route: Route<string>;
    }) => Route<string> | undefined;
    onContentHeightChange?: (props: {
        route: Route<string>;
        height: number;
    }) => void;
    styleInterpolator: StackHeaderStyleInterpolator;
    gestureDirection: GestureDirection;
    style?: StyleProp<ViewStyle>;
};
export default function HeaderContainer({ mode, scenes, layout, insets, state, getPreviousRoute, onContentHeightChange, gestureDirection, styleInterpolator, style, }: Props): JSX.Element;
