import _extends from"@babel/runtime/helpers/extends";import _objectWithoutProperties from"@babel/runtime/helpers/objectWithoutProperties";import _objectSpread from"@babel/runtime/helpers/objectSpread";import _classCallCheck from"@babel/runtime/helpers/classCallCheck";import _createClass from"@babel/runtime/helpers/createClass";import _possibleConstructorReturn from"@babel/runtime/helpers/possibleConstructorReturn";import _getPrototypeOf from"@babel/runtime/helpers/getPrototypeOf";import _inherits from"@babel/runtime/helpers/inherits";var _jsxFileName="/Users/satya/Workspace/Callstack/react-navigation-stack/src/vendor/views/Stack/Card.tsx";import*as React from'react';import{Animated,View,StyleSheet,Platform,InteractionManager}from'react-native';import{PanGestureHandler,State as GestureState}from'react-native-gesture-handler';import Color from'color';import StackGestureRefContext from'../../utils/GestureHandlerRefContext';import CardAnimationContext from'../../utils/CardAnimationContext';import getDistanceForDirection from'../../utils/getDistanceForDirection';import getInvertedMultiplier from'../../utils/getInvertedMultiplier';import memoize from'../../utils/memoize';var GESTURE_VELOCITY_IMPACT=0.3;var TRUE=1;var FALSE=0;var GESTURE_RESPONSE_DISTANCE_HORIZONTAL=50;var GESTURE_RESPONSE_DISTANCE_VERTICAL=135;var useNativeDriver=Platform.OS!=='web';var Card=function(_React$Component){_inherits(Card,_React$Component);function Card(){var _getPrototypeOf2;var _this;_classCallCheck(this,Card);for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++){args[_key]=arguments[_key];}_this=_possibleConstructorReturn(this,(_getPrototypeOf2=_getPrototypeOf(Card)).call.apply(_getPrototypeOf2,[this].concat(args)));_this.isClosing=new Animated.Value(FALSE);_this.inverted=new Animated.Value(getInvertedMultiplier(_this.props.gestureDirection));_this.layout={width:new Animated.Value(_this.props.layout.width),height:new Animated.Value(_this.props.layout.height)};_this.isSwiping=new Animated.Value(FALSE);_this.animate=function(_ref){var closing=_ref.closing,velocity=_ref.velocity;var _this$props=_this.props,gesture=_this$props.gesture,transitionSpec=_this$props.transitionSpec,onOpen=_this$props.onOpen,onClose=_this$props.onClose,onTransitionStart=_this$props.onTransitionStart;var toValue=_this.getAnimateToValue(_objectSpread({},_this.props,{closing:closing}));var spec=closing?transitionSpec.close:transitionSpec.open;var animation=spec.animation==='spring'?Animated.spring:Animated.timing;_this.setPointerEventsEnabled(!closing);_this.handleStartInteraction();onTransitionStart==null?void 0:onTransitionStart({closing:closing});animation(gesture,_objectSpread({},spec.config,{velocity:velocity,toValue:toValue,useNativeDriver:useNativeDriver,isInteraction:false})).start(function(_ref2){var finished=_ref2.finished;_this.handleEndInteraction();if(finished){if(closing){onClose();}else{onOpen();}}});};_this.getAnimateToValue=function(_ref3){var closing=_ref3.closing,layout=_ref3.layout,gestureDirection=_ref3.gestureDirection;if(!closing){return 0;}return getDistanceForDirection(layout,gestureDirection);};_this.setPointerEventsEnabled=function(enabled){var pointerEvents=enabled?'box-none':'none';_this.content.current&&_this.content.current.setNativeProps({pointerEvents:pointerEvents});};_this.content=React.createRef();_this.handleStartInteraction=function(){if(_this.interactionHandle===undefined){_this.interactionHandle=InteractionManager.createInteractionHandle();}};_this.handleEndInteraction=function(){if(_this.interactionHandle!==undefined){InteractionManager.clearInteractionHandle(_this.interactionHandle);_this.interactionHandle=undefined;}};_this.handleGestureStateChange=function(_ref4){var nativeEvent=_ref4.nativeEvent;var _this$props2=_this.props,layout=_this$props2.layout,onGestureBegin=_this$props2.onGestureBegin,onGestureCanceled=_this$props2.onGestureCanceled,onGestureEnd=_this$props2.onGestureEnd,gestureDirection=_this$props2.gestureDirection,gestureVelocityImpact=_this$props2.gestureVelocityImpact;switch(nativeEvent.state){case GestureState.BEGAN:_this.isSwiping.setValue(TRUE);_this.handleStartInteraction();onGestureBegin==null?void 0:onGestureBegin();break;case GestureState.CANCELLED:_this.isSwiping.setValue(FALSE);_this.handleEndInteraction();onGestureCanceled==null?void 0:onGestureCanceled();break;case GestureState.END:{_this.isSwiping.setValue(FALSE);var distance;var translation;var velocity;if(gestureDirection==='vertical'||gestureDirection==='vertical-inverted'){distance=layout.height;translation=nativeEvent.translationY;velocity=nativeEvent.velocityY;}else{distance=layout.width;translation=nativeEvent.translationX;velocity=nativeEvent.velocityX;}var closing=Math.abs(translation+velocity*gestureVelocityImpact)>distance/2?velocity!==0||translation!==0:false;_this.animate({closing:closing,velocity:velocity});onGestureEnd==null?void 0:onGestureEnd();break;}}};_this.getInterpolatedStyle=memoize(function(styleInterpolator,index,current,next,layout,insetTop,insetRight,insetBottom,insetLeft){return styleInterpolator({index:index,current:{progress:current},next:next&&{progress:next},closing:_this.isClosing,swiping:_this.isSwiping,inverted:_this.inverted,layouts:{screen:layout},insets:{top:insetTop,right:insetRight,bottom:insetBottom,left:insetLeft}});});_this.getCardAnimationContext=memoize(function(index,current,next,layout,insetTop,insetRight,insetBottom,insetLeft){return{index:index,current:{progress:current},next:next&&{progress:next},closing:_this.isClosing,swiping:_this.isSwiping,inverted:_this.inverted,layouts:{screen:layout},insets:{top:insetTop,right:insetRight,bottom:insetBottom,left:insetLeft}};});_this.gestureRef=React.createRef();return _this;}_createClass(Card,[{key:"componentDidMount",value:function componentDidMount(){this.animate({closing:this.props.closing});}},{key:"componentDidUpdate",value:function componentDidUpdate(prevProps){var _this$props3=this.props,layout=_this$props3.layout,gestureDirection=_this$props3.gestureDirection,closing=_this$props3.closing;var width=layout.width,height=layout.height;if(width!==prevProps.layout.width){this.layout.width.setValue(width);}if(height!==prevProps.layout.height){this.layout.height.setValue(height);}if(gestureDirection!==prevProps.gestureDirection){this.inverted.setValue(getInvertedMultiplier(gestureDirection));}if(this.getAnimateToValue(this.props)!==this.getAnimateToValue(prevProps)){this.animate({closing:closing});}}},{key:"componentWillUnmount",value:function componentWillUnmount(){this.handleEndInteraction();}},{key:"gestureActivationCriteria",value:function gestureActivationCriteria(){var _this$props4=this.props,layout=_this$props4.layout,gestureDirection=_this$props4.gestureDirection,gestureResponseDistance=_this$props4.gestureResponseDistance;var distance=gestureDirection==='vertical'||gestureDirection==='vertical-inverted'?(gestureResponseDistance==null?void 0:gestureResponseDistance.vertical)!==undefined?gestureResponseDistance.vertical:GESTURE_RESPONSE_DISTANCE_VERTICAL:(gestureResponseDistance==null?void 0:gestureResponseDistance.horizontal)!==undefined?gestureResponseDistance.horizontal:GESTURE_RESPONSE_DISTANCE_HORIZONTAL;if(gestureDirection==='vertical'){return{maxDeltaX:15,minOffsetY:5,hitSlop:{bottom:-layout.height+distance}};}else if(gestureDirection==='vertical-inverted'){return{maxDeltaX:15,minOffsetY:-5,hitSlop:{top:-layout.height+distance}};}else{var hitSlop=-layout.width+distance;var invertedMultiplier=getInvertedMultiplier(gestureDirection);if(invertedMultiplier===1){return{minOffsetX:5,maxDeltaY:20,hitSlop:{right:hitSlop}};}else{return{minOffsetX:-5,maxDeltaY:20,hitSlop:{left:hitSlop}};}}}},{key:"render",value:function render(){var _this$props5=this.props,styleInterpolator=_this$props5.styleInterpolator,index=_this$props5.index,current=_this$props5.current,gesture=_this$props5.gesture,next=_this$props5.next,layout=_this$props5.layout,insets=_this$props5.insets,overlayEnabled=_this$props5.overlayEnabled,shadowEnabled=_this$props5.shadowEnabled,gestureEnabled=_this$props5.gestureEnabled,gestureDirection=_this$props5.gestureDirection,children=_this$props5.children,customContainerStyle=_this$props5.containerStyle,contentStyle=_this$props5.contentStyle,rest=_objectWithoutProperties(_this$props5,["styleInterpolator","index","current","gesture","next","layout","insets","overlayEnabled","shadowEnabled","gestureEnabled","gestureDirection","children","containerStyle","contentStyle"]);var interpolatedStyle=this.getInterpolatedStyle(styleInterpolator,index,current,next,layout,insets.top,insets.right,insets.bottom,insets.left);var animationContext=this.getCardAnimationContext(index,current,next,layout,insets.top,insets.right,insets.bottom,insets.left);var containerStyle=interpolatedStyle.containerStyle,cardStyle=interpolatedStyle.cardStyle,overlayStyle=interpolatedStyle.overlayStyle,shadowStyle=interpolatedStyle.shadowStyle;var handleGestureEvent=gestureEnabled?Animated.event([{nativeEvent:gestureDirection==='vertical'||gestureDirection==='vertical-inverted'?{translationY:gesture}:{translationX:gesture}}],{useNativeDriver:useNativeDriver}):undefined;var _StyleSheet$flatten=StyleSheet.flatten(contentStyle||{}),backgroundColor=_StyleSheet$flatten.backgroundColor;var isTransparent=backgroundColor?Color(backgroundColor).alpha()===0:false;return React.createElement(View,_extends({pointerEvents:"box-none"},rest,{__source:{fileName:_jsxFileName,lineNumber:457}}),overlayEnabled&&overlayStyle?React.createElement(Animated.View,{pointerEvents:"none",style:[styles.overlay,overlayStyle],__source:{fileName:_jsxFileName,lineNumber:459}}):null,React.createElement(Animated.View,{style:[styles.container,containerStyle,customContainerStyle],pointerEvents:"box-none",__source:{fileName:_jsxFileName,lineNumber:464}},React.createElement(PanGestureHandler,_extends({ref:this.gestureRef,enabled:layout.width!==0&&gestureEnabled,onGestureEvent:handleGestureEvent,onHandlerStateChange:this.handleGestureStateChange},this.gestureActivationCriteria(),{__source:{fileName:_jsxFileName,lineNumber:468}}),React.createElement(Animated.View,{style:[styles.container,cardStyle],__source:{fileName:_jsxFileName,lineNumber:475}},shadowEnabled&&shadowStyle&&!isTransparent?React.createElement(Animated.View,{style:[styles.shadow,gestureDirection==='horizontal'?styles.shadowHorizontal:styles.shadowVertical,shadowStyle],pointerEvents:"none",__source:{fileName:_jsxFileName,lineNumber:477}}):null,React.createElement(View,{ref:this.content,style:[styles.content,contentStyle],__source:{fileName:_jsxFileName,lineNumber:488}},React.createElement(StackGestureRefContext.Provider,{value:this.gestureRef,__source:{fileName:_jsxFileName,lineNumber:489}},React.createElement(CardAnimationContext.Provider,{value:animationContext,__source:{fileName:_jsxFileName,lineNumber:490}},children)))))));}}]);return Card;}(React.Component);Card.defaultProps={overlayEnabled:Platform.OS!=='ios',shadowEnabled:true,gestureEnabled:true,gestureVelocityImpact:GESTURE_VELOCITY_IMPACT};export{Card as default};var styles=StyleSheet.create({container:{flex:1},content:{flex:1,overflow:'hidden'},overlay:_objectSpread({},StyleSheet.absoluteFillObject,{backgroundColor:'#000'}),shadow:{position:'absolute',backgroundColor:'#fff',shadowRadius:5,shadowColor:'#000',shadowOpacity:0.3},shadowHorizontal:{top:0,left:0,bottom:0,width:3,shadowOffset:{width:-1,height:1}},shadowVertical:{top:0,left:0,right:0,height:3,shadowOffset:{width:1,height:-1}}});
//# sourceMappingURL=Card.js.map