package com.swmansion.rnscreens;

import android.view.View;

import com.facebook.react.bridge.JSApplicationCausedNativeException;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.annotations.ReactProp;

import javax.annotation.Nonnull;

@ReactModule(name = ScreenStackHeaderConfigViewManager.REACT_CLASS)
public class ScreenStackHeaderConfigViewManager extends ViewGroupManager<ScreenStackHeaderConfig> {

  protected static final String REACT_CLASS = "RNSScreenStackHeaderConfig";

  @Override
  public String getName() {
    return REACT_CLASS;
  }

  @Override
  protected ScreenStackHeaderConfig createViewInstance(ThemedReactContext reactContext) {
    return new ScreenStackHeaderConfig(reactContext);
  }

  @Override
  public void addView(ScreenStackHeaderConfig parent, View child, int index) {
    if (!(child instanceof ScreenStackHeaderSubview)) {
      throw new JSApplicationCausedNativeException("Config children should be of type " + ScreenStackHeaderSubviewManager.REACT_CLASS);
    }
    parent.addConfigSubview((ScreenStackHeaderSubview) child, index);
  }

  @Override
  public void onDropViewInstance(@Nonnull ScreenStackHeaderConfig view) {
    view.destroy();
  }

  @Override
  public void removeAllViews(ScreenStackHeaderConfig parent) {
    parent.removeAllConfigSubviews();
  }

  @Override
  public void removeViewAt(ScreenStackHeaderConfig parent, int index) {
    parent.removeConfigSubview(index);
  }

  @Override
  public int getChildCount(ScreenStackHeaderConfig parent) {
    return parent.getConfigSubviewsCount();
  }

  @Override
  public View getChildAt(ScreenStackHeaderConfig parent, int index) {
    return parent.getConfigSubview(index);
  }

  @Override
  public boolean needsCustomLayoutForChildren() {
    return true;
  }

  @Override
  protected void onAfterUpdateTransaction(ScreenStackHeaderConfig parent) {
    super.onAfterUpdateTransaction(parent);
    parent.onUpdate();
  }

  @ReactProp(name = "title")
  public void setTitle(ScreenStackHeaderConfig config, String title) {
    config.setTitle(title);
  }

  @ReactProp(name = "titleFontFamily")
  public void setTitleFontFamily(ScreenStackHeaderConfig config, String titleFontFamily) {
    config.setTitleFontFamily(titleFontFamily);
  }

  @ReactProp(name = "titleFontSize")
  public void setTitleFontSize(ScreenStackHeaderConfig config, float titleFontSize) {
    config.setTitleFontSize(titleFontSize);
  }

  @ReactProp(name = "titleColor", customType = "Color")
  public void setTitleColor(ScreenStackHeaderConfig config, int titleColor) {
    config.setTitleColor(titleColor);
  }

  @ReactProp(name = "backgroundColor", customType = "Color")
  public void setBackgroundColor(ScreenStackHeaderConfig config, int titleColor) {
    config.setBackgroundColor(titleColor);
  }

  @ReactProp(name = "hideShadow")
  public void setHideShadow(ScreenStackHeaderConfig config, boolean hideShadow) {
    config.setHideShadow(hideShadow);
  }

  @ReactProp(name = "gestureEnabled", defaultBoolean = true)
  public void setGestureEnabled(ScreenStackHeaderConfig config, boolean gestureEnabled) {
    config.setGestureEnabled(gestureEnabled);
  }

  @ReactProp(name = "hideBackButton")
  public void setHideBackButton(ScreenStackHeaderConfig config, boolean hideBackButton) {
    config.setHideBackButton(hideBackButton);
  }

  @ReactProp(name = "color", customType = "Color")
  public void setColor(ScreenStackHeaderConfig config, int color) {
    config.setTintColor(color);
  }

  @ReactProp(name = "hidden")
  public void setHidden(ScreenStackHeaderConfig config, boolean hidden) {
    config.setHidden(hidden);
  }


//  RCT_EXPORT_VIEW_PROPERTY(backTitle, NSString)
//  RCT_EXPORT_VIEW_PROPERTY(backTitleFontFamily, NSString)
//  RCT_EXPORT_VIEW_PROPERTY(backTitleFontSize, NSString)
//  // `hidden` is an UIView property, we need to use different name internally
//  RCT_EXPORT_VIEW_PROPERTY(translucent, BOOL)
}
