import * as React from 'react';
import { Animated, ViewStyle, StyleProp } from 'react-native';
import { FABGroup as _FABGroup } from './FABGroup';
import Surface from '../Surface';
import { Theme, $RemoveChildren } from '../../types';
import { IconSource } from './../Icon';
declare type Props = $RemoveChildren<typeof Surface> & {
    /**
     * Icon to display for the `FAB`.
     */
    icon: IconSource;
    /**
     * Optional label for extended `FAB`.
     */
    label?: string;
    /**
     * Accessibility label for the FAB. This is read by the screen reader when the user taps the FAB.
     * Uses `label` by default if specified.
     */
    accessibilityLabel?: string;
    /**
     *  Whether FAB is mini-sized, used to create visual continuity with other elements. This has no effect if `label` is specified.
     */
    small?: boolean;
    /**
     * Custom color for the `FAB`.
     */
    color?: string;
    /**
     * Whether `FAB` is disabled. A disabled button is greyed out and `onPress` is not called on touch.
     */
    disabled?: boolean;
    /**
     * Whether `FAB` is currently visible.
     */
    visible?: boolean;
    /**
     * Whether to show a loading indicator.
     */
    loading?: boolean;
    /**
     * Function to execute on press.
     */
    onPress?: () => void;
    style?: StyleProp<ViewStyle>;
    /**
     * @optional
     */
    theme: Theme;
};
declare type State = {
    visibility: Animated.Value;
};
/**
 * A floating action button represents the primary action in an application.
 *
 * <div class="screenshots">
 *   <img src="screenshots/fab-1.png" />
 *   <img src="screenshots/fab-2.png" />
 * </div>
 *
 * ## Usage
 * ```js
 * import * as React from 'react';
 * import { StyleSheet } from 'react-native';
 * import { FAB } from 'react-native-paper';
 *
 * const MyComponent = () => (
 *   <FAB
 *     style={styles.fab}
 *     small
 *     icon="plus"
 *     onPress={() => console.log('Pressed')}
 *   />
 * );
 *
 * const styles = StyleSheet.create({
 *   fab: {
 *     position: 'absolute',
 *     margin: 16,
 *     right: 0,
 *     bottom: 0,
 *   },
 * })
 *
 * export default MyComponent;
 * ```
 */
declare class FAB extends React.Component<Props, State> {
    static Group: (React.ComponentClass<Pick<{
        actions: {
            icon: IconSource;
            label?: string | undefined;
            color?: string | undefined;
            accessibilityLabel?: string | undefined;
            style?: StyleProp<ViewStyle>;
            onPress: () => void;
        }[];
        icon: IconSource;
        accessibilityLabel?: string | undefined;
        color?: string | undefined;
        onPress?: (() => void) | undefined;
        open: boolean;
        onStateChange: (state: {
            open: boolean;
        }) => void;
        visible: boolean;
        style?: StyleProp<ViewStyle>;
        fabStyle?: StyleProp<ViewStyle>;
        theme: Theme;
    }, "style" | "color" | "icon" | "onPress" | "accessibilityLabel" | "visible" | "actions" | "open" | "onStateChange" | "fabStyle"> & {
        theme?: import("@callstack/react-theme-provider").$DeepPartial<Theme> | undefined;
    }, any> & import("@callstack/react-theme-provider/typings/hoist-non-react-statics").NonReactStatics<(React.ComponentClass<{
        actions: {
            icon: IconSource;
            label?: string | undefined;
            color?: string | undefined;
            accessibilityLabel?: string | undefined;
            style?: StyleProp<ViewStyle>;
            onPress: () => void;
        }[];
        icon: IconSource;
        accessibilityLabel?: string | undefined;
        color?: string | undefined;
        onPress?: (() => void) | undefined;
        open: boolean;
        onStateChange: (state: {
            open: boolean;
        }) => void;
        visible: boolean;
        style?: StyleProp<ViewStyle>;
        fabStyle?: StyleProp<ViewStyle>;
        theme: Theme;
    }, any> & typeof _FABGroup) | (React.FunctionComponent<{
        actions: {
            icon: IconSource;
            label?: string | undefined;
            color?: string | undefined;
            accessibilityLabel?: string | undefined;
            style?: StyleProp<ViewStyle>;
            onPress: () => void;
        }[];
        icon: IconSource;
        accessibilityLabel?: string | undefined;
        color?: string | undefined;
        onPress?: (() => void) | undefined;
        open: boolean;
        onStateChange: (state: {
            open: boolean;
        }) => void;
        visible: boolean;
        style?: StyleProp<ViewStyle>;
        fabStyle?: StyleProp<ViewStyle>;
        theme: Theme;
    }> & typeof _FABGroup), {}>) | (React.FunctionComponent<Pick<{
        actions: {
            icon: IconSource;
            label?: string | undefined;
            color?: string | undefined;
            accessibilityLabel?: string | undefined;
            style?: StyleProp<ViewStyle>;
            onPress: () => void;
        }[];
        icon: IconSource;
        accessibilityLabel?: string | undefined;
        color?: string | undefined;
        onPress?: (() => void) | undefined;
        open: boolean;
        onStateChange: (state: {
            open: boolean;
        }) => void;
        visible: boolean;
        style?: StyleProp<ViewStyle>;
        fabStyle?: StyleProp<ViewStyle>;
        theme: Theme;
    }, "style" | "color" | "icon" | "onPress" | "accessibilityLabel" | "visible" | "actions" | "open" | "onStateChange" | "fabStyle"> & {
        theme?: import("@callstack/react-theme-provider").$DeepPartial<Theme> | undefined;
    }> & import("@callstack/react-theme-provider/typings/hoist-non-react-statics").NonReactStatics<(React.ComponentClass<{
        actions: {
            icon: IconSource;
            label?: string | undefined;
            color?: string | undefined;
            accessibilityLabel?: string | undefined;
            style?: StyleProp<ViewStyle>;
            onPress: () => void;
        }[];
        icon: IconSource;
        accessibilityLabel?: string | undefined;
        color?: string | undefined;
        onPress?: (() => void) | undefined;
        open: boolean;
        onStateChange: (state: {
            open: boolean;
        }) => void;
        visible: boolean;
        style?: StyleProp<ViewStyle>;
        fabStyle?: StyleProp<ViewStyle>;
        theme: Theme;
    }, any> & typeof _FABGroup) | (React.FunctionComponent<{
        actions: {
            icon: IconSource;
            label?: string | undefined;
            color?: string | undefined;
            accessibilityLabel?: string | undefined;
            style?: StyleProp<ViewStyle>;
            onPress: () => void;
        }[];
        icon: IconSource;
        accessibilityLabel?: string | undefined;
        color?: string | undefined;
        onPress?: (() => void) | undefined;
        open: boolean;
        onStateChange: (state: {
            open: boolean;
        }) => void;
        visible: boolean;
        style?: StyleProp<ViewStyle>;
        fabStyle?: StyleProp<ViewStyle>;
        theme: Theme;
    }> & typeof _FABGroup), {}>);
    static defaultProps: {
        visible: boolean;
    };
    state: {
        visibility: Animated.Value;
    };
    componentDidUpdate(prevProps: Props): void;
    render(): JSX.Element;
}
declare const _default: (React.ComponentClass<Pick<Props, "label" | "small" | "style" | "color" | "icon" | "onLayout" | "onPress" | "testID" | "nativeID" | "accessible" | "accessibilityLabel" | "accessibilityRole" | "accessibilityStates" | "accessibilityHint" | "accessibilityComponentType" | "accessibilityLiveRegion" | "importantForAccessibility" | "accessibilityElementsHidden" | "accessibilityTraits" | "onAccessibilityTap" | "onMagicTap" | "accessibilityIgnoresInvertColors" | "disabled" | "hitSlop" | "pointerEvents" | "removeClippedSubviews" | "collapsable" | "needsOffscreenAlphaCompositing" | "renderToHardwareTextureAndroid" | "accessibilityViewIsModal" | "accessibilityActions" | "onAccessibilityAction" | "shouldRasterizeIOS" | "isTVSelectable" | "hasTVPreferredFocus" | "tvParallaxProperties" | "tvParallaxShiftDistanceX" | "tvParallaxShiftDistanceY" | "tvParallaxTiltAngle" | "tvParallaxMagnification" | "onStartShouldSetResponder" | "onMoveShouldSetResponder" | "onResponderEnd" | "onResponderGrant" | "onResponderReject" | "onResponderMove" | "onResponderRelease" | "onResponderStart" | "onResponderTerminationRequest" | "onResponderTerminate" | "onStartShouldSetResponderCapture" | "onMoveShouldSetResponderCapture" | "onTouchStart" | "onTouchMove" | "onTouchEnd" | "onTouchCancel" | "onTouchEndCapture" | "visible" | "loading"> & {
    theme?: import("@callstack/react-theme-provider").$DeepPartial<Theme> | undefined;
}, any> & import("@callstack/react-theme-provider/typings/hoist-non-react-statics").NonReactStatics<(React.ComponentClass<Props, any> & typeof FAB) | (React.FunctionComponent<Props> & typeof FAB), {}>) | (React.FunctionComponent<Pick<Props, "label" | "small" | "style" | "color" | "icon" | "onLayout" | "onPress" | "testID" | "nativeID" | "accessible" | "accessibilityLabel" | "accessibilityRole" | "accessibilityStates" | "accessibilityHint" | "accessibilityComponentType" | "accessibilityLiveRegion" | "importantForAccessibility" | "accessibilityElementsHidden" | "accessibilityTraits" | "onAccessibilityTap" | "onMagicTap" | "accessibilityIgnoresInvertColors" | "disabled" | "hitSlop" | "pointerEvents" | "removeClippedSubviews" | "collapsable" | "needsOffscreenAlphaCompositing" | "renderToHardwareTextureAndroid" | "accessibilityViewIsModal" | "accessibilityActions" | "onAccessibilityAction" | "shouldRasterizeIOS" | "isTVSelectable" | "hasTVPreferredFocus" | "tvParallaxProperties" | "tvParallaxShiftDistanceX" | "tvParallaxShiftDistanceY" | "tvParallaxTiltAngle" | "tvParallaxMagnification" | "onStartShouldSetResponder" | "onMoveShouldSetResponder" | "onResponderEnd" | "onResponderGrant" | "onResponderReject" | "onResponderMove" | "onResponderRelease" | "onResponderStart" | "onResponderTerminationRequest" | "onResponderTerminate" | "onStartShouldSetResponderCapture" | "onMoveShouldSetResponderCapture" | "onTouchStart" | "onTouchMove" | "onTouchEnd" | "onTouchCancel" | "onTouchEndCapture" | "visible" | "loading"> & {
    theme?: import("@callstack/react-theme-provider").$DeepPartial<Theme> | undefined;
}> & import("@callstack/react-theme-provider/typings/hoist-non-react-statics").NonReactStatics<(React.ComponentClass<Props, any> & typeof FAB) | (React.FunctionComponent<Props> & typeof FAB), {}>);
export default _default;
