import * as React from 'react';
import { StyleProp, ViewStyle } from 'react-native';
import { IconSource } from '../Icon';
import { Theme } from '../../types';
declare type Props = {
    /**
     * The label text of the item.
     */
    label: string;
    /**
     * Icon to display for the `DrawerItem`.
     */
    icon?: IconSource;
    /**
     * Whether to highlight the drawer item as active.
     */
    active?: boolean;
    /**
     * Function to execute on press.
     */
    onPress?: () => void;
    style?: StyleProp<ViewStyle>;
    /**
     * @optional
     */
    theme: Theme;
};
/**
 * A component used to show an action item with an icon and a label in a navigation drawer.
 *
 * ## Usage
 * ```js
 * import * as React from 'react';
 * import { Drawer } from 'react-native-paper';
 *
 * const MyComponent = () => (
 *   <Drawer.Item label="First Item" />
 * );
 *
 * export default MyComponent;
 * ```
 */
declare class DrawerItem extends React.Component<Props> {
    static displayName: string;
    render(): JSX.Element;
}
declare const _default: (React.ComponentClass<Pick<Props, "label" | "style" | "icon" | "onPress" | "active"> & {
    theme?: import("@callstack/react-theme-provider").$DeepPartial<Theme> | undefined;
}, any> & import("@callstack/react-theme-provider/typings/hoist-non-react-statics").NonReactStatics<(React.ComponentClass<Props, any> & typeof DrawerItem) | (React.FunctionComponent<Props> & typeof DrawerItem), {}>) | (React.FunctionComponent<Pick<Props, "label" | "style" | "icon" | "onPress" | "active"> & {
    theme?: import("@callstack/react-theme-provider").$DeepPartial<Theme> | undefined;
}> & import("@callstack/react-theme-provider/typings/hoist-non-react-statics").NonReactStatics<(React.ComponentClass<Props, any> & typeof DrawerItem) | (React.FunctionComponent<Props> & typeof DrawerItem), {}>);
export default _default;
