/**
 * (c) Michel Weststrate 2015 - 2018
 * MIT Licensed
 *
 * Welcome to the mobx sources! To get an global overview of how MobX internally works,
 * this is a good place to start:
 * https://medium.com/@mweststrate/becoming-fully-reactive-an-in-depth-explanation-of-mobservable-55995262a254#.xvbh6qd74
 *
 * Source folders:
 * ===============
 *
 * - api/     Most of the public static methods exposed by the module can be found here.
 * - core/    Implementation of the MobX algorithm; atoms, derivations, reactions, dependency trees, optimizations. Cool stuff can be found here.
 * - types/   All the magic that is need to have observable objects, arrays and values is in this folder. Including the modifiers like `asFlat`.
 * - utils/   Utility stuff.
 *
 */
export { IObservable, IDepTreeNode, Reaction, IReactionPublic, IReactionDisposer, IDerivation, untracked, IDerivationState, IAtom, createAtom, IAction, spy, IComputedValue, IEqualsComparer, comparer, IEnhancer, IInterceptable, IInterceptor, IListenable, IObjectWillChange, IObjectDidChange, IObservableObject, isObservableObject, IValueDidChange, IValueWillChange, IObservableValue, isObservableValue as isBoxedObservable, IObservableArray, IArrayWillChange, IArrayWillSplice, IArrayChange, IArraySplice, isObservableArray, IKeyValueMap, ObservableMap, IMapEntries, IMapEntry, IMapWillChange, IMapDidChange, isObservableMap, IObservableMapInitialValues, ObservableSet, isObservableSet, ISetDidChange, ISetWillChange, IObservableSetInitialValues, transaction, observable, IObservableFactory, IObservableFactories, computed, IComputed, isObservable, isObservableProp, isComputed, isComputedProp, extendObservable, observe, intercept, autorun, IAutorunOptions, reaction, IReactionOptions, when, IWhenOptions, action, isAction, runInAction, IActionFactory, keys, values, entries, set, remove, has, get, decorate, configure, onBecomeObserved, onBecomeUnobserved, flow, FlowCancellationError, isFlowCancellationError, toJS, trace, IObserverTree, IDependencyTree, getDependencyTree, getObserverTree, resetGlobalState as _resetGlobalState, getGlobalState as _getGlobalState, getDebugName, getAtom, getAdministration as _getAdministration, allowStateChanges as _allowStateChanges, allowStateChangesInsideComputed as _allowStateChangesInsideComputed, Lambda, isArrayLike, $mobx, isComputingDerivation as _isComputingDerivation, onReactionError, interceptReads as _interceptReads, IComputedValueOptions, IActionRunInfo, _startAction, _endAction, allowStateReadsStart as _allowStateReadsStart, allowStateReadsEnd as _allowStateReadsEnd } from "./internal";
