"use strict";
/** @format */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.decipherAES = exports.getDomain = exports.randomHex = exports.findlnurl = void 0;
var aes_js_1 = __importDefault(require("aes-js"));
var base64_js_1 = __importDefault(require("base64-js"));
function findlnurl(bodyOfText) {
    var res = /,*?((lnurl)([0-9]{1,}[a-z0-9]+){1})/.exec(bodyOfText.toLowerCase());
    if (res) {
        return res[1];
    }
    return null;
}
exports.findlnurl = findlnurl;
function randomHex(nbytes) {
    var len = nbytes * 2;
    var hex = '0123456789abcdef';
    var output = '';
    for (var i = 0; i < len; ++i) {
        output += hex.charAt(Math.floor(Math.random() * hex.length));
    }
    return output;
}
exports.randomHex = randomHex;
function getDomain(url) {
    return url
        .split('://')[1]
        .split('/')[0]
        .split('@')
        .slice(-1)[0]
        .split(':')[0];
}
exports.getDomain = getDomain;
function decipherAES(sa, preimage) {
    if (sa.tag !== 'aes') {
        return '';
    }
    var key = aes_js_1.default.utils.hex.toBytes(preimage);
    var iv = base64_js_1.default.toByteArray(sa.iv);
    var ciphertext = base64_js_1.default.toByteArray(sa.ciphertext);
    var CBC = new aes_js_1.default.ModeOfOperation.cbc(key, iv);
    var plaintext = CBC.decrypt(ciphertext);
    // remove padding
    var size = plaintext.length;
    var pad = plaintext[size - 1];
    plaintext = plaintext.slice(0, size - pad);
    return aes_js_1.default.utils.utf8.fromBytes(plaintext);
}
exports.decipherAES = decipherAES;
