import _toConsumableArray from"@babel/runtime/helpers/toConsumableArray";import _objectSpread from"@babel/runtime/helpers/objectSpread";import*as NavigationActions from'../NavigationActions';import*as StackActions from'./StackActions';import createConfigGetter from'./createConfigGetter';import getScreenForRouteName from'./getScreenForRouteName';import StateUtils from'../StateUtils';import validateRouteConfigMap from'./validateRouteConfigMap';import invariant from'../utils/invariant';import{generateKey}from'./KeyGenerator';import{createPathParser}from'./pathUtils';function behavesLikePushAction(action){return action.type===NavigationActions.NAVIGATE||action.type===StackActions.PUSH;}var defaultActionCreators=function defaultActionCreators(){return{};};function isResetToRootStack(action){return action.type===StackActions.RESET&&action.key===null;}export default(function(routeConfigs){var stackConfig=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};validateRouteConfigMap(routeConfigs);var childRouters={};var routeNames=Object.keys(routeConfigs);routeNames.forEach(function(routeName){var routeConfig=routeConfigs[routeName];var screen=routeConfig&&routeConfig.screen?routeConfig.screen:routeConfig;if(screen&&screen.router){childRouters[routeName]=screen.router;}else{childRouters[routeName]=null;}});var initialRouteParams=stackConfig.initialRouteParams;var getCustomActionCreators=stackConfig.getCustomActionCreators||defaultActionCreators;var initialRouteName=stackConfig.initialRouteName||routeNames[0];var initialChildRouter=childRouters[initialRouteName];function getInitialState(action){var route={};var childRouter=childRouters[action.routeName];if(behavesLikePushAction(action)&&childRouter!==undefined){var childState={};if(childRouter!==null){var childAction=action.action||NavigationActions.init({params:action.params});childState=childRouter.getStateForAction(childAction);}return{key:'StackRouterRoot',isTransitioning:false,index:0,routes:[_objectSpread({params:action.params},childState,{key:action.key||generateKey(),routeName:action.routeName})]};}if(initialChildRouter){route=initialChildRouter.getStateForAction(NavigationActions.navigate({routeName:initialRouteName,params:initialRouteParams}));}var params=(routeConfigs[initialRouteName].params||route.params||action.params||initialRouteParams)&&_objectSpread({},routeConfigs[initialRouteName].params||{},route.params||{},action.params||{},initialRouteParams||{});var initialRouteKey=stackConfig.initialRouteKey;route=_objectSpread({},route,params?{params:params}:{},{routeName:initialRouteName,key:action.key||initialRouteKey||generateKey()});return{key:'StackRouterRoot',isTransitioning:false,index:0,routes:[route]};}function getParamsForRouteAndAction(routeName,action){var routeConfig=routeConfigs[routeName];if(routeConfig&&routeConfig.params){return _objectSpread({},routeConfig.params,action.params);}else{return action.params;}}var _createPathParser=createPathParser(childRouters,routeConfigs,stackConfig),getPathAndParamsForRoute=_createPathParser.getPathAndParamsForRoute,_getActionForPathAndParams=_createPathParser.getActionForPathAndParams;return{childRouters:childRouters,getComponentForState:function getComponentForState(state){var activeChildRoute=state.routes[state.index];var routeName=activeChildRoute.routeName;if(childRouters[routeName]){return childRouters[routeName].getComponentForState(activeChildRoute);}return getScreenForRouteName(routeConfigs,routeName);},getComponentForRouteName:function getComponentForRouteName(routeName){return getScreenForRouteName(routeConfigs,routeName);},getActionCreators:function getActionCreators(route,navStateKey){return _objectSpread({},getCustomActionCreators(route,navStateKey),{pop:function pop(n,params){return StackActions.pop(_objectSpread({n:n},params));},popToTop:function popToTop(params){return StackActions.popToTop(params);},push:function push(routeName,params,action){return StackActions.push({routeName:routeName,params:params,action:action});},replace:function replace(replaceWith,params,action,newKey){if(typeof replaceWith==='string'){return StackActions.replace({routeName:replaceWith,params:params,action:action,key:route.key,newKey:newKey});}invariant(typeof replaceWith==='object','Must replaceWith an object or a string');invariant(params==null,'Params must not be provided to .replace() when specifying an object');invariant(action==null,'Child action must not be provided to .replace() when specifying an object');invariant(newKey==null,'Child action must not be provided to .replace() when specifying an object');return StackActions.replace(replaceWith);},reset:function reset(actions,index){return StackActions.reset({actions:actions,index:index==null?actions.length-1:index,key:navStateKey});},dismiss:function dismiss(){return NavigationActions.back({key:navStateKey});}});},getStateForAction:function getStateForAction(action,state){if(!state){return getInitialState(action);}var activeChildRoute=state.routes[state.index];if(!isResetToRootStack(action)&&action.type!==NavigationActions.NAVIGATE){var activeChildRouter=childRouters[activeChildRoute.routeName];if(activeChildRouter){var route=activeChildRouter.getStateForAction(action,activeChildRoute);if(route!==null&&route!==activeChildRoute){return StateUtils.replaceAt(state,activeChildRoute.key,route,action.type===NavigationActions.SET_PARAMS);}}}else if(action.type===NavigationActions.NAVIGATE){for(var _iterator=state.routes.slice().reverse(),_isArray=Array.isArray(_iterator),_i=0,_iterator=_isArray?_iterator:_iterator[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();;){var _ref;if(_isArray){if(_i>=_iterator.length)break;_ref=_iterator[_i++];}else{_i=_iterator.next();if(_i.done)break;_ref=_i.value;}var _childRoute=_ref;var childRouter=childRouters[_childRoute.routeName];var childAction=action.routeName===_childRoute.routeName&&action.action?action.action:action;if(childRouter){var nextRouteState=childRouter.getStateForAction(childAction,_childRoute);if(nextRouteState===null||nextRouteState!==_childRoute){var newState=StateUtils.replaceAndPrune(state,nextRouteState?nextRouteState.key:_childRoute.key,nextRouteState?nextRouteState:_childRoute);return _objectSpread({},newState,{isTransitioning:state.index!==newState.index?action.immediate!==true:state.isTransitioning});}}}}if(behavesLikePushAction(action)&&childRouters[action.routeName]!==undefined){var _childRouter=childRouters[action.routeName];var _route;invariant(action.type!==StackActions.PUSH||action.key==null,'StackRouter does not support key on the push action');var lastRouteIndex=state.routes.findIndex(function(r){if(action.key){return r.key===action.key;}else{return r.routeName===action.routeName;}});if(action.type!==StackActions.PUSH&&lastRouteIndex!==-1){if(state.index===lastRouteIndex&&!action.params){return null;}var routes=state.routes.slice(0,lastRouteIndex+1);if(action.params){var _route2=state.routes[lastRouteIndex];routes[lastRouteIndex]=_objectSpread({},_route2,{params:_objectSpread({},_route2.params,action.params)});}return _objectSpread({},state,{isTransitioning:state.index!==lastRouteIndex?action.immediate!==true:state.isTransitioning,index:lastRouteIndex,routes:routes});}if(_childRouter){var _childAction=action.action||NavigationActions.init({params:getParamsForRouteAndAction(action.routeName,action)});_route=_objectSpread({params:getParamsForRouteAndAction(action.routeName,action)},_childRouter.getStateForAction(_childAction),{routeName:action.routeName,key:action.key||generateKey()});}else{_route={params:getParamsForRouteAndAction(action.routeName,action),routeName:action.routeName,key:action.key||generateKey()};}return _objectSpread({},StateUtils.push(state,_route),{isTransitioning:action.immediate!==true});}else if(action.type===StackActions.PUSH&&childRouters[action.routeName]===undefined){return state;}if(behavesLikePushAction(action)){var childRouterNames=Object.keys(childRouters);for(var i=0;i<childRouterNames.length;i++){var childRouterName=childRouterNames[i];var _childRouter2=childRouters[childRouterName];if(_childRouter2){var initChildRoute=_childRouter2.getStateForAction(NavigationActions.init());var navigatedChildRoute=_childRouter2.getStateForAction(action,initChildRoute);var routeToPush=null;if(navigatedChildRoute===null){routeToPush=initChildRoute;}else if(navigatedChildRoute!==initChildRoute){routeToPush=navigatedChildRoute;}if(routeToPush){var _route3=_objectSpread({},routeToPush,{routeName:childRouterName,key:action.key||generateKey()});return _objectSpread({},StateUtils.push(state,_route3),{isTransitioning:action.immediate!==true});}}}}if(action.type===StackActions.POP_TO_TOP){if(action.key&&state.key!==action.key){return state;}if(state.index>0){return _objectSpread({},state,{isTransitioning:action.immediate!==true,index:0,routes:[state.routes[0]]});}return state;}if(action.type===StackActions.REPLACE){var routeIndex;if(action.key===undefined&&state.routes.length){routeIndex=state.routes.length-1;}else{routeIndex=state.routes.findIndex(function(r){return r.key===action.key;});}if(routeIndex!==-1){var _childRouter3=childRouters[action.routeName];var childState={};if(_childRouter3){var _childAction2=action.action||NavigationActions.init({params:getParamsForRouteAndAction(action.routeName,action)});childState=_childRouter3.getStateForAction(_childAction2);}var _routes=_toConsumableArray(state.routes);_routes[routeIndex]=_objectSpread({params:getParamsForRouteAndAction(action.routeName,action)},childState,{routeName:action.routeName,key:action.newKey||generateKey()});return _objectSpread({},state,{routes:_routes});}}if(action.type===StackActions.COMPLETE_TRANSITION&&(action.key==null||action.key===state.key)&&action.toChildKey===state.routes[state.index].key&&state.isTransitioning){return _objectSpread({},state,{isTransitioning:false});}if(action.type===NavigationActions.SET_PARAMS){var key=action.key;var lastRoute=state.routes.find(function(route){return route.key===key;});if(lastRoute){var params=_objectSpread({},lastRoute.params,action.params);var _routes2=_toConsumableArray(state.routes);_routes2[state.routes.indexOf(lastRoute)]=_objectSpread({},lastRoute,{params:params});return _objectSpread({},state,{routes:_routes2});}}if(action.type===StackActions.RESET){if(action.key!=null&&action.key!=state.key){return state;}var newStackActions=action.actions;return _objectSpread({},state,{routes:newStackActions.map(function(newStackAction){var router=childRouters[newStackAction.routeName];var childState={};if(router){var _childAction3=newStackAction.action||NavigationActions.init({params:getParamsForRouteAndAction(newStackAction.routeName,newStackAction)});childState=router.getStateForAction(_childAction3);}return _objectSpread({params:getParamsForRouteAndAction(newStackAction.routeName,newStackAction)},childState,{routeName:newStackAction.routeName,key:newStackAction.key||generateKey()});}),index:action.index});}if(action.type===NavigationActions.BACK||action.type===StackActions.POP){var _key=action.key,n=action.n,immediate=action.immediate;var backRouteIndex=state.index;if(action.type===StackActions.POP&&n!=null){backRouteIndex=Math.max(1,state.index-n+1);}else if(_key){var backRoute=state.routes.find(function(route){return route.key===_key;});backRouteIndex=state.routes.indexOf(backRoute);}if(backRouteIndex>0){return _objectSpread({},state,{routes:state.routes.slice(0,backRouteIndex),index:backRouteIndex-1,isTransitioning:immediate!==true});}}var keyIndex=action.key?StateUtils.indexOf(state,action.key):-1;for(var _iterator2=state.routes.slice().reverse(),_isArray2=Array.isArray(_iterator2),_i2=0,_iterator2=_isArray2?_iterator2:_iterator2[typeof Symbol==="function"?Symbol.iterator:"@@iterator"]();;){var _ref2;if(_isArray2){if(_i2>=_iterator2.length)break;_ref2=_iterator2[_i2++];}else{_i2=_iterator2.next();if(_i2.done)break;_ref2=_i2.value;}var _childRoute3=_ref2;if(_childRoute3.key===activeChildRoute.key){continue;}if(keyIndex>=0&&_childRoute3.key!==action.key){continue;}var _childRouter5=childRouters[_childRoute3.routeName];if(_childRouter5){var _route4=_childRouter5.getStateForAction(action,_childRoute3);if(_route4===null){return state;}else if(_route4&&_route4!==_childRoute3){return StateUtils.replaceAt(state,_childRoute3.key,_route4,action.preserveFocus||action.type.includes('DRAWER'));}}}return state;},getPathAndParamsForState:function getPathAndParamsForState(state){var route=state.routes[state.index];return getPathAndParamsForRoute(route);},getActionForPathAndParams:function getActionForPathAndParams(path,params){return _getActionForPathAndParams(path,params);},getScreenOptions:createConfigGetter(routeConfigs,stackConfig.defaultNavigationOptions)};});
//# sourceMappingURL=StackRouter.js.map