# Description

Relates to issue: **ZEUS-0000**

_Please enter a description and screenshots, if appropriate, of the work covered in this PR_

This pull request is categorized as a:

- [ ] New feature
- [ ] Bug fix
- [ ] Code refactor
- [ ] Configuration change
- [ ] Locales update
- [ ] Other

## Checklist
- [ ] I’ve run `npm run tsc` and make sure my code didn’t produce errors 
- [ ] I’ve run `npm run prettier` and formatted my code correctly

## Testing

If you added new functionality or fixed a bug, did you add new unit tests?

- [ ] No, I’m a fool
- [ ] Yes
- [ ] N/A

I have tested this PR on the following platforms (please specify OS version and phone model/VM):

- [ ] Android
- [ ] iOS

I have tested this PR with the following types of nodes (please specify node version and API version where appropriate):

- [ ] LND
- [ ] c-lightning-REST
- [ ] spark
- [ ] Eclair
- [ ] LndHub

### Locales
- [ ] I’ve added new locale text that requires translations
- [ ] I’m aware that new translations should be made on the Zeus [Transfix page](https://www.transifex.com/ZeusLN/zeus/) and not directly to this repo

### Third Party Dependencies and Packages

- [ ] Contributors will need to run `npm install` after this PR is merged in
- [ ] 3rd party dependencies have been modified:
    * verify that `package.json` and `package-lock.json` have been properly updated
    * verify that dependencies are installed for both iOS and Android platforms

### Other:

- [ ] Changes were made that require an update to the README
- [ ] Changes were made that require an update to onboarding
