import CSSStyleDeclaration from '../../css/declaration/CSSStyleDeclaration.cjs';
import * as PropertySymbol from '../../PropertySymbol.cjs';
import Element from '../element/Element.cjs';
import SVGSVGElement from '../svg-svg-element/SVGSVGElement.cjs';
import Event from '../../event/Event.cjs';
import DOMStringMap from '../../dom/DOMStringMap.cjs';
/**
 * SVG Element.
 *
 * Reference:
 * https://developer.mozilla.org/en-US/docs/Web/API/SVGElement.
 */
export default class SVGElement extends Element {
    #private;
    onabort: (event: Event) => void | null;
    onerror: (event: Event) => void | null;
    onload: (event: Event) => void | null;
    onresize: (event: Event) => void | null;
    onscroll: (event: Event) => void | null;
    onunload: (event: Event) => void | null;
    [PropertySymbol.style]: CSSStyleDeclaration | null;
    /**
     * Returns current translate.
     *
     * @returns Element.
     */
    get ownerSVGElement(): SVGSVGElement | null;
    /**
     * Returns the SVGElement which established the current viewport. Often the nearest ancestor <svg> element. null if the given element is the outermost <svg> element.
     *
     * @returns SVG element.
     */
    get viewportElement(): SVGElement | null;
    /**
     * Returns data set.
     *
     * @returns Data set.
     */
    get dataset(): DOMStringMap;
    /**
     * Returns style.
     *
     * @returns Style.
     */
    get style(): CSSStyleDeclaration;
    /**
     * Returns tab index.
     *
     * @returns Tab index.
     */
    get tabIndex(): number;
    /**
     * Returns tab index.
     *
     * @param tabIndex Tab index.
     */
    set tabIndex(tabIndex: number);
    /**
     * Triggers a blur event.
     */
    blur(): void;
    /**
     * Triggers a focus event.
     */
    focus(): void;
}
//# sourceMappingURL=SVGElement.d.ts.map