import ErrorEvent from '../../event/events/ErrorEvent.cjs';
import Event from '../../event/Event.cjs';
import HTMLElement from '../html-element/HTMLElement.cjs';
import TimeRanges from './TimeRanges.cjs';
import DOMTokenList from '../../dom/DOMTokenList.cjs';
import RemotePlayback from './RemotePlayback.cjs';
import MediaStream from './MediaStream.cjs';
import TextTrackList from './TextTrackList.cjs';
import TextTrack from './TextTrack.cjs';
import TextTrackKindEnum from './TextTrackKindEnum.cjs';
import * as PropertySymbol from '../../PropertySymbol.cjs';
interface IMediaError {
    code: number;
    message: string;
}
/**
 * HTML Media Element.
 *
 * Reference:
 * https://developer.mozilla.org/en-US/docs/Web/API/HTMLMediaElement
 *
 */
export default class HTMLMediaElement extends HTMLElement {
    cloneNode: (deep?: boolean) => HTMLMediaElement;
    onabort: (event: Event) => void | null;
    oncanplay: (event: Event) => void | null;
    oncanplaythrough: (event: Event) => void | null;
    ondurationchange: (event: Event) => void | null;
    onemptied: (event: Event) => void | null;
    onended: (event: Event) => void | null;
    onerror: (event: ErrorEvent) => void | null;
    onloadeddata: (event: Event) => void | null;
    onloadedmetadata: (event: Event) => void | null;
    onloadstart: (event: Event) => void | null;
    onpause: (event: Event) => void | null;
    onplay: (event: Event) => void | null;
    onplaying: (event: Event) => void | null;
    onprogress: (event: Event) => void | null;
    onratechange: (event: Event) => void | null;
    onresize: (event: Event) => void | null;
    onseeked: (event: Event) => void | null;
    onseeking: (event: Event) => void | null;
    onstalled: (event: Event) => void | null;
    onsuspend: (event: Event) => void | null;
    ontimeupdate: (event: Event) => void | null;
    onvolumechange: (event: Event) => void | null;
    onwaiting: (event: Event) => void | null;
    [PropertySymbol.volume]: number;
    [PropertySymbol.paused]: boolean;
    [PropertySymbol.currentTime]: number;
    [PropertySymbol.playbackRate]: number;
    [PropertySymbol.defaultPlaybackRate]: number;
    [PropertySymbol.muted]: boolean;
    [PropertySymbol.defaultMuted]: boolean;
    [PropertySymbol.preservesPitch]: boolean;
    [PropertySymbol.buffered]: TimeRanges;
    [PropertySymbol.duration]: number;
    [PropertySymbol.error]: IMediaError;
    [PropertySymbol.ended]: boolean;
    [PropertySymbol.networkState]: number;
    [PropertySymbol.readyState]: number;
    [PropertySymbol.seeking]: boolean;
    [PropertySymbol.seekable]: TimeRanges;
    [PropertySymbol.sinkId]: string;
    [PropertySymbol.played]: TimeRanges;
    [PropertySymbol.remote]: RemotePlayback;
    [PropertySymbol.controlsList]: DOMTokenList | null;
    [PropertySymbol.mediaKeys]: object | null;
    [PropertySymbol.srcObject]: MediaStream | null;
    [PropertySymbol.textTracks]: TextTrack[];
    /**
     * Returns buffered.
     *
     * @returns Buffered.
     */
    get buffered(): TimeRanges;
    /**
     * Returns duration.
     *
     * @returns Duration.
     */
    get duration(): number;
    /**
     * Returns error.
     *
     * @returns Error.
     */
    get error(): IMediaError;
    /**
     * Returns ended.
     *
     * @returns Ended.
     */
    get ended(): boolean;
    /**
     * Returns networkState.
     *
     * @returns NetworkState.
     */
    get networkState(): number;
    /**
     * Returns readyState.
     *
     * @returns ReadyState.
     */
    get readyState(): number;
    /**
     * Return a RemotePlayback object instance associated with the media element.
     *
     * @returns RemotePlayback.
     */
    get remote(): RemotePlayback;
    /**
     * Returns seeking.
     *
     * @returns Seeking.
     */
    get seeking(): boolean;
    /**
     * Returns seekable.
     *
     * @returns Seekable.
     */
    get seekable(): TimeRanges;
    /**
     * Returns sinkId.
     *
     * @returns SinkId.
     */
    get sinkId(): string;
    /**
     * Returns played.
     *
     * @returns Played.
     */
    get played(): TimeRanges;
    /**
     * Returns autoplay.
     *
     * @returns Autoplay.
     */
    get autoplay(): boolean;
    /**
     * Sets autoplay.
     *
     * @param autoplay Autoplay.
     */
    set autoplay(autoplay: boolean);
    /**
     * Returns controls.
     *
     * @returns Controls.
     */
    get controls(): boolean;
    /**
     * Sets controls.
     *
     * @param controls Controls.
     */
    set controls(controls: boolean);
    /**
     * Returns loop.
     *
     * @returns Loop.
     */
    get loop(): boolean;
    /**
     * Sets loop.
     *
     * @param loop Loop.
     */
    set loop(loop: boolean);
    /**
     * Returns preload.
     *
     * @returns preload.
     */
    get preload(): string;
    /**
     * Sets preload.
     *
     * @param preload preload.
     */
    set preload(preload: string);
    /**
     * Returns src.
     *
     * @returns Src.
     */
    get src(): string;
    /**
     * Sets src.
     *
     * @param src Src.
     */
    set src(src: string);
    /**
     * Returns controlsList.
     *
     * @returns ControlsList.
     */
    get controlsList(): DOMTokenList;
    /**
     * Returns mediaKeys.
     *
     * @returns MediaKeys.
     */
    get mediaKeys(): object | null;
    /**
     * Returns muted.
     *
     * @returns Muted.
     */
    get muted(): boolean;
    /**
     * Sets muted.
     *
     * @param muted Muted.
     */
    set muted(muted: boolean);
    /**
     * Returns defaultMuted.
     *
     * @returns DefaultMuted.
     */
    get defaultMuted(): boolean;
    /**
     * Sets defaultMuted.
     *
     * @param defaultMuted DefaultMuted.
     */
    set defaultMuted(defaultMuted: boolean);
    /**
     * Returns disableRemotePlayback.
     *
     * @returns DisableRemotePlayback.
     */
    get disableRemotePlayback(): boolean;
    /**
     * Sets disableRemotePlayback.
     *
     * @param disableRemotePlayback DisableRemotePlayback.
     */
    set disableRemotePlayback(disableRemotePlayback: boolean);
    /**
     * A MediaStream representing the media to play or that has played in the current HTMLMediaElement, or null if not assigned.
     *
     * @returns MediaStream.
     */
    get srcObject(): MediaStream | null;
    /**
     * Sets src object.
     *
     * @param srcObject SrcObject.
     */
    set srcObject(srcObject: MediaStream | null);
    /**
     * Returns text track list.
     *
     * @returns Text track list.
     */
    get textTracks(): TextTrackList;
    /**
     * Returns currentSrc.
     *
     * @returns CurrentrSrc.
     */
    get currentSrc(): string;
    /**
     * Returns volume.
     *
     * @returns Volume.
     */
    get volume(): number;
    /**
     * Sets volume.
     *
     * @param volume Volume.
     */
    set volume(volume: number | string);
    /**
     * Returns crossOrigin.
     *
     * @returns CrossOrigin.
     */
    get crossOrigin(): string;
    /**
     * Sets crossOrigin.
     *
     * @param crossOrigin CrossOrigin.
     */
    set crossOrigin(crossOrigin: string | null);
    /**
     * Returns currentTime.
     *
     * @returns CurrentTime.
     */
    get currentTime(): number;
    /**
     * Sets currentTime.
     *
     * @param currentTime CurrentTime.
     */
    set currentTime(currentTime: number | string);
    /**
     * Returns playbackRate.
     *
     * @returns PlaybackRate.
     */
    get playbackRate(): number;
    /**
     * Sets playbackRate.
     *
     * @param playbackRate PlaybackRate.
     */
    set playbackRate(playbackRate: number | string);
    /**
     * Returns defaultPlaybackRate.
     *
     * @returns DefaultPlaybackRate.
     */
    get defaultPlaybackRate(): number;
    /**
     * Sets defaultPlaybackRate.
     *
     * @param defaultPlaybackRate DefaultPlaybackRate.
     */
    set defaultPlaybackRate(defaultPlaybackRate: number | string);
    /**
     * Returns preservesPitch.
     *
     * @returns PlaybackRate.
     */
    get preservesPitch(): boolean;
    /**
     * Sets preservesPitch.
     *
     * @param preservesPitch PreservesPitch.
     */
    set preservesPitch(preservesPitch: boolean);
    /**
     * Returns paused.
     *
     * @returns Paused.
     */
    get paused(): boolean;
    /**
     * Adds a new text track to the media element.
     *
     * @param kind The kind of text track.
     * @param label The label of the text track.
     * @param language The language of the text track data.
     */
    addTextTrack(kind: TextTrackKindEnum, label?: string, language?: string): TextTrack;
    /**
     * Pause played media.
     */
    pause(): void;
    /**
     * Start playing media.
     */
    play(): Promise<void>;
    /**
     * Reports how likely it is that the current browser will be able to play media of a given MIME type.
     *
     * @param _type MIME type.
     * @returns Can play type.
     */
    canPlayType(_type: string): string;
    /**
     * Quickly seeks the media to the new time with precision tradeoff.
     *
     * @param _time Time.
     */
    fastSeek(_time: number): void;
    /**
     * Load media.
     */
    load(): void;
    /**
     * Sets media keys.
     *
     * @param mediaKeys MediaKeys.
     * @returns Promise.
     */
    setMediaKeys(mediaKeys: object | null): Promise<void>;
    /**
     * Sets sink id.
     *
     * @param sinkId SinkId.
     * @returns Promise.
     */
    setSinkId(sinkId: string): Promise<void>;
    /**
     * Returns MediaStream, captures a stream of the media content.
     *
     * @returns MediaStream.
     */
    captureStream(): MediaStream;
    /**
     * @override
     */
    [PropertySymbol.cloneNode](deep?: boolean): HTMLMediaElement;
}
export {};
//# sourceMappingURL=HTMLMediaElement.d.ts.map