import Event from '../../event/Event.cjs';
import HTMLElement from '../html-element/HTMLElement.cjs';
import * as PropertySymbol from '../../PropertySymbol.cjs';
import Attr from '../attr/Attr.cjs';
/**
 * HTMLDetailsElement
 *
 * @see https://developer.mozilla.org/en-US/docs/Web/API/HTMLDetailsElement
 */
export default class HTMLDetailsElement extends HTMLElement {
    ontoggle: (event: Event) => void | null;
    /**
     * Returns the open attribute.
     */
    get open(): boolean;
    /**
     * Sets the open attribute.
     *
     * @param open New value.
     */
    set open(open: boolean);
    /**
     * @override
     */
    [PropertySymbol.onSetAttribute](attribute: Attr, replacedAttribute: Attr | null): void;
    /**
     * @override
     */
    [PropertySymbol.onRemoveAttribute](removedAttribute: Attr): void;
    /**
     * @override
     */
    dispatchEvent(event: Event): boolean;
}
//# sourceMappingURL=HTMLDetailsElement.d.ts.map