/*!
 Stencil CLI v4.27.2 | MIT Licensed | https://stenciljs.com
 */
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __require = /* @__PURE__ */ ((x) => typeof require !== "undefined" ? require : typeof Proxy !== "undefined" ? new Proxy(x, {
  get: (a, b) => (typeof require !== "undefined" ? require : a)[b]
}) : x)(function(x) {
  if (typeof require !== "undefined") return require.apply(this, arguments);
  throw Error('Dynamic require of "' + x + '" is not supported');
});
var __commonJS = (cb, mod) => function __require2() {
  return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));

// node_modules/kleur/index.js
var require_kleur = __commonJS({
  "node_modules/kleur/index.js"(exports, module) {
    "use strict";
    var { FORCE_COLOR, NODE_DISABLE_COLORS, TERM } = process.env;
    var $ = {
      enabled: !NODE_DISABLE_COLORS && TERM !== "dumb" && FORCE_COLOR !== "0",
      // modifiers
      reset: init(0, 0),
      bold: init(1, 22),
      dim: init(2, 22),
      italic: init(3, 23),
      underline: init(4, 24),
      inverse: init(7, 27),
      hidden: init(8, 28),
      strikethrough: init(9, 29),
      // colors
      black: init(30, 39),
      red: init(31, 39),
      green: init(32, 39),
      yellow: init(33, 39),
      blue: init(34, 39),
      magenta: init(35, 39),
      cyan: init(36, 39),
      white: init(37, 39),
      gray: init(90, 39),
      grey: init(90, 39),
      // background colors
      bgBlack: init(40, 49),
      bgRed: init(41, 49),
      bgGreen: init(42, 49),
      bgYellow: init(43, 49),
      bgBlue: init(44, 49),
      bgMagenta: init(45, 49),
      bgCyan: init(46, 49),
      bgWhite: init(47, 49)
    };
    function run2(arr, str) {
      let i = 0, tmp, beg = "", end = "";
      for (; i < arr.length; i++) {
        tmp = arr[i];
        beg += tmp.open;
        end += tmp.close;
        if (str.includes(tmp.close)) {
          str = str.replace(tmp.rgx, tmp.close + tmp.open);
        }
      }
      return beg + str + end;
    }
    function chain(has, keys) {
      let ctx = { has, keys };
      ctx.reset = $.reset.bind(ctx);
      ctx.bold = $.bold.bind(ctx);
      ctx.dim = $.dim.bind(ctx);
      ctx.italic = $.italic.bind(ctx);
      ctx.underline = $.underline.bind(ctx);
      ctx.inverse = $.inverse.bind(ctx);
      ctx.hidden = $.hidden.bind(ctx);
      ctx.strikethrough = $.strikethrough.bind(ctx);
      ctx.black = $.black.bind(ctx);
      ctx.red = $.red.bind(ctx);
      ctx.green = $.green.bind(ctx);
      ctx.yellow = $.yellow.bind(ctx);
      ctx.blue = $.blue.bind(ctx);
      ctx.magenta = $.magenta.bind(ctx);
      ctx.cyan = $.cyan.bind(ctx);
      ctx.white = $.white.bind(ctx);
      ctx.gray = $.gray.bind(ctx);
      ctx.grey = $.grey.bind(ctx);
      ctx.bgBlack = $.bgBlack.bind(ctx);
      ctx.bgRed = $.bgRed.bind(ctx);
      ctx.bgGreen = $.bgGreen.bind(ctx);
      ctx.bgYellow = $.bgYellow.bind(ctx);
      ctx.bgBlue = $.bgBlue.bind(ctx);
      ctx.bgMagenta = $.bgMagenta.bind(ctx);
      ctx.bgCyan = $.bgCyan.bind(ctx);
      ctx.bgWhite = $.bgWhite.bind(ctx);
      return ctx;
    }
    function init(open, close) {
      let blk = {
        open: `\x1B[${open}m`,
        close: `\x1B[${close}m`,
        rgx: new RegExp(`\\x1b\\[${close}m`, "g")
      };
      return function(txt) {
        if (this !== void 0 && this.has !== void 0) {
          this.has.includes(open) || (this.has.push(open), this.keys.push(blk));
          return txt === void 0 ? this : $.enabled ? run2(this.keys, txt + "") : txt + "";
        }
        return txt === void 0 ? chain([open], [blk]) : $.enabled ? run2([blk], txt + "") : txt + "";
      };
    }
    module.exports = $;
  }
});

// node_modules/prompts/lib/util/action.js
var require_action = __commonJS({
  "node_modules/prompts/lib/util/action.js"(exports, module) {
    "use strict";
    module.exports = (key, isSelect) => {
      if (key.meta && key.name !== "escape") return;
      if (key.ctrl) {
        if (key.name === "a") return "first";
        if (key.name === "c") return "abort";
        if (key.name === "d") return "abort";
        if (key.name === "e") return "last";
        if (key.name === "g") return "reset";
      }
      if (isSelect) {
        if (key.name === "j") return "down";
        if (key.name === "k") return "up";
      }
      if (key.name === "return") return "submit";
      if (key.name === "enter") return "submit";
      if (key.name === "backspace") return "delete";
      if (key.name === "delete") return "deleteForward";
      if (key.name === "abort") return "abort";
      if (key.name === "escape") return "exit";
      if (key.name === "tab") return "next";
      if (key.name === "pagedown") return "nextPage";
      if (key.name === "pageup") return "prevPage";
      if (key.name === "home") return "home";
      if (key.name === "end") return "end";
      if (key.name === "up") return "up";
      if (key.name === "down") return "down";
      if (key.name === "right") return "right";
      if (key.name === "left") return "left";
      return false;
    };
  }
});

// node_modules/prompts/lib/util/strip.js
var require_strip = __commonJS({
  "node_modules/prompts/lib/util/strip.js"(exports, module) {
    "use strict";
    module.exports = (str) => {
      const pattern = [
        "[\\u001B\\u009B][[\\]()#;?]*(?:(?:(?:(?:;[-a-zA-Z\\d\\/#&.:=?%@~_]+)*|[a-zA-Z\\d]+(?:;[-a-zA-Z\\d\\/#&.:=?%@~_]*)*)?\\u0007)",
        "(?:(?:\\d{1,4}(?:;\\d{0,4})*)?[\\dA-PRZcf-ntqry=><~]))"
      ].join("|");
      const RGX = new RegExp(pattern, "g");
      return typeof str === "string" ? str.replace(RGX, "") : str;
    };
  }
});

// node_modules/sisteransi/src/index.js
var require_src = __commonJS({
  "node_modules/sisteransi/src/index.js"(exports, module) {
    "use strict";
    var ESC = "\x1B";
    var CSI = `${ESC}[`;
    var beep = "\x07";
    var cursor = {
      to(x, y) {
        if (!y) return `${CSI}${x + 1}G`;
        return `${CSI}${y + 1};${x + 1}H`;
      },
      move(x, y) {
        let ret = "";
        if (x < 0) ret += `${CSI}${-x}D`;
        else if (x > 0) ret += `${CSI}${x}C`;
        if (y < 0) ret += `${CSI}${-y}A`;
        else if (y > 0) ret += `${CSI}${y}B`;
        return ret;
      },
      up: (count = 1) => `${CSI}${count}A`,
      down: (count = 1) => `${CSI}${count}B`,
      forward: (count = 1) => `${CSI}${count}C`,
      backward: (count = 1) => `${CSI}${count}D`,
      nextLine: (count = 1) => `${CSI}E`.repeat(count),
      prevLine: (count = 1) => `${CSI}F`.repeat(count),
      left: `${CSI}G`,
      hide: `${CSI}?25l`,
      show: `${CSI}?25h`,
      save: `${ESC}7`,
      restore: `${ESC}8`
    };
    var scroll = {
      up: (count = 1) => `${CSI}S`.repeat(count),
      down: (count = 1) => `${CSI}T`.repeat(count)
    };
    var erase = {
      screen: `${CSI}2J`,
      up: (count = 1) => `${CSI}1J`.repeat(count),
      down: (count = 1) => `${CSI}J`.repeat(count),
      line: `${CSI}2K`,
      lineEnd: `${CSI}K`,
      lineStart: `${CSI}1K`,
      lines(count) {
        let clear = "";
        for (let i = 0; i < count; i++)
          clear += this.line + (i < count - 1 ? cursor.up() : "");
        if (count)
          clear += cursor.left;
        return clear;
      }
    };
    module.exports = { cursor, scroll, erase, beep };
  }
});

// node_modules/prompts/lib/util/clear.js
var require_clear = __commonJS({
  "node_modules/prompts/lib/util/clear.js"(exports, module) {
    "use strict";
    var strip = require_strip();
    var { erase, cursor } = require_src();
    var width = (str) => [...strip(str)].length;
    module.exports = function(prompt, perLine) {
      if (!perLine) return erase.line + cursor.to(0);
      let rows = 0;
      const lines = prompt.split(/\r?\n/);
      for (let line of lines) {
        rows += 1 + Math.floor(Math.max(width(line) - 1, 0) / perLine);
      }
      return erase.lines(rows);
    };
  }
});

// node_modules/prompts/lib/util/figures.js
var require_figures = __commonJS({
  "node_modules/prompts/lib/util/figures.js"(exports, module) {
    "use strict";
    var main = {
      arrowUp: "\u2191",
      arrowDown: "\u2193",
      arrowLeft: "\u2190",
      arrowRight: "\u2192",
      radioOn: "\u25C9",
      radioOff: "\u25EF",
      tick: "\u2714",
      cross: "\u2716",
      ellipsis: "\u2026",
      pointerSmall: "\u203A",
      line: "\u2500",
      pointer: "\u276F"
    };
    var win = {
      arrowUp: main.arrowUp,
      arrowDown: main.arrowDown,
      arrowLeft: main.arrowLeft,
      arrowRight: main.arrowRight,
      radioOn: "(*)",
      radioOff: "( )",
      tick: "\u221A",
      cross: "\xD7",
      ellipsis: "...",
      pointerSmall: "\xBB",
      line: "\u2500",
      pointer: ">"
    };
    var figures = process.platform === "win32" ? win : main;
    module.exports = figures;
  }
});

// node_modules/prompts/lib/util/style.js
var require_style = __commonJS({
  "node_modules/prompts/lib/util/style.js"(exports, module) {
    "use strict";
    var c = require_kleur();
    var figures = require_figures();
    var styles = Object.freeze({
      password: { scale: 1, render: (input) => "*".repeat(input.length) },
      emoji: { scale: 2, render: (input) => "\u{1F603}".repeat(input.length) },
      invisible: { scale: 0, render: (input) => "" },
      default: { scale: 1, render: (input) => `${input}` }
    });
    var render = (type) => styles[type] || styles.default;
    var symbols = Object.freeze({
      aborted: c.red(figures.cross),
      done: c.green(figures.tick),
      exited: c.yellow(figures.cross),
      default: c.cyan("?")
    });
    var symbol = (done, aborted, exited) => aborted ? symbols.aborted : exited ? symbols.exited : done ? symbols.done : symbols.default;
    var delimiter = (completing) => c.gray(completing ? figures.ellipsis : figures.pointerSmall);
    var item = (expandable, expanded) => c.gray(expandable ? expanded ? figures.pointerSmall : "+" : figures.line);
    module.exports = {
      styles,
      render,
      symbols,
      symbol,
      delimiter,
      item
    };
  }
});

// node_modules/prompts/lib/util/lines.js
var require_lines = __commonJS({
  "node_modules/prompts/lib/util/lines.js"(exports, module) {
    "use strict";
    var strip = require_strip();
    module.exports = function(msg, perLine) {
      let lines = String(strip(msg) || "").split(/\r?\n/);
      if (!perLine) return lines.length;
      return lines.map((l) => Math.ceil(l.length / perLine)).reduce((a, b) => a + b);
    };
  }
});

// node_modules/prompts/lib/util/wrap.js
var require_wrap = __commonJS({
  "node_modules/prompts/lib/util/wrap.js"(exports, module) {
    "use strict";
    module.exports = (msg, opts = {}) => {
      const tab = Number.isSafeInteger(parseInt(opts.margin)) ? new Array(parseInt(opts.margin)).fill(" ").join("") : opts.margin || "";
      const width = opts.width;
      return (msg || "").split(/\r?\n/g).map((line) => line.split(/\s+/g).reduce((arr, w) => {
        if (w.length + tab.length >= width || arr[arr.length - 1].length + w.length + 1 < width)
          arr[arr.length - 1] += ` ${w}`;
        else arr.push(`${tab}${w}`);
        return arr;
      }, [tab]).join("\n")).join("\n");
    };
  }
});

// node_modules/prompts/lib/util/entriesToDisplay.js
var require_entriesToDisplay = __commonJS({
  "node_modules/prompts/lib/util/entriesToDisplay.js"(exports, module) {
    "use strict";
    module.exports = (cursor, total, maxVisible) => {
      maxVisible = maxVisible || total;
      let startIndex = Math.min(total - maxVisible, cursor - Math.floor(maxVisible / 2));
      if (startIndex < 0) startIndex = 0;
      let endIndex = Math.min(startIndex + maxVisible, total);
      return { startIndex, endIndex };
    };
  }
});

// node_modules/prompts/lib/util/index.js
var require_util = __commonJS({
  "node_modules/prompts/lib/util/index.js"(exports, module) {
    "use strict";
    module.exports = {
      action: require_action(),
      clear: require_clear(),
      style: require_style(),
      strip: require_strip(),
      figures: require_figures(),
      lines: require_lines(),
      wrap: require_wrap(),
      entriesToDisplay: require_entriesToDisplay()
    };
  }
});

// node_modules/prompts/lib/elements/prompt.js
var require_prompt = __commonJS({
  "node_modules/prompts/lib/elements/prompt.js"(exports, module) {
    "use strict";
    var readline = __require("readline");
    var { action } = require_util();
    var EventEmitter = __require("events");
    var { beep, cursor } = require_src();
    var color = require_kleur();
    var Prompt = class extends EventEmitter {
      constructor(opts = {}) {
        super();
        this.firstRender = true;
        this.in = opts.stdin || process.stdin;
        this.out = opts.stdout || process.stdout;
        this.onRender = (opts.onRender || (() => void 0)).bind(this);
        const rl = readline.createInterface({ input: this.in, escapeCodeTimeout: 50 });
        readline.emitKeypressEvents(this.in, rl);
        if (this.in.isTTY) this.in.setRawMode(true);
        const isSelect = ["SelectPrompt", "MultiselectPrompt"].indexOf(this.constructor.name) > -1;
        const keypress = (str, key) => {
          let a = action(key, isSelect);
          if (a === false) {
            this._ && this._(str, key);
          } else if (typeof this[a] === "function") {
            this[a](key);
          } else {
            this.bell();
          }
        };
        this.close = () => {
          this.out.write(cursor.show);
          this.in.removeListener("keypress", keypress);
          if (this.in.isTTY) this.in.setRawMode(false);
          rl.close();
          this.emit(this.aborted ? "abort" : this.exited ? "exit" : "submit", this.value);
          this.closed = true;
        };
        this.in.on("keypress", keypress);
      }
      fire() {
        this.emit("state", {
          value: this.value,
          aborted: !!this.aborted,
          exited: !!this.exited
        });
      }
      bell() {
        this.out.write(beep);
      }
      render() {
        this.onRender(color);
        if (this.firstRender) this.firstRender = false;
      }
    };
    module.exports = Prompt;
  }
});

// node_modules/prompts/lib/elements/text.js
var require_text = __commonJS({
  "node_modules/prompts/lib/elements/text.js"(exports, module) {
    var color = require_kleur();
    var Prompt = require_prompt();
    var { erase, cursor } = require_src();
    var { style, clear, lines, figures } = require_util();
    var TextPrompt = class extends Prompt {
      constructor(opts = {}) {
        super(opts);
        this.transform = style.render(opts.style);
        this.scale = this.transform.scale;
        this.msg = opts.message;
        this.initial = opts.initial || ``;
        this.validator = opts.validate || (() => true);
        this.value = ``;
        this.errorMsg = opts.error || `Please Enter A Valid Value`;
        this.cursor = Number(!!this.initial);
        this.cursorOffset = 0;
        this.clear = clear(``, this.out.columns);
        this.render();
      }
      set value(v) {
        if (!v && this.initial) {
          this.placeholder = true;
          this.rendered = color.gray(this.transform.render(this.initial));
        } else {
          this.placeholder = false;
          this.rendered = this.transform.render(v);
        }
        this._value = v;
        this.fire();
      }
      get value() {
        return this._value;
      }
      reset() {
        this.value = ``;
        this.cursor = Number(!!this.initial);
        this.cursorOffset = 0;
        this.fire();
        this.render();
      }
      exit() {
        this.abort();
      }
      abort() {
        this.value = this.value || this.initial;
        this.done = this.aborted = true;
        this.error = false;
        this.red = false;
        this.fire();
        this.render();
        this.out.write("\n");
        this.close();
      }
      async validate() {
        let valid = await this.validator(this.value);
        if (typeof valid === `string`) {
          this.errorMsg = valid;
          valid = false;
        }
        this.error = !valid;
      }
      async submit() {
        this.value = this.value || this.initial;
        this.cursorOffset = 0;
        this.cursor = this.rendered.length;
        await this.validate();
        if (this.error) {
          this.red = true;
          this.fire();
          this.render();
          return;
        }
        this.done = true;
        this.aborted = false;
        this.fire();
        this.render();
        this.out.write("\n");
        this.close();
      }
      next() {
        if (!this.placeholder) return this.bell();
        this.value = this.initial;
        this.cursor = this.rendered.length;
        this.fire();
        this.render();
      }
      moveCursor(n) {
        if (this.placeholder) return;
        this.cursor = this.cursor + n;
        this.cursorOffset += n;
      }
      _(c, key) {
        let s1 = this.value.slice(0, this.cursor);
        let s2 = this.value.slice(this.cursor);
        this.value = `${s1}${c}${s2}`;
        this.red = false;
        this.cursor = this.placeholder ? 0 : s1.length + 1;
        this.render();
      }
      delete() {
        if (this.isCursorAtStart()) return this.bell();
        let s1 = this.value.slice(0, this.cursor - 1);
        let s2 = this.value.slice(this.cursor);
        this.value = `${s1}${s2}`;
        this.red = false;
        if (this.isCursorAtStart()) {
          this.cursorOffset = 0;
        } else {
          this.cursorOffset++;
          this.moveCursor(-1);
        }
        this.render();
      }
      deleteForward() {
        if (this.cursor * this.scale >= this.rendered.length || this.placeholder) return this.bell();
        let s1 = this.value.slice(0, this.cursor);
        let s2 = this.value.slice(this.cursor + 1);
        this.value = `${s1}${s2}`;
        this.red = false;
        if (this.isCursorAtEnd()) {
          this.cursorOffset = 0;
        } else {
          this.cursorOffset++;
        }
        this.render();
      }
      first() {
        this.cursor = 0;
        this.render();
      }
      last() {
        this.cursor = this.value.length;
        this.render();
      }
      left() {
        if (this.cursor <= 0 || this.placeholder) return this.bell();
        this.moveCursor(-1);
        this.render();
      }
      right() {
        if (this.cursor * this.scale >= this.rendered.length || this.placeholder) return this.bell();
        this.moveCursor(1);
        this.render();
      }
      isCursorAtStart() {
        return this.cursor === 0 || this.placeholder && this.cursor === 1;
      }
      isCursorAtEnd() {
        return this.cursor === this.rendered.length || this.placeholder && this.cursor === this.rendered.length + 1;
      }
      render() {
        if (this.closed) return;
        if (!this.firstRender) {
          if (this.outputError)
            this.out.write(cursor.down(lines(this.outputError, this.out.columns) - 1) + clear(this.outputError, this.out.columns));
          this.out.write(clear(this.outputText, this.out.columns));
        }
        super.render();
        this.outputError = "";
        this.outputText = [
          style.symbol(this.done, this.aborted),
          color.bold(this.msg),
          style.delimiter(this.done),
          this.red ? color.red(this.rendered) : this.rendered
        ].join(` `);
        if (this.error) {
          this.outputError += this.errorMsg.split(`
`).reduce((a, l, i) => a + `
${i ? " " : figures.pointerSmall} ${color.red().italic(l)}`, ``);
        }
        this.out.write(erase.line + cursor.to(0) + this.outputText + cursor.save + this.outputError + cursor.restore + cursor.move(this.cursorOffset, 0));
      }
    };
    module.exports = TextPrompt;
  }
});

// node_modules/prompts/lib/elements/select.js
var require_select = __commonJS({
  "node_modules/prompts/lib/elements/select.js"(exports, module) {
    "use strict";
    var color = require_kleur();
    var Prompt = require_prompt();
    var { style, clear, figures, wrap, entriesToDisplay } = require_util();
    var { cursor } = require_src();
    var SelectPrompt = class extends Prompt {
      constructor(opts = {}) {
        super(opts);
        this.msg = opts.message;
        this.hint = opts.hint || "- Use arrow-keys. Return to submit.";
        this.warn = opts.warn || "- This option is disabled";
        this.cursor = opts.initial || 0;
        this.choices = opts.choices.map((ch, idx) => {
          if (typeof ch === "string")
            ch = { title: ch, value: idx };
          return {
            title: ch && (ch.title || ch.value || ch),
            value: ch && (ch.value === void 0 ? idx : ch.value),
            description: ch && ch.description,
            selected: ch && ch.selected,
            disabled: ch && ch.disabled
          };
        });
        this.optionsPerPage = opts.optionsPerPage || 10;
        this.value = (this.choices[this.cursor] || {}).value;
        this.clear = clear("", this.out.columns);
        this.render();
      }
      moveCursor(n) {
        this.cursor = n;
        this.value = this.choices[n].value;
        this.fire();
      }
      reset() {
        this.moveCursor(0);
        this.fire();
        this.render();
      }
      exit() {
        this.abort();
      }
      abort() {
        this.done = this.aborted = true;
        this.fire();
        this.render();
        this.out.write("\n");
        this.close();
      }
      submit() {
        if (!this.selection.disabled) {
          this.done = true;
          this.aborted = false;
          this.fire();
          this.render();
          this.out.write("\n");
          this.close();
        } else
          this.bell();
      }
      first() {
        this.moveCursor(0);
        this.render();
      }
      last() {
        this.moveCursor(this.choices.length - 1);
        this.render();
      }
      up() {
        if (this.cursor === 0) {
          this.moveCursor(this.choices.length - 1);
        } else {
          this.moveCursor(this.cursor - 1);
        }
        this.render();
      }
      down() {
        if (this.cursor === this.choices.length - 1) {
          this.moveCursor(0);
        } else {
          this.moveCursor(this.cursor + 1);
        }
        this.render();
      }
      next() {
        this.moveCursor((this.cursor + 1) % this.choices.length);
        this.render();
      }
      _(c, key) {
        if (c === " ") return this.submit();
      }
      get selection() {
        return this.choices[this.cursor];
      }
      render() {
        if (this.closed) return;
        if (this.firstRender) this.out.write(cursor.hide);
        else this.out.write(clear(this.outputText, this.out.columns));
        super.render();
        let { startIndex, endIndex } = entriesToDisplay(this.cursor, this.choices.length, this.optionsPerPage);
        this.outputText = [
          style.symbol(this.done, this.aborted),
          color.bold(this.msg),
          style.delimiter(false),
          this.done ? this.selection.title : this.selection.disabled ? color.yellow(this.warn) : color.gray(this.hint)
        ].join(" ");
        if (!this.done) {
          this.outputText += "\n";
          for (let i = startIndex; i < endIndex; i++) {
            let title, prefix, desc = "", v = this.choices[i];
            if (i === startIndex && startIndex > 0) {
              prefix = figures.arrowUp;
            } else if (i === endIndex - 1 && endIndex < this.choices.length) {
              prefix = figures.arrowDown;
            } else {
              prefix = " ";
            }
            if (v.disabled) {
              title = this.cursor === i ? color.gray().underline(v.title) : color.strikethrough().gray(v.title);
              prefix = (this.cursor === i ? color.bold().gray(figures.pointer) + " " : "  ") + prefix;
            } else {
              title = this.cursor === i ? color.cyan().underline(v.title) : v.title;
              prefix = (this.cursor === i ? color.cyan(figures.pointer) + " " : "  ") + prefix;
              if (v.description && this.cursor === i) {
                desc = ` - ${v.description}`;
                if (prefix.length + title.length + desc.length >= this.out.columns || v.description.split(/\r?\n/).length > 1) {
                  desc = "\n" + wrap(v.description, { margin: 3, width: this.out.columns });
                }
              }
            }
            this.outputText += `${prefix} ${title}${color.gray(desc)}
`;
          }
        }
        this.out.write(this.outputText);
      }
    };
    module.exports = SelectPrompt;
  }
});

// node_modules/prompts/lib/elements/toggle.js
var require_toggle = __commonJS({
  "node_modules/prompts/lib/elements/toggle.js"(exports, module) {
    var color = require_kleur();
    var Prompt = require_prompt();
    var { style, clear } = require_util();
    var { cursor, erase } = require_src();
    var TogglePrompt = class extends Prompt {
      constructor(opts = {}) {
        super(opts);
        this.msg = opts.message;
        this.value = !!opts.initial;
        this.active = opts.active || "on";
        this.inactive = opts.inactive || "off";
        this.initialValue = this.value;
        this.render();
      }
      reset() {
        this.value = this.initialValue;
        this.fire();
        this.render();
      }
      exit() {
        this.abort();
      }
      abort() {
        this.done = this.aborted = true;
        this.fire();
        this.render();
        this.out.write("\n");
        this.close();
      }
      submit() {
        this.done = true;
        this.aborted = false;
        this.fire();
        this.render();
        this.out.write("\n");
        this.close();
      }
      deactivate() {
        if (this.value === false) return this.bell();
        this.value = false;
        this.render();
      }
      activate() {
        if (this.value === true) return this.bell();
        this.value = true;
        this.render();
      }
      delete() {
        this.deactivate();
      }
      left() {
        this.deactivate();
      }
      right() {
        this.activate();
      }
      down() {
        this.deactivate();
      }
      up() {
        this.activate();
      }
      next() {
        this.value = !this.value;
        this.fire();
        this.render();
      }
      _(c, key) {
        if (c === " ") {
          this.value = !this.value;
        } else if (c === "1") {
          this.value = true;
        } else if (c === "0") {
          this.value = false;
        } else return this.bell();
        this.render();
      }
      render() {
        if (this.closed) return;
        if (this.firstRender) this.out.write(cursor.hide);
        else this.out.write(clear(this.outputText, this.out.columns));
        super.render();
        this.outputText = [
          style.symbol(this.done, this.aborted),
          color.bold(this.msg),
          style.delimiter(this.done),
          this.value ? this.inactive : color.cyan().underline(this.inactive),
          color.gray("/"),
          this.value ? color.cyan().underline(this.active) : this.active
        ].join(" ");
        this.out.write(erase.line + cursor.to(0) + this.outputText);
      }
    };
    module.exports = TogglePrompt;
  }
});

// node_modules/prompts/lib/dateparts/datepart.js
var require_datepart = __commonJS({
  "node_modules/prompts/lib/dateparts/datepart.js"(exports, module) {
    "use strict";
    var DatePart = class _DatePart {
      constructor({ token, date, parts, locales }) {
        this.token = token;
        this.date = date || /* @__PURE__ */ new Date();
        this.parts = parts || [this];
        this.locales = locales || {};
      }
      up() {
      }
      down() {
      }
      next() {
        const currentIdx = this.parts.indexOf(this);
        return this.parts.find((part, idx) => idx > currentIdx && part instanceof _DatePart);
      }
      setTo(val) {
      }
      prev() {
        let parts = [].concat(this.parts).reverse();
        const currentIdx = parts.indexOf(this);
        return parts.find((part, idx) => idx > currentIdx && part instanceof _DatePart);
      }
      toString() {
        return String(this.date);
      }
    };
    module.exports = DatePart;
  }
});

// node_modules/prompts/lib/dateparts/meridiem.js
var require_meridiem = __commonJS({
  "node_modules/prompts/lib/dateparts/meridiem.js"(exports, module) {
    "use strict";
    var DatePart = require_datepart();
    var Meridiem = class extends DatePart {
      constructor(opts = {}) {
        super(opts);
      }
      up() {
        this.date.setHours((this.date.getHours() + 12) % 24);
      }
      down() {
        this.up();
      }
      toString() {
        let meridiem = this.date.getHours() > 12 ? "pm" : "am";
        return /\A/.test(this.token) ? meridiem.toUpperCase() : meridiem;
      }
    };
    module.exports = Meridiem;
  }
});

// node_modules/prompts/lib/dateparts/day.js
var require_day = __commonJS({
  "node_modules/prompts/lib/dateparts/day.js"(exports, module) {
    "use strict";
    var DatePart = require_datepart();
    var pos = (n) => {
      n = n % 10;
      return n === 1 ? "st" : n === 2 ? "nd" : n === 3 ? "rd" : "th";
    };
    var Day = class extends DatePart {
      constructor(opts = {}) {
        super(opts);
      }
      up() {
        this.date.setDate(this.date.getDate() + 1);
      }
      down() {
        this.date.setDate(this.date.getDate() - 1);
      }
      setTo(val) {
        this.date.setDate(parseInt(val.substr(-2)));
      }
      toString() {
        let date = this.date.getDate();
        let day = this.date.getDay();
        return this.token === "DD" ? String(date).padStart(2, "0") : this.token === "Do" ? date + pos(date) : this.token === "d" ? day + 1 : this.token === "ddd" ? this.locales.weekdaysShort[day] : this.token === "dddd" ? this.locales.weekdays[day] : date;
      }
    };
    module.exports = Day;
  }
});

// node_modules/prompts/lib/dateparts/hours.js
var require_hours = __commonJS({
  "node_modules/prompts/lib/dateparts/hours.js"(exports, module) {
    "use strict";
    var DatePart = require_datepart();
    var Hours = class extends DatePart {
      constructor(opts = {}) {
        super(opts);
      }
      up() {
        this.date.setHours(this.date.getHours() + 1);
      }
      down() {
        this.date.setHours(this.date.getHours() - 1);
      }
      setTo(val) {
        this.date.setHours(parseInt(val.substr(-2)));
      }
      toString() {
        let hours = this.date.getHours();
        if (/h/.test(this.token))
          hours = hours % 12 || 12;
        return this.token.length > 1 ? String(hours).padStart(2, "0") : hours;
      }
    };
    module.exports = Hours;
  }
});

// node_modules/prompts/lib/dateparts/milliseconds.js
var require_milliseconds = __commonJS({
  "node_modules/prompts/lib/dateparts/milliseconds.js"(exports, module) {
    "use strict";
    var DatePart = require_datepart();
    var Milliseconds = class extends DatePart {
      constructor(opts = {}) {
        super(opts);
      }
      up() {
        this.date.setMilliseconds(this.date.getMilliseconds() + 1);
      }
      down() {
        this.date.setMilliseconds(this.date.getMilliseconds() - 1);
      }
      setTo(val) {
        this.date.setMilliseconds(parseInt(val.substr(-this.token.length)));
      }
      toString() {
        return String(this.date.getMilliseconds()).padStart(4, "0").substr(0, this.token.length);
      }
    };
    module.exports = Milliseconds;
  }
});

// node_modules/prompts/lib/dateparts/minutes.js
var require_minutes = __commonJS({
  "node_modules/prompts/lib/dateparts/minutes.js"(exports, module) {
    "use strict";
    var DatePart = require_datepart();
    var Minutes = class extends DatePart {
      constructor(opts = {}) {
        super(opts);
      }
      up() {
        this.date.setMinutes(this.date.getMinutes() + 1);
      }
      down() {
        this.date.setMinutes(this.date.getMinutes() - 1);
      }
      setTo(val) {
        this.date.setMinutes(parseInt(val.substr(-2)));
      }
      toString() {
        let m = this.date.getMinutes();
        return this.token.length > 1 ? String(m).padStart(2, "0") : m;
      }
    };
    module.exports = Minutes;
  }
});

// node_modules/prompts/lib/dateparts/month.js
var require_month = __commonJS({
  "node_modules/prompts/lib/dateparts/month.js"(exports, module) {
    "use strict";
    var DatePart = require_datepart();
    var Month = class extends DatePart {
      constructor(opts = {}) {
        super(opts);
      }
      up() {
        this.date.setMonth(this.date.getMonth() + 1);
      }
      down() {
        this.date.setMonth(this.date.getMonth() - 1);
      }
      setTo(val) {
        val = parseInt(val.substr(-2)) - 1;
        this.date.setMonth(val < 0 ? 0 : val);
      }
      toString() {
        let month = this.date.getMonth();
        let tl = this.token.length;
        return tl === 2 ? String(month + 1).padStart(2, "0") : tl === 3 ? this.locales.monthsShort[month] : tl === 4 ? this.locales.months[month] : String(month + 1);
      }
    };
    module.exports = Month;
  }
});

// node_modules/prompts/lib/dateparts/seconds.js
var require_seconds = __commonJS({
  "node_modules/prompts/lib/dateparts/seconds.js"(exports, module) {
    "use strict";
    var DatePart = require_datepart();
    var Seconds = class extends DatePart {
      constructor(opts = {}) {
        super(opts);
      }
      up() {
        this.date.setSeconds(this.date.getSeconds() + 1);
      }
      down() {
        this.date.setSeconds(this.date.getSeconds() - 1);
      }
      setTo(val) {
        this.date.setSeconds(parseInt(val.substr(-2)));
      }
      toString() {
        let s = this.date.getSeconds();
        return this.token.length > 1 ? String(s).padStart(2, "0") : s;
      }
    };
    module.exports = Seconds;
  }
});

// node_modules/prompts/lib/dateparts/year.js
var require_year = __commonJS({
  "node_modules/prompts/lib/dateparts/year.js"(exports, module) {
    "use strict";
    var DatePart = require_datepart();
    var Year = class extends DatePart {
      constructor(opts = {}) {
        super(opts);
      }
      up() {
        this.date.setFullYear(this.date.getFullYear() + 1);
      }
      down() {
        this.date.setFullYear(this.date.getFullYear() - 1);
      }
      setTo(val) {
        this.date.setFullYear(val.substr(-4));
      }
      toString() {
        let year = String(this.date.getFullYear()).padStart(4, "0");
        return this.token.length === 2 ? year.substr(-2) : year;
      }
    };
    module.exports = Year;
  }
});

// node_modules/prompts/lib/dateparts/index.js
var require_dateparts = __commonJS({
  "node_modules/prompts/lib/dateparts/index.js"(exports, module) {
    "use strict";
    module.exports = {
      DatePart: require_datepart(),
      Meridiem: require_meridiem(),
      Day: require_day(),
      Hours: require_hours(),
      Milliseconds: require_milliseconds(),
      Minutes: require_minutes(),
      Month: require_month(),
      Seconds: require_seconds(),
      Year: require_year()
    };
  }
});

// node_modules/prompts/lib/elements/date.js
var require_date = __commonJS({
  "node_modules/prompts/lib/elements/date.js"(exports, module) {
    "use strict";
    var color = require_kleur();
    var Prompt = require_prompt();
    var { style, clear, figures } = require_util();
    var { erase, cursor } = require_src();
    var { DatePart, Meridiem, Day, Hours, Milliseconds, Minutes, Month, Seconds, Year } = require_dateparts();
    var regex = /\\(.)|"((?:\\["\\]|[^"])+)"|(D[Do]?|d{3,4}|d)|(M{1,4})|(YY(?:YY)?)|([aA])|([Hh]{1,2})|(m{1,2})|(s{1,2})|(S{1,4})|./g;
    var regexGroups = {
      1: ({ token }) => token.replace(/\\(.)/g, "$1"),
      2: (opts) => new Day(opts),
      // Day // TODO
      3: (opts) => new Month(opts),
      // Month
      4: (opts) => new Year(opts),
      // Year
      5: (opts) => new Meridiem(opts),
      // AM/PM // TODO (special)
      6: (opts) => new Hours(opts),
      // Hours
      7: (opts) => new Minutes(opts),
      // Minutes
      8: (opts) => new Seconds(opts),
      // Seconds
      9: (opts) => new Milliseconds(opts)
      // Fractional seconds
    };
    var dfltLocales = {
      months: "January,February,March,April,May,June,July,August,September,October,November,December".split(","),
      monthsShort: "Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov,Dec".split(","),
      weekdays: "Sunday,Monday,Tuesday,Wednesday,Thursday,Friday,Saturday".split(","),
      weekdaysShort: "Sun,Mon,Tue,Wed,Thu,Fri,Sat".split(",")
    };
    var DatePrompt = class extends Prompt {
      constructor(opts = {}) {
        super(opts);
        this.msg = opts.message;
        this.cursor = 0;
        this.typed = "";
        this.locales = Object.assign(dfltLocales, opts.locales);
        this._date = opts.initial || /* @__PURE__ */ new Date();
        this.errorMsg = opts.error || "Please Enter A Valid Value";
        this.validator = opts.validate || (() => true);
        this.mask = opts.mask || "YYYY-MM-DD HH:mm:ss";
        this.clear = clear("", this.out.columns);
        this.render();
      }
      get value() {
        return this.date;
      }
      get date() {
        return this._date;
      }
      set date(date) {
        if (date) this._date.setTime(date.getTime());
      }
      set mask(mask) {
        let result;
        this.parts = [];
        while (result = regex.exec(mask)) {
          let match = result.shift();
          let idx = result.findIndex((gr) => gr != null);
          this.parts.push(idx in regexGroups ? regexGroups[idx]({ token: result[idx] || match, date: this.date, parts: this.parts, locales: this.locales }) : result[idx] || match);
        }
        let parts = this.parts.reduce((arr, i) => {
          if (typeof i === "string" && typeof arr[arr.length - 1] === "string")
            arr[arr.length - 1] += i;
          else arr.push(i);
          return arr;
        }, []);
        this.parts.splice(0);
        this.parts.push(...parts);
        this.reset();
      }
      moveCursor(n) {
        this.typed = "";
        this.cursor = n;
        this.fire();
      }
      reset() {
        this.moveCursor(this.parts.findIndex((p) => p instanceof DatePart));
        this.fire();
        this.render();
      }
      exit() {
        this.abort();
      }
      abort() {
        this.done = this.aborted = true;
        this.error = false;
        this.fire();
        this.render();
        this.out.write("\n");
        this.close();
      }
      async validate() {
        let valid = await this.validator(this.value);
        if (typeof valid === "string") {
          this.errorMsg = valid;
          valid = false;
        }
        this.error = !valid;
      }
      async submit() {
        await this.validate();
        if (this.error) {
          this.color = "red";
          this.fire();
          this.render();
          return;
        }
        this.done = true;
        this.aborted = false;
        this.fire();
        this.render();
        this.out.write("\n");
        this.close();
      }
      up() {
        this.typed = "";
        this.parts[this.cursor].up();
        this.render();
      }
      down() {
        this.typed = "";
        this.parts[this.cursor].down();
        this.render();
      }
      left() {
        let prev = this.parts[this.cursor].prev();
        if (prev == null) return this.bell();
        this.moveCursor(this.parts.indexOf(prev));
        this.render();
      }
      right() {
        let next = this.parts[this.cursor].next();
        if (next == null) return this.bell();
        this.moveCursor(this.parts.indexOf(next));
        this.render();
      }
      next() {
        let next = this.parts[this.cursor].next();
        this.moveCursor(next ? this.parts.indexOf(next) : this.parts.findIndex((part) => part instanceof DatePart));
        this.render();
      }
      _(c) {
        if (/\d/.test(c)) {
          this.typed += c;
          this.parts[this.cursor].setTo(this.typed);
          this.render();
        }
      }
      render() {
        if (this.closed) return;
        if (this.firstRender) this.out.write(cursor.hide);
        else this.out.write(clear(this.outputText, this.out.columns));
        super.render();
        this.outputText = [
          style.symbol(this.done, this.aborted),
          color.bold(this.msg),
          style.delimiter(false),
          this.parts.reduce((arr, p, idx) => arr.concat(idx === this.cursor && !this.done ? color.cyan().underline(p.toString()) : p), []).join("")
        ].join(" ");
        if (this.error) {
          this.outputText += this.errorMsg.split("\n").reduce(
            (a, l, i) => a + `
${i ? ` ` : figures.pointerSmall} ${color.red().italic(l)}`,
            ``
          );
        }
        this.out.write(erase.line + cursor.to(0) + this.outputText);
      }
    };
    module.exports = DatePrompt;
  }
});

// node_modules/prompts/lib/elements/number.js
var require_number = __commonJS({
  "node_modules/prompts/lib/elements/number.js"(exports, module) {
    var color = require_kleur();
    var Prompt = require_prompt();
    var { cursor, erase } = require_src();
    var { style, figures, clear, lines } = require_util();
    var isNumber = /[0-9]/;
    var isDef = (any) => any !== void 0;
    var round = (number, precision) => {
      let factor = Math.pow(10, precision);
      return Math.round(number * factor) / factor;
    };
    var NumberPrompt = class extends Prompt {
      constructor(opts = {}) {
        super(opts);
        this.transform = style.render(opts.style);
        this.msg = opts.message;
        this.initial = isDef(opts.initial) ? opts.initial : "";
        this.float = !!opts.float;
        this.round = opts.round || 2;
        this.inc = opts.increment || 1;
        this.min = isDef(opts.min) ? opts.min : -Infinity;
        this.max = isDef(opts.max) ? opts.max : Infinity;
        this.errorMsg = opts.error || `Please Enter A Valid Value`;
        this.validator = opts.validate || (() => true);
        this.color = `cyan`;
        this.value = ``;
        this.typed = ``;
        this.lastHit = 0;
        this.render();
      }
      set value(v) {
        if (!v && v !== 0) {
          this.placeholder = true;
          this.rendered = color.gray(this.transform.render(`${this.initial}`));
          this._value = ``;
        } else {
          this.placeholder = false;
          this.rendered = this.transform.render(`${round(v, this.round)}`);
          this._value = round(v, this.round);
        }
        this.fire();
      }
      get value() {
        return this._value;
      }
      parse(x) {
        return this.float ? parseFloat(x) : parseInt(x);
      }
      valid(c) {
        return c === `-` || c === `.` && this.float || isNumber.test(c);
      }
      reset() {
        this.typed = ``;
        this.value = ``;
        this.fire();
        this.render();
      }
      exit() {
        this.abort();
      }
      abort() {
        let x = this.value;
        this.value = x !== `` ? x : this.initial;
        this.done = this.aborted = true;
        this.error = false;
        this.fire();
        this.render();
        this.out.write(`
`);
        this.close();
      }
      async validate() {
        let valid = await this.validator(this.value);
        if (typeof valid === `string`) {
          this.errorMsg = valid;
          valid = false;
        }
        this.error = !valid;
      }
      async submit() {
        await this.validate();
        if (this.error) {
          this.color = `red`;
          this.fire();
          this.render();
          return;
        }
        let x = this.value;
        this.value = x !== `` ? x : this.initial;
        this.done = true;
        this.aborted = false;
        this.error = false;
        this.fire();
        this.render();
        this.out.write(`
`);
        this.close();
      }
      up() {
        this.typed = ``;
        if (this.value === "") {
          this.value = this.min - this.inc;
        }
        if (this.value >= this.max) return this.bell();
        this.value += this.inc;
        this.color = `cyan`;
        this.fire();
        this.render();
      }
      down() {
        this.typed = ``;
        if (this.value === "") {
          this.value = this.min + this.inc;
        }
        if (this.value <= this.min) return this.bell();
        this.value -= this.inc;
        this.color = `cyan`;
        this.fire();
        this.render();
      }
      delete() {
        let val = this.value.toString();
        if (val.length === 0) return this.bell();
        this.value = this.parse(val = val.slice(0, -1)) || ``;
        if (this.value !== "" && this.value < this.min) {
          this.value = this.min;
        }
        this.color = `cyan`;
        this.fire();
        this.render();
      }
      next() {
        this.value = this.initial;
        this.fire();
        this.render();
      }
      _(c, key) {
        if (!this.valid(c)) return this.bell();
        const now = Date.now();
        if (now - this.lastHit > 1e3) this.typed = ``;
        this.typed += c;
        this.lastHit = now;
        this.color = `cyan`;
        if (c === `.`) return this.fire();
        this.value = Math.min(this.parse(this.typed), this.max);
        if (this.value > this.max) this.value = this.max;
        if (this.value < this.min) this.value = this.min;
        this.fire();
        this.render();
      }
      render() {
        if (this.closed) return;
        if (!this.firstRender) {
          if (this.outputError)
            this.out.write(cursor.down(lines(this.outputError, this.out.columns) - 1) + clear(this.outputError, this.out.columns));
          this.out.write(clear(this.outputText, this.out.columns));
        }
        super.render();
        this.outputError = "";
        this.outputText = [
          style.symbol(this.done, this.aborted),
          color.bold(this.msg),
          style.delimiter(this.done),
          !this.done || !this.done && !this.placeholder ? color[this.color]().underline(this.rendered) : this.rendered
        ].join(` `);
        if (this.error) {
          this.outputError += this.errorMsg.split(`
`).reduce((a, l, i) => a + `
${i ? ` ` : figures.pointerSmall} ${color.red().italic(l)}`, ``);
        }
        this.out.write(erase.line + cursor.to(0) + this.outputText + cursor.save + this.outputError + cursor.restore);
      }
    };
    module.exports = NumberPrompt;
  }
});

// node_modules/prompts/lib/elements/multiselect.js
var require_multiselect = __commonJS({
  "node_modules/prompts/lib/elements/multiselect.js"(exports, module) {
    "use strict";
    var color = require_kleur();
    var { cursor } = require_src();
    var Prompt = require_prompt();
    var { clear, figures, style, wrap, entriesToDisplay } = require_util();
    var MultiselectPrompt = class extends Prompt {
      constructor(opts = {}) {
        super(opts);
        this.msg = opts.message;
        this.cursor = opts.cursor || 0;
        this.scrollIndex = opts.cursor || 0;
        this.hint = opts.hint || "";
        this.warn = opts.warn || "- This option is disabled -";
        this.minSelected = opts.min;
        this.showMinError = false;
        this.maxChoices = opts.max;
        this.instructions = opts.instructions;
        this.optionsPerPage = opts.optionsPerPage || 10;
        this.value = opts.choices.map((ch, idx) => {
          if (typeof ch === "string")
            ch = { title: ch, value: idx };
          return {
            title: ch && (ch.title || ch.value || ch),
            description: ch && ch.description,
            value: ch && (ch.value === void 0 ? idx : ch.value),
            selected: ch && ch.selected,
            disabled: ch && ch.disabled
          };
        });
        this.clear = clear("", this.out.columns);
        if (!opts.overrideRender) {
          this.render();
        }
      }
      reset() {
        this.value.map((v) => !v.selected);
        this.cursor = 0;
        this.fire();
        this.render();
      }
      selected() {
        return this.value.filter((v) => v.selected);
      }
      exit() {
        this.abort();
      }
      abort() {
        this.done = this.aborted = true;
        this.fire();
        this.render();
        this.out.write("\n");
        this.close();
      }
      submit() {
        const selected = this.value.filter((e) => e.selected);
        if (this.minSelected && selected.length < this.minSelected) {
          this.showMinError = true;
          this.render();
        } else {
          this.done = true;
          this.aborted = false;
          this.fire();
          this.render();
          this.out.write("\n");
          this.close();
        }
      }
      first() {
        this.cursor = 0;
        this.render();
      }
      last() {
        this.cursor = this.value.length - 1;
        this.render();
      }
      next() {
        this.cursor = (this.cursor + 1) % this.value.length;
        this.render();
      }
      up() {
        if (this.cursor === 0) {
          this.cursor = this.value.length - 1;
        } else {
          this.cursor--;
        }
        this.render();
      }
      down() {
        if (this.cursor === this.value.length - 1) {
          this.cursor = 0;
        } else {
          this.cursor++;
        }
        this.render();
      }
      left() {
        this.value[this.cursor].selected = false;
        this.render();
      }
      right() {
        if (this.value.filter((e) => e.selected).length >= this.maxChoices) return this.bell();
        this.value[this.cursor].selected = true;
        this.render();
      }
      handleSpaceToggle() {
        const v = this.value[this.cursor];
        if (v.selected) {
          v.selected = false;
          this.render();
        } else if (v.disabled || this.value.filter((e) => e.selected).length >= this.maxChoices) {
          return this.bell();
        } else {
          v.selected = true;
          this.render();
        }
      }
      toggleAll() {
        if (this.maxChoices !== void 0 || this.value[this.cursor].disabled) {
          return this.bell();
        }
        const newSelected = !this.value[this.cursor].selected;
        this.value.filter((v) => !v.disabled).forEach((v) => v.selected = newSelected);
        this.render();
      }
      _(c, key) {
        if (c === " ") {
          this.handleSpaceToggle();
        } else if (c === "a") {
          this.toggleAll();
        } else {
          return this.bell();
        }
      }
      renderInstructions() {
        if (this.instructions === void 0 || this.instructions) {
          if (typeof this.instructions === "string") {
            return this.instructions;
          }
          return `
Instructions:
    ${figures.arrowUp}/${figures.arrowDown}: Highlight option
    ${figures.arrowLeft}/${figures.arrowRight}/[space]: Toggle selection
` + (this.maxChoices === void 0 ? `    a: Toggle all
` : "") + `    enter/return: Complete answer`;
        }
        return "";
      }
      renderOption(cursor2, v, i, arrowIndicator) {
        const prefix = (v.selected ? color.green(figures.radioOn) : figures.radioOff) + " " + arrowIndicator + " ";
        let title, desc;
        if (v.disabled) {
          title = cursor2 === i ? color.gray().underline(v.title) : color.strikethrough().gray(v.title);
        } else {
          title = cursor2 === i ? color.cyan().underline(v.title) : v.title;
          if (cursor2 === i && v.description) {
            desc = ` - ${v.description}`;
            if (prefix.length + title.length + desc.length >= this.out.columns || v.description.split(/\r?\n/).length > 1) {
              desc = "\n" + wrap(v.description, { margin: prefix.length, width: this.out.columns });
            }
          }
        }
        return prefix + title + color.gray(desc || "");
      }
      // shared with autocompleteMultiselect
      paginateOptions(options) {
        if (options.length === 0) {
          return color.red("No matches for this query.");
        }
        let { startIndex, endIndex } = entriesToDisplay(this.cursor, options.length, this.optionsPerPage);
        let prefix, styledOptions = [];
        for (let i = startIndex; i < endIndex; i++) {
          if (i === startIndex && startIndex > 0) {
            prefix = figures.arrowUp;
          } else if (i === endIndex - 1 && endIndex < options.length) {
            prefix = figures.arrowDown;
          } else {
            prefix = " ";
          }
          styledOptions.push(this.renderOption(this.cursor, options[i], i, prefix));
        }
        return "\n" + styledOptions.join("\n");
      }
      // shared with autocomleteMultiselect
      renderOptions(options) {
        if (!this.done) {
          return this.paginateOptions(options);
        }
        return "";
      }
      renderDoneOrInstructions() {
        if (this.done) {
          return this.value.filter((e) => e.selected).map((v) => v.title).join(", ");
        }
        const output = [color.gray(this.hint), this.renderInstructions()];
        if (this.value[this.cursor].disabled) {
          output.push(color.yellow(this.warn));
        }
        return output.join(" ");
      }
      render() {
        if (this.closed) return;
        if (this.firstRender) this.out.write(cursor.hide);
        super.render();
        let prompt = [
          style.symbol(this.done, this.aborted),
          color.bold(this.msg),
          style.delimiter(false),
          this.renderDoneOrInstructions()
        ].join(" ");
        if (this.showMinError) {
          prompt += color.red(`You must select a minimum of ${this.minSelected} choices.`);
          this.showMinError = false;
        }
        prompt += this.renderOptions(this.value);
        this.out.write(this.clear + prompt);
        this.clear = clear(prompt, this.out.columns);
      }
    };
    module.exports = MultiselectPrompt;
  }
});

// node_modules/prompts/lib/elements/autocomplete.js
var require_autocomplete = __commonJS({
  "node_modules/prompts/lib/elements/autocomplete.js"(exports, module) {
    "use strict";
    var color = require_kleur();
    var Prompt = require_prompt();
    var { erase, cursor } = require_src();
    var { style, clear, figures, wrap, entriesToDisplay } = require_util();
    var getVal = (arr, i) => arr[i] && (arr[i].value || arr[i].title || arr[i]);
    var getTitle = (arr, i) => arr[i] && (arr[i].title || arr[i].value || arr[i]);
    var getIndex = (arr, valOrTitle) => {
      const index = arr.findIndex((el) => el.value === valOrTitle || el.title === valOrTitle);
      return index > -1 ? index : void 0;
    };
    var AutocompletePrompt = class extends Prompt {
      constructor(opts = {}) {
        super(opts);
        this.msg = opts.message;
        this.suggest = opts.suggest;
        this.choices = opts.choices;
        this.initial = typeof opts.initial === "number" ? opts.initial : getIndex(opts.choices, opts.initial);
        this.select = this.initial || opts.cursor || 0;
        this.i18n = { noMatches: opts.noMatches || "no matches found" };
        this.fallback = opts.fallback || this.initial;
        this.clearFirst = opts.clearFirst || false;
        this.suggestions = [];
        this.input = "";
        this.limit = opts.limit || 10;
        this.cursor = 0;
        this.transform = style.render(opts.style);
        this.scale = this.transform.scale;
        this.render = this.render.bind(this);
        this.complete = this.complete.bind(this);
        this.clear = clear("", this.out.columns);
        this.complete(this.render);
        this.render();
      }
      set fallback(fb) {
        this._fb = Number.isSafeInteger(parseInt(fb)) ? parseInt(fb) : fb;
      }
      get fallback() {
        let choice;
        if (typeof this._fb === "number")
          choice = this.choices[this._fb];
        else if (typeof this._fb === "string")
          choice = { title: this._fb };
        return choice || this._fb || { title: this.i18n.noMatches };
      }
      moveSelect(i) {
        this.select = i;
        if (this.suggestions.length > 0)
          this.value = getVal(this.suggestions, i);
        else this.value = this.fallback.value;
        this.fire();
      }
      async complete(cb) {
        const p = this.completing = this.suggest(this.input, this.choices);
        const suggestions = await p;
        if (this.completing !== p) return;
        this.suggestions = suggestions.map((s, i, arr) => ({ title: getTitle(arr, i), value: getVal(arr, i), description: s.description }));
        this.completing = false;
        const l = Math.max(suggestions.length - 1, 0);
        this.moveSelect(Math.min(l, this.select));
        cb && cb();
      }
      reset() {
        this.input = "";
        this.complete(() => {
          this.moveSelect(this.initial !== void 0 ? this.initial : 0);
          this.render();
        });
        this.render();
      }
      exit() {
        if (this.clearFirst && this.input.length > 0) {
          this.reset();
        } else {
          this.done = this.exited = true;
          this.aborted = false;
          this.fire();
          this.render();
          this.out.write("\n");
          this.close();
        }
      }
      abort() {
        this.done = this.aborted = true;
        this.exited = false;
        this.fire();
        this.render();
        this.out.write("\n");
        this.close();
      }
      submit() {
        this.done = true;
        this.aborted = this.exited = false;
        this.fire();
        this.render();
        this.out.write("\n");
        this.close();
      }
      _(c, key) {
        let s1 = this.input.slice(0, this.cursor);
        let s2 = this.input.slice(this.cursor);
        this.input = `${s1}${c}${s2}`;
        this.cursor = s1.length + 1;
        this.complete(this.render);
        this.render();
      }
      delete() {
        if (this.cursor === 0) return this.bell();
        let s1 = this.input.slice(0, this.cursor - 1);
        let s2 = this.input.slice(this.cursor);
        this.input = `${s1}${s2}`;
        this.complete(this.render);
        this.cursor = this.cursor - 1;
        this.render();
      }
      deleteForward() {
        if (this.cursor * this.scale >= this.rendered.length) return this.bell();
        let s1 = this.input.slice(0, this.cursor);
        let s2 = this.input.slice(this.cursor + 1);
        this.input = `${s1}${s2}`;
        this.complete(this.render);
        this.render();
      }
      first() {
        this.moveSelect(0);
        this.render();
      }
      last() {
        this.moveSelect(this.suggestions.length - 1);
        this.render();
      }
      up() {
        if (this.select === 0) {
          this.moveSelect(this.suggestions.length - 1);
        } else {
          this.moveSelect(this.select - 1);
        }
        this.render();
      }
      down() {
        if (this.select === this.suggestions.length - 1) {
          this.moveSelect(0);
        } else {
          this.moveSelect(this.select + 1);
        }
        this.render();
      }
      next() {
        if (this.select === this.suggestions.length - 1) {
          this.moveSelect(0);
        } else this.moveSelect(this.select + 1);
        this.render();
      }
      nextPage() {
        this.moveSelect(Math.min(this.select + this.limit, this.suggestions.length - 1));
        this.render();
      }
      prevPage() {
        this.moveSelect(Math.max(this.select - this.limit, 0));
        this.render();
      }
      left() {
        if (this.cursor <= 0) return this.bell();
        this.cursor = this.cursor - 1;
        this.render();
      }
      right() {
        if (this.cursor * this.scale >= this.rendered.length) return this.bell();
        this.cursor = this.cursor + 1;
        this.render();
      }
      renderOption(v, hovered, isStart, isEnd) {
        let desc;
        let prefix = isStart ? figures.arrowUp : isEnd ? figures.arrowDown : " ";
        let title = hovered ? color.cyan().underline(v.title) : v.title;
        prefix = (hovered ? color.cyan(figures.pointer) + " " : "  ") + prefix;
        if (v.description) {
          desc = ` - ${v.description}`;
          if (prefix.length + title.length + desc.length >= this.out.columns || v.description.split(/\r?\n/).length > 1) {
            desc = "\n" + wrap(v.description, { margin: 3, width: this.out.columns });
          }
        }
        return prefix + " " + title + color.gray(desc || "");
      }
      render() {
        if (this.closed) return;
        if (this.firstRender) this.out.write(cursor.hide);
        else this.out.write(clear(this.outputText, this.out.columns));
        super.render();
        let { startIndex, endIndex } = entriesToDisplay(this.select, this.choices.length, this.limit);
        this.outputText = [
          style.symbol(this.done, this.aborted, this.exited),
          color.bold(this.msg),
          style.delimiter(this.completing),
          this.done && this.suggestions[this.select] ? this.suggestions[this.select].title : this.rendered = this.transform.render(this.input)
        ].join(" ");
        if (!this.done) {
          const suggestions = this.suggestions.slice(startIndex, endIndex).map((item, i) => this.renderOption(
            item,
            this.select === i + startIndex,
            i === 0 && startIndex > 0,
            i + startIndex === endIndex - 1 && endIndex < this.choices.length
          )).join("\n");
          this.outputText += `
` + (suggestions || color.gray(this.fallback.title));
        }
        this.out.write(erase.line + cursor.to(0) + this.outputText);
      }
    };
    module.exports = AutocompletePrompt;
  }
});

// node_modules/prompts/lib/elements/autocompleteMultiselect.js
var require_autocompleteMultiselect = __commonJS({
  "node_modules/prompts/lib/elements/autocompleteMultiselect.js"(exports, module) {
    "use strict";
    var color = require_kleur();
    var { cursor } = require_src();
    var MultiselectPrompt = require_multiselect();
    var { clear, style, figures } = require_util();
    var AutocompleteMultiselectPrompt = class extends MultiselectPrompt {
      constructor(opts = {}) {
        opts.overrideRender = true;
        super(opts);
        this.inputValue = "";
        this.clear = clear("", this.out.columns);
        this.filteredOptions = this.value;
        this.render();
      }
      last() {
        this.cursor = this.filteredOptions.length - 1;
        this.render();
      }
      next() {
        this.cursor = (this.cursor + 1) % this.filteredOptions.length;
        this.render();
      }
      up() {
        if (this.cursor === 0) {
          this.cursor = this.filteredOptions.length - 1;
        } else {
          this.cursor--;
        }
        this.render();
      }
      down() {
        if (this.cursor === this.filteredOptions.length - 1) {
          this.cursor = 0;
        } else {
          this.cursor++;
        }
        this.render();
      }
      left() {
        this.filteredOptions[this.cursor].selected = false;
        this.render();
      }
      right() {
        if (this.value.filter((e) => e.selected).length >= this.maxChoices) return this.bell();
        this.filteredOptions[this.cursor].selected = true;
        this.render();
      }
      delete() {
        if (this.inputValue.length) {
          this.inputValue = this.inputValue.substr(0, this.inputValue.length - 1);
          this.updateFilteredOptions();
        }
      }
      updateFilteredOptions() {
        const currentHighlight = this.filteredOptions[this.cursor];
        this.filteredOptions = this.value.filter((v) => {
          if (this.inputValue) {
            if (typeof v.title === "string") {
              if (v.title.toLowerCase().includes(this.inputValue.toLowerCase())) {
                return true;
              }
            }
            if (typeof v.value === "string") {
              if (v.value.toLowerCase().includes(this.inputValue.toLowerCase())) {
                return true;
              }
            }
            return false;
          }
          return true;
        });
        const newHighlightIndex = this.filteredOptions.findIndex((v) => v === currentHighlight);
        this.cursor = newHighlightIndex < 0 ? 0 : newHighlightIndex;
        this.render();
      }
      handleSpaceToggle() {
        const v = this.filteredOptions[this.cursor];
        if (v.selected) {
          v.selected = false;
          this.render();
        } else if (v.disabled || this.value.filter((e) => e.selected).length >= this.maxChoices) {
          return this.bell();
        } else {
          v.selected = true;
          this.render();
        }
      }
      handleInputChange(c) {
        this.inputValue = this.inputValue + c;
        this.updateFilteredOptions();
      }
      _(c, key) {
        if (c === " ") {
          this.handleSpaceToggle();
        } else {
          this.handleInputChange(c);
        }
      }
      renderInstructions() {
        if (this.instructions === void 0 || this.instructions) {
          if (typeof this.instructions === "string") {
            return this.instructions;
          }
          return `
Instructions:
    ${figures.arrowUp}/${figures.arrowDown}: Highlight option
    ${figures.arrowLeft}/${figures.arrowRight}/[space]: Toggle selection
    [a,b,c]/delete: Filter choices
    enter/return: Complete answer
`;
        }
        return "";
      }
      renderCurrentInput() {
        return `
Filtered results for: ${this.inputValue ? this.inputValue : color.gray("Enter something to filter")}
`;
      }
      renderOption(cursor2, v, i) {
        let title;
        if (v.disabled) title = cursor2 === i ? color.gray().underline(v.title) : color.strikethrough().gray(v.title);
        else title = cursor2 === i ? color.cyan().underline(v.title) : v.title;
        return (v.selected ? color.green(figures.radioOn) : figures.radioOff) + "  " + title;
      }
      renderDoneOrInstructions() {
        if (this.done) {
          return this.value.filter((e) => e.selected).map((v) => v.title).join(", ");
        }
        const output = [color.gray(this.hint), this.renderInstructions(), this.renderCurrentInput()];
        if (this.filteredOptions.length && this.filteredOptions[this.cursor].disabled) {
          output.push(color.yellow(this.warn));
        }
        return output.join(" ");
      }
      render() {
        if (this.closed) return;
        if (this.firstRender) this.out.write(cursor.hide);
        super.render();
        let prompt = [
          style.symbol(this.done, this.aborted),
          color.bold(this.msg),
          style.delimiter(false),
          this.renderDoneOrInstructions()
        ].join(" ");
        if (this.showMinError) {
          prompt += color.red(`You must select a minimum of ${this.minSelected} choices.`);
          this.showMinError = false;
        }
        prompt += this.renderOptions(this.filteredOptions);
        this.out.write(this.clear + prompt);
        this.clear = clear(prompt, this.out.columns);
      }
    };
    module.exports = AutocompleteMultiselectPrompt;
  }
});

// node_modules/prompts/lib/elements/confirm.js
var require_confirm = __commonJS({
  "node_modules/prompts/lib/elements/confirm.js"(exports, module) {
    var color = require_kleur();
    var Prompt = require_prompt();
    var { style, clear } = require_util();
    var { erase, cursor } = require_src();
    var ConfirmPrompt = class extends Prompt {
      constructor(opts = {}) {
        super(opts);
        this.msg = opts.message;
        this.value = opts.initial;
        this.initialValue = !!opts.initial;
        this.yesMsg = opts.yes || "yes";
        this.yesOption = opts.yesOption || "(Y/n)";
        this.noMsg = opts.no || "no";
        this.noOption = opts.noOption || "(y/N)";
        this.render();
      }
      reset() {
        this.value = this.initialValue;
        this.fire();
        this.render();
      }
      exit() {
        this.abort();
      }
      abort() {
        this.done = this.aborted = true;
        this.fire();
        this.render();
        this.out.write("\n");
        this.close();
      }
      submit() {
        this.value = this.value || false;
        this.done = true;
        this.aborted = false;
        this.fire();
        this.render();
        this.out.write("\n");
        this.close();
      }
      _(c, key) {
        if (c.toLowerCase() === "y") {
          this.value = true;
          return this.submit();
        }
        if (c.toLowerCase() === "n") {
          this.value = false;
          return this.submit();
        }
        return this.bell();
      }
      render() {
        if (this.closed) return;
        if (this.firstRender) this.out.write(cursor.hide);
        else this.out.write(clear(this.outputText, this.out.columns));
        super.render();
        this.outputText = [
          style.symbol(this.done, this.aborted),
          color.bold(this.msg),
          style.delimiter(this.done),
          this.done ? this.value ? this.yesMsg : this.noMsg : color.gray(this.initialValue ? this.yesOption : this.noOption)
        ].join(" ");
        this.out.write(erase.line + cursor.to(0) + this.outputText);
      }
    };
    module.exports = ConfirmPrompt;
  }
});

// node_modules/prompts/lib/elements/index.js
var require_elements = __commonJS({
  "node_modules/prompts/lib/elements/index.js"(exports, module) {
    "use strict";
    module.exports = {
      TextPrompt: require_text(),
      SelectPrompt: require_select(),
      TogglePrompt: require_toggle(),
      DatePrompt: require_date(),
      NumberPrompt: require_number(),
      MultiselectPrompt: require_multiselect(),
      AutocompletePrompt: require_autocomplete(),
      AutocompleteMultiselectPrompt: require_autocompleteMultiselect(),
      ConfirmPrompt: require_confirm()
    };
  }
});

// node_modules/prompts/lib/prompts.js
var require_prompts = __commonJS({
  "node_modules/prompts/lib/prompts.js"(exports) {
    "use strict";
    var $ = exports;
    var el = require_elements();
    var noop = (v) => v;
    function toPrompt(type, args, opts = {}) {
      return new Promise((res, rej) => {
        const p = new el[type](args);
        const onAbort = opts.onAbort || noop;
        const onSubmit = opts.onSubmit || noop;
        const onExit = opts.onExit || noop;
        p.on("state", args.onState || noop);
        p.on("submit", (x) => res(onSubmit(x)));
        p.on("exit", (x) => res(onExit(x)));
        p.on("abort", (x) => rej(onAbort(x)));
      });
    }
    $.text = (args) => toPrompt("TextPrompt", args);
    $.password = (args) => {
      args.style = "password";
      return $.text(args);
    };
    $.invisible = (args) => {
      args.style = "invisible";
      return $.text(args);
    };
    $.number = (args) => toPrompt("NumberPrompt", args);
    $.date = (args) => toPrompt("DatePrompt", args);
    $.confirm = (args) => toPrompt("ConfirmPrompt", args);
    $.list = (args) => {
      const sep = args.separator || ",";
      return toPrompt("TextPrompt", args, {
        onSubmit: (str) => str.split(sep).map((s) => s.trim())
      });
    };
    $.toggle = (args) => toPrompt("TogglePrompt", args);
    $.select = (args) => toPrompt("SelectPrompt", args);
    $.multiselect = (args) => {
      args.choices = [].concat(args.choices || []);
      const toSelected = (items) => items.filter((item) => item.selected).map((item) => item.value);
      return toPrompt("MultiselectPrompt", args, {
        onAbort: toSelected,
        onSubmit: toSelected
      });
    };
    $.autocompleteMultiselect = (args) => {
      args.choices = [].concat(args.choices || []);
      const toSelected = (items) => items.filter((item) => item.selected).map((item) => item.value);
      return toPrompt("AutocompleteMultiselectPrompt", args, {
        onAbort: toSelected,
        onSubmit: toSelected
      });
    };
    var byTitle = (input, choices) => Promise.resolve(
      choices.filter((item) => item.title.slice(0, input.length).toLowerCase() === input.toLowerCase())
    );
    $.autocomplete = (args) => {
      args.suggest = args.suggest || byTitle;
      args.choices = [].concat(args.choices || []);
      return toPrompt("AutocompletePrompt", args);
    };
  }
});

// node_modules/prompts/lib/index.js
var require_lib = __commonJS({
  "node_modules/prompts/lib/index.js"(exports, module) {
    "use strict";
    var prompts = require_prompts();
    var passOn = ["suggest", "format", "onState", "validate", "onRender", "type"];
    var noop = () => {
    };
    async function prompt(questions = [], { onSubmit = noop, onCancel = noop } = {}) {
      const answers = {};
      const override2 = prompt._override || {};
      questions = [].concat(questions);
      let answer, question, quit, name, type, lastPrompt;
      const getFormattedAnswer = async (question2, answer2, skipValidation = false) => {
        if (!skipValidation && question2.validate && question2.validate(answer2) !== true) {
          return;
        }
        return question2.format ? await question2.format(answer2, answers) : answer2;
      };
      for (question of questions) {
        ({ name, type } = question);
        if (typeof type === "function") {
          type = await type(answer, { ...answers }, question);
          question["type"] = type;
        }
        if (!type) continue;
        for (let key in question) {
          if (passOn.includes(key)) continue;
          let value = question[key];
          question[key] = typeof value === "function" ? await value(answer, { ...answers }, lastPrompt) : value;
        }
        lastPrompt = question;
        if (typeof question.message !== "string") {
          throw new Error("prompt message is required");
        }
        ({ name, type } = question);
        if (prompts[type] === void 0) {
          throw new Error(`prompt type (${type}) is not defined`);
        }
        if (override2[question.name] !== void 0) {
          answer = await getFormattedAnswer(question, override2[question.name]);
          if (answer !== void 0) {
            answers[name] = answer;
            continue;
          }
        }
        try {
          answer = prompt._injected ? getInjectedAnswer(prompt._injected, question.initial) : await prompts[type](question);
          answers[name] = answer = await getFormattedAnswer(question, answer, true);
          quit = await onSubmit(question, answer, answers);
        } catch (err2) {
          quit = !await onCancel(question, answers);
        }
        if (quit) return answers;
      }
      return answers;
    }
    function getInjectedAnswer(injected, deafultValue) {
      const answer = injected.shift();
      if (answer instanceof Error) {
        throw answer;
      }
      return answer === void 0 ? deafultValue : answer;
    }
    function inject(answers) {
      prompt._injected = (prompt._injected || []).concat(answers);
    }
    function override(answers) {
      prompt._override = Object.assign({}, answers);
    }
    module.exports = Object.assign(prompt, { prompt, prompts, inject, override });
  }
});

// src/cli/config-flags.ts
var BOOLEAN_CLI_FLAGS = [
  "build",
  "cache",
  "checkVersion",
  "ci",
  "compare",
  "debug",
  "dev",
  "devtools",
  "docs",
  "e2e",
  "es5",
  "esm",
  "help",
  "log",
  "open",
  "prerender",
  "prerenderExternal",
  "prod",
  "profile",
  "serviceWorker",
  "screenshot",
  "serve",
  "skipNodeCheck",
  "spec",
  "ssr",
  "stats",
  "updateScreenshot",
  "verbose",
  "version",
  "watch",
  // JEST CLI OPTIONS
  "all",
  "automock",
  "bail",
  // 'cache', Stencil already supports this argument
  "changedFilesWithAncestor",
  // 'ci', Stencil already supports this argument
  "clearCache",
  "clearMocks",
  "collectCoverage",
  "color",
  "colors",
  "coverage",
  // 'debug', Stencil already supports this argument
  "detectLeaks",
  "detectOpenHandles",
  "errorOnDeprecated",
  "expand",
  "findRelatedTests",
  "forceExit",
  "init",
  "injectGlobals",
  "json",
  "lastCommit",
  "listTests",
  "logHeapUsage",
  "noStackTrace",
  "notify",
  "onlyChanged",
  "onlyFailures",
  "passWithNoTests",
  "resetMocks",
  "resetModules",
  "restoreMocks",
  "runInBand",
  "runTestsByPath",
  "showConfig",
  "silent",
  "skipFilter",
  "testLocationInResults",
  "updateSnapshot",
  "useStderr",
  // 'verbose', Stencil already supports this argument
  // 'version', Stencil already supports this argument
  // 'watch', Stencil already supports this argument
  "watchAll",
  "watchman"
];
var NUMBER_CLI_FLAGS = [
  "port",
  // JEST CLI ARGS
  "maxConcurrency",
  "testTimeout"
];
var STRING_CLI_FLAGS = [
  "address",
  "config",
  "docsApi",
  "docsJson",
  "emulate",
  "root",
  "screenshotConnector",
  // JEST CLI ARGS
  "cacheDirectory",
  "changedSince",
  "collectCoverageFrom",
  // 'config', Stencil already supports this argument
  "coverageDirectory",
  "coverageThreshold",
  "env",
  "filter",
  "globalSetup",
  "globalTeardown",
  "globals",
  "haste",
  "moduleNameMapper",
  "notifyMode",
  "outputFile",
  "preset",
  "prettierPath",
  "resolver",
  "rootDir",
  "runner",
  "testEnvironment",
  "testEnvironmentOptions",
  "testFailureExitCode",
  "testNamePattern",
  "testResultsProcessor",
  "testRunner",
  "testSequencer",
  "testURL",
  "timers",
  "transform"
];
var STRING_ARRAY_CLI_FLAGS = [
  "collectCoverageOnlyFrom",
  "coveragePathIgnorePatterns",
  "coverageReporters",
  "moduleDirectories",
  "moduleFileExtensions",
  "modulePathIgnorePatterns",
  "modulePaths",
  "projects",
  "reporters",
  "roots",
  "selectProjects",
  "setupFiles",
  "setupFilesAfterEnv",
  "snapshotSerializers",
  "testMatch",
  "testPathIgnorePatterns",
  "testPathPattern",
  "testRegex",
  "transformIgnorePatterns",
  "unmockedModulePathPatterns",
  "watchPathIgnorePatterns"
];
var STRING_NUMBER_CLI_FLAGS = ["maxWorkers"];
var BOOLEAN_STRING_CLI_FLAGS = [
  /**
   * `headless` is an argument passed through to Puppeteer (which is passed to Chrome) for end-to-end testing.
   *
   * {@see https://developer.chrome.com/blog/chrome-headless-shell/}
   */
  "headless"
];
var LOG_LEVEL_CLI_FLAGS = ["logLevel"];
var CLI_FLAG_ALIASES = {
  c: "config",
  h: "help",
  p: "port",
  v: "version",
  // JEST SPECIFIC CLI FLAGS
  // these are defined in
  // https://github.com/facebook/jest/blob/4156f86/packages/jest-cli/src/args.ts
  b: "bail",
  e: "expand",
  f: "onlyFailures",
  i: "runInBand",
  o: "onlyChanged",
  t: "testNamePattern",
  u: "updateSnapshot",
  w: "maxWorkers"
};
var CLI_FLAG_REGEX = new RegExp(`^-[chpvbewofitu]{1}$`);
var createConfigFlags = (init = {}) => {
  const flags = {
    task: null,
    args: [],
    knownArgs: [],
    unknownArgs: [],
    ...init
  };
  return flags;
};

// src/utils/constants.ts
var DIST_HYDRATE_SCRIPT = "dist-hydrate-script";
var DOCS_CUSTOM = "docs-custom";
var DOCS_JSON = "docs-json";
var DOCS_README = "docs-readme";
var DOCS_VSCODE = "docs-vscode";
var WWW = "www";

// src/utils/helpers.ts
var dashToPascalCase = (str) => str.toLowerCase().split("-").map((segment) => segment.charAt(0).toUpperCase() + segment.slice(1)).join("");
var toCamelCase = (str) => {
  const pascalCase = dashToPascalCase(str);
  return pascalCase.charAt(0).toLowerCase() + pascalCase.slice(1);
};
var isFunction = (v) => typeof v === "function";
var isString = (v) => typeof v === "string";

// src/utils/message-utils.ts
var buildError = (diagnostics) => {
  const diagnostic = {
    level: "error",
    type: "build",
    header: "Build Error",
    messageText: "build error",
    relFilePath: void 0,
    absFilePath: void 0,
    lines: []
  };
  if (diagnostics) {
    diagnostics.push(diagnostic);
  }
  return diagnostic;
};
var catchError = (diagnostics, err2, msg) => {
  const diagnostic = {
    level: "error",
    type: "build",
    header: "Build Error",
    messageText: "build error",
    lines: []
  };
  if (isString(msg)) {
    diagnostic.messageText = msg.length ? msg : "UNKNOWN ERROR";
  } else if (err2 != null) {
    if (err2.stack != null) {
      diagnostic.messageText = err2.stack.toString();
    } else {
      if (err2.message != null) {
        diagnostic.messageText = err2.message.length ? err2.message : "UNKNOWN ERROR";
      } else {
        diagnostic.messageText = err2.toString();
      }
    }
  }
  if (diagnostics != null && !shouldIgnoreError(diagnostic.messageText)) {
    diagnostics.push(diagnostic);
  }
  return diagnostic;
};
var hasError = (diagnostics) => {
  if (diagnostics == null || diagnostics.length === 0) {
    return false;
  }
  return diagnostics.some((d) => d.level === "error" && d.type !== "runtime");
};
var shouldIgnoreError = (msg) => {
  return msg === TASK_CANCELED_MSG;
};
var TASK_CANCELED_MSG = `task canceled`;

// src/utils/path.ts
var normalizePath = (path, relativize = true) => {
  if (typeof path !== "string") {
    throw new Error(`invalid path to normalize`);
  }
  path = normalizeSlashes(path.trim());
  const components = pathComponents(path, getRootLength(path));
  const reducedComponents = reducePathComponents(components);
  const rootPart = reducedComponents[0];
  const secondPart = reducedComponents[1];
  const normalized = rootPart + reducedComponents.slice(1).join("/");
  if (normalized === "") {
    return ".";
  }
  if (rootPart === "" && secondPart && path.includes("/") && !secondPart.startsWith(".") && !secondPart.startsWith("@") && relativize) {
    return "./" + normalized;
  }
  return normalized;
};
var normalizeSlashes = (path) => path.replace(backslashRegExp, "/");
var altDirectorySeparator = "\\";
var urlSchemeSeparator = "://";
var backslashRegExp = /\\/g;
var reducePathComponents = (components) => {
  if (!Array.isArray(components) || components.length === 0) {
    return [];
  }
  const reduced = [components[0]];
  for (let i = 1; i < components.length; i++) {
    const component = components[i];
    if (!component) continue;
    if (component === ".") continue;
    if (component === "..") {
      if (reduced.length > 1) {
        if (reduced[reduced.length - 1] !== "..") {
          reduced.pop();
          continue;
        }
      } else if (reduced[0]) continue;
    }
    reduced.push(component);
  }
  return reduced;
};
var getRootLength = (path) => {
  const rootLength = getEncodedRootLength(path);
  return rootLength < 0 ? ~rootLength : rootLength;
};
var getEncodedRootLength = (path) => {
  if (!path) return 0;
  const ch0 = path.charCodeAt(0);
  if (ch0 === 47 /* slash */ || ch0 === 92 /* backslash */) {
    if (path.charCodeAt(1) !== ch0) return 1;
    const p1 = path.indexOf(ch0 === 47 /* slash */ ? "/" : altDirectorySeparator, 2);
    if (p1 < 0) return path.length;
    return p1 + 1;
  }
  if (isVolumeCharacter(ch0) && path.charCodeAt(1) === 58 /* colon */) {
    const ch2 = path.charCodeAt(2);
    if (ch2 === 47 /* slash */ || ch2 === 92 /* backslash */) return 3;
    if (path.length === 2) return 2;
  }
  const schemeEnd = path.indexOf(urlSchemeSeparator);
  if (schemeEnd !== -1) {
    const authorityStart = schemeEnd + urlSchemeSeparator.length;
    const authorityEnd = path.indexOf("/", authorityStart);
    if (authorityEnd !== -1) {
      const scheme = path.slice(0, schemeEnd);
      const authority = path.slice(authorityStart, authorityEnd);
      if (scheme === "file" && (authority === "" || authority === "localhost") && isVolumeCharacter(path.charCodeAt(authorityEnd + 1))) {
        const volumeSeparatorEnd = getFileUrlVolumeSeparatorEnd(path, authorityEnd + 2);
        if (volumeSeparatorEnd !== -1) {
          if (path.charCodeAt(volumeSeparatorEnd) === 47 /* slash */) {
            return ~(volumeSeparatorEnd + 1);
          }
          if (volumeSeparatorEnd === path.length) {
            return ~volumeSeparatorEnd;
          }
        }
      }
      return ~(authorityEnd + 1);
    }
    return ~path.length;
  }
  return 0;
};
var isVolumeCharacter = (charCode) => charCode >= 97 /* a */ && charCode <= 122 /* z */ || charCode >= 65 /* A */ && charCode <= 90 /* Z */;
var getFileUrlVolumeSeparatorEnd = (url, start) => {
  const ch0 = url.charCodeAt(start);
  if (ch0 === 58 /* colon */) return start + 1;
  if (ch0 === 37 /* percent */ && url.charCodeAt(start + 1) === 51 /* _3 */) {
    const ch2 = url.charCodeAt(start + 2);
    if (ch2 === 97 /* a */ || ch2 === 65 /* A */) return start + 3;
  }
  return -1;
};
var pathComponents = (path, rootLength) => {
  const root = path.substring(0, rootLength);
  const rest = path.substring(rootLength).split("/");
  const restLen = rest.length;
  if (restLen > 0 && !rest[restLen - 1]) {
    rest.pop();
  }
  return [root, ...rest];
};

// src/utils/output-target.ts
var isOutputTargetHydrate = (o) => o.type === DIST_HYDRATE_SCRIPT;
var isOutputTargetDocs = (o) => o.type === DOCS_README || o.type === DOCS_JSON || o.type === DOCS_CUSTOM || o.type === DOCS_VSCODE;

// src/utils/result.ts
var result_exports = {};
__export(result_exports, {
  err: () => err,
  map: () => map,
  ok: () => ok,
  unwrap: () => unwrap,
  unwrapErr: () => unwrapErr
});
var ok = (value) => ({
  isOk: true,
  isErr: false,
  value
});
var err = (value) => ({
  isOk: false,
  isErr: true,
  value
});
function map(result, fn) {
  if (result.isOk) {
    const val = fn(result.value);
    if (val instanceof Promise) {
      return val.then((newVal) => ok(newVal));
    } else {
      return ok(val);
    }
  }
  if (result.isErr) {
    const value = result.value;
    return err(value);
  }
  throw "should never get here";
}
var unwrap = (result) => {
  if (result.isOk) {
    return result.value;
  } else {
    throw result.value;
  }
};
var unwrapErr = (result) => {
  if (result.isErr) {
    return result.value;
  } else {
    throw result.value;
  }
};

// src/utils/util.ts
var readOnlyArrayHasStringMember = (readOnlyArray, maybeMember) => readOnlyArray.includes(maybeMember);

// src/utils/validation.ts
var validateComponentTag = (tag) => {
  if (typeof tag !== "string") {
    return `Tag "${tag}" must be a string type`;
  }
  if (tag !== tag.trim()) {
    return `Tag can not contain white spaces`;
  }
  if (tag !== tag.toLowerCase()) {
    return `Tag can not contain upper case characters`;
  }
  if (tag.length === 0) {
    return `Received empty tag value`;
  }
  if (tag.indexOf(" ") > -1) {
    return `"${tag}" tag cannot contain a space`;
  }
  if (tag.indexOf(",") > -1) {
    return `"${tag}" tag cannot be used for multiple tags`;
  }
  const invalidChars = tag.replace(/\w|-/g, "");
  if (invalidChars !== "") {
    return `"${tag}" tag contains invalid characters: ${invalidChars}`;
  }
  if (tag.indexOf("-") === -1) {
    return `"${tag}" tag must contain a dash (-) to work as a valid web component`;
  }
  if (tag.indexOf("--") > -1) {
    return `"${tag}" tag cannot contain multiple dashes (--) next to each other`;
  }
  if (tag.indexOf("-") === 0) {
    return `"${tag}" tag cannot start with a dash (-)`;
  }
  if (tag.lastIndexOf("-") === tag.length - 1) {
    return `"${tag}" tag cannot end with a dash (-)`;
  }
  return void 0;
};

// src/declarations/stencil-public-compiler.ts
var LOG_LEVELS = ["debug", "info", "warn", "error"];

// src/cli/parse-flags.ts
var parseFlags = (args) => {
  const flags = createConfigFlags();
  flags.args = Array.isArray(args) ? args.slice() : [];
  if (flags.args.length > 0 && flags.args[0] && !flags.args[0].startsWith("-")) {
    flags.task = flags.args[0];
    parseArgs(flags, args.slice(1));
  } else {
    parseArgs(flags, flags.args);
  }
  if (flags.task != null) {
    const i = flags.args.indexOf(flags.task);
    if (i > -1) {
      flags.args.splice(i, 1);
    }
  }
  return flags;
};
var parseArgs = (flags, args) => {
  const argsCopy = args.concat();
  while (argsCopy.length > 0) {
    parseCLITerm(flags, argsCopy);
  }
};
var parseCLITerm = (flags, args) => {
  const arg = args.shift();
  if (arg === void 0) return;
  const isNegatedBoolean = !readOnlyArrayHasStringMember(BOOLEAN_CLI_FLAGS, normalizeFlagName(arg)) && readOnlyArrayHasStringMember(BOOLEAN_CLI_FLAGS, normalizeNegativeFlagName(arg));
  const isNegatedBooleanOrString = !readOnlyArrayHasStringMember(BOOLEAN_STRING_CLI_FLAGS, normalizeFlagName(arg)) && readOnlyArrayHasStringMember(BOOLEAN_STRING_CLI_FLAGS, normalizeNegativeFlagName(arg));
  if (arg.startsWith("--") && arg.includes("=")) {
    const [originalArg, value] = parseEqualsArg(arg);
    setCLIArg(flags, arg.split("=")[0], normalizeFlagName(originalArg), value);
  } else if (arg.startsWith("-") && arg.includes("=")) {
    const [originalArg, value] = parseEqualsArg(arg);
    setCLIArg(flags, desugarRawAlias(originalArg), normalizeFlagName(originalArg), value);
  } else if (CLI_FLAG_REGEX.test(arg)) {
    setCLIArg(flags, desugarRawAlias(arg), normalizeFlagName(arg), parseCLIValue(args));
  } else if (arg.startsWith("--no-") && arg.length > "--no-".length) {
    const normalized = normalizeNegativeFlagName(arg);
    setCLIArg(flags, arg, normalized, "");
  } else if (arg.startsWith("--no") && (isNegatedBoolean || isNegatedBooleanOrString)) {
    setCLIArg(flags, arg, normalizeNegativeFlagName(arg), "");
  } else if (arg.startsWith("--") && arg.length > "--".length) {
    setCLIArg(flags, arg, normalizeFlagName(arg), parseCLIValue(args));
  } else {
    flags.unknownArgs.push(arg);
  }
};
var normalizeNegativeFlagName = (flagName) => {
  const trimmed = flagName.replace(/^--no[-]?/, "");
  return normalizeFlagName(trimmed.charAt(0).toLowerCase() + trimmed.slice(1));
};
var normalizeFlagName = (flagName) => {
  const trimmed = flagName.replace(/^-+/, "");
  return trimmed.includes("-") ? toCamelCase(trimmed) : trimmed;
};
var setCLIArg = (flags, rawArg, normalizedArg, value) => {
  normalizedArg = desugarAlias(normalizedArg);
  if (readOnlyArrayHasStringMember(BOOLEAN_CLI_FLAGS, normalizedArg)) {
    const parsed = typeof value === "string" ? (
      // check if the value is `'true'`
      value === "true"
    ) : (
      // no value was supplied, default to true
      true
    );
    flags[normalizedArg] = parsed;
    flags.knownArgs.push(rawArg);
    if (typeof value === "string" && value !== "") {
      flags.knownArgs.push(value);
    }
  } else if (readOnlyArrayHasStringMember(STRING_CLI_FLAGS, normalizedArg)) {
    if (typeof value === "string") {
      flags[normalizedArg] = value;
      flags.knownArgs.push(rawArg);
      flags.knownArgs.push(value);
    } else {
      throwCLIParsingError(rawArg, "expected a string argument but received nothing");
    }
  } else if (readOnlyArrayHasStringMember(STRING_ARRAY_CLI_FLAGS, normalizedArg)) {
    if (typeof value === "string") {
      if (!Array.isArray(flags[normalizedArg])) {
        flags[normalizedArg] = [];
      }
      const targetArray = flags[normalizedArg];
      if (Array.isArray(targetArray)) {
        targetArray.push(value);
        flags.knownArgs.push(rawArg);
        flags.knownArgs.push(value);
      }
    } else {
      throwCLIParsingError(rawArg, "expected a string argument but received nothing");
    }
  } else if (readOnlyArrayHasStringMember(NUMBER_CLI_FLAGS, normalizedArg)) {
    if (typeof value === "string") {
      const parsed = parseInt(value, 10);
      if (isNaN(parsed)) {
        throwNumberParsingError(rawArg, value);
      } else {
        flags[normalizedArg] = parsed;
        flags.knownArgs.push(rawArg);
        flags.knownArgs.push(value);
      }
    } else {
      throwCLIParsingError(rawArg, "expected a number argument but received nothing");
    }
  } else if (readOnlyArrayHasStringMember(STRING_NUMBER_CLI_FLAGS, normalizedArg)) {
    if (typeof value === "string") {
      if (CLI_ARG_STRING_REGEX.test(value)) {
        flags[normalizedArg] = value;
      } else {
        const parsed = Number(value);
        if (isNaN(parsed)) {
          throwNumberParsingError(rawArg, value);
        } else {
          flags[normalizedArg] = parsed;
        }
      }
      flags.knownArgs.push(rawArg);
      flags.knownArgs.push(value);
    } else {
      throwCLIParsingError(rawArg, "expected a string or a number but received nothing");
    }
  } else if (readOnlyArrayHasStringMember(BOOLEAN_STRING_CLI_FLAGS, normalizedArg)) {
    const derivedValue = typeof value === "string" ? value ? value : false : true;
    flags[normalizedArg] = derivedValue;
    flags.knownArgs.push(rawArg);
    if (typeof derivedValue === "string" && derivedValue) {
      flags.knownArgs.push(derivedValue);
    }
  } else if (readOnlyArrayHasStringMember(LOG_LEVEL_CLI_FLAGS, normalizedArg)) {
    if (typeof value === "string") {
      if (isLogLevel(value)) {
        flags[normalizedArg] = value;
        flags.knownArgs.push(rawArg);
        flags.knownArgs.push(value);
      } else {
        throwCLIParsingError(rawArg, `expected to receive a valid log level but received "${String(value)}"`);
      }
    } else {
      throwCLIParsingError(rawArg, "expected to receive a valid log level but received nothing");
    }
  } else {
    flags.unknownArgs.push(rawArg);
    if (typeof value === "string") {
      flags.unknownArgs.push(value);
    }
  }
};
var CLI_ARG_STRING_REGEX = /[^\d\.Ee\+\-]+/g;
var Empty = Symbol("Empty");
var parseCLIValue = (args) => {
  if (args[0] === void 0) {
    return Empty;
  }
  if (!args[0].startsWith("-")) {
    const value = args.shift();
    if (typeof value === "string") {
      return value;
    }
  }
  return Empty;
};
var parseEqualsArg = (arg) => {
  const [originalArg, ...splitSections] = arg.split("=");
  const value = splitSections.join("=");
  return [originalArg, value === "" ? Empty : value];
};
var isLogLevel = (maybeLogLevel) => readOnlyArrayHasStringMember(LOG_LEVELS, maybeLogLevel);
var throwCLIParsingError = (flag, message) => {
  throw new Error(`when parsing CLI flag "${flag}": ${message}`);
};
var throwNumberParsingError = (flag, value) => {
  throwCLIParsingError(flag, `expected a number but received "${value}"`);
};
var desugarAlias = (maybeAlias) => {
  const possiblyDesugared = CLI_FLAG_ALIASES[maybeAlias];
  if (typeof possiblyDesugared === "string") {
    return possiblyDesugared;
  }
  return maybeAlias;
};
var desugarRawAlias = (rawAlias) => "--" + desugarAlias(normalizeFlagName(rawAlias));

// src/cli/find-config.ts
var findConfig = async (opts) => {
  const sys = opts.sys;
  const cwd = sys.getCurrentDirectory();
  const rootDir = normalizePath(cwd);
  let configPath = opts.configPath;
  if (isString(configPath)) {
    if (!sys.platformPath.isAbsolute(configPath)) {
      configPath = normalizePath(sys.platformPath.join(cwd, configPath));
    } else {
      configPath = normalizePath(configPath);
    }
  } else {
    configPath = rootDir;
  }
  const results = {
    configPath,
    rootDir: normalizePath(cwd)
  };
  const stat = await sys.stat(configPath);
  if (stat.error) {
    const diagnostics = [];
    const diagnostic = buildError(diagnostics);
    diagnostic.absFilePath = configPath;
    diagnostic.header = `Invalid config path`;
    diagnostic.messageText = `Config path "${configPath}" not found`;
    return result_exports.err(diagnostics);
  }
  if (stat.isFile) {
    results.configPath = configPath;
    results.rootDir = sys.platformPath.dirname(configPath);
  } else if (stat.isDirectory) {
    for (const configName of ["stencil.config.ts", "stencil.config.js"]) {
      const testConfigFilePath = sys.platformPath.join(configPath, configName);
      const stat2 = await sys.stat(testConfigFilePath);
      if (stat2.isFile) {
        results.configPath = testConfigFilePath;
        results.rootDir = sys.platformPath.dirname(testConfigFilePath);
        break;
      }
    }
  }
  return result_exports.ok(results);
};

// src/cli/load-compiler.ts
var loadCoreCompiler = async (sys) => {
  return await sys.dynamicImport(sys.getCompilerExecutingPath());
};

// src/cli/logs.ts
var startupLog = (logger, task) => {
  if (task === "info" || task === "serve" || task === "version") {
    return;
  }
  logger.info(logger.cyan(`@stencil/core`));
};
var startupLogVersion = (logger, task, coreCompiler) => {
  if (task === "info" || task === "serve" || task === "version") {
    return;
  }
  const isDevBuild = coreCompiler.version.includes("-dev.");
  let startupMsg;
  if (isDevBuild) {
    startupMsg = logger.yellow(`[LOCAL DEV] v${coreCompiler.version}`);
  } else {
    startupMsg = logger.cyan(`v${coreCompiler.version}`);
  }
  startupMsg += logger.emoji(" " + coreCompiler.vermoji);
  logger.info(startupMsg);
};
var loadedCompilerLog = (sys, logger, flags, coreCompiler) => {
  const sysDetails = sys.details;
  const runtimeInfo = `${sys.name} ${sys.version}`;
  const platformInfo = sysDetails ? `${sysDetails.platform}, ${sysDetails.cpuModel}` : `Unknown Platform, Unknown CPU Model`;
  const statsInfo = sysDetails ? `cpus: ${sys.hardwareConcurrency}, freemem: ${Math.round(
    sysDetails.freemem() / 1e6
  )}MB, totalmem: ${Math.round(sysDetails.totalmem / 1e6)}MB` : "Unknown CPU Core Count, Unknown Memory";
  if (logger.getLevel() === "debug") {
    logger.debug(runtimeInfo);
    logger.debug(platformInfo);
    logger.debug(statsInfo);
    logger.debug(`compiler: ${sys.getCompilerExecutingPath()}`);
    logger.debug(`build: ${coreCompiler.buildId}`);
  } else if (flags.ci) {
    logger.info(runtimeInfo);
    logger.info(platformInfo);
    logger.info(statsInfo);
  }
};
var startupCompilerLog = (coreCompiler, config) => {
  if (config.suppressLogs === true) {
    return;
  }
  const { logger } = config;
  const isDebug = logger.getLevel() === "debug";
  const isPrerelease = coreCompiler.version.includes("-");
  const isDevBuild = coreCompiler.version.includes("-dev.");
  if (isPrerelease && !isDevBuild) {
    logger.warn(
      logger.yellow(
        `This is a prerelease build, undocumented changes might happen at any time. Technical support is not available for prereleases, but any assistance testing is appreciated.`
      )
    );
  }
  if (config.devMode && !isDebug) {
    if (config.buildEs5) {
      logger.warn(
        `Generating ES5 during development is a very task expensive, initial and incremental builds will be much slower. Drop the '--es5' flag and use a modern browser for development.`
      );
    }
    if (!config.enableCache) {
      logger.warn(`Disabling cache during development will slow down incremental builds.`);
    }
  }
};

// src/cli/check-version.ts
var startCheckVersion = async (config, currentVersion) => {
  if (config.devMode && !config.flags.ci && !currentVersion.includes("-dev.") && isFunction(config.sys.checkVersion)) {
    return config.sys.checkVersion(config.logger, currentVersion);
  }
  return null;
};
var printCheckVersionResults = async (versionChecker) => {
  if (versionChecker) {
    const checkVersionResults = await versionChecker;
    if (isFunction(checkVersionResults)) {
      checkVersionResults();
    }
  }
};

// src/cli/task-prerender.ts
var taskPrerender = async (coreCompiler, config) => {
  startupCompilerLog(coreCompiler, config);
  const hydrateAppFilePath = config.flags.unknownArgs[0];
  if (typeof hydrateAppFilePath !== "string") {
    config.logger.error(`Missing hydrate app script path`);
    return config.sys.exit(1);
  }
  const srcIndexHtmlPath = config.srcIndexHtml;
  const diagnostics = await runPrerenderTask(coreCompiler, config, hydrateAppFilePath, void 0, srcIndexHtmlPath);
  config.logger.printDiagnostics(diagnostics);
  if (diagnostics.some((d) => d.level === "error")) {
    return config.sys.exit(1);
  }
};
var runPrerenderTask = async (coreCompiler, config, hydrateAppFilePath, componentGraph, srcIndexHtmlPath) => {
  const diagnostics = [];
  try {
    const prerenderer = await coreCompiler.createPrerenderer(config);
    const results = await prerenderer.start({
      hydrateAppFilePath,
      componentGraph,
      srcIndexHtmlPath
    });
    diagnostics.push(...results.diagnostics);
  } catch (e) {
    catchError(diagnostics, e);
  }
  return diagnostics;
};

// src/cli/task-watch.ts
var taskWatch = async (coreCompiler, config) => {
  let devServer = null;
  let exitCode = 0;
  try {
    startupCompilerLog(coreCompiler, config);
    const versionChecker = startCheckVersion(config, coreCompiler.version);
    const compiler = await coreCompiler.createCompiler(config);
    const watcher = await compiler.createWatcher();
    if (!config.sys.getDevServerExecutingPath || !config.sys.dynamicImport || !config.sys.onProcessInterrupt) {
      throw new Error(
        `Environment doesn't provide required functions: getDevServerExecutingPath, dynamicImport, onProcessInterrupt`
      );
    }
    if (config.flags.serve) {
      const devServerPath = config.sys.getDevServerExecutingPath();
      const { start } = await config.sys.dynamicImport(devServerPath);
      devServer = await start(config.devServer, config.logger, watcher);
    }
    config.sys.onProcessInterrupt(() => {
      config.logger.debug(`close watch`);
      compiler && compiler.destroy();
    });
    const rmVersionCheckerLog = watcher.on("buildFinish", async () => {
      rmVersionCheckerLog();
      printCheckVersionResults(versionChecker);
    });
    if (devServer) {
      const rmDevServerLog = watcher.on("buildFinish", () => {
        var _a;
        rmDevServerLog();
        const url = (_a = devServer == null ? void 0 : devServer.browserUrl) != null ? _a : "UNKNOWN URL";
        config.logger.info(`${config.logger.cyan(url)}
`);
      });
    }
    const closeResults = await watcher.start();
    if (closeResults.exitCode > 0) {
      exitCode = closeResults.exitCode;
    }
  } catch (e) {
    exitCode = 1;
    config.logger.error(e);
  }
  if (devServer) {
    await devServer.close();
  }
  if (exitCode > 0) {
    return config.sys.exit(exitCode);
  }
};

// src/cli/telemetry/helpers.ts
var tryFn = async (fn, ...args) => {
  try {
    return await fn(...args);
  } catch {
  }
  return null;
};
var isInteractive = (sys, flags, object) => {
  const terminalInfo = object || Object.freeze({
    tty: sys.isTTY() ? true : false,
    ci: ["CI", "BUILD_ID", "BUILD_NUMBER", "BITBUCKET_COMMIT", "CODEBUILD_BUILD_ARN"].filter(
      (v) => {
        var _a;
        return !!((_a = sys.getEnvironmentVar) == null ? void 0 : _a.call(sys, v));
      }
    ).length > 0 || !!flags.ci
  });
  return terminalInfo.tty && !terminalInfo.ci;
};
var UUID_REGEX = new RegExp(/^[0-9A-F]{8}-[0-9A-F]{4}-4[0-9A-F]{3}-[89AB][0-9A-F]{3}-[0-9A-F]{12}$/i);
function uuidv4() {
  return "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g, (c) => {
    const r = Math.random() * 16 | 0;
    const v = c == "x" ? r : r & 3 | 8;
    return v.toString(16);
  });
}
async function readJson(sys, path) {
  const file = await sys.readFile(path);
  return !!file && JSON.parse(file);
}
function hasDebug(flags) {
  return !!flags.debug;
}
function hasVerbose(flags) {
  return !!flags.verbose && hasDebug(flags);
}

// src/cli/ionic-config.ts
var isTest = () => process.env.JEST_WORKER_ID !== void 0;
var defaultConfig = (sys) => sys.resolvePath(`${sys.homeDir()}/.ionic/${isTest() ? "tmp-config.json" : "config.json"}`);
var defaultConfigDirectory = (sys) => sys.resolvePath(`${sys.homeDir()}/.ionic`);
async function readConfig(sys) {
  let config = await readJson(sys, defaultConfig(sys));
  if (!config) {
    config = {
      "tokens.telemetry": uuidv4(),
      "telemetry.stencil": true
    };
    await writeConfig(sys, config);
  } else if (!config["tokens.telemetry"] || !UUID_REGEX.test(config["tokens.telemetry"])) {
    const newUuid = uuidv4();
    await writeConfig(sys, { ...config, "tokens.telemetry": newUuid });
    config["tokens.telemetry"] = newUuid;
  }
  return config;
}
async function writeConfig(sys, config) {
  let result = false;
  try {
    await sys.createDir(defaultConfigDirectory(sys), { recursive: true });
    await sys.writeFile(defaultConfig(sys), JSON.stringify(config, null, 2));
    result = true;
  } catch (error) {
    console.error(`Stencil Telemetry: couldn't write configuration file to ${defaultConfig(sys)} - ${error}.`);
  }
  return result;
}
async function updateConfig(sys, newOptions) {
  const config = await readConfig(sys);
  return await writeConfig(sys, Object.assign(config, newOptions));
}

// src/cli/telemetry/shouldTrack.ts
async function shouldTrack(config, sys, ci) {
  return !ci && isInteractive(sys, config.flags) && await checkTelemetry(sys);
}

// src/cli/telemetry/telemetry.ts
async function telemetryBuildFinishedAction(sys, config, coreCompiler, result) {
  const tracking = await shouldTrack(config, sys, !!config.flags.ci);
  if (!tracking) {
    return;
  }
  const component_count = result.componentGraph ? Object.keys(result.componentGraph).length : void 0;
  const data = await prepareData(coreCompiler, config, sys, result.duration, component_count);
  await sendMetric(sys, config, "stencil_cli_command", data);
  config.logger.debug(`${config.logger.blue("Telemetry")}: ${config.logger.gray(JSON.stringify(data))}`);
}
async function telemetryAction(sys, config, coreCompiler, action) {
  const tracking = await shouldTrack(config, sys, !!config.flags.ci);
  let duration = void 0;
  let error;
  if (action) {
    const start = /* @__PURE__ */ new Date();
    try {
      await action();
    } catch (e) {
      error = e;
    }
    const end = /* @__PURE__ */ new Date();
    duration = end.getTime() - start.getTime();
  }
  if (!tracking || config.flags.task == "build" && !config.flags.args.includes("--watch")) {
    return;
  }
  const data = await prepareData(coreCompiler, config, sys, duration);
  await sendMetric(sys, config, "stencil_cli_command", data);
  config.logger.debug(`${config.logger.blue("Telemetry")}: ${config.logger.gray(JSON.stringify(data))}`);
  if (error) {
    throw error;
  }
}
function hasAppTarget(config) {
  return config.outputTargets.some(
    (target) => target.type === WWW && (!!target.serviceWorker || !!target.baseUrl && target.baseUrl !== "/")
  );
}
function isUsingYarn(sys) {
  var _a, _b;
  return ((_b = (_a = sys.getEnvironmentVar) == null ? void 0 : _a.call(sys, "npm_execpath")) == null ? void 0 : _b.includes("yarn")) || false;
}
function getActiveTargets(config) {
  const result = config.outputTargets.map((t) => t.type);
  return Array.from(new Set(result));
}
var prepareData = async (coreCompiler, config, sys, duration_ms, component_count = void 0) => {
  var _a, _b, _c;
  const { typescript, rollup } = coreCompiler.versions || { typescript: "unknown", rollup: "unknown" };
  const { packages, packagesNoVersions } = await getInstalledPackages(sys, config);
  const targets = getActiveTargets(config);
  const yarn = isUsingYarn(sys);
  const stencil = coreCompiler.version || "unknown";
  const system = `${sys.name} ${sys.version}`;
  const os_name = (_a = sys.details) == null ? void 0 : _a.platform;
  const os_version = (_b = sys.details) == null ? void 0 : _b.release;
  const cpu_model = (_c = sys.details) == null ? void 0 : _c.cpuModel;
  const build = coreCompiler.buildId || "unknown";
  const has_app_pwa_config = hasAppTarget(config);
  const anonymizedConfig = anonymizeConfigForTelemetry(config);
  return {
    arguments: config.flags.args,
    build,
    component_count,
    config: anonymizedConfig,
    cpu_model,
    duration_ms,
    has_app_pwa_config,
    os_name,
    os_version,
    packages,
    packages_no_versions: packagesNoVersions,
    rollup,
    stencil,
    system,
    system_major: getMajorVersion(system),
    targets,
    task: config.flags.task,
    typescript,
    yarn
  };
};
var OUTPUT_TARGET_KEYS_TO_KEEP = ["type"];
var CONFIG_PROPS_TO_ANONYMIZE = [
  "rootDir",
  "fsNamespace",
  "packageJsonFilePath",
  "namespace",
  "srcDir",
  "srcIndexHtml",
  "buildLogFilePath",
  "cacheDir",
  "configPath",
  "tsconfig"
];
var CONFIG_PROPS_TO_DELETE = [
  "commonjs",
  "devServer",
  "env",
  "logger",
  "rollupConfig",
  "sys",
  "testing",
  "tsCompilerOptions"
];
var anonymizeConfigForTelemetry = (config) => {
  const anonymizedConfig = { ...config };
  for (const prop of CONFIG_PROPS_TO_ANONYMIZE) {
    if (anonymizedConfig[prop] !== void 0) {
      anonymizedConfig[prop] = "omitted";
    }
  }
  anonymizedConfig.outputTargets = config.outputTargets.map((target) => {
    const anonymizedOT = JSON.parse(
      JSON.stringify(target, (key, value) => {
        if (!(typeof value === "string")) {
          return value;
        }
        if (OUTPUT_TARGET_KEYS_TO_KEEP.includes(key)) {
          return value;
        }
        return "omitted";
      })
    );
    if (isOutputTargetHydrate(target) && target.external) {
      anonymizedOT["external"] = target.external.concat();
    }
    return anonymizedOT;
  });
  for (const prop of CONFIG_PROPS_TO_DELETE) {
    delete anonymizedConfig[prop];
  }
  return anonymizedConfig;
};
async function getInstalledPackages(sys, config) {
  let packages = [];
  let packagesNoVersions = [];
  const yarn = isUsingYarn(sys);
  try {
    const appRootDir = sys.getCurrentDirectory();
    const packageJson = await tryFn(
      readJson,
      sys,
      sys.resolvePath(appRootDir + "/package.json")
    );
    if (!packageJson) {
      return { packages, packagesNoVersions };
    }
    const rawPackages = Object.entries({
      ...packageJson.devDependencies,
      ...packageJson.dependencies
    });
    const ionicPackages = rawPackages.filter(
      ([k]) => k.startsWith("@stencil/") || k.startsWith("@ionic/") || k.startsWith("@capacitor/")
    );
    try {
      packages = yarn ? await yarnPackages(sys, ionicPackages) : await npmPackages(sys, ionicPackages);
    } catch (e) {
      packages = ionicPackages.map(([k, v]) => `${k}@${v.replace("^", "")}`);
    }
    packagesNoVersions = ionicPackages.map(([k]) => `${k}`);
    return { packages, packagesNoVersions };
  } catch (err2) {
    hasDebug(config.flags) && console.error(err2);
    return { packages, packagesNoVersions };
  }
}
async function npmPackages(sys, ionicPackages) {
  const appRootDir = sys.getCurrentDirectory();
  const packageLockJson = await tryFn(readJson, sys, sys.resolvePath(appRootDir + "/package-lock.json"));
  return ionicPackages.map(([k, v]) => {
    var _a, _b, _c, _d;
    let version = (_d = (_c = (_a = packageLockJson == null ? void 0 : packageLockJson.dependencies[k]) == null ? void 0 : _a.version) != null ? _c : (_b = packageLockJson == null ? void 0 : packageLockJson.devDependencies[k]) == null ? void 0 : _b.version) != null ? _d : v;
    version = version.includes("file:") ? sanitizeDeclaredVersion(v) : version;
    return `${k}@${version}`;
  });
}
async function yarnPackages(sys, ionicPackages) {
  var _a;
  const appRootDir = sys.getCurrentDirectory();
  const yarnLock = sys.readFileSync(sys.resolvePath(appRootDir + "/yarn.lock"));
  const yarnLockYml = (_a = sys.parseYarnLockFile) == null ? void 0 : _a.call(sys, yarnLock);
  return ionicPackages.map(([k, v]) => {
    var _a2;
    const identifiedVersion = `${k}@${v}`;
    let version = (_a2 = yarnLockYml == null ? void 0 : yarnLockYml.object[identifiedVersion]) == null ? void 0 : _a2.version;
    version = version && version.includes("undefined") ? sanitizeDeclaredVersion(identifiedVersion) : version;
    return `${k}@${version}`;
  });
}
function sanitizeDeclaredVersion(version) {
  return version.replace(/[*^~]/g, "");
}
async function sendMetric(sys, config, name, value) {
  const session_id = await getTelemetryToken(sys);
  const message = {
    name,
    timestamp: (/* @__PURE__ */ new Date()).toISOString(),
    source: "stencil_cli",
    value,
    session_id
  };
  await sendTelemetry(sys, config, message);
}
async function getTelemetryToken(sys) {
  const config = await readConfig(sys);
  if (config["tokens.telemetry"] === void 0) {
    config["tokens.telemetry"] = uuidv4();
    await writeConfig(sys, config);
  }
  return config["tokens.telemetry"];
}
async function sendTelemetry(sys, config, data) {
  try {
    const now = (/* @__PURE__ */ new Date()).toISOString();
    const body = {
      metrics: [data],
      sent_at: now
    };
    if (!sys.fetch) {
      throw new Error("No fetch implementation available");
    }
    const response = await sys.fetch("https://api.ionicjs.com/events/metrics", {
      method: "POST",
      headers: {
        "Content-Type": "application/json"
      },
      body: JSON.stringify(body)
    });
    hasVerbose(config.flags) && console.debug("\nSent %O metric to events service (status: %O)", data.name, response.status, "\n");
    if (response.status !== 204) {
      hasVerbose(config.flags) && console.debug("\nBad response from events service. Request body: %O", response.body.toString(), "\n");
    }
  } catch (e) {
    hasVerbose(config.flags) && console.debug("Telemetry request failed:", e);
  }
}
async function checkTelemetry(sys) {
  const config = await readConfig(sys);
  if (config["telemetry.stencil"] === void 0) {
    config["telemetry.stencil"] = true;
    await writeConfig(sys, config);
  }
  return config["telemetry.stencil"];
}
async function enableTelemetry(sys) {
  return await updateConfig(sys, { "telemetry.stencil": true });
}
async function disableTelemetry(sys) {
  return await updateConfig(sys, { "telemetry.stencil": false });
}
function getMajorVersion(version) {
  const parts = version.split(".");
  return parts[0];
}

// src/cli/task-build.ts
var taskBuild = async (coreCompiler, config) => {
  if (config.flags.watch) {
    await taskWatch(coreCompiler, config);
    return;
  }
  let exitCode = 0;
  try {
    startupCompilerLog(coreCompiler, config);
    const versionChecker = startCheckVersion(config, coreCompiler.version);
    const compiler = await coreCompiler.createCompiler(config);
    const results = await compiler.build();
    await telemetryBuildFinishedAction(config.sys, config, coreCompiler, results);
    await compiler.destroy();
    if (results.hasError) {
      exitCode = 1;
    } else if (config.flags.prerender) {
      const prerenderDiagnostics = await runPrerenderTask(
        coreCompiler,
        config,
        results.hydrateAppFilePath,
        results.componentGraph,
        void 0
      );
      config.logger.printDiagnostics(prerenderDiagnostics);
      if (prerenderDiagnostics.some((d) => d.level === "error")) {
        exitCode = 1;
      }
    }
    await printCheckVersionResults(versionChecker);
  } catch (e) {
    exitCode = 1;
    config.logger.error(e);
  }
  if (exitCode > 0) {
    return config.sys.exit(exitCode);
  }
};

// src/cli/task-docs.ts
var taskDocs = async (coreCompiler, config) => {
  config.devServer = {};
  config.outputTargets = config.outputTargets.filter(isOutputTargetDocs);
  config.devMode = true;
  startupCompilerLog(coreCompiler, config);
  const compiler = await coreCompiler.createCompiler(config);
  await compiler.build();
  await compiler.destroy();
};

// src/cli/task-generate.ts
import { join as join2, parse, relative } from "path";
var taskGenerate = async (config) => {
  if (!config.configPath) {
    config.logger.error("Please run this command in your root directory (i. e. the one containing stencil.config.ts).");
    return config.sys.exit(1);
  }
  const absoluteSrcDir = config.srcDir;
  if (!absoluteSrcDir) {
    config.logger.error(`Stencil's srcDir was not specified.`);
    return config.sys.exit(1);
  }
  const { prompt } = await Promise.resolve().then(() => __toESM(require_lib()));
  const input = config.flags.unknownArgs.find((arg) => !arg.startsWith("-")) || (await prompt({ name: "tagName", type: "text", message: "Component tag name (dash-case):" })).tagName;
  if (void 0 === input) {
    return;
  }
  const { dir, base: componentName } = parse(input);
  const tagError = validateComponentTag(componentName);
  if (tagError) {
    config.logger.error(tagError);
    return config.sys.exit(1);
  }
  let cssExtension = "css";
  if (!!config.plugins.find((plugin) => plugin.name === "sass")) {
    cssExtension = await chooseSassExtension();
  } else if (!!config.plugins.find((plugin) => plugin.name === "less")) {
    cssExtension = "less";
  }
  const filesToGenerateExt = await chooseFilesToGenerate(cssExtension);
  if (!filesToGenerateExt) {
    return;
  }
  const extensionsToGenerate = ["tsx", ...filesToGenerateExt];
  const testFolder = extensionsToGenerate.some(isTest2) ? "test" : "";
  const outDir = join2(absoluteSrcDir, "components", dir, componentName);
  await config.sys.createDir(normalizePath(join2(outDir, testFolder)), { recursive: true });
  const filesToGenerate = extensionsToGenerate.map((extension) => ({
    extension,
    path: getFilepathForFile(outDir, componentName, extension)
  }));
  await checkForOverwrite(filesToGenerate, config);
  const writtenFiles = await Promise.all(
    filesToGenerate.map(
      (file) => getBoilerplateAndWriteFile(
        config,
        componentName,
        extensionsToGenerate.includes("css") || extensionsToGenerate.includes("sass") || extensionsToGenerate.includes("scss") || extensionsToGenerate.includes("less"),
        file,
        cssExtension
      )
    )
  ).catch((error) => config.logger.error(error));
  if (!writtenFiles) {
    return config.sys.exit(1);
  }
  console.log();
  console.log(`${config.logger.gray("$")} stencil generate ${input}`);
  console.log();
  console.log(config.logger.bold("The following files have been generated:"));
  const absoluteRootDir = config.rootDir;
  writtenFiles.map((file) => console.log(`  - ${relative(absoluteRootDir, file)}`));
};
var chooseFilesToGenerate = async (cssExtension) => {
  const { prompt } = await Promise.resolve().then(() => __toESM(require_lib()));
  return (await prompt({
    name: "filesToGenerate",
    type: "multiselect",
    message: "Which additional files do you want to generate?",
    choices: [
      { value: cssExtension, title: `Stylesheet (.${cssExtension})`, selected: true },
      { value: "spec.tsx", title: "Spec Test  (.spec.tsx)", selected: true },
      { value: "e2e.ts", title: "E2E Test (.e2e.ts)", selected: true }
    ]
  })).filesToGenerate;
};
var chooseSassExtension = async () => {
  const { prompt } = await Promise.resolve().then(() => __toESM(require_lib()));
  return (await prompt({
    name: "sassFormat",
    type: "select",
    message: "Which Sass format would you like to use? (More info: https://sass-lang.com/documentation/syntax/#the-indented-syntax)",
    choices: [
      { value: "sass", title: `*.sass Format`, selected: true },
      { value: "scss", title: "*.scss Format" }
    ]
  })).sassFormat;
};
var getFilepathForFile = (filePath, componentName, extension) => isTest2(extension) ? normalizePath(join2(filePath, "test", `${componentName}.${extension}`)) : normalizePath(join2(filePath, `${componentName}.${extension}`));
var getBoilerplateAndWriteFile = async (config, componentName, withCss, file, styleExtension) => {
  const boilerplate = getBoilerplateByExtension(componentName, file.extension, withCss, styleExtension);
  await config.sys.writeFile(normalizePath(file.path), boilerplate);
  return file.path;
};
var checkForOverwrite = async (files, config) => {
  const alreadyPresent = [];
  await Promise.all(
    files.map(async ({ path }) => {
      if (await config.sys.readFile(path) !== void 0) {
        alreadyPresent.push(path);
      }
    })
  );
  if (alreadyPresent.length > 0) {
    config.logger.error(
      "Generating code would overwrite the following files:",
      ...alreadyPresent.map((path) => "	" + normalizePath(path))
    );
    await config.sys.exit(1);
  }
};
var isTest2 = (extension) => {
  return extension === "e2e.ts" || extension === "spec.tsx";
};
var getBoilerplateByExtension = (tagName, extension, withCss, styleExtension) => {
  switch (extension) {
    case "tsx":
      return getComponentBoilerplate(tagName, withCss, styleExtension);
    case "css":
    case "less":
    case "sass":
    case "scss":
      return getStyleUrlBoilerplate(styleExtension);
    case "spec.tsx":
      return getSpecTestBoilerplate(tagName);
    case "e2e.ts":
      return getE2eTestBoilerplate(tagName);
    default:
      throw new Error(`Unkown extension "${extension}".`);
  }
};
var getComponentBoilerplate = (tagName, hasStyle, styleExtension) => {
  const decorator = [`{`];
  decorator.push(`  tag: '${tagName}',`);
  if (hasStyle) {
    decorator.push(`  styleUrl: '${tagName}.${styleExtension}',`);
  }
  decorator.push(`  shadow: true,`);
  decorator.push(`}`);
  return `import { Component, Host, h } from '@stencil/core';

@Component(${decorator.join("\n")})
export class ${toPascalCase(tagName)} {
  render() {
    return (
      <Host>
        <slot></slot>
      </Host>
    );
  }
}
`;
};
var getStyleUrlBoilerplate = (ext) => ext === "sass" ? `:host
  display: block
` : `:host {
  display: block;
}
`;
var getSpecTestBoilerplate = (tagName) => `import { newSpecPage } from '@stencil/core/testing';
import { ${toPascalCase(tagName)} } from '../${tagName}';

describe('${tagName}', () => {
  it('renders', async () => {
    const page = await newSpecPage({
      components: [${toPascalCase(tagName)}],
      html: \`<${tagName}></${tagName}>\`,
    });
    expect(page.root).toEqualHtml(\`
      <${tagName}>
        <mock:shadow-root>
          <slot></slot>
        </mock:shadow-root>
      </${tagName}>
    \`);
  });
});
`;
var getE2eTestBoilerplate = (tagName) => `import { newE2EPage } from '@stencil/core/testing';

describe('${tagName}', () => {
  it('renders', async () => {
    const page = await newE2EPage();
    await page.setContent('<${tagName}></${tagName}>');

    const element = await page.find('${tagName}');
    expect(element).toHaveClass('hydrated');
  });
});
`;
var toPascalCase = (str) => str.split("-").reduce((res, part) => res + part[0].toUpperCase() + part.slice(1), "");

// src/cli/task-telemetry.ts
var taskTelemetry = async (flags, sys, logger) => {
  var _a;
  const prompt = logger.dim(((_a = sys.details) == null ? void 0 : _a.platform) === "windows" ? ">" : "$");
  const isEnabling = flags.args.includes("on");
  const isDisabling = flags.args.includes("off");
  const INFORMATION = `Opt in or out of telemetry. Information about the data we collect is available on our website: ${logger.bold(
    "https://stenciljs.com/telemetry"
  )}`;
  const THANK_YOU = `Thank you for helping to make Stencil better! \u{1F496}`;
  const ENABLED_MESSAGE = `${logger.green("Enabled")}. ${THANK_YOU}

`;
  const DISABLED_MESSAGE = `${logger.red("Disabled")}

`;
  const hasTelemetry = await checkTelemetry(sys);
  if (isEnabling) {
    const result = await enableTelemetry(sys);
    result ? console.log(`
  ${logger.bold("Telemetry is now ") + ENABLED_MESSAGE}`) : console.log(`Something went wrong when enabling Telemetry.`);
    return;
  }
  if (isDisabling) {
    const result = await disableTelemetry(sys);
    result ? console.log(`
  ${logger.bold("Telemetry is now ") + DISABLED_MESSAGE}`) : console.log(`Something went wrong when disabling Telemetry.`);
    return;
  }
  console.log(`  ${logger.bold("Telemetry:")} ${logger.dim(INFORMATION)}`);
  console.log(`
  ${logger.bold("Status")}: ${hasTelemetry ? ENABLED_MESSAGE : DISABLED_MESSAGE}`);
  console.log(`    ${prompt} ${logger.green("stencil telemetry [off|on]")}

        ${logger.cyan("off")} ${logger.dim(".............")} Disable sharing anonymous usage data
        ${logger.cyan("on")} ${logger.dim("..............")} Enable sharing anonymous usage data
  `);
};

// src/cli/task-help.ts
var taskHelp = async (flags, logger, sys) => {
  var _a;
  const prompt = logger.dim(((_a = sys.details) == null ? void 0 : _a.platform) === "windows" ? ">" : "$");
  console.log(`
  ${logger.bold("Build:")} ${logger.dim("Build components for development or production.")}

    ${prompt} ${logger.green("stencil build [--dev] [--watch] [--prerender] [--debug]")}

      ${logger.cyan("--dev")} ${logger.dim(".............")} Development build
      ${logger.cyan("--watch")} ${logger.dim("...........")} Rebuild when files update
      ${logger.cyan("--serve")} ${logger.dim("...........")} Start the dev-server
      ${logger.cyan("--prerender")} ${logger.dim(".......")} Prerender the application
      ${logger.cyan("--docs")} ${logger.dim("............")} Generate component readme.md docs
      ${logger.cyan("--config")} ${logger.dim("..........")} Set stencil config file
      ${logger.cyan("--stats")} ${logger.dim("...........")} Write stencil-stats.json file
      ${logger.cyan("--log")} ${logger.dim(".............")} Write stencil-build.log file
      ${logger.cyan("--debug")} ${logger.dim("...........")} Set the log level to debug


  ${logger.bold("Test:")} ${logger.dim("Run unit and end-to-end tests.")}

    ${prompt} ${logger.green("stencil test [--spec] [--e2e]")}

      ${logger.cyan("--spec")} ${logger.dim("............")} Run unit tests with Jest
      ${logger.cyan("--e2e")} ${logger.dim(".............")} Run e2e tests with Puppeteer


  ${logger.bold("Generate:")} ${logger.dim("Bootstrap components.")}

    ${prompt} ${logger.green("stencil generate")} or ${logger.green("stencil g")}

`);
  await taskTelemetry(flags, sys, logger);
  console.log(`
  ${logger.bold("Examples:")}

  ${prompt} ${logger.green("stencil build --dev --watch --serve")}
  ${prompt} ${logger.green("stencil build --prerender")}
  ${prompt} ${logger.green("stencil test --spec --e2e")}
  ${prompt} ${logger.green("stencil telemetry on")}
  ${prompt} ${logger.green("stencil generate")}
  ${prompt} ${logger.green("stencil g my-component")}
`);
};

// src/cli/task-info.ts
var taskInfo = (coreCompiler, sys, logger) => {
  const details = sys.details;
  const versions = coreCompiler.versions;
  console.log(``);
  console.log(`${logger.cyan("      System:")} ${sys.name} ${sys.version}`);
  if (details) {
    console.log(`${logger.cyan("    Platform:")} ${details.platform} (${details.release})`);
    console.log(
      `${logger.cyan("   CPU Model:")} ${details.cpuModel} (${sys.hardwareConcurrency} cpu${sys.hardwareConcurrency !== 1 ? "s" : ""})`
    );
  }
  console.log(`${logger.cyan("    Compiler:")} ${sys.getCompilerExecutingPath()}`);
  console.log(`${logger.cyan("       Build:")} ${coreCompiler.buildId}`);
  console.log(`${logger.cyan("     Stencil:")} ${coreCompiler.version}${logger.emoji(" " + coreCompiler.vermoji)}`);
  console.log(`${logger.cyan("  TypeScript:")} ${versions.typescript}`);
  console.log(`${logger.cyan("      Rollup:")} ${versions.rollup}`);
  console.log(`${logger.cyan("      Parse5:")} ${versions.parse5}`);
  console.log(`${logger.cyan("      jQuery:")} ${versions.jquery}`);
  console.log(`${logger.cyan("      Terser:")} ${versions.terser}`);
  console.log(``);
};

// src/cli/task-serve.ts
var taskServe = async (config) => {
  config.suppressLogs = true;
  config.flags.serve = true;
  config.devServer.openBrowser = !!config.flags.open;
  config.devServer.reloadStrategy = null;
  config.devServer.initialLoadUrl = "/";
  config.devServer.websocket = false;
  config.maxConcurrentWorkers = 1;
  config.devServer.root = isString(config.flags.root) ? config.flags.root : config.sys.getCurrentDirectory();
  if (!config.sys.getDevServerExecutingPath || !config.sys.dynamicImport || !config.sys.onProcessInterrupt) {
    throw new Error(
      `Environment doesn't provide required functions: getDevServerExecutingPath, dynamicImport, onProcessInterrupt`
    );
  }
  const devServerPath = config.sys.getDevServerExecutingPath();
  const { start } = await config.sys.dynamicImport(devServerPath);
  const devServer = await start(config.devServer, config.logger);
  console.log(`${config.logger.cyan("     Root:")} ${devServer.root}`);
  console.log(`${config.logger.cyan("  Address:")} ${devServer.address}`);
  console.log(`${config.logger.cyan("     Port:")} ${devServer.port}`);
  console.log(`${config.logger.cyan("   Server:")} ${devServer.browserUrl}`);
  console.log(``);
  config.sys.onProcessInterrupt(() => {
    if (devServer) {
      config.logger.debug(`dev server close: ${devServer.browserUrl}`);
      devServer.close();
    }
  });
};

// src/cli/task-test.ts
var taskTest = async (config) => {
  var _a;
  config.buildDocs = false;
  const testingRunOpts = {
    e2e: !!config.flags.e2e,
    screenshot: !!config.flags.screenshot,
    spec: !!config.flags.spec,
    updateScreenshot: !!config.flags.updateScreenshot
  };
  const ensureModuleIds = ["@types/jest", "jest", "jest-cli"];
  if (testingRunOpts.e2e) {
    const puppeteer = config.testing.browserExecutablePath ? "puppeteer-core" : "puppeteer";
    ensureModuleIds.push(puppeteer);
    if (testingRunOpts.screenshot) {
      config.logger.warn(
        config.logger.yellow(
          `EXPERIMENTAL: screenshot visual diff testing is currently under heavy development and has not reached a stable status. However, any assistance testing would be appreciated.`
        )
      );
    }
  }
  const diagnostics = await ((_a = config.sys.lazyRequire) == null ? void 0 : _a.ensure(config.rootDir, ensureModuleIds));
  if (diagnostics && diagnostics.length > 0) {
    config.logger.printDiagnostics(diagnostics);
    return config.sys.exit(1);
  }
  try {
    const { createTesting } = await import("../testing/index.js");
    const testing = await createTesting(config);
    const passed = await testing.run(testingRunOpts);
    await testing.destroy();
    if (!passed) {
      return config.sys.exit(1);
    }
  } catch (e) {
    config.logger.error(e);
    return config.sys.exit(1);
  }
};

// src/cli/run.ts
var run = async (init) => {
  const { args, logger, sys } = init;
  try {
    const flags = parseFlags(args);
    const task = flags.task;
    if (flags.debug || flags.verbose) {
      logger.setLevel("debug");
    }
    if (flags.ci) {
      logger.enableColors(false);
    }
    if (isFunction(sys.applyGlobalPatch)) {
      sys.applyGlobalPatch(sys.getCurrentDirectory());
    }
    if (task && task === "version" || flags.version) {
      const coreCompiler2 = await loadCoreCompiler(sys);
      console.log(coreCompiler2.version);
      return;
    }
    if (!task || task === "help" || flags.help) {
      await taskHelp(createConfigFlags({ task: "help", args }), logger, sys);
      return;
    }
    startupLog(logger, task);
    const findConfigResults = await findConfig({ sys, configPath: flags.config });
    if (findConfigResults.isErr) {
      logger.printDiagnostics(findConfigResults.value);
      return sys.exit(1);
    }
    const coreCompiler = await loadCoreCompiler(sys);
    startupLogVersion(logger, task, coreCompiler);
    loadedCompilerLog(sys, logger, flags, coreCompiler);
    if (task === "info") {
      taskInfo(coreCompiler, sys, logger);
      return;
    }
    const foundConfig = result_exports.unwrap(findConfigResults);
    const validated = await coreCompiler.loadConfig({
      config: {
        flags
      },
      configPath: foundConfig.configPath,
      logger,
      sys
    });
    if (validated.diagnostics.length > 0) {
      logger.printDiagnostics(validated.diagnostics);
      if (hasError(validated.diagnostics)) {
        return sys.exit(1);
      }
    }
    if (isFunction(sys.applyGlobalPatch)) {
      sys.applyGlobalPatch(validated.config.rootDir);
    }
    await telemetryAction(sys, validated.config, coreCompiler, async () => {
      await runTask(coreCompiler, validated.config, task, sys);
    });
  } catch (e) {
    if (!shouldIgnoreError(e)) {
      const details = `${logger.getLevel() === "debug" && e instanceof Error ? e.stack : ""}`;
      logger.error(`uncaught cli error: ${e}${details}`);
      return sys.exit(1);
    }
  }
};
var runTask = async (coreCompiler, config, task, sys) => {
  var _a;
  const flags = createConfigFlags((_a = config.flags) != null ? _a : { task });
  config.flags = flags;
  if (!config.sys) {
    config.sys = sys;
  }
  const strictConfig = coreCompiler.validateConfig(config, {}).config;
  switch (task) {
    case "build":
      await taskBuild(coreCompiler, strictConfig);
      break;
    case "docs":
      await taskDocs(coreCompiler, strictConfig);
      break;
    case "generate":
    case "g":
      await taskGenerate(strictConfig);
      break;
    case "help":
      await taskHelp(strictConfig.flags, strictConfig.logger, sys);
      break;
    case "prerender":
      await taskPrerender(coreCompiler, strictConfig);
      break;
    case "serve":
      await taskServe(strictConfig);
      break;
    case "telemetry":
      await taskTelemetry(strictConfig.flags, sys, strictConfig.logger);
      break;
    case "test":
      await taskTest(strictConfig);
      break;
    case "version":
      console.log(coreCompiler.version);
      break;
    default:
      strictConfig.logger.error(
        `${strictConfig.logger.emoji("\u274C ")}Invalid stencil command, please see the options below:`
      );
      await taskHelp(strictConfig.flags, strictConfig.logger, sys);
      return config.sys.exit(1);
  }
};
export {
  BOOLEAN_CLI_FLAGS,
  parseFlags,
  run,
  runTask
};
